#ifndef GALEON_WRAPPER_H
#define GALEON_WRAPPER_H

#ifndef __gen_nsIDOMEventTarget_h__
#include "nsIDOMEventTarget.h"
#endif

#ifndef __gen_nsIDOMDocument_h__
#include "nsIDOMDocument.h"
#endif

#ifndef __gen_nsIWebNavigation_h__
#include "nsIWebNavigation.h"
#endif

#ifndef __gen_nsISHistory_h__
#include "nsISHistory.h"
#endif

#ifndef __gen_nsIDocShell_h__
#include "nsIDocShell.h"
#endif

#ifndef nsIDOMMouseEvent_h__
#include "nsIDOMMouseEvent.h"
#endif

#ifndef nsIDOMEventListener_h__
#include "nsIDOMEventListener.h"
#endif

#ifndef nsIDOMDragListener_h__
#include "nsIDOMDragListener.h"
#endif

#ifndef __gen_nsIWebBrowser_h__
#include "nsIWebBrowser.h"
#endif

#ifndef nsITextServicesDocument_h__
#include "nsITextServicesDocument.h"
#endif

#ifndef __nsCOMPtr_h__
#include "nsCOMPtr.h"
#endif

#include "nsIDOMEventReceiver.h"
#include "nsIPrintOptions.h"

#ifdef CVS_SOURCE
#	include "nsICookieManager.h"
#	include	"nsICookie.h"
#	include "nsIPermissionManager.h"
#	include "nsIPermission.h"
#	include "nsIImgManager.h"
#	define COOKIEMANAGER_ID "@mozilla.org/cookiemanager;1"
#	define PERMISSIONMANAGER_ID "@mozilla.org/permissionmanager;1"
#	define IMAGEMANAGER_ID "@mozilla.org/imgmanager;1"
#	define CACHESERVICE_ID "@mozilla.org/network/cache-service;1"
#else
#	include "nsICookieViewer.h"
#	define COOKIEVIEWER_ID "@mozilla.org/cookieviewer/cookieviewer-world;1"
#endif

class GaleonEventListener;

class GaleonWrapper
{
public:
	GaleonWrapper();
	~GaleonWrapper();

	nsresult Init (GaleonEmbed *galeon_embed);
	nsresult Destroy (void);
	nsresult AddListener (void);
	nsresult RemoveListener (void);
	nsresult AddEventListener (void);
	nsresult RemoveEventListener (void);

	nsresult SetZoom (float aTextZoom);
	nsresult GetZoom (float *aTextZoom);

	nsresult SaveMainDocument (const char *filename);
	nsresult SaveDocument (const char *filename);

#if MOZILLA_MILESTONE != 81
	nsresult SaveURLFromCache (const char *url, 
				   const char *dir, const char *filename);
#endif
	nsresult SaveURI (const char *url, const char *filename);
#ifdef CVS_SOURCE
	nsresult Print (nsIPrintOptions *options);
#endif
	nsresult Find (const char *exp, PRBool matchcase, 
		       PRBool search_backwards, PRBool *didFind);

	nsresult GetDocumentUrl (char **url);

	nsresult GaleonWrapper::ReloadDocument ();

	nsresult GetSHInfo (PRInt32 *count, PRInt32 *index);
	nsresult GetSHTitleAtIndex (PRInt32 index, PRUnichar **title);

	nsresult GetEventContext (nsCOMPtr<nsIDOMEventTarget> EventTarget, WrapperContextInfo *info);
	nsresult GetKeyEventContext (nsIDOMKeyEvent *keyEvent, WrapperKeyEventInfo *info);
	nsresult GetMouseEventContext (nsIDOMMouseEvent *event, WrapperMouseEventInfo *info);
	nsresult ScrollbarClicked (nsIDOMMouseEvent *aMouseEvent);

	nsresult CopyHistoryTo (GaleonWrapper *embed);
#ifndef CVS_SOURCE
	nsresult SetViewSourceMode (PRInt32 mode);
#endif
	nsresult GoToHistoryIndex (PRInt16 index);

	nsresult SetSitePermission( PRBool permission, PRInt32 type );

	nsresult ForceCharacterSet (char *charset);

	nsresult GaleonWrapper::IsPageFramed (PRBool *Framed);
	
	nsresult GetFaviconURL (char **favicon_url);

	nsCOMPtr<nsIWebBrowser>           mWebBrowser;

#if MOZILLA_MILESTONE != 81
	nsCOMPtr<nsIDOMEventListener>     mEventListener;
#else
	GaleonEventListener *mEventListener;
#endif
#if MOZILLA_MILESTONE != 81
	nsCOMPtr<nsIWebNavigation>        mChromeNav;
#else
	nsCOMPtr<nsIDOMEventReceiver>  mEventReceiver;
#endif
	GtkMozEmbed *mGtkMozEmbed;
	GaleonEmbed *embed;
	PRBool attachListener;

private:
	nsresult GetDOMAttribute (nsIDOMNode *node, char *tag,
				  char **attribute);
	nsresult GetDOMDocument (nsIDOMDocument **aDOMDocument);
	nsresult GetMainDOMDocument (nsIDOMDocument **aDOMDocument);
	nsresult SaveDOMDocument (nsIDOMDocument *aDOMDocument, const char *filename);
	nsresult GetDocShell (nsIDocShell **aDocShell);
	nsresult GetSHistory (nsISHistory **aSHistory);
};

class GaleonEventListener : public nsIDOMDragListener
{
public:
	GaleonEventListener();
	virtual ~GaleonEventListener();

	void Init (GaleonWrapper *embed);
  
	NS_DECL_ISUPPORTS

	// nsIDOMEventListener
	
	NS_IMETHOD HandleEvent(nsIDOMEvent* aEvent);

	// nsIDOMDragListener

	NS_IMETHOD DragEnter(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragExit(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragDrop(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragGesture(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragOver(nsIDOMEvent* aMouseEvent);

private:
	GaleonWrapper *wrapper;
};

#endif
