/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Configuration includes
 */	
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/**
 * System includes
 */
#include <sys/stat.h>
#include <math.h>

/**
 * GNOME includes
 */
#include <gnome.h>
#include <gmodule.h>
#include <libgnorba/gnorba.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-mime.h>
#include <gnome-xml/xmlmemory.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <liboaf/liboaf.h>

/* yes, this does need to be explicit */
#include <libgnomeui/gnome-window-icon.h>

/*
 * FIXME: at the present time, the glade headers are not C++ clean for
 * recent versions of gcc, so this is a temporary hackaround 
 *   -- MattA 5/11/2000
 */
#ifndef __cplusplus
#include <glade/glade.h>
#else
/* minimal prototypes required */
typedef struct GladeXML;
GtkWidget *glade_xml_get_widget (GladeXML *self, const char *name);
#endif

/**
 * Mozilla includes
 */
#include <gtkmozembed.h>

/**
 * Galeon global includes 
 */
#include "galeon_types.h"
#include "file-operations.h"
#include "print.h"
#include "mozilla.h"
#include "Galeon.h"
#include "Gtm.h"

/*
 * Configuration strings and their defaults... 
 */
#define CONF_GENERAL_HOMEPAGE         "/galeon/General/startpage=www.gnome.org"
#define CONF_GENERAL_HOMEPAGE_TYPE    "/galeon/General/startpage_type=0"
#define CONF_GENERAL_FIRSTPAGE_TYPE   "/galeon/General/firstpage_type=0"
#define CONF_GENERAL_NEWPAGE_TYPE     "/galeon/General/newpage_type=0"
#define CONF_GENERAL_BOOKMARK_TITLE   "/galeon/General/bookmark_title=0"
#define CONF_GENERAL_LINKS_AUTOSHOW   "/galeon/General/links_autoshow=1"
#define CONF_GENERAL_AUTOSHOW_TIME    "/galeon/General/autoshow_time=2"
#define CONF_GENERAL_ALLOW_POPUPS     "/galeon/General/allow_popups=TRUE"
#define CONF_GENERAL_FAVICONS_ENABLED "/galeon/General/favicons_enabled=TRUE" 

#define CONF_COMPLETION_AUTOCOMP_ENABLE \
                                      "/galeon/completion/autocompletion=TRUE"
#define CONF_COMPLETION_SORT          "/galeon/completion/sorting_type=0"
	

#define CONF_APPEARANCE_WINWIDTH      "/galeon/Appearance/winwidth=640"
#define CONF_APPEARANCE_WINHEIGHT     "/galeon/Appearance/winheight=575"
#define CONF_APPEARANCE_WINDOWS_TITLE "/galeon/Appearance/windows_title=Galeon - %s"
#define CONF_APPEARANCE_USE_OWN_COLORS \
                                      "/galeon/Appearance/use_own_colors=FALSE"
#define CONF_APPEARANCE_USE_OWN_FONTS \
                                      "/galeon/Appearance/use_own_fonts=FALSE"
#define CONF_APPEARANCE_TABBED        "/galeon/Appearance/tabbed=FALSE"
#define CONF_APPEARANCE_TABBED_POPUPS "/galeon/Appearance/tabbed_popups=FALSE"
#define CONF_APPEARANCE_TABBED_AUTOJUMP \
                                      "/galeon/Appearance/tabbed_autojump=FALSE"
#define CONF_APPEARANCE_TABBED_INSERT_NEW_TABS \
                                      "/galeon/Appearance/tabbed_insert_new_tabs=FALSE"
#define CONF_APPEARANCE_TABBED_POSITION \
                                      "/galeon/Appearance/tabbed_position=2"
#define CONF_APPEARANCE_TABBED_ALWAYS_SHOW \
                                      "/galeon/Appearance/tabbed_always_show=FALSE"
#define CONF_APPEARANCE_TABBED_CLOSEBUTTON \
                                      "/galeon/Appearance/tabbed_closebutton=TRUE"
#define CONF_APPEARANCE_TABBED_PREFIX "/galeon/Appearance/tabbed_prefix=TRUE"
#define CONF_APPEARANCE_TABBED_SEPARATOR \
	                              "/galeon/Appearance/tabbed_separator=TRUE"
#define CONF_APPEARANCE_TABBED_VOWEL  "/galeon/Appearance/tabbed_vowel=FALSE"
#define CONF_APPEARANCE_NAUTILUS_ICONS \
                                      "/galeon/Appearance/nautilus_icons=FALSE"
#define CONF_APPEARANCE_TABBED_SHORTEN \
                                      "/galeon/Appearance/tabbed_shorten=30"
#define CONF_MIME                     "/galeon/mime/"
#define CONF_HANDLERS_MIME_ENABLE     "/galeon/handlers/mime_enable=FALSE"
#define CONF_ADVANCED_IMAGE_LOADING_TYPE \
                                      "/galeon/Advanced/image_loading_type=0"
#define CONF_ADVANCED_ANIMATE_TYPE    "/galeon/Advanced/animate_type=0"
#define CONF_ADVANCED_HISTORY_EXPIRE  "/galeon/Advanced/history_expire=100"
#define CONF_ADVANCED_STATUSBAR_REWRITE \
	                              "/galeon/Advanced/statusbar_rewrite=TRUE"
#define CONF_HANDLERS_USE_EXTERNAL_SOURCE_VIEWER \
                                       "/galeon/Handlers/use_external_source_viewer=FALSE"
#define CONF_HANDLERS_EXTERNAL_SOURCE_VIEWER \
                                       "/galeon/Handlers/external_source_viewer=gnome-edit"
#define CONF_HANDLER_VIEW_SOURCE_COLORS \
				       "/galeon/Handlers/enable_syntax_highlighting"
#define CONF_DOWNLOADING_FTP_PROGRAM   "/galeon/Downloading/ftp_program=0" /* use gtm */
#define CONF_DOWNLOADING_FTP_COMMAND   "/galeon/Downloading/ftp_command=darxget %s"
#define CONF_ADVANCED_JAVASCRIPT_ENABLED \
                                       "/galeon/Advanced/javascript_enabled=1"
#define CONF_ADVANCED_JAVA_ENABLED     "/galeon/Advanced/java_enabled=1" 
#define CONF_ADVANCED_PROXY_ENABLED    "/galeon/Advanced/proxy_enabled=FALSE"
#define CONF_AUTOBOOKMARKS_ENABLED     "/galeon/AutoBookmarks/enabled=TRUE" 
#define CONF_AUTOBOOKMARKS_COUNT       "/galeon/AutoBookmarks/count=15" 
#define CONF_AUTOBOOKMARKS_SHORTEN     "/galeon/AutoBookmarks/shorten=25" 
#define CONF_ADVANCED_COOKIES_BEHAVIOR "/galeon/Advanced/cookie_behavior=0"
#define CONF_ADVANCED_CRASH_BEHAVIOUR  "/galeon/Advanced/crash_behaviour=0"
#define CONF_DIR_OPEN "/galeon/Directories/open=~/"
#define CONF_MOUSE_LINKS_DRAG "/galeon/Mouse/links_drag=FALSE"

/* the virtual URL of "My Portal" feature */
#define MYPORTAL_URL       "about:myportal"
	
/* bookmark file locations - relative to home dir */
#define NETSCAPE_BOOKMARKS "/.netscape/bookmarks.html"
#define MOZILLA_PREFS_DIR  "/.mozilla/default/"
	
/* FIXME: ugh */
#define LANG_ENC_NUM 15

/**
 * Globals: FIXME!
 */
	
/* types of drag and drop for links */
/* FIXME: I doubt these are all needed */
extern const GtkTargetEntry link_drag_types[];
extern const gint link_drag_types_num_items;
extern const GtkTargetEntry url_drag_types[];
extern const gint url_drag_types_num_items;
extern const GtkTargetEntry drop_types[];
extern const gint drop_types_num_items;
extern GtkTargetList *link_drag_types_tl;

/** The history window */
extern GtkWidget *dHistory;
extern GtkCTree *clHistory;
extern GtkSortType history_sort_type;
extern gint history_sort_column;

/** the global list of MimeItems */
extern GList *mime_types; /* FIXME: can this be made local?  MattA */

/** The root of the bookmarks tree */
extern BookmarkItem *bookmarks_root;

/** The root of the temporary bookmark tree */
extern BookmarkItem *temp_bookmarks_root;

/** The AutoBookmarks folder */
extern BookmarkItem *autobookmarks_root;

/** The bookmarks editor */
extern BookmarksEditorControls *bookmarks_editor;

/** The preferences dialog */
extern GtkWidget *prefs;

/** The temp bookmarks window */
extern BookmarksEditorControls *temp_bookmarks_window;

/** The global list of all GaleonWindow structures */
extern GList *all_windows;

/** The global list of all GaleonEmbed structures */
extern GList *all_embeds;

/** Module with all the symbols of the program */
extern GModule *mod_self;

/** GConf client for looking up configuration data */
extern GConfClient *gconf_client;

/** Styles for coloured text */
extern GtkStyle *red_text_style;
extern GtkStyle *yellow_text_style;
extern GtkStyle *green_text_style;
extern GtkStyle *blue_text_style;

/* global character set hash and sorted title list*/
extern GHashTable *charsets;
extern GList *sorted_charset_titles;

/* are we in server mode? */
extern gboolean galeon_server_mode;

/* last save image directory */
extern gchar *image_save_dir;

/**
 * The standard pixmaps for bookmarks / sites
 */
extern PixmapData *folder_pixmap_data;
extern PixmapData *folder_open_pixmap_data;
extern PixmapData *site_pixmap_data;

/* FIXME */
extern const GtkTargetEntry bookmarks_dnd_targets[];
extern const gint bookmarks_dnd_targets_num_items;

/* FIXME */
extern const char *lgroups[];
extern const char *charset_trans_array[];

/*
 * Function prototypes. Together these form the entire internal
 * API of Galeon. Could do with being thinned out a LOT -- MattA
 */

/* embed.c */
GaleonEmbed *embed_create_default (GaleonEmbed *previous, gboolean new_window);
GaleonEmbed *embed_create_hidden (GaleonEmbed *previous, gboolean new_window);
GaleonEmbed *embed_create_from_url (GaleonEmbed *previous, const gchar *url,
				    gboolean new_window);
GaleonEmbed *embed_create_from_url_view_source (GaleonEmbed *previous,
						const gchar *url,
						gboolean new_window);
void embed_go_default (GaleonEmbed *previous_embed, GaleonEmbed *embed);
void embed_wrapper_init (GaleonEmbed *embed);
void embed_set_visibility (GaleonEmbed *embed, gboolean visibility);
void embed_load_url (GaleonEmbed *embed, const gchar *url);
void embed_progress_clear (GaleonEmbed *embed);
void embed_save_image (GaleonEmbed *embed, gchar *url);
void embed_save_image_default (GaleonEmbed *embed, gchar *url);
void embed_set_image_as_background (GaleonEmbed *embed, gchar *url);
void embed_save_document (GaleonEmbed *embed, gboolean main);
void embed_add_temporary_bookmark (GaleonEmbed *embed);
void embed_show_find_dialog (GaleonEmbed *embed);
void embed_view_source (GaleonEmbed *embed, gboolean main,
			gboolean new_window);
void embed_close (GaleonEmbed *embed);
void embed_open_frame (GaleonEmbed *embed, gboolean same_embed,
		       gboolean new_window);
void embed_reload (GaleonEmbed *embed);
void embed_update_page_location (GaleonEmbed *embed);
void embed_update_page_title (GaleonEmbed *embed);
void embed_set_notebook_label (GaleonEmbed *embed);
void embed_set_notebook_label_status (GaleonEmbed *embed, TabbedStatus status);
void embed_update_notebook_closebutton (GaleonEmbed *embed);
void embed_go_up (GaleonEmbed *embed, gint levels);
gboolean embed_can_go_up (GaleonEmbed *embed);

/* window.c */
GtkWidget *window_lookup_widget (GtkWidget *widget, const char *name);
GaleonWindow *window_create (void);
void window_set_fullscreen_mode (GaleonWindow *window, gboolean active);
void window_show_open_dialog (GaleonWindow *window);
void window_show_openurl_dialog (GaleonWindow *window);
void window_menubar_show (GaleonWindow *window);
void window_menubar_hide (GaleonWindow *window);
void window_toolbar_show (GaleonWindow *window);
void window_toolbar_hide (GaleonWindow *window);
void window_statusbar_show (GaleonWindow *window);
void window_statusbar_hide (GaleonWindow *window);
void window_close (GaleonWindow *window);
void window_load_url (GaleonWindow *window, const gchar *url);
void window_update_temp_message (GaleonWindow *window, const char *message);
void window_update_nav_buttons (GaleonWindow *window);
void window_update_status_bar (GaleonWindow *window);
void window_set_visibility (GaleonWindow *window, gboolean visible);
void window_show_error (GaleonWindow *window, char *errormsg);
void window_close (GaleonWindow *window);
void window_go_home (GaleonWindow *window, gboolean new_embed, 
		     gboolean new_window);
void window_set_layer (GtkWidget *widget);
void window_set_encoding_menu (GaleonWindow *window, GList *charset_titles);
void window_reload_all (GaleonWindow *window);

/* window_callbacks.c */
gboolean window_back_forward_button_press_cb (GtkButton *button,
					      GdkEventButton *event,
					      GaleonWindow *window);
gboolean window_new_button_press_cb (GtkButton *button, GdkEventButton *event,
				     GaleonWindow *window);
void window_new_button_drag_data_received_cb (GtkWidget *widget, 
					      GdkDragContext *drag_context,
					      gint x, gint y,
					      GtkSelectionData *selection_data,
					      guint info, guint time,
					      GaleonWindow *window);
void window_back_button_clicked_cb (GtkButton *button, GaleonWindow *window);
void window_up_button_clicked_cb (GtkButton *button, GaleonWindow *window);
gboolean window_up_button_press_event_cb (GtkButton *button, 
					  GdkEventButton *event,
					  GaleonWindow *window);
void window_forward_button_clicked_cb (GtkButton *button, 
				       GaleonWindow *window);
void window_refresh_button_clicked_cb (GtkButton *button, 
				       GaleonWindow *window);
gboolean window_refresh_button_press_event_cb (GtkButton *button,
					       GdkEventButton *event,
					       GaleonWindow *window);
gboolean window_start_button_press_event_cb (GtkButton *button,
					     GdkEventButton *event,
					     GaleonWindow *window);
void window_stop_button_clicked_cb (GtkButton *button, GaleonWindow *window);
void window_zoom_spin_changed_cb (GtkEditable *editable, GaleonWindow *window);
gboolean window_zoom_spin_key_press_cb (GtkWidget *widget, GdkEventKey *event,
					GaleonWindow *window);
void window_go_button_clicked_cb (GtkButton *button, GaleonWindow *window);
void window_drag_pixmap_drag_data_get_cb (GtkWidget *widget, 
					  GdkDragContext *context,
					  GtkSelectionData *selection_data, 
					  guint info, guint time, 
					  GaleonWindow *window);
void window_drag_data_get_cb (GtkWidget *widget, GdkDragContext *context,
			      GtkSelectionData *selection_data, 
			      guint info, guint time, 
			      GaleonWindow *window);
void window_selection_get_cb (GtkWidget *widget, 
			      GtkSelectionData *selection_data,
			      guint info, guint time_stamp, gpointer data);
void window_selection_received_cb (GtkWidget *widget, 
				   GtkSelectionData *selection_data,
				   guint time, GaleonWindow *window);
void open_url_ok_button_clicked_cb (gchar *string, GaleonWindow *window);
gboolean window_location_entry_key_press_cb (GtkWidget *widget, 
					     GdkEventKey *event,
					     GaleonWindow *window);
void window_location_entry_drag_data_received_cb (GtkWidget *widget, 
						  GdkDragContext *drag_context,
						  gint x, gint y,
						  GtkSelectionData *sel_data, 
						  guint info,
						  guint time, 
						  GaleonWindow *window);
void window_start_button_clicked_cb (GtkButton *button, GaleonWindow *window);
gboolean window_progress_action (GaleonWindow *window);
void window_location_gnomeentry_popwin_cb (GtkWidget *widget, 
					   GaleonWindow *window);

/* embed_callbacks.c */
void embed_drag_data_received (GtkWidget *widget, GdkDragContext *context,
			       gint x, gint y, 
			       GtkSelectionData *selection_data,
			       guint info, guint time, GaleonEmbed *embed);
void embed_notebook_switch_page_cb (GtkNotebook *notebook, 
				    GtkNotebookPage *page, guint page_num);
void embed_notebook_close_clicked_cb (GtkWidget *but, GaleonEmbed *embed);
void embed_tab_draw_cb (GtkWidget *widget, GdkRectangle *area,
			GaleonEmbed *embed);

/* misc_callbacks.c */
void mozembed_destroy_cb (GtkObject *object, GaleonEmbed *embed);
void window_spinner_button_clicked_cb(GtkButton *button, GaleonWindow *window);
void history_menu_menuitem_activate_cb (GtkMenuItem *menuitem, 
					gpointer user_data);
gboolean client_save_yourself_cb (GnomeClient *client, gint phase, 
				  GnomeSaveStyle save_style, gint shutdown,
				  GnomeInteractStyle interact_style,
				  gint fast);

/* history.c */
void history_show_dialog (GaleonWindow *window);
void history_hide_dialog (void);
void history_show_dock (GaleonWindow *window);
void history_hide_dock (void);
void history_load (void);
HistoryItem *history_visited (const gchar *url, const gchar *title);
void history_save (void);
gchar *history_get_last_url (void);
void history_add_recent_menu (HistoryItem *hi, GnomeApp *WMain);
void history_refresh_ctree (void);
void history_clear_recent_menu (void);

/* history_callbacks.c */
void window_menu_recent_activate_cb(GtkMenuItem *menuitem, gpointer user_data);
gint history_popup_selection_done_cb(GtkMenuShell *menushell,GtkWidget *popup);
void history_time_optionmenu_deactivate_cb (GtkWidget *menushell);

/* bookmarks.c */
#define BOOKMARKS_MENU_MAX_LENGTH 40 /** Max length of a bookmark menu item */
void bookmarks_load_icons (void);
BookmarkItem * bookmarks_new_bookmark (BookmarkType type, gboolean escape_name,
					const char *name, const char *url, 
					const char *nick, const char *notes, 
					const char *pixmap_file);
BookmarkItem *bookmarks_new_alias (BookmarkItem *b);
void bookmarks_update_alias (BookmarksEditorControls *c, BookmarkItem *b);
BookmarkItem *bookmarks_find_real_bookmark (BookmarkItem *b);
BookmarkItem *bookmarks_copy_bookmark (BookmarkItem *b);
void bookmarks_free_bookmark (BookmarkItem *b);
void bookmarks_load (void);
BookmarkItem *bookmarks_load_from (char *file);
void bookmarks_save (void);
void bookmarks_save_as (BookmarkItem *root, char *file);
void bookmarks_smart_bm_dialog (GaleonWindow *window, BookmarkItem *b,
				gboolean new_window);
gint bookmarks_move_bookmark (BookmarksEditorControls *controls,
			      BookmarkItem *b, int where);
void bookmarks_insert_bookmark (BookmarkItem *b, BookmarkItem *near,
				GtkCListDragPos insert_pos);
void bookmarks_remove_recursively (BookmarkItem *b);
void bookmarks_string_request_callback (gchar *string, BookmarkItem *new_item);
void bookmarks_create_menu (GaleonWindow *window);
void bookmarks_create_tb (GaleonWindow *window);
void bookmarks_update_menu (void);
void bookmarks_update_tb (void);
void bookmarks_tb_update_entries_global (void);
void bookmarks_create_menu_recursively (BookmarkItem *bookmark,
					GtkMenu *menu, 
					GtkMenuItem *file_menuitem,
					GtkTooltips *tooltips,
					gboolean special_items, 
					gboolean disable_tearoffs);
BookmarkItem *add_temp_bookmark (BookmarkType type, const gchar *name,
				 const gchar *url, BookmarkItem *parent);
void temp_bookmarks_init (void);
void temp_bookmarks_save (void);
GSList *bookmarks_list_all_urls(BookmarkItem *bookmark);
GSList *bookmarks_list_all_folders(BookmarkItem *bookmark);
gchar *bookmarks_parse_nick (gchar *text, BookmarkItem *root);
gchar *bookmarks_substitute_argument (BookmarkItem *b, const gchar *arguments);
void bookmarks_editor_place_tree_item (BookmarksEditorControls *controls,
				       BookmarkItem *b);
void bookmarks_editor_update_tree_item (BookmarksEditorControls *controls,
					BookmarkItem *b);
void bookmarks_editor_remove_tree_item (BookmarksEditorControls *controls,
					BookmarkItem *b);
void bookmarks_editor_goto_bookmark (BookmarkItem *b);
GtkMenu* bookmarks_create_copy_menu
			 (BookmarksEditorControls *destination_window, 
			  BookmarkItem *source);
void bookmarks_toolbar_set_visible (GaleonWindow *window, gboolean visible);
gchar *bookmarks_item_to_string (BookmarkItem *root);
BookmarkItem *bookmarks_item_from_string (char *string);
void bookmarks_editor_show_dialog (GaleonWindow *window,
				   BookmarksEditorControls_type type);
void bookmarks_editor_hide_dialog (BookmarksEditorControls *controls);
void bookmarks_editor_show_dock (GaleonWindow *window);
void bookmarks_editor_hide_dock (void);
void bookmarks_create_menu_global (void);
void bookmarks_create_tb_global (void);
void bookmarks_remove_menu_global (void);
void bookmarks_remove_tb_global (void);
void bookmarks_import_netscape_activate_cb (GtkMenuItem *menuitem,
					    GaleonWindow *window);
void bookmarks_import_mozilla_activate_cb (GtkMenuItem *menuitem,
					   GaleonWindow *window);
GList *bookmarks_get_selections_sorted (GtkCList *clist);
void bookmarks_create_toolbar_from_bm (GaleonWindow *window, GtkToolbar *tb,
				       BookmarkItem *b, gint insert_pos);
gboolean bookmarks_toolbar_item_button_release_event_cb
					(GtkWidget *item,
					 GdkEventButton *event,
					 BookmarkDragItem *bookmark_info);
gchar *bookmarks_translate_string (gchar *smart_bm_string);
void bookmarks_folder_open_all_items (GaleonEmbed *embed, BookmarkItem *bi,
				      gboolean new_window, gboolean reuse);
PixmapData *bookmarks_get_siteicon (const gchar *url);

/* bookmarks_callbacks.c */
gboolean bookmarks_button_release_event_cb (GtkWidget *widget, 
					    GdkEventButton *event,
					    BookmarkItem *bi);
void bookmarks_activate_cb (GtkWidget *widget, BookmarkItem *bi);
void bookmarks_menuitem_drag_data_received_cb (GtkWidget *widget, 
					       GdkDragContext *drag_context, 
					       gint x, gint y, 
					       GtkSelectionData *seldata,
					       guint info, guint time, 
					       GaleonWindow *window);
void bookmarks_file_bookmark_cb (GtkWidget *widget, BookmarkItem *parent);
void bookmarks_editor_bookmark_copy_cb (GtkMenuItem *menuitem,
					BookmarkItem *parent);
void bookmarks_nick_entry_activate (GtkEntry *entry, BookmarkItem *b);
void bookmarks_toolbar_drag_data_received_cb (GtkWidget *widget,
					      GdkDragContext *drag_context,
					      gint x, gint y,
					      GtkSelectionData *selection_data,
					      guint info, guint time,
					      BookmarkDragItem *drag_info);

/* netscape.c */
gint netscape_import_bookmarks (GString *filename);
gint netscape_export_bookmarks (gchar *filename, BookmarkItem *root);
gboolean netscape_import_prefs (void);

/* xbel */
gboolean xbel_export_bookmarks (const gchar *filename, BookmarkItem *root);

/* prefs.c */
void preferences_open (void);
void preferences_close (void);
void preferences_load (void);
void preferences_save (void);
void preferences_help (void);
void preferences_set_dialog_to_config (GtkWidget *widget);
void preferences_set_config_to_dialog (GtkWidget *widget);
void preferences_apply (void);
void set_settings_menu_window (GaleonWindow *window);
void preferences_set_use_own_colors (gboolean value);
void preferences_set_enable_javascript (gboolean value);
void preferences_set_enable_java (gboolean value);
void preferences_set_enable_proxy (gboolean value);
void preferences_set_use_own_fonts (gboolean value);
void preferences_set_image_loading (ImageLoadingType value);
void preferences_set_animate (AnimateType value);
void preferences_set_handlers_enable_mime (gboolean value);

/* mime.c */
void mime_add(gchar *name, gchar *program, gchar *extensions,
	      MimeAction action);
void mime_delete(MimeItem *m);
void mime_update(MimeItem *m, gchar *name, gchar *program, 
		 gchar *extensions, MimeAction action);
void mime_get_entry(gchar **name, gchar **program, gchar **extensions,
		    MimeAction *action);
MimeAction mime_get_action (const gchar *mime_type);
void mime_set_action (const gchar *mime_type, MimeAction action);
void mime_ask_action (const gchar *url, const gchar *mime_type, 
		      GaleonEmbed *embed);
MimeItem *mime_item_clone (MimeItem *m);
void mime_item_free (MimeItem *m);

/* mozcallbacks.c */
void mozembed_new_window_cb (GtkMozEmbed *dummy, GtkMozEmbed **retval,
			     guint chromemask, GaleonEmbed *embed);
void mozembed_visibility_cb (GtkMozEmbed *dummy, gboolean visibility,
			     GaleonEmbed *embed);
void mozembed_destroy_brsr_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void destroy_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_location_changed_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_title_changed_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_load_started_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_load_finished_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_progress_change_cb (GtkMozEmbed *dummy, gint cur, gint max,
				  GaleonEmbed *embed);
void mozembed_link_message_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_js_status_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
gint mozembed_open_uri_cb (GtkMozEmbed *dummy, const char *uri, 
			   GaleonEmbed *embed);
void mozembed_net_status_change_cb (GtkMozEmbed *dummy, gint flags,
				    guint status, GaleonEmbed *embed);
gint mozembed_dom_mouse_click_cb (GtkMozEmbed *dummy, gpointer dom_event, 
				  GaleonEmbed *embed);
gint mozembed_dom_mouse_down_cb (GtkMozEmbed *dummy, gpointer dom_event, 
				 GaleonEmbed *embed);
gint mozembed_dom_mouse_up_cb (GtkMozEmbed *dummy, gpointer dom_event, 
			       GaleonEmbed *embed);
gint mozembed_dom_mouse_over_cb (GtkMozEmbed *dummy, gpointer dom_event, 
				 GaleonEmbed *embed);
gint mozembed_dom_key_press_cb (GtkMozEmbed *dummy, gpointer dom_event, 
				GaleonEmbed *embed);
void mozembed_size_to_cb (GtkMozEmbed *dummy, gint width, gint height, 
			  GaleonEmbed *embed);
gboolean mozembed_drag_drop_cb (GtkWidget *widget, GdkDragContext *context, 
				gint x, gint y, 
				GtkSelectionData *selection_data, 
				guint info, guint time);

/* session.h */
void session_autosave(void);
gboolean session_autoresume(void);
void session_save(gchar *filename);

/* misc.c */
gboolean copy_file (const char *src, const char *dest);
void set_toolbar_style_window (GaleonWindow *window);
void set_toolbar_style_global (void);
void save_url (const gchar* url);
void save_url_with_gtm (const gchar* url);
void save_url_with_command_line (const gchar* url);
void ask_dir (const gchar *url);
gboolean handle_foreign_protocols (const char *url);
gboolean handle_foreign_mime_types (const char *url, GaleonEmbed *embed);
GtkWidget *glade_lookup_widget (GtkWidget *widget, const gchar *widget_name);
gchar *user_file (gchar *fname, gint critical);
GladeXML *glade_widget_new (const gchar *widget_name, 
			    GtkWidget **root, gpointer data);
int g_str_is_url (gchar * string);
void label_set_accel_text (gchar *text, GtkWidget *label, GtkWidget *menu,
			   GtkWidget *item);
gchar *strip_uline_accel (const gchar *text);
gchar *escape_uline_accel (const gchar *text);
GtkWidget *new_num_accel_label (int num, gchar *origtext, gboolean lettersok,
				GtkWidget *menu, GtkWidget *item);

#ifndef CVS_SOURCE
gchar *init_cache_dir (void);
#endif

GtkMenu *create_back_menu (GaleonEmbed *embed);
GtkMenu *create_forward_menu (GaleonEmbed *embed);
GtkMenu *create_up_menu (GaleonEmbed *embed);
void menu_position_under_widget(GtkMenu *menu, gint *x, gint *y,
				gpointer user_data);
gboolean require_external_handler (const char *uri);
gboolean process_mime (const char *uri);
void copy_to_clipboard (gchar *text, GaleonEmbed *embed);
void galeon_quit (GaleonWindow *window);
void galeon_quit_with_session (void);
void galeon_exit (void);
void remove_directory (const char *dirname, gboolean just_clean);
gchar *shorten_name (const gchar *name, gint target_length);
void initialise_colours (void);
gchar *read_line_from_file (FILE *f);
const gchar *g_strcasestr (const gchar *a, const gchar *b);
void create_charset_submenus (GtkMenuItem *encoding_menu_item, 
			GList *charset_titles, GaleonWindow *window);
gchar* get_mozilla_prefs_directory (); 
void launch_external_viewer (const gchar *filename);
xmlAttrPtr xmlSetPropISOLatin1 (xmlNodePtr node, 
				const xmlChar *name, 
				const xmlChar *value);
xmlChar *xmlGetPropISOLatin1 (xmlNodePtr node, const xmlChar *name);
void get_siteicon (GaleonEmbed *embed, gchar *url);
gchar *favicon_filename (gchar *favicon_url);
void misc_ask_file_name (const gchar *title, const gchar *label_title, const gchar *def, 
			 FileCallbackFunc callback_ok, FileCallbackFunc callback_cancel,
			 gboolean must_exist, gboolean warn_overwrite,
			 gpointer data);
gboolean misc_ask_question (const gchar *question, GtkWindow *parent);
PixmapData *pixmap_data_new_from_file (const gchar *file);
gchar *time_to_string (GTime t);

/* auto_completion.c */
void auto_completion_add_url (gchar *url);
void auto_completion_reset (void);
gchar *auto_completion_complete_url (gchar *prefix);
gchar *auto_completion_complete_url_extended (gchar *prefix);
void auto_completion_display (GaleonWindow *window, GtkWidget *entry);
void auto_completion_display_alternatives (GaleonWindow *window,
					   GtkWidget *entry);
void auto_completion_add_from_entry (GnomeEntry *e);

/* gtm.c */
gboolean gtm_add_url (const gchar *url, gchar *dir, gboolean disable_proxy,
		      gboolean disable_auto_dl);

/* spinner.c */
GtkWidget *spinner_create (GtkWidget *hbox);
void spinner_start (GaleonWindow *window);
void spinner_stop (GaleonWindow *window);
void spinner_fill_iconlist (GnomeIconList *icon_list);
gchar *spinner_get_path_from_index (int index);

/* toolbar.c */
void toolbar_create (GaleonWindow *window);
void toolbar_destroy (GaleonWindow *window);
void toolbar_recreate (GaleonWindow *window);
void toolbar_global_recreate (void);

/* portal.c */
void portal_render_into_embed (GaleonEmbed *embed);

/* mozilla_prefs.c */
void mozilla_prefs_set (void);
void mozilla_prefs_set_default_charset (void);
void mozilla_prefs_set_languages (void);

/* context.c */
void context_show_menu (GaleonEmbed *embed, WrapperContextInfo *info);
void context_show_bookmark_menu (GaleonEmbed *embed);

/* mozilla_prefs.c */
void mozilla_prefs_import_language (void);

/* autobookmarks.c */
void autobookmarks_generate (void);

/* cookies.c */
GtkWidget *cookies_show_manager (void);
GtkWidget *cookies_show_page (const CookiePage page);

/* menu_callbacks.c */
void window_menu_encoding_activate_cb (GtkMenuItem *menuitem,
				       GaleonWindow *window);
void window_menu_bookmark_activate_cb  (GtkMenuItem *menuitem, 
					gpointer user_data);

/* newuser.c */
gboolean newuser_check(void);

/* mozilla-i18n.c */
gint get_lgroups_count(void);
gint get_translated_cscount(void);

/* find.c */
gboolean find_next (GaleonEmbed *embed, const gchar *string);

#ifdef __cplusplus
}
#endif

