/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include "galeon.h"

/* local function prototypes */

gboolean history_clist_button_press_event_cb (GtkWidget *widget, 
					      GdkEventButton *event,
					      GaleonWindow *window);
gboolean history_dialog_delete_event_cb(GtkWidget *widget, GdkEvent *event, 
				  gpointer user_data);
void history_ok_button_clicked_cb(GtkButton *button, gpointer user_data);
void history_dock_ok_button_clicked_cb (GtkButton *button, gpointer user_data);
void history_entry_activate_cb (GtkEditable *editable);
void history_time_optionmenu_leave_cb (GtkOptionMenu *optionmenu);
void history_host_checkbutton_toggled_cb (GtkCheckButton *check_button);

extern gchar *search_text;
extern gboolean host_group;
extern gint search_time;

/**
 * Loads the selected row in the browser
 */
gboolean
history_clist_button_press_event_cb (GtkWidget *widget, GdkEventButton *event,
				     GaleonWindow *window)
{
        gint arow, acolumn;
	char *url;

	return_val_if_not_window (window, FALSE);

        gtk_clist_get_selection_info (GTK_CLIST(clHistory), 
				      event->x, event->y, 
				      &arow, &acolumn);
        if (event->button != 1) {
                gtk_clist_select_row (GTK_CLIST(clHistory), arow, acolumn);
        }

        if ((event->button == 2) || (event->type == GDK_2BUTTON_PRESS))
	{
		url = gtk_clist_get_row_data (GTK_CLIST(widget), arow);
		if (url)
		{
			window_load_url(window, url);
		}
        }
        return FALSE;
}

/**
 * Hides the window
 */
gboolean
history_dialog_delete_event_cb (GtkWidget *widget, GdkEvent *event,
				gpointer user_data)
{
	history_hide_dialog ();
        return TRUE;
}

/**
 * Hides the window
 */
void
history_ok_button_clicked_cb (GtkButton *button, gpointer user_data)
{
	history_hide_dialog ();
}

/**
 * Hides the dock
 */
void
history_dock_ok_button_clicked_cb (GtkButton *button, gpointer user_data)
{
	history_hide_dock ();
}

/* FIXME what does this ? please comment it */
gint history_popup_selection_done_cb (GtkMenuShell *menushell,GtkWidget *popup)
{
	gtk_menu_shell_deactivate (GTK_MENU_SHELL(popup));
	return FALSE;
}

/*
 * history_entry_activate_cb: search text is changed, update the tree
 */
void 
history_entry_activate_cb (GtkEditable *editable)
{
	search_text = gtk_entry_get_text (GTK_ENTRY(editable));

	history_refresh_ctree ();
}

/*
 * history_time_optionmenu_deactivate_cb: time option menu is changed
 * update the tree
 */
void
history_time_optionmenu_deactivate_cb (GtkWidget *menushell)
{
	gint item_index;
	GtkWidget *active_item;

	active_item = gtk_menu_get_active(GTK_MENU(menushell));
	item_index = g_list_index(GTK_MENU_SHELL(menushell)->children,
				  active_item);

	search_time = item_index;
	history_refresh_ctree ();
}

/*
 * history_host_checkbutton_toggled_cb: the host group checkbox status is
 * changed, update the tree
 */
void
history_host_checkbutton_toggled_cb (GtkCheckButton *check_button)
{
	host_group = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(check_button));
	gnome_config_set_bool ("/Galeon/history_group_by_host", host_group);
	history_refresh_ctree ();
}
