/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "menubar.h"

/**
 * window_menu_select_dir_activate_cb: show the download directory dialog (menu)
 */
void
window_menu_select_dir_activate_cb (GtkMenuItem *menuitem,
				    GaleonWindow *window)
{
	GtkWidget *dialog;
	char *olddir;
	GladeXML *gxml;

	return_if_not_window (window);

	gxml = glade_widget_new ("dirselection", &dialog, window);

	olddir = gnome_config_get_string("/galeon/Downloading/download_dir");

	gtk_file_selection_set_filename(GTK_FILE_SELECTION (dialog), olddir);
  
	gtk_widget_set_sensitive(GTK_WIDGET(GTK_FILE_SELECTION(
						dialog)->file_list), FALSE);
	gtk_widget_show(dialog);
	window_set_layer(dialog);
}

/**
 * window_menu_prefs_activate_cb: show preferences dialog
 */
void
window_menu_prefs_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	preferences_open ();
}

/**
 * window_menu_bookmarks_edit_activate_cb: show edit bookmarks dialog
 */
void
window_menu_bookmarks_edit_activate_cb (GtkMenuItem *menuitem,
				        GaleonWindow *window) 
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	bookmarks_editor_show_dialog (window, STANDARD_BOOKMARKS_EDITOR);
}

/**
 * window_menu_find_activate_cb: show find dialog
 */
void
window_menu_find_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	embed_show_find_dialog (window->active_embed);
}

/**
 * Goes to the url of the item
 */
void 
window_menu_recent_activate_cb (GtkMenuItem *menuitem, gpointer user_data)
{
        GtkWidget *WMain = window_lookup_widget (GTK_WIDGET(menuitem), "WMain");
        GaleonWindow *window = (GaleonWindow *) gtk_object_get_data
		(GTK_OBJECT (WMain), "GaleonWindow");
        HistoryItem *hi = gtk_object_get_user_data (GTK_OBJECT (menuitem));

	return_if_not_window (window);
	window_load_url(window, hi->url);
}

/**
 * window_spinner_button_clicked_cb: spinner clicked
 */
void
window_spinner_button_clicked_cb(GtkButton *button, GaleonWindow *window)
{
	return_if_not_window (window);
	/* FIXME: don't hardcode this */
	window_load_url (window, "http://galeon.sourceforge.net");
}

/**
 * window_menu_view_source_activate_cb: view source
 */
void
window_menu_view_source_activate_cb (GtkMenuItem *menuitem,
				     GaleonWindow *window)
{
	gboolean tabbed_mode;

	return_if_not_window (window);

	tabbed_mode = gnome_config_get_bool (CONF_APPEARANCE_TABBED);
	embed_view_source (window->active_embed, TRUE, !tabbed_mode);
}

/**
 * window_menu_history_activate_cb: show history dialog
 */
void window_menu_history_activate_cb (GtkMenuItem *menuitem,
				      GaleonWindow *window)
{
	return_if_not_window (window);
	history_show_dialog (window);
}

/**
 * window_menu_about_activate_cb: show about dialog 
 */
void
window_menu_about_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	static const char *author[] = {
		"Marco Pesenti Gritti <mpeseng@tin.it>",
		"Remco de Jong <rdj@rdj.cg.nu>",
		"Ricardo Fernandez Pascual <ric@users.sourceforge.net>",
		"Nate Case <nd@kracked.com>",
		"Bob Phan <ex-freek@yahoo.com>",
		"Matt Aubury <matt@ookypooky.com>",
		"Joshua Horvath <jmhorvat@home.com>",
		"Yanko Kaneti <yaneti@declera.com>",
		"","Graphic arts :", "Toussaint Frederic (fred@linuxgraphic.org)",
		NULL
	};

	static GtkWidget * about;

	return_if_not_window (window);

	if (!about)
	{
		about = gnome_about_new (_(PACKAGE), VERSION,
				 _("Copyright (C) 2000-2001 Marco Pesenti Gritti"),
				 author, _("A GNOME browser based on mozilla"),
				 SHARE_DIR"/logo.png");

		gtk_signal_connect (GTK_OBJECT (about), "destroy",
			    GTK_SIGNAL_FUNC(gtk_widget_destroyed), &about);
		gtk_widget_show (about);
	}

	window_set_layer (about);
}

/**
 * window_menu_manual_activate: show the main Galeon manual page
 */
void
window_menu_manual_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	gnome_help_goto (NULL, "ghelp:galeon");
}

/** 
 * window_menu_new_window_activate_cb: open a new window
 */
void
window_menu_new_window_activate_cb (GtkMenuItem *menuitem,
				    GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	embed_create_default (window->active_embed, TRUE);
}

/** 
 * window_menu_new_tab_activate_cb: open a new tab
 */
void
window_menu_new_tab_activate_cb (GtkMenuItem *menuitem,
				 GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	embed_create_default (window->active_embed, FALSE);
}

/** 
 * window_menu_open_activate_cb: show open file dialog
 */
void
window_menu_open_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	window_show_open_dialog (window);
}

/** 
 * on_new_window_activate: show open url dialog
*/
void
window_menu_open_url_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	window_show_openurl_dialog (window);
}

/** 
 * on_save_as1_actuvate: show save dialog
 */
void
window_menu_save_as_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	embed_save_document (window->active_embed, TRUE);
}

/** 
 * window_menu_exit_activate_cb: exit galeon
 */
void
window_menu_exit_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);

	/* We call the quit function indirectly, to make sure control returns
	   to the main loop first.  This is because we might have been
	   activated from within the mozembed_key_press callback, and if the
	   widget is destroyed before returning from the callback, very bad
	   things happen.  --Josh */
	gtk_timeout_add (50, (GtkFunction) galeon_quit, window);
}

/** 
 * window_menu_exit_with_session_activate_cb: exit galeon
 */
void
window_menu_exit_with_session_activate_cb (GtkMenuItem *menuitem, 
					   GaleonWindow *window)
{
	return_if_not_window (window);
	galeon_quit_with_session ();
}

/** 
 * window_menu_print_activate_cb: print document
 */
void
window_menu_print_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	print_show_dialog (window);
}


/** 
 * window_menu_close_activate_cb: close current active embed
 */
void
window_menu_close_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window) 
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	embed_close (window->active_embed);
}

/** 
 * window_menu_back_activate_cb: back menu activated
 */
void
window_menu_back_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	gtk_moz_embed_go_back (window->active_embed->mozEmbed);
}

/** 
 * window_menu_up_activate_cb: up menu activated
 */
void
window_menu_up_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	embed_go_up (window->active_embed, 0);
}

/** 
 * window_menu_forward_activate_cb: forward menu activated
 */
void
window_menu_forward_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	gtk_moz_embed_go_forward(window->active_embed->mozEmbed);
}

/** 
 * window_menu_prev_tab_activate_cb: previous tab activated
 */
void
window_menu_prev_tab_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	gtk_notebook_prev_page (GTK_NOTEBOOK (window->notebook));
}

/** 
 * window_menu_next_tab_activate_cb: next tab activated
 */
void
window_menu_next_tab_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	gtk_notebook_next_page (GTK_NOTEBOOK (window->notebook));
}

/** 
 * window_menu_stop_activate_cb: stop menu activated
 */
void
window_menu_stop_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	gtk_moz_embed_stop_load(window->active_embed->mozEmbed);
}

/** 
 * window_menu_reload_activate_cb: reload menu activated
 */
void
window_menu_reload_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	embed_reload (window->active_embed);
}

/** 
 * window_menu_start_page_activate_cb: start page menu activated
 */
void
window_menu_start_page_activate_cb (GtkMenuItem *menuitem,
				    GaleonWindow *window)
{
	return_if_not_window (window);
	/* FIXME: dont call this directly */
	window_start_button_clicked_cb (GTK_BUTTON (window->BStart), window);
}

/** 
 * window_menu_show_temp_bookmarks_activate_cb: show temp bookmarks window
 */
void
window_menu_show_temp_bookmarks_activate_cb (GtkMenuItem *menuitem,
					     GaleonWindow *window)
{
	return_if_not_window (window);
	bookmarks_editor_show_dialog (window, COMPACT_BOOKMARKS_EDITOR);
}

void
window_menu_add_temp_bookmark_activate_cb (GtkMenuItem *menuitem,
					   GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);
	embed_add_temporary_bookmark (window->active_embed);
}

/** 
 * window_menu_toolbar_activate_cb: hide/show the toolbar
 */
void window_menu_toolbar_activate_cb (GtkCheckMenuItem *menuitem,
				      GaleonWindow *window)
{
	return_if_not_window (window);
	if (menuitem->active) 
	{		
		window_toolbar_show (window);
	}
	else
	{
		window_toolbar_hide (window);
	}
}

/** 
 * window_menu_menubar_activate_cb: hide/show the menubar
 */
void window_menu_menubar_activate_cb (GtkCheckMenuItem *menuitem,
				      GaleonWindow *window)
{
	return_if_not_window (window);
	if (menuitem->active) 
	{
		window_menubar_show (window);
	}
	else
	{
		window_menubar_hide (window);
	}
}

/** 
 * window_menu_statusbar_activate_cb: hide/show the menubar
 */
void window_menu_statusbar_activate_cb (GtkCheckMenuItem *menuitem,
					GaleonWindow *window)
{
	return_if_not_window (window);
	if (menuitem->active) 
	{
		window_statusbar_show (window);
	}	
	else
	{
		window_statusbar_hide (window);
	}
}

/** 
 * window_menu_bookmarks_dock_activate_cb: hide/show the bookmarks dock
 */
void window_menu_bookmarks_dock_activate_cb (GtkCheckMenuItem *menuitem,
					     GaleonWindow *window)
{
	return_if_not_window (window);
	if (menuitem->active)
	{
		bookmarks_editor_show_dock (window);
	}
	else
	{
		bookmarks_editor_hide_dock ();
	}
}

/** 
 * window_menu_history_dock_activate_cb: hide/show the history dock
 */
void window_menu_history_dock_activate_cb (GtkCheckMenuItem *menuitem,
					   GaleonWindow *window)
{
	return_if_not_window (window);
	if (menuitem->active)
	{
		history_show_dock (window);
	}
	else
	{
		history_hide_dock ();
	}
}

/** 
 * window_menu_fullscreen_activate_cb: set fullscreen mode
 *
 */
void window_menu_fullscreen_activate_cb (GtkCheckMenuItem *menuitem,
					 GaleonWindow *window)
{
	return_if_not_window (window);
	window_set_fullscreen_mode (window, menuitem->active);
}

void
window_menu_own_colors_activate_cb (GtkCheckMenuItem *menuitem,
				    GaleonWindow *window)
{
	return_if_not_window (window);
	preferences_set_use_own_colors (menuitem->active);
}

void
window_menu_enable_javascript_activate_cb (GtkCheckMenuItem *menuitem,
					   GaleonWindow *window)
{
	return_if_not_window (window);
	preferences_set_enable_javascript (menuitem->active);
}

void
window_menu_enable_proxy_activate_cb (GtkCheckMenuItem *menuitem,
                                           GaleonWindow *window)
{
        return_if_not_window (window);
        preferences_set_enable_proxy (menuitem->active);
}


void
window_menu_own_fonts_activate_cb (GtkCheckMenuItem *menuitem,
				   GaleonWindow *window)
{
	return_if_not_window (window);
	preferences_set_use_own_fonts (menuitem->active);
}

void
window_menu_galeon_mime_handling_activate_cb (GtkCheckMenuItem *menuitem,
					      GaleonWindow *window)
{
	return_if_not_window (window);
	preferences_set_handlers_enable_mime (menuitem->active);
}

void
window_menu_enable_java_activate_cb (GtkCheckMenuItem *menuitem,
				     GaleonWindow *window)
{
	return_if_not_window (window);
	preferences_set_enable_java (menuitem->active);
}

void
window_menu_images_never_activate_cb (GtkCheckMenuItem *menuitem,
				      GaleonWindow *window)
{
	return_if_not_window (window);
	if (menuitem->active) 
	{
		preferences_set_image_loading (IMAGE_LOADING_NEVER);
	}
}

void
window_menu_images_current_server_activate_cb (GtkCheckMenuItem *menuitem,
					       GaleonWindow *window)
{
	return_if_not_window (window);
	if (menuitem->active) 
	{
		preferences_set_image_loading
			(IMAGE_LOADING_FROM_CURRENT_SERVER_ONLY);
	}
}

void
window_menu_images_always_activate_cb (GtkCheckMenuItem *menuitem,
				       GaleonWindow *window)
{
	return_if_not_window (window);
	if (menuitem->active) 
	{
		preferences_set_image_loading (IMAGE_LOADING_ALWAYS);
	}
}

void
window_block_images_from_activate_cb (GtkMenuItem *menuitem,
				      GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);

	mozilla_set_permission (window->active_embed, FALSE, IMAGEPERMISSION);
}

void
window_allow_images_from_activate_cb (GtkMenuItem *menuitem,
				      GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);

	mozilla_set_permission (window->active_embed, TRUE, IMAGEPERMISSION);
}

void
window_view_stored_sites_activate_cb (GtkMenuItem *menuItem,
				      GaleonWindow *window)
{
	return_if_not_window (window);
	cookies_show_page (IMAGESITES);
}

void
window_menu_animate_always_activate_cb (GtkCheckMenuItem *menuitem,
					GaleonWindow *window)
{
	return_if_not_window (window);
	if (menuitem->active) 
	{
		preferences_set_animate (ANIMATE_ALWAYS);
	}
}

void
window_menu_animate_once_through_activate_cb (GtkCheckMenuItem *menuitem,
					      GaleonWindow *window)
{
	return_if_not_window (window);
	if (menuitem->active) 
	{
		preferences_set_animate (ANIMATE_ONCE_THROUGH);
	}
}

void
window_menu_animate_never_activate_cb (GtkCheckMenuItem *menuitem,
				       GaleonWindow *window)
{
	return_if_not_window (window);
	if (menuitem->active) 
	{
		preferences_set_animate (ANIMATE_NEVER);
	}
}

void
window_cookie_manager_launch_cb (GtkMenuItem *menuitem,
				 GaleonWindow *window)
{
	return_if_not_window (window);
	cookies_show_manager();
}

void
window_block_cookies_from_activate_cb (GtkMenuItem *menuitem,
				       GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);

	mozilla_set_permission (window->active_embed, FALSE, COOKIEPERMISSION);
}

void
window_allow_cookies_from_activate_cb (GtkMenuItem *menuitem,
				       GaleonWindow *window)
{
	return_if_not_window (window);
	return_if_not_embed (window->active_embed);

	mozilla_set_permission (window->active_embed, TRUE, COOKIEPERMISSION);	
}

void
window_menu_zoom_in_activate_cb (GtkCheckMenuItem *menuitem,
				 GaleonWindow *window)
{
	return_if_not_window (window);
	gtk_spin_button_spin (GTK_SPIN_BUTTON (window->zoom_spin),
			      GTK_SPIN_STEP_FORWARD, 10); 
}

void
window_menu_zoom_out_activate_cb (GtkCheckMenuItem *menuitem,
				  GaleonWindow *window)
{
	return_if_not_window (window);
	gtk_spin_button_spin (GTK_SPIN_BUTTON (window->zoom_spin),
			      GTK_SPIN_STEP_BACKWARD, 10); 
}

void 
window_menu_encoding_activate_cb (GtkMenuItem *menuitem,
				  GaleonWindow *window)
{
	char *menulabel;

	return_if_not_window (window);
	return_if_not_embed (window->active_embed);

	gtk_label_get (GTK_LABEL(GTK_BIN(menuitem)->child), &menulabel);
	mozilla_force_character_set (window->active_embed,
				     g_hash_table_lookup (charsets,
							  menulabel));
	embed_reload (window->active_embed);
}

#ifdef CVS_SOURCE
void
window_view_passwords_activate_cb (GtkMenuItem *menuItem,
			           GaleonWindow *window)
{
	return_if_not_window (window);
	cookies_show_page (PASSWORDS);
}
void
window_view_password_sites_activate_cb (GtkMenuItem *menuItem,
				        GaleonWindow *window)
{
	return_if_not_window (window);
	cookies_show_page (PASSWORDSITES);
}
#endif
