/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "menubar.h"

/* The menubar GnomeUIInfo structs */ 
GnomeUIInfo file_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_New window"), NULL,
	  window_menu_new_window_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	  GDK_n, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("New _tab"), NULL,
	  window_menu_new_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	  GDK_b, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_MENU_OPEN_ITEM (window_menu_open_activate_cb, NULL),
	{ GNOME_APP_UI_ITEM, N_("Open _URL"), N_("Open a new URL"),
	  window_menu_open_url_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
	  GDK_o, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_MENU_SAVE_AS_ITEM (window_menu_save_as_activate_cb, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PRINT_ITEM (window_menu_print_activate_cb, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_CLOSE_ITEM (window_menu_close_activate_cb, NULL),
	{ GNOME_APP_UI_ITEM, N_("Exit with _session"),
	  N_("Exit the program, saving the location of each open window"),
	  window_menu_exit_with_session_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	GNOMEUIINFO_MENU_EXIT_ITEM (window_menu_exit_activate_cb, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo edit_menu_uiinfo[] =
{
	GNOMEUIINFO_MENU_FIND_ITEM (window_menu_find_activate_cb, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo view_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_View source..."), NULL,
	  window_menu_view_source_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_V, GDK_CONTROL_MASK | GDK_MOD1_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Menubar"), NULL,
	  window_menu_menubar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_M, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Toolbar"), NULL,
	  window_menu_toolbar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_T, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Statusbar"), NULL,
	  window_menu_statusbar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_U, GDK_CONTROL_MASK, NULL },
/* FIXME: dont forget to fix numbering too  (window.c)
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Bookmarks Dock"), NULL,
	  window_menu_bookmarks_dock_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_B, GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
*/
	{ GNOME_APP_UI_TOGGLEITEM, N_("_History Dock"), NULL,
	  window_menu_history_dock_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_H, GDK_CONTROL_MASK | GDK_SHIFT_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("_Full screen"), NULL,
	  window_menu_fullscreen_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_F11, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Zoom _in"), NULL,
	  window_menu_zoom_in_activate_cb, NULL, NULL,
 	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_plus, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Zoom _out"), NULL,
	  window_menu_zoom_out_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_minus, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Encoding"), NULL,
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo load_images_always_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Always"), NULL,
	  window_menu_images_always_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("From _current server only"), NULL,
	  window_menu_images_current_server_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Never"), NULL,
	  window_menu_images_never_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo load_images_menu_uiinfo[] =
{
	{ GNOME_APP_UI_RADIOITEMS, NULL, NULL, load_images_always_uiinfo,
	  NULL, NULL, 0, NULL, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("A_llow images from this site"), NULL,
	  window_allow_images_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Block images from this site"), NULL,
	  window_block_images_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_View stored sites..."), NULL,
	  window_view_stored_sites_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo animate_always_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Continuously"), NULL,
	  window_menu_animate_always_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Once"), NULL,
	  window_menu_animate_once_through_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Never"), NULL,
	  window_menu_animate_never_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo animate_images_menu_uiinfo[] =
{
	{ GNOME_APP_UI_RADIOITEMS, NULL, NULL, animate_always_uiinfo,
	  NULL, NULL, 0, NULL, 0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo cookies_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("Cookie _Manager..."), NULL,
	  window_cookie_manager_launch_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_Allow cookies from this site"), NULL,
	  window_allow_cookies_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Block cookies from this site"), NULL,
	  window_block_cookies_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

#ifdef CVS_SOURCE
GnomeUIInfo passwords_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("View _passwords..."), NULL,
	  window_view_passwords_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("View password _sites..."), NULL,
	  window_view_password_sites_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};
#endif

GnomeUIInfo settings_menu_uiinfo[] =
{
	{ GNOME_APP_UI_SUBTREE, N_("_Load images"),
	  N_("Display the images of the document"),
	  load_images_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("_Animate images"), NULL,
	  animate_images_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("_Cookies"), NULL,
	  cookies_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
#ifdef CVS_SOURCE
	{ GNOME_APP_UI_SUBTREE, N_("_Passwords"), NULL,
	  passwords_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
#endif  
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_TOGGLEITEM, N_("Use own _fonts"),
	  N_("Use own fonts instead of document provided fonts"),
	  window_menu_own_fonts_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Use own c_olors"),
	  N_("Use own colors instead of document provided colors"),
	  window_menu_own_colors_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Enable _Java"), NULL,
	  window_menu_enable_java_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Enable Java_Script"), NULL,
	  window_menu_enable_javascript_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
        { GNOME_APP_UI_TOGGLEITEM, N_("Enable pro_xy"), NULL,
          window_menu_enable_proxy_activate_cb, NULL, NULL,
          GNOME_APP_PIXMAP_NONE, NULL,
          0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Use Galeon _MIME handling"), NULL,
	  window_menu_galeon_mime_handling_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PREFERENCES_ITEM (window_menu_prefs_activate_cb, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo import_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("Import from _Netscape bookmarks"), NULL,
	  bookmarks_import_netscape_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Import from _Mozilla bookmarks"), NULL,
	  bookmarks_import_mozilla_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Import from _other location"), NULL,
	  bookmarks_import_other_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Export bookmarks in _XBEL"), NULL,
	  bookmarks_export_xbel_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Export to Net_scape bookmarks"), NULL,
	  bookmarks_export_netscape_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Export to Mo_zilla bookmarks"), NULL,
	  bookmarks_export_mozilla_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Export to o_ther location"), NULL,
	  bookmarks_export_other_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

GnomeUIInfo bookmarks_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Add bookmark to"), NULL,
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_INDEX,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Edit"), NULL,
	  window_menu_bookmarks_edit_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN,
	  GDK_E, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Add _temporary bookmark"), NULL,
	  window_menu_add_temp_bookmark_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_A, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Show temporary bookmarks"), NULL,
	  window_menu_show_temp_bookmarks_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_T, GDK_MOD1_MASK, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("_Import / Export"), NULL,
	  import_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CONVERT,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
};

GnomeUIInfo go_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Back"), NULL,
	  window_menu_back_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BACK,
	  GDK_Left, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Up"), NULL,
	  window_menu_up_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_UP,
	  GDK_Up, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Forward"), NULL,
	  window_menu_forward_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD,
	  GDK_Right, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Reload"), NULL,
	  window_menu_reload_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH,
	  GDK_r, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("H_ome page"), NULL,
	  window_menu_start_page_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
	  GDK_Home, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Stop"), NULL,
	  window_menu_stop_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_STOP,
	  GDK_Escape, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Pre_vious tab"), NULL,
	  window_menu_prev_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_UP,
	  GDK_comma, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Next ta_b"), NULL,
	  window_menu_next_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_DOWN,
	  GDK_period, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_History..."),
	  N_("Log of visited pages"),
	  window_menu_history_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_H, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
};
	
GnomeUIInfo help_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Galeon manual"), NULL,
	  window_menu_manual_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_MENU_ABOUT_ITEM (window_menu_about_activate_cb, NULL),
	GNOMEUIINFO_END
};

GnomeUIInfo menubar_uiinfo[] =
{
	GNOMEUIINFO_MENU_FILE_TREE (file_menu_uiinfo),
	GNOMEUIINFO_MENU_EDIT_TREE (edit_menu_uiinfo),
	GNOMEUIINFO_MENU_VIEW_TREE (view_menu_uiinfo),
	GNOMEUIINFO_MENU_SETTINGS_TREE (settings_menu_uiinfo),
	{ GNOME_APP_UI_SUBTREE, N_("B_ookmarks"), NULL,
	  bookmarks_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("_Go"), NULL,
	  go_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_MENU_HELP_TREE (help_menu_uiinfo),
	GNOMEUIINFO_END
};

GnomeUIInfo *all_menus[] =
{
	file_menu_uiinfo,
	edit_menu_uiinfo,
	view_menu_uiinfo,
	load_images_always_uiinfo,
	load_images_menu_uiinfo,
	animate_always_uiinfo,
	animate_images_menu_uiinfo,
	cookies_menu_uiinfo,
#ifdef CVS_SOURCE
	passwords_menu_uiinfo,
#endif
	settings_menu_uiinfo,
	bookmarks_menu_uiinfo,
	import_menu_uiinfo,
	go_menu_uiinfo,
	help_menu_uiinfo
};

gint menus_num_items[] =
{
	sizeof(file_menu_uiinfo)           / sizeof(GnomeUIInfo),
	sizeof(edit_menu_uiinfo)           / sizeof(GnomeUIInfo),
	sizeof(view_menu_uiinfo)           / sizeof(GnomeUIInfo),
	sizeof(load_images_always_uiinfo)  / sizeof(GnomeUIInfo),
	sizeof(load_images_menu_uiinfo)    / sizeof(GnomeUIInfo),
	sizeof(animate_always_uiinfo)      / sizeof(GnomeUIInfo),
	sizeof(animate_images_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(cookies_menu_uiinfo)        / sizeof(GnomeUIInfo),
#ifdef CVS_SOURCE
	sizeof(passwords_menu_uiinfo)	   / sizeof(GnomeUIInfo),
#endif
	sizeof(settings_menu_uiinfo)       / sizeof(GnomeUIInfo),
	sizeof(bookmarks_menu_uiinfo)      / sizeof(GnomeUIInfo),
	sizeof(import_menu_uiinfo)         / sizeof(GnomeUIInfo),
	sizeof(go_menu_uiinfo)             / sizeof(GnomeUIInfo),
	sizeof(help_menu_uiinfo)           / sizeof(GnomeUIInfo)
};

gint num_menus = sizeof(all_menus) / sizeof(GnomeUIInfo *);

