/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

typedef struct
{
	gchar *img; 
	gchar *link; 
	gboolean framed_page;
	gint context;
} WrapperContextInfo;

typedef struct
{
	WrapperContextInfo ctx;
	gulong key;
	gint modifier;
} WrapperKeyEventInfo;

typedef struct
{
	WrapperContextInfo ctx;
	gint button;
	gint modifier;
} WrapperMouseEventInfo;

typedef struct
{
	const gchar *search_string;
	gboolean backwards;
	gboolean wrap;
	gboolean entire_word;
	gboolean match_case;
} WrapperSearchProperties;


/* Preferences */
extern gboolean mozilla_preference_set (const char *preference_name,
					const char *new_value);
extern gboolean mozilla_preference_set_boolean (const char *preference_name,
						gboolean  new_boolean_value);
extern gboolean mozilla_preference_set_int (const char *preference_name,
					    int new_int_value);

/* PromptService initialization */
extern gboolean mozilla_init_promptService (void);

/* Wrapper initialization */
extern gpointer mozilla_wrapper_init (GaleonEmbed *embed,
				      gboolean attach_listener);
extern gboolean mozilla_wrapper_destroy (GaleonEmbed *embed);

/* Base functionalities */
extern gboolean mozilla_find (GaleonEmbed *embed,
			      WrapperSearchProperties *properties);
extern gboolean mozilla_save_image (GaleonEmbed *embed, const char *image, 
				    const char *file_name);
extern gboolean mozilla_save (GaleonEmbed *embed, const char *file_name);
extern gboolean mozilla_save_main_document (GaleonEmbed *embed,
					    const char *file_name);
extern gboolean mozilla_reload (GaleonEmbed *embed);
extern gboolean mozilla_print (GaleonEmbed *embed, PrintInfo *info);
extern gboolean mozilla_set_zoom (GaleonEmbed *embed, float f);
extern gboolean mozilla_get_zoom (GaleonEmbed *embed, float *f);
extern gboolean mozilla_session_history (GaleonEmbed *embed, char **titles[],
					 int *count, int *index);
extern gboolean mozilla_session_history_go (GaleonEmbed *embed, int index);
extern gchar* mozilla_get_document_url (GaleonEmbed *embed);
#ifndef CVS_SOURCE
	extern gboolean mozilla_view_source_mode (GaleonEmbed *embed,
						  gboolean view_source);
#endif
extern void mozilla_clear_cache (unsigned long cache);

/* Utils */
extern gboolean mozilla_get_key_event_info (GaleonEmbed *embed,
					    gpointer event,
					    WrapperKeyEventInfo *info);
extern gboolean mozilla_get_mouse_event_info (GaleonEmbed *embed,
					      gpointer event,
					      WrapperMouseEventInfo *info);

/* Charsets */
extern void mozilla_get_charsets (GHashTable **charsets,
				  GList **sorted_charset_titles);
extern void mozilla_force_character_set (GaleonEmbed *embed,
					 char *force_character_set);

/* Cookies manager */
#define COOKIEPERMISSION 0
#define IMAGEPERMISSION 1
extern void mozilla_block_url (const char *imgURL);
extern GList *mozilla_list_cookies (void);
extern void mozilla_set_permission (GaleonEmbed *embed, gboolean permit, 
				    int type);
extern GList *mozilla_get_permissions (int type);
#ifdef CVS_SOURCE
	extern gboolean mozilla_remove_cookies (GList *gone, gboolean block);
	extern gboolean mozilla_remove_permissions (GList *gone, int type);
#else
	extern gboolean mozilla_set_cookies (GList *gone_c, GList *gone_p,
					     GList *gone_i, gboolean block);
#endif

/* Password Manager */
#ifdef CVS_SOURCE
#define PASSWORDMANAGER_ID "@mozilla.org/passwordmanager;1"
extern GList *mozilla_list_passwords (PasswordType type);
extern gboolean mozilla_remove_passwords (GList *gone, PasswordType type);
#endif

/* Others */
#define UTF8_ENCODER_ID "@mozilla.org/intl/unicode/encoder;1?charset=UTF-8"  
#define UTF8_DECODER_ID "@mozilla.org/intl/unicode/decoder;1?charset=UTF-8"

extern gboolean mozilla_copy_session_history (GaleonEmbed *embed,
					      GaleonEmbed *dest);
extern gboolean mozilla_get_favicon_location (GaleonEmbed *embed, gchar **url);

#ifdef __cplusplus
#include <nscore.h>
extern gchar *mozilla_unicode_to_utf8 (const PRUnichar *uniStr);
extern gchar *mozilla_unicode_to_locale (const PRUnichar *uniStr);
extern PRUnichar *mozilla_utf8_to_unicode (const gchar *utfStr);
extern PRUnichar *mozilla_locale_to_unicode (const gchar *locStr);
#endif
