/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

/**
 * newuser_check: check if this is the first time the user
 * has run Galeon, and take the necessary steps if so
 */
gboolean
newuser_check (void)
{
	gchar *conf_dir, *netscape_dir, *favicons_dir;
	GtkWidget *import_netscape_preferences;
	GtkWidget *import_netscape_bookmarks;
	GtkWidget *import_mozilla_bookmarks;
	GtkWidget *import_no_bookmarks;
	GladeXML *gxml;

	/* check we're not a new user */
	if (gnome_config_get_int ("/galeon/General/new_user=1") == 0)
	{
		return FALSE;
	}

	/* never show again! */
	gnome_config_set_int ("/galeon/General/new_user", 0);

	/* check toplevel dir exists */
 	conf_dir = g_concat_dir_and_file (g_get_home_dir (), "/.galeon");
	if (!g_file_exists (conf_dir))
	{
		if (mkdir (conf_dir, 488) != 0)
		{
			g_error ("couldn't make `%s' directory", conf_dir);
		}
	}

	/* check favicons dir exists */
	favicons_dir = g_concat_dir_and_file (g_get_home_dir (), 
					      "/.galeon/favicons");
	if (!g_file_exists (favicons_dir))
	{
		if (mkdir (favicons_dir, 488) != 0)
		{
			g_error ("couldn't make %s' directory", favicons_dir);
		}
	}

	/* build the druid */
	gxml = glade_widget_new ("new_user_druid", NULL, NULL);

	/* lookup some widgets */
	import_netscape_bookmarks = 
		glade_xml_get_widget (gxml, ("new_user_druid_import_netscape_"
					     "bookmarks_radio_button"));
	import_mozilla_bookmarks = 
		glade_xml_get_widget (gxml, ("new_user_druid_import_mozilla_"
					     "bookmarks_radio_button"));
	import_no_bookmarks = 
		glade_xml_get_widget (gxml, ("new_user_druid_import_no_"
					     "bookmarks_radio_button"));
	import_netscape_preferences = 
		glade_xml_get_widget (gxml, ("new_user_druid_import_netscape_"
					     "preferences_check_button"));

	/* netscape directory would be... */
 	netscape_dir = g_concat_dir_and_file (g_get_home_dir(), "/.netscape");

	/* does it exist? */
	if (!(g_file_exists (netscape_dir)))
	{
		/* no, don't let us select netscape options then */
		gtk_widget_set_sensitive
			(GTK_WIDGET (import_netscape_bookmarks), FALSE);
		gtk_widget_set_sensitive
			(GTK_WIDGET (import_netscape_preferences), FALSE);
		gtk_toggle_button_set_active 
			(GTK_TOGGLE_BUTTON (import_mozilla_bookmarks), TRUE);
	}

	/* mozilla directory would be... */
 	netscape_dir = g_concat_dir_and_file (g_get_home_dir(), "/.mozilla");

	/* does it exist? */
	if (!(g_file_exists (netscape_dir)))
	{
		/* no, don't let us select mozilla options then */
		gtk_widget_set_sensitive
			(GTK_WIDGET (import_mozilla_bookmarks), FALSE);
		if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON (import_mozilla_bookmarks)))
		{
			gtk_toggle_button_set_active 
				(GTK_TOGGLE_BUTTON (import_no_bookmarks),TRUE);
		}
	}

	/* indicate to main() not to open an initial window */
	return TRUE;
}
