#!/usr/bin/perl
#############################################################################
##
#W  perlftp.pl       GAP share package 'atlasrep'               Frank L"ubeck
#W                                                            Max Neunh"offer
##
#H  @(#)$Id: perlftp.pl,v 1.7 2001/01/22 18:12:09 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This script must be called in one of the following two forms.
##     perl perlftp.pl <hostname> <dirname> <login> <password> ls
##  or
##     perl perlftp.pl <hostname> <dirname> <login> <password> get <filename>
##  In each case, <hostname> is the name of the remote server
##  (for example 'for.mat.bham.ac.uk'),
##  <dirname> is the directory on the remote server where the data in
##  question resides (for example 'v2.0/'),
##  <login> is the login name (for example 'atlasftp'),
##  and <password> is the corresponding password (for example 'atlasftp').
##
##  Called in the first form, 'perlftp.pl' prints the names of the files
##  contained in the remote directory.
##  Called in the second form, 'perlftp.pl' gets the file with name
##  <filename> from the remote directory.
##
use Net::FTP;

$host = shift;
$dir = shift;
$login = shift;
$password = shift;
$cmd = shift;
$name = shift;

$ftp = Net::FTP->new($host,TimeOut=>300);
$ftp->login($login,$password);
$ftp->cwd($dir);
if ( defined( $name ) ) {
  @list = $ftp->$cmd( $name )
}
else {
  @list = $ftp->$cmd()
}
$ftp->quit();

for $l (@list) {
  print $l,"\n";
}

#############################################################################
##
#E

