#############################################################################
##
#W  access.gd          GAP share package 'atlasrep'             Thomas Breuer
##
#H  @(#)$Id: access.gd,v 1.22 2001/02/27 17:15:33 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file contains functions for low level access to data from the
##  {\ATLAS} of Group Representations.
##
Revision.( "atlasrep/gap/access_gd" ) :=
    "@(#)$Id: access.gd,v 1.22 2001/02/27 17:15:33 gap Exp $";


#############################################################################
##
#V  InfoAtlasRep
##
##  If the info level of `InfoAtlasRep' is at least $1$ then information
##  about `fail' results of functions in the AtlasRep package is printed.
##  If the info level is at least $2$ then information about calls to
##  external programs is printed.
##  The default level is $0$, no information is printed on this level.
##
DeclareInfoClass( "InfoAtlasRep" );


#############################################################################
##
#v  AtlasOfGroupRepresentationsInfo
##
AUTO( ReadPkg, "atlasrep/gap/atlasprm.g",
      "AtlasOfGroupRepresentationsInfo" );


#############################################################################
##
##  Filenames Used in the Atlas of Group Representations
#1
##  The data of each local {\GAP} version of the {\ATLAS} of Group
##  Representations is stored in the two directories `datagens' and
##  `dataword'.
##  In the former directory, the generators for the representations available
##  are stored, the latter directory contains the straight line programs to
##  compute conjugacy class representatives,
##  \index{class representatives}
##  generators of maximal subgroups,
##  or images of generators under automorphisms
##  \index{automorphisms}
##  of a given group $G$ from standard generators of $G$
##  \index{maximal subgroups}
##  (see~"Standard Generators Used in the AtlasRep Package").
##
##  The name of each data file in the {\ATLAS} of Group Representations
##  describes the contents of the file.
##  This section lists the definitions of the filenames used.
##
##  Each filename consists of two parts, separated by a minus sign `-'.
##  The first part is always of the form `<groupname>G<i>', where the integer
##  <i> denotes the <i>-th set of standard generators for the group with
##  {\ATLAS}-file name <groupname>
##  (see~"Group Names Used in the AtlasRep Package").
##  The translations of the name <groupname> to the name(s) used within
##  {\GAP} is given by the list `AtlasOfGroupRepresentationsInfo.GAPnames'
##  (see~"AtlasOfGroupRepresentationsInfo").
##
##  The filenames in the directory `dataword' have one of the following
##  forms.
##  In each of these cases, the suffix `W<n>' means that <n> is the version
##  number of the straight line program.
##  \beginitems
##  `<groupname>G<i>-cycW<n>' &
##      In this case, the file contains a straight line program that returns
##      a list of representatives of generators
##      of maximally cyclic subgroups of $G$.
##      An example is `Co1G1-cycW1'.
##
##  `<groupname>G<i>-cclsW<n>' &
##      In this case, the file contains a straight line program that returns
##      a list of conjugacy class representatives of $G$.
##      An example is `RuG1-cclsW1'.
##
##  `<groupname>G<i>cycW<n>-cclsW<m>' &
##      In this case, the file contains a straight line program that takes
##      the return value of the program in the file `<groupname>G<i>-cycW<n>'
##      (see above),
##      and returns a list of conjugacy class representatives of $G$.
##      An example is `M11G1cycW1-cclsW1'.
##
##  `<groupname>G<i>-max<k>W<n>' &
##      In this case, the file contains the straight line program that takes
##      generators of $G$ w.r.t.~the <i>-th set of standard generators,
##      and returns a list of generators
##      (in general *not* standard generators)
##      for a subgroup $U$ in the <k>-th class of maximal subgroups of $G$.
##      An example is `J1G1-max7W1'.
##
##  `<groupname>G<i>max<k>W<n>-<subgroupname>G<j>W<m>' &
##      In this case, the file contains a straight line program that takes
##      the return value of the program in the file
##      `<groupname>G<i>-max<k>W<n>' (see above),
##      which are generators for a group $U$, say;
##      <subgroupname> is a name for $U$, and the return value are standard
##      generators for $U$, w.r.t.~the <j>-th set of standard generators.
##      (Of course this implies that the groups in the <k>-th class of
##      maximal subgroups of $G$ are isomorphic to the group with name
##      <subgroupname>.)
##      An example is `J1G1max1W1-L211G1W1'.
##      The first class of maximal subgroups of the Janko group $J_1$
##      consists of groups isomorphic to the linear group $L_2(11)$,
##      for which standard generators are defined.
##
##  `<groupname>G<i>-a<outname>W<n>' &
##      In this case, the file contains the straight line program that takes
##      generators of $G$ w.r.t.~the <i>-th set of standard generators,
##      and returns the list of their images
##      under the outer automorphism $\alpha$ of $G$ given by the name
##      <outname>;
##      if this name is empty then $\alpha$ is the unique nontrivial outer
##      automorphism of $G$;
##      if it is a positive integer $k$ then $\alpha$ is a generator of the
##      unique cyclic order $k$ subgroup of the outer automorphism group of
##      $G$;
##      if it is of the form $2_1$, $4_2$, $3_3$ $\ldots$ then $\alpha$
##      generates the cyclic group of automorphisms induced on $G$ by
##      $G\.2_1$, $G\.4_2$, $G\.3_3$ $\ldots$;
##      finally, if it is of the form `<k>p<d>', with <k> one of the above
##      forms and <d> an integer then <d> denotes the number of dashes
##      appended to the automorphism described by <k>;
##      if $<d> = 1$ then <d> can be omitted.
##      Examples are `A5G1-aW1', `L34G1-a2_1W1', `U43G1-a2_3pW1', and
##      `O8p3G1-a2_2p5W1';
##      these file names describe the outer order $2$ automorphism of $A_5$
##      (induced by the action of $S_5$) and the order $2$ automorphisms of
##      $L_3(4)$, $U_4(3)$, and $O_8^+(3)$ induced by the actions of
##      $L_3(4)\.2_1$, $U_4(3)\.2_2^{\prime}$,
##      and $O_8^+(3)\.2_2^{\prime\prime\prime\prime\prime}$, respectively.
##  \enditems
##
##  The filenames in the directory `datagens' have one of the following
##  forms.
##  In each of these cases,
##  <id> is a (possibly empty) string that starts with a non-digit character,
##  and <m> is a nonnegative integer, meaning that the generators are
##  written w.r.t.~the <m>-th basis (in a list defined by the {\ATLAS}
##  developers).
##  \beginitems
##  `<groupname>G<i>-Ar<dim><id>B<m>.g' &
##      a {\GAP} readable file
##      containing all generators of a matrix representation of dimension
##      <dim> over an algebraic number field not specified further.
##      An example is `A5G1-Ar3aB0.g'.
##
##  `<groupname>G<i>-Zr<dim><id>B<m>.g' &
##      a {\GAP} readable file
##      containing all generators of a matrix representation
##      over the integers, of dimension <dim>.
##      An example is `A5G1-Zr4B0.g'.
##
##  `<groupname>G<i>-Z<n>r<dim><id>B<m>.g' &
##      a {\GAP} readable file
##      containing all generators of a matrix representation of dimension
##      <dim> over the ring of integers mod <n>.
##      An example is `2A8G1-Z4r4aB0.g'.
##
##  `<groupname>G<i>-f<q>r<dim><id>B<m>.m<nr>' &
##      a file in {\MeatAxe} textfile format
##      containing the <nr>-th generator of a matrix representation
##      over the field with <q> elements, of dimension <dim>.
##      An example is `S5G1-f2r4aB0.m1'.
##
##  `<groupname>G<i>-p<n><id>B<m>.m<nr>' &
##      a file in {\MeatAxe} textfile format
##      containing the <nr>-th generator of a permutation representation
##      on <n> points.
##      An example is `M11G1-p11B0.m1'.
##  \enditems
##


#############################################################################
##
#F  FilenameAtlas( <dirname>, <groupname>, <filename> )
##
##  Let <dirname>, <groupname>, and <filename> be strings,
##  where <dirname> is one of `\"datagens\"', `\"dataword\"'.
##  If <groupname> is the {\ATLAS}-file name of a group $G$
##  (see~"Group Names Used in the AtlasRep Package"),
##  and <filename> is the name of an accessible file in the <dirname>
##  directory of the {\ATLAS}, with data concerning $G$,
##  then `FilenameAtlas' returns the corresponding filename
##  (see~"ref:Filename" in the {\GAP} Reference Manual),
##  otherwise `fail' is returned.
##
##  A file is regarded as accessible either if it is already stored in the
##  <dirname> directory of the local installation or if the `remote'
##  component of the record `AtlasOfGroupRepresentationsInfo' has value
##  `true' (see~"AtlasOfGroupRepresentationsInfo") and the required file
##  is found on one of the relevant servers;
##  in the latter case, the file is transferred to the local directory
##  before `FilenameAtlas' returns the filename,
##  such that afterwards the file can be read into {\GAP} using `Read'
##  (see~"ref:Read" in the {\GAP} Reference Manual).
##
##  Note that `FilenameAtlas' does *not* check whether the table of contents
##  of the {\ATLAS} of Group Representations actually contains <filename>.
##
DeclareGlobalFunction( "FilenameAtlas" );


#############################################################################
##
##  The Tables Of Contents of the Atlas of Group Representations
#2
##  The list of data currently available is stored in two tables of contents,
##  one for the local {\GAP} installation, one for the remote servers.
##  They are created and accessed automatically when
##  `ReloadAtlasTableOfContents' (see~"ReloadAtlasTableOfContents")
##  is called.
##
##  The low level functions used by `ReloadAtlasTableOfContents' are
##  `AtlasTableOfContents',
##  which actually fetches and composes the necessary information,
##  and `StringOfAtlasTableOfContents',
##  which translates the filenames into calls of `AGRGRP' and `AGRTOC'
##  and creates a string that can be printed to a file.
##  These functions and the utilities for them can be found in the files
##  `access.gd' and `access.gi' in the `gap' directory of the package.
##
##  Note that it is assumed that the local data directories contain only
##  files that are also available on servers.
##  Private extensions to the database (cf.~"Extending the Atlas Database")
##  cannot be handled by putting the data files into the local directories.
##


#############################################################################
##
#F  DirectoryTree( <string> )
##
##  Assumed that <string> is a string obtained as the output of a `ls -R'
##  call,
##  `DirectoryTree' returns a record containing for each plain file with name
##  <name> in the directory the component <name> with value an empty record,
##  and for each subdirectory with name <dir> a component <dir> with value a
##  record describing the contents of this subdirectory in the same way.
##
DeclareGlobalFunction( "DirectoryTree" );


#############################################################################
##
#F  AtlasFilesFromDirectoryTree( <tree> )
##
##  Let <tree> be a record as returned by `DirectoryTree' when this was
##  applied to the directory <path> of a server given by the pair
##  `[ <servername>, <path> ]' (see~"AtlasOfGroupRepresentationsInfo").
##
##  `AtlasFilesFromDirectoryTree' checks whether the names of the directories
##  containing the data files are notified correctly,
##  and whether new such directories have appeared that are not yet notified.
##  The return value is a list of triples of the form
##  `[ <dir>, <simp>, <file> ]'.
##  If an error happened then `fail' is returned.
##
##  Note that this function does *not* work for local installations of the
##  package
##  (see~"Local or Remote Installation of the AtlasRep Share Package").
##
DeclareGlobalFunction( "AtlasFilesFromDirectoryTree" );


#############################################################################
##
#F  GroupNamesOfAtlasOfGroupRepresentations( <list> )
##
##  Let <list> be the return value of `AtlasFilesFromDirectoryTree'
##  (see~"AtlasFilesFromDirectoryTree").
##
##  `GroupNamesOfAtlasOfGroupRepresentations' returns the sorted list of all
##  triples to be stored as value of the `groupnames' component of
##  `AtlasOfGroupRepresentationsInfo' (see~"AtlasOfGroupRepresentationsInfo")
##  if the `TableOfContents' component is replaced by the record to be
##  computed from <list>.
##  If the level of `InfoAtlasRep' (see~"InfoAtlasRep") is at least $1$
##  then information is printed about illegal names met.
##
DeclareGlobalFunction( "GroupNamesOfAtlasOfGroupRepresentations" );


#############################################################################
##
#F  AGRGNAN( <gapname>, <atlasname> )
##
##  Let <gapname> be a string denoting a {\GAP} group name,
##  and <atlasname> be a string denoting the corresponding {\ATLAS}-file name
##  used in filenames of the {\ATLAS} of Group Representations.
##  `AGRGNAN' adds the pair `[ <gapname>, <atlasname> ]' to the list
##  `AtlasOfGroupRepresentationsInfo.GAPnames'
##  (see~"AtlasOfGroupRepresentationsInfo"),
##  making the {\ATLAS} data involving <atlasname> accessible for
##  the group with name <gapname>.
##
DeclareGlobalFunction( "AGRGNAN" );


#############################################################################
##
#F  AGRFLD( <filename>, <descr> )
##
##  Let <filename> be a string denoting the name of a file containing the
##  generators of a representation written over a proper extension of the
##  rational number field, and <descr> a string describing the field
##  generated by the matrix entries.
##  `AGRFLD' adds the pair `[ <filename>, <descr> ]' to the list
##  `AtlasOfGroupRepresentationsInfo.fieldinfo'
##  (see~"AtlasOfGroupRepresentationsInfo").
##
DeclareGlobalFunction( "AGRFLD" );


#############################################################################
##
#F  AtlasGeneratorsCharacteristicZeroFile( <filename> )
##
##  Let <filename> be the name of a file containing the generators of a
##  representation in characteristic zero such that reading the file via
##  `ReadAsFunction' yields the lists of the generators.
##  Then `AtlasGeneratorsCharacteristicZeroFile' returns these generators.
##
DeclareGlobalFunction( "AtlasGeneratorsCharacteristicZeroFile" );


#############################################################################
##
#F  AtlasStringOfFieldOfMatrixEntries( <mats> )
#F  AtlasStringOfFieldOfMatrixEntries( <filename> )
##
##  For a nonempty list <mats> of matrices of cyclotomics,
##  `AtlasStringOfFieldOfMatrixEntries' returns a string describing the field
##  $F$ generated by all matrix entries.
##  If $F$ is a quadratic field then the result is of the form
##  `\"Field([Sqrt(<n>)])\"' where <n> is an integer;
##  if $F$ is the <n>-th cyclotomic field, for a positive integer <n>
##  then the result is of the form `\"Field([E(<n>)])\"';
##  otherwise the result is the `String' value
##  (see~"ref:String" in the {\GAP} Reference Manual)
##  of the field object.
##
DeclareGlobalFunction( "AtlasStringOfFieldOfMatrixEntries" );


#############################################################################
##
#F  AtlasTableOfContents( \"local\" )
#F  AtlasTableOfContents( \"remote\" )
##
##  `AtlasTableOfContents' returns a record with components `groupnames' and
##  `TableOfContents'.
##
##  If the argument is `\"local\"' then the value of the `groupnames'
##  component is equal to the value of
##  `AtlasOfGroupRepresentationsInfo.groupnames';
##  if the argument is `\"remote\"' then the value of the `groupnames'
##  component is the list of triples corresponding to the groups currently
##  available on the servers (see~"AtlasOfGroupRepresentationsInfo").
##
##  The value of the `TableOfContents' component is a record whose components
##  are names that occur as last entries in the `groupnames' triples;
##  the value of each such component is a record with components
##  `perm', `matff', `matalg', `matint', `matmodn', `classes', `maxes',
##  and `maxstd', all lists.
##  If the argument is `\"local\"' then the contents of the local {\GAP}
##  installation is considered, otherwise the data available on the servers
##  (see~"AtlasOfGroupRepresentationsInfo").
##
##  Once a (local or remote) table of contents has been computed using
##  `AtlasTableOfContents',
##  it is stored in `AtlasOfGroupRepresentationsInfo.TableOfContents'
##  (see~"AtlasOfGroupRepresentationsInfo"),
##  and is just fetched when `AtlasTableOfContents' is called again.
##  Recomputation can be forced using `ReloadAtlasTableOfContents'
##  (see~"ReloadAtlasTableOfContents").
##
DeclareGlobalFunction( "AtlasTableOfContents" );


#############################################################################
##
#F  ReloadAtlasTableOfContents( \"local\" )
#F  ReloadAtlasTableOfContents( \"remote\" )
##
##  `ReloadAtlasTableOfContents' replaces the table of contents
##  (local or remote, depending on the argument)
##  of the {\ATLAS} of Group Representations by the one obtained from
##  inspecting the actual contents of the data directories
##  (see~"The Tables Of Contents of the Atlas of Group Representations").
##
DeclareGlobalFunction( "ReloadAtlasTableOfContents" );


#############################################################################
##
#F  AGRGRP( <dirname>, <simpname>, <groupname> )
#F  AGRTOC( <arg> )
##
##  These functions are used to create the initial table of contents for the
##  server data of the AtlasRep package when the file `atlasprm.g' in the
##  `gap' directory of the package is read.
##  Encoding the table of contents in terms of calls to `AGRGRP' and `AGRTOC'
##  is done by `StringOfAtlasTableOfContents'
##  (see~"StringOfAtlasTableOfContents").
##
##  Each call of `AGRGRP' notifies the group with name <groupname>,
##  which is related to the simple group with name <simpname>
##  and for which the data on the servers can be found in the directory
##  with name <dirname>.
##
##  Each call of `AGRTOC' notifies an entry to the `TableOfContents.remote'
##  component of the global variable `AtlasOfGroupRepresentationsInfo'.
##  The arguments must have one of the following forms,
##  which correspond to the possible forms of the names of the data files
##  described in
##  Section~"Filenames Used in the Atlas of Group Representations".
##  In any case <groupname> is a string appearing at third
##  position in an entry of `AtlasOfGroupRepresentationsInfo.groupnames'
##  (see~"AtlasOfGroupRepresentationsInfo"),
##  <gens> is a nonnegative integer denoting the set of standard generators
##  used,
##  and <bas> is an integer denoting that the generators are written
##  w.r.t.~the <bas>-th basis.
##  \beginitems
##  `AGRTOC(<groupname>,<gens>,\"p\",<degree>,<id>,<bas>,<filenames>);' &
##      permutation representation of degree <degree>, specified by <id>,
##      with generators in the files with names in the list <filenames>,
##
##  `AGRTOC(<groupname>,<gens>,\"f\",<q>,<dim>,<id>,<bas>,<filenames>);' &
##      matrix representation over the field with <q> elements,
##      of dimension <dim>, specified by <id>,
##      with generators in the files with names in the list <filenames>,
##
##  `AGRTOC(<groupname>,<gens>,\"Ar\",<dim>,<id>,<bas>,<filename>);' &
##      matrix representation of dimension <dim> over an algebraic number
##      field, specified by <id>,
##      with generators in the file with name <filename>,
##
##  `AGRTOC(<groupname>,<gens>,\"Zr\",<dim>,<id>,<bas>,<filename>);' &
##      matrix representation of dimension <dim> over the integers,
##      specified by <id>,
##      with generators in the file with name <filename>,
##
##  `AGRTOC(<groupname>,<gens>,\"R\",<n>,<dim>,<id>,<bas>,<filename>);' &
##      matrix representation of dimension <dim> over the residue class ring
##      of integers mod <n>, specified by <id>,
##      with generators in the file with name <filename>,
##
##  `AGRTOC(<groupname>,<gens>,\"M\",<n>,<filename>);' &
##      straight line program to compute generators of the <n>-th maximal
##      subgroup, stored in the file with name <filename>,
##
##  `AGRTOC(<groupname>,<gens>,\"MS\",<filename>);' &
##      straight line program to standardize generators of a maximal
##      subgroup, stored in the file with name <filename>,
##
##  `AGRTOC(<groupname>,<gens>,\"C\",<filename>);' &
##      straight line program to compute conjugacy class representatives,
##      or representatives of maximally cyclic subgroups,
##      stored in the file with name <filename>,
##
##  `AGRTOC(<groupname>,<gens>,\"O\",<outname>,<filename>);' &
##      straight line program to compute images of the standard generators
##      under the outer automorphism with name <outname>,
##      stored in the file with name <filename>.
##  \enditems
##
DeclareGlobalFunction( "AGRGRP" );
DeclareGlobalFunction( "AGRTOC" );


#############################################################################
##
#F  StringOfAtlasTableOfContents( \"remote\" )
#F  StringOfAtlasTableOfContents( \"local\" )
##
##  If the argument is the string `\"remote\"' or `\"local\"' then
##  `StringOfAtlasTableOfContents' returns a string that encodes the
##  currently stored value of the table of contents for the remote or local
##  data, respectively, of the {\ATLAS} of Group Representations,
##  in terms of calls to `AGRGRP' (see~"AGRGRP") and `AGRTOC' (see~"AGRTOC").
##
##  This function is used for automatically creating updates of the file
##  `atlasprm.g' in the `gap' directory of the AtlasRep package.
##
DeclareGlobalFunction( "StringOfAtlasTableOfContents" );


#############################################################################
##
#F  AtlasOfGroupRepresentationsUpdateData( [<groupnames>] )
##
##  The purpose of `AtlasOfGroupRepresentationsUpdateData' is to transfer
##  data files of the {\ATLAS} of Group Representations available on the
##  remote servers to the local data directories.
##  If a list <groupnames> of {\GAP} names is given as argument
##  (see~"Group Names Used in the AtlasRep Package") then all files for these
##  groups are fetched from the servers (if not yet locally available),
##  the default is the list of all {\GAP} names.
##
##  Note that this function is thought for adding a few new files to an
##  already existing local installation of the {\ATLAS} data
##  (see~"Local or Remote Installation of the AtlasRep Share Package").
##  The function is *not* thought for creating a local copy of the servers'
##  data from scratch.
##
DeclareGlobalFunction( "AtlasOfGroupRepresentationsUpdateData" );


#############################################################################
##
#E

