#############################################################################
##
#W  atlasprm.g         GAP share package `atlasrep'             Thomas Breuer
##
#H  @(#)$Id: atlasprm.g,v 1.38 2001/03/26 15:20:12 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file is the primary file of the {\GAP} interface for the
##  Atlas of Group Representations.
##  It contains the data that is needed to access the representations and
##  straight line programs.
##
##  This file is the only one in the `atlasrep' package that must be changed
##  when the database is upgraded.
##
Revision.( "atlasrep/gap/atlasprm_g" ) :=
    "@(#)$Id: atlasprm.g,v 1.38 2001/03/26 15:20:12 gap Exp $";


#############################################################################
##
##  The `AUTO' statement binds the variable.
##
Unbind( AtlasOfGroupRepresentationsInfo );


#############################################################################
##
#V  AtlasOfGroupRepresentationsInfo
##
##  `AtlasOfGroupRepresentationsInfo' is a record with the following
##  components.
##  \beginitems
##  `remote' &
##      a boolean that controls what files are available;
##      if the value is `true' then {\GAP} is allowed to try remotely
##      accessing any {\ATLAS} file from the servers (see below) and thus all
##      files listed in the global table of contents are available,
##      if the value is `false' then {\GAP} may access
##      only those files that are stored in the database directories of the
##      local {\GAP} installation,
##
##  `servers' &
##      a list of quadrupels `[ <server>, <path>, <login>, <password> ]',
##      where <server> is a string denoting the `ftp' address of a server
##      where files can be fetched that are not stored in the local database,
##      <path> is a string describing the path where the data directories
##      on the server reside
##      (relative to the directory entered via `ftp' login),
##      <login> is the login name for the server access,
##      and <password> is the corresponding password;
##      only this list must be adjusted if new servers are added or if the
##      addresses of servers change,
##
##  `dirnames' &
##      a list of the names of the directories on the servers that contain
##      subdirectories corresponding to the individual groups,
##
##  `GAPnames' &
##      a list of pairs, each containing the {\GAP} name and the
##      {\ATLAS}-file name of a group
##      (see~"Group Names Used in the AtlasRep Package"),
##
##  `groupnames' &
##      a list of triples, each containing at the first position the name of
##      the directory on each server that contains data about the group $G$
##      in question, at the second position the name of the (usually simple)
##      group for which a subdirectory exists that contains the data about
##      $G$, and at the third position the {\ATLAS}-file name used for $G$
##      (see~"Filenames used in the Atlas of Group Representations"),
##
##  `fieldinfo' &
##      a list of pairs, each containing at the first position the name of
##      the file with the matrices of a characteristic zero representation,
##      and at the second position a string describing the field generated
##      by the matrix entries;
##      `DisplayAtlasInfo' (see~"DisplayAtlasInfo") displays this information
##      for representations over proper extensions of the rational number
##      field only if the representation is mentioned in the `fieldinfo'
##      list, and
##
##  `TableOfContents' &
##      a record with at most the components `local', `remote', and `data';
##      the values of these components can be computed automatically by
##      `AtlasTableOfContents'.
##  \enditems
##
##  The record components, except `TableOfContents',
##  are not computed automatically.
##  If new groups or new field information for characteristic zero
##  representations become available then the file `atlasprm.g' must be
##  updated.
##
DeclareGlobalVariable( "AtlasOfGroupRepresentationsInfo",
    "record storing group names, table of contents etc." );

InstallValue( AtlasOfGroupRepresentationsInfo, rec(

    servers := [
                 [ "for.mat.bham.ac.uk", "v2.0/", "atlasftp", "atlasftp" ],
               ],

    remote := true,

    dirnames := [
                  "alt",
                  "clas",
                  "exc",
                  "lin",
                  "misc",
                  "spor",
                ],

    GAPnames := [],

    groupnames := [],

    fieldinfo := [],

    TableOfContents := rec( remote := rec() )

    ) );


#############################################################################
##
##  Establish the bijection between the group names used in the filenames of
##  the {\ATLAS} database and the names used to access the groups in {\GAP}.
##

# alternating and related groups
AGRGNAN("A5","A5");
AGRGNAN("A5.2","S5");
AGRGNAN("2.A5","2A5");
AGRGNAN("2.A5.2","2S5");
AGRGNAN("Isoclinic(2.A5.2)","2S5i");
AGRGNAN("A6","A6");
AGRGNAN("2.A6","2A6");
AGRGNAN("3.A6","3A6");
AGRGNAN("6.A6","6A6");
AGRGNAN("A7","A7");
AGRGNAN("A7.2","S7");
AGRGNAN("2.A7","2A7");
AGRGNAN("2.A7.2","2S7");
AGRGNAN("3.A7","3A7");
AGRGNAN("3.A7.2","3S7");
AGRGNAN("6.A7","6A7");
AGRGNAN("6.A7.2","6S7");
AGRGNAN("A8","A8");
AGRGNAN("A8.2","S8");
AGRGNAN("2.A8","2A8");
AGRGNAN("2.A8.2","2S8");
AGRGNAN("A9","A9");
AGRGNAN("A9.2","S9");
AGRGNAN("2.A9","2A9");
AGRGNAN("2.A9.2","2S9");
AGRGNAN("A10","A10");
AGRGNAN("A10.2","S10");
AGRGNAN("2.A10","2A10");
AGRGNAN("2.A10.2","2S10");
AGRGNAN("A11","A11");
AGRGNAN("A11.2","S11");
AGRGNAN("2.A11","2A11");
AGRGNAN("2.A11.2","2S11");
AGRGNAN("A12","A12");
AGRGNAN("A12.2","S12");
AGRGNAN("2.A12","2A12");
AGRGNAN("2.A12.2","2S12");
AGRGNAN("A13","A13");
AGRGNAN("A13.2","S13");
AGRGNAN("2.A13","2A13");
AGRGNAN("2.A13.2","2S13");
AGRGNAN("A14","A14");
AGRGNAN("A14.2","S14");
AGRGNAN("2.A14","2A14");
AGRGNAN("2.A14.2","2S14");
AGRGNAN("Isoclinic(2.A14.2)","2S14i");

# symplectic and related groups
AGRGNAN("S4(4)","S44");
AGRGNAN("S4(4).2","S44d2");
AGRGNAN("S4(4).4","S44d4");
AGRGNAN("S4(5)","S45");
AGRGNAN("S4(5).2","S45d2");
AGRGNAN("2.S4(5)","2S45");
AGRGNAN("S4(7)","S47");
AGRGNAN("S4(7).2","S47d2");
AGRGNAN("2.S4(7)","2S47");
AGRGNAN("2.S4(7).2","2S47d2");
AGRGNAN("S6(2)","S62");
AGRGNAN("2.S6(2)","2S62");
AGRGNAN("S6(3)","S63");
AGRGNAN("S6(3).2","S63d2");
AGRGNAN("2.S6(3)","2S63");
AGRGNAN("2.S6(3).2","2S63d2");
AGRGNAN("S8(2)","S82");
AGRGNAN("S10(2)","S102");

# orthogonal and related groups
AGRGNAN("O7(3)","O73");
AGRGNAN("O7(3).2","O73d2");
AGRGNAN("2.O7(3)","2O73");
AGRGNAN("2.O7(3).2","2O73d2");
AGRGNAN("3.O7(3)","3O73");
AGRGNAN("3.O7(3).2","3O73d2");
AGRGNAN("6.O7(3)","6O73");
AGRGNAN("6.O7(3).2","6O73d2");
AGRGNAN("O8-(2)","O8m2");
AGRGNAN("O8-(2).2","O8m2d2");
AGRGNAN("O8+(2)","O8p2");
AGRGNAN("O8+(2).2","O8p2d2");
AGRGNAN("O8+(2).3","O8p2d3");
AGRGNAN("2.O8+(2)","2O8p2");
AGRGNAN("2.O8+(2).2","2O8p2d2");
AGRGNAN("O8-(3)","O8m3");
AGRGNAN("O8-(3).2_1","O8m3d2a");
AGRGNAN("O8-(3).2^2","O8m3V4");
AGRGNAN("O8-(3).D8","O8m3D8");    # a double cover of `O8-(3).2^2'
AGRGNAN("2.O8-(3)","2O8m3");
AGRGNAN("2.O8-(3).2_1","2O8m3d2a");
AGRGNAN("O8+(3)","O8p3");
AGRGNAN("O9(3)","O93");
AGRGNAN("O9(3).2","O93d2");
AGRGNAN("2.O9(3)","2O93");
AGRGNAN("2.O9(3).2","2O93d2");
AGRGNAN("O10-(2)","O10m2");
AGRGNAN("O10-(2).2","O10m2d2");

# projective special unitary and related groups
AGRGNAN("U3(3)","U33");
AGRGNAN("U3(3).2","U33d2");
AGRGNAN("U3(4)","U34");
AGRGNAN("U3(4).2","U34d2");
AGRGNAN("U3(4).4","U34d4");
AGRGNAN("U3(5)","U35");
AGRGNAN("U3(5).2","U35d2");
AGRGNAN("U3(5).3","U35d3");
AGRGNAN("U3(7)","U37");
AGRGNAN("U3(8)","U38");
AGRGNAN("U3(9)","U39");
AGRGNAN("U3(11)","U311");
AGRGNAN("U4(2)","U42");
AGRGNAN("U4(2).2","U42d2");
AGRGNAN("2.U4(2)","2U42");
AGRGNAN("2.U4(2).2","2U42d2");
AGRGNAN("U4(3)","U43");
AGRGNAN("U4(3).2_1","U43d21");
AGRGNAN("U4(3).2_2","U43d22");
AGRGNAN("U4(3).2_3","U43d23");
AGRGNAN("U4(3).4","U43d4");
AGRGNAN("U6(2)","U62");
AGRGNAN("U6(2).2","U62d2");
AGRGNAN("U6(2).3","U62d3");
AGRGNAN("U7(2)","U72");
AGRGNAN("2^14.U7(2)","214U72");

# exceptional and related groups
AGRGNAN("E6(2)","E62");
AGRGNAN("E6(4)","E64");
AGRGNAN("E6(4).2","E64d2");
AGRGNAN("3.E6(4)","3E64");
AGRGNAN("3.E6(4).2","3E64d2");
AGRGNAN("E7(2)","E72");
AGRGNAN("E7(4)","E74");
AGRGNAN("E8(2)","E82");
AGRGNAN("E8(5)","E85");
AGRGNAN("F4(2)","F42");
AGRGNAN("F4(2).2","F42d2");
AGRGNAN("2.F4(2)","2F42");
AGRGNAN("2.F4(2).2","2F42d2");
AGRGNAN("Isoclinic(2.F4(2).4)","2F42d4i");
AGRGNAN("G2(3)","G23");
AGRGNAN("G2(3).2","G23d2");
AGRGNAN("3.G2(3)","3G23");
AGRGNAN("3.G2(3).2","3G23d2");
AGRGNAN("G2(4)","G24");
AGRGNAN("G2(4).2","G24d2");
AGRGNAN("2.G2(4)","2G24");
AGRGNAN("2.G2(4).2","2G24d2");
AGRGNAN("Isoclinic(2.G2(4).2)","2G24d2i");
AGRGNAN("G2(5)","G25");
AGRGNAN("R(27)","R27");
AGRGNAN("R(27).3","R27d3");
AGRGNAN("Sz(32)","Sz32");
AGRGNAN("Sz(32).5","Sz32d5");
AGRGNAN("Sz(8)","Sz8");
AGRGNAN("Sz(8).3","Sz8d3");
AGRGNAN("2.Sz(8)","2Sz8");
AGRGNAN("2^2.Sz(8).3","4Sz8d3");

# twisted and related groups
AGRGNAN("3D4(2)","TD42");
AGRGNAN("3D4(2).3","TD42d3");
AGRGNAN("3D4(3)","TD43");
AGRGNAN("2E6(2)","TE62");
AGRGNAN("2E6(2).2","TE62d2");
AGRGNAN("2E6(2).3","TE62d3");
AGRGNAN("2E6(2).S3","TE62S3");
AGRGNAN("2.2E6(2)","2TE62");
AGRGNAN("2.2E6(2).2","2TE62d2");
AGRGNAN("2^2.2E6(2)","4TE62");
AGRGNAN("3.2E6(2)","3TE62");
AGRGNAN("3.2E6(2).2","3TE62d2");
AGRGNAN("3.2E6(2).3","3TE62d3");
AGRGNAN("3.2E6(2).S3","3TE62S3");
AGRGNAN("2F4(2)'","TF42");
AGRGNAN("2F4(2)'.2","TF42d2");

# projective special linear and related groups
AGRGNAN("L2(8)","L28");
AGRGNAN("L2(8).3","L28d3");
AGRGNAN("L2(11)","L211");
AGRGNAN("L2(11).2","L211d2");
AGRGNAN("L2(13)","L213");
AGRGNAN("L2(13).2","L213d2");
AGRGNAN("L2(16)","L216");
AGRGNAN("L2(16).2","L216d2");
AGRGNAN("L2(16).4","L216d4");
AGRGNAN("L2(17)","L217");
AGRGNAN("L2(17).2","L217d2");
AGRGNAN("L2(19)","L219");
AGRGNAN("L2(19).2","L219d2");
AGRGNAN("L2(23)","L223");
AGRGNAN("L2(23).2","L223d2");
AGRGNAN("L2(25)","L225");
AGRGNAN("L2(25).2_1","L225d21");
AGRGNAN("L2(25).2_2","L225d22");
AGRGNAN("L2(25).2_3","L225d23");
AGRGNAN("L2(27)","L227");
AGRGNAN("L2(27).2","L227d2");
AGRGNAN("L2(27).3","L227d3");
AGRGNAN("L2(27).6","L227d6");
AGRGNAN("L2(29)","L229");
AGRGNAN("L2(29).2","L229d2");
AGRGNAN("L2(31)","L231");
AGRGNAN("L2(31).2","L231d2");
AGRGNAN("L2(32)","L232");
AGRGNAN("L2(32).5","L232d5");
AGRGNAN("L3(2)","L32");
AGRGNAN("L3(2).2","L32d2");
AGRGNAN("L3(3)","L33");
AGRGNAN("L3(3).2","L33d2");
AGRGNAN("L3(4)","L34");
AGRGNAN("L3(5)","L35");
AGRGNAN("L3(5).2","L35d2");
AGRGNAN("L3(7)","L37");
AGRGNAN("L3(7).2","L37d2");
AGRGNAN("L3(7).3","L37d3");
AGRGNAN("L3(8)","L38");
AGRGNAN("L3(8).2","L38d2");
AGRGNAN("L3(8).3","L38d3");
AGRGNAN("L3(8).6","L38d6");
AGRGNAN("L3(9)","L39");
AGRGNAN("L3(9).2_1","L39d21");
AGRGNAN("L3(9).2_2","L39d22");
AGRGNAN("L3(9).2_3","L39d23");
AGRGNAN("L4(3)","L43");
AGRGNAN("L4(3).2_1","L43d21");
AGRGNAN("L4(3).2_2","L43d22");
AGRGNAN("L4(3).2_3","L43d23");
AGRGNAN("L5(2)","L52");
AGRGNAN("L5(2).2","L52d2");
AGRGNAN("2^4.A8","24A8");
AGRGNAN("2^5.L5(2)","25L52");
AGRGNAN("5^3.L3(5)","53L35");

# sporadic simple and related groups
AGRGNAN("B","B");
AGRGNAN("Co1","Co1");
AGRGNAN("2.Co1","2Co1");
AGRGNAN("Co2","Co2");
AGRGNAN("Co3","Co3");
AGRGNAN("Fi22","F22");
AGRGNAN("Fi22.2","F22d2");
AGRGNAN("2.Fi22","2F22");
AGRGNAN("2.Fi22.2","2F22d2");
AGRGNAN("3.Fi22","3F22");
AGRGNAN("3.Fi22.2","3F22d2");
AGRGNAN("6.Fi22","6F22");
AGRGNAN("6.Fi22.2","6F22d2");
AGRGNAN("Fi23","F23");
AGRGNAN("3.Fi24'","3F24");
AGRGNAN("3.Fi24'.2","3F24d2");
AGRGNAN("Fi24'","F24");
AGRGNAN("Fi24'.2","F24d2");
AGRGNAN("HN","HN");
AGRGNAN("HN.2","HNd2");
AGRGNAN("HS","HS");
AGRGNAN("HS.2","HSd2");
AGRGNAN("2.HS","2HS");
AGRGNAN("2.HS.2","2HSd2");
AGRGNAN("He","He");
AGRGNAN("He.2","Hed2");
AGRGNAN("J1","J1");
AGRGNAN("J2","J2");
AGRGNAN("J2.2","J2d2");
AGRGNAN("2.J2","2J2");
AGRGNAN("2.J2.2","2J2d2");
AGRGNAN("J3","J3");
AGRGNAN("J3.2","J3d2");
AGRGNAN("3.J3","3J3");
AGRGNAN("3.J3.2","3J3d2");
AGRGNAN("J4","J4");
AGRGNAN("Ly","Ly");
AGRGNAN("M11","M11");
AGRGNAN("M12","M12");
AGRGNAN("M12.2","M12d2");
AGRGNAN("2.M12","2M12");
AGRGNAN("2.M12.2","2M12d2");
AGRGNAN("M22","M22");
AGRGNAN("M22.2","M22d2");
AGRGNAN("2.M22","2M22");
AGRGNAN("2.M22.2","2M22d2");
AGRGNAN("3.M22","3M22");
AGRGNAN("3.M22.2","3M22d2");
AGRGNAN("4.M22","4M22");
AGRGNAN("4.M22.2","4M22d2");
AGRGNAN("6.M22","6M22");
AGRGNAN("6.M22.2","6M22d2");
AGRGNAN("12.M22","12M22");
AGRGNAN("12.M22.2","12M22d2");
AGRGNAN("M23","M23");
AGRGNAN("M24","M24");
AGRGNAN("McL","McL");
AGRGNAN("McL.2","McLd2");
AGRGNAN("3.McL","3McL");
AGRGNAN("3.McL.2","3McLd2");
AGRGNAN("ON","ON");
AGRGNAN("ON.2","ONd2");
AGRGNAN("ON.4","ONd4");
AGRGNAN("3.ON","3ON");
AGRGNAN("3.ON.2","3ONd2");
AGRGNAN("Ru","Ru");
AGRGNAN("2.Ru","2Ru");
AGRGNAN("Suz","Suz");
AGRGNAN("Suz.2","Suzd2");
AGRGNAN("2.Suz","2Suz");
AGRGNAN("2.Suz.2","2Suzd2");
AGRGNAN("3.Suz","3Suz");
AGRGNAN("3.Suz.2","3Suzd2");
AGRGNAN("6.Suz","6Suz");
AGRGNAN("6.Suz.2","6Suzd2");
AGRGNAN("Th","Th");


#############################################################################
##
##  Store information about the fields over which characteristic zero
##  representations are written if known.
##  Note that the filenames do not contain this information,
##  so it has to be stored explicitly.
##
AGRFLD("2A5G1-Ar6B0","Field([Sqrt(-1)])");
AGRFLD("2A5G1-Ar6B1","Field([Sqrt(-3)])");
AGRFLD("2S5G1-Ar4bB0","Field([Sqrt(-3)])");
AGRFLD("2S5iG1-Ar4aB1","Field([Sqrt(-2)])");
AGRFLD("2S5iG1-Ar4aB2","Field([Sqrt(-5)])");
AGRFLD("A5G1-Ar3aB0","Field([Sqrt(5)])");
AGRFLD("A5G1-Ar3bB0","Field([Sqrt(5)])");
AGRFLD("L52d2G1-Ar30B0","Field([Sqrt(2)])");
AGRFLD("M11G1-Ar10bB0","Field([Sqrt(-2)])");
AGRFLD("M11G1-Ar10cB0","Field([Sqrt(-2)])");


#############################################################################
##
##  In the following, the table of contents is built up
##  using `AGRGRP' and `AGRTOC'.
##  This part of the file is created by the script `etc/maketoc',
##  do not edit below this line!
##

# 2A10
AGRGRP("alt","A10","2A10");
AGRTOC("2A10",1,"f",3,16,"",0,["2A10G1-f3r16B0.m",2]);
AGRTOC("2A10",1,"f",5,8,"",0,["2A10G1-f5r8B0.m",2]);
AGRTOC("2A10",1,"f",5,56,"",0,["2A10G1-f5r56B0.m",2]);
AGRTOC("2A10",1,"f",7,16,"",0,["2A10G1-f7r16B0.m",2]);

# A10
AGRGRP("alt","A10","A10");
AGRTOC("A10",1,"p",10,"",0,["A10G1-p10B0.m",2]);
AGRTOC("A10",1,"p",45,"",0,["A10G1-p45B0.m",2]);
AGRTOC("A10",1,"p",120,"",0,["A10G1-p120B0.m",2]);
AGRTOC("A10",1,"p",126,"",0,["A10G1-p126B0.m",2]);
AGRTOC("A10",1,"p",210,"",0,["A10G1-p210B0.m",2]);
AGRTOC("A10",1,"p",945,"",0,["A10G1-p945B0.m",2]);
AGRTOC("A10",1,"p",2520,"",0,["A10G1-p2520B0.m",2]);
AGRTOC("A10",1,"f",2,16,"",0,["A10G1-f2r16B0.m",2]);

# S10
AGRGRP("alt","A10","S10");
AGRTOC("S10",1,"p",10,"",0,["S10G1-p10B0.m",2]);

# 2A11
AGRGRP("alt","A11","2A11");
AGRTOC("2A11",1,"p",5040,"",0,["2A11G1-p5040B0.m",2]);
AGRTOC("2A11",1,"f",3,16,"a",0,["2A11G1-f3r16aB0.m",2]);
AGRTOC("2A11",1,"f",3,16,"b",0,["2A11G1-f3r16bB0.m",2]);
AGRTOC("2A11",1,"f",3,144,"",0,["2A11G1-f3r144B0.m",2]);
AGRTOC("2A11",1,"f",5,16,"a",0,["2A11G1-f5r16aB0.m",2]);
AGRTOC("2A11",1,"f",5,16,"b",0,["2A11G1-f5r16bB0.m",2]);
AGRTOC("2A11",1,"f",5,56,"",0,["2A11G1-f5r56B0.m",2]);
AGRTOC("2A11",1,"f",7,32,"",0,["2A11G1-f7r32B0.m",2]);
AGRTOC("2A11",1,"f",7,144,"",0,["2A11G1-f7r144B0.m",2]);
AGRTOC("2A11",1,"f",11,16,"",0,["2A11G1-f11r16B0.m",2]);
AGRTOC("2A11",1,"f",11,128,"",0,["2A11G1-f11r128B0.m",2]);
AGRTOC("2A11",1,"f",49,16,"a",0,["2A11G1-f49r16aB0.m",2]);
AGRTOC("2A11",1,"f",49,16,"b",0,["2A11G1-f49r16bB0.m",2]);

# 2S11
AGRGRP("alt","A11","2S11");
AGRTOC("2S11",1,"f",3,32,"",0,["2S11G1-f3r32B0.m",2]);
AGRTOC("2S11",1,"f",5,32,"",0,["2S11G1-f5r32B0.m",2]);
AGRTOC("2S11",1,"f",7,32,"",0,["2S11G1-f7r32B0.m",2]);
AGRTOC("2S11",1,"f",11,16,"",0,["2S11G1-f11r16B0.m",2]);

# A11
AGRGRP("alt","A11","A11");
AGRTOC("A11",1,"p",11,"",0,["A11G1-p11B0.m",2]);
AGRTOC("A11",1,"p",55,"",0,["A11G1-p55B0.m",2]);
AGRTOC("A11",1,"p",165,"",0,["A11G1-p165B0.m",2]);
AGRTOC("A11",1,"p",330,"",0,["A11G1-p330B0.m",2]);
AGRTOC("A11",1,"p",462,"",0,["A11G1-p462B0.m",2]);
AGRTOC("A11",1,"p",2520,"a",0,["A11G1-p2520aB0.m",2]);
AGRTOC("A11",1,"p",2520,"b",0,["A11G1-p2520bB0.m",2]);
AGRTOC("A11",1,"f",2,10,"",0,["A11G1-f2r10B0.m",2]);
AGRTOC("A11",1,"f",2,32,"",0,["A11G1-f2r32B0.m",2]);
AGRTOC("A11",1,"f",2,44,"",0,["A11G1-f2r44B0.m",2]);
AGRTOC("A11",1,"f",2,100,"",0,["A11G1-f2r100B0.m",2]);
AGRTOC("A11",1,"f",2,144,"",0,["A11G1-f2r144B0.m",2]);
AGRTOC("A11",1,"f",2,164,"",0,["A11G1-f2r164B0.m",2]);
AGRTOC("A11",1,"f",2,186,"",0,["A11G1-f2r186B0.m",2]);
AGRTOC("A11",1,"f",2,198,"",0,["A11G1-f2r198B0.m",2]);
AGRTOC("A11",1,"f",3,10,"",0,["A11G1-f3r10B0.m",2]);
AGRTOC("A11",1,"f",3,34,"",0,["A11G1-f3r34B0.m",2]);
AGRTOC("A11",1,"f",3,45,"",0,["A11G1-f3r45B0.m",2]);
AGRTOC("A11",1,"f",3,109,"",0,["A11G1-f3r109B0.m",2]);
AGRTOC("A11",1,"f",3,120,"",0,["A11G1-f3r120B0.m",2]);
AGRTOC("A11",1,"f",3,126,"b",0,["A11G1-f3r126bB0.m",2]);
AGRTOC("A11",1,"f",3,126,"a",0,["A11G1-f3r126aB0.m",2]);
AGRTOC("A11",1,"f",3,131,"",0,["A11G1-f3r131B0.m",2]);
AGRTOC("A11",1,"f",4,16,"a",0,["A11G1-f4r16aB0.m",2]);
AGRTOC("A11",1,"f",4,16,"b",0,["A11G1-f4r16bB0.m",2]);
AGRTOC("A11",1,"f",5,10,"",0,["A11G1-f5r10B0.m",2]);
AGRTOC("A11",1,"f",5,43,"",0,["A11G1-f5r43B0.m",2]);
AGRTOC("A11",1,"f",5,45,"",0,["A11G1-f5r45B0.m",2]);
AGRTOC("A11",1,"f",5,55,"",0,["A11G1-f5r55B0.m",2]);
AGRTOC("A11",1,"f",5,89,"",0,["A11G1-f5r89B0.m",2]);
AGRTOC("A11",1,"f",5,110,"",0,["A11G1-f5r110B0.m",2]);
AGRTOC("A11",1,"f",5,120,"",0,["A11G1-f5r120B0.m",2]);
AGRTOC("A11",1,"f",7,10,"",0,["A11G1-f7r10B0.m",2]);
AGRTOC("A11",1,"f",7,44,"",0,["A11G1-f7r44B0.m",2]);
AGRTOC("A11",1,"f",7,45,"",0,["A11G1-f7r45B0.m",2]);
AGRTOC("A11",1,"f",7,66,"",0,["A11G1-f7r66B0.m",2]);
AGRTOC("A11",1,"f",11,9,"",0,["A11G1-f11r9B0.m",2]);
AGRTOC("A11",1,"f",11,36,"",0,["A11G1-f11r36B0.m",2]);
AGRTOC("A11",1,"f",11,44,"",0,["A11G1-f11r44B0.m",2]);
AGRTOC("A11",1,"f",11,84,"",0,["A11G1-f11r84B0.m",2]);

# S11
AGRGRP("alt","A11","S11");
AGRTOC("S11",1,"p",11,"",0,["S11G1-p11B0.m",2]);
AGRTOC("S11",1,"f",2,32,"",0,["S11G1-f2r32B0.m",2]);

# 2A12
AGRGRP("alt","A12","2A12");
AGRTOC("2A12",1,"f",3,16,"a",0,["2A12G1-f3r16aB0.m",2]);
AGRTOC("2A12",1,"f",3,16,"b",0,["2A12G1-f3r16bB0.m",2]);
AGRTOC("2A12",1,"f",5,32,"",0,["2A12G1-f5r32B0.m",2]);
AGRTOC("2A12",1,"f",7,32,"",0,["2A12G1-f7r32B0.m",2]);
AGRTOC("2A12",1,"f",11,32,"",0,["2A12G1-f11r32B0.m",2]);

# A12
AGRGRP("alt","A12","A12");
AGRTOC("A12",1,"p",12,"",0,["A12G1-p12B0.m",2]);
AGRTOC("A12",1,"p",66,"",0,["A12G1-p66B0.m",2]);
AGRTOC("A12",1,"p",220,"",0,["A12G1-p220B0.m",2]);
AGRTOC("A12",1,"p",462,"",0,["A12G1-p462B0.m",2]);
AGRTOC("A12",1,"p",495,"",0,["A12G1-p495B0.m",2]);
AGRTOC("A12",1,"p",792,"",0,["A12G1-p792B0.m",2]);
AGRTOC("A12",1,"p",2520,"",0,["A12G1-p2520B0.m",2]);
AGRTOC("A12",1,"f",2,10,"",0,["A12G1-f2r10B0.m",2]);
AGRTOC("A12",1,"f",2,44,"",0,["A12G1-f2r44B0.m",2]);
AGRTOC("A12",1,"f",2,100,"",0,["A12G1-f2r100B0.m",2]);
AGRTOC("A12",1,"f",3,10,"",0,["A12G1-f3r10B0.m",2]);
AGRTOC("A12",1,"f",3,45,"",0,["A12G1-f3r45B0.m",2]);
AGRTOC("A12",1,"f",3,54,"",0,["A12G1-f3r54B0.m",2]);
AGRTOC("A12",1,"f",4,16,"a",0,["A12G1-f4r16aB0.m",2]);
AGRTOC("A12",1,"f",4,16,"b",0,["A12G1-f4r16bB0.m",2]);
AGRTOC("A12",1,"f",5,11,"",0,["A12G1-f5r11B0.m",2]);
AGRTOC("A12",1,"f",5,43,"",0,["A12G1-f5r43B0.m",2]);
AGRTOC("A12",1,"f",5,55,"",0,["A12G1-f5r55B0.m",2]);
AGRTOC("A12",1,"f",5,89,"",0,["A12G1-f5r89B0.m",2]);

# S12
AGRGRP("alt","A12","S12");
AGRTOC("S12",1,"p",12,"",0,["S12G1-p12B0.m",2]);

# 2A13
AGRGRP("alt","A13","2A13");
AGRTOC("2A13",1,"f",3,32,"a",0,["2A13G1-f3r32aB0.m",2]);
AGRTOC("2A13",1,"f",3,32,"b",0,["2A13G1-f3r32bB0.m",2]);
AGRTOC("2A13",1,"f",5,64,"",0,["2A13G1-f5r64B0.m",2]);
AGRTOC("2A13",1,"f",7,64,"",0,["2A13G1-f7r64B0.m",2]);
AGRTOC("2A13",1,"f",11,64,"",0,["2A13G1-f11r64B0.m",2]);
AGRTOC("2A13",1,"f",13,32,"",0,["2A13G1-f13r32B0.m",2]);
AGRTOC("2A13",1,"f",25,32,"a",0,["2A13G1-f25r32aB0.m",2]);
AGRTOC("2A13",1,"f",25,32,"b",0,["2A13G1-f25r32bB0.m",2]);
AGRTOC("2A13",1,"f",49,32,"a",0,["2A13G1-f49r32aB0.m",2]);
AGRTOC("2A13",1,"f",49,32,"b",0,["2A13G1-f49r32bB0.m",2]);
AGRTOC("2A13",1,"f",121,32,"a",0,["2A13G1-f121r32aB0.m",2]);
AGRTOC("2A13",1,"f",121,32,"b",0,["2A13G1-f121r32bB0.m",2]);

# A13
AGRGRP("alt","A13","A13");
AGRTOC("A13",1,"p",13,"",0,["A13G1-p13B0.m",2]);
AGRTOC("A13",1,"p",78,"",0,["A13G1-p78B0.m",2]);
AGRTOC("A13",1,"f",2,64,"",0,["A13G1-f2r64B0.m",2]);
AGRTOC("A13",1,"f",4,32,"a",0,["A13G1-f4r32aB0.m",2]);
AGRTOC("A13",1,"f",4,32,"b",0,["A13G1-f4r32bB0.m",2]);

# S13
AGRGRP("alt","A13","S13");
AGRTOC("S13",1,"p",13,"",0,["S13G1-p13B0.m",2]);
AGRTOC("S13",1,"p",78,"",0,["S13G1-p78B0.m",2]);

# 2A14
AGRGRP("alt","A14","2A14");
AGRTOC("2A14",1,"f",3,64,"",0,["2A14G1-f3r64B0.m",2]);
AGRTOC("2A14",1,"f",5,64,"",0,["2A14G1-f5r64B0.m",2]);
AGRTOC("2A14",1,"f",7,64,"",0,["2A14G1-f7r64B0.m",2]);
AGRTOC("2A14",1,"f",11,64,"",0,["2A14G1-f11r64B0.m",2]);
AGRTOC("2A14",1,"f",13,64,"",0,["2A14G1-f13r64B0.m",2]);
AGRTOC("2A14",1,"f",49,32,"a",0,["2A14G1-f49r32aB0.m",2]);
AGRTOC("2A14",1,"f",49,32,"b",0,["2A14G1-f49r32bB0.m",2]);

# 2S14
AGRGRP("alt","A14","2S14");
AGRTOC("2S14",1,"f",7,64,"",0,["2S14G1-f7r64B0.m",2]);

# 2S14i
AGRGRP("alt","A14","2S14i");
AGRTOC("2S14i",1,"f",7,64,"",0,["2S14iG1-f7r64B0.m",2]);

# A14
AGRGRP("alt","A14","A14");
AGRTOC("A14",1,"p",14,"",0,["A14G1-p14B0.m",2]);
AGRTOC("A14",1,"p",91,"",0,["A14G1-p91B0.m",2]);
AGRTOC("A14",1,"p",364,"",0,["A14G1-p364B0.m",2]);
AGRTOC("A14",1,"p",1001,"",0,["A14G1-p1001B0.m",2]);
AGRTOC("A14",1,"p",1716,"",0,["A14G1-p1716B0.m",2]);
AGRTOC("A14",1,"p",2002,"",0,["A14G1-p2002B0.m",2]);
AGRTOC("A14",1,"p",3003,"",0,["A14G1-p3003B0.m",2]);
AGRTOC("A14",1,"f",2,12,"",0,["A14G1-f2r12B0.m",2]);
AGRTOC("A14",1,"f",2,64,"b",0,["A14G1-f2r64bB0.m",2]);
AGRTOC("A14",1,"f",2,64,"a",0,["A14G1-f2r64aB0.m",2]);
AGRTOC("A14",1,"f",3,13,"",0,["A14G1-f3r13B0.m",2]);
AGRTOC("A14",1,"f",3,64,"",0,["A14G1-f3r64B0.m",2]);
AGRTOC("A14",1,"f",3,78,"",0,["A14G1-f3r78B0.m",2]);
AGRTOC("A14",1,"f",5,13,"",0,["A14G1-f5r13B0.m",2]);
AGRTOC("A14",1,"f",5,77,"",0,["A14G1-f5r77B0.m",2]);
AGRTOC("A14",1,"f",5,78,"",0,["A14G1-f5r78B0.m",2]);
AGRTOC("A14",1,"f",7,12,"",0,["A14G1-f7r12B0.m",2]);
AGRTOC("A14",1,"f",7,66,"",0,["A14G1-f7r66B0.m",2]);
AGRTOC("A14",1,"f",7,77,"",0,["A14G1-f7r77B0.m",2]);
AGRTOC("A14",1,"f",11,13,"",0,["A14G1-f11r13B0.m",2]);
AGRTOC("A14",1,"f",11,77,"",0,["A14G1-f11r77B0.m",2]);
AGRTOC("A14",1,"f",11,78,"",0,["A14G1-f11r78B0.m",2]);
AGRTOC("A14",1,"f",13,13,"",0,["A14G1-f13r13B0.m",2]);
AGRTOC("A14",1,"f",13,76,"",0,["A14G1-f13r76B0.m",2]);
AGRTOC("A14",1,"f",13,78,"",0,["A14G1-f13r78B0.m",2]);
AGRTOC("A14",1,"Zr",13,"",0,"A14G1-Zr13B0.M");
AGRTOC("A14",1,"Zr",77,"",0,"A14G1-Zr77B0.M");
AGRTOC("A14",1,"Zr",78,"",0,"A14G1-Zr78B0.M");

# S14
AGRGRP("alt","A14","S14");
AGRTOC("S14",1,"p",14,"",0,["S14G1-p14B0.m",2]);
AGRTOC("S14",1,"p",91,"",0,["S14G1-p91B0.m",2]);
AGRTOC("S14",1,"p",364,"",0,["S14G1-p364B0.m",2]);
AGRTOC("S14",1,"p",1001,"",0,["S14G1-p1001B0.m",2]);
AGRTOC("S14",1,"p",1716,"",0,["S14G1-p1716B0.m",2]);
AGRTOC("S14",1,"p",2002,"",0,["S14G1-p2002B0.m",2]);
AGRTOC("S14",1,"p",3003,"",0,["S14G1-p3003B0.m",2]);
AGRTOC("S14",1,"f",2,12,"",0,["S14G1-f2r12B0.m",2]);
AGRTOC("S14",1,"f",2,64,"a",0,["S14G1-f2r64aB0.m",2]);
AGRTOC("S14",1,"f",2,64,"b",0,["S14G1-f2r64bB0.m",2]);
AGRTOC("S14",1,"f",7,12,"",0,["S14G1-f7r12B0.m",2]);

# 2A5
AGRGRP("alt","A5","2A5");
AGRTOC("2A5",1,"p",24,"",0,["2A5G1-p24B0.m",2]);
AGRTOC("2A5",1,"p",40,"",0,["2A5G1-p40B0.m",2]);
AGRTOC("2A5",1,"f",2,8,"",0,["2A5G1-f2r8B0.m",2]);
AGRTOC("2A5",1,"f",2,9,"",0,["2A5G1-f2r9B0.m",2]);
AGRTOC("2A5",1,"f",2,10,"",0,["2A5G1-f2r10B0.m",2]);
AGRTOC("2A5",1,"f",3,4,"",0,["2A5G1-f3r4B0.m",2]);
AGRTOC("2A5",1,"f",3,6,"",0,["2A5G1-f3r6B0.m",2]);
AGRTOC("2A5",1,"f",4,5,"a",0,["2A5G1-f4r5aB0.m",2]);
AGRTOC("2A5",1,"f",4,5,"b",0,["2A5G1-f4r5bB0.m",2]);
AGRTOC("2A5",1,"f",5,2,"",0,["2A5G1-f5r2B0.m",2]);
AGRTOC("2A5",1,"f",5,4,"",0,["2A5G1-f5r4B0.m",2]);
AGRTOC("2A5",1,"f",7,4,"a",0,["2A5G1-f7r4aB0.m",2]);
AGRTOC("2A5",1,"f",7,4,"b",0,["2A5G1-f7r4bB0.m",2]);
AGRTOC("2A5",1,"f",7,6,"",0,["2A5G1-f7r6B0.m",2]);
AGRTOC("2A5",1,"f",9,2,"a",0,["2A5G1-f9r2aB0.m",2]);
AGRTOC("2A5",1,"f",9,2,"b",0,["2A5G1-f9r2bB0.m",2]);
AGRTOC("2A5",1,"f",49,2,"a",0,["2A5G1-f49r2aB0.m",2]);
AGRTOC("2A5",1,"f",49,2,"b",0,["2A5G1-f49r2bB0.m",2]);
AGRTOC("2A5",1,"Ar",6,"",0,"2A5G1-Ar6B0.M");
AGRTOC("2A5",1,"Ar",6,"",1,"2A5G1-Ar6B1.M");
AGRTOC("2A5",1,"Zr",12,"",0,"2A5G1-Zr12B0.M");

# 2S5
AGRGRP("alt","A5","2S5");
AGRTOC("2S5",1,"p",40,"a",0,["2S5G1-p40aB0.m",2]);
AGRTOC("2S5",1,"p",40,"b",0,["2S5G1-p40bB0.m",2]);
AGRTOC("2S5",1,"p",48,"",0,["2S5G1-p48B0.m",2]);
AGRTOC("2S5",1,"f",3,4,"",0,["2S5G1-f3r4B0.m",2]);
AGRTOC("2S5",1,"f",3,6,"",0,["2S5G1-f3r6B0.m",2]);
AGRTOC("2S5",1,"f",5,4,"b",0,["2S5G1-f5r4bB0.m",2]);
AGRTOC("2S5",1,"f",5,8,"",0,["2S5G1-f5r8B0.m",2]);
AGRTOC("2S5",1,"f",25,2,"",0,["2S5G1-f25r2B0.m",2]);
AGRTOC("2S5",1,"f",25,4,"a",0,["2S5G1-f25r4aB0.m",2]);
AGRTOC("2S5",1,"Ar",4,"b",0,"2S5G1-Ar4bB0.M");
AGRTOC("2S5",1,"Zr",8,"a",0,"2S5G1-Zr8aB0.M");

# 2S5i
AGRGRP("alt","A5","2S5i");
AGRTOC("2S5i",1,"p",48,"",0,["2S5iG1-p48B0.m",2]);
AGRTOC("2S5i",1,"p",80,"",0,["2S5iG1-p80B0.m",2]);
AGRTOC("2S5i",1,"f",3,4,"",0,["2S5iG1-f3r4B0.m",2]);
AGRTOC("2S5i",1,"f",3,12,"",0,["2S5iG1-f3r12B0.m",2]);
AGRTOC("2S5i",1,"f",5,4,"b",0,["2S5iG1-f5r4bB0.m",2]);
AGRTOC("2S5i",1,"f",5,8,"",0,["2S5iG1-f5r8B0.m",2]);
AGRTOC("2S5i",1,"f",9,6,"",0,["2S5iG1-f9r6B0.m",2]);
AGRTOC("2S5i",1,"f",25,2,"",0,["2S5iG1-f25r2B0.m",2]);
AGRTOC("2S5i",1,"f",25,4,"a",0,["2S5iG1-f25r4aB0.m",2]);
AGRTOC("2S5i",1,"Ar",4,"a",1,"2S5iG1-Ar4aB1.M");
AGRTOC("2S5i",1,"Ar",4,"a",2,"2S5iG1-Ar4aB2.M");

# A5
AGRGRP("alt","A5","A5");
AGRTOC("A5",1,"p",5,"",0,["A5G1-p5B0.m",2]);
AGRTOC("A5",1,"p",6,"",0,["A5G1-p6B0.m",2]);
AGRTOC("A5",1,"p",10,"",0,["A5G1-p10B0.m",2]);
AGRTOC("A5",1,"f",2,4,"a",0,["A5G1-f2r4aB0.m",2]);
AGRTOC("A5",1,"f",2,4,"b",0,["A5G1-f2r4bB0.m",2]);
AGRTOC("A5",1,"f",3,4,"",0,["A5G1-f3r4B0.m",2]);
AGRTOC("A5",1,"f",3,6,"",0,["A5G1-f3r6B0.m",2]);
AGRTOC("A5",1,"f",4,2,"a",0,["A5G1-f4r2aB0.m",2]);
AGRTOC("A5",1,"f",4,2,"b",0,["A5G1-f4r2bB0.m",2]);
AGRTOC("A5",1,"f",5,3,"",0,["A5G1-f5r3B0.m",2]);
AGRTOC("A5",1,"f",5,5,"",0,["A5G1-f5r5B0.m",2]);
AGRTOC("A5",1,"f",9,3,"a",0,["A5G1-f9r3aB0.m",2]);
AGRTOC("A5",1,"f",9,3,"b",0,["A5G1-f9r3bB0.m",2]);
AGRTOC("A5",1,"Ar",3,"a",0,"A5G1-Ar3aB0.M");
AGRTOC("A5",1,"Ar",3,"b",0,"A5G1-Ar3bB0.M");
AGRTOC("A5",1,"Zr",4,"",0,"A5G1-Zr4B0.M");
AGRTOC("A5",1,"Zr",5,"",0,"A5G1-Zr5B0.M");
AGRTOC("A5",1,"Zr",6,"",0,"A5G1-Zr6B0.M");
AGRTOC("A5",1,"M",1,"A5G1-max1W1");
AGRTOC("A5",1,"M",2,"A5G1-max2W1");
AGRTOC("A5",1,"M",3,"A5G1-max3W1");

# S5
AGRGRP("alt","A5","S5");
AGRTOC("S5",1,"p",5,"",0,["S5G1-p5B0.m",2]);
AGRTOC("S5",1,"p",6,"",0,["S5G1-p6B0.m",2]);
AGRTOC("S5",1,"p",10,"",0,["S5G1-p10B0.m",2]);
AGRTOC("S5",1,"f",2,4,"a",0,["S5G1-f2r4aB0.m",2]);
AGRTOC("S5",1,"f",2,4,"b",0,["S5G1-f2r4bB0.m",2]);
AGRTOC("S5",1,"f",3,4,"",0,["S5G1-f3r4B0.m",2]);
AGRTOC("S5",1,"f",3,6,"",0,["S5G1-f3r6B0.m",2]);
AGRTOC("S5",1,"f",5,3,"",0,["S5G1-f5r3B0.m",2]);
AGRTOC("S5",1,"f",5,5,"",0,["S5G1-f5r5B0.m",2]);
AGRTOC("S5",1,"M",1,"S5G1-max1W1");
AGRTOC("S5",1,"M",2,"S5G1-max2W1");
AGRTOC("S5",1,"M",3,"S5G1-max3W1");
AGRTOC("S5",1,"M",4,"S5G1-max4W1");

# 6A6
AGRGRP("alt","A6","6A6");
AGRTOC("6A6",1,"f",9,6,"a",0,["6A6G1-f9r6aB0.m",2]);

# 2A8
AGRGRP("alt","A8","2A8");
AGRTOC("2A8",1,"p",240,"a",0,["2A8G1-p240aB0.m",2]);
AGRTOC("2A8",1,"p",240,"b",0,["2A8G1-p240bB0.m",2]);
AGRTOC("2A8",1,"p",240,"c",0,["2A8G1-p240cB0.m",2]);
AGRTOC("2A8",1,"f",3,8,"",0,["2A8G1-f3r8B0.m",2]);
AGRTOC("2A8",1,"f",3,48,"a",0,["2A8G1-f3r48aB0.m",2]);
AGRTOC("2A8",1,"f",3,48,"b",0,["2A8G1-f3r48bB0.m",2]);
AGRTOC("2A8",1,"f",5,8,"",0,["2A8G1-f5r8B0.m",2]);
AGRTOC("2A8",1,"f",5,48,"a",0,["2A8G1-f5r48aB0.m",2]);
AGRTOC("2A8",1,"f",5,48,"b",0,["2A8G1-f5r48bB0.m",2]);
AGRTOC("2A8",1,"f",5,64,"",0,["2A8G1-f5r64B0.m",2]);
AGRTOC("2A8",1,"f",7,8,"",0,["2A8G1-f7r8B0.m",2]);
AGRTOC("2A8",1,"f",7,16,"",0,["2A8G1-f7r16B0.m",2]);
AGRTOC("2A8",1,"f",7,48,"",0,["2A8G1-f7r48B0.m",2]);
AGRTOC("2A8",1,"f",7,56,"a",0,["2A8G1-f7r56aB0.m",2]);
AGRTOC("2A8",1,"f",7,56,"b",0,["2A8G1-f7r56bB0.m",2]);
AGRTOC("2A8",1,"f",7,112,"",0,["2A8G1-f7r112B0.m",2]);
AGRTOC("2A8",1,"f",9,24,"a",0,["2A8G1-f9r24aB0.m",2]);
AGRTOC("2A8",1,"f",9,24,"b",0,["2A8G1-f9r24bB0.m",2]);
AGRTOC("2A8",1,"f",25,24,"a",0,["2A8G1-f25r24aB0.m",2]);
AGRTOC("2A8",1,"f",25,24,"b",0,["2A8G1-f25r24bB0.m",2]);
AGRTOC("2A8",1,"f",25,32,"b",0,["2A8G1-f25r32bB0.m",2]);
AGRTOC("2A8",1,"f",25,32,"a",0,["2A8G1-f25r32aB0.m",2]);
AGRTOC("2A8",1,"f",49,56,"c",0,["2A8G1-f49r56cB0.m",2]);
AGRTOC("2A8",1,"f",49,56,"d",0,["2A8G1-f49r56dB0.m",2]);
AGRTOC("2A8",1,"R",4,4,"a",0,"2A8G1-Z4r4aB0.M");

# A8
AGRGRP("alt","A8","A8");
AGRTOC("A8",1,"p",8,"",0,["A8G1-p8B0.m",2]);
AGRTOC("A8",1,"p",15,"a",0,["A8G1-p15aB0.m",2]);
AGRTOC("A8",1,"p",15,"b",0,["A8G1-p15bB0.m",2]);
AGRTOC("A8",1,"f",2,4,"a",0,["A8G1-f2r4aB0.m",2]);
AGRTOC("A8",1,"f",2,4,"b",0,["A8G1-f2r4bB0.m",2]);
AGRTOC("A8",1,"f",2,6,"",0,["A8G1-f2r6B0.m",2]);
AGRTOC("A8",1,"f",2,14,"",0,["A8G1-f2r14B0.m",2]);
AGRTOC("A8",1,"f",2,20,"a",0,["A8G1-f2r20aB0.m",2]);
AGRTOC("A8",1,"f",2,20,"b",0,["A8G1-f2r20bB0.m",2]);
AGRTOC("A8",1,"f",2,64,"",0,["A8G1-f2r64B0.m",2]);

# S8
AGRGRP("alt","A8","S8");
AGRTOC("S8",1,"p",8,"",0,["S8G1-p8B0.m",2]);
AGRTOC("S8",1,"f",2,6,"",0,["S8G1-f2r6B0.m",2]);
AGRTOC("S8",1,"f",2,8,"",0,["S8G1-f2r8B0.m",2]);
AGRTOC("S8",1,"f",2,14,"",0,["S8G1-f2r14B0.m",2]);
AGRTOC("S8",1,"f",2,40,"",0,["S8G1-f2r40B0.m",2]);
AGRTOC("S8",1,"f",2,64,"",0,["S8G1-f2r64B0.m",2]);

# 2A9
AGRGRP("alt","A9","2A9");
AGRTOC("2A9",1,"f",3,8,"",0,["2A9G1-f3r8B0.m",2]);
AGRTOC("2A9",1,"f",3,48,"",0,["2A9G1-f3r48B0.m",2]);
AGRTOC("2A9",1,"f",3,104,"",0,["2A9G1-f3r104B0.m",2]);
AGRTOC("2A9",1,"f",5,8,"a",0,["2A9G1-f5r8aB0.m",2]);
AGRTOC("2A9",1,"f",5,8,"b",0,["2A9G1-f5r8bB0.m",2]);
AGRTOC("2A9",1,"f",7,8,"a",0,["2A9G1-f7r8aB0.m",2]);
AGRTOC("2A9",1,"f",7,8,"b",0,["2A9G1-f7r8bB0.m",2]);

# A9
AGRGRP("alt","A9","A9");
AGRTOC("A9",1,"p",9,"",0,["A9G1-p9B0.m",2]);
AGRTOC("A9",1,"p",36,"",0,["A9G1-p36B0.m",2]);
AGRTOC("A9",1,"p",84,"",0,["A9G1-p84B0.m",2]);
AGRTOC("A9",1,"p",120,"a",0,["A9G1-p120aB0.m",2]);
AGRTOC("A9",1,"p",120,"b",0,["A9G1-p120bB0.m",2]);
AGRTOC("A9",1,"p",126,"",0,["A9G1-p126B0.m",2]);
AGRTOC("A9",1,"p",280,"",0,["A9G1-p280B0.m",2]);
AGRTOC("A9",1,"p",840,"",0,["A9G1-p840B0.m",2]);
AGRTOC("A9",1,"f",2,8,"a",0,["A9G1-f2r8aB0.m",2]);
AGRTOC("A9",1,"f",2,8,"b",0,["A9G1-f2r8bB0.m",2]);
AGRTOC("A9",1,"f",2,8,"c",0,["A9G1-f2r8cB0.m",2]);
AGRTOC("A9",1,"f",3,7,"",0,["A9G1-f3r7B0.m",2]);
AGRTOC("A9",1,"f",5,8,"",0,["A9G1-f5r8B0.m",2]);
AGRTOC("A9",1,"f",7,8,"",0,["A9G1-f7r8B0.m",2]);

# S9
AGRGRP("alt","A9","S9");
AGRTOC("S9",1,"p",9,"",0,["S9G1-p9B0.m",2]);

# O10m2
AGRGRP("clas","O10m2","O10m2");
AGRTOC("O10m2",1,"p",495,"",0,["O10m2G1-p495B0.m",2]);
AGRTOC("O10m2",1,"p",528,"",0,["O10m2G1-p528B0.m",2]);
AGRTOC("O10m2",1,"f",2,10,"",0,["O10m2G1-f2r10B0.m",2]);
AGRTOC("O10m2",1,"f",2,44,"",0,["O10m2G1-f2r44B0.m",2]);
AGRTOC("O10m2",1,"f",2,100,"",0,["O10m2G1-f2r100B0.m",2]);
AGRTOC("O10m2",1,"f",2,164,"",0,["O10m2G1-f2r164B0.m",2]);
AGRTOC("O10m2",1,"f",2,670,"",0,["O10m2G1-f2r670B0.m",2]);
AGRTOC("O10m2",1,"f",4,16,"a",0,["O10m2G1-f4r16aB0.m",2]);
AGRTOC("O10m2",1,"f",4,16,"b",0,["O10m2G1-f4r16bB0.m",2]);

# O10m2d2
AGRGRP("clas","O10m2","O10m2d2");
AGRTOC("O10m2d2",1,"p",495,"",0,["O10m2d2G1-p495B0.m",2]);
AGRTOC("O10m2d2",1,"p",528,"",0,["O10m2d2G1-p528B0.m",2]);
AGRTOC("O10m2d2",1,"f",2,10,"",0,["O10m2d2G1-f2r10B0.m",2]);
AGRTOC("O10m2d2",1,"f",2,32,"",0,["O10m2d2G1-f2r32B0.m",2]);
AGRTOC("O10m2d2",1,"f",2,44,"",0,["O10m2d2G1-f2r44B0.m",2]);
AGRTOC("O10m2d2",1,"f",2,100,"",0,["O10m2d2G1-f2r100B0.m",2]);
AGRTOC("O10m2d2",1,"f",2,164,"",0,["O10m2d2G1-f2r164B0.m",2]);
AGRTOC("O10m2d2",1,"f",2,670,"",0,["O10m2d2G1-f2r670B0.m",2]);

# 2O73
AGRGRP("clas","O73","2O73");
AGRTOC("2O73",1,"p",2160,"",0,["2O73G1-p2160B0.m",2]);
AGRTOC("2O73",1,"f",3,8,"",0,["2O73G1-f3r8B0.m",2]);

# 2O73d2
AGRGRP("clas","O73","2O73d2");
AGRTOC("2O73d2",1,"f",3,8,"",0,["2O73d2G1-f3r8B0.m",2]);

# 3O73
AGRGRP("clas","O73","3O73");
AGRTOC("3O73",1,"f",4,27,"a",0,["3O73G1-f4r27aB0.m",2]);

# 3O73d2
AGRGRP("clas","O73","3O73d2");
AGRTOC("3O73d2",1,"f",2,54,"",0,["3O73d2G1-f2r54B0.m",2]);

# O73
AGRGRP("clas","O73","O73");
AGRTOC("O73",1,"p",351,"",0,["O73G1-p351B0.m",2]);
AGRTOC("O73",1,"p",364,"",0,["O73G1-p364B0.m",2]);
AGRTOC("O73",1,"p",378,"",0,["O73G1-p378B0.m",2]);
AGRTOC("O73",1,"p",1080,"a",0,["O73G1-p1080aB0.m",2]);
AGRTOC("O73",1,"p",1080,"b",0,["O73G1-p1080bB0.m",2]);
AGRTOC("O73",1,"p",1120,"",0,["O73G1-p1120B0.m",2]);
AGRTOC("O73",1,"p",3640,"",0,["O73G1-p3640B0.m",2]);
AGRTOC("O73",1,"f",2,78,"",0,["O73G1-f2r78B0.m",2]);
AGRTOC("O73",1,"f",2,90,"",0,["O73G1-f2r90B0.m",2]);
AGRTOC("O73",1,"f",2,104,"",0,["O73G1-f2r104B0.m",2]);
AGRTOC("O73",1,"f",2,260,"a",0,["O73G1-f2r260aB0.m",2]);
AGRTOC("O73",1,"f",2,260,"b",0,["O73G1-f2r260bB0.m",2]);
AGRTOC("O73",1,"f",3,7,"",0,["O73G1-f3r7B0.m",2]);
AGRTOC("O73",1,"f",3,21,"",0,["O73G1-f3r21B0.m",2]);
AGRTOC("O73",1,"f",3,27,"",0,["O73G1-f3r27B0.m",2]);
AGRTOC("O73",1,"f",3,35,"",0,["O73G1-f3r35B0.m",2]);
AGRTOC("O73",1,"f",3,63,"",0,["O73G1-f3r63B0.m",2]);
AGRTOC("O73",1,"f",3,189,"a",0,["O73G1-f3r189aB0.m",2]);
AGRTOC("O73",1,"f",3,309,"",0,["O73G1-f3r309B0.m",2]);
AGRTOC("O73",1,"f",5,78,"",0,["O73G1-f5r78B0.m",2]);
AGRTOC("O73",1,"f",7,78,"",0,["O73G1-f7r78B0.m",2]);
AGRTOC("O73",1,"f",13,78,"",0,["O73G1-f13r78B0.m",2]);

# O73d2
AGRGRP("clas","O73","O73d2");
AGRTOC("O73d2",1,"p",351,"",0,["O73d2G1-p351B0.m",2]);
AGRTOC("O73d2",1,"f",2,78,"",0,["O73d2G1-f2r78B0.m",2]);
AGRTOC("O73d2",1,"f",3,7,"",0,["O73d2G1-f3r7B0.m",2]);

# O8m2
AGRGRP("clas","O8m2","O8m2");
AGRTOC("O8m2",1,"p",119,"",0,["O8m2G1-p119B0.m",2]);
AGRTOC("O8m2",1,"p",136,"",0,["O8m2G1-p136B0.m",2]);
AGRTOC("O8m2",1,"p",765,"",0,["O8m2G1-p765B0.m",2]);
AGRTOC("O8m2",1,"p",1071,"",0,["O8m2G1-p1071B0.m",2]);
AGRTOC("O8m2",1,"p",1632,"",0,["O8m2G1-p1632B0.m",2]);
AGRTOC("O8m2",1,"p",24192,"",0,["O8m2G1-p24192B0.m",2]);
AGRTOC("O8m2",1,"p",45696,"",0,["O8m2G1-p45696B0.m",2]);
AGRTOC("O8m2",1,"f",2,8,"",0,["O8m2G1-f2r8B0.m",2]);
AGRTOC("O8m2",1,"f",2,26,"",0,["O8m2G1-f2r26B0.m",2]);
AGRTOC("O8m2",1,"f",2,48,"",0,["O8m2G1-f2r48B0.m",2]);
AGRTOC("O8m2",1,"f",3,34,"",0,["O8m2G1-f3r34B0.m",2]);
AGRTOC("O8m2",1,"f",3,50,"",0,["O8m2G1-f3r50B0.m",2]);
AGRTOC("O8m2",1,"f",4,8,"b",0,["O8m2G1-f4r8bB0.m",2]);
AGRTOC("O8m2",1,"f",4,8,"c",0,["O8m2G1-f4r8cB0.m",2]);
AGRTOC("O8m2",1,"f",4,48,"b",0,["O8m2G1-f4r48bB0.m",2]);
AGRTOC("O8m2",1,"f",4,48,"c",0,["O8m2G1-f4r48cB0.m",2]);
AGRTOC("O8m2",1,"f",5,34,"",0,["O8m2G1-f5r34B0.m",2]);
AGRTOC("O8m2",1,"f",5,51,"",0,["O8m2G1-f5r51B0.m",2]);
AGRTOC("O8m2",1,"f",5,84,"",0,["O8m2G1-f5r84B0.m",2]);
AGRTOC("O8m2",1,"f",7,33,"",0,["O8m2G1-f7r33B0.m",2]);
AGRTOC("O8m2",1,"f",7,51,"",0,["O8m2G1-f7r51B0.m",2]);
AGRTOC("O8m2",1,"f",7,84,"",0,["O8m2G1-f7r84B0.m",2]);
AGRTOC("O8m2",1,"f",17,34,"",0,["O8m2G1-f17r34B0.m",2]);
AGRTOC("O8m2",1,"f",17,51,"",0,["O8m2G1-f17r51B0.m",2]);
AGRTOC("O8m2",1,"f",17,83,"",0,["O8m2G1-f17r83B0.m",2]);
AGRTOC("O8m2",1,"C","O8m2G1-cycW1");

# O8m2d2
AGRGRP("clas","O8m2","O8m2d2");
AGRTOC("O8m2d2",1,"p",119,"",0,["O8m2d2G1-p119B0.m",2]);
AGRTOC("O8m2d2",1,"f",2,8,"",0,["O8m2d2G1-f2r8B0.m",2]);
AGRTOC("O8m2d2",1,"f",3,34,"",0,["O8m2d2G1-f3r34B0.m",2]);
AGRTOC("O8m2d2",1,"f",3,50,"",0,["O8m2d2G1-f3r50B0.m",2]);
AGRTOC("O8m2d2",1,"C","O8m2d2G1-cycW1");

# 2O8m3
AGRGRP("clas","O8m3","2O8m3");
AGRTOC("2O8m3",1,"f",3,16,"",0,["2O8m3G1-f3r16B0.m",2]);
AGRTOC("2O8m3",1,"f",9,8,"a",0,["2O8m3G1-f9r8aB0.m",2]);
AGRTOC("2O8m3",1,"f",9,8,"b",0,["2O8m3G1-f9r8bB0.m",2]);

# 2O8m3d2a
AGRGRP("clas","O8m3","2O8m3d2a");
AGRTOC("2O8m3d2a",1,"f",3,16,"",0,["2O8m3d2aG1-f3r16B0.m",2]);

# O8m3
AGRGRP("clas","O8m3","O8m3");
AGRTOC("O8m3",1,"p",1066,"",0,["O8m3G1-p1066B0.m",2]);
AGRTOC("O8m3",1,"f",3,8,"",0,["O8m3G1-f3r8B0.m",2]);

# O8m3D8
AGRGRP("clas","O8m3","O8m3D8");
AGRTOC("O8m3D8",1,"f",3,8,"",0,["O8m3D8G1-f3r8B0.m",2]);

# O8m3V4
AGRGRP("clas","O8m3","O8m3V4");
AGRTOC("O8m3V4",1,"p",1066,"",0,["O8m3V4G1-p1066B0.m",2]);
AGRTOC("O8m3V4",1,"f",3,16,"",0,["O8m3V4G1-f3r16B0.m",2]);

# O8m3d2a
AGRGRP("clas","O8m3","O8m3d2a");
AGRTOC("O8m3d2a",1,"p",1066,"",0,["O8m3d2aG1-p1066B0.m",2]);
AGRTOC("O8m3d2a",1,"f",3,8,"",0,["O8m3d2aG1-f3r8B0.m",2]);

# 2O93
AGRGRP("clas","O93","2O93");
AGRTOC("2O93",1,"f",3,16,"",0,["2O93G1-f3r16B0.m",2]);

# 2O93d2
AGRGRP("clas","O93","2O93d2");
AGRTOC("2O93d2",1,"f",3,16,"",0,["2O93d2G1-f3r16B0.m",2]);

# O93
AGRGRP("clas","O93","O93");
AGRTOC("O93",1,"f",3,9,"",0,["O93G1-f3r9B0.m",2]);

# O93d2
AGRGRP("clas","O93","O93d2");
AGRTOC("O93d2",1,"f",3,9,"",0,["O93d2G1-f3r9B0.m",2]);

# S102
AGRGRP("clas","S102","S102");
AGRTOC("S102",1,"p",496,"",0,["S102G1-p496B0.m",2]);
AGRTOC("S102",1,"p",528,"",0,["S102G1-p528B0.m",2]);
AGRTOC("S102",1,"p",992,"",0,["S102G1-p992B0.m",2]);
AGRTOC("S102",1,"p",1023,"",0,["S102G1-p1023B0.m",2]);
AGRTOC("S102",1,"p",1056,"",0,["S102G1-p1056B0.m",2]);
AGRTOC("S102",1,"f",2,10,"",0,["S102G1-f2r10B0.m",2]);
AGRTOC("S102",1,"f",2,32,"",0,["S102G1-f2r32B0.m",2]);
AGRTOC("S102",1,"f",2,44,"",0,["S102G1-f2r44B0.m",2]);
AGRTOC("S102",1,"f",2,100,"",0,["S102G1-f2r100B0.m",2]);
AGRTOC("S102",1,"f",2,164,"",0,["S102G1-f2r164B0.m",2]);
AGRTOC("S102",1,"f",3,155,"",0,["S102G1-f3r155B0.m",2]);
AGRTOC("S102",1,"f",5,155,"",0,["S102G1-f5r155B0.m",2]);
AGRTOC("S102",1,"f",7,155,"",0,["S102G1-f7r155B0.m",2]);
AGRTOC("S102",1,"f",11,155,"",0,["S102G1-f11r155B0.m",2]);
AGRTOC("S102",1,"f",17,155,"",0,["S102G1-f17r155B0.m",2]);
AGRTOC("S102",1,"f",31,155,"",0,["S102G1-f31r155B0.m",2]);

# S44
AGRGRP("clas","S44","S44");
AGRTOC("S44",1,"p",85,"a",0,["S44G1-p85aB0.m",2]);
AGRTOC("S44",1,"p",120,"b",0,["S44G1-p120bB0.m",2]);
AGRTOC("S44",1,"f",3,18,"",0,["S44G1-f3r18B0.m",2]);
AGRTOC("S44",1,"f",4,4,"c",0,["S44G1-f4r4cB0.m",2]);
AGRTOC("S44",1,"f",5,18,"",0,["S44G1-f5r18B0.m",2]);
AGRTOC("S44",1,"f",5,33,"b",0,["S44G1-f5r33bB0.m",2]);
AGRTOC("S44",1,"f",17,18,"",0,["S44G1-f17r18B0.m",2]);
AGRTOC("S44",1,"M",1,"S44G1-max1W1");
AGRTOC("S44",1,"M",2,"S44G1-max2W1");
AGRTOC("S44",1,"M",3,"S44G1-max3W1");
AGRTOC("S44",1,"M",4,"S44G1-max4W1");
AGRTOC("S44",1,"M",5,"S44G1-max5W1");
AGRTOC("S44",1,"M",6,"S44G1-max6W1");
AGRTOC("S44",1,"M",7,"S44G1-max7W1");

# S44d2
AGRGRP("clas","S44","S44d2");
AGRTOC("S44d2",1,"f",2,8,"a",0,["S44d2G1-f2r8aB0.m",2]);

# S44d4
AGRGRP("clas","S44","S44d4");
AGRTOC("S44d4",1,"f",2,16,"",0,["S44d4G1-f2r16B0.m",2]);

# 2S45
AGRGRP("clas","S45","2S45");
AGRTOC("2S45",1,"p",624,"",0,["2S45G1-p624B0.m",2]);
AGRTOC("2S45",1,"f",5,4,"",0,["2S45G1-f5r4B0.m",2]);

# S45
AGRGRP("clas","S45","S45");
AGRTOC("S45",1,"p",156,"a",0,["S45G1-p156aB0.m",2]);
AGRTOC("S45",1,"p",156,"b",0,["S45G1-p156bB0.m",2]);
AGRTOC("S45",1,"p",300,"",0,["S45G1-p300B0.m",2]);
AGRTOC("S45",1,"p",325,"",0,["S45G1-p325B0.m",2]);
AGRTOC("S45",1,"f",4,12,"a",0,["S45G1-f4r12aB0.m",2]);
AGRTOC("S45",1,"f",5,5,"",0,["S45G1-f5r5B0.m",2]);
AGRTOC("S45",1,"f",9,13,"",0,["S45G1-f9r13B0.m",2]);
AGRTOC("S45",1,"M",1,"S45G1-max1W1");
AGRTOC("S45",1,"M",2,"S45G1-max2W1");
AGRTOC("S45",1,"M",3,"S45G1-max3W1");
AGRTOC("S45",1,"M",4,"S45G1-max4W1");
AGRTOC("S45",1,"M",5,"S45G1-max5W1");
AGRTOC("S45",1,"M",6,"S45G1-max6W1");
AGRTOC("S45",1,"M",7,"S45G1-max7W1");
AGRTOC("S45",1,"M",8,"S45G1-max8W1");

# S45d2
AGRGRP("clas","S45","S45d2");
AGRTOC("S45d2",1,"f",2,24,"",0,["S45d2G1-f2r24B0.m",2]);
AGRTOC("S45d2",1,"f",2,40,"",0,["S45d2G1-f2r40B0.m",2]);
AGRTOC("S45d2",1,"f",2,64,"",0,["S45d2G1-f2r64B0.m",2]);
AGRTOC("S45d2",1,"f",2,104,"a",0,["S45d2G1-f2r104aB0.m",2]);
AGRTOC("S45d2",1,"f",2,104,"b",0,["S45d2G1-f2r104bB0.m",2]);
AGRTOC("S45d2",1,"f",3,26,"",0,["S45d2G1-f3r26B0.m",2]);
AGRTOC("S45d2",1,"f",5,5,"",0,["S45d2G1-f5r5B0.m",2]);

# 2S47
AGRGRP("clas","S47","2S47");
AGRTOC("2S47",1,"f",7,4,"",0,["2S47G1-f7r4B0.m",2]);

# 2S47d2
AGRGRP("clas","S47","2S47d2");
AGRTOC("2S47d2",1,"f",7,4,"",0,["2S47d2G1-f7r4B0.m",2]);

# S47
AGRGRP("clas","S47","S47");
AGRTOC("S47",1,"p",400,"a",0,["S47G1-p400aB0.m",2]);
AGRTOC("S47",1,"p",400,"b",0,["S47G1-p400bB0.m",2]);
AGRTOC("S47",1,"p",1176,"",0,["S47G1-p1176B0.m",2]);
AGRTOC("S47",1,"p",1225,"",0,["S47G1-p1225B0.m",2]);
AGRTOC("S47",1,"f",7,5,"",0,["S47G1-f7r5B0.m",2]);

# S47d2
AGRGRP("clas","S47","S47d2");
AGRTOC("S47d2",1,"p",400,"a",0,["S47d2G1-p400aB0.m",2]);
AGRTOC("S47d2",1,"p",400,"b",0,["S47d2G1-p400bB0.m",2]);
AGRTOC("S47d2",1,"f",7,5,"",0,["S47d2G1-f7r5B0.m",2]);

# 2S62
AGRGRP("clas","S62","2S62");
AGRTOC("2S62",1,"p",240,"a",0,["2S62G1-p240aB0.m",2]);
AGRTOC("2S62",1,"f",3,8,"",0,["2S62G1-f3r8B0.m",2]);
AGRTOC("2S62",1,"f",3,48,"",0,["2S62G1-f3r48B0.m",2]);
AGRTOC("2S62",1,"f",3,56,"a",0,["2S62G1-f3r56aB0.m",2]);
AGRTOC("2S62",1,"f",3,56,"b",0,["2S62G1-f3r56bB0.m",2]);
AGRTOC("2S62",1,"f",3,104,"",0,["2S62G1-f3r104B0.m",2]);
AGRTOC("2S62",1,"f",3,272,"",0,["2S62G1-f3r272B0.m",2]);
AGRTOC("2S62",1,"Zr",8,"",0,"2S62G1-Zr8B0.M");

# S62
AGRGRP("clas","S62","S62");
AGRTOC("S62",1,"p",28,"",0,["S62G1-p28B0.m",2]);
AGRTOC("S62",1,"p",36,"",0,["S62G1-p36B0.m",2]);
AGRTOC("S62",1,"p",63,"",0,["S62G1-p63B0.m",2]);
AGRTOC("S62",1,"p",120,"",0,["S62G1-p120B0.m",2]);
AGRTOC("S62",1,"p",135,"",0,["S62G1-p135B0.m",2]);
AGRTOC("S62",1,"p",315,"",0,["S62G1-p315B0.m",2]);
AGRTOC("S62",1,"p",336,"",0,["S62G1-p336B0.m",2]);
AGRTOC("S62",1,"p",960,"",0,["S62G1-p960B0.m",2]);
AGRTOC("S62",1,"f",2,6,"",0,["S62G1-f2r6B0.m",2]);
AGRTOC("S62",1,"f",2,8,"",0,["S62G1-f2r8B0.m",2]);
AGRTOC("S62",1,"f",2,14,"",0,["S62G1-f2r14B0.m",2]);
AGRTOC("S62",1,"f",2,48,"",0,["S62G1-f2r48B0.m",2]);
AGRTOC("S62",1,"f",2,64,"",0,["S62G1-f2r64B0.m",2]);
AGRTOC("S62",1,"f",2,112,"",0,["S62G1-f2r112B0.m",2]);
AGRTOC("S62",1,"f",2,512,"",0,["S62G1-f2r512B0.m",2]);
AGRTOC("S62",1,"f",3,7,"",0,["S62G1-f3r7B0.m",2]);
AGRTOC("S62",1,"f",3,21,"",0,["S62G1-f3r21B0.m",2]);
AGRTOC("S62",1,"f",3,27,"",0,["S62G1-f3r27B0.m",2]);
AGRTOC("S62",1,"f",3,34,"",0,["S62G1-f3r34B0.m",2]);
AGRTOC("S62",1,"f",3,35,"",0,["S62G1-f3r35B0.m",2]);
AGRTOC("S62",1,"f",3,91,"",0,["S62G1-f3r91B0.m",2]);
AGRTOC("S62",1,"f",3,98,"",0,["S62G1-f3r98B0.m",2]);
AGRTOC("S62",1,"f",3,189,"a",0,["S62G1-f3r189aB0.m",2]);
AGRTOC("S62",1,"f",3,189,"b",0,["S62G1-f3r189bB0.m",2]);
AGRTOC("S62",1,"f",3,189,"c",0,["S62G1-f3r189cB0.m",2]);
AGRTOC("S62",1,"f",3,196,"",0,["S62G1-f3r196B0.m",2]);
AGRTOC("S62",1,"f",3,405,"",0,["S62G1-f3r405B0.m",2]);
AGRTOC("S62",1,"Zr",7,"",0,"S62G1-Zr7B0.M");
AGRTOC("S62",1,"Zr",15,"",0,"S62G1-Zr15B0.M");
AGRTOC("S62",1,"Zr",27,"",0,"S62G1-Zr27B0.M");
AGRTOC("S62",1,"Zr",35,"b",0,"S62G1-Zr35bB0.M");
AGRTOC("S62",1,"C","S62G1-cclsW1");
AGRTOC("S62",1,"C","S62G1-cycW1");
AGRTOC("S62",1,"M",1,"S62G1-max1W1");
AGRTOC("S62",1,"M",2,"S62G1-max2W1");
AGRTOC("S62",1,"M",3,"S62G1-max3W1");
AGRTOC("S62",1,"M",4,"S62G1-max4W1");
AGRTOC("S62",1,"M",5,"S62G1-max5W1");
AGRTOC("S62",1,"M",6,"S62G1-max6W1");
AGRTOC("S62",1,"M",7,"S62G1-max7W1");
AGRTOC("S62",1,"M",8,"S62G1-max8W1");

# 2S63
AGRGRP("clas","S63","2S63");
AGRTOC("2S63",1,"f",3,6,"",0,["2S63G1-f3r6B0.m",2]);

# 2S63d2
AGRGRP("clas","S63","2S63d2");
AGRTOC("2S63d2",1,"p",728,"",0,["2S63d2G1-p728B0.m",2]);
AGRTOC("2S63d2",1,"f",3,6,"",0,["2S63d2G1-f3r6B0.m",2]);

# S63
AGRGRP("clas","S63","S63");
AGRTOC("S63",1,"p",364,"",0,["S63G1-p364B0.m",2]);
AGRTOC("S63",1,"p",1120,"",0,["S63G1-p1120B0.m",2]);
AGRTOC("S63",1,"p",3640,"",0,["S63G1-p3640B0.m",2]);
AGRTOC("S63",1,"p",7371,"",0,["S63G1-p7371B0.m",2]);
AGRTOC("S63",1,"f",4,13,"a",0,["S63G1-f4r13aB0.m",2]);
AGRTOC("S63",1,"M",1,"S63G1-max1W1");
AGRTOC("S63",1,"M",2,"S63G1-max2W1");
AGRTOC("S63",1,"M",4,"S63G1-max4W1");
AGRTOC("S63",1,"M",5,"S63G1-max5W1");
AGRTOC("S63",1,"M",6,"S63G1-max6W1");
AGRTOC("S63",1,"M",7,"S63G1-max7W1");
AGRTOC("S63",1,"M",8,"S63G1-max8W1");
AGRTOC("S63",1,"M",9,"S63G1-max9W1");
AGRTOC("S63",1,"M",10,"S63G1-max10W1");
AGRTOC("S63",1,"M",11,"S63G1-max11W1");

# S63d2
AGRGRP("clas","S63","S63d2");
AGRTOC("S63d2",1,"p",364,"",0,["S63d2G1-p364B0.m",2]);
AGRTOC("S63d2",1,"p",1120,"",0,["S63d2G1-p1120B0.m",2]);
AGRTOC("S63d2",1,"p",3640,"",0,["S63d2G1-p3640B0.m",2]);
AGRTOC("S63d2",1,"p",7371,"",0,["S63d2G1-p7371B0.m",2]);
AGRTOC("S63d2",1,"f",2,26,"",0,["S63d2G1-f2r26B0.m",2]);
AGRTOC("S63d2",1,"f",3,13,"",0,["S63d2G1-f3r13B0.m",2]);

# S82
AGRGRP("clas","S82","S82");
AGRTOC("S82",1,"p",120,"",0,["S82G1-p120B0.m",2]);
AGRTOC("S82",1,"p",136,"",0,["S82G1-p136B0.m",2]);
AGRTOC("S82",1,"p",240,"",0,["S82G1-p240B0.m",2]);
AGRTOC("S82",1,"p",255,"",0,["S82G1-p255B0.m",2]);
AGRTOC("S82",1,"p",272,"",0,["S82G1-p272B0.m",2]);
AGRTOC("S82",1,"p",2295,"",0,["S82G1-p2295B0.m",2]);
AGRTOC("S82",1,"p",5355,"",0,["S82G1-p5355B0.m",2]);
AGRTOC("S82",1,"f",2,8,"",0,["S82G1-f2r8B0.m",2]);
AGRTOC("S82",1,"f",2,16,"",0,["S82G1-f2r16B0.m",2]);
AGRTOC("S82",1,"f",2,26,"",0,["S82G1-f2r26B0.m",2]);
AGRTOC("S82",1,"f",2,48,"",0,["S82G1-f2r48B0.m",2]);
AGRTOC("S82",1,"f",3,35,"",0,["S82G1-f3r35B0.m",2]);
AGRTOC("S82",1,"f",3,50,"",0,["S82G1-f3r50B0.m",2]);
AGRTOC("S82",1,"f",5,35,"",0,["S82G1-f5r35B0.m",2]);
AGRTOC("S82",1,"f",5,51,"",0,["S82G1-f5r51B0.m",2]);
AGRTOC("S82",1,"f",7,35,"",0,["S82G1-f7r35B0.m",2]);
AGRTOC("S82",1,"f",7,51,"",0,["S82G1-f7r51B0.m",2]);
AGRTOC("S82",1,"f",17,35,"",0,["S82G1-f17r35B0.m",2]);
AGRTOC("S82",1,"f",17,51,"",0,["S82G1-f17r51B0.m",2]);
AGRTOC("S82",1,"Zr",35,"",0,"S82G1-Zr35B0.M");

# U311
AGRGRP("clas","U311","U311");
AGRTOC("U311",1,"M",1,"U311G1-max1W1");

# U33
AGRGRP("clas","U33","U33");
AGRTOC("U33",1,"p",28,"",0,["U33G1-p28B0.m",2]);
AGRTOC("U33",1,"p",36,"",0,["U33G1-p36B0.m",2]);
AGRTOC("U33",1,"p",63,"a",0,["U33G1-p63aB0.m",2]);
AGRTOC("U33",1,"p",63,"b",0,["U33G1-p63bB0.m",2]);
AGRTOC("U33",1,"f",2,6,"",0,["U33G1-f2r6B0.m",2]);
AGRTOC("U33",1,"f",2,14,"",0,["U33G1-f2r14B0.m",2]);
AGRTOC("U33",1,"f",2,32,"a",0,["U33G1-f2r32aB0.m",2]);
AGRTOC("U33",1,"f",2,32,"b",0,["U33G1-f2r32bB0.m",2]);
AGRTOC("U33",1,"f",3,7,"",0,["U33G1-f3r7B0.m",2]);
AGRTOC("U33",1,"f",3,27,"",0,["U33G1-f3r27B0.m",2]);
AGRTOC("U33",1,"f",7,6,"",0,["U33G1-f7r6B0.m",2]);
AGRTOC("U33",1,"f",7,7,"a",0,["U33G1-f7r7aB0.m",2]);
AGRTOC("U33",1,"f",7,14,"",0,["U33G1-f7r14B0.m",2]);
AGRTOC("U33",1,"f",7,21,"a",0,["U33G1-f7r21aB0.m",2]);
AGRTOC("U33",1,"f",7,26,"",0,["U33G1-f7r26B0.m",2]);
AGRTOC("U33",1,"f",9,3,"b",0,["U33G1-f9r3bB0.m",2]);
AGRTOC("U33",1,"f",9,6,"b",0,["U33G1-f9r6bB0.m",2]);
AGRTOC("U33",1,"f",9,15,"b",0,["U33G1-f9r15bB0.m",2]);
AGRTOC("U33",1,"f",49,7,"b",0,["U33G1-f49r7bB0.m",2]);
AGRTOC("U33",1,"f",49,21,"b",0,["U33G1-f49r21bB0.m",2]);
AGRTOC("U33",1,"f",49,28,"a",0,["U33G1-f49r28aB0.m",2]);

# U33d2
AGRGRP("clas","U33","U33d2");
AGRTOC("U33d2",1,"p",63,"b",0,["U33d2G1-p63bB0.m",2]);
AGRTOC("U33d2",1,"f",2,6,"",0,["U33d2G1-f2r6B0.m",2]);
AGRTOC("U33d2",1,"f",2,14,"",0,["U33d2G1-f2r14B0.m",2]);
AGRTOC("U33d2",1,"f",2,64,"",0,["U33d2G1-f2r64B0.m",2]);
AGRTOC("U33d2",1,"f",3,6,"",0,["U33d2G1-f3r6B0.m",2]);
AGRTOC("U33d2",1,"f",3,7,"",0,["U33d2G1-f3r7B0.m",2]);
AGRTOC("U33d2",1,"f",3,12,"",0,["U33d2G1-f3r12B0.m",2]);
AGRTOC("U33d2",1,"f",3,27,"",0,["U33d2G1-f3r27B0.m",2]);
AGRTOC("U33d2",1,"f",3,30,"",0,["U33d2G1-f3r30B0.m",2]);

# 2U42
AGRGRP("clas","U42","2U42");
AGRTOC("2U42",1,"p",80,"",0,["2U42G1-p80B0.m",2]);
AGRTOC("2U42",1,"p",240,"",0,["2U42G1-p240B0.m",2]);
AGRTOC("2U42",1,"f",3,4,"",0,["2U42G1-f3r4B0.m",2]);
AGRTOC("2U42",1,"f",3,16,"",0,["2U42G1-f3r16B0.m",2]);
AGRTOC("2U42",1,"f",3,40,"",0,["2U42G1-f3r40B0.m",2]);

# 2U42d2
AGRGRP("clas","U42","2U42d2");
AGRTOC("2U42d2",1,"p",240,"",0,["2U42d2G1-p240B0.m",2]);
AGRTOC("2U42d2",1,"f",3,4,"",0,["2U42d2G1-f3r4B0.m",2]);

# U42
AGRGRP("clas","U42","U42");
AGRTOC("U42",1,"p",27,"",0,["U42G1-p27B0.m",2]);
AGRTOC("U42",1,"p",36,"",0,["U42G1-p36B0.m",2]);
AGRTOC("U42",1,"p",40,"a",0,["U42G1-p40aB0.m",2]);
AGRTOC("U42",1,"p",40,"b",0,["U42G1-p40bB0.m",2]);
AGRTOC("U42",1,"p",45,"",0,["U42G1-p45B0.m",2]);
AGRTOC("U42",1,"f",3,5,"",0,["U42G1-f3r5B0.m",2]);
AGRTOC("U42",1,"f",3,10,"",0,["U42G1-f3r10B0.m",2]);
AGRTOC("U42",1,"f",3,14,"",0,["U42G1-f3r14B0.m",2]);
AGRTOC("U42",1,"f",3,25,"",0,["U42G1-f3r25B0.m",2]);
AGRTOC("U42",1,"f",3,81,"",0,["U42G1-f3r81B0.m",2]);
AGRTOC("U42",1,"f",4,4,"a",0,["U42G1-f4r4aB0.m",2]);
AGRTOC("U42",1,"f",5,6,"",0,["U42G1-f5r6B0.m",2]);
AGRTOC("U42",1,"f",25,5,"a",0,["U42G1-f25r5aB0.m",2]);
AGRTOC("U42",1,"f",25,10,"b",0,["U42G1-f25r10bB0.m",2]);

# U42d2
AGRGRP("clas","U42","U42d2");
AGRTOC("U42d2",1,"p",36,"",0,["U42d2G1-p36B0.m",2]);
AGRTOC("U42d2",1,"f",2,6,"",0,["U42d2G1-f2r6B0.m",2]);
AGRTOC("U42d2",1,"f",2,8,"",0,["U42d2G1-f2r8B0.m",2]);
AGRTOC("U42d2",1,"f",2,14,"",0,["U42d2G1-f2r14B0.m",2]);
AGRTOC("U42d2",1,"f",2,40,"",0,["U42d2G1-f2r40B0.m",2]);
AGRTOC("U42d2",1,"f",2,64,"",0,["U42d2G1-f2r64B0.m",2]);
AGRTOC("U42d2",1,"f",3,5,"",0,["U42d2G1-f3r5B0.m",2]);

# U72
AGRGRP("clas","U72","U72");
AGRTOC("U72",1,"p",2709,"",0,["U72G1-p2709B0.m",2]);
AGRTOC("U72",1,"p",2752,"",0,["U72G1-p2752B0.m",2]);
AGRTOC("U72",1,"f",4,7,"a",0,["U72G1-f4r7aB0.m",2]);
AGRTOC("U72",1,"M",1,"U72G1-max1W1");
AGRTOC("U72",1,"M",2,"U72G1-max2W1");
AGRTOC("U72",1,"M",7,"U72G1-max7W1");

# E62
AGRGRP("exc","E62","E62");
AGRTOC("E62",0,"f",2,27,"a",0,["E62G0-f2r27aB0.m",2]);
AGRTOC("E62",0,"f",2,27,"b",0,["E62G0-f2r27bB0.m",2]);
AGRTOC("E62",1,"f",2,27,"a",0,["E62G1-f2r27aB0.m",2]);
AGRTOC("E62",1,"f",2,27,"b",0,["E62G1-f2r27bB0.m",2]);
AGRTOC("E62",0,"f",2,78,"",0,["E62G0-f2r78B0.m",2]);
AGRTOC("E62",1,"f",2,78,"",0,["E62G1-f2r78B0.m",2]);

# 3E64
AGRGRP("exc","E64","3E64");
AGRTOC("3E64",0,"f",4,27,"",0,["3E64G0-f4r27B0.m",2]);

# 3E64d2
AGRGRP("exc","E64","3E64d2");
AGRTOC("3E64d2",0,"f",4,54,"",0,["3E64d2G0-f4r54B0.m",2]);

# E64
AGRGRP("exc","E64","E64");
AGRTOC("E64",0,"f",4,78,"",0,["E64G0-f4r78B0.m",2]);

# E72
AGRGRP("exc","E72","E72");
AGRTOC("E72",0,"f",2,56,"",0,["E72G0-f2r56B0.m",2]);
AGRTOC("E72",0,"f",2,132,"",0,["E72G0-f2r132B0.m",2]);

# E74
AGRGRP("exc","E74","E74");
AGRTOC("E74",0,"f",4,56,"a",0,["E74G0-f4r56aB0.m",2]);
AGRTOC("E74",0,"f",4,132,"a",0,["E74G0-f4r132aB0.m",2]);
AGRTOC("E74",0,"f",4,248,"a",0,["E74G0-f4r248aB0.m",2]);

# E82
AGRGRP("exc","E82","E82");
AGRTOC("E82",0,"f",2,248,"",0,["E82G0-f2r248B0.m",2]);
AGRTOC("E82",1,"f",2,248,"",0,["E82G1-f2r248B0.m",9]);

# E85
AGRGRP("exc","E85","E85");
AGRTOC("E85",0,"f",5,248,"",0,["E85G0-f5r248B0.m",2]);

# 2F42
AGRGRP("exc","F42","2F42");
AGRTOC("2F42",1,"p",139776,"",0,["2F42G1-p139776B0.m",2]);
AGRTOC("2F42",1,"f",3,52,"",0,["2F42G1-f3r52B0.m",2]);
AGRTOC("2F42",1,"f",3,2380,"",0,["2F42G1-f3r2380B0.m",2]);
AGRTOC("2F42",1,"f",5,52,"",0,["2F42G1-f5r52B0.m",2]);

# 2F42d2
AGRGRP("exc","F42","2F42d2");
AGRTOC("2F42d2",1,"f",25,52,"",0,["2F42d2G1-f25r52B0.m",2]);

# 2F42d4i
AGRGRP("exc","F42","2F42d4i");
AGRTOC("2F42d4i",1,"f",5,52,"",0,["2F42d4iG1-f5r52B0.m",2]);

# F42
AGRGRP("exc","F42","F42");
AGRTOC("F42",1,"p",69888,"a",0,["F42G1-p69888aB0.m",2]);
AGRTOC("F42",1,"f",2,26,"a",0,["F42G1-f2r26aB0.m",2]);
AGRTOC("F42",1,"M",3,"F42G1-max3W1");
AGRTOC("F42",1,"O","2","F42G1-aW1");

# F42d2
AGRGRP("exc","F42","F42d2");
AGRTOC("F42d2",1,"f",2,52,"",0,["F42d2G1-f2r52B0.m",2]);

# 3G23
AGRGRP("exc","G23","3G23");
AGRTOC("3G23",1,"p",1134,"",0,["3G23G1-p1134B0.m",2]);
AGRTOC("3G23",1,"f",4,27,"",0,["3G23G1-f4r27B0.m",2]);
AGRTOC("3G23",1,"f",7,27,"",0,["3G23G1-f7r27B0.m",2]);
AGRTOC("3G23",1,"f",13,27,"",0,["3G23G1-f13r27B0.m",2]);

# 3G23d2
AGRGRP("exc","G23","3G23d2");
AGRTOC("3G23d2",1,"f",2,54,"",0,["3G23d2G1-f2r54B0.m",2]);

# G23
AGRGRP("exc","G23","G23");
AGRTOC("G23",1,"f",2,14,"",0,["G23G1-f2r14B0.m",2]);
AGRTOC("G23",1,"f",2,78,"",0,["G23G1-f2r78B0.m",2]);
AGRTOC("G23",1,"f",2,90,"c",0,["G23G1-f2r90cB0.m",2]);
AGRTOC("G23",1,"f",2,90,"a",0,["G23G1-f2r90aB0.m",2]);
AGRTOC("G23",1,"f",2,90,"b",0,["G23G1-f2r90bB0.m",2]);
AGRTOC("G23",1,"f",2,378,"",0,["G23G1-f2r378B0.m",2]);
AGRTOC("G23",1,"f",3,7,"a",0,["G23G1-f3r7aB0.m",2]);
AGRTOC("G23",1,"f",3,7,"b",0,["G23G1-f3r7bB0.m",2]);
AGRTOC("G23",1,"f",3,27,"a",0,["G23G1-f3r27aB0.m",2]);
AGRTOC("G23",1,"f",3,27,"b",0,["G23G1-f3r27bB0.m",2]);
AGRTOC("G23",1,"f",3,49,"",0,["G23G1-f3r49B0.m",2]);
AGRTOC("G23",1,"f",3,189,"b",0,["G23G1-f3r189bB0.m",2]);
AGRTOC("G23",1,"f",3,189,"a",0,["G23G1-f3r189aB0.m",2]);
AGRTOC("G23",1,"f",3,729,"",0,["G23G1-f3r729B0.m",2]);
AGRTOC("G23",1,"f",4,64,"a",0,["G23G1-f4r64aB0.m",2]);
AGRTOC("G23",1,"f",4,64,"",0,["G23G1-f4r64B0.m",2]);
AGRTOC("G23",1,"C","G23G1-cycW1");
AGRTOC("G23",1,"M",1,"G23G1-max1W1");
AGRTOC("G23",1,"M",2,"G23G1-max2W1");
AGRTOC("G23",1,"M",3,"G23G1-max3W1");
AGRTOC("G23",1,"M",4,"G23G1-max4W1");
AGRTOC("G23",1,"M",5,"G23G1-max5W1");
AGRTOC("G23",1,"M",6,"G23G1-max6W1");
AGRTOC("G23",1,"M",7,"G23G1-max7W1");
AGRTOC("G23",1,"M",8,"G23G1-max8W1");
AGRTOC("G23",1,"M",9,"G23G1-max9W1");
AGRTOC("G23",1,"M",10,"G23G1-max10W1");
AGRTOC("G23",1,"O","2","G23G1-aW1");

# G23d2
AGRGRP("exc","G23","G23d2");
AGRTOC("G23d2",1,"p",756,"",0,["G23d2G1-p756B0.m",2]);
AGRTOC("G23d2",1,"f",2,14,"",0,["G23d2G1-f2r14B0.m",2]);
AGRTOC("G23d2",1,"f",3,14,"",0,["G23d2G1-f3r14B0.m",2]);
AGRTOC("G23d2",1,"f",7,14,"",0,["G23d2G1-f7r14B0.m",2]);
AGRTOC("G23d2",1,"f",13,14,"",0,["G23d2G1-f13r14B0.m",2]);
AGRTOC("G23d2",1,"f",13,434,"a",0,["G23d2G1-f13r434aB0.m",2]);
AGRTOC("G23d2",1,"C","G23d2G1-cycW1");

# 2G24
AGRGRP("exc","G24","2G24");
AGRTOC("2G24",1,"f",3,12,"",0,["2G24G1-f3r12B0.m",2]);
AGRTOC("2G24",1,"f",5,12,"",0,["2G24G1-f5r12B0.m",2]);
AGRTOC("2G24",1,"f",5,92,"",0,["2G24G1-f5r92B0.m",2]);
AGRTOC("2G24",1,"f",7,12,"",0,["2G24G1-f7r12B0.m",2]);
AGRTOC("2G24",1,"f",13,12,"",0,["2G24G1-f13r12B0.m",2]);

# 2G24d2
AGRGRP("exc","G24","2G24d2");
AGRTOC("2G24d2",1,"f",7,12,"",0,["2G24d2G1-f7r12B0.m",2]);
AGRTOC("2G24d2",1,"f",9,12,"",0,["2G24d2G1-f9r12B0.m",2]);
AGRTOC("2G24d2",1,"f",25,12,"",0,["2G24d2G1-f25r12B0.m",2]);
AGRTOC("2G24d2",1,"f",169,12,"",0,["2G24d2G1-f169r12B0.m",2]);

# 2G24d2i
AGRGRP("exc","G24","2G24d2i");
AGRTOC("2G24d2i",1,"f",3,12,"",0,["2G24d2iG1-f3r12B0.m",2]);

# G24
AGRGRP("exc","G24","G24");
AGRTOC("G24",1,"p",416,"",0,["G24G1-p416B0.m",2]);
AGRTOC("G24",1,"p",1365,"a",0,["G24G1-p1365aB0.m",2]);
AGRTOC("G24",1,"p",1365,"b",0,["G24G1-p1365bB0.m",2]);
AGRTOC("G24",1,"p",2016,"",0,["G24G1-p2016B0.m",2]);
AGRTOC("G24",1,"p",2080,"",0,["G24G1-p2080B0.m",2]);
AGRTOC("G24",1,"p",20800,"",0,["G24G1-p20800B0.m",2]);
AGRTOC("G24",1,"f",3,64,"",0,["G24G1-f3r64B0.m",2]);
AGRTOC("G24",1,"f",3,78,"",0,["G24G1-f3r78B0.m",2]);
AGRTOC("G24",1,"f",3,286,"",0,["G24G1-f3r286B0.m",2]);
AGRTOC("G24",1,"f",4,6,"a",0,["G24G1-f4r6aB0.m",2]);
AGRTOC("G24",1,"f",5,65,"",0,["G24G1-f5r65B0.m",2]);
AGRTOC("G24",1,"f",5,78,"",0,["G24G1-f5r78B0.m",2]);
AGRTOC("G24",1,"f",5,350,"",0,["G24G1-f5r350B0.m",2]);
AGRTOC("G24",1,"f",5,363,"a",0,["G24G1-f5r363aB0.m",2]);
AGRTOC("G24",1,"f",5,650,"",0,["G24G1-f5r650B0.m",2]);
AGRTOC("G24",1,"f",7,65,"",0,["G24G1-f7r65B0.m",2]);
AGRTOC("G24",1,"f",7,78,"",0,["G24G1-f7r78B0.m",2]);
AGRTOC("G24",1,"f",13,65,"",0,["G24G1-f13r65B0.m",2]);
AGRTOC("G24",1,"f",13,78,"",0,["G24G1-f13r78B0.m",2]);
AGRTOC("G24",1,"C","G24G1-cycW1");
AGRTOC("G24",1,"M",1,"G24G1-max1W1");
AGRTOC("G24",1,"M",2,"G24G1-max2W1");
AGRTOC("G24",1,"M",3,"G24G1-max3W1");
AGRTOC("G24",1,"M",4,"G24G1-max4W1");
AGRTOC("G24",1,"M",5,"G24G1-max5W1");
AGRTOC("G24",1,"M",6,"G24G1-max6W1");
AGRTOC("G24",1,"M",7,"G24G1-max7W1");
AGRTOC("G24",1,"M",8,"G24G1-max8W1");
AGRTOC("G24",1,"O","2","G24G1-aW1");

# G24d2
AGRGRP("exc","G24","G24d2");
AGRTOC("G24d2",1,"f",2,12,"",0,["G24d2G1-f2r12B0.m",2]);
AGRTOC("G24d2",1,"f",2,28,"",0,["G24d2G1-f2r28B0.m",2]);
AGRTOC("G24d2",1,"f",2,36,"",0,["G24d2G1-f2r36B0.m",2]);
AGRTOC("G24d2",1,"f",2,128,"",0,["G24d2G1-f2r128B0.m",2]);
AGRTOC("G24d2",1,"f",2,168,"",0,["G24d2G1-f2r168B0.m",2]);
AGRTOC("G24d2",1,"f",2,196,"",0,["G24d2G1-f2r196B0.m",2]);
AGRTOC("G24d2",1,"f",3,64,"",0,["G24d2G1-f3r64B0.m",2]);
AGRTOC("G24d2",1,"f",5,65,"",0,["G24d2G1-f5r65B0.m",2]);
AGRTOC("G24d2",1,"f",7,65,"",0,["G24d2G1-f7r65B0.m",2]);
AGRTOC("G24d2",1,"f",13,65,"",0,["G24d2G1-f13r65B0.m",2]);
AGRTOC("G24d2",1,"C","G24d2G1-cycW1");

# G25
AGRGRP("exc","G25","G25");
AGRTOC("G25",1,"p",3906,"a",0,["G25G1-p3906aB0.m",2]);
AGRTOC("G25",1,"p",3906,"b",0,["G25G1-p3906bB0.m",2]);
AGRTOC("G25",1,"p",7750,"",0,["G25G1-p7750B0.m",2]);
AGRTOC("G25",1,"p",7875,"",0,["G25G1-p7875B0.m",2]);
AGRTOC("G25",1,"f",2,124,"",0,["G25G1-f2r124B0.m",2]);
AGRTOC("G25",1,"f",3,124,"",0,["G25G1-f3r124B0.m",2]);
AGRTOC("G25",1,"f",3,651,"",0,["G25G1-f3r651B0.m",2]);
AGRTOC("G25",1,"f",5,7,"",0,["G25G1-f5r7B0.m",2]);
AGRTOC("G25",1,"f",5,14,"",0,["G25G1-f5r14B0.m",2]);
AGRTOC("G25",1,"f",5,27,"",0,["G25G1-f5r27B0.m",2]);
AGRTOC("G25",1,"f",5,64,"",0,["G25G1-f5r64B0.m",2]);
AGRTOC("G25",1,"f",5,77,"a",0,["G25G1-f5r77aB0.m",2]);
AGRTOC("G25",1,"f",5,77,"b",0,["G25G1-f5r77bB0.m",2]);
AGRTOC("G25",1,"f",5,97,"",0,["G25G1-f5r97B0.m",2]);
AGRTOC("G25",1,"C","G25G1-cycW1");
AGRTOC("G25",1,"M",1,"G25G1-max1W1");
AGRTOC("G25",1,"M",2,"G25G1-max2W1");
AGRTOC("G25",1,"M",3,"G25G1-max3W1");
AGRTOC("G25",1,"M",4,"G25G1-max4W1");
AGRTOC("G25",1,"M",5,"G25G1-max5W1");
AGRTOC("G25",1,"M",6,"G25G1-max6W1");
AGRTOC("G25",1,"M",7,"G25G1-max7W1");

# R27
AGRGRP("exc","R27","R27");
AGRTOC("R27",1,"p",19684,"",0,["R27G1-p19684B0.m",2]);
AGRTOC("R27",1,"f",2,702,"",0,["R27G1-f2r702B0.m",2]);
AGRTOC("R27",1,"f",27,7,"a",0,["R27G1-f27r7aB0.m",2]);
AGRTOC("R27",1,"C","R27G1-cycW1");
AGRTOC("R27",1,"M",1,"R27G1-max1W1");
AGRTOC("R27",1,"M",2,"R27G1-max2W1");
AGRTOC("R27",1,"M",3,"R27G1-max3W1");
AGRTOC("R27",1,"M",4,"R27G1-max4W1");
AGRTOC("R27",1,"M",5,"R27G1-max5W1");
AGRTOC("R27",1,"M",6,"R27G1-max6W1");

# R27d3
AGRGRP("exc","R27","R27d3");
AGRTOC("R27d3",1,"p",19684,"",0,["R27d3G1-p19684B0.m",2]);
AGRTOC("R27d3",1,"f",2,702,"",0,["R27d3G1-f2r702B0.m",2]);
AGRTOC("R27d3",1,"f",3,21,"",0,["R27d3G1-f3r21B0.m",2]);
AGRTOC("R27d3",1,"C","R27d3G1-cycW1");
AGRTOC("R27d3",1,"M",1,"R27d3G1-max1W1");
AGRTOC("R27d3",1,"M",2,"R27d3G1-max2W1");
AGRTOC("R27d3",1,"M",5,"R27d3G1-max5W1");
AGRTOC("R27d3",1,"M",6,"R27d3G1-max6W1");

# Sz32
AGRGRP("exc","Sz32","Sz32");
AGRTOC("Sz32",1,"p",1025,"",0,["Sz32G1-p1025B0.m",2]);
AGRTOC("Sz32",1,"p",198400,"",0,["Sz32G1-p198400B0.m",2]);
AGRTOC("Sz32",1,"f",5,124,"a",0,["Sz32G1-f5r124aB0.m",2]);
AGRTOC("Sz32",1,"f",32,4,"a",0,["Sz32G1-f32r4aB0.m",2]);
AGRTOC("Sz32",1,"f",41,124,"b",0,["Sz32G1-f41r124bB0.m",2]);
AGRTOC("Sz32",1,"C","Sz32G1-cycW1");
AGRTOC("Sz32",1,"M",1,"Sz32G1-max1W1");
AGRTOC("Sz32",1,"M",2,"Sz32G1-max2W1");
AGRTOC("Sz32",1,"M",3,"Sz32G1-max3W1");
AGRTOC("Sz32",1,"M",4,"Sz32G1-max4W1");

# Sz32d5
AGRGRP("exc","Sz32","Sz32d5");
AGRTOC("Sz32d5",1,"p",1025,"",0,["Sz32d5G1-p1025B0.m",2]);
AGRTOC("Sz32d5",1,"f",2,20,"",0,["Sz32d5G1-f2r20B0.m",2]);
AGRTOC("Sz32d5",1,"f",5,124,"",0,["Sz32d5G1-f5r124B0.m",2]);
AGRTOC("Sz32d5",1,"f",5,248,"",0,["Sz32d5G1-f5r248B0.m",2]);
AGRTOC("Sz32d5",1,"f",41,124,"",0,["Sz32d5G1-f41r124B0.m",2]);
AGRTOC("Sz32d5",1,"C","Sz32d5G1-cycW1");

# 2Sz8
AGRGRP("exc","Sz8","2Sz8");
AGRTOC("2Sz8",1,"p",1040,"",0,["2Sz8G1-p1040B0.m",2]);
AGRTOC("2Sz8",1,"f",2,128,"",0,["2Sz8G1-f2r128B0.m",2]);
AGRTOC("2Sz8",1,"f",5,8,"",0,["2Sz8G1-f5r8B0.m",2]);
AGRTOC("2Sz8",1,"f",7,40,"",0,["2Sz8G1-f7r40B0.m",2]);
AGRTOC("2Sz8",1,"f",13,16,"",0,["2Sz8G1-f13r16B0.m",2]);
AGRTOC("2Sz8",1,"f",13,24,"",0,["2Sz8G1-f13r24B0.m",2]);

# 4Sz8d3
AGRGRP("exc","Sz8","4Sz8d3");
AGRTOC("4Sz8d3",1,"f",5,24,"",0,["4Sz8d3G1-f5r24B0.m",2]);
AGRTOC("4Sz8d3",1,"f",7,120,"",0,["4Sz8d3G1-f7r120B0.m",2]);
AGRTOC("4Sz8d3",1,"f",13,48,"",0,["4Sz8d3G1-f13r48B0.m",2]);

# Sz8
AGRGRP("exc","Sz8","Sz8");
AGRTOC("Sz8",1,"p",65,"",0,["Sz8G1-p65B0.m",2]);
AGRTOC("Sz8",1,"p",560,"",0,["Sz8G1-p560B0.m",2]);
AGRTOC("Sz8",1,"p",1456,"",0,["Sz8G1-p1456B0.m",2]);
AGRTOC("Sz8",1,"p",2080,"",0,["Sz8G1-p2080B0.m",2]);
AGRTOC("Sz8",1,"f",2,64,"",0,["Sz8G1-f2r64B0.m",2]);
AGRTOC("Sz8",1,"f",5,14,"a",0,["Sz8G1-f5r14aB0.m",2]);
AGRTOC("Sz8",1,"f",5,35,"c",0,["Sz8G1-f5r35cB0.m",2]);
AGRTOC("Sz8",1,"f",5,35,"a",0,["Sz8G1-f5r35aB0.m",2]);
AGRTOC("Sz8",1,"f",5,35,"b",0,["Sz8G1-f5r35bB0.m",2]);
AGRTOC("Sz8",1,"f",5,63,"",0,["Sz8G1-f5r63B0.m",2]);
AGRTOC("Sz8",1,"f",7,64,"",0,["Sz8G1-f7r64B0.m",2]);
AGRTOC("Sz8",1,"f",7,91,"",0,["Sz8G1-f7r91B0.m",2]);
AGRTOC("Sz8",1,"f",7,105,"",0,["Sz8G1-f7r105B0.m",2]);
AGRTOC("Sz8",1,"f",8,4,"a",0,["Sz8G1-f8r4aB0.m",2]);
AGRTOC("Sz8",1,"f",8,16,"a",0,["Sz8G1-f8r16aB0.m",2]);
AGRTOC("Sz8",1,"f",13,14,"a",0,["Sz8G1-f13r14aB0.m",2]);
AGRTOC("Sz8",1,"f",13,14,"b",0,["Sz8G1-f13r14bB0.m",2]);
AGRTOC("Sz8",1,"f",13,35,"",0,["Sz8G1-f13r35B0.m",2]);
AGRTOC("Sz8",1,"f",13,65,"a",0,["Sz8G1-f13r65aB0.m",2]);
AGRTOC("Sz8",1,"f",13,65,"b",0,["Sz8G1-f13r65bB0.m",2]);
AGRTOC("Sz8",1,"f",13,65,"c",0,["Sz8G1-f13r65cB0.m",2]);
AGRTOC("Sz8",1,"f",13,91,"",0,["Sz8G1-f13r91B0.m",2]);
AGRTOC("Sz8",1,"f",49,14,"a",0,["Sz8G1-f49r14aB0.m",2]);
AGRTOC("Sz8",1,"f",125,65,"a",0,["Sz8G1-f125r65aB0.m",2]);
AGRTOC("Sz8",1,"M",1,"Sz8G1-max1W1");
AGRTOC("Sz8",1,"M",2,"Sz8G1-max2W1");
AGRTOC("Sz8",1,"M",3,"Sz8G1-max3W1");
AGRTOC("Sz8",1,"M",4,"Sz8G1-max4W1");

# Sz8d3
AGRGRP("exc","Sz8","Sz8d3");
AGRTOC("Sz8d3",1,"f",2,12,"",0,["Sz8d3G1-f2r12B0.m",2]);
AGRTOC("Sz8d3",1,"f",2,48,"",0,["Sz8d3G1-f2r48B0.m",2]);
AGRTOC("Sz8d3",1,"f",2,64,"",0,["Sz8d3G1-f2r64B0.m",2]);
AGRTOC("Sz8d3",1,"f",5,14,"",0,["Sz8d3G1-f5r14B0.m",2]);
AGRTOC("Sz8d3",1,"f",13,14,"",0,["Sz8d3G1-f13r14B0.m",2]);
AGRTOC("Sz8d3",1,"f",49,14,"",0,["Sz8d3G1-f49r14B0.m",2]);
AGRTOC("Sz8d3",1,"M",1,"Sz8d3G1-max1W1");
AGRTOC("Sz8d3",1,"M",2,"Sz8d3G1-max2W1");
AGRTOC("Sz8d3",1,"M",3,"Sz8d3G1-max3W1");
AGRTOC("Sz8d3",1,"M",4,"Sz8d3G1-max4W1");
AGRTOC("Sz8d3",1,"M",5,"Sz8d3G1-max5W1");

# TD42
AGRGRP("exc","TD42","TD42");
AGRTOC("TD42",1,"p",819,"",0,["TD42G1-p819B0.m",2]);
AGRTOC("TD42",1,"f",2,26,"",0,["TD42G1-f2r26B0.m",2]);
AGRTOC("TD42",1,"f",3,25,"",0,["TD42G1-f3r25B0.m",2]);
AGRTOC("TD42",1,"f",3,52,"",0,["TD42G1-f3r52B0.m",2]);
AGRTOC("TD42",1,"f",7,26,"",0,["TD42G1-f7r26B0.m",2]);
AGRTOC("TD42",1,"f",7,298,"",0,["TD42G1-f7r298B0.m",2]);
AGRTOC("TD42",1,"f",8,8,"a",0,["TD42G1-f8r8aB0.m",2]);
AGRTOC("TD42",1,"f",13,26,"",0,["TD42G1-f13r26B0.m",2]);
AGRTOC("TD42",1,"C","TD42G1-cycW1");
AGRTOC("TD42",1,"M",1,"TD42G1-max1W1");
AGRTOC("TD42",1,"M",2,"TD42G1-max2W1");
AGRTOC("TD42",1,"M",3,"TD42G1-max3W1");
AGRTOC("TD42",1,"M",4,"TD42G1-max4W1");
AGRTOC("TD42",1,"M",5,"TD42G1-max5W1");
AGRTOC("TD42",1,"M",6,"TD42G1-max6W1");
AGRTOC("TD42",1,"M",7,"TD42G1-max7W1");
AGRTOC("TD42",1,"M",8,"TD42G1-max8W1");
AGRTOC("TD42",1,"M",9,"TD42G1-max9W1");
AGRTOC("TD42",1,"O","2","TD42G1-aW1");

# TD42d3
AGRGRP("exc","TD42","TD42d3");
AGRTOC("TD42d3",1,"f",2,24,"",0,["TD42d3G1-f2r24B0.m",2]);
AGRTOC("TD42d3",1,"f",2,26,"",0,["TD42d3G1-f2r26B0.m",2]);
AGRTOC("TD42d3",1,"f",2,144,"",0,["TD42d3G1-f2r144B0.m",2]);
AGRTOC("TD42d3",1,"f",3,52,"",0,["TD42d3G1-f3r52B0.m",2]);
AGRTOC("TD42d3",1,"f",3,196,"",0,["TD42d3G1-f3r196B0.m",2]);
AGRTOC("TD42d3",1,"f",13,26,"a",0,["TD42d3G1-f13r26aB0.m",2]);
AGRTOC("TD42d3",1,"C","TD42d3G1-cycW1");
AGRTOC("TD42d3",1,"M",4,"TD42d3G1-max4W1");

# TD43
AGRGRP("exc","TD43","TD43");
AGRTOC("TD43",1,"p",26572,"",0,["TD43G1-p26572B0.m",2]);
AGRTOC("TD43",1,"f",2,218,"",0,["TD43G1-f2r218B0.m",2]);
AGRTOC("TD43",1,"f",27,8,"a",0,["TD43G1-f27r8aB0.m",2]);

# 2TE62
AGRGRP("exc","TE62","2TE62");
AGRTOC("2TE62",1,"f",2,1704,"",0,["2TE62G1-f2r1704B0.m",2]);

# 2TE62d2
AGRGRP("exc","TE62","2TE62d2");
AGRTOC("2TE62d2",1,"f",2,1705,"",0,["2TE62d2G1-f2r1705B0.m",2]);
AGRTOC("2TE62d2",1,"f",3,2432,"",0,["2TE62d2G1-f3r2432B0.m",2]);

# 3TE62
AGRGRP("exc","TE62","3TE62");
AGRTOC("3TE62",1,"f",4,27,"",0,["3TE62G1-f4r27B0.m",2]);

# 3TE62S3
AGRGRP("exc","TE62","3TE62S3");
AGRTOC("3TE62S3",0,"f",2,54,"",0,["3TE62S3G0-f2r54B0.m",2]);

# 3TE62d2
AGRGRP("exc","TE62","3TE62d2");
AGRTOC("3TE62d2",1,"f",2,54,"",0,["3TE62d2G1-f2r54B0.m",2]);

# 3TE62d3
AGRGRP("exc","TE62","3TE62d3");
AGRTOC("3TE62d3",0,"f",4,27,"",0,["3TE62d3G0-f4r27B0.m",2]);

# 4TE62
AGRGRP("exc","TE62","4TE62");
AGRTOC("4TE62",1,"f",2,1706,"",0,["4TE62G1-f2r1706B0.m",2]);

# TE62
AGRGRP("exc","TE62","TE62");
AGRTOC("TE62",1,"f",2,78,"",0,["TE62G1-f2r78B0.m",2]);
AGRTOC("TE62",1,"O","2","TE62G1-a2W1");
AGRTOC("TE62",1,"O","3","TE62G1-a3W1");

# TE62S3
AGRGRP("exc","TE62","TE62S3");
AGRTOC("TE62S3",0,"f",2,78,"",0,["TE62S3G0-f2r78B0.m",2]);

# TE62d2
AGRGRP("exc","TE62","TE62d2");
AGRTOC("TE62d2",1,"f",2,78,"",0,["TE62d2G1-f2r78B0.m",2]);
AGRTOC("TE62d2",1,"f",3,1938,"",0,["TE62d2G1-f3r1938B0.m",2]);

# TE62d3
AGRGRP("exc","TE62","TE62d3");
AGRTOC("TE62d3",0,"f",2,78,"",0,["TE62d3G0-f2r78B0.m",2]);

# TF42
AGRGRP("exc","TF42","TF42");
AGRTOC("TF42",1,"p",1600,"",0,["TF42G1-p1600B0.m",2]);
AGRTOC("TF42",1,"p",1755,"",0,["TF42G1-p1755B0.m",2]);
AGRTOC("TF42",1,"p",2304,"",0,["TF42G1-p2304B0.m",2]);
AGRTOC("TF42",1,"p",2925,"",0,["TF42G1-p2925B0.m",2]);
AGRTOC("TF42",1,"p",12480,"",0,["TF42G1-p12480B0.m",2]);
AGRTOC("TF42",1,"p",14976,"",0,["TF42G1-p14976B0.m",2]);
AGRTOC("TF42",1,"f",2,26,"",0,["TF42G1-f2r26B0.m",2]);
AGRTOC("TF42",1,"f",2,246,"",0,["TF42G1-f2r246B0.m",2]);
AGRTOC("TF42",1,"f",3,26,"a",0,["TF42G1-f3r26aB0.m",2]);
AGRTOC("TF42",1,"f",3,26,"b",0,["TF42G1-f3r26bB0.m",2]);
AGRTOC("TF42",1,"f",3,54,"",0,["TF42G1-f3r54B0.m",2]);
AGRTOC("TF42",1,"f",3,77,"",0,["TF42G1-f3r77B0.m",2]);
AGRTOC("TF42",1,"f",3,124,"b",0,["TF42G1-f3r124bB0.m",2]);
AGRTOC("TF42",1,"f",3,124,"a",0,["TF42G1-f3r124aB0.m",2]);
AGRTOC("TF42",1,"f",4,2048,"a",0,["TF42G1-f4r2048aB0.m",2]);
AGRTOC("TF42",1,"f",5,27,"b",0,["TF42G1-f5r27bB0.m",2]);
AGRTOC("TF42",1,"f",5,27,"a",0,["TF42G1-f5r27aB0.m",2]);
AGRTOC("TF42",1,"f",5,52,"",0,["TF42G1-f5r52B0.m",2]);
AGRTOC("TF42",1,"f",5,78,"",0,["TF42G1-f5r78B0.m",2]);
AGRTOC("TF42",1,"f",5,218,"",0,["TF42G1-f5r218B0.m",2]);
AGRTOC("TF42",1,"f",9,27,"b",0,["TF42G1-f9r27bB0.m",2]);
AGRTOC("TF42",1,"f",9,27,"a",0,["TF42G1-f9r27aB0.m",2]);
AGRTOC("TF42",1,"f",13,27,"a",0,["TF42G1-f13r27aB0.m",2]);
AGRTOC("TF42",1,"f",13,27,"b",0,["TF42G1-f13r27bB0.m",2]);
AGRTOC("TF42",1,"f",13,52,"",0,["TF42G1-f13r52B0.m",2]);
AGRTOC("TF42",1,"f",13,78,"",0,["TF42G1-f13r78B0.m",2]);
AGRTOC("TF42",1,"f",25,26,"b",0,["TF42G1-f25r26bB0.m",2]);
AGRTOC("TF42",1,"f",25,26,"a",0,["TF42G1-f25r26aB0.m",2]);
AGRTOC("TF42",1,"f",25,109,"a",0,["TF42G1-f25r109aB0.m",2]);
AGRTOC("TF42",1,"f",25,109,"b",0,["TF42G1-f25r109bB0.m",2]);
AGRTOC("TF42",1,"f",169,26,"",0,["TF42G1-f169r26B0.m",2]);
AGRTOC("TF42",1,"C","TF42G1-cycW1");
AGRTOC("TF42",1,"M",1,"TF42G1-max1W1");
AGRTOC("TF42",1,"M",2,"TF42G1-max2W1");
AGRTOC("TF42",1,"M",3,"TF42G1-max3W1");
AGRTOC("TF42",1,"M",4,"TF42G1-max4W1");
AGRTOC("TF42",1,"M",5,"TF42G1-max5W1");
AGRTOC("TF42",1,"M",6,"TF42G1-max6W1");
AGRTOC("TF42",1,"M",7,"TF42G1-max7W1");
AGRTOC("TF42",1,"M",8,"TF42G1-max8W1");

# TF42d2
AGRGRP("exc","TF42","TF42d2");
AGRTOC("TF42d2",1,"p",1755,"",0,["TF42d2G1-p1755B0.m",2]);
AGRTOC("TF42d2",1,"p",2304,"",0,["TF42d2G1-p2304B0.m",2]);
AGRTOC("TF42d2",1,"f",2,26,"",0,["TF42d2G1-f2r26B0.m",2]);
AGRTOC("TF42d2",1,"f",2,246,"",0,["TF42d2G1-f2r246B0.m",2]);
AGRTOC("TF42d2",1,"f",3,52,"",0,["TF42d2G1-f3r52B0.m",2]);
AGRTOC("TF42d2",1,"f",3,54,"",0,["TF42d2G1-f3r54B0.m",2]);
AGRTOC("TF42d2",1,"f",3,77,"",0,["TF42d2G1-f3r77B0.m",2]);
AGRTOC("TF42d2",1,"f",5,27,"",0,["TF42d2G1-f5r27B0.m",2]);
AGRTOC("TF42d2",1,"f",5,52,"",0,["TF42d2G1-f5r52B0.m",2]);
AGRTOC("TF42d2",1,"f",5,78,"",0,["TF42d2G1-f5r78B0.m",2]);
AGRTOC("TF42d2",1,"f",5,218,"",0,["TF42d2G1-f5r218B0.m",2]);
AGRTOC("TF42d2",1,"f",13,27,"a",0,["TF42d2G1-f13r27aB0.m",2]);
AGRTOC("TF42d2",1,"f",13,27,"b",0,["TF42d2G1-f13r27bB0.m",2]);
AGRTOC("TF42d2",1,"f",13,78,"",0,["TF42d2G1-f13r78B0.m",2]);
AGRTOC("TF42d2",1,"f",13,1374,"",0,["TF42d2G1-f13r1374B0.m",2]);
AGRTOC("TF42d2",1,"M",1,"TF42d2G1-max1W1");

# L28
AGRGRP("lin","L28","L28");
AGRTOC("L28",1,"p",9,"",0,["L28G1-p9B0.m",2]);
AGRTOC("L28",1,"p",28,"",0,["L28G1-p28B0.m",2]);
AGRTOC("L28",1,"p",36,"",0,["L28G1-p36B0.m",2]);
AGRTOC("L28",1,"f",2,6,"",0,["L28G1-f2r6B0.m",2]);
AGRTOC("L28",1,"f",2,8,"",0,["L28G1-f2r8B0.m",2]);
AGRTOC("L28",1,"f",2,12,"",0,["L28G1-f2r12B0.m",2]);
AGRTOC("L28",1,"f",3,7,"",0,["L28G1-f3r7B0.m",2]);
AGRTOC("L28",1,"f",3,27,"",0,["L28G1-f3r27B0.m",2]);
AGRTOC("L28",1,"f",7,7,"a",0,["L28G1-f7r7aB0.m",2]);
AGRTOC("L28",1,"f",7,8,"",0,["L28G1-f7r8B0.m",2]);
AGRTOC("L28",1,"f",7,21,"",0,["L28G1-f7r21B0.m",2]);
AGRTOC("L28",1,"f",8,2,"b",0,["L28G1-f8r2bB0.m",2]);
AGRTOC("L28",1,"f",8,2,"c",0,["L28G1-f8r2cB0.m",2]);
AGRTOC("L28",1,"f",8,2,"a",0,["L28G1-f8r2aB0.m",2]);
AGRTOC("L28",1,"f",8,4,"a",0,["L28G1-f8r4aB0.m",2]);
AGRTOC("L28",1,"f",8,4,"c",0,["L28G1-f8r4cB0.m",2]);
AGRTOC("L28",1,"f",8,4,"b",0,["L28G1-f8r4bB0.m",2]);
AGRTOC("L28",1,"f",27,9,"b",0,["L28G1-f27r9bB0.m",2]);
AGRTOC("L28",1,"f",27,9,"c",0,["L28G1-f27r9cB0.m",2]);
AGRTOC("L28",1,"f",27,9,"a",0,["L28G1-f27r9aB0.m",2]);
AGRTOC("L28",1,"Zr",8,"",0,"L28G1-Zr8B0.M");
AGRTOC("L28",1,"Zr",27,"",0,"L28G1-Zr27B0.M");

# L28d3
AGRGRP("lin","L28","L28d3");
AGRTOC("L28d3",1,"p",9,"",0,["L28d3G1-p9B0.m",2]);
AGRTOC("L28d3",1,"p",28,"",0,["L28d3G1-p28B0.m",2]);
AGRTOC("L28d3",1,"p",36,"",0,["L28d3G1-p36B0.m",2]);
AGRTOC("L28d3",1,"f",2,6,"",0,["L28d3G1-f2r6B0.m",2]);
AGRTOC("L28d3",1,"f",2,8,"",0,["L28d3G1-f2r8B0.m",2]);
AGRTOC("L28d3",1,"f",2,12,"",0,["L28d3G1-f2r12B0.m",2]);
AGRTOC("L28d3",1,"f",3,7,"",0,["L28d3G1-f3r7B0.m",2]);
AGRTOC("L28d3",1,"f",3,27,"",0,["L28d3G1-f3r27B0.m",2]);
AGRTOC("L28d3",1,"f",7,7,"",0,["L28d3G1-f7r7B0.m",2]);
AGRTOC("L28d3",1,"f",7,8,"",0,["L28d3G1-f7r8B0.m",2]);
AGRTOC("L28d3",1,"f",7,21,"",0,["L28d3G1-f7r21B0.m",2]);
AGRTOC("L28d3",1,"Zr",7,"",0,"L28d3G1-Zr7B0.M");
AGRTOC("L28d3",1,"Zr",8,"",0,"L28d3G1-Zr8B0.M");
AGRTOC("L28d3",1,"Zr",21,"",0,"L28d3G1-Zr21B0.M");
AGRTOC("L28d3",1,"Zr",27,"",0,"L28d3G1-Zr27B0.M");

# L35
AGRGRP("lin","L35","L35");
AGRTOC("L35",1,"p",31,"a",0,["L35G1-p31aB0.m",2]);
AGRTOC("L35",1,"p",31,"b",0,["L35G1-p31bB0.m",2]);
AGRTOC("L35",1,"f",5,3,"a",0,["L35G1-f5r3aB0.m",2]);
AGRTOC("L35",1,"f",5,3,"b",0,["L35G1-f5r3bB0.m",2]);
AGRTOC("L35",1,"f",5,8,"",0,["L35G1-f5r8B0.m",2]);

# L35d2
AGRGRP("lin","L35","L35d2");
AGRTOC("L35d2",1,"p",62,"",0,["L35d2G1-p62B0.m",2]);
AGRTOC("L35d2",1,"p",186,"",0,["L35d2G1-p186B0.m",2]);
AGRTOC("L35d2",1,"p",775,"",0,["L35d2G1-p775B0.m",2]);
AGRTOC("L35d2",1,"p",3100,"",0,["L35d2G1-p3100B0.m",2]);
AGRTOC("L35d2",1,"p",3875,"",0,["L35d2G1-p3875B0.m",2]);
AGRTOC("L35d2",1,"p",4000,"",0,["L35d2G1-p4000B0.m",2]);
AGRTOC("L35d2",1,"f",5,6,"",0,["L35d2G1-f5r6B0.m",2]);
AGRTOC("L35d2",1,"f",5,8,"",0,["L35d2G1-f5r8B0.m",2]);

# L37d2
AGRGRP("lin","L37","L37d2");
AGRTOC("L37d2",1,"f",2,56,"",0,["L37d2G1-f2r56B0.m",2]);
AGRTOC("L37d2",1,"f",2,152,"",0,["L37d2G1-f2r152B0.m",2]);
AGRTOC("L37d2",1,"f",2,342,"",0,["L37d2G1-f2r342B0.m",2]);
AGRTOC("L37d2",1,"f",3,55,"",0,["L37d2G1-f3r55B0.m",2]);
AGRTOC("L37d2",1,"f",3,57,"",0,["L37d2G1-f3r57B0.m",2]);
AGRTOC("L37d2",1,"f",3,96,"",0,["L37d2G1-f3r96B0.m",2]);
AGRTOC("L37d2",1,"f",3,192,"",0,["L37d2G1-f3r192B0.m",2]);
AGRTOC("L37d2",1,"f",3,399,"",0,["L37d2G1-f3r399B0.m",2]);
AGRTOC("L37d2",1,"f",7,8,"",0,["L37d2G1-f7r8B0.m",2]);
AGRTOC("L37d2",1,"f",7,20,"",0,["L37d2G1-f7r20B0.m",2]);
AGRTOC("L37d2",1,"f",7,27,"",0,["L37d2G1-f7r27B0.m",2]);
AGRTOC("L37d2",1,"f",7,37,"",0,["L37d2G1-f7r37B0.m",2]);
AGRTOC("L37d2",1,"f",7,56,"",0,["L37d2G1-f7r56B0.m",2]);
AGRTOC("L37d2",1,"f",7,70,"",0,["L37d2G1-f7r70B0.m",2]);
AGRTOC("L37d2",1,"f",7,308,"",0,["L37d2G1-f7r308B0.m",2]);
AGRTOC("L37d2",1,"f",7,343,"",0,["L37d2G1-f7r343B0.m",2]);
AGRTOC("L37d2",1,"f",9,342,"b",0,["L37d2G1-f9r342bB0.m",2]);
AGRTOC("L37d2",1,"f",9,342,"c",0,["L37d2G1-f9r342cB0.m",2]);

# L52d2
AGRGRP("lin","L52","L52d2");
AGRTOC("L52d2",1,"Ar",30,"",0,"L52d2G1-Ar30B0.M");

# 214U72
AGRGRP("misc","214U72","214U72");
AGRTOC("214U72",1,"p",10836,"",0,["214U72G1-p10836B0.m",2]);

# 24A8
AGRGRP("misc","24A8","24A8");
AGRTOC("24A8",1,"p",30,"",0,["24A8G1-p30B0.m",2]);
AGRTOC("24A8",1,"p",128,"",0,["24A8G1-p128B0.m",2]);
AGRTOC("24A8",1,"f",2,11,"a",0,["24A8G1-f2r11aB0.m",2]);
AGRTOC("24A8",1,"f",2,11,"b",0,["24A8G1-f2r11bB0.m",2]);
AGRTOC("24A8",1,"f",3,15,"",0,["24A8G1-f3r15B0.m",2]);
AGRTOC("24A8",1,"f",5,15,"",0,["24A8G1-f5r15B0.m",2]);
AGRTOC("24A8",1,"f",7,15,"",0,["24A8G1-f7r15B0.m",2]);
AGRTOC("24A8",1,"Zr",15,"",0,"24A8G1-Zr15B0.M");

# 25L52
AGRGRP("misc","25L52","25L52");
AGRTOC("25L52",1,"p",7440,"a",0,["25L52G1-p7440aB0.m",2]);
AGRTOC("25L52",1,"p",7440,"b",0,["25L52G1-p7440bB0.m",2]);
AGRTOC("25L52",1,"p",7440,"c",0,["25L52G1-p7440cB0.m",2]);
AGRTOC("25L52",1,"f",2,69,"a",0,["25L52G1-f2r69aB0.m",2]);
AGRTOC("25L52",1,"f",3,248,"",0,["25L52G1-f3r248B0.m",2]);
AGRTOC("25L52",1,"f",5,248,"",0,["25L52G1-f5r248B0.m",2]);
AGRTOC("25L52",1,"f",7,248,"",0,["25L52G1-f7r248B0.m",2]);
AGRTOC("25L52",1,"f",31,248,"",0,["25L52G1-f31r248B0.m",2]);
AGRTOC("25L52",1,"Zr",248,"",0,"25L52G1-Zr248B0.M");

# 53L35
AGRGRP("misc","53L35","53L35");
AGRTOC("53L35",2,"f",5,16,"a",0,["53L35G2-f5r16aB0.m",2]);

# B
AGRGRP("spor","B","B");
AGRTOC("B",1,"f",2,4370,"",0,["BG1-f2r4370B0.m",2]);
AGRTOC("B",1,"f",3,4371,"",0,["BG1-f3r4371B0.m",2]);
AGRTOC("B",1,"f",5,4371,"",0,["BG1-f5r4371B0.m",2]);
AGRTOC("B",1,"M",1,"BG1-max1W1");
AGRTOC("B",1,"M",2,"BG1-max2W1");
AGRTOC("B",1,"M",3,"BG1-max3W1");
AGRTOC("B",1,"M",5,"BG1-max5W1");
AGRTOC("B",1,"M",11,"BG1-max11W1");

# 2Co1
AGRGRP("spor","Co1","2Co1");
AGRTOC("2Co1",1,"f",3,24,"",0,["2Co1G1-f3r24B0.m",2]);
AGRTOC("2Co1",1,"f",5,24,"",0,["2Co1G1-f5r24B0.m",2]);
AGRTOC("2Co1",1,"f",7,24,"",0,["2Co1G1-f7r24B0.m",2]);
AGRTOC("2Co1",1,"f",11,24,"",0,["2Co1G1-f11r24B0.m",2]);
AGRTOC("2Co1",1,"f",13,24,"",0,["2Co1G1-f13r24B0.m",2]);
AGRTOC("2Co1",1,"f",23,24,"",0,["2Co1G1-f23r24B0.m",2]);

# Co1
AGRGRP("spor","Co1","Co1");
AGRTOC("Co1",1,"f",2,24,"",0,["Co1G1-f2r24B0.m",2]);
AGRTOC("Co1",1,"f",2,274,"",0,["Co1G1-f2r274B0.m",2]);
AGRTOC("Co1",1,"f",3,276,"",0,["Co1G1-f3r276B0.m",2]);
AGRTOC("Co1",1,"f",3,298,"",0,["Co1G1-f3r298B0.m",2]);
AGRTOC("Co1",1,"f",5,276,"",0,["Co1G1-f5r276B0.m",2]);
AGRTOC("Co1",1,"f",5,299,"",0,["Co1G1-f5r299B0.m",2]);
AGRTOC("Co1",1,"f",7,276,"",0,["Co1G1-f7r276B0.m",2]);
AGRTOC("Co1",1,"f",7,299,"",0,["Co1G1-f7r299B0.m",2]);
AGRTOC("Co1",1,"f",11,276,"",0,["Co1G1-f11r276B0.m",2]);
AGRTOC("Co1",1,"f",11,299,"",0,["Co1G1-f11r299B0.m",2]);
AGRTOC("Co1",1,"f",13,276,"",0,["Co1G1-f13r276B0.m",2]);
AGRTOC("Co1",1,"f",13,299,"",0,["Co1G1-f13r299B0.m",2]);
AGRTOC("Co1",1,"f",23,276,"",0,["Co1G1-f23r276B0.m",2]);
AGRTOC("Co1",1,"f",23,299,"",0,["Co1G1-f23r299B0.m",2]);
AGRTOC("Co1",1,"C","Co1G1-cycW1");

# Co2
AGRGRP("spor","Co2","Co2");
AGRTOC("Co2",1,"p",2300,"",0,["Co2G1-p2300B0.m",2]);
AGRTOC("Co2",1,"p",4600,"",0,["Co2G1-p4600B0.m",2]);
AGRTOC("Co2",1,"f",2,22,"",0,["Co2G1-f2r22B0.m",2]);
AGRTOC("Co2",1,"f",2,24,"",0,["Co2G1-f2r24B0.m",2]);
AGRTOC("Co2",1,"f",2,230,"",0,["Co2G1-f2r230B0.m",2]);
AGRTOC("Co2",1,"f",2,748,"a",0,["Co2G1-f2r748aB0.m",2]);
AGRTOC("Co2",1,"f",2,748,"b",0,["Co2G1-f2r748bB0.m",2]);
AGRTOC("Co2",1,"f",3,23,"",0,["Co2G1-f3r23B0.m",2]);
AGRTOC("Co2",1,"f",3,253,"",0,["Co2G1-f3r253B0.m",2]);
AGRTOC("Co2",1,"f",3,275,"",0,["Co2G1-f3r275B0.m",2]);
AGRTOC("Co2",1,"f",5,23,"",0,["Co2G1-f5r23B0.m",2]);
AGRTOC("Co2",1,"f",5,253,"",0,["Co2G1-f5r253B0.m",2]);
AGRTOC("Co2",1,"f",5,275,"",0,["Co2G1-f5r275B0.m",2]);
AGRTOC("Co2",1,"f",7,23,"",0,["Co2G1-f7r23B0.m",2]);
AGRTOC("Co2",1,"f",7,253,"",0,["Co2G1-f7r253B0.m",2]);
AGRTOC("Co2",1,"f",7,275,"",0,["Co2G1-f7r275B0.m",2]);
AGRTOC("Co2",1,"f",11,23,"",0,["Co2G1-f11r23B0.m",2]);
AGRTOC("Co2",1,"f",11,253,"",0,["Co2G1-f11r253B0.m",2]);
AGRTOC("Co2",1,"f",11,275,"",0,["Co2G1-f11r275B0.m",2]);
AGRTOC("Co2",1,"f",23,23,"",0,["Co2G1-f23r23B0.m",2]);
AGRTOC("Co2",1,"f",23,253,"",0,["Co2G1-f23r253B0.m",2]);
AGRTOC("Co2",1,"f",23,274,"",0,["Co2G1-f23r274B0.m",2]);
AGRTOC("Co2",1,"C","Co2G1-cycW1");

# Co3
AGRGRP("spor","Co3","Co3");
AGRTOC("Co3",1,"p",276,"",0,["Co3G1-p276B0.m",2]);
AGRTOC("Co3",1,"p",552,"",0,["Co3G1-p552B0.m",2]);
AGRTOC("Co3",1,"p",11178,"",0,["Co3G1-p11178B0.m",2]);
AGRTOC("Co3",1,"p",37950,"",0,["Co3G1-p37950B0.m",2]);
AGRTOC("Co3",1,"p",48600,"",0,["Co3G1-p48600B0.m",2]);
AGRTOC("Co3",1,"p",128800,"",0,["Co3G1-p128800B0.m",2]);
AGRTOC("Co3",1,"f",2,22,"",0,["Co3G1-f2r22B0.m",2]);
AGRTOC("Co3",1,"f",2,230,"",0,["Co3G1-f2r230B0.m",2]);
AGRTOC("Co3",1,"f",3,22,"",0,["Co3G1-f3r22B0.m",2]);
AGRTOC("Co3",1,"f",3,126,"a",0,["Co3G1-f3r126aB0.m",2]);
AGRTOC("Co3",1,"f",3,126,"b",0,["Co3G1-f3r126bB0.m",2]);
AGRTOC("Co3",1,"f",3,231,"a",0,["Co3G1-f3r231aB0.m",2]);
AGRTOC("Co3",1,"f",3,770,"a",0,["Co3G1-f3r770aB0.m",2]);
AGRTOC("Co3",1,"f",3,770,"b",0,["Co3G1-f3r770bB0.m",2]);
AGRTOC("Co3",1,"f",5,23,"",0,["Co3G1-f5r23B0.m",2]);
AGRTOC("Co3",1,"f",7,23,"",0,["Co3G1-f7r23B0.m",2]);
AGRTOC("Co3",1,"f",11,23,"",0,["Co3G1-f11r23B0.m",2]);
AGRTOC("Co3",1,"f",23,23,"",0,["Co3G1-f23r23B0.m",2]);
AGRTOC("Co3",1,"Zr",23,"",0,"Co3G1-Zr23B0.M");
AGRTOC("Co3",1,"C","Co3G1-cycW1");
AGRTOC("Co3",1,"M",1,"Co3G1-max1W1");
AGRTOC("Co3",1,"M",2,"Co3G1-max2W1");
AGRTOC("Co3",1,"M",3,"Co3G1-max3W1");
AGRTOC("Co3",1,"M",4,"Co3G1-max4W1");
AGRTOC("Co3",1,"M",5,"Co3G1-max5W1");
AGRTOC("Co3",1,"M",6,"Co3G1-max6W1");
AGRTOC("Co3",1,"M",7,"Co3G1-max7W1");
AGRTOC("Co3",1,"M",8,"Co3G1-max8W1");
AGRTOC("Co3",1,"M",9,"Co3G1-max9W1");
AGRTOC("Co3",1,"M",10,"Co3G1-max10W1");
AGRTOC("Co3",1,"M",11,"Co3G1-max11W1");
AGRTOC("Co3",1,"M",12,"Co3G1-max12W1");
AGRTOC("Co3",1,"M",12,"Co3G1-max12W2");
AGRTOC("Co3",1,"M",13,"Co3G1-max13W1");
AGRTOC("Co3",1,"M",14,"Co3G1-max14W1");
AGRTOC("Co3",1,"M",14,"Co3G1-max14W2");

# 2F22
AGRGRP("spor","F22","2F22");
AGRTOC("2F22",1,"p",28160,"",0,["2F22G1-p28160B0.m",2]);
AGRTOC("2F22",1,"f",3,176,"a",0,["2F22G1-f3r176aB0.m",2]);
AGRTOC("2F22",1,"f",5,352,"",0,["2F22G1-f5r352B0.m",2]);
AGRTOC("2F22",1,"f",7,352,"",0,["2F22G1-f7r352B0.m",2]);
AGRTOC("2F22",1,"f",11,352,"",0,["2F22G1-f11r352B0.m",2]);
AGRTOC("2F22",1,"f",13,352,"",0,["2F22G1-f13r352B0.m",2]);

# 2F22d2
AGRGRP("spor","F22","2F22d2");
AGRTOC("2F22d2",1,"f",3,352,"",0,["2F22d2G1-f3r352B0.m",2]);

# 3F22
AGRGRP("spor","F22","3F22");
AGRTOC("3F22",1,"f",4,27,"a",0,["3F22G1-f4r27aB0.m",2]);
AGRTOC("3F22",1,"f",7,351,"a",0,["3F22G1-f7r351aB0.m",2]);

# 3F22d2
AGRGRP("spor","F22","3F22d2");
AGRTOC("3F22d2",1,"p",185328,"",0,["3F22d2G1-p185328B0.m",2]);
AGRTOC("3F22d2",1,"f",2,54,"",0,["3F22d2G1-f2r54B0.m",2]);
AGRTOC("3F22d2",1,"f",7,702,"",0,["3F22d2G1-f7r702B0.m",2]);

# F22
AGRGRP("spor","F22","F22");
AGRTOC("F22",1,"p",3510,"",0,["F22G1-p3510B0.m",2]);
AGRTOC("F22",1,"p",14080,"b",0,["F22G1-p14080bB0.m",2]);
AGRTOC("F22",1,"p",61776,"",0,["F22G1-p61776B0.m",2]);
AGRTOC("F22",1,"p",142155,"",0,["F22G1-p142155B0.m",2]);
AGRTOC("F22",1,"p",694980,"",0,["F22G1-p694980B0.m",2]);
AGRTOC("F22",1,"f",2,78,"",0,["F22G1-f2r78B0.m",2]);
AGRTOC("F22",1,"f",2,350,"",0,["F22G1-f2r350B0.m",2]);
AGRTOC("F22",1,"f",2,572,"",0,["F22G1-f2r572B0.m",2]);
AGRTOC("F22",1,"f",3,77,"",0,["F22G1-f3r77B0.m",2]);
AGRTOC("F22",1,"f",3,351,"",0,["F22G1-f3r351B0.m",2]);
AGRTOC("F22",1,"f",3,924,"",0,["F22G1-f3r924B0.m",2]);
AGRTOC("F22",1,"f",5,78,"",0,["F22G1-f5r78B0.m",2]);
AGRTOC("F22",1,"f",5,428,"",0,["F22G1-f5r428B0.m",2]);
AGRTOC("F22",1,"f",7,78,"",0,["F22G1-f7r78B0.m",2]);
AGRTOC("F22",1,"f",7,429,"",0,["F22G1-f7r429B0.m",2]);
AGRTOC("F22",1,"f",11,78,"",0,["F22G1-f11r78B0.m",2]);
AGRTOC("F22",1,"f",11,429,"",0,["F22G1-f11r429B0.m",2]);
AGRTOC("F22",1,"f",13,78,"",0,["F22G1-f13r78B0.m",2]);
AGRTOC("F22",1,"f",13,429,"",0,["F22G1-f13r429B0.m",2]);
AGRTOC("F22",1,"C","F22G1-cycW1");
AGRTOC("F22",1,"M",1,"F22G1-max1W1");
AGRTOC("F22",1,"M",2,"F22G1-max2W1");
AGRTOC("F22",1,"M",3,"F22G1-max3W1");
AGRTOC("F22",1,"M",3,"F22G1-max3W2");
AGRTOC("F22",1,"M",4,"F22G1-max4W1");
AGRTOC("F22",1,"M",5,"F22G1-max5W1");
AGRTOC("F22",1,"M",6,"F22G1-max6W1");
AGRTOC("F22",1,"M",7,"F22G1-max7W1");
AGRTOC("F22",1,"M",9,"F22G1-max9W1");
AGRTOC("F22",1,"M",10,"F22G1-max10W1");
AGRTOC("F22",1,"M",11,"F22G1-max11W1");
AGRTOC("F22",1,"M",12,"F22G1-max12W1");
AGRTOC("F22",1,"M",13,"F22G1-max13W1");
AGRTOC("F22",1,"M",13,"F22G1-max13W2");
AGRTOC("F22",1,"M",14,"F22G1-max14W1");

# F22d2
AGRGRP("spor","F22","F22d2");
AGRTOC("F22d2",1,"p",3510,"",0,["F22d2G1-p3510B0.m",2]);
AGRTOC("F22d2",1,"f",2,78,"",0,["F22d2G1-f2r78B0.m",2]);
AGRTOC("F22d2",1,"f",3,77,"a",0,["F22d2G1-f3r77aB0.m",2]);
AGRTOC("F22d2",1,"f",3,351,"",0,["F22d2G1-f3r351B0.m",2]);

# F23
AGRGRP("spor","F23","F23");
AGRTOC("F23",1,"p",31671,"",0,["F23G1-p31671B0.m",2]);
AGRTOC("F23",1,"f",2,782,"",0,["F23G1-f2r782B0.m",2]);
AGRTOC("F23",1,"f",3,253,"",0,["F23G1-f3r253B0.m",2]);
AGRTOC("F23",1,"f",3,528,"",0,["F23G1-f3r528B0.m",2]);
AGRTOC("F23",1,"f",5,782,"",0,["F23G1-f5r782B0.m",2]);
AGRTOC("F23",1,"f",7,782,"",0,["F23G1-f7r782B0.m",2]);
AGRTOC("F23",1,"f",11,782,"",0,["F23G1-f11r782B0.m",2]);
AGRTOC("F23",1,"f",13,782,"",0,["F23G1-f13r782B0.m",2]);
AGRTOC("F23",1,"f",17,782,"",0,["F23G1-f17r782B0.m",2]);
AGRTOC("F23",1,"f",23,782,"",0,["F23G1-f23r782B0.m",2]);
AGRTOC("F23",1,"C","F23G1-cycW1");
AGRTOC("F23",1,"M",1,"F23G1-max1W1");
AGRTOC("F23",1,"M",1,"F23G1-max1W2");
AGRTOC("F23",1,"M",2,"F23G1-max2W1");
AGRTOC("F23",1,"M",3,"F23G1-max3W1");
AGRTOC("F23",1,"M",4,"F23G1-max4W1");
AGRTOC("F23",1,"M",5,"F23G1-max5W1");
AGRTOC("F23",1,"M",6,"F23G1-max6W1");
AGRTOC("F23",1,"M",9,"F23G1-max9W1");
AGRTOC("F23",1,"M",10,"F23G1-max10W1");
AGRTOC("F23",1,"M",13,"F23G1-max13W1");
AGRTOC("F23",1,"M",14,"F23G1-max14W1");

# 3F24
AGRGRP("spor","F24","3F24");
AGRTOC("3F24",1,"p",920808,"",0,["3F24G1-p920808B0.m",2]);
AGRTOC("3F24",1,"f",4,783,"",0,["3F24G1-f4r783B0.m",2]);

# 3F24d2
AGRGRP("spor","F24","3F24d2");
AGRTOC("3F24d2",1,"f",2,1566,"",0,["3F24d2G1-f2r1566B0.m",2]);

# F24
AGRGRP("spor","F24","F24");
AGRTOC("F24",1,"f",3,781,"",0,["F24G1-f3r781B0.m",2]);
AGRTOC("F24",1,"C","F24G1-cycW1");

# F24d2
AGRGRP("spor","F24","F24d2");
AGRTOC("F24d2",1,"p",306936,"",0,["F24d2G1-p306936B0.m",2]);
AGRTOC("F24d2",1,"f",3,781,"",0,["F24d2G1-f3r781B0.m",2]);
AGRTOC("F24d2",1,"M",1,"F24d2G1-max1W1");

# HN
AGRGRP("spor","HN","HN");
AGRTOC("HN",1,"p",1140000,"",0,["HNG1-p1140000B0.m",2]);
AGRTOC("HN",1,"f",2,760,"",0,["HNG1-f2r760B0.m",2]);
AGRTOC("HN",1,"f",3,760,"",0,["HNG1-f3r760B0.m",2]);
AGRTOC("HN",1,"f",4,132,"a",0,["HNG1-f4r132aB0.m",2]);
AGRTOC("HN",1,"f",4,132,"b",0,["HNG1-f4r132bB0.m",2]);
AGRTOC("HN",1,"f",4,133,"",0,["HNG1-f4r133B0.m",2]);
AGRTOC("HN",1,"f",4,2650,"a",0,["HNG1-f4r2650aB0.m",2]);
AGRTOC("HN",1,"f",5,133,"",0,["HNG1-f5r133B0.m",2]);
AGRTOC("HN",1,"f",5,626,"",0,["HNG1-f5r626B0.m",2]);
AGRTOC("HN",1,"f",5,627,"",0,["HNG1-f5r627B0.m",2]);
AGRTOC("HN",1,"f",9,133,"a",0,["HNG1-f9r133aB0.m",2]);
AGRTOC("HN",1,"f",9,133,"b",0,["HNG1-f9r133bB0.m",2]);
AGRTOC("HN",1,"f",11,133,"b",0,["HNG1-f11r133bB0.m",2]);
AGRTOC("HN",1,"f",11,133,"a",0,["HNG1-f11r133aB0.m",2]);
AGRTOC("HN",1,"f",19,133,"a",0,["HNG1-f19r133aB0.m",2]);
AGRTOC("HN",1,"f",19,133,"b",0,["HNG1-f19r133bB0.m",2]);
AGRTOC("HN",1,"f",49,133,"a",0,["HNG1-f49r133aB0.m",2]);
AGRTOC("HN",1,"f",49,133,"b",0,["HNG1-f49r133bB0.m",2]);
AGRTOC("HN",1,"C","HNG1-cycW1");
AGRTOC("HN",1,"M",1,"HNG1-max1W1");
AGRTOC("HN",1,"M",2,"HNG1-max2W1");
AGRTOC("HN",1,"M",3,"HNG1-max3W1");
AGRTOC("HN",1,"M",4,"HNG1-max4W1");
AGRTOC("HN",1,"M",5,"HNG1-max5W1");
AGRTOC("HN",1,"M",6,"HNG1-max6W1");
AGRTOC("HN",1,"M",7,"HNG1-max7W1");
AGRTOC("HN",1,"M",10,"HNG1-max10W1");
AGRTOC("HN",1,"M",11,"HNG1-max11W1");
AGRTOC("HN",1,"M",12,"HNG1-max12W1");
AGRTOC("HN",1,"M",14,"HNG1-max14W1");

# HNd2
AGRGRP("spor","HN","HNd2");
AGRTOC("HNd2",1,"f",2,264,"",0,["HNd2G1-f2r264B0.m",2]);
AGRTOC("HNd2",1,"f",5,133,"",0,["HNd2G1-f5r133B0.m",2]);

# 2HS
AGRGRP("spor","HS","2HS");
AGRTOC("2HS",1,"p",704,"",0,["2HSG1-p704B0.m",2]);
AGRTOC("2HS",1,"f",3,56,"",0,["2HSG1-f3r56B0.m",2]);
AGRTOC("2HS",1,"f",5,28,"b",0,["2HSG1-f5r28bB0.m",2]);
AGRTOC("2HS",1,"f",5,120,"b",0,["2HSG1-f5r120bB0.m",2]);
AGRTOC("2HS",1,"f",5,440,"b",0,["2HSG1-f5r440bB0.m",2]);
AGRTOC("2HS",1,"f",9,176,"b",0,["2HSG1-f9r176bB0.m",2]);

# 2HSd2
AGRGRP("spor","HS","2HSd2");
AGRTOC("2HSd2",1,"p",1408,"",0,["2HSd2G1-p1408B0.m",2]);
AGRTOC("2HSd2",1,"f",3,112,"",0,["2HSd2G1-f3r112B0.m",2]);
AGRTOC("2HSd2",1,"f",5,56,"",0,["2HSd2G1-f5r56B0.m",2]);
AGRTOC("2HSd2",1,"f",9,56,"",0,["2HSd2G1-f9r56B0.m",2]);

# HS
AGRGRP("spor","HS","HS");
AGRTOC("HS",1,"p",100,"",0,["HSG1-p100B0.m",2]);
AGRTOC("HS",1,"p",176,"b",0,["HSG1-p176bB0.m",2]);
AGRTOC("HS",1,"p",1100,"a",0,["HSG1-p1100aB0.m",2]);
AGRTOC("HS",1,"p",1100,"b",0,["HSG1-p1100bB0.m",2]);
AGRTOC("HS",1,"p",3850,"",0,["HSG1-p3850B0.m",2]);
AGRTOC("HS",1,"p",4125,"",0,["HSG1-p4125B0.m",2]);
AGRTOC("HS",1,"p",5600,"a",0,["HSG1-p5600aB0.m",2]);
AGRTOC("HS",1,"p",15400,"",0,["HSG1-p15400B0.m",2]);
AGRTOC("HS",1,"f",2,20,"",0,["HSG1-f2r20B0.m",2]);
AGRTOC("HS",1,"f",2,56,"",0,["HSG1-f2r56B0.m",2]);
AGRTOC("HS",1,"f",2,132,"",0,["HSG1-f2r132B0.m",2]);
AGRTOC("HS",1,"f",2,518,"",0,["HSG1-f2r518B0.m",2]);
AGRTOC("HS",1,"f",2,1000,"",0,["HSG1-f2r1000B0.m",2]);
AGRTOC("HS",1,"f",3,22,"",0,["HSG1-f3r22B0.m",2]);
AGRTOC("HS",1,"f",3,49,"a",0,["HSG1-f3r49aB0.m",2]);
AGRTOC("HS",1,"f",3,49,"b",0,["HSG1-f3r49bB0.m",2]);
AGRTOC("HS",1,"f",3,77,"",0,["HSG1-f3r77B0.m",2]);
AGRTOC("HS",1,"f",3,154,"b",0,["HSG1-f3r154bB0.m",2]);
AGRTOC("HS",1,"f",3,154,"c",0,["HSG1-f3r154cB0.m",2]);
AGRTOC("HS",1,"f",3,154,"a",0,["HSG1-f3r154aB0.m",2]);
AGRTOC("HS",1,"f",3,231,"",0,["HSG1-f3r231B0.m",2]);
AGRTOC("HS",1,"f",3,321,"",0,["HSG1-f3r321B0.m",2]);
AGRTOC("HS",1,"f",3,693,"",0,["HSG1-f3r693B0.m",2]);
AGRTOC("HS",1,"f",3,748,"",0,["HSG1-f3r748B0.m",2]);
AGRTOC("HS",1,"f",3,770,"a",0,["HSG1-f3r770aB0.m",2]);
AGRTOC("HS",1,"f",3,825,"",0,["HSG1-f3r825B0.m",2]);
AGRTOC("HS",1,"f",5,21,"",0,["HSG1-f5r21B0.m",2]);
AGRTOC("HS",1,"f",5,55,"",0,["HSG1-f5r55B0.m",2]);
AGRTOC("HS",1,"f",5,98,"",0,["HSG1-f5r98B0.m",2]);
AGRTOC("HS",1,"f",5,133,"b",0,["HSG1-f5r133bB0.m",2]);
AGRTOC("HS",1,"f",5,133,"a",0,["HSG1-f5r133aB0.m",2]);
AGRTOC("HS",1,"f",5,175,"",0,["HSG1-f5r175B0.m",2]);
AGRTOC("HS",1,"f",5,210,"",0,["HSG1-f5r210B0.m",2]);
AGRTOC("HS",1,"f",5,280,"a",0,["HSG1-f5r280aB0.m",2]);
AGRTOC("HS",1,"f",5,518,"",0,["HSG1-f5r518B0.m",2]);
AGRTOC("HS",1,"f",5,650,"",0,["HSG1-f5r650B0.m",2]);
AGRTOC("HS",1,"f",7,22,"",0,["HSG1-f7r22B0.m",2]);
AGRTOC("HS",1,"f",7,77,"",0,["HSG1-f7r77B0.m",2]);
AGRTOC("HS",1,"f",7,154,"a",0,["HSG1-f7r154aB0.m",2]);
AGRTOC("HS",1,"f",7,154,"b",0,["HSG1-f7r154bB0.m",2]);
AGRTOC("HS",1,"f",7,154,"c",0,["HSG1-f7r154cB0.m",2]);
AGRTOC("HS",1,"f",7,175,"",0,["HSG1-f7r175B0.m",2]);
AGRTOC("HS",1,"f",7,231,"",0,["HSG1-f7r231B0.m",2]);
AGRTOC("HS",1,"f",7,693,"",0,["HSG1-f7r693B0.m",2]);
AGRTOC("HS",1,"f",7,770,"a",0,["HSG1-f7r770aB0.m",2]);
AGRTOC("HS",1,"f",7,803,"",0,["HSG1-f7r803B0.m",2]);
AGRTOC("HS",1,"f",11,22,"",0,["HSG1-f11r22B0.m",2]);
AGRTOC("HS",1,"f",11,77,"",0,["HSG1-f11r77B0.m",2]);
AGRTOC("HS",1,"f",11,154,"a",0,["HSG1-f11r154aB0.m",2]);
AGRTOC("HS",1,"f",11,174,"",0,["HSG1-f11r174B0.m",2]);
AGRTOC("HS",1,"f",11,231,"",0,["HSG1-f11r231B0.m",2]);
AGRTOC("HS",1,"f",11,693,"",0,["HSG1-f11r693B0.m",2]);
AGRTOC("HS",1,"f",11,770,"a",0,["HSG1-f11r770aB0.m",2]);
AGRTOC("HS",1,"f",11,825,"",0,["HSG1-f11r825B0.m",2]);
AGRTOC("HS",1,"C","HSG1-cycW1");
AGRTOC("HS",1,"M",1,"HSG1-max1W1");
AGRTOC("HS",1,"M",2,"HSG1-max2W1");
AGRTOC("HS",1,"M",3,"HSG1-max3W1");
AGRTOC("HS",1,"M",4,"HSG1-max4W1");
AGRTOC("HS",1,"M",5,"HSG1-max5W1");
AGRTOC("HS",1,"M",6,"HSG1-max6W1");
AGRTOC("HS",1,"M",7,"HSG1-max7W1");
AGRTOC("HS",1,"M",8,"HSG1-max8W1");
AGRTOC("HS",1,"M",9,"HSG1-max9W1");
AGRTOC("HS",1,"M",10,"HSG1-max10W1");
AGRTOC("HS",1,"M",11,"HSG1-max11W1");
AGRTOC("HS",1,"M",12,"HSG1-max12W1");

# HSd2
AGRGRP("spor","HS","HSd2");
AGRTOC("HSd2",1,"p",100,"",0,["HSd2G1-p100B0.m",2]);
AGRTOC("HSd2",1,"p",352,"",0,["HSd2G1-p352B0.m",2]);
AGRTOC("HSd2",1,"p",1100,"b",0,["HSd2G1-p1100bB0.m",2]);
AGRTOC("HSd2",1,"p",15400,"",0,["HSd2G1-p15400B0.m",2]);
AGRTOC("HSd2",1,"f",2,20,"",0,["HSd2G1-f2r20B0.m",2]);
AGRTOC("HSd2",1,"f",2,22,"",0,["HSd2G1-f2r22B0.m",2]);
AGRTOC("HSd2",1,"f",3,22,"a",0,["HSd2G1-f3r22aB0.m",2]);
AGRTOC("HSd2",1,"f",5,21,"a",0,["HSd2G1-f5r21aB0.m",2]);
AGRTOC("HSd2",1,"f",7,22,"",0,["HSd2G1-f7r22B0.m",2]);
AGRTOC("HSd2",1,"f",7,154,"",0,["HSd2G1-f7r154B0.m",2]);
AGRTOC("HSd2",1,"f",7,693,"",0,["HSd2G1-f7r693B0.m",2]);
AGRTOC("HSd2",1,"f",7,770,"a",0,["HSd2G1-f7r770aB0.m",2]);
AGRTOC("HSd2",1,"f",7,803,"",0,["HSd2G1-f7r803B0.m",2]);
AGRTOC("HSd2",1,"f",11,22,"",0,["HSd2G1-f11r22B0.m",2]);
AGRTOC("HSd2",1,"f",11,896,"a",0,["HSd2G1-f11r896aB0.m",2]);
AGRTOC("HSd2",1,"M",1,"HSd2G1-max1W1");

# He
AGRGRP("spor","He","He");
AGRTOC("He",1,"p",2058,"",0,["HeG1-p2058B0.m",2]);
AGRTOC("He",1,"p",8330,"",0,["HeG1-p8330B0.m",2]);
AGRTOC("He",1,"p",29155,"",0,["HeG1-p29155B0.m",2]);
AGRTOC("He",1,"p",244800,"",0,["HeG1-p244800B0.m",2]);
AGRTOC("He",1,"f",2,51,"",0,["HeG1-f2r51B0.m",2]);
AGRTOC("He",1,"f",2,101,"",0,["HeG1-f2r101B0.m",2]);
AGRTOC("He",1,"f",2,246,"",0,["HeG1-f2r246B0.m",2]);
AGRTOC("He",1,"f",2,680,"",0,["HeG1-f2r680B0.m",2]);
AGRTOC("He",1,"f",3,679,"",0,["HeG1-f3r679B0.m",2]);
AGRTOC("He",1,"f",5,104,"",0,["HeG1-f5r104B0.m",2]);
AGRTOC("He",1,"f",5,680,"",0,["HeG1-f5r680B0.m",2]);
AGRTOC("He",1,"f",7,50,"",0,["HeG1-f7r50B0.m",2]);
AGRTOC("He",1,"f",7,153,"",0,["HeG1-f7r153B0.m",2]);
AGRTOC("He",1,"f",7,426,"",0,["HeG1-f7r426B0.m",2]);
AGRTOC("He",1,"f",7,798,"",0,["HeG1-f7r798B0.m",2]);
AGRTOC("He",1,"f",9,51,"",0,["HeG1-f9r51B0.m",2]);
AGRTOC("He",1,"f",17,102,"",0,["HeG1-f17r102B0.m",2]);
AGRTOC("He",1,"f",17,680,"",0,["HeG1-f17r680B0.m",2]);
AGRTOC("He",1,"f",25,51,"",0,["HeG1-f25r51B0.m",2]);
AGRTOC("He",1,"C","HeG1-cycW1");
AGRTOC("He",1,"M",1,"HeG1-max1W1");
AGRTOC("He",1,"M",2,"HeG1-max2W1");
AGRTOC("He",1,"M",3,"HeG1-max3W1");
AGRTOC("He",1,"M",4,"HeG1-max4W1");
AGRTOC("He",1,"M",5,"HeG1-max5W1");
AGRTOC("He",1,"M",6,"HeG1-max6W1");
AGRTOC("He",1,"M",7,"HeG1-max7W1");
AGRTOC("He",1,"M",8,"HeG1-max8W1");
AGRTOC("He",1,"M",9,"HeG1-max9W1");
AGRTOC("He",1,"M",10,"HeG1-max10W1");
AGRTOC("He",1,"M",11,"HeG1-max11W1");

# Hed2
AGRGRP("spor","He","Hed2");
AGRTOC("Hed2",1,"p",2058,"",0,["Hed2G1-p2058B0.m",2]);
AGRTOC("Hed2",1,"p",8330,"",0,["Hed2G1-p8330B0.m",2]);
AGRTOC("Hed2",1,"f",2,102,"",0,["Hed2G1-f2r102B0.m",2]);
AGRTOC("Hed2",1,"f",3,102,"",0,["Hed2G1-f3r102B0.m",2]);
AGRTOC("Hed2",1,"f",5,102,"",0,["Hed2G1-f5r102B0.m",2]);
AGRTOC("Hed2",1,"f",5,104,"",0,["Hed2G1-f5r104B0.m",2]);
AGRTOC("Hed2",1,"f",7,50,"",0,["Hed2G1-f7r50B0.m",2]);
AGRTOC("Hed2",1,"f",7,153,"",0,["Hed2G1-f7r153B0.m",2]);
AGRTOC("Hed2",1,"f",7,426,"",0,["Hed2G1-f7r426B0.m",2]);
AGRTOC("Hed2",1,"f",17,102,"",0,["Hed2G1-f17r102B0.m",2]);

# J1
AGRGRP("spor","J1","J1");
AGRTOC("J1",1,"p",266,"",0,["J1G1-p266B0.m",2]);
AGRTOC("J1",1,"p",1045,"",0,["J1G1-p1045B0.m",2]);
AGRTOC("J1",1,"p",1463,"",0,["J1G1-p1463B0.m",2]);
AGRTOC("J1",1,"p",1540,"",0,["J1G1-p1540B0.m",2]);
AGRTOC("J1",1,"p",1596,"",0,["J1G1-p1596B0.m",2]);
AGRTOC("J1",1,"p",2926,"",0,["J1G1-p2926B0.m",2]);
AGRTOC("J1",1,"p",4180,"",0,["J1G1-p4180B0.m",2]);
AGRTOC("J1",1,"f",2,20,"",0,["J1G1-f2r20B0.m",2]);
AGRTOC("J1",1,"f",2,76,"a",0,["J1G1-f2r76aB0.m",2]);
AGRTOC("J1",1,"f",2,76,"b",0,["J1G1-f2r76bB0.m",2]);
AGRTOC("J1",1,"f",2,112,"a",0,["J1G1-f2r112aB0.m",2]);
AGRTOC("J1",1,"f",2,112,"b",0,["J1G1-f2r112bB0.m",2]);
AGRTOC("J1",1,"f",2,360,"",0,["J1G1-f2r360B0.m",2]);
AGRTOC("J1",1,"f",3,76,"b",0,["J1G1-f3r76bB0.m",2]);
AGRTOC("J1",1,"f",3,76,"a",0,["J1G1-f3r76aB0.m",2]);
AGRTOC("J1",1,"f",3,112,"",0,["J1G1-f3r112B0.m",2]);
AGRTOC("J1",1,"f",3,133,"",0,["J1G1-f3r133B0.m",2]);
AGRTOC("J1",1,"f",3,154,"",0,["J1G1-f3r154B0.m",2]);
AGRTOC("J1",1,"f",3,360,"",0,["J1G1-f3r360B0.m",2]);
AGRTOC("J1",1,"f",4,56,"b",0,["J1G1-f4r56bB0.m",2]);
AGRTOC("J1",1,"f",4,56,"d",0,["J1G1-f4r56dB0.m",2]);
AGRTOC("J1",1,"f",4,56,"a",0,["J1G1-f4r56aB0.m",2]);
AGRTOC("J1",1,"f",4,56,"c",0,["J1G1-f4r56cB0.m",2]);
AGRTOC("J1",1,"f",5,56,"",0,["J1G1-f5r56B0.m",2]);
AGRTOC("J1",1,"f",5,76,"b",0,["J1G1-f5r76bB0.m",2]);
AGRTOC("J1",1,"f",5,76,"a",0,["J1G1-f5r76aB0.m",2]);
AGRTOC("J1",1,"f",5,77,"",0,["J1G1-f5r77B0.m",2]);
AGRTOC("J1",1,"f",5,133,"",0,["J1G1-f5r133B0.m",2]);
AGRTOC("J1",1,"f",5,360,"",0,["J1G1-f5r360B0.m",2]);
AGRTOC("J1",1,"f",7,31,"",0,["J1G1-f7r31B0.m",2]);
AGRTOC("J1",1,"f",7,45,"",0,["J1G1-f7r45B0.m",2]);
AGRTOC("J1",1,"f",7,75,"",0,["J1G1-f7r75B0.m",2]);
AGRTOC("J1",1,"f",7,77,"a",0,["J1G1-f7r77aB0.m",2]);
AGRTOC("J1",1,"f",7,89,"",0,["J1G1-f7r89B0.m",2]);
AGRTOC("J1",1,"f",7,112,"",0,["J1G1-f7r112B0.m",2]);
AGRTOC("J1",1,"f",7,120,"",0,["J1G1-f7r120B0.m",2]);
AGRTOC("J1",1,"f",7,133,"a",0,["J1G1-f7r133aB0.m",2]);
AGRTOC("J1",1,"f",7,154,"",0,["J1G1-f7r154B0.m",2]);
AGRTOC("J1",1,"f",7,266,"",0,["J1G1-f7r266B0.m",2]);
AGRTOC("J1",1,"f",8,120,"a",0,["J1G1-f8r120aB0.m",2]);
AGRTOC("J1",1,"f",8,120,"b",0,["J1G1-f8r120bB0.m",2]);
AGRTOC("J1",1,"f",8,120,"c",0,["J1G1-f8r120cB0.m",2]);
AGRTOC("J1",1,"f",9,56,"b",0,["J1G1-f9r56bB0.m",2]);
AGRTOC("J1",1,"f",9,56,"a",0,["J1G1-f9r56aB0.m",2]);
AGRTOC("J1",1,"f",9,77,"a",0,["J1G1-f9r77aB0.m",2]);
AGRTOC("J1",1,"f",9,77,"b",0,["J1G1-f9r77bB0.m",2]);
AGRTOC("J1",1,"f",11,7,"",0,["J1G1-f11r7B0.m",2]);
AGRTOC("J1",1,"f",11,14,"",0,["J1G1-f11r14B0.m",2]);
AGRTOC("J1",1,"f",11,27,"",0,["J1G1-f11r27B0.m",2]);
AGRTOC("J1",1,"f",11,49,"",0,["J1G1-f11r49B0.m",2]);
AGRTOC("J1",1,"f",11,56,"",0,["J1G1-f11r56B0.m",2]);
AGRTOC("J1",1,"f",11,64,"",0,["J1G1-f11r64B0.m",2]);
AGRTOC("J1",1,"f",11,69,"",0,["J1G1-f11r69B0.m",2]);
AGRTOC("J1",1,"f",11,77,"b",0,["J1G1-f11r77bB0.m",2]);
AGRTOC("J1",1,"f",11,77,"c",0,["J1G1-f11r77cB0.m",2]);
AGRTOC("J1",1,"f",11,77,"a",0,["J1G1-f11r77aB0.m",2]);
AGRTOC("J1",1,"f",11,106,"",0,["J1G1-f11r106B0.m",2]);
AGRTOC("J1",1,"f",11,119,"",0,["J1G1-f11r119B0.m",2]);
AGRTOC("J1",1,"f",11,209,"",0,["J1G1-f11r209B0.m",2]);
AGRTOC("J1",1,"f",19,22,"",0,["J1G1-f19r22B0.m",2]);
AGRTOC("J1",1,"f",19,34,"",0,["J1G1-f19r34B0.m",2]);
AGRTOC("J1",1,"f",19,43,"",0,["J1G1-f19r43B0.m",2]);
AGRTOC("J1",1,"f",19,55,"",0,["J1G1-f19r55B0.m",2]);
AGRTOC("J1",1,"f",19,76,"b",0,["J1G1-f19r76bB0.m",2]);
AGRTOC("J1",1,"f",19,76,"a",0,["J1G1-f19r76aB0.m",2]);
AGRTOC("J1",1,"f",19,77,"",0,["J1G1-f19r77B0.m",2]);
AGRTOC("J1",1,"f",19,133,"c",0,["J1G1-f19r133cB0.m",2]);
AGRTOC("J1",1,"f",19,133,"a",0,["J1G1-f19r133aB0.m",2]);
AGRTOC("J1",1,"f",19,133,"b",0,["J1G1-f19r133bB0.m",2]);
AGRTOC("J1",1,"f",19,209,"",0,["J1G1-f19r209B0.m",2]);
AGRTOC("J1",1,"f",27,120,"a",0,["J1G1-f27r120aB0.m",2]);
AGRTOC("J1",1,"f",27,120,"c",0,["J1G1-f27r120cB0.m",2]);
AGRTOC("J1",1,"f",27,120,"b",0,["J1G1-f27r120bB0.m",2]);
AGRTOC("J1",1,"f",49,56,"b",0,["J1G1-f49r56bB0.m",2]);
AGRTOC("J1",1,"f",49,56,"a",0,["J1G1-f49r56aB0.m",2]);
AGRTOC("J1",1,"f",49,77,"c",0,["J1G1-f49r77cB0.m",2]);
AGRTOC("J1",1,"f",49,77,"b",0,["J1G1-f49r77bB0.m",2]);
AGRTOC("J1",1,"f",49,133,"c",0,["J1G1-f49r133cB0.m",2]);
AGRTOC("J1",1,"f",49,133,"b",0,["J1G1-f49r133bB0.m",2]);
AGRTOC("J1",1,"f",125,120,"c",0,["J1G1-f125r120cB0.m",2]);
AGRTOC("J1",1,"f",125,120,"a",0,["J1G1-f125r120aB0.m",2]);
AGRTOC("J1",1,"f",125,120,"b",0,["J1G1-f125r120bB0.m",2]);
AGRTOC("J1",1,"C","J1G1-cycW1");
AGRTOC("J1",1,"M",1,"J1G1-max1W1");
AGRTOC("J1",1,"M",2,"J1G1-max2W1");
AGRTOC("J1",1,"M",3,"J1G1-max3W1");
AGRTOC("J1",1,"M",4,"J1G1-max4W1");
AGRTOC("J1",1,"M",5,"J1G1-max5W1");
AGRTOC("J1",1,"M",6,"J1G1-max6W1");
AGRTOC("J1",1,"M",7,"J1G1-max7W1");

# 2J2
AGRGRP("spor","J2","2J2");
AGRTOC("2J2",1,"p",200,"",0,["2J2G1-p200B0.m",2]);
AGRTOC("2J2",1,"p",1120,"",0,["2J2G1-p1120B0.m",2]);
AGRTOC("2J2",1,"f",3,14,"",0,["2J2G1-f3r14B0.m",2]);
AGRTOC("2J2",1,"f",3,216,"",0,["2J2G1-f3r216B0.m",2]);
AGRTOC("2J2",1,"f",3,236,"",0,["2J2G1-f3r236B0.m",2]);
AGRTOC("2J2",1,"f",5,6,"",0,["2J2G1-f5r6B0.m",2]);
AGRTOC("2J2",1,"f",5,14,"",0,["2J2G1-f5r14B0.m",2]);
AGRTOC("2J2",1,"f",5,50,"b",0,["2J2G1-f5r50bB0.m",2]);
AGRTOC("2J2",1,"f",5,50,"a",0,["2J2G1-f5r50aB0.m",2]);
AGRTOC("2J2",1,"f",5,56,"",0,["2J2G1-f5r56B0.m",2]);
AGRTOC("2J2",1,"f",5,64,"",0,["2J2G1-f5r64B0.m",2]);
AGRTOC("2J2",1,"f",7,14,"",0,["2J2G1-f7r14B0.m",2]);
AGRTOC("2J2",1,"f",9,6,"a",0,["2J2G1-f9r6aB0.m",2]);
AGRTOC("2J2",1,"f",9,36,"a",0,["2J2G1-f9r36aB0.m",2]);
AGRTOC("2J2",1,"f",9,50,"b",0,["2J2G1-f9r50bB0.m",2]);
AGRTOC("2J2",1,"f",9,126,"b",0,["2J2G1-f9r126bB0.m",2]);
AGRTOC("2J2",1,"f",49,6,"a",0,["2J2G1-f49r6aB0.m",2]);
AGRTOC("2J2",1,"f",49,50,"b",0,["2J2G1-f49r50bB0.m",2]);
AGRTOC("2J2",1,"f",49,58,"a",0,["2J2G1-f49r58aB0.m",2]);

# 2J2d2
AGRGRP("spor","J2","2J2d2");
AGRTOC("2J2d2",1,"f",3,12,"",0,["2J2d2G1-f3r12B0.m",2]);
AGRTOC("2J2d2",1,"f",7,12,"",0,["2J2d2G1-f7r12B0.m",2]);
AGRTOC("2J2d2",1,"f",25,6,"a",0,["2J2d2G1-f25r6aB0.m",2]);

# J2
AGRGRP("spor","J2","J2");
AGRTOC("J2",1,"p",100,"",0,["J2G1-p100B0.m",2]);
AGRTOC("J2",1,"p",280,"",0,["J2G1-p280B0.m",2]);
AGRTOC("J2",1,"p",315,"",0,["J2G1-p315B0.m",2]);
AGRTOC("J2",1,"p",525,"",0,["J2G1-p525B0.m",2]);
AGRTOC("J2",1,"p",840,"",0,["J2G1-p840B0.m",2]);
AGRTOC("J2",1,"p",1008,"",0,["J2G1-p1008B0.m",2]);
AGRTOC("J2",1,"p",1800,"",0,["J2G1-p1800B0.m",2]);
AGRTOC("J2",1,"f",2,36,"",0,["J2G1-f2r36B0.m",2]);
AGRTOC("J2",1,"f",2,84,"",0,["J2G1-f2r84B0.m",2]);
AGRTOC("J2",1,"f",2,160,"",0,["J2G1-f2r160B0.m",2]);
AGRTOC("J2",1,"f",3,36,"",0,["J2G1-f3r36B0.m",2]);
AGRTOC("J2",1,"f",3,63,"",0,["J2G1-f3r63B0.m",2]);
AGRTOC("J2",1,"f",3,90,"",0,["J2G1-f3r90B0.m",2]);
AGRTOC("J2",1,"f",3,133,"",0,["J2G1-f3r133B0.m",2]);
AGRTOC("J2",1,"f",3,225,"",0,["J2G1-f3r225B0.m",2]);
AGRTOC("J2",1,"f",4,6,"a",0,["J2G1-f4r6aB0.m",2]);
AGRTOC("J2",1,"f",4,14,"a",0,["J2G1-f4r14aB0.m",2]);
AGRTOC("J2",1,"f",4,64,"a",0,["J2G1-f4r64aB0.m",2]);
AGRTOC("J2",1,"f",5,14,"",0,["J2G1-f5r14B0.m",2]);
AGRTOC("J2",1,"f",5,21,"",0,["J2G1-f5r21B0.m",2]);
AGRTOC("J2",1,"f",5,41,"",0,["J2G1-f5r41B0.m",2]);
AGRTOC("J2",1,"f",5,70,"",0,["J2G1-f5r70B0.m",2]);
AGRTOC("J2",1,"f",5,85,"",0,["J2G1-f5r85B0.m",2]);
AGRTOC("J2",1,"f",5,90,"",0,["J2G1-f5r90B0.m",2]);
AGRTOC("J2",1,"f",5,175,"",0,["J2G1-f5r175B0.m",2]);
AGRTOC("J2",1,"f",5,189,"",0,["J2G1-f5r189B0.m",2]);
AGRTOC("J2",1,"f",5,225,"",0,["J2G1-f5r225B0.m",2]);
AGRTOC("J2",1,"f",5,300,"",0,["J2G1-f5r300B0.m",2]);
AGRTOC("J2",1,"f",7,36,"",0,["J2G1-f7r36B0.m",2]);
AGRTOC("J2",1,"f",7,63,"",0,["J2G1-f7r63B0.m",2]);
AGRTOC("J2",1,"f",7,89,"",0,["J2G1-f7r89B0.m",2]);
AGRTOC("J2",1,"f",7,101,"",0,["J2G1-f7r101B0.m",2]);
AGRTOC("J2",1,"f",7,124,"",0,["J2G1-f7r124B0.m",2]);
AGRTOC("J2",1,"f",7,126,"",0,["J2G1-f7r126B0.m",2]);
AGRTOC("J2",1,"f",7,175,"",0,["J2G1-f7r175B0.m",2]);
AGRTOC("J2",1,"f",7,199,"",0,["J2G1-f7r199B0.m",2]);
AGRTOC("J2",1,"f",7,336,"",0,["J2G1-f7r336B0.m",2]);
AGRTOC("J2",1,"f",9,13,"a",0,["J2G1-f9r13aB0.m",2]);
AGRTOC("J2",1,"f",9,21,"a",0,["J2G1-f9r21aB0.m",2]);
AGRTOC("J2",1,"f",9,57,"a",0,["J2G1-f9r57aB0.m",2]);
AGRTOC("J2",1,"f",9,189,"a",0,["J2G1-f9r189aB0.m",2]);
AGRTOC("J2",1,"f",49,14,"a",0,["J2G1-f49r14aB0.m",2]);
AGRTOC("J2",1,"f",49,21,"a",0,["J2G1-f49r21aB0.m",2]);
AGRTOC("J2",1,"f",49,70,"a",0,["J2G1-f49r70aB0.m",2]);
AGRTOC("J2",1,"f",49,189,"a",0,["J2G1-f49r189aB0.m",2]);
AGRTOC("J2",1,"f",49,224,"b",0,["J2G1-f49r224bB0.m",2]);
AGRTOC("J2",1,"C","J2G1-cycW1");
AGRTOC("J2",1,"M",1,"J2G1-max1W1");
AGRTOC("J2",1,"M",2,"J2G1-max2W1");
AGRTOC("J2",1,"M",3,"J2G1-max3W1");
AGRTOC("J2",1,"M",4,"J2G1-max4W1");
AGRTOC("J2",1,"M",5,"J2G1-max5W1");
AGRTOC("J2",1,"M",6,"J2G1-max6W1");
AGRTOC("J2",1,"M",7,"J2G1-max7W1");
AGRTOC("J2",1,"M",8,"J2G1-max8W1");
AGRTOC("J2",1,"M",9,"J2G1-max9W1");

# J2d2
AGRGRP("spor","J2","J2d2");
AGRTOC("J2d2",1,"p",100,"",0,["J2d2G1-p100B0.m",2]);
AGRTOC("J2d2",1,"f",2,12,"",0,["J2d2G1-f2r12B0.m",2]);
AGRTOC("J2d2",1,"f",2,28,"",0,["J2d2G1-f2r28B0.m",2]);
AGRTOC("J2d2",1,"f",2,36,"",0,["J2d2G1-f2r36B0.m",2]);
AGRTOC("J2d2",1,"f",2,84,"",0,["J2d2G1-f2r84B0.m",2]);
AGRTOC("J2d2",1,"f",2,128,"",0,["J2d2G1-f2r128B0.m",2]);
AGRTOC("J2d2",1,"f",2,160,"",0,["J2d2G1-f2r160B0.m",2]);
AGRTOC("J2d2",1,"f",3,26,"",0,["J2d2G1-f3r26B0.m",2]);
AGRTOC("J2d2",1,"f",5,14,"a",0,["J2d2G1-f5r14aB0.m",2]);
AGRTOC("J2d2",1,"f",7,28,"",0,["J2d2G1-f7r28B0.m",2]);
AGRTOC("J2d2",1,"M",1,"J2d2G1-max1W1");

# 3J3
AGRGRP("spor","J3","3J3");
AGRTOC("3J3",1,"f",4,9,"a",0,["3J3G1-f4r9aB0.m",2]);
AGRTOC("3J3",1,"f",4,18,"b",0,["3J3G1-f4r18bB0.m",2]);
AGRTOC("3J3",1,"f",5,36,"",0,["3J3G1-f5r36B0.m",2]);
AGRTOC("3J3",1,"f",17,36,"a",0,["3J3G1-f17r36aB0.m",2]);
AGRTOC("3J3",1,"f",17,36,"b",0,["3J3G1-f17r36bB0.m",2]);
AGRTOC("3J3",1,"f",19,18,"a",0,["3J3G1-f19r18aB0.m",2]);
AGRTOC("3J3",1,"f",19,18,"b",0,["3J3G1-f19r18bB0.m",2]);
AGRTOC("3J3",1,"f",25,18,"",0,["3J3G1-f25r18B0.m",2]);

# 3J3d2
AGRGRP("spor","J3","3J3d2");
AGRTOC("3J3d2",1,"f",2,18,"",0,["3J3d2G1-f2r18B0.m",2]);

# J3
AGRGRP("spor","J3","J3");
AGRTOC("J3",1,"p",6156,"",0,["J3G1-p6156B0.m",2]);
AGRTOC("J3",1,"p",14688,"a",0,["J3G1-p14688aB0.m",2]);
AGRTOC("J3",1,"p",14688,"b",0,["J3G1-p14688bB0.m",2]);
AGRTOC("J3",1,"p",17442,"",0,["J3G1-p17442B0.m",2]);
AGRTOC("J3",1,"p",20520,"",0,["J3G1-p20520B0.m",2]);
AGRTOC("J3",1,"p",23256,"",0,["J3G1-p23256B0.m",2]);
AGRTOC("J3",1,"p",25840,"",0,["J3G1-p25840B0.m",2]);
AGRTOC("J3",1,"p",26163,"",0,["J3G1-p26163B0.m",2]);
AGRTOC("J3",1,"p",43605,"",0,["J3G1-p43605B0.m",2]);
AGRTOC("J3",1,"f",2,80,"",0,["J3G1-f2r80B0.m",2]);
AGRTOC("J3",1,"f",2,248,"",0,["J3G1-f2r248B0.m",2]);
AGRTOC("J3",1,"f",3,324,"",0,["J3G1-f3r324B0.m",2]);
AGRTOC("J3",1,"f",4,78,"b",0,["J3G1-f4r78bB0.m",2]);
AGRTOC("J3",1,"f",4,84,"a",0,["J3G1-f4r84aB0.m",2]);
AGRTOC("J3",1,"f",5,85,"a",0,["J3G1-f5r85aB0.m",2]);
AGRTOC("J3",1,"f",5,323,"",0,["J3G1-f5r323B0.m",2]);
AGRTOC("J3",1,"f",9,18,"b",0,["J3G1-f9r18bB0.m",2]);
AGRTOC("J3",1,"f",9,84,"b",0,["J3G1-f9r84bB0.m",2]);
AGRTOC("J3",1,"f",9,153,"b",0,["J3G1-f9r153bB0.m",2]);
AGRTOC("J3",1,"f",17,85,"b",0,["J3G1-f17r85bB0.m",2]);
AGRTOC("J3",1,"f",19,85,"",0,["J3G1-f19r85B0.m",2]);
AGRTOC("J3",1,"f",19,110,"",0,["J3G1-f19r110B0.m",2]);
AGRTOC("J3",1,"f",19,214,"",0,["J3G1-f19r214B0.m",2]);
AGRTOC("J3",1,"C","J3G1-cycW1");
AGRTOC("J3",1,"M",1,"J3G1-max1W1");
AGRTOC("J3",1,"M",2,"J3G1-max2W1");
AGRTOC("J3",1,"M",3,"J3G1-max3W1");
AGRTOC("J3",1,"M",4,"J3G1-max4W1");
AGRTOC("J3",1,"M",5,"J3G1-max5W1");
AGRTOC("J3",1,"M",6,"J3G1-max6W1");
AGRTOC("J3",1,"M",7,"J3G1-max7W1");
AGRTOC("J3",1,"M",8,"J3G1-max8W1");
AGRTOC("J3",1,"M",9,"J3G1-max9W1");

# J3d2
AGRGRP("spor","J3","J3d2");
AGRTOC("J3d2",1,"p",6156,"",0,["J3d2G1-p6156B0.m",2]);
AGRTOC("J3d2",1,"f",3,36,"",0,["J3d2G1-f3r36B0.m",2]);
AGRTOC("J3d2",1,"f",5,323,"b",0,["J3d2G1-f5r323bB0.m",2]);
AGRTOC("J3d2",1,"f",19,214,"b",0,["J3d2G1-f19r214bB0.m",2]);

# J4
AGRGRP("spor","J4","J4");
AGRTOC("J4",1,"f",2,112,"",0,["J4G1-f2r112B0.m",2]);
AGRTOC("J4",1,"f",2,1220,"a",0,["J4G1-f2r1220aB0.m",2]);
AGRTOC("J4",1,"f",11,1333,"",0,["J4G1-f11r1333B0.m",2]);
AGRTOC("J4",1,"C","J4G1-cycW1");
AGRTOC("J4",1,"M",1,"J4G1-max1W1");
AGRTOC("J4",1,"M",2,"J4G1-max2W1");
AGRTOC("J4",1,"M",3,"J4G1-max3W1");
AGRTOC("J4",1,"M",4,"J4G1-max4W1");
AGRTOC("J4",1,"M",5,"J4G1-max5W1");
AGRTOC("J4",1,"M",6,"J4G1-max6W1");
AGRTOC("J4",1,"M",7,"J4G1-max7W1");
AGRTOC("J4",1,"M",8,"J4G1-max8W1");
AGRTOC("J4",1,"M",9,"J4G1-max9W1");
AGRTOC("J4",1,"M",10,"J4G1-max10W1");
AGRTOC("J4",1,"M",11,"J4G1-max11W1");
AGRTOC("J4",1,"M",12,"J4G1-max12W1");
AGRTOC("J4",1,"M",13,"J4G1-max13W1");

# Ly
AGRGRP("spor","Ly","Ly");
AGRTOC("Ly",1,"f",3,651,"",0,["LyG1-f3r651B0.m",2]);
AGRTOC("Ly",1,"f",4,2480,"",0,["LyG1-f4r2480B0.m",2]);
AGRTOC("Ly",1,"f",5,111,"",0,["LyG1-f5r111B0.m",2]);
AGRTOC("Ly",1,"f",5,517,"",0,["LyG1-f5r517B0.m",2]);
AGRTOC("Ly",1,"C","LyG1-cycW1");
AGRTOC("Ly",1,"M",1,"LyG1-max1W1");
AGRTOC("Ly",1,"M",2,"LyG1-max2W1");
AGRTOC("Ly",1,"M",3,"LyG1-max3W1");
AGRTOC("Ly",1,"M",4,"LyG1-max4W1");
AGRTOC("Ly",1,"M",5,"LyG1-max5W1");
AGRTOC("Ly",1,"M",6,"LyG1-max6W1");
AGRTOC("Ly",1,"M",7,"LyG1-max7W1");
AGRTOC("Ly",1,"M",8,"LyG1-max8W1");
AGRTOC("Ly",1,"M",9,"LyG1-max9W1");

# M11
AGRGRP("spor","M11","M11");
AGRTOC("M11",1,"p",11,"",0,["M11G1-p11B0.m",2]);
AGRTOC("M11",1,"p",12,"",0,["M11G1-p12B0.m",2]);
AGRTOC("M11",1,"p",55,"",0,["M11G1-p55B0.m",2]);
AGRTOC("M11",1,"p",66,"",0,["M11G1-p66B0.m",2]);
AGRTOC("M11",1,"p",165,"",0,["M11G1-p165B0.m",2]);
AGRTOC("M11",1,"f",2,10,"",0,["M11G1-f2r10B0.m",2]);
AGRTOC("M11",1,"f",2,32,"",0,["M11G1-f2r32B0.m",2]);
AGRTOC("M11",1,"f",2,44,"",0,["M11G1-f2r44B0.m",2]);
AGRTOC("M11",1,"f",3,5,"a",0,["M11G1-f3r5aB0.m",2]);
AGRTOC("M11",1,"f",3,5,"b",0,["M11G1-f3r5bB0.m",2]);
AGRTOC("M11",1,"f",3,10,"a",0,["M11G1-f3r10aB0.m",2]);
AGRTOC("M11",1,"f",3,10,"b",0,["M11G1-f3r10bB0.m",2]);
AGRTOC("M11",1,"f",3,10,"c",0,["M11G1-f3r10cB0.m",2]);
AGRTOC("M11",1,"f",3,24,"",0,["M11G1-f3r24B0.m",2]);
AGRTOC("M11",1,"f",3,45,"",0,["M11G1-f3r45B0.m",2]);
AGRTOC("M11",1,"f",4,16,"b",0,["M11G1-f4r16bB0.m",2]);
AGRTOC("M11",1,"f",4,16,"a",0,["M11G1-f4r16aB0.m",2]);
AGRTOC("M11",1,"f",5,10,"a",0,["M11G1-f5r10aB0.m",2]);
AGRTOC("M11",1,"f",5,11,"",0,["M11G1-f5r11B0.m",2]);
AGRTOC("M11",1,"f",5,16,"b",0,["M11G1-f5r16bB0.m",2]);
AGRTOC("M11",1,"f",5,16,"a",0,["M11G1-f5r16aB0.m",2]);
AGRTOC("M11",1,"f",5,20,"",0,["M11G1-f5r20B0.m",2]);
AGRTOC("M11",1,"f",5,45,"",0,["M11G1-f5r45B0.m",2]);
AGRTOC("M11",1,"f",5,55,"",0,["M11G1-f5r55B0.m",2]);
AGRTOC("M11",1,"f",11,9,"",0,["M11G1-f11r9B0.m",2]);
AGRTOC("M11",1,"f",11,10,"a",0,["M11G1-f11r10aB0.m",2]);
AGRTOC("M11",1,"f",11,10,"b",0,["M11G1-f11r10bB0.m",2]);
AGRTOC("M11",1,"f",11,11,"",0,["M11G1-f11r11B0.m",2]);
AGRTOC("M11",1,"f",11,16,"",0,["M11G1-f11r16B0.m",2]);
AGRTOC("M11",1,"f",11,44,"",0,["M11G1-f11r44B0.m",2]);
AGRTOC("M11",1,"f",11,55,"",0,["M11G1-f11r55B0.m",2]);
AGRTOC("M11",1,"f",25,10,"c",0,["M11G1-f25r10cB0.m",2]);
AGRTOC("M11",1,"f",25,10,"b",0,["M11G1-f25r10bB0.m",2]);
AGRTOC("M11",1,"Ar",10,"b",0,"M11G1-Ar10bB0.M");
AGRTOC("M11",1,"Ar",10,"c",0,"M11G1-Ar10cB0.M");
AGRTOC("M11",1,"Zr",10,"a",0,"M11G1-Zr10aB0.M");
AGRTOC("M11",1,"Zr",11,"",0,"M11G1-Zr11B0.M");
AGRTOC("M11",1,"Zr",20,"",0,"M11G1-Zr20B0.M");
AGRTOC("M11",1,"Zr",32,"",0,"M11G1-Zr32B0.M");
AGRTOC("M11",1,"Zr",44,"",0,"M11G1-Zr44B0.M");
AGRTOC("M11",1,"Zr",45,"",0,"M11G1-Zr45B0.M");
AGRTOC("M11",1,"Zr",55,"",0,"M11G1-Zr55B0.M");
AGRTOC("M11",1,"C","M11G1-cycW1");
AGRTOC("M11",1,"C","M11G1cycW1-cclsW1");
AGRTOC("M11",1,"M",1,"M11G1-max1W1");
AGRTOC("M11",1,"M",2,"M11G1-max2W1");
AGRTOC("M11",1,"M",3,"M11G1-max3W1");
AGRTOC("M11",1,"M",4,"M11G1-max4W1");
AGRTOC("M11",1,"M",5,"M11G1-max5W1");

# 2M12
AGRGRP("spor","M12","2M12");
AGRTOC("2M12",1,"p",24,"a",0,["2M12G1-p24aB0.m",2]);
AGRTOC("2M12",1,"f",3,6,"b",0,["2M12G1-f3r6bB0.m",2]);
AGRTOC("2M12",1,"f",5,12,"",0,["2M12G1-f5r12B0.m",2]);

# 2M12d2
AGRGRP("spor","M12","2M12d2");
AGRTOC("2M12d2",1,"p",48,"",0,["2M12d2G1-p48B0.m",2]);
AGRTOC("2M12d2",1,"f",3,10,"b",0,["2M12d2G1-f3r10bB0.m",2]);
AGRTOC("2M12d2",1,"f",3,12,"",0,["2M12d2G1-f3r12B0.m",2]);

# M12
AGRGRP("spor","M12","M12");
AGRTOC("M12",1,"p",12,"a",0,["M12G1-p12aB0.m",2]);
AGRTOC("M12",1,"p",12,"b",0,["M12G1-p12bB0.m",2]);
AGRTOC("M12",1,"p",66,"a",0,["M12G1-p66aB0.m",2]);
AGRTOC("M12",1,"p",66,"b",0,["M12G1-p66bB0.m",2]);
AGRTOC("M12",1,"f",2,10,"",0,["M12G1-f2r10B0.m",2]);
AGRTOC("M12",1,"f",2,44,"",0,["M12G1-f2r44B0.m",2]);
AGRTOC("M12",1,"f",2,144,"",0,["M12G1-f2r144B0.m",2]);
AGRTOC("M12",1,"f",3,10,"a",0,["M12G1-f3r10aB0.m",2]);
AGRTOC("M12",1,"f",3,15,"b",0,["M12G1-f3r15bB0.m",2]);
AGRTOC("M12",1,"f",3,34,"",0,["M12G1-f3r34B0.m",2]);
AGRTOC("M12",1,"f",3,45,"a",0,["M12G1-f3r45aB0.m",2]);
AGRTOC("M12",1,"f",3,45,"b",0,["M12G1-f3r45bB0.m",2]);
AGRTOC("M12",1,"f",3,54,"",0,["M12G1-f3r54B0.m",2]);
AGRTOC("M12",1,"f",3,99,"",0,["M12G1-f3r99B0.m",2]);
AGRTOC("M12",1,"f",4,16,"a",0,["M12G1-f4r16aB0.m",2]);
AGRTOC("M12",1,"f",4,16,"b",0,["M12G1-f4r16bB0.m",2]);
AGRTOC("M12",1,"f",5,11,"a",0,["M12G1-f5r11aB0.m",2]);
AGRTOC("M12",1,"f",5,16,"b",0,["M12G1-f5r16bB0.m",2]);
AGRTOC("M12",1,"f",5,45,"",0,["M12G1-f5r45B0.m",2]);
AGRTOC("M12",1,"f",5,55,"c",0,["M12G1-f5r55cB0.m",2]);
AGRTOC("M12",1,"f",5,55,"a",0,["M12G1-f5r55aB0.m",2]);
AGRTOC("M12",1,"f",5,66,"",0,["M12G1-f5r66B0.m",2]);
AGRTOC("M12",1,"f",5,78,"",0,["M12G1-f5r78B0.m",2]);
AGRTOC("M12",1,"f",5,98,"",0,["M12G1-f5r98B0.m",2]);
AGRTOC("M12",1,"f",5,120,"",0,["M12G1-f5r120B0.m",2]);
AGRTOC("M12",1,"f",11,11,"a",0,["M12G1-f11r11aB0.m",2]);
AGRTOC("M12",1,"f",11,16,"",0,["M12G1-f11r16B0.m",2]);
AGRTOC("M12",1,"f",11,29,"",0,["M12G1-f11r29B0.m",2]);
AGRTOC("M12",1,"f",11,53,"",0,["M12G1-f11r53B0.m",2]);
AGRTOC("M12",1,"f",11,55,"a",0,["M12G1-f11r55aB0.m",2]);
AGRTOC("M12",1,"f",11,55,"c",0,["M12G1-f11r55cB0.m",2]);
AGRTOC("M12",1,"f",11,66,"",0,["M12G1-f11r66B0.m",2]);
AGRTOC("M12",1,"f",11,91,"",0,["M12G1-f11r91B0.m",2]);
AGRTOC("M12",1,"f",11,99,"",0,["M12G1-f11r99B0.m",2]);
AGRTOC("M12",1,"f",11,176,"",0,["M12G1-f11r176B0.m",2]);
AGRTOC("M12",1,"C","M12G1-cycW1");
AGRTOC("M12",1,"M",1,"M12G1-max1W1");
AGRTOC("M12",1,"M",2,"M12G1-max2W1");
AGRTOC("M12",1,"M",3,"M12G1-max3W1");
AGRTOC("M12",1,"M",4,"M12G1-max4W1");
AGRTOC("M12",1,"M",5,"M12G1-max5W1");
AGRTOC("M12",1,"M",6,"M12G1-max6W1");
AGRTOC("M12",1,"M",7,"M12G1-max7W1");
AGRTOC("M12",1,"M",8,"M12G1-max8W1");
AGRTOC("M12",1,"M",9,"M12G1-max9W1");
AGRTOC("M12",1,"M",9,"M12G1-max9W2");
AGRTOC("M12",1,"M",10,"M12G1-max10W1");
AGRTOC("M12",1,"M",11,"M12G1-max11W1");

# M12d2
AGRGRP("spor","M12","M12d2");
AGRTOC("M12d2",1,"p",24,"",0,["M12d2G1-p24B0.m",2]);
AGRTOC("M12d2",1,"f",2,10,"",0,["M12d2G1-f2r10B0.m",2]);
AGRTOC("M12d2",1,"f",2,32,"",0,["M12d2G1-f2r32B0.m",2]);
AGRTOC("M12d2",1,"f",2,44,"",0,["M12d2G1-f2r44B0.m",2]);
AGRTOC("M12d2",1,"f",2,144,"",0,["M12d2G1-f2r144B0.m",2]);

# 12M22
AGRGRP("spor","M22","12M22");
AGRTOC("12M22",1,"f",25,48,"a",0,["12M22G1-f25r48aB0.m",2]);
AGRTOC("12M22",1,"f",121,24,"b",0,["12M22G1-f121r24bB0.m",2]);

# 2M22
AGRGRP("spor","M22","2M22");
AGRTOC("2M22",1,"f",5,120,"",0,["2M22G1-f5r120B0.m",2]);
AGRTOC("2M22",1,"f",7,10,"",0,["2M22G1-f7r10B0.m",2]);
AGRTOC("2M22",1,"f",7,120,"",0,["2M22G1-f7r120B0.m",2]);
AGRTOC("2M22",1,"f",7,320,"",0,["2M22G1-f7r320B0.m",2]);
AGRTOC("2M22",1,"f",9,10,"b",0,["2M22G1-f9r10bB0.m",2]);
AGRTOC("2M22",1,"f",11,10,"b",0,["2M22G1-f11r10bB0.m",2]);
AGRTOC("2M22",1,"f",25,10,"b",0,["2M22G1-f25r10bB0.m",2]);
AGRTOC("2M22",1,"f",49,126,"b",0,["2M22G1-f49r126bB0.m",2]);

# 2M22d2
AGRGRP("spor","M22","2M22d2");
AGRTOC("2M22d2",1,"f",7,10,"a",0,["2M22d2G1-f7r10aB0.m",2]);
AGRTOC("2M22d2",1,"f",9,10,"b",0,["2M22d2G1-f9r10bB0.m",2]);
AGRTOC("2M22d2",1,"f",11,10,"b",0,["2M22d2G1-f11r10bB0.m",2]);
AGRTOC("2M22d2",1,"f",25,10,"b",0,["2M22d2G1-f25r10bB0.m",2]);

# 3M22
AGRGRP("spor","M22","3M22");
AGRTOC("3M22",1,"f",4,6,"a",0,["3M22G1-f4r6aB0.m",2]);
AGRTOC("3M22",1,"f",7,21,"a",0,["3M22G1-f7r21aB0.m",2]);
AGRTOC("3M22",1,"f",25,21,"a",0,["3M22G1-f25r21aB0.m",2]);
AGRTOC("3M22",1,"f",121,21,"b",0,["3M22G1-f121r21bB0.m",2]);

# 3M22d2
AGRGRP("spor","M22","3M22d2");
AGRTOC("3M22d2",1,"f",2,12,"",0,["3M22d2G1-f2r12B0.m",2]);

# 4M22
AGRGRP("spor","M22","4M22");
AGRTOC("4M22",1,"f",25,56,"a",0,["4M22G1-f25r56aB0.m",2]);
AGRTOC("4M22",1,"f",49,16,"a",0,["4M22G1-f49r16aB0.m",2]);
AGRTOC("4M22",1,"f",121,56,"a",0,["4M22G1-f121r56aB0.m",2]);

# 4M22d2
AGRGRP("spor","M22","4M22d2");
AGRTOC("4M22d2",1,"f",7,32,"",0,["4M22d2G1-f7r32B0.m",2]);

# 6M22
AGRGRP("spor","M22","6M22");
AGRTOC("6M22",1,"f",7,54,"a",0,["6M22G1-f7r54aB0.m",2]);
AGRTOC("6M22",1,"f",121,36,"b",0,["6M22G1-f121r36bB0.m",2]);

# 6M22d2
AGRGRP("spor","M22","6M22d2");
AGRTOC("6M22d2",1,"f",11,72,"",0,["6M22d2G1-f11r72B0.m",2]);

# M22
AGRGRP("spor","M22","M22");
AGRTOC("M22",1,"p",22,"",0,["M22G1-p22B0.m",2]);
AGRTOC("M22",1,"f",2,10,"a",0,["M22G1-f2r10aB0.m",2]);
AGRTOC("M22",1,"f",2,10,"b",0,["M22G1-f2r10bB0.m",2]);
AGRTOC("M22",1,"f",2,34,"",0,["M22G1-f2r34B0.m",2]);
AGRTOC("M22",1,"f",2,98,"",0,["M22G1-f2r98B0.m",2]);
AGRTOC("M22",1,"f",3,21,"",0,["M22G1-f3r21B0.m",2]);
AGRTOC("M22",1,"f",3,49,"a",0,["M22G1-f3r49aB0.m",2]);
AGRTOC("M22",1,"f",3,49,"b",0,["M22G1-f3r49bB0.m",2]);
AGRTOC("M22",1,"f",3,55,"",0,["M22G1-f3r55B0.m",2]);
AGRTOC("M22",1,"f",3,99,"",0,["M22G1-f3r99B0.m",2]);
AGRTOC("M22",1,"f",3,210,"",0,["M22G1-f3r210B0.m",2]);
AGRTOC("M22",1,"f",3,231,"",0,["M22G1-f3r231B0.m",2]);
AGRTOC("M22",1,"f",4,70,"b",0,["M22G1-f4r70bB0.m",2]);
AGRTOC("M22",1,"f",4,70,"a",0,["M22G1-f4r70aB0.m",2]);
AGRTOC("M22",1,"f",5,21,"",0,["M22G1-f5r21B0.m",2]);
AGRTOC("M22",1,"f",5,55,"",0,["M22G1-f5r55B0.m",2]);
AGRTOC("M22",1,"f",5,98,"",0,["M22G1-f5r98B0.m",2]);
AGRTOC("M22",1,"f",5,133,"",0,["M22G1-f5r133B0.m",2]);
AGRTOC("M22",1,"f",5,210,"",0,["M22G1-f5r210B0.m",2]);
AGRTOC("M22",1,"f",5,280,"a",0,["M22G1-f5r280aB0.m",2]);
AGRTOC("M22",1,"f",5,385,"",0,["M22G1-f5r385B0.m",2]);
AGRTOC("M22",1,"f",7,21,"",0,["M22G1-f7r21B0.m",2]);
AGRTOC("M22",1,"f",7,45,"",0,["M22G1-f7r45B0.m",2]);
AGRTOC("M22",1,"f",7,54,"",0,["M22G1-f7r54B0.m",2]);
AGRTOC("M22",1,"f",7,154,"",0,["M22G1-f7r154B0.m",2]);
AGRTOC("M22",1,"f",7,210,"",0,["M22G1-f7r210B0.m",2]);
AGRTOC("M22",1,"f",7,231,"",0,["M22G1-f7r231B0.m",2]);
AGRTOC("M22",1,"f",7,385,"",0,["M22G1-f7r385B0.m",2]);
AGRTOC("M22",1,"f",9,45,"a",0,["M22G1-f9r45aB0.m",2]);
AGRTOC("M22",1,"f",11,20,"",0,["M22G1-f11r20B0.m",2]);
AGRTOC("M22",1,"f",11,45,"a",0,["M22G1-f11r45aB0.m",2]);
AGRTOC("M22",1,"f",11,45,"b",0,["M22G1-f11r45bB0.m",2]);
AGRTOC("M22",1,"f",11,55,"",0,["M22G1-f11r55B0.m",2]);
AGRTOC("M22",1,"f",11,99,"",0,["M22G1-f11r99B0.m",2]);
AGRTOC("M22",1,"f",11,154,"",0,["M22G1-f11r154B0.m",2]);
AGRTOC("M22",1,"f",11,190,"",0,["M22G1-f11r190B0.m",2]);
AGRTOC("M22",1,"f",11,231,"",0,["M22G1-f11r231B0.m",2]);
AGRTOC("M22",1,"f",11,385,"",0,["M22G1-f11r385B0.m",2]);
AGRTOC("M22",1,"f",25,45,"a",0,["M22G1-f25r45aB0.m",2]);
AGRTOC("M22",1,"f",49,280,"a",0,["M22G1-f49r280aB0.m",2]);
AGRTOC("M22",1,"f",49,280,"b",0,["M22G1-f49r280bB0.m",2]);
AGRTOC("M22",1,"C","M22G1-cycW1");
AGRTOC("M22",1,"M",1,"M22G1-max1W1");
AGRTOC("M22",1,"M",2,"M22G1-max2W1");
AGRTOC("M22",1,"M",3,"M22G1-max3W1");
AGRTOC("M22",1,"M",4,"M22G1-max4W1");
AGRTOC("M22",1,"M",5,"M22G1-max5W1");
AGRTOC("M22",1,"M",6,"M22G1-max6W1");
AGRTOC("M22",1,"M",7,"M22G1-max7W1");
AGRTOC("M22",1,"M",7,"M22G1-max7W2");
AGRTOC("M22",1,"M",8,"M22G1-max8W1");

# M22d2
AGRGRP("spor","M22","M22d2");
AGRTOC("M22d2",1,"p",22,"",0,["M22d2G1-p22B0.m",2]);
AGRTOC("M22d2",1,"p",77,"",0,["M22d2G1-p77B0.m",2]);
AGRTOC("M22d2",1,"f",2,10,"b",0,["M22d2G1-f2r10bB0.m",2]);
AGRTOC("M22d2",1,"C","M22d2G1-cycW1");

# M23
AGRGRP("spor","M23","M23");
AGRTOC("M23",1,"p",23,"",0,["M23G1-p23B0.m",2]);
AGRTOC("M23",1,"p",253,"a",0,["M23G1-p253aB0.m",2]);
AGRTOC("M23",1,"p",253,"b",0,["M23G1-p253bB0.m",2]);
AGRTOC("M23",1,"p",506,"",0,["M23G1-p506B0.m",2]);
AGRTOC("M23",1,"p",1288,"",0,["M23G1-p1288B0.m",2]);
AGRTOC("M23",1,"p",1771,"",0,["M23G1-p1771B0.m",2]);
AGRTOC("M23",1,"f",2,11,"a",0,["M23G1-f2r11aB0.m",2]);
AGRTOC("M23",1,"f",2,11,"b",0,["M23G1-f2r11bB0.m",2]);
AGRTOC("M23",1,"f",2,44,"a",0,["M23G1-f2r44aB0.m",2]);
AGRTOC("M23",1,"f",2,44,"b",0,["M23G1-f2r44bB0.m",2]);
AGRTOC("M23",1,"f",2,120,"",0,["M23G1-f2r120B0.m",2]);
AGRTOC("M23",1,"f",2,220,"a",0,["M23G1-f2r220aB0.m",2]);
AGRTOC("M23",1,"f",2,220,"b",0,["M23G1-f2r220bB0.m",2]);
AGRTOC("M23",1,"f",2,252,"",0,["M23G1-f2r252B0.m",2]);
AGRTOC("M23",1,"f",3,22,"",0,["M23G1-f3r22B0.m",2]);
AGRTOC("M23",1,"f",3,104,"a",0,["M23G1-f3r104aB0.m",2]);
AGRTOC("M23",1,"f",3,104,"b",0,["M23G1-f3r104bB0.m",2]);
AGRTOC("M23",1,"f",3,231,"",0,["M23G1-f3r231B0.m",2]);
AGRTOC("M23",1,"f",3,253,"",0,["M23G1-f3r253B0.m",2]);
AGRTOC("M23",1,"f",3,770,"a",0,["M23G1-f3r770aB0.m",2]);
AGRTOC("M23",1,"f",5,22,"",0,["M23G1-f5r22B0.m",2]);
AGRTOC("M23",1,"f",5,230,"",0,["M23G1-f5r230B0.m",2]);
AGRTOC("M23",1,"f",5,231,"a",0,["M23G1-f5r231aB0.m",2]);
AGRTOC("M23",1,"f",7,22,"",0,["M23G1-f7r22B0.m",2]);
AGRTOC("M23",1,"f",7,45,"",0,["M23G1-f7r45B0.m",2]);
AGRTOC("M23",1,"f",7,208,"",0,["M23G1-f7r208B0.m",2]);
AGRTOC("M23",1,"f",7,231,"a",0,["M23G1-f7r231aB0.m",2]);
AGRTOC("M23",1,"f",9,45,"a",0,["M23G1-f9r45aB0.m",2]);
AGRTOC("M23",1,"f",9,990,"a",0,["M23G1-f9r990aB0.m",2]);
AGRTOC("M23",1,"f",11,22,"",0,["M23G1-f11r22B0.m",2]);
AGRTOC("M23",1,"f",11,45,"",0,["M23G1-f11r45B0.m",2]);
AGRTOC("M23",1,"f",23,21,"",0,["M23G1-f23r21B0.m",2]);
AGRTOC("M23",1,"f",23,45,"",0,["M23G1-f23r45B0.m",2]);
AGRTOC("M23",1,"f",23,280,"",0,["M23G1-f23r280B0.m",2]);
AGRTOC("M23",1,"f",25,45,"a",0,["M23G1-f25r45aB0.m",2]);
AGRTOC("M23",1,"C","M23G1-cycW1");
AGRTOC("M23",1,"C","M23G1cycW1-cclsW1");
AGRTOC("M23",1,"M",1,"M23G1-max1W1");
AGRTOC("M23",1,"M",2,"M23G1-max2W1");
AGRTOC("M23",1,"M",3,"M23G1-max3W1");
AGRTOC("M23",1,"M",4,"M23G1-max4W1");
AGRTOC("M23",1,"M",5,"M23G1-max5W1");
AGRTOC("M23",1,"M",6,"M23G1-max6W1");
AGRTOC("M23",1,"M",7,"M23G1-max7W1");

# M24
AGRGRP("spor","M24","M24");
AGRTOC("M24",1,"p",24,"",0,["M24G1-p24B0.m",2]);
AGRTOC("M24",1,"p",276,"",0,["M24G1-p276B0.m",2]);
AGRTOC("M24",1,"p",759,"",0,["M24G1-p759B0.m",2]);
AGRTOC("M24",1,"p",1288,"",0,["M24G1-p1288B0.m",2]);
AGRTOC("M24",1,"p",1771,"",0,["M24G1-p1771B0.m",2]);
AGRTOC("M24",1,"p",2024,"",0,["M24G1-p2024B0.m",2]);
AGRTOC("M24",1,"p",3795,"",0,["M24G1-p3795B0.m",2]);
AGRTOC("M24",1,"f",2,11,"a",0,["M24G1-f2r11aB0.m",2]);
AGRTOC("M24",1,"f",2,11,"b",0,["M24G1-f2r11bB0.m",2]);
AGRTOC("M24",1,"f",2,44,"a",0,["M24G1-f2r44aB0.m",2]);
AGRTOC("M24",1,"f",2,44,"b",0,["M24G1-f2r44bB0.m",2]);
AGRTOC("M24",1,"f",2,120,"",0,["M24G1-f2r120B0.m",2]);
AGRTOC("M24",1,"f",2,220,"a",0,["M24G1-f2r220aB0.m",2]);
AGRTOC("M24",1,"f",2,220,"b",0,["M24G1-f2r220bB0.m",2]);
AGRTOC("M24",1,"f",2,252,"",0,["M24G1-f2r252B0.m",2]);
AGRTOC("M24",1,"f",2,320,"a",0,["M24G1-f2r320aB0.m",2]);
AGRTOC("M24",1,"f",2,320,"b",0,["M24G1-f2r320bB0.m",2]);
AGRTOC("M24",1,"f",2,1242,"",0,["M24G1-f2r1242B0.m",2]);
AGRTOC("M24",1,"f",2,1792,"",0,["M24G1-f2r1792B0.m",2]);
AGRTOC("M24",1,"f",3,22,"",0,["M24G1-f3r22B0.m",2]);
AGRTOC("M24",1,"f",3,231,"",0,["M24G1-f3r231B0.m",2]);
AGRTOC("M24",1,"f",3,252,"",0,["M24G1-f3r252B0.m",2]);
AGRTOC("M24",1,"f",5,23,"",0,["M24G1-f5r23B0.m",2]);
AGRTOC("M24",1,"f",7,23,"",0,["M24G1-f7r23B0.m",2]);
AGRTOC("M24",1,"f",7,45,"",0,["M24G1-f7r45B0.m",2]);
AGRTOC("M24",1,"f",9,45,"a",0,["M24G1-f9r45aB0.m",2]);
AGRTOC("M24",1,"f",9,45,"b",0,["M24G1-f9r45bB0.m",2]);
AGRTOC("M24",1,"f",11,23,"",0,["M24G1-f11r23B0.m",2]);
AGRTOC("M24",1,"f",11,45,"",0,["M24G1-f11r45B0.m",2]);
AGRTOC("M24",1,"f",23,23,"",0,["M24G1-f23r23B0.m",2]);
AGRTOC("M24",1,"f",23,45,"",0,["M24G1-f23r45B0.m",2]);
AGRTOC("M24",1,"f",25,45,"a",0,["M24G1-f25r45aB0.m",2]);
AGRTOC("M24",1,"f",25,45,"b",0,["M24G1-f25r45bB0.m",2]);
AGRTOC("M24",1,"C","M24G1-cycW1");
AGRTOC("M24",1,"M",1,"M24G1-max1W1");
AGRTOC("M24",1,"M",1,"M24G1-max1W2");
AGRTOC("M24",1,"M",2,"M24G1-max2W1");
AGRTOC("M24",1,"M",3,"M24G1-max3W1");
AGRTOC("M24",1,"M",4,"M24G1-max4W1");
AGRTOC("M24",1,"M",5,"M24G1-max5W1");
AGRTOC("M24",1,"M",6,"M24G1-max6W1");
AGRTOC("M24",1,"M",7,"M24G1-max7W1");
AGRTOC("M24",1,"M",8,"M24G1-max8W1");
AGRTOC("M24",1,"M",9,"M24G1-max9W1");

# 3McL
AGRGRP("spor","McL","3McL");
AGRTOC("3McL",1,"p",66825,"",0,["3McLG1-p66825B0.m",2]);
AGRTOC("3McL",1,"p",340200,"",0,["3McLG1-p340200B0.m",2]);
AGRTOC("3McL",1,"f",3,42,"",0,["3McLG1-f3r42B0.m",2]);
AGRTOC("3McL",1,"f",4,126,"a",0,["3McLG1-f4r126aB0.m",2]);
AGRTOC("3McL",1,"f",4,396,"d",0,["3McLG1-f4r396dB0.m",2]);
AGRTOC("3McL",1,"f",25,45,"a",0,["3McLG1-f25r45aB0.m",2]);

# 3McLd2
AGRGRP("spor","McL","3McLd2");
AGRTOC("3McLd2",1,"f",4,252,"a",0,["3McLd2G1-f4r252aB0.m",2]);
AGRTOC("3McLd2",1,"f",5,90,"",0,["3McLd2G1-f5r90B0.m",2]);
AGRTOC("3McLd2",1,"f",5,306,"",0,["3McLd2G1-f5r306B0.m",2]);
AGRTOC("3McLd2",1,"f",5,1278,"",0,["3McLd2G1-f5r1278B0.m",2]);

# McL
AGRGRP("spor","McL","McL");
AGRTOC("McL",1,"p",275,"",0,["McLG1-p275B0.m",2]);
AGRTOC("McL",1,"p",2025,"a",0,["McLG1-p2025aB0.m",2]);
AGRTOC("McL",1,"p",2025,"b",0,["McLG1-p2025bB0.m",2]);
AGRTOC("McL",1,"p",7128,"",0,["McLG1-p7128B0.m",2]);
AGRTOC("McL",1,"p",15400,"a",0,["McLG1-p15400aB0.m",2]);
AGRTOC("McL",1,"p",15400,"b",0,["McLG1-p15400bB0.m",2]);
AGRTOC("McL",1,"p",22275,"a",0,["McLG1-p22275aB0.m",2]);
AGRTOC("McL",1,"p",22275,"b",0,["McLG1-p22275bB0.m",2]);
AGRTOC("McL",1,"p",22275,"c",0,["McLG1-p22275cB0.m",2]);
AGRTOC("McL",1,"p",22275,"d",0,["McLG1-p22275dB0.m",2]);
AGRTOC("McL",1,"p",113400,"",0,["McLG1-p113400B0.m",2]);
AGRTOC("McL",1,"p",299376,"",0,["McLG1-p299376B0.m",2]);
AGRTOC("McL",1,"f",2,22,"",0,["McLG1-f2r22B0.m",2]);
AGRTOC("McL",1,"f",2,230,"",0,["McLG1-f2r230B0.m",2]);
AGRTOC("McL",1,"f",2,748,"a",0,["McLG1-f2r748aB0.m",2]);
AGRTOC("McL",1,"f",2,748,"b",0,["McLG1-f2r748bB0.m",2]);
AGRTOC("McL",1,"f",3,21,"",0,["McLG1-f3r21B0.m",2]);
AGRTOC("McL",1,"f",3,104,"a",0,["McLG1-f3r104aB0.m",2]);
AGRTOC("McL",1,"f",3,104,"b",0,["McLG1-f3r104bB0.m",2]);
AGRTOC("McL",1,"f",3,210,"",0,["McLG1-f3r210B0.m",2]);
AGRTOC("McL",1,"f",3,560,"",0,["McLG1-f3r560B0.m",2]);
AGRTOC("McL",1,"f",5,21,"",0,["McLG1-f5r21B0.m",2]);
AGRTOC("McL",1,"f",5,210,"",0,["McLG1-f5r210B0.m",2]);
AGRTOC("McL",1,"f",5,230,"",0,["McLG1-f5r230B0.m",2]);
AGRTOC("McL",1,"f",5,560,"",0,["McLG1-f5r560B0.m",2]);
AGRTOC("McL",1,"f",7,22,"",0,["McLG1-f7r22B0.m",2]);
AGRTOC("McL",1,"f",7,231,"",0,["McLG1-f7r231B0.m",2]);
AGRTOC("McL",1,"f",7,252,"",0,["McLG1-f7r252B0.m",2]);
AGRTOC("McL",1,"f",11,22,"",0,["McLG1-f11r22B0.m",2]);
AGRTOC("McL",1,"f",11,231,"",0,["McLG1-f11r231B0.m",2]);
AGRTOC("McL",1,"f",11,251,"",0,["McLG1-f11r251B0.m",2]);
AGRTOC("McL",1,"f",25,1200,"a",0,["McLG1-f25r1200aB0.m",2]);
AGRTOC("McL",1,"C","McLG1-cycW1");
AGRTOC("McL",1,"M",1,"McLG1-max1W1");
AGRTOC("McL",1,"M",2,"McLG1-max2W1");
AGRTOC("McL",1,"M",3,"McLG1-max3W1");
AGRTOC("McL",1,"M",4,"McLG1-max4W1");
AGRTOC("McL",1,"M",5,"McLG1-max5W1");
AGRTOC("McL",1,"M",6,"McLG1-max6W1");
AGRTOC("McL",1,"M",7,"McLG1-max7W1");
AGRTOC("McL",1,"M",8,"McLG1-max8W1");
AGRTOC("McL",1,"M",9,"McLG1-max9W1");
AGRTOC("McL",1,"M",10,"McLG1-max10W1");
AGRTOC("McL",1,"M",11,"McLG1-max11W1");
AGRTOC("McL",1,"M",12,"McLG1-max12W1");

# McLd2
AGRGRP("spor","McL","McLd2");
AGRTOC("McLd2",1,"p",275,"",0,["McLd2G1-p275B0.m",2]);
AGRTOC("McLd2",1,"p",4050,"",0,["McLd2G1-p4050B0.m",2]);
AGRTOC("McLd2",1,"p",7128,"",0,["McLd2G1-p7128B0.m",2]);
AGRTOC("McLd2",1,"p",22275,"a",0,["McLd2G1-p22275aB0.m",2]);
AGRTOC("McLd2",1,"p",44550,"",0,["McLd2G1-p44550B0.m",2]);
AGRTOC("McLd2",1,"f",2,22,"",0,["McLd2G1-f2r22B0.m",2]);
AGRTOC("McLd2",1,"f",3,21,"a",0,["McLd2G1-f3r21aB0.m",2]);
AGRTOC("McLd2",1,"f",3,104,"a",0,["McLd2G1-f3r104aB0.m",2]);
AGRTOC("McLd2",1,"f",5,21,"a",0,["McLd2G1-f5r21aB0.m",2]);
AGRTOC("McLd2",1,"f",7,22,"a",0,["McLd2G1-f7r22aB0.m",2]);
AGRTOC("McLd2",1,"f",11,22,"a",0,["McLd2G1-f11r22aB0.m",2]);

# 3ON
AGRGRP("spor","ON","3ON");
AGRTOC("3ON",1,"f",4,153,"",0,["3ONG1-f4r153B0.m",2]);
AGRTOC("3ON",1,"f",7,45,"a",0,["3ONG1-f7r45aB0.m",2]);
AGRTOC("3ON",1,"f",7,45,"b",0,["3ONG1-f7r45bB0.m",2]);

# 3ONd2
AGRGRP("spor","ON","3ONd2");
AGRTOC("3ONd2",1,"f",2,306,"",0,["3ONd2G1-f2r306B0.m",2]);
AGRTOC("3ONd2",1,"f",7,90,"",0,["3ONd2G1-f7r90B0.m",2]);

# ON
AGRGRP("spor","ON","ON");
AGRTOC("ON",1,"p",122760,"a",0,["ONG1-p122760aB0.m",2]);
AGRTOC("ON",1,"f",3,154,"",0,["ONG1-f3r154B0.m",2]);
AGRTOC("ON",1,"f",3,495,"",0,["ONG1-f3r495B0.m",2]);
AGRTOC("ON",1,"f",7,406,"",0,["ONG1-f7r406B0.m",2]);
AGRTOC("ON",1,"f",7,1618,"",0,["ONG1-f7r1618B0.m",2]);
AGRTOC("ON",1,"f",31,1869,"",0,["ONG1-f31r1869B0.m",2]);
AGRTOC("ON",1,"C","ONG1-cycW1");
AGRTOC("ON",1,"M",1,"ONG1-max1W1");
AGRTOC("ON",1,"M",2,"ONG1-max2W1");
AGRTOC("ON",1,"M",3,"ONG1-max3W1");
AGRTOC("ON",1,"M",4,"ONG1-max4W1");
AGRTOC("ON",1,"M",5,"ONG1-max5W1");
AGRTOC("ON",1,"M",6,"ONG1-max6W1");
AGRTOC("ON",1,"M",7,"ONG1-max7W1");
AGRTOC("ON",1,"M",8,"ONG1-max8W1");
AGRTOC("ON",1,"M",9,"ONG1-max9W1");
AGRTOC("ON",1,"M",10,"ONG1-max10W1");
AGRTOC("ON",1,"M",11,"ONG1-max11W1");
AGRTOC("ON",1,"M",12,"ONG1-max12W1");
AGRTOC("ON",1,"M",13,"ONG1-max13W1");

# ONd2
AGRGRP("spor","ON","ONd2");
AGRTOC("ONd2",1,"f",9,154,"",0,["ONd2G1-f9r154B0.m",2]);
AGRTOC("ONd2",1,"M",1,"ONd2G1-max1W1");

# ONd4
AGRGRP("spor","ON","ONd4");
AGRTOC("ONd4",1,"f",3,154,"",0,["ONd4G1-f3r154B0.m",2]);

# 2Ru
AGRGRP("spor","Ru","2Ru");
AGRTOC("2Ru",1,"p",16240,"",0,["2RuG1-p16240B0.m",2]);
AGRTOC("2Ru",1,"f",3,56,"",0,["2RuG1-f3r56B0.m",2]);
AGRTOC("2Ru",1,"f",5,28,"",0,["2RuG1-f5r28B0.m",2]);
AGRTOC("2Ru",1,"f",5,912,"",0,["2RuG1-f5r912B0.m",2]);
AGRTOC("2Ru",1,"f",7,56,"",0,["2RuG1-f7r56B0.m",2]);
AGRTOC("2Ru",1,"f",9,28,"",0,["2RuG1-f9r28B0.m",2]);
AGRTOC("2Ru",1,"f",13,28,"",0,["2RuG1-f13r28B0.m",2]);
AGRTOC("2Ru",1,"f",29,28,"",0,["2RuG1-f29r28B0.m",2]);
AGRTOC("2Ru",1,"f",49,28,"",0,["2RuG1-f49r28B0.m",2]);

# Ru
AGRGRP("spor","Ru","Ru");
AGRTOC("Ru",1,"p",4060,"",0,["RuG1-p4060B0.m",2]);
AGRTOC("Ru",1,"f",2,28,"",0,["RuG1-f2r28B0.m",2]);
AGRTOC("Ru",1,"f",2,376,"",0,["RuG1-f2r376B0.m",2]);
AGRTOC("Ru",1,"f",2,1246,"",0,["RuG1-f2r1246B0.m",2]);
AGRTOC("Ru",1,"f",3,406,"",0,["RuG1-f3r406B0.m",2]);
AGRTOC("Ru",1,"f",3,783,"",0,["RuG1-f3r783B0.m",2]);
AGRTOC("Ru",1,"f",5,133,"",0,["RuG1-f5r133B0.m",2]);
AGRTOC("Ru",1,"f",5,273,"",0,["RuG1-f5r273B0.m",2]);
AGRTOC("Ru",1,"f",5,378,"",0,["RuG1-f5r378B0.m",2]);
AGRTOC("Ru",1,"f",5,783,"",0,["RuG1-f5r783B0.m",2]);
AGRTOC("Ru",1,"f",7,406,"",0,["RuG1-f7r406B0.m",2]);
AGRTOC("Ru",1,"f",7,782,"",0,["RuG1-f7r782B0.m",2]);
AGRTOC("Ru",1,"f",9,378,"",0,["RuG1-f9r378B0.m",2]);
AGRTOC("Ru",1,"f",13,378,"",0,["RuG1-f13r378B0.m",2]);
AGRTOC("Ru",1,"f",13,406,"",0,["RuG1-f13r406B0.m",2]);
AGRTOC("Ru",1,"f",13,783,"",0,["RuG1-f13r783B0.m",2]);
AGRTOC("Ru",1,"f",29,378,"",0,["RuG1-f29r378B0.m",2]);
AGRTOC("Ru",1,"f",29,406,"",0,["RuG1-f29r406B0.m",2]);
AGRTOC("Ru",1,"f",29,783,"",0,["RuG1-f29r783B0.m",2]);
AGRTOC("Ru",1,"f",49,378,"",0,["RuG1-f49r378B0.m",2]);
AGRTOC("Ru",1,"C","RuG1-cclsW1");
AGRTOC("Ru",1,"C","RuG1-cycW1");
AGRTOC("Ru",1,"M",1,"RuG1-max1W1");
AGRTOC("Ru",1,"M",2,"RuG1-max2W1");
AGRTOC("Ru",1,"M",3,"RuG1-max3W1");
AGRTOC("Ru",1,"M",4,"RuG1-max4W1");
AGRTOC("Ru",1,"M",5,"RuG1-max5W1");

# 2Suz
AGRGRP("spor","Suz","2Suz");
AGRTOC("2Suz",1,"f",3,12,"",0,["2SuzG1-f3r12B0.m",2]);
AGRTOC("2Suz",1,"f",3,208,"",0,["2SuzG1-f3r208B0.m",2]);
AGRTOC("2Suz",1,"f",3,352,"",0,["2SuzG1-f3r352B0.m",2]);

# 2Suzd2
AGRGRP("spor","Suz","2Suzd2");
AGRTOC("2Suzd2",1,"f",3,12,"a",0,["2Suzd2G1-f3r12aB0.m",2]);

# 3Suz
AGRGRP("spor","Suz","3Suz");
AGRTOC("3Suz",1,"f",4,12,"a",0,["3SuzG1-f4r12aB0.m",2]);
AGRTOC("3Suz",1,"f",25,66,"a",0,["3SuzG1-f25r66aB0.m",2]);

# 3Suzd2
AGRGRP("spor","Suz","3Suzd2");
AGRTOC("3Suzd2",1,"p",5346,"",0,["3Suzd2G1-p5346B0.m",2]);
AGRTOC("3Suzd2",1,"f",2,24,"",0,["3Suzd2G1-f2r24B0.m",2]);
AGRTOC("3Suzd2",1,"f",5,132,"",0,["3Suzd2G1-f5r132B0.m",2]);
AGRTOC("3Suzd2",1,"f",7,132,"",0,["3Suzd2G1-f7r132B0.m",2]);
AGRTOC("3Suzd2",1,"f",11,132,"",0,["3Suzd2G1-f11r132B0.m",2]);

# 6Suz
AGRGRP("spor","Suz","6Suz");
AGRTOC("6Suz",1,"f",7,12,"a",0,["6SuzG1-f7r12aB0.m",2]);
AGRTOC("6Suz",1,"f",13,12,"a",0,["6SuzG1-f13r12aB0.m",2]);
AGRTOC("6Suz",1,"f",25,12,"a",0,["6SuzG1-f25r12aB0.m",2]);

# 6Suzd2
AGRGRP("spor","Suz","6Suzd2");
AGRTOC("6Suzd2",1,"f",3,24,"",0,["6Suzd2G1-f3r24B0.m",2]);
AGRTOC("6Suzd2",1,"f",5,24,"",0,["6Suzd2G1-f5r24B0.m",2]);
AGRTOC("6Suzd2",1,"f",11,24,"",0,["6Suzd2G1-f11r24B0.m",2]);

# Suz
AGRGRP("spor","Suz","Suz");
AGRTOC("Suz",1,"p",1782,"",0,["SuzG1-p1782B0.m",2]);
AGRTOC("Suz",1,"p",22880,"",0,["SuzG1-p22880B0.m",2]);
AGRTOC("Suz",1,"p",32760,"",0,["SuzG1-p32760B0.m",2]);
AGRTOC("Suz",1,"f",2,142,"",0,["SuzG1-f2r142B0.m",2]);
AGRTOC("Suz",1,"f",2,638,"",0,["SuzG1-f2r638B0.m",2]);
AGRTOC("Suz",1,"f",3,64,"",0,["SuzG1-f3r64B0.m",2]);
AGRTOC("Suz",1,"f",3,78,"",0,["SuzG1-f3r78B0.m",2]);
AGRTOC("Suz",1,"f",3,286,"",0,["SuzG1-f3r286B0.m",2]);
AGRTOC("Suz",1,"f",3,429,"",0,["SuzG1-f3r429B0.m",2]);
AGRTOC("Suz",1,"f",3,649,"",0,["SuzG1-f3r649B0.m",2]);
AGRTOC("Suz",1,"f",4,110,"a",0,["SuzG1-f4r110aB0.m",2]);
AGRTOC("Suz",1,"f",4,572,"a",0,["SuzG1-f4r572aB0.m",2]);
AGRTOC("Suz",1,"f",4,572,"b",0,["SuzG1-f4r572bB0.m",2]);
AGRTOC("Suz",1,"f",5,143,"",0,["SuzG1-f5r143B0.m",2]);
AGRTOC("Suz",1,"f",5,363,"",0,["SuzG1-f5r363B0.m",2]);
AGRTOC("Suz",1,"f",5,780,"",0,["SuzG1-f5r780B0.m",2]);
AGRTOC("Suz",1,"f",7,143,"",0,["SuzG1-f7r143B0.m",2]);
AGRTOC("Suz",1,"f",7,364,"",0,["SuzG1-f7r364B0.m",2]);
AGRTOC("Suz",1,"f",7,780,"",0,["SuzG1-f7r780B0.m",2]);
AGRTOC("Suz",1,"f",11,143,"",0,["SuzG1-f11r143B0.m",2]);
AGRTOC("Suz",1,"f",11,364,"",0,["SuzG1-f11r364B0.m",2]);
AGRTOC("Suz",1,"f",11,779,"",0,["SuzG1-f11r779B0.m",2]);
AGRTOC("Suz",1,"f",13,143,"",0,["SuzG1-f13r143B0.m",2]);
AGRTOC("Suz",1,"f",13,364,"",0,["SuzG1-f13r364B0.m",2]);
AGRTOC("Suz",1,"f",13,780,"",0,["SuzG1-f13r780B0.m",2]);
AGRTOC("Suz",1,"C","SuzG1-cycW1");
AGRTOC("Suz",1,"M",1,"SuzG1-max1W1");
AGRTOC("Suz",1,"M",2,"SuzG1-max2W1");
AGRTOC("Suz",1,"M",3,"SuzG1-max3W1");
AGRTOC("Suz",1,"M",4,"SuzG1-max4W1");
AGRTOC("Suz",1,"M",5,"SuzG1-max5W1");
AGRTOC("Suz",1,"M",6,"SuzG1-max6W1");
AGRTOC("Suz",1,"M",7,"SuzG1-max7W1");
AGRTOC("Suz",1,"M",8,"SuzG1-max8W1");
AGRTOC("Suz",1,"M",9,"SuzG1-max9W1");
AGRTOC("Suz",1,"M",10,"SuzG1-max10W1");
AGRTOC("Suz",1,"M",11,"SuzG1-max11W1");
AGRTOC("Suz",1,"M",12,"SuzG1-max12W1");
AGRTOC("Suz",1,"M",13,"SuzG1-max13W1");
AGRTOC("Suz",1,"M",14,"SuzG1-max14W1");
AGRTOC("Suz",1,"M",15,"SuzG1-max15W1");
AGRTOC("Suz",1,"M",16,"SuzG1-max16W1");
AGRTOC("Suz",1,"M",17,"SuzG1-max17W1");

# Suzd2
AGRGRP("spor","Suz","Suzd2");
AGRTOC("Suzd2",1,"p",1782,"",0,["Suzd2G1-p1782B0.m",2]);
AGRTOC("Suzd2",1,"f",3,64,"a",0,["Suzd2G1-f3r64aB0.m",2]);
AGRTOC("Suzd2",1,"f",5,143,"a",0,["Suzd2G1-f5r143aB0.m",2]);
AGRTOC("Suzd2",1,"f",7,143,"a",0,["Suzd2G1-f7r143aB0.m",2]);
AGRTOC("Suzd2",1,"f",11,143,"a",0,["Suzd2G1-f11r143aB0.m",2]);
AGRTOC("Suzd2",1,"M",1,"Suzd2G1-max1W1");

# Th
AGRGRP("spor","Th","Th");
AGRTOC("Th",1,"f",2,248,"",0,["ThG1-f2r248B0.m",2]);
AGRTOC("Th",1,"f",3,248,"",0,["ThG1-f3r248B0.m",2]);
AGRTOC("Th",1,"f",3,3875,"",0,["ThG1-f3r3875B0.m",2]);
AGRTOC("Th",1,"f",5,248,"",0,["ThG1-f5r248B0.m",2]);
AGRTOC("Th",1,"f",7,248,"",0,["ThG1-f7r248B0.m",2]);
AGRTOC("Th",1,"f",13,248,"",0,["ThG1-f13r248B0.m",2]);
AGRTOC("Th",1,"f",19,248,"",0,["ThG1-f19r248B0.m",2]);
AGRTOC("Th",1,"f",31,248,"",0,["ThG1-f31r248B0.m",2]);
AGRTOC("Th",1,"C","ThG1-cycW1");


#############################################################################
##
#E

