#############################################################################
##
#W  interfac.gd        GAP share package 'atlasrep'             Thomas Breuer
##
#H  @(#)$Id: interfac.gd,v 1.16 2001/02/06 17:01:58 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file contains the declaration part of the ``high level'' {\GAP}
##  interface to the {\ATLAS} of Group Representations.
##
Revision.( "atlasrep/gap/interfac_gd" ) :=
    "@(#)$Id: interfac.gd,v 1.16 2001/02/06 17:01:58 gap Exp $";


#############################################################################
##
#F  DisplayAtlasInfo(  )
#F  DisplayAtlasInfo( <listofnames> )
#F  DisplayAtlasInfo( <gapname>[, <std>] )
#F  DisplayAtlasInfo( <gapname>[, <std>], IsPermGroup )
#F  DisplayAtlasInfo( <gapname>[, <std>], NrMovedPoints, <n> )
#F  DisplayAtlasInfo( <gapname>[, <std>], IsMatrixGroup )
#F  DisplayAtlasInfo( <gapname>[, <std>][, Characteristic, <p>]
#F                                      [, Dimension, <n>] )
#F  DisplayAtlasInfo( <gapname>[, <std>], IsStraightLineProgram )
##
##  `DisplayAtlasInfo' lists the information available via the AtlasRep
##  package, for the given inputs.
##  Depending on the value of the `remote' component of the global variable
##  `AtlasOfGroupRepresentationsInfo'
##  (see~"AtlasOfGroupRepresentationsInfo"), all the data provided by the
##  {\ATLAS} of Group Representations or only that in the local installation
##  is available.
##
##  Called without arguments, `DisplayAtlasInfo' prints an overview what
##  information the {\ATLAS} of Group Representations provides.
##  One line is printed for each group $G$, with the following columns.
##  \beginitems
##  `group' &
##      the {\GAP} name of $G$
##      (see~"Group Names Used in the AtlasRep Package"),
##
##  `\#' &
##      the number of representations stored for $G$,
##
##  `maxes' &
##      the available straight line programs\index{straight line program}
##      for computing maximal subgroups of $G$,
##
##  `cl' &
##      a `+' sign if at least one program for computing representatives
##      of conjugacy classes of elements of $G$ is stored,
##      and a `-' sign otherwise,
##
##  `cyc' &
##      a `+' sign if at least one program for computing representatives of
##      classes of maximally cyclic subgroups of $G$ is stored,
##      and a `-' sign otherwise, and
##
##  `out' &
##      descriptions of outer automorphisms of $G$ for which at least one
##      program is stored.
##  \enditems
##
##  In the second form, <listofnames> must be a list of strings that are
##  {\GAP} names for a group from the {\ATLAS} of Group Representations;
##  in this case, the overview described above is restricted to the groups
##  in this list.
##
##  In the third form, <gapname> must be a string that is a {\GAP} name
##  for a group from the {\ATLAS} of Group Representations;
##  in this case, `DisplayAtlasInfo' prints an overview of the information
##  that is available for this group.
##  One line is printed for each representation, showing the number of this
##  representation
##  (which is used in calls of `AtlasGenerators', see~"AtlasGenerators"),
##  and a string of one of the following forms.
##  `G \<= Sym(<n><id>)' denotes a permutation representation of degree <n>,
##  and `G \<= GL(<n><id>,<descr>)' denotes a matrix representation of
##  dimension <n> over a coefficient ring described by <descr>;
##  in both cases, <id> is a (possible empty) string specifying the
##  representation, for example `G \<= Sym(40a)' and `G \<= Sym(40b)' denote
##  two (nonequivalent) representations of degree $40$.
##  In the case of matrix representations, <descr> can be a prime power,
##  `Z' (denoting the ring of integers),
##  a description of an algebraic extension field,
##  `C' (denoting an unspecified algebraic extension field), or
##  `Z/<m>Z' for an integer <m> (denoting the ring of residues mod <m>);
##  for example, `G \<= GL(2a,4)' and `G \<= GL(2b,4)' denote two
##  (nonequivalent) representations of dimension $2$ over the field with four
##  elements.
##  After the representations, the straight line programs available for
##  <gapname> are listed.
##
##  If the first argument is a string <gapname>, the following optional
##  arguments can be used to restrict the overview.
##  \beginitems
##  <std> &
##      must be a positive integer or a list of positive integers;
##      if it is given then only those representations are considered
##      that refer to the <std>-th set of standard generators or the $i$-th
##      set of standard generators, for $i$ in <std>
##      (see~"Standard Generators Used in the AtlasRep Package"),
##
##  `IsPermGroup' &
##      restricts to permutation representations,
##
##  `NrMovedPoints' and <n> &
##      for a positive integer or a list <n>, restrict to permutation
##      representations of degree <n> or in the list <n>,
##
##  `IsMatrixGroup' &
##      restricts to matrix representations,
##
##  `Characteristic' and <p> &
##      for a prime integer or a list <p>, restrict to matrix representations
##      over fields of characteristic <p> or in the list <p>
##      (representations over residue class rings that are not fields can be
##      addressed by `<p> = fail'),
##
##  `Dimension' and <n> &
##      for a positive integer <n> or a list <n>, restrict to matrix
##      representations of dimension <n> or in the list <n>, and
##
##  `IsStraightLineProgram' &
##      restricts to straight line programs.
##  \enditems
##
##  The representations are ordered as follows.
##  Permutation representations come first (ordered according to the degree),
##  followed by matrix representations over finite fields
##  (ordered first according to the characteristic and second according to
##  the dimension), matrix representations over the integers,
##  and then matrix representations over algebraic extension fields
##  (both kinds ordered according to the dimension),
##  the last representations are matrix representations over residue class
##  rings (ordered first according to the modulus and second according to the
##  dimension).
##
##  Note that in each case, either the whole contents of the database
##  or the contents of the local installation is considered,
##  depending on whether the value of
##  `AtlasOfGroupRepresentationsInfo.remote' is `true' or `false'
##  (see~"AtlasOfGroupRepresentationsInfo").
##
DeclareGlobalFunction( "DisplayAtlasInfo" );


#############################################################################
##
#F  AtlasGenerators( <gapname>, <repnr> )
#F  AtlasGenerators( <gapname>, <repnr>, <maxnr> )
#F  AtlasGenerators( <identifier> )
##
##  In the first two forms, <gapname> must be a string denoting a {\GAP}
##  name (see~"Group Names Used in the AtlasRep Package") of a group,
##  and <repnr> a positive integer.
##  If the {\ATLAS} of Group Representations contains at least <repnr>
##  representations for the group with {\GAP} name <gapname> then
##  `AtlasGenerators', when called with <gapname> and <repnr>,
##  returns an immutable record describing the <repnr>-th representation;
##  otherwise `fail' is returned.
##  If a third argument <maxnr>, a positive integer,
##  is given then an immutable record describing the restriction of the
##  <repnr>-th representation to the <maxnr>-th maximal subgroup is returned.
##
##  The result record has the following components.
##  \beginitems
##  `generators' &
##      a list of generators for the group,
##
##  `standardization' &
##      the positive integer denoting the underlying standard generators,
##
##  `identifier' &
##      a {\GAP} object (a list of filenames plus additional information)
##      that uniquely determines the representation;
##      the value can be used as <identifier> argument of `AtlasGenerators'
##      (see below).
##  \enditems
##  It should be noted that the number <repnr> refers to the number shown
##  by `DisplayAtlasInfo' (see~"DisplayAtlasInfo") *in the current session*;
##  it may be that after the addition of new representations, <repnr> refers
##  to another representation.
##
##  The third form of `AtlasGenerators', with only argument <identifier>,
##  can be used to fetch the result record with `identifier' value equal to
##  <identifier>.
##  The purpose of this variant is to access the *same* representation also
##  in *different* {\GAP} sessions.
##
DeclareGlobalFunction( "AtlasGenerators" );


#############################################################################
##
#F  AtlasStraightLineProgram( <gapname>[, <std>], <maxnr> )
#F  AtlasStraightLineProgram( <gapname>[, <std>], "classes" )
#F  AtlasStraightLineProgram( <gapname>[, <std>], "cyclic" )
#F  AtlasStraightLineProgram( <gapname>[, <std>], "automorphism", <autname> )
#F  AtlasStraightLineProgram( <identifier> )
##
##  In the first four forms, <gapname> must be a string denoting a {\GAP}
##  name (see~"Group Names Used in the AtlasRep Package") of a group $G$,
##  say, and <std> a positive integer denoting the standard generators of $G$
##  used (see~"Standard Generators Used in the AtlasRep Package").
##  If the {\ATLAS} of Group Representations contains a straight line program
##  (see~"ref:Straight Line Programs" in the {\GAP} Reference Manual)
##  as described by the last argument (see below) then
##  `AtlasStraightLineProgram' returns an immutable record with this program,
##  otherwise `fail' is returned.
##
##  If the optional argument <std> is given, only those straight line
##  programs are considered that take generators from the <std>-th set of
##  standard generators of $G$ as input.
##
##  The result record has the following components.
##  \beginitems
##  `program' &
##      the required straight line program,
##
##  `standardization' &
##      the positive integer denoting the underlying standard generators of
##      $G$,
##
##  `identifier' &
##      a {\GAP} object (a list of filenames plus additional information)
##      that uniquely determines the program;
##      the value can be used as <identifier> argument of
##      `AtlasStraightLineProgram' (see below).
##  \enditems
##
##  In the first form, the last argument must be a positive integer <maxnr>,
##  and the required program computes generators of the <maxnr>-th maximal
##  subgroup of the group with {\GAP} name <gapname>.%
##  \index{straight line program!for maximal subgroups}%
##  \index{maximal subgroups}
##
##  In the second form, the last argument is the string `\"classes\"',
##  and the required program computes representatives of conjugacy classes of
##  elements of the group with {\GAP} name <gapname>.%
##  \index{straight line program!for class representatives}%
##  \index{class representatives}
##
##  In the third form, the last argument is the string `\"cyclic\"',
##  and the required program computes representatives of generators of
##  classes of maximally cyclic subgroups of the group with {\GAP} name
##  <gapname>.%
##  \index{straight line program!for representatives of cyclic subgroups}%
##  \index{cyclic subgroups}%
##  \index{maximally cyclic subgroups}
##
##  See~\cite{BSW01} for the background concerning these straight line
##  programs.
##  In the second and third form of `AtlasStraightLineProgram',
##  the result record also contains a component `outputs',
##  whose value is a list of class names of the outputs,
##  as described in Section~"Class Names Used in the AtlasRep Package".
##
##  In the fourth form, the last argument is a string <autname>,
##  and the required program computes images of standard generators under the
##  outer automorphism of the group with {\GAP} name <gapname>
##  that is given by this string.
##  \index{straight line program!for outer automorphisms}%
##  \index{automorphisms}
##
##  The fifth form of `AtlasStraightLineProgram',
##  with only argument <identifier>,
##  can be used to fetch the result record with `identifier' value equal to
##  <identifier>.
##
DeclareGlobalFunction( "AtlasStraightLineProgram" );


#############################################################################
##
#F  OneAtlasGeneratingSet( <gapname>[, <std>] )
#F  OneAtlasGeneratingSet( <gapname>[, <std>], IsPermGroup )
#F  OneAtlasGeneratingSet( <gapname>[, <std>], NrMovedPoints, <n> )
#F  OneAtlasGeneratingSet( <gapname>[, <std>], IsMatrixGroup )
#F  OneAtlasGeneratingSet( <gapname>[, <std>][, Characteristic, <p>]
#F                                           [, Dimension, <m>] )
#F  OneAtlasGeneratingSet( <gapname>[, <std>][, Ring, <R>]
#F                                           [, Dimension, <m>] )
##
##  Let <gapname> be a string.
##  If the {\ATLAS} of Group Representations contains at least one
##  representation for the group $G$ with {\GAP} name <gapname> and with
##  the required properties then `OneAtlasRepresentation' returns
##  an immutable record as described for `AtlasGenerators'
##  (see~"AtlasGenerators") for such a representation;
##  otherwise `fail' is returned.
##  If the argument <std> is given then it must be a positive integer
##  or a list of positive integers, denoting the sets of standard generators
##  w.r.t.~which the representation shall be given
##  (see~"Standard Generators Used in the AtlasRep Package").
##
##  In the first form, `OneAtlasGeneratingSet' returns the first generating
##  set for $G$, in the ordering shown by `DisplayAtlasInfo'
##  (see~"DisplayAtlasInfo").
##  In the remaining forms,
##  `IsPermGroup' and `IsMatrixGroup' restrict to permutation and matrix
##  representations, respectively,
##  `NrMovedPoints' restricts to permutation representations of degree equal
##  to the integer <n> or in the list <n>,
##  `Characteristic' restricts to matrix representations of characteristic
##  equal to the integer <p> or in the list <p> (representations over residue
##  class rings that are not fields can be accessed with `<p> = fail'),
##  `Dimension' restricts to matrix representations of dimension equal to the
##  positive integer <m> or in the list <m>,
##  and `Ring' restricts to matrix representations with matrix entries
##  contained in the ring <R>.
##
DeclareGlobalFunction( "OneAtlasGeneratingSet" );


#############################################################################
##
#E

