#############################################################################
##
#W  scanmtx.gd     share packages 'atlasrep' and 'meataxe'      Thomas Breuer
##
#H  @(#)$Id: scanmtx.gd,v 1.4 2001/03/26 15:39:09 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  Whenever this file is changed in one of the packages
##  `atlasrep' or `meataxe',
##  do not forget to update the corresponding file in the other package!
##
##  This file contains declaration part of the interface routines for reading
##  and writing {\MeatAxe} text format and straight line programs used in the
##  {\ATLAS} of Group Representations.
##
if IsBound( Revision ) then
  Revision.( "atlasrep/gap/scanmtx_gd" ) :=
    "@(#)$Id: scanmtx.gd,v 1.4 2001/03/26 15:39:09 gap Exp $";
  Revision.( "cmeataxe/gap/scanmtx_gd" ) :=
    "@(#)$Id: scanmtx.gd,v 1.4 2001/03/26 15:39:09 gap Exp $";
fi;


#############################################################################
##
#V  InfoCMeatAxe
##
##  If the info level of `InfoCMeatAxe' is at least $1$ then information
##  about `fail' results of C-{\MeatAxe} functions is printed.
##  The default level is $0$, no information is printed on this level.
##
DeclareInfoClass( "InfoCMeatAxe" );


#############################################################################
##
#F  FFList( <F> )
#V  FFLists
##
##  `FFList' is a utility program for the conversion of vectors and matrices
##  from {\MeatAxe} format to {\GAP} format and vice versa.
##  It is used by `ScanMeatAxeFile' (see~"ScanMeatAxeFile")
##  and `MeatAxeString' (see~"MeatAxeString").
##
##  For a finite field <F>, `FFList' returns a list <l>
##  giving the correspondence between the {\MeatAxe} numbering and the {\GAP}
##  numbering of the elements in <F>.
##
##  The element of <F> corresponding to {\MeatAxe} number <n> is
##  `<l>[ <n>+1 ]',
##  and the {\MeatAxe} number of the field element <z> is
##  `Position( <l>, <z> ) - 1'.
##
##  The global variable `FFLists' is used to store the information
##  about <F> once it has been computed.
##
DeclareGlobalFunction( "FFList" );
DeclareGlobalVariable( "FFLists",
    "list of info to translate FFE orderings between GAP and MeatAxe" );


#############################################################################
##
#F  CMeatAxeFileHeaderInfo( <string> )
##
DeclareGlobalFunction( "CMeatAxeFileHeaderInfo" );


#############################################################################
##
#F  ScanMeatAxeFile( <filename>[, <q>] )
#F  ScanMeatAxeFile( <string>[, <q>], "string" )
##
##  Let <filename> be the name of a {\GAP} readable file (see~"ref:Filename"
##  in the {\GAP} Reference Manual) that contains a matrix or a permutation
##  or a list of permutations in {\MeatAxe} text format (see the section
##  about the program `zcv' in the {\MeatAxe} manual~\cite{Rin98}),
##  and let <q> be a prime power.
##  `ScanMeatAxeFile' returns the corresponding {\GAP} matrix
##  or list of permutations, respectively.
#T supports both the ``old'' and the ``new'' text file format!
##
##  The file is read line by line, and the matrix is constructed line by
##  line, in a compressed representation
##  (see~"ref:Row Vectors over Finite Fields"
##  and~"ref:Matrices over Finite Fields" in the {\GAP} Reference Manual),
##  which makes it possible to read large matrices in a reasonable amount
##  of space.
##  If the parameter <q> is given and the result is a matrix then this
##  matrix is represented over the field with <q> elements.
##
##  In the second form, the first argument <string> must be a string as
##  obtained by reading a file in {\MeatAxe} text format as a text stream
##  (see~"ref:InputTextFile" in the {\GAP} Reference Manual),
##  and the third argument the string `\"string\"'.
##  Also in this case, `ScanMeatAxeFile' returns the corresponding {\GAP}
##  matrix or list of permutations, respectively.
##
DeclareGlobalFunction( "ScanMeatAxeFile" );


#############################################################################
##
#O  MeatAxeString( <mat>, <q> )
#O  MeatAxeString( <perms>, <degree> )
#O  MeatAxeString( <perm>, <q>, <dims> )
##
##  In the first form, for a matrix <mat> whose entries lie in the finite
##  field with <q> elements, `MeatAxeString' returns a string that encodes
##  <mat> as a matrix over `GF(<q>)', in {\MeatAxe} text format.
##
##  In the second form, for a nonempty list <perms> of permutations that move
##  only points up to the positive integer <degree>,
##  `MeatAxeString' returns a string that encodes <perms> as permutations of
##  degree <degree>, in {\MeatAxe} text format.
##
##  In the third form, for a permutation <perm> with largest moved point $n$,
##  say, a prime power <q>, and a list <dims> of length $2$ containing two
##  positive integers larger than or equal to $n$,
##  `MeatAxeString' returns a string that encodes <perm> as a matrix over
##  `GF(<q>)', of dimensions <dims>, whose first $n$ rows and columns
##  describe the permutation matrix corresponding to <perm>,
##  and the remaining rows and columns are zero.
#T The strings are in *old* format!
##
DeclareOperation( "MeatAxeString", [ IsTable, IsPosInt ] );
DeclareOperation( "MeatAxeString",
    [ IsPermCollection and IsList, IsPosInt ] );
DeclareOperation( "MeatAxeString", [ IsPerm, IsPosInt, IsList ] );


#############################################################################
##
#F  ScanStraightLineProgram( <filename> )
#F  ScanStraightLineProgram( <string>, "string" )
##
##  Let <filename> be the name of a file that contains a straight line
##  program in the sense that it consists only of lines in the following
##  form.
##  \beginitems
##  \item{}
##  `\# <anything>' &
##      lines starting with a hash sign `\#' are ignored,
##
##  `echo <anything>' &
##      lines starting with `echo' are ignored for the `program' component
##      of the result record (see below),
##      they are used to set up the bijection between the labels used in
##      the program and conjugacy class names in the case that the program
##      computes dedicated class representatives,
##
##  `inp <n>' &
##      means that there are <n> inputs, referred to via the labels
##      `1', `2', $\ldots$, <n>,
##
##  `inp <k> <a1> <a2> ... <ak>' &
##      means that the next <k> inputs are referred to via the labels
##      <a1>, <a2>, ..., <ak>,
##
##  `cjr <a> <b>' &
##      means that <a> is replaced by `<b>^(-1) <a> <b>',
##
##  `cj <a> <b> <c>' &
##      means that <c> is defined as `<b>^(-1) <a> <b>',
##
##  `com <a> <b> <c>' &
##      means that <c> is defined as `<a>^(-1) <b>^(-1) <a> <b>',
##
##  `iv <a> <b>' &
##      means that <b> is defined as `<a>^(-1)',
##
##  `mu <a> <b> <c>' &
##      means that <c> is defined as `<a>*<b>',
##
##  `pwr <a> <b> <c>' &
##      means that <c> is defined to be `<b>^<a>', and
##
##  `cp <a> <b>' &
##      means that <b> is defined as a copy of <a>,
##
##  `oup <l>' &
##      means that there are <l> outputs, stored in the labels `1', `2',
##      $\ldots$, <l>,
##
##  `oup <l> <b1> <b2> ... <bl>' &
##      means that the next <l> outputs are stored in the labels
##      <b1>, <b2>, ... <bl>.
##  \enditems
##
##  Each of the labels <a>, <b>, <c> can be any nonempty sequence of digits
##  and alphabet characters,
##  except that the first argument of `pwr' must denote an integer.
##
##  If the `inp' or `oup' statements are missing then the input or output,
##  respectively, is assumed to be given by the labels `1' and `2'.
##  There can be multiple `inp' lines at the beginning of the program
##  and multiple `oup' lines at the end of the program.
##  Only the first `inp' or `oup' line may omit the names of the elements.
##  No command except cjr may overwrite its own input.
##
##  `ScanStraightLineProgram' returns a record containing as the value of its
##  component `program' the corresponding {\GAP} straight line program
##  (see~"ref:IsStraightLineProgram" in the {\GAP} Reference Manual)
##  if the input string satisfies the syntax rules stated above,
##  and returns `fail' otherwise.
##  In the latter case, information about the first corrupted line of the
##  program is printed if the info level of `InfoCMeatAxe' is at least $1$
##  (see~"InfoCMeatAxe").
##
##  In the second form, the first argument <string> must be a string as
##  obtained by reading a file in {\MeatAxe} text format as a text stream
##  (see~"ref:InputTextFile" in the {\GAP} Reference Manual),
##  and the second argument the string `\"string\"'.
##  Also in this case, `ScanStraightLineProgram' returns either a record with
##  the corresponding {\GAP} straight line program or `fail'.
##
##  If the input describes a straight line program that computes certain
##  class representatives of the group in question then the result record
##  also contains the component `outputs'.
##  Its value is a list of strings, the entry at position $i$ denoting the
##  name of the class in which the $i$ output of the straight line program
##  lies;
##  see~"Class Names Used in the AtlasRep Package" for the definition of the
##  class names that occur.
##
##  Such straight line programs must end with a sequence of output
##  specifications of the following form.
##
##  \begintt
##  echo "Classes 1A 2A 3A 5A 5B"
##  oup 5 3 1 2 4 5
##  \endtt
##
##  This example means that the list of outputs of the program contains
##  elements of the classes `1A', `2A', `3A', `5A', and `5B' (in this order),
##  and that inside the program, these elements are referred to by the names
##  `3', `1', `2', `4', and `5'.
##
DeclareGlobalFunction( "ScanStraightLineProgram" );


#############################################################################
##
#F  AtlasStringOfStraightLineProgram( <prog>[, <outputnames>] )
##
##  For a straight line program <prog> (see~"ref:IsStraightLineProgram" in
##  the {\GAP} Reference Manual), `AtlasStringOfStraightLineProgram' returns
##  a string describing the format of an equivalent straight line program
##  as used in the {\ATLAS} of Group Representations, that is,
##  the lines are of the form described in~"ScanStraightLineProgram".
##
##  A list of strings that is given as the optional second argument
##  <outputnames> is interpreted as the class names corresponding to the
##  outputs; this argument has the effect that appropriate `echo' statements
##  appear in the result string.
##
DeclareGlobalFunction( "AtlasStringOfStraightLineProgram" );


#############################################################################
##
#E

