#############################################################################
##
#W  test.gd            GAP share package `atlasrep'             Thomas Breuer
##
#H  @(#)$Id: test.gd,v 1.16 2001/03/26 15:37:05 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file contains the declaration of functions to test the data
##  available in the {\ATLAS} of Group Representations.
##
##  1. Sanity Checks for the Atlas of Group Representations
##     (These checks are performed when `atlasrep.tst' is read.)
##  2. Further Tests
##     (These checks are *not* performed automatically when
##     `tst/atlasrep.tst' is read since they require server access
##     or are very time consuming.
##
Revision.( "atlasrep/gap/test_gd" ) :=
    "@(#)$Id: test.gd,v 1.16 2001/03/26 15:37:05 gap Exp $";


#############################################################################
##
##  1. Sanity Checks for the Atlas of Group Representations
##     (These checks are performed when `atlasrep.tst' is read.)
#1
##  The fact that the {\ATLAS} of Group Representations is designed as an
##  open database
##  (see~"Local or Remote Installation of the AtlasRep Share Package")
##  makes it especially desirable to have consistency checks available
##  which can be run automatically
##  whenever new data are entered by the developers of the {\ATLAS};
##  thus these checks are mainly thought for them.
##
##  The file `atlasrep.tst' in the `tst' directory of the package contains
##  a collection of such sanity checks;
##  one can run them by starting {\GAP} in the `tst' directory,
##  and calling `ReadTest( \"atlasrep.tst\" )',
##  see~"ref:ReadTest" in the {\GAP} Reference Manual.
##
##  The functions available to perform these tests and detailed information
##  about them can be found in the files `test.gd' and `test.gi' in the `gap'
##  directory of the package.
##
##  All these tests apply only to the *local* table of contents
##  (see~"The Tables Of Contents of the Atlas of Group Representations"),
##  that is, only those data files are checked that are actually available
##  in the local {\GAP} installation.
##
##  The examples in this manual are collected in the file `docxpl.tst' in the
##  `tst' directory of the package;
##  analogeously to the tests mentioned above, one can run them by starting
##  {\GAP} in the `tst' directory and calling `ReadTest( \"docxpl.tst\" )'.
##


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestWords()
#F  AtlasOfGroupRepresentationsTestWords( <groupname>, <filename> )
##
##  Called with two arguments <groupname> and <filename>, both strings,
##  `AtlasOfGroupRepresentationsTestWords' reads the straight line program
##  concerning the group with name <groupname> that is stored in the file
##  with name <filename>,
##  using `ScanStraightLineProgram' (see~"ScanStraightLineProgram"),
##  and then runs the program on abstract generators.
##  If an error occurs then `false' is returned, otherwise `true'.
##
##  Called without arguments,
##  `AtlasOfGroupRepresentationsTestWords' runs the above test for all
##  filenames <filename> stored in the local `dataword' directory;
##  the return value is `false' if an error occurs, otherwise `true'.
##
DeclareGlobalFunction( "AtlasOfGroupRepresentationsTestWords" );


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestFileHeaders()
#F  AtlasOfGroupRepresentationsTestFileHeaders( <groupname> )
#F  AtlasOfGroupRepresentationsTestFileHeaders( <groupname>, <type>,
#F                                              <tocentry> )
##
##  First suppose that `AtlasOfGroupRepresentationsTestFileHeaders' is called
##  with three arguments
##  <groupname> (a name of a group),
##  <type> (the type of the representation in question,
##  given by a component name in the <groupname> record of
##  `AtlasOfGroupRepresentationsInfo.TableOfContents.( "local" )'),
##  and <tocentry> (a list that appears as an entry in the <type> list of the
##  local data available for <groupname>);
##  if the data files of <tocentry> are in {\MeatAxe} text format then it is
##  checked whether for each file, the name and the header line are
##  consistent,
##  and if there is only one data file in {\GAP} format then it is checked
##  whether the file name is consistent with the contents of the file.
##
##  If only one argument <groupname> is given then all representations
##  available for <groupname> are checked with the three argument version.
##
##  If no argument is given then all available groups are checked with the
##  one argument version.
##
##  In all cases, the return value is `false' if an error occurred,
##  and `true' otherwise.
##
DeclareGlobalFunction( "AtlasOfGroupRepresentationsTestFileHeaders" );


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestStandardization()
#F  AtlasOfGroupRepresentationsTestStandardization( <groupname> )
#F  AtlasOfGroupRepresentationsTestStandardization( <groupname>, <type>,
#F                                                  <tocentry> )
##
##  *@As soon as the definition of standard generators becomes transparent
##  in {\GAP}, this function should be provided!@*
##
DeclareGlobalFunction( "AtlasOfGroupRepresentationsTestStandardization" );


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestCharZeroFields()
##
##  The information stored in `AtlasOfGroupRepresentationsInfo.fieldinfo' is
##  compared with the actual contents of those files of matrix
##  representations over proper extension fields of the rational number field
##  that are stored in the local data directories.
##  If no differences are found then `true' is returned,
##  otherwise the differences are printed, and `false' is returned.
##
DeclareGlobalFunction( "AtlasOfGroupRepresentationsTestCharZeroFields" );


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestTableOfContentsContainment()
##
##  It is checked whether the local table of contents is a subset of the
##  currently stored version of the table of contents of the server,
##  and if so then `true' is returned, otherwise `false'.
##  For the files in the local data directories that are not part of the
##  remote data, information lines are printed.
##
DeclareGlobalFunction(
    "AtlasOfGroupRepresentationsTestTableOfContentsContainment" );


#############################################################################
##
##  2. Further Tests
##     (These checks are *not* performed automatically when
##     `tst/atlasrep.tst' is read since they require server access
##     or are very time consuming.
##


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestTableOfContentsRemoteUpdates()
##
##  It is checked whether files in the local data directories must be updated
##  because of changes of the corresponding files in the remote data
##  directories.
##  For each local file whose creation date is earlier than that of the
##  corresponding remote file, an information line is printed.
##
##  (Note that touching files without changing the contents will confuse this
##  function.)
##
DeclareGlobalFunction(
    "AtlasOfGroupRepresentationsTestTableOfContentsRemoteUpdates" );


#############################################################################
##
#F  AtlasOfGroupRepresentationsToDoInMakeTOC( <flags>, <filename> )
##
##  This function is called in the script `etc/maketoc' of the AtlasRep
##  package.
##  It calls `ReloadAtlasTableOfContents' with argument `\"remote\"' and then
##  appends the output of `StringOfAtlasTableOfContents( \"remote\" )' to the
##  file with name <filename>.
##
##  If the list <flags> contains the string `\"-v\"' then the level of
##  `InfoAtlasRep' is set to $3$ in the beginning.
##
##  If the list <flags> contains the string `\"-test\"' then the functions
##  `AtlasOfGroupRepresentationsTestTableOfContentsContainment' and
##  `AtlasOfGroupRepresentationsTestTableOfContentsRemoteUpdates' are called
##  after the modified file <filename> has been read.
##
DeclareGlobalFunction( "AtlasOfGroupRepresentationsToDoInMakeTOC" );


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestFiles()
#F  AtlasOfGroupRepresentationsTestFiles( <groupname> )
##
##  `AtlasOfGroupRepresentationsTestFiles' is an analogue of
##  `AtlasOfGroupRepresentationsTestFileHeaders'.
##  The function does not check if the first line of a {\MeatAxe} file is
##  consistent with the filename
##  but checks whether reading the files with `ScanMeatAxeFile' returns
##  non-`fail' results.
##
##  In all cases, the return value is `false' if an error occurred,
##  and `true' otherwise.
##
DeclareGlobalFunction( "AtlasOfGroupRepresentationsTestFiles" );


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestClassScripts()
#F  AtlasOfGroupRepresentationsTestClassScripts( <groupname> )
##
##  First suppose that `AtlasOfGroupRepresentationsTestClassScripts' is
##  called with one argument <groupname>, the name of a component in
##  `AtlasOfGroupRepresentationsInfo.TableOfContents.( "local" )'.
##  If the {\GAP} table library contains an ordinary character table with
##  `Identifier' value the {\GAP} name corresponding to <groupname> then
##  it is checked whether all those straight line programs for this group
##  that return class representatives are consistent with the character table
##  in the sense that the class names used occur for the table, and that the
##  element orders and centralizer orders for the classes are correct.
##
##  If no argument is given then all available groups are checked with the
##  one argument version.
##
##  In all cases, the return value is `false' if an error occurred,
##  and `true' otherwise.
##
DeclareGlobalFunction( "AtlasOfGroupRepresentationsTestClassScripts" );


#############################################################################
##
#E

