#############################################################################
##
#W  test.gi            GAP share package `atlasrep'             Thomas Breuer
##
#H  @(#)$Id: test.gi,v 1.27 2001/03/29 16:13:50 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file contains functions to test the data available in the
##  {\ATLAS} of Group Representations.
##
Revision.( "atlasrep/gap/test_gi" ) :=
    "@(#)$Id: test.gi,v 1.27 2001/03/29 16:13:50 gap Exp $";


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestWords()
#F  AtlasOfGroupRepresentationsTestWords( <groupname>, <filename> )
#F  AtlasOfGroupRepresentationsTestWords( <groupname>, <filename>, <output> )
##
InstallGlobalFunction( AtlasOfGroupRepresentationsTestWords, function( arg )

    local result, toc, name, r, pair, filename, prog, prg, gens;

    # Initialize the result.
    result:= true;

    if Length( arg ) = 0 then

      # Extract the contents of the local `dataword' directory
      # from the table of contents, and loop over the filenames.
      ReloadAtlasTableOfContents( "local" );
      toc:= AtlasTableOfContents( "local" );
      for name in toc.groupnames do
        if IsBound( toc.TableOfContents.( name[3] ) ) then
          r:= toc.TableOfContents.( name[3] );

          # Note that the ordering in the `and' statement must not be
          # changed, in order to execute all tests!
          for pair in Concatenation( Concatenation( Compacted( r.maxes ) ),
                                     r.maxstd ) do
            result:= AtlasOfGroupRepresentationsTestWords( name[3], pair[2],
                         false ) and result;
          od;
          for pair in r.classes do
            result:= AtlasOfGroupRepresentationsTestWords( name[3], pair[2],
                         true ) and result;
          od;

        fi;
      od;

    elif Length( arg ) = 2 and IsString( arg[1] ) and IsString( arg[2] ) then

      result:= AtlasOfGroupRepresentationsTestWords( arg[1], arg[2], false );

    elif Length( arg ) = 3 and IsString( arg[1] ) and IsString( arg[2] )
                           and IsBool( arg[3] ) then

      # Read the program.
      filename:= FilenameAtlas( "dataword", arg[1], arg[2] );
      if filename = fail then
        Info( InfoAtlasRep, 1,
              "no filename `dataword/", arg[2], "' for `", arg[1], "'" );
        return false;
      fi;
      prog:= ScanStraightLineProgram( filename );

      # Check consistency.
      if prog = fail or not IsInternallyConsistent( prog.program ) then
        Info( InfoAtlasRep, 1,
              "program `dataword/", arg[2], "' not internally consistent" );
        return false;
      fi;
      prg:= prog.program;

      # Create the list of (trivial) generators.
      gens:= ListWithIdenticalEntries( NrInputsOfStraightLineProgram( prg ),
                                       () );

      # Run the program.
      gens:= ResultOfStraightLineProgram( prg, gens );

      # If the script computes class representatives then
      # check whether there is an `outputs' component of the right length.
      if arg[3] then
        if not IsBound( prog.outputs ) then
          Info( InfoAtlasRep, 1,
                "program `dataword/", arg[2],
                "' without component `outputs'" );
          return false;
        elif Length( prog.outputs ) <> Length( gens ) then
          Info( InfoAtlasRep, 1,
                "program `dataword/", arg[2],
                "' with wrong number of `outputs'" );
          return false;
        fi;
      fi;

    else
      Error( "usage: AtlasOfGroupRepresentationsTestWords( ",
             "[<name>, <filename>] )" );
    fi;

    # Return the result.
    return result;
end );


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestFileHeaders( [<groupname>[, <type>,
#F                                              <tocentry>]] )
##
InstallGlobalFunction( AtlasOfGroupRepresentationsTestFileHeaders,
    function( arg )

    local result,
          toc,
          groupname,
          type,
          tocentry,
          len,
          filenames,
          name,
          filename,
          file,
          line,
          mats,
          dim,
          record,
          entry,
          triple;

    # Initialize the result.
    result:= true;

    if   Length( arg ) = 4 then

      groupname := arg[1];
      type      := arg[2];
      tocentry  := arg[3];
      name      := arg[4];

      # Read the first line of the file.
      filename:= FilenameAtlas( "datagens", groupname, name );
      if filename = fail then
        Info( InfoAtlasRep, 1,
              "filename `datagens/",name,"' not found" );
        return false;
      fi;
      file:= InputTextFile( filename );
      if file = fail then
        Info( InfoAtlasRep, 1,
              "cannot create input stream for file `",filename,"'" );
        return false;
      fi;
      InfoRead1( "#I  reading `",filename,"' started\n" );
      line:= ReadLine( file );
      if line = fail then
        CloseStream( file );
        Info( InfoAtlasRep, 2,
              "no first line in file `",filename,"'" );
        return false;
      fi;
      CloseStream( file );
      InfoRead1( "#I  reading `",filename,"' done\n" );

      # The header must consist of four nonnegative integers.
      line:= CMeatAxeFileHeaderInfo( line );
      if line = fail then
        Info( InfoAtlasRep, 1,
              "illegal header of file `", filename,"'" );
        return false;
      fi;

      if type = "perm" then

        # Check mode, number of permutations, and degree.
        if   line[1] <> 12 then
          Info( InfoAtlasRep, 1,
                "mode of file `datagens/", name, "' differs from 12" );
          return false;
        elif line[4] <> 1 then
          Info( InfoAtlasRep, 1,
                "more than one permutation in file `datagens/", name,
                "'" );
          return false;
        elif line[3] <> tocentry[2] then
          Info( InfoAtlasRep, 1,
                "perm. degree in file `datagens/", name, "' is ", line[3] );
          return false;
        fi;

      else

        # Check mode, field size, and dimension.
        if   6 < line[1] then
          Info( InfoAtlasRep, 1,
                "mode of file `datagens/", name, "' is larger than 6" );
          return false;
        elif line[2] <> tocentry[2] then
          Info( InfoAtlasRep, 1,
                "field of entries in file `datagens/", name, "' is ",
                line[2] );
          return false;
        elif line[3] <> tocentry[3] then
          Info( InfoAtlasRep, 1,
                "matrix dimension in file `datagens/", name, "' is ",
                line[3] );
          return false;
        elif line[3] <> line[4] then
          Info( InfoAtlasRep, 1,
                "matrix in file `datagens/", name, "' is not square" );
          return false;
        fi;

      fi;

    elif Length( arg ) = 3 and IsString( arg[1] ) and IsString( arg[2] )
                           and IsList( arg[3] ) then

      groupname := arg[1];
      type      := arg[2];
      tocentry  := arg[3];
      len:= Length( tocentry );
      if   type in [ "matff", "perm" ] then

        # Each generator is stored in a file of its own.
        filenames:= tocentry[ len ];
        for name in filenames do
          result:= AtlasOfGroupRepresentationsTestFileHeaders( groupname,
                       type, tocentry, name ) and result;
        od;

      elif type in [ "matalg", "matint", "matmodn" ] then

        # Try to read the file.
        filename:= FilenameAtlas( "datagens", groupname, tocentry[ len ] );
        if filename = fail then
          Info( InfoAtlasRep, 1,
                "filename `", filename, "' not found" );
          return false;
        fi;
        InfoRead1( "#I  reading `",filename,"' started\n" );
        mats:= ReadAsFunction( filename )();
        InfoRead1( "#I  reading `",filename,"' done\n" );

        # Check that the return value is a list of matrices.
        if not ( IsList( mats ) and ForAll( mats, IsMatrix ) ) then
          Info( InfoAtlasRep, 1,
                "file `",filename,"' does not contain a list of matrices" );
          return false;
        fi;

        # Check the entries and the dimension.
        if type = "matmodn" then
          if   not IsZmodnZObjNonprimeCollCollColl( mats ) then
            Info( InfoAtlasRep, 1,
                  "matrices in `", filename,
                  "' are not over a residue class ring" );
            return false;
          elif ModulusOfZmodnZObj( mats[1][1][1] ) <> tocentry[2] then
            Info( InfoAtlasRep, 1,
                  "matrices in `", filename,
                  "' are not over Z/", tocentry[2], "Z" );
            return false;
          fi;
          dim:= tocentry[3];
        else
          if not IsCyclotomicCollCollColl( mats ) then
            Info( InfoAtlasRep, 1,
                  "matrices in `",filename,"' are not over cyclotomics" );
            return false;
          elif type = "matint" then
            if not ForAll( mats, mat -> ForAll( mat,
                                 row -> ForAll( row, IsInt ) ) ) then
              Info( InfoAtlasRep, 1,
                    "matrices in `",filename,"' are not over the integers" );
              return false;
            fi;
          elif ForAll( mats, mat -> ForAll( mat,
                             row -> ForAll( row, IsInt ) ) ) then
            Info( InfoAtlasRep, 1,
                  "matrices in `",filename,"' are over the integers" );
            return false;
          fi;
          dim:= tocentry[2];
        fi;
        dim:= [ dim, dim ];
        if ForAny( mats, mat -> DimensionsMat( mat ) <> dim ) then
          Info( InfoAtlasRep, 1,
                "matrices in `",filename,"' have wrong dimensions" );
          return false;
        fi;

      else
        Info( InfoAtlasRep, 1,
              "unknown type `", type, "'" );
        result:= false;
      fi;

    elif Length( arg ) = 1 and IsString( arg[1] ) then

      toc:= AtlasTableOfContents( "local" ).TableOfContents;
      if IsBound( toc.( arg[1] ) ) then
        record:= toc.( arg[1] );
        for type in [ "perm", "matff", "matalg", "matint", "matmodn" ] do
          for entry in record.( type ) do
            result:= AtlasOfGroupRepresentationsTestFileHeaders( arg[1],
                         type, entry ) and result;
          od;
        od;
      fi;

    elif Length( arg ) = 0 then

      for triple in AtlasOfGroupRepresentationsInfo.groupnames do
        result:= AtlasOfGroupRepresentationsTestFileHeaders( triple[3] )
                 and result;
      od;

    fi;

    # Return the result.
    return result;
end );


############################################################################
##
#F  AtlasOfGroupRepresentationsTestStandardization( <tocentry> )
##


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestCharZeroFields()
##
InstallGlobalFunction( AtlasOfGroupRepresentationsTestCharZeroFields,
    function()

    local result,
          datadirs,
          pair,
          name;

    # Initialize the result.
    result:= true;

    # Get the absolute path name.
    datadirs:= DirectoriesPackageLibrary( "atlasrep", "datagens" );

    for pair in AtlasOfGroupRepresentationsInfo.fieldinfo do
      name:= Filename( datadirs, Concatenation( pair[1], ".g" ) );
      if name <> fail then
        if AtlasStringOfFieldOfMatrixEntries( name ) <> pair[2] then
          Print( "#I  field of the data file `", pair[1],
                     ".g' differs from `", pair[2], "'\n" );
          result:= false;
        fi;
      fi;
    od;

    # Return the result.
    return result;
end );


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestTableOfContentsContainment()
##
InstallGlobalFunction(
    AtlasOfGroupRepresentationsTestTableOfContentsContainment, function()

    local ok, toc, lnames, rnames, name, groupname, entry, list;

    ok:= true;
    ReloadAtlasTableOfContents( "local", true );
    toc:= AtlasOfGroupRepresentationsInfo.TableOfContents;

    # Check whether there are ``illegal'' group names.
    lnames:= RecNames( toc.( "local" ) );
    rnames:= RecNames( toc.remote );
    for name in Difference( lnames, rnames ) do
      if not name in [ "data", "otherfiles" ] then
        ok:= false;
        Print( "#I  remove all local files with initial part `", name,
               "'\n" );
      fi;
    od;

    # Loop over the ``legal'' group names.
    for groupname in Intersection( lnames, rnames ) do
      if groupname <> "data" then

        # Check whether there are ``illegal'' components for this group.
        lnames:= RecNames( toc.( "local" ).( groupname ) );
        rnames:= RecNames( toc.remote.( groupname ) );
        for name in Difference( lnames, rnames ) do
          ok:= false;
          Print( "#I  remove all local files for group `", groupname,
                 "' corresp. to the component `", name, "'\n" );
        od;

        # Check the files for the ``legal'' components.
        for name in Intersection( lnames, rnames ) do
          if name in [ "perm", "matff", "matalg", "matint", "matmodn" ] then
            for entry in Difference( toc.( "local" ).( groupname ).( name ),
                                     toc.remote.( groupname ).( name ) ) do
#T careful: names of Magma files vs. names of GAP files ???
              if not IsString( entry[ Length( entry ) ] ) then
                ok:= false;
                Print( "#I  remove the local file(s) given by `",
                       entry[ Length( entry ) ], "'\n" );
              fi;
            od;
          elif name in [ "maxes", "classes", "maxstd", "out" ] then
            for entry in toc.( "local" ).( groupname ).( name ) do
              for list in entry do
                if ForAll( toc.remote.( groupname ).( name ),
                           x -> not list in x ) then
                  ok:= false;
                  Print( "#I  remove the local file(s) given by `",
                         list, "'\n" );
                fi;
              od;
            od;
          fi;
        od;

      fi;
    od;

    # Return the result.
    return ok;
end );


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestTableOfContentsRemoteUpdates()
##
InstallGlobalFunction(
    AtlasOfGroupRepresentationsTestTableOfContentsRemoteUpdates, function()

    local toc, newtoc, string, old, isless, ok,
          lnames, ldata, rnames, rdata, len, i, name, pos;

    # If not yet available then read the local and remote table of contents,
    # with `ls -l' info.
    toc:= AtlasOfGroupRepresentationsInfo.TableOfContents;
    newtoc:= rec();
    for string in [ "local", "remote" ] do

      if not IsBound( toc.( string ) ) then
        newtoc.( string ):=
            AtlasTableOfContents( string, true ).TableOfContents;
      elif not IsBound( toc.( string ).data ) then
        old:= toc.( string );
        Unbind( toc.( string ) );
        newtoc.( string ):=
            AtlasTableOfContents( string, true ).TableOfContents;
        toc.( string ):= old;
      else
        newtoc.( string ):= toc.( string );
      fi;

    od;

    # Check that this was successful.
    if not IsBound( newtoc.( "local" ) ) or not IsBound( newtoc.remote ) then
      Print( "#I  could not load the two tables of contents\n" );
      return false;
    fi;

    # This local function compares date info lists that are obtained
    # by splitting output lines of `ls -l'.
    # More precisely, `date1' and `date2' are assumed to be of the form
    # `[ "-rw-r--r--", "1", "sam", "sam", "4749", "Jan", "19", "19:06" ]' or
    # `[ "-rw-r--r--", "1", "sam", "sam", "75873", "Aug", "19", "2000" ]'.
    isless:= function( date1, date2 )

      local months;

      # If one of the dates shows a year and the other a time,
      # or if both dates show different years then the relation is clear.
      if   ':' in date1[8] and not ':' in date2[8] then
        return false;
      elif not ':' in date1[8] and ':' in date2[8] then
        return true;
      elif not ':' in date1[8] and not ':' in date2[8]
           and date1[8] <> date2[8] then
        return Int( date1[8] ) < Int( date2[8] );
      fi;

      # For equal years, compare the months.
      months:= [ "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                 "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ];
      if Position( months, date1[6] ) <> Position( months, date2[6] ) then
        return Position( months, date1[6] ) < Position( months, date2[6] );
      fi;

      # For equal years and months, compare the days.
      if Int( date1[7] ) <> Int( date2[7] ) then
        return Int( date1[7] ) < Int( date2[7] );
      fi;

      # For equal years, months, and days, compare the times.
      if ':' in date1[8] then
        return    date1[8]{ [ 1, 2 ] } < date2[8]{ [ 1, 2 ] }
               or ( date1[8]{ [ 1, 2 ] } = date2[8]{ [ 1, 2 ] } and
                    date1[8]{ [ 3, 4 ] } < date2[8]{ [ 3, 4 ] } );
      fi;

      # Year, month, and date are equal.
      return false;
    end;

    # Check that the creation dates of the local files are not older than
    # the creation dates of the corresponding remote files.
    ok:= true;
    lnames := newtoc.( "local" ).data[1];
    ldata  := newtoc.( "local" ).data[2];
    rnames := newtoc.( "remote" ).data[1];
    rdata  := newtoc.( "remote" ).data[2];
    len:= Length( lnames );
    for i in [ 1 .. len ] do
      name:= lnames[i];
      pos:= Position( rnames, name );
      if pos <> fail then
        if isless( ldata[i], rdata[ pos ] ) then
          ok:= false;
          Print( "#I  update local file `", name, "'\n" );
        fi;
      fi;
    od;

    # Return the result.
    return ok;
end );


#############################################################################
##
#F  AtlasOfGroupRepresentationsToDoInMakeTOC( <flags>, <filename> )
##
InstallGlobalFunction( AtlasOfGroupRepresentationsToDoInMakeTOC,
    function( flags, filename )
    local test, data;

    if "-v" in flags then
      SetInfoLevel( InfoAtlasRep, 3 );
    fi;
    test:= ( "-test" in flags );
    ReloadAtlasTableOfContents( "remote", test );
    if test then
      data:= AtlasOfGroupRepresentationsInfo.TableOfContents.remote.data;
    fi;
    AppendTo( filename, StringOfAtlasTableOfContents( "remote" ) );
    Reread( filename );
    if test then
      AtlasOfGroupRepresentationsInfo.TableOfContents.remote.data:= data;
      AtlasOfGroupRepresentationsTestTableOfContentsContainment();
      AtlasOfGroupRepresentationsTestTableOfContentsRemoteUpdates();
    fi;
end );


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestFiles( [<groupname>] )
##
InstallGlobalFunction( AtlasOfGroupRepresentationsTestFiles, function( arg )

    local result,
          toc,
          groupname,
          type,
          tocentry,
          len,
          filenames,
          name,
          filename,
          file,
          line,
          mats,
          dim,
          record,
          entry,
          triple;

    # Initialize the result.
    result:= true;

    if   Length( arg ) = 2 and IsString( arg[1] ) and IsString( arg[2] ) then

      groupname := arg[1];
      name      := arg[2];

      # Read the file.
      filename:= FilenameAtlas( "datagens", groupname, name );
      if filename = fail then
        Info( InfoAtlasRep, 1,
              "file `datagens/",name,"' not available" );
        return false;
      fi;
      filename:= ScanMeatAxeFile( filename );
      if filename = fail then
        Info( InfoAtlasRep, 1,
              "file `datagens/",name,"' corrupted" );
        return false;
      fi;

    elif Length( arg ) = 2 and IsString( arg[1] ) and IsList( arg[2] ) then

      groupname := arg[1];
      tocentry  := arg[2];
      for name in tocentry[ Length( tocentry ) ] do
        result:= AtlasOfGroupRepresentationsTestFiles( groupname, name )
                 and result;
      od;

    elif Length( arg ) = 1 and IsString( arg[1] ) then

      toc:= AtlasTableOfContents( "local" ).TableOfContents;
      if IsBound( toc.( arg[1] ) ) then
        record:= toc.( arg[1] );
        for type in [ "perm", "matff" ] do

          # Each generator is stored in a file of its own.
          # (Other types do not use {\MeatAxe} matrices.)
          for entry in record.( type ) do
            result:= AtlasOfGroupRepresentationsTestFiles( arg[1], entry )
                     and result;
          od;

        od;
      fi;

    elif Length( arg ) = 0 then

      for triple in AtlasOfGroupRepresentationsInfo.groupnames do
        result:= AtlasOfGroupRepresentationsTestFiles( triple[3] )
                 and result;
      od;

    fi;

    # Return the result.
    return result;
end );


#############################################################################
##
#F  AtlasOfGroupRepresentationsTestClassScripts()
#F  AtlasOfGroupRepresentationsTestClassScripts( <groupname> )
##
InstallGlobalFunction( AtlasOfGroupRepresentationsTestClassScripts,
    function( arg )
    local badnames, result, groupname, gapname, toc, record, std, name,
          prg, tbl, outputs, ident, classnames, map, gens, grp, reps,
          orders1, orders2, cents1, cents2, triple;

    # The following groups are currently too large for checking
    # centralizer orders in a concrete representation.
    badnames:= [ "B", "F24", "HN", "J4", "Ly", "M", "ON", "Th" ];

    # Initialize the result.
    result:= true;

    if Length( arg ) = 1 and IsString( arg[1] ) then

      groupname:= arg[1];
      gapname:= First( AtlasOfGroupRepresentationsInfo.GAPnames,
                       pair -> pair[2] = groupname )[1];
      toc:= AtlasTableOfContents( "local" ).TableOfContents;
      if IsBound( toc.( groupname ) ) then
        record:= toc.( groupname );
        for std in Set( List( record.classes, x -> x[1] ) ) do

          for name in [ "cyclic", "classes" ] do

            prg:= AtlasStraightLineProgram( gapname, std, name );
            if prg <> fail then

              # Fetch the character table of the group.
              # (No further tests are possible if it is not available.)
              tbl:= CharacterTable( gapname );
              if tbl <> fail then

                outputs:= prg.outputs;
                ident:= prg.identifier[2];
                prg:= prg.program;
                classnames:= AtlasClassNames( tbl );
                map:= List( outputs, x -> Position( classnames, x ) );

                # Check the class names.
                # (No further checks are possible if `-' signs occur.)
                if ForAll( outputs, x -> not '-' in x ) then

                  if fail in map then
                    Info( InfoAtlasRep, 1,
                          "strange class names ",
                          Difference( outputs, classnames ),
                          " for `dataword/", ident, "'" );
                    result:= false;
                  fi;
                  if ForAny( [ 1 .. Length( name ) - 2 ],
                             i -> name{ [ i .. i+2 ] } = "ccl" ) and
                     Set( classnames ) <> Set( outputs ) then
                    Info( InfoAtlasRep, 1,
                          "class names ",
                          Difference( classnames, outputs ),
                          " not hit for `dataword/", ident, "'" );
                    result:= false;
                  fi;

                fi;


                if not fail in map and not groupname in badnames then

                  # Compute the representatives in a representation.
                  # (No further tests are possible if none is available.)
                  gens:= OneAtlasGeneratingSet( gapname, std );
                  if gens <> fail then

                    gens:= gens.generators;
                    grp:= Group( gens );
                    reps:= ResultOfStraightLineProgram( prg, gens );

                    if Length( reps ) <> Length( outputs ) then

                      Info( InfoAtlasRep, 1,
                            "inconsistent output numbers for ",
                            "`dataword/", ident, "'" );
                      result:= false;

                    else

                      # Check element orders and centralizer orders.
                      orders1:= OrdersClassRepresentatives( tbl ){ map };
                      orders2:= List( reps, Order );
                      if orders1 <> orders2 then
                        Info( InfoAtlasRep, 1,
                              "element orders of ",
                              outputs{ Filtered( [ 1 .. Length( outputs ) ],
                                           i -> orders1[i] <> orders2[i] ) },
                              " differ for `dataword/", ident, "'" );
                        result:= false;
                      fi;
                      cents1:= SizesCentralizers( tbl ){ map };
                      cents2:= List( reps, x -> Size( Centralizer(grp,x) ) );
                      if    cents1 <> cents2 then
                        Info( InfoAtlasRep, 1,
                              "centralizer orders of ",
                              outputs{ Filtered( [ 1 .. Length( outputs ) ],
                                           i -> cents1[i] <> cents2[i] ) },
                              " differ for `dataword/", ident, "'" );
                        result:= false;
                      fi;

                    fi;

                  fi;

                fi;

              fi;
            fi;
          od;

        od;
      fi;

    elif Length( arg ) = 0 then

      for triple in AtlasOfGroupRepresentationsInfo.groupnames do
        result:= AtlasOfGroupRepresentationsTestClassScripts( triple[3] )
                 and result;
      od;

    fi;

    # Return the result.
    return result;
end );


#############################################################################
##
#E

