#############################################################################
##
#W  utils.gd           GAP share package 'atlasrep'             Thomas Breuer
##
#H  @(#)$Id: utils.gd,v 1.5 2001/03/27 16:09:50 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file contains the declarations of utility functions for the
##  {\ATLAS} of Group Representations.
##
Revision.( "atlasrep/gap/utils_gd" ) :=
    "@(#)$Id: utils.gd,v 1.5 2001/03/27 16:09:50 gap Exp $";


#############################################################################
#1
##  For each straight line program (see~"AtlasStraightLineProgram") that is
##  used to compute lists of class representatives,
##  it is essential to describe the classes in which these elements lie.
##  Therefore, in these cases the records returned by the function
##  `AtlasStraightLineProgram' (see~"AtlasStraightLineProgram") contain
##  a component `outputs' with value a list of *class names*.
##  Currently we define these class names only for almost simple groups,
##  that is, subgroups of the automorphism groups of simple groups.
##
##  For the definition of class names of an almost simple group,
##  we assume that the ordinary character tables of all nontrivial normal
##  subgroups are shown in the {\ATLAS} of Finite Groups~\cite{CCN85}.
##
##  Each class name is a string consisting of the element order of the class
##  in question followed by a combination of capital letters, digits, and
##  the characters `{'}' and `-' (starting with a capital letter).
##  For example, `1A', `12A1', and `3B{'}' denote the class that contains
##  the identity element, a class of element order $12$, and a class of
##  element order $3$, respectively.
##
##  \beginlist
##  \item{1.}
##  For the table of a *simple* group, the class names are the same as
##  returned by the {\GAP} function `ClassNames' (see~"ref:ClassNames"
##  in the {\GAP} Reference Manual),
##  see Chapter~7, Section~5 of the {\ATLAS} of Finite Groups~\cite{CCN85}:
##  The classes are arranged w.r.t.~increasing element order and for each
##  element order w.r.t.~decreasing centralizer order,
##  the conjugacy classes that contain elements of order $n$ are named
##  $nA, nB, nC, \ldots$;
##  the alphabet used here is potentially infinite, and reads
##  `A', `B', `C', $\ldots$, `Z', `A1', `B1', $\ldots$, `A2', `B2', $\ldots$.
##
##  For example, the classes of the alternating group $A_5$ have the names
##  `1A', `2A', `3A', `5A', and `5B'.
##
##  \item{2.}
##  Next we consider the case of an *upward extension* $G\.A$ of a simple
##  group $G$ by a *cyclic* group of order $A$.
##  The {\ATLAS} defines class names for each element $g$ of $G\.A$ only
##  w.r.t.~the group $G\.a$, say, that is generated by $G$ and $g$;
##  namely, there is a power of $g$ (with the exponent coprime to the order
##  of $g$) for which the class has a name of the same form as
##  the class names for simple groups,
##  and the name of the class of $g$ w.r.t.~$G\.a$ is then obtained from this
##  name by appending a suitable number of dashes~`{'}'.
##  So dashed class names refer exactly to those classes that are not printed
##  in the {\ATLAS}.
##
##  For example, those classes of the symmetric group $S_5$ that do not lie
##  in $A_5$ have the names `2B', `4A', and `6A'.
##  The outer classes of the group $L_2(8)\.3$ have the names
##  `3B', `6A', `9D', and `3B{'}', `6A{'}', `9D{'}'.
##  and the outer elements of order $5$ in the group $Sz(32)\.5$ lie in the
##  classes with names `5B', `5B{'}', `5B{''}', `5B{'''}', and `5B{''''}'.
##
##  In the group $G\.A$, the class of $g$ may fuse with other classes.
##  The name of the class of $g$ in $G\.A$ is obtained from the names of the
##  involved classes of $G\.a$ by concatenating their names after removing
##  the element order part for all of them except the first one.
##
##  For example, the elements of order $9$ in the group $L_2(27)\.6$ are
##  contained in the subgroup $L_2(27)\.3$ but not in $L_2(27)$.
##  In $L_2(27)\.3$, they lie in the classes `9A', `9A{'}', `9B', and `9B{'}';
##  in $L_2(27)\.6$, these classes fuse to `9AB' and `9A{'}B{'}'.
##
##  \item{3.}
##  Now we define class names for *general upward extensions* $G\.A$ of a
##  simple group.
##  Each element $g$ of such a group lies in an upward extension $G\.a$ by a
##  cyclic group, and the class names w.r.t.~$G\.a$ are already defined.
##  The name of the class of $g$ in $G\.A$ is obtained by concatenating the
##  names of the classes in the orbit of $G\.A$ on the classes of cyclic
##  upward extensions of $G$, after ordering the names lexicographically and
##  removing the element order part for all of them except the first one.
##  An *exception* is the situation where dashed and non-dashed class names
##  appear in an orbit; in this case, the dashed names are omitted.
##
##  For example, the classes `21A' and `21B' of the group $U_3(5)\.3$ fuse
##  in $U_3(5)\.S_3$ to the class `21AB',
##  and the class `2B' of $U_3(5)\.2$ fuses with the involution classes
##  `2B{'}', `2B{''}' in the groups $U_3(5)\.2^{\prime}$ and
##  $U_3(5)\.2^{\prime\prime}$ to the class `2B' of $U_3(5)\.S_3$.
##  \endlist
##
##  It may happen that some names in the `outputs' component of a record
##  returned by `AtlasStraightLineProgram' (see~"AtlasStraightLineProgram")
##  do not uniquely determine the classes of the corresponding elements.
##  For example, the (algebraically conjugate) classes `39A' and `39B' of the
##  group $Co_1$ have not been distinguished yet.
##  In such cases, the names used contain a minus sign `-',
##  and mean ``one of the classes in the range described by the name before
##  and the name after the minus sign''; the element order part of the name
##  does not appear after the minus sign.
##  So the name `39A-B' for the group $Co_1$ means `39A' or `39B',
##  and the name `20A-B{''''}' for the group $Sz(32)$ means one of the
##  (outer) classes of element order $20$ in this group.
##


#############################################################################
##
#F  AtlasClassNames( <tbl> )
##
##  If <tbl> is the ordinary character table of an almost simple group $G$
##  whose ordinary character table is contained in the {\ATLAS} of Finite
##  Groups then `AtlasClassNames' returns the list of class names for $G$,
##  as defined above.
##  The ordering of class names is the same as the ordering of the columns
##  of <tbl>.
##
##  (The function may work also for almost simple non-{\ATLAS} groups,
##  but then clearly the class names returned are somewhat arbitrary.)
##
DeclareGlobalFunction( "AtlasClassNames" );


#############################################################################
##
#V  AtlasClassNamesOffsetInfo
##
##  This global variable describes the cyclic upwards extensions of those
##  simple groups whose ordinary character tables are contained in the
##  {\ATLAS} of Finite Groups and for which the outer automorphism groups
##  are noncyclic.
##
DeclareGlobalVariable( "AtlasClassNamesOffsetInfo" );


#############################################################################
##
#F  StringOfAtlasProgramCycToCcls( <filename>, <tbls> )
##
##  The purpose of this utility program is to construct a straight line
##  program for computing conjugacy class representatives of a group $G$
##  from the straight line program for computing representatives of classes
##  of maximally cyclic subgroups of $G$;
##  the latter program is assumed to be stored in the file with name
##  <filename>.
##  The second argument <tbls> must be a list of ordinary character tables,
##  the first entry being the table of the derived subgroup of $G$,
##  the last entry being the table of $G$, and the other entries being the
##  tables of intermediate subgroups.
##
##  All involved tables must be {\ATLAS} groups, and their classes must be
##  sorted as given in the {\ATLAS} of Finite Groups~\cite{CCN85},
##
DeclareGlobalFunction( "StringOfAtlasProgramCycToCcls" );


#############################################################################
##
#E

