#############################################################################
##
#W  init.g                 share package 'atlasrep'             Thomas Breuer
##
#H  @(#)$Id: init.g,v 1.8 2001/02/28 16:04:41 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##

# Announce the package version.
DeclarePackage( "atlasrep", "1.0", function()

    local name, sysprog;

    # The package needs at least {\GAP}~4.2.
    if not CompareVersionNumbers( VERSION, "4.2" ) then
      return false;
    fi;

    # Test for existence of `awk', `ls', `perl', and `rm'.
    # (The package works without these programs if all data files
    # are contained in the local installation, so we always return `true',
    # just some warnings are issued.)
    name:= Filename( DirectoriesPackageLibrary( "atlasrep", "etc" ),
                     "perlftp.pl" );
    if name = fail then
      Info( InfoWarning, 1,
            "Package `atlasrep':  script `etc/perlftp.pl' not available");
    elif not IsReadableFile( name ) then
      Info( InfoWarning, 1,
            "Package `atlasrep':  script `etc/perlftp.pl' not readable");
    fi;
    for sysprog in [ "awk", "ls", "perl", "rm" ] do
      name:= Filename( DirectoriesSystemPrograms(), sysprog );
      if name = fail then
        Info( InfoWarning, 1,
              "Package `atlasrep':  The system program `", sysprog,
              "' is not available." );
      elif not IsExecutableFile( name ) then
        Info( InfoWarning, 1,
              "Package `atlasrep':  The system program `", sysprog,
              "' is not executable." );
      fi;
    od;

    return true;
end );

# Install the documentation.
DeclarePackageAutoDocumentation( "atlasrep", "doc" );

# Read the banner.
ReadPkg( "atlasrep", "banner.g" );

# If necessary then read functions not yet available in {\GAP}~4.2.
if not CompareVersionNumbers( VERSION, "4.3" ) then
  ReadPkg( "atlasrep", "gap/compat42.g" );
fi;

# Read the declaration part.
if not IsBound( InfoCMeatAxe ) then
  # This file is also part of the C-{\MeaAxe} package.
  ReadPkg( "atlasrep", "gap/scanmtx.gd" );
  ReadPkg( "atlasrep", "gap/scanmtx.gi" );
fi;
ReadPkg( "atlasrep", "gap/access.gd" );
ReadPkg( "atlasrep", "gap/interfac.gd" );
ReadPkg( "atlasrep", "gap/utils.gd" );
ReadPkg( "atlasrep", "gap/test.gd" );


#############################################################################
##
#E

