#############################################################################
##
#W  atlasrep.tst      GAP share package `atlasrep'              Thomas Breuer
##
#H  @(#)$Id: atlasrep.tst,v 1.13 2001/03/19 18:19:26 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file contains among others the function calls needed to perform the
##  sanity checks mentioned in Section~"Sanity Checks" of the manual of the
##  {\ATLAS} of Group Representations.
##
##  In order to run the tests, one starts {\GAP} from the `gap' subdirectory
##  of the `pkg/atlasrep' directory, and calls `ReadTest( "atlasrep.tst" );'.
##
##  If one of the functions `AtlasOfGroupRepresentationsTestWords',
##  `AtlasOfGroupRepresentationsTestFileHeaders' reports an error
##  then detailed information can be obtained by increasing the
##  info level of `InfoAtlasRep' to at least $1$ and then running the tests
##  again.
##

gap> START_TEST("$Id: atlasrep.tst,v 1.13 2001/03/19 18:19:26 gap Exp $");


# Load the package.
gap> RequirePackage( "atlasrep" );
true

# Test whether the straight line programs can be read and processed.
gap> if not AtlasOfGroupRepresentationsTestWords() then
>      Print( "#I  Error in `AtlasOfGroupRepresentationsTestWords'\n" );
> fi;

# Test whether the generators are consistent with their filenames.
gap> if not AtlasOfGroupRepresentationsTestFileHeaders() then
>      Print( "#I  Error in ",
>          "`AtlasOfGroupRepresentationsTestFileHeaders'\n" );
> fi;

# Test the standardization of the available generators.
#T missing!

# Test reading and writing straight line programs.
gap> str:= "\
> mu 1 2 3\n\
> mu 3 2 4\n\
> mu 3 4 5\n\
> mu 3 5 6\n\
> mu 6 6 5\n\
> mu 6 5 1\n\
> iv 4 5\n\
> mu 5 2 6\n\
> mu 6 4 2\n\
> iv 3 4\n\
> mu 4 1 5\n\
> mu 5 3 1";;
gap> prog:= ScanStraightLineProgram( str, "string" );
rec( program := <straight line program> )
gap> Print( AtlasStringOfStraightLineProgram( prog.program ) );
inp 2
mu 1 2 3
mu 3 2 4
mu 3 4 5
mu 3 5 6
mu 6 6 5
mu 6 5 1
iv 4 5
mu 5 2 6
mu 6 4 2
iv 3 4
mu 4 1 5
mu 5 3 1
oup 2
gap> str:= "\
> mu 1 2 3\n\
> mu 3 2 4\n\
> mu 3 4 5\n\
> mu 5 4 6\n\
> mu 6 2 7\n\
> oup 4 7 4 6 3";;
gap> prog:= ScanStraightLineProgram( str, "string" );
rec( program := <straight line program> )
gap> Print( AtlasStringOfStraightLineProgram( prog.program,
>     ["5A","6A","8A","11A"] ) );
inp 2
mu 1 2 3
mu 3 2 4
mu 3 4 5
mu 5 4 6
mu 6 2 7
echo "Classes 5A 6A 8A 11A"
oup 4 7 4 6 3
gap> prg:= ScanStraightLineProgram( "inp 4 1 2 3 4\noup 3 1 2 4", "string" );;
gap> Display( prg.program );
# input:
r:= [ g1, g2, g3, g4 ];
# program:
# return values:
[ r[1], r[2], r[4] ]
gap> prg:= ScanStraightLineProgram( "inp 4 1 2 3 4\noup 3 1 2 3", "string" );;
gap> Display( prg.program );
# input:
r:= [ g1, g2, g3 ];
# program:
# return values:
[ r[1], r[2], r[3] ]
gap> str:= "\
> inp 2\n\
> mu 1 2 3\n\
> mu 1 1 4\n\
> mu 3 3 5\n\
> echo \"Classes 1A 2A 3A 5A 5B\"\n\
> oup 5 4 1 2 3 5";;
gap> prg:= ScanStraightLineProgram( str, "string" );
rec( outputs := [ "1A", "2A", "3A", "5A", "5B" ], 
  program := <straight line program> )
gap> Display( prg.program );
# input:
r:= [ g1, g2 ];
# program:
r[3]:= r[1]*r[2];
r[4]:= r[1]*r[1];
r[5]:= r[3]*r[3];
# return values:
[ r[4], r[1], r[2], r[3], r[5] ]

# Test reading group generators in {\MeatAxe} format.
gap> dir:= DirectoriesPackageLibrary( "atlasrep", "tst" );;

# mode 12
gap> str:= "\
> 12     1    9     1\n\
>      1\n\
>      4\n\
>      5\n\
>      2\n\
>      3\n\
>      8\n\
>      6\n\
>      9\n\
>      7";;
gap> perms:= ScanMeatAxeFile( str, "string" );
[ (2,4)(3,5)(6,8,9,7) ]
gap> str:= "\
> permutation degree=9\n\
> 1 4 5 2 3 8 6 9 7";;
gap> perms = ScanMeatAxeFile( str, "string" );
true
gap> ScanMeatAxeFile( Filename( dir, "perm7.tst" ) );
[ (1,2,3)(4,6) ]

# mode 1
gap> str:= "\
>  1     9     3     3\n\
> 200\n\
> 020\n\
> 331";
" 1     9     3     3\n200\n020\n331"
gap> scan:= ScanMeatAxeFile( str, "string" );
[ [ Z(3), 0*Z(3), 0*Z(3) ], [ 0*Z(3), Z(3), 0*Z(3) ], 
  [ Z(3^2), Z(3^2), Z(3)^0 ] ]
gap> str:= "\
> matrix field=9 rows=3 cols=3\n\
> 200\n\
> 020\n\
> 331";;
gap> scan = ScanMeatAxeFile( str, "string" );
true
gap> scan = ScanMeatAxeFile( Filename( dir, "matf9r3.tst" ) );
true
gap> scan = ScanMeatAxeFile( Filename( dir, "matf81r3.tst" ) );
true

# mode 3
gap> str:= "\
>  3    11    10    10\n\
>   0  1  0  0  0  0  0  0  0  0\n\
>   1  0  0  0  0  0  0  0  0  0\n\
>   0  0  0  1  0  0  0  0  0  0\n\
>   0  0  1  0  0  0  0  0  0  0\n\
>   0  0  0  0  0  0  1  0  0  0\n\
>   0  0  0  0  0  0  0  1  0  0\n\
>   0  0  0  0  1  0  0  0  0  0\n\
>   0  0  0  0  0  1  0  0  0  0\n\
>   6  6 10 10  9 10  9 10 10  0\n\
>  10 10  9  9  1  6  1  6  0 10";;
gap> scan:= ScanMeatAxeFile( str, "string" );;
gap> Print( scan, "\n" );
[ [ 0*Z(11), Z(11)^0, 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11),
       0*Z(11), 0*Z(11) ],
  [ Z(11)^0, 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11),
       0*Z(11), 0*Z(11) ],
  [ 0*Z(11), 0*Z(11), 0*Z(11), Z(11)^0, 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11),
       0*Z(11), 0*Z(11) ],
  [ 0*Z(11), 0*Z(11), Z(11)^0, 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11),
       0*Z(11), 0*Z(11) ],
  [ 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), Z(11)^0, 0*Z(11),
       0*Z(11), 0*Z(11) ],
  [ 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), Z(11)^0,
       0*Z(11), 0*Z(11) ],
  [ 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), Z(11)^0, 0*Z(11), 0*Z(11), 0*Z(11),
       0*Z(11), 0*Z(11) ],
  [ 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), 0*Z(11), Z(11)^0, 0*Z(11), 0*Z(11),
       0*Z(11), 0*Z(11) ],
  [ Z(11)^9, Z(11)^9, Z(11)^5, Z(11)^5, Z(11)^6, Z(11)^5, Z(11)^6, Z(11)^5,
       Z(11)^5, 0*Z(11) ],
  [ Z(11)^5, Z(11)^5, Z(11)^6, Z(11)^6, Z(11)^0, Z(11)^9, Z(11)^0, Z(11)^9,
       0*Z(11), Z(11)^5 ] ]
gap> str:= "\
> matrix field=11 rows=10 cols=10\n\
>   0  1  0  0  0  0  0  0  0  0\n\
>   1  0  0  0  0  0  0  0  0  0\n\
>   0  0  0  1  0  0  0  0  0  0\n\
>   0  0  1  0  0  0  0  0  0  0\n\
>   0  0  0  0  0  0  1  0  0  0\n\
>   0  0  0  0  0  0  0  1  0  0\n\
>   0  0  0  0  1  0  0  0  0  0\n\
>   0  0  0  0  0  1  0  0  0  0\n\
>   6  6 10 10  9 10  9 10 10  0\n\
>  10 10  9  9  1  6  1  6  0 10";;
gap> scan = ScanMeatAxeFile( str, "string" );
true
gap> scan = ScanMeatAxeFile( Filename( dir, "matf11r10.tst" ) );
true

# mode 4
# mode 5
# mode 6

# mode 2
gap> str:= "\
> 2 5 3 6\n\
> 4\n\
> 6\n\
> 1";;
gap> scan:= ScanMeatAxeFile( str, "string" );
[ [ 0*Z(5), 0*Z(5), 0*Z(5), Z(5)^0, 0*Z(5), 0*Z(5) ], 
  [ 0*Z(5), 0*Z(5), 0*Z(5), 0*Z(5), 0*Z(5), Z(5)^0 ], 
  [ Z(5)^0, 0*Z(5), 0*Z(5), 0*Z(5), 0*Z(5), 0*Z(5) ] ]
gap> str:= "\
> matrix field=5 rows=3 cols=6\n\
> 000100\n\
> 000001\n\
> 100000";;
gap> scan = ScanMeatAxeFile( str, "string" );
true
gap> scan:= ScanMeatAxeFile( Filename( dir, "permmat7.tst" ) );;
gap> scan = PermutationMat( (1,2,3)(4,6), 7, GF(3) );
true

# Test the information about fields of char. zero representations.
gap> if not AtlasOfGroupRepresentationsTestCharZeroFields() then
>      Print( "#I  Error in ",
>          "`AtlasOfGroupRepresentationsTestCharZeroFields'\n" );
> fi;

# Check that the function `StringOfAtlasTableOfContents' works.
gap> StringOfAtlasTableOfContents( "remote" );;

# Check that the local table of contents is a subset of the remote one.
gap> if not AtlasOfGroupRepresentationsTestTableOfContentsContainment() then
>      Print( "#I  Error in ",
>          "`AtlasOfGroupRepresentationsTestTableOfContentsContainment'\n" );
> fi;

# Check whether reading the file `atlasprm.g' reports inconsistencies.
gap> level:= InfoLevel( InfoAtlasRep );;
gap> SetInfoLevel( InfoAtlasRep, 3 );
gap> RereadPkg( "atlasrep", "gap/atlasprm.g" );
gap> SetInfoLevel( InfoAtlasRep, level );


gap> STOP_TEST( "atlasrep.tst", 10000000 );


#############################################################################
##
#E

