# This file was created automatically, do not edit!
#############################################################################
##
#W  docxpl.tst        GAP share package `atlasrep'              Thomas Breuer
##
#H  @(#)$Id: docxpl.tst,v 1.2 2001/01/22 18:12:10 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file contains the {\GAP} code of the examples in the package
##  documentation files.
##
##  In order to run the tests, one starts {\GAP} from the `gap' subdirectory
##  of the `pkg/atlasrep' directory, and calls `ReadTest( "docxpl.tst" );'.
##

gap> START_TEST("$Id: docxpl.tst,v 1.2 2001/01/22 18:12:10 gap Exp $");


# Load the package if necessary.
gap> RequirePackage( "atlasrep" );
true

gap> AtlasClassNames( CharacterTable( "L3(4).3" ) );
[ "1A", "2A", "3A", "4ABC", "5A", "5B", "7A", "7B", "3B", "3B'", "3C", "3C'", 
  "6B", "6B'", "15A", "15A'", "15B", "15B'", "21A", "21A'", "21B", "21B'" ]
gap> AtlasClassNames( CharacterTable( "U3(5).2" ) );
[ "1A", "2A", "3A", "4A", "5A", "5B", "5CD", "6A", "7AB", "8AB", "10A", "2B", 
  "4B", "6D", "8C", "10B", "12B", "20A", "20B" ]
gap> AtlasClassNames( CharacterTable( "L2(27).6" ) );
[ "1A", "2A", "3AB", "7ABC", "13ABC", "13DEF", "14ABC", "2B", "4A", "26ABC", 
  "26DEF", "28ABC", "28DEF", "3C", "3C'", "6A", "6A'", "9AB", "9A'B'", "6B", 
  "6B'", "12A", "12A'" ]

gap> DisplayAtlasInfo( [ "M11", "A5" ] );
group     #     maxes  cl  cyc  out
-----------------------------------
M11      42      1..5   +    +     
A5       18      1..3   -    -     

gap> DisplayAtlasInfo( "A5", IsPermGroup );
Representations for G = A5:    (all refer to std. generators 1)
---------------------------
 1: G <= Sym(5)
 2: G <= Sym(6)
 3: G <= Sym(10)
gap> DisplayAtlasInfo( "A5", NrMovedPoints, [ 4 .. 9 ] );
Representations for G = A5:    (all refer to std. generators 1)
---------------------------
 1: G <= Sym(5)
 2: G <= Sym(6)

gap> DisplayAtlasInfo( "A5", Dimension, [ 1 .. 3 ] );
Representations for G = A5:    (all refer to std. generators 1)
---------------------------
 8: G <= GL(2a,4)
 9: G <= GL(2b,4)
10: G <= GL(3,5)
12: G <= GL(3a,9)
13: G <= GL(3b,9)
17: G <= GL(3a,Field([Sqrt(5)]))
18: G <= GL(3b,Field([Sqrt(5)]))
gap> DisplayAtlasInfo( "A5", Characteristic, 0 );
Representations for G = A5:    (all refer to std. generators 1)
---------------------------
14: G <= GL(4,Z)
15: G <= GL(5,Z)
16: G <= GL(6,Z)
17: G <= GL(3a,Field([Sqrt(5)]))
18: G <= GL(3b,Field([Sqrt(5)]))

gap> DisplayAtlasInfo( "A5", IsStraightLineProgram );
Straight line programs for G = A5:    (all refer to std. generators 1)
----------------------------------
available maxes of G:  [ 1 .. 3 ]
repres. of cyclic subgroups of G available?  false
class repres. of G available?  false
available automorphisms:  [  ]

gap> gens1:= AtlasGenerators( "A5", 1 );
rec( generators := [ (1,2)(3,4), (1,3,5) ], standardization := 1, 
  identifier := [ "A5", [ "A5G1-p5B0.m1", "A5G1-p5B0.m2" ], 1, 5 ] )
gap> gens8:= AtlasGenerators( "A5", 8 );
rec( 
  generators := [ [ [ Z(2)^0, 0*Z(2) ], [ Z(2^2), Z(2)^0 ] ], [ [ 0*Z(2), Z(2
                 )^0 ], [ Z(2)^0, Z(2)^0 ] ] ], standardization := 1, 
  identifier := [ "A5", [ "A5G1-f4r2aB0.m1", "A5G1-f4r2aB0.m2" ], 1, 4 ] )
gap> gens17:= AtlasGenerators( "A5", 17 );
rec( 
  generators := [ [ [ -1, 0, 0 ], [ 0, -1, 0 ], [ -E(5)-E(5)^4, -E(5)-E(5)^4, 
              1 ] ], [ [ 0, 1, 0 ], [ 0, 0, 1 ], [ 1, 0, 0 ] ] ], 
  standardization := 1, identifier := [ "A5", "A5G1-Ar3aB0.M", 1, 3 ] )

gap> gens1max2:= AtlasGenerators( "A5", 1, 2 );
rec( generators := [ (1,2)(3,4), (2,3)(4,5) ], standardization := 1, 
  identifier := [ "A5", [ "A5G1-p5B0.m1", "A5G1-p5B0.m2" ], 1, 5, 2 ] )
gap> id:= gens1max2.identifier;;
gap> gens1max2 = AtlasGenerators( id );
true
gap> max2:= Group( gens1max2.generators );;
gap> Size( max2 );
10
gap> IdGroup( max2 ) = IdGroup( DihedralGroup( 10 ) );
true

gap> prog:= AtlasStraightLineProgram( "A5", 2 );
rec( program := <straight line program>, standardization := 1, 
  identifier := [ "A5", "A5G1-max2W1", 1 ] )
gap> StringOfResultOfStraightLineProgram( prog.program, [ "a", "b" ] );
"[ a, bbab ]"
gap> gens1:= AtlasGenerators( "A5", 1 );
rec( generators := [ (1,2)(3,4), (1,3,5) ], standardization := 1, 
  identifier := [ "A5", [ "A5G1-p5B0.m1", "A5G1-p5B0.m2" ], 1, 5 ] )
gap> maxgens:= ResultOfStraightLineProgram( prog.program, gens1.generators );
[ (1,2)(3,4), (2,3)(4,5) ]
gap> maxgens = gens1max2.generators;
true

gap> prog:= AtlasStraightLineProgram( "J1", "cyclic" );
rec( program := <straight line program>, standardization := 1, 
  identifier := [ "J1", "J1G1-cycW1", 1 ],
  outputs := [ "6A", "7A", "10B", "11A", "15B", "19A" ] )
gap> gens:= GeneratorsOfGroup( FreeGroup( "x", "y" ) );;
gap> ResultOfStraightLineProgram( prog.program, gens );
[ x*y*x*y^2*x*y*x*y^2*x*y*x*y*x*y^2*x*y^2, x*y, x*y*x*y^2*x*y*x*y*x*y^2*x*y^2,
  x*y*x*y*x*y^2*x*y^2*x*y*x*y^2*x*y*x*y*x*y^2*x*y^2*x*y*x*y^2*x*y*x*y*x*y^
    2*x*y^2, x*y*x*y*x*y^2*x*y^2, x*y*x*y^2 ]

gap> gens:= OneAtlasGeneratingSet( "A5" );
rec( generators := [ (1,2)(3,4), (1,3,5) ], standardization := 1, 
  identifier := [ "A5", [ "A5G1-p5B0.m1", "A5G1-p5B0.m2" ], 1, 5 ] )
gap> gens = OneAtlasGeneratingSet( "A5", IsPermGroup );
true
gap> gens = OneAtlasGeneratingSet( "A5", NrMovedPoints, [ 1 .. 10 ] );
true
gap> OneAtlasGeneratingSet( "A5", NrMovedPoints, 20 );
fail

gap> gens:= OneAtlasGeneratingSet( "A5", IsMatrixGroup );
rec( 
  generators := [ <an immutable 4x4 matrix over GF2>, <an immutable 4x4 matrix\
 over GF2> ], standardization := 1, 
  identifier := [ "A5", [ "A5G1-f2r4aB0.m1", "A5G1-f2r4aB0.m2" ], 1, 2 ] )
gap> gens = OneAtlasGeneratingSet( "A5", Dimension, 4 );
true
gap> gens = OneAtlasGeneratingSet( "A5", Characteristic, 2 );
true
gap> OneAtlasGeneratingSet( "A5", Characteristic, [2,5], Dimension, 2 );
rec( 
  generators := [ [ [ Z(2)^0, 0*Z(2) ], [ Z(2^2), Z(2)^0 ] ], [ [ 0*Z(2), Z(2
                 )^0 ], [ Z(2)^0, Z(2)^0 ] ] ], standardization := 1, 
  identifier := [ "A5", [ "A5G1-f4r2aB0.m1", "A5G1-f4r2aB0.m2" ], 1, 4 ] )
gap> OneAtlasGeneratingSet( "A5", Characteristic, [2,5], Dimension, 1 );
fail
gap> gens:= OneAtlasGeneratingSet( "A5", Characteristic, 0, Dimension, 4 );
rec( 
  generators := [ [ [ 1, 0, 0, 0 ], [ 0, 0, 1, 0 ], [ 0, 1, 0, 0 ], [ -1, -1, 
              -1, -1 ] ], 
      [ [ 0, 1, 0, 0 ], [ 0, 0, 0, 1 ], [ 0, 0, 1, 0 ], [ 1, 0, 0, 0 ] ] ], 
  standardization := 1, identifier := [ "A5", "A5G1-Zr4B0.M", 1, 4 ] )
gap> gens = OneAtlasGeneratingSet( "A5", Ring, Integers );
true
gap> gens = OneAtlasGeneratingSet( "A5", Ring, CF(37) );
true
gap> OneAtlasGeneratingSet( "A5", Ring, Integers mod 77 );
fail
gap> gens:= OneAtlasGeneratingSet( "A5", Ring, CF(5), Dimension, 3 );
rec( 
  generators := [ [ [ -1, 0, 0 ], [ 0, -1, 0 ], [ -E(5)-E(5)^4, -E(5)-E(5)^4, 
              1 ] ], [ [ 0, 1, 0 ], [ 0, 0, 1 ], [ 1, 0, 0 ] ] ], 
  standardization := 1, identifier := [ "A5", "A5G1-Ar3aB0.M", 1, 3 ] )
gap> OneAtlasGeneratingSet( "A5", Ring, GF(17) );
fail

gap> tbl:= CharacterTable( "M11" );;
gap> modtbl:= tbl mod 2;;
gap> CharacterDegrees( modtbl );
[ [ 1, 1 ], [ 10, 1 ], [ 16, 2 ], [ 44, 1 ] ]

gap> DisplayAtlasInfo( "M11", Characteristic, 2 );
Representations for G = M11:    (all refer to std. generators 1)
----------------------------
 6: G <= GL(10,2)
 7: G <= GL(32,2)
 8: G <= GL(44,2)
16: G <= GL(16b,4)
17: G <= GL(16a,4)

gap> gens:= OneAtlasGeneratingSet( "M11", Characteristic, 2,
>                                         Dimension, 10 );;
gap> ccls:= AtlasStraightLineProgram( "M11", gens.standardization,
>                                     "classes" );
rec( program := <straight line program>, standardization := 1,
  identifier := [ "M11", [ "M11G1cycW1-cclsW1", "M11G1-cycW1" ], 1 ],
  outputs := [ "1A", "2A", "3A", "4A", "5A", "6A", "8A", "8B", "11A", "11B" ]
 )
gap> reps:= ResultOfStraightLineProgram( ccls.program, gens.generators );;

gap> Length( reps );
10
gap> List( reps, Order ) = OrdersClassRepresentatives( tbl );
true

gap> fus:= GetFusionMap( modtbl, tbl );
[ 1, 3, 5, 9, 10 ]
gap> modreps:= reps{ fus };;

gap> char:= List( modreps, BrauerCharacterValue );
[ 10, 1, 0, -1, -1 ]
gap> Position( Irr( modtbl ), char );
2

gap> grp:= Group( gens.generators );;
gap> v:= GF(2)^10;;
gap> orbs:= Orbits( grp, AsList( v ) );;
gap> List( orbs, Length );
[ 1, 396, 55, 330, 66, 165, 11 ]

gap> gens:= AtlasGenerators( "M11", 6, 1 );;

gap> id:= IdentityMat( 10, GF(2) );;
gap> sub1:= Subspace( v, NullspaceMat( gens.generators[1] - id ) );;
gap> sub2:= Subspace( v, NullspaceMat( gens.generators[2] - id ) );;
gap> fix:= Intersection( sub1, sub2 );
<vector space of dimension 1 over GF(2)>

gap> orb:= Orbit( grp, Basis( fix )[1] );;
gap> act:= Action( grp, orb );;  Print( act, "\n" );
Group( [ ( 1, 2)( 4, 6)( 5, 8)( 7,10), ( 1, 3, 5, 9)( 2, 4, 7,11) ] )

gap> permgrp:= Group( AtlasGenerators( "M11", 1 ).generators );;
gap> Print( permgrp, "\n" );
Group( [ ( 2,10)( 4,11)( 5, 7)( 8, 9), ( 1, 4, 3, 8)( 2, 5, 6, 9) ] )
gap> permgrp = act;
false
gap> IsConjugate( SymmetricGroup(11), permgrp, act );
true

gap> DisplayAtlasInfo( "G2(3)", IsStraightLineProgram );
Straight line programs for G = G2(3):    (all refer to std. generators 1)
-------------------------------------
available maxes of G:  [ 1 .. 10 ]
repres. of cyclic subgroups of G available?  true
class repres. of G available?  false
available automorphisms:  [ "2" ]
gap> prog:= AtlasStraightLineProgram( "G2(3)", "2" ).program;;
gap> gens:= AtlasGenerators( "G2(3)", 1 ).generators;;
gap> imgs:= ResultOfStraightLineProgram( prog, gens );;
gap> g:= Group( gens );;

gap> aut:= GroupHomomorphismByImagesNC( g, g, gens, imgs );;
gap> SetIsBijective( aut, true );

gap> max1:= AtlasStraightLineProgram( "G2(3)", 1 ).program;;
gap> mgens:= ResultOfStraightLineProgram( max1, gens );;
gap> comp:= CompositionOfStraightLinePrograms( max1, prog );;
gap> mimgs:= ResultOfStraightLineProgram( comp, gens );;

gap> mimgs = List( mgens, x -> x^aut );
true

gap> mat:= [ [ 1, -1 ], [ 0, 1 ] ] * Z(3)^0;;
gap> str:= MeatAxeString( mat, 3 );
"1 3 2 2\n12\n01\n"
gap> mat = ScanMeatAxeFile( str, "string" );
true
gap> str:= MeatAxeString( mat, 9 );
"1 9 2 2\n12\n01\n"
gap> mat = ScanMeatAxeFile( str, "string" );
true
gap> perms:= [ (1,2,3)(5,6) ];;
gap> str:= MeatAxeString( perms, 6 );
"12 1 6 1\n2\n3\n1\n4\n6\n5\n"
gap> perms = ScanMeatAxeFile( str, "string" );
true
gap> str:= MeatAxeString( perms, 8 );
"12 1 8 1\n2\n3\n1\n4\n6\n5\n7\n8\n"
gap> perms = ScanMeatAxeFile( str, "string" );
true
gap> perm:= (1,2,4);;
gap> str:= MeatAxeString( perm, 3, [ 5, 6 ] );
"2 3 5 6\n2\n4\n3\n1\n5\n"
gap> mat:= ScanMeatAxeFile( str, "string" );;  Print( mat, "\n" );
[ [ 0*Z(3), Z(3)^0, 0*Z(3), 0*Z(3), 0*Z(3), 0*Z(3) ], 
  [ 0*Z(3), 0*Z(3), 0*Z(3), Z(3)^0, 0*Z(3), 0*Z(3) ], 
  [ 0*Z(3), 0*Z(3), Z(3)^0, 0*Z(3), 0*Z(3), 0*Z(3) ], 
  [ Z(3)^0, 0*Z(3), 0*Z(3), 0*Z(3), 0*Z(3), 0*Z(3) ], 
  [ 0*Z(3), 0*Z(3), 0*Z(3), 0*Z(3), Z(3)^0, 0*Z(3) ] ]
gap> MeatAxeString( mat, 3 ) = str;
true

gap> FFList( GF(4) );
[ 0*Z(2), Z(2)^0, Z(2^2), Z(2^2)^2 ]
gap> IsBound( FFLists[4] );
true

gap> str:= "inp 2\nmu 1 2 3\nmu 3 1 2\niv 2 1\noup 2 1 2";;
gap> prg:= ScanStraightLineProgram( str, "string" );
rec( program := <straight line program> )
gap> prg:= prg.program;;
gap> Display( prg );
# input:
r:= [ g1, g2 ];
# program:
r[3]:= r[1]*r[2];
r[2]:= r[3]*r[1];
r[1]:= r[2]^-1;
# return values:
[ r[1], r[2] ]
gap> StringOfResultOfStraightLineProgram( prg, [ "a", "b" ] );
"[ (aba)^-1, aba ]"
gap> AtlasStringOfStraightLineProgram( prg );
"inp 2\nmu 1 2 3\nmu 3 1 2\niv 2 1\noup 2\n"
gap> prg:= StraightLineProgram( "(a^2b^3)^-1", [ "a", "b" ] );
<straight line program>
gap> Print( AtlasStringOfStraightLineProgram( prg ) );
inp 2
pwr 2 1 4
pwr 3 2 5
mu 4 5 3
iv 3 4
oup 1 4
gap> prg:= StraightLineProgram( [ [2,3], [ [3,1,1,4], [1,2,3,1] ] ], 2 );
<straight line program>
gap> Print( AtlasStringOfStraightLineProgram( prg ) );
inp 2
pwr 3 2 3
pwr 4 1 5
mu 3 5 4
pwr 2 1 6
mu 6 3 5
oup 2 4 5


gap> STOP_TEST( "docxpl.tst", 10000000 );


#############################################################################
##
#E

