#############################################################################
##
#W  hardtest.tst      GAP share package `atlasrep'              Thomas Breuer
##
#H  @(#)$Id: hardtest.tst,v 1.6 2001/03/26 15:46:43 gap Exp $
##
#Y  Copyright (C)  2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file contains, among others, those checks for the AtlasRep package
##  that examine the transfer from a server and the matrices that are
##  contained in the local `atlasgens' directory.
##  *Note that these tests cannot be performed without server access.*
##
##  In order to run the tests, one starts {\GAP} from the `gap' subdirectory
##  of the `pkg/atlasrep' directory, and calls `ReadTest( "hardtest.tst" );'.
##

gap> START_TEST("$Id: hardtest.tst,v 1.6 2001/03/26 15:46:43 gap Exp $");


# Load the package.
gap> RequirePackage( "atlasrep" );
true

# Test transferring group generators in {\MeatAxe} format.
gap> dir:= DirectoriesPackageLibrary( "atlasrep", "datagens" );;
gap> id:= OneAtlasGeneratingSet( "A5", Characteristic, 2 ).identifier;;
gap> for file in List( id[2], name -> Filename( dir, name ) ) do
>      RemoveFile( file );
> od;
gap> id = AtlasGenerators( id ).identifier;
true

# Test transferring group generators in {\GAP} format,
# to be converted from MAGMA format before reading.
gap> id:= OneAtlasGeneratingSet( "A5", Characteristic, 0 ).identifier;;
gap> RemoveFile( FilenameAtlas( "datagens", "A5", id[2] ) );;
gap> id = AtlasGenerators( id ).identifier;
true

# Read all {\MeatAxe} format files in the local installation.
gap> if not AtlasOfGroupRepresentationsTestFiles() then
>      Print( "#I  Error in `TestAtlasFiles'\n" );
> fi;

# Check whether changes of server files require cleanup.
gap> if not AtlasOfGroupRepresentationsTestTableOfContentsRemoteUpdates() then
>      Print( "#I  Cleanup required by ",
>             "`TestAtlasTableOfContentsRemoteUpdates'\n" );
> fi;

# Check the automorphism mentioned in the documentation.
# (This is too hard for {\GAP}~4.2 but feasible in 4.3.)
gap> prog:= AtlasStraightLineProgram( "G2(3)", "2" ).program;;
gap> gens:= AtlasGenerators( "G2(3)", 1 ).generators;;
gap> imgs:= ResultOfStraightLineProgram( prog, gens );;
gap> g:= Group( gens );;
gap> aut:= GroupHomomorphismByImages( g, g, gens, imgs );;
gap> IsBijective( aut );
true

# Check the interface functions.
gap> g:= "A5";;
gap> IsRecord( OneAtlasGeneratingSet( g ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, 1 ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, IsPermGroup ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, 1, IsPermGroup ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, NrMovedPoints, 5 ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, 1, NrMovedPoints, 5 ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, IsMatrixGroup ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, 1, IsMatrixGroup ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, Characteristic, 2 ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, 1, Characteristic, 2 ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, Dimension, 2 ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, 1, Dimension, 2 ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, Characteristic,2,Dimension,2 ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, 1,Characteristic,2,Dimension,2 ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, Ring, GF(2) ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, 1, Ring, GF(2) ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, Ring, GF(2), Dimension, 4 ) );
true
gap> IsRecord( OneAtlasGeneratingSet( g, 1, Ring, GF(2), Dimension, 4 ) );
true

# Call `AtlasClassNames' for all tables of nonsimple and almost simple
# groups.
# (Note that we have no easy access to the list of almost simple groups,
# here we use a heuristic argument based on the structure of names.)
# We check whether the function runs without error messages,
# and that the class names returned are different and are compatible with
# the element orders.
gap> digitprefix:= function( str )
>        local bad;
>        bad:= First( str, x -> not IsDigitChar( x ) );
>        if bad = fail then
>          return str;
>        else
>          return str{ [ 1 .. Position( str, bad ) - 1 ] };
>        fi;
> end;;
gap> simpl:= AllCharacterTableNames( IsSimple, true );;
gap> bad:= [ "A6.D8", "O8+(3).A4", "O8+(3).S4" ];;
gap> for name in AllCharacterTableNames() do
>      pos:= Position( name, '.' );
>      if pos <> fail then
>        for simp in simpl do
>          if     Length( simp ) = pos-1
>             and name{ [ 1 .. pos-1 ] } = simp
>             and ForAll( "xMN", x -> Position( name, x, pos ) = fail )
>             and not name in bad then
>            tbl:= CharacterTable( name );
>            classnames:= AtlasClassNames( tbl );
>            if    classnames = fail
>               or Length( classnames ) <> Length( Set( classnames ) )
>               or List( classnames, digitprefix )
>                   <> List( OrdersClassRepresentatives( tbl ), String ) then
>              Print( "#I  AtlasClassNames: problem for `", name, "'\n" );
>            fi;
>          fi;
>        od;
>      fi;
>    od;

# Test whether the scripts that return class representatives
# are sufficiently consistent.
gap> AtlasOfGroupRepresentationsTestClassScripts();
true


gap> STOP_TEST( "hardtest.tst", 10000000 );


#############################################################################
##
#E

