##############################################################################
##
#W  map2.gd                        XMOD Package                  Chris Wensley
#W                                                                 & Murat Alp
##
##  Declaration file for functions of the XMOD package.
##
#H  @(#)$Id: map2.gd,v 1.2 2002/04/17 gap Exp $
##
#Y  Copyright (C) 1999,2001 University of St. Andrews, North Haugh,
#Y                          St. Andrews, Fife KY16 9SS, Scotland
##
Revision.("xmod/gap/map2_gd") := 
    "@(#)$Id: map2.gd,v 2.001 2002/04/17 gap Exp $";

#############################################################################
##
#P  IsGeneral2dMapping( <map> )
#P  Is2dMapping( <mor> )
#P  IsPreXModMorphism( <mor> )
#P  IsXModMorphism( <mor> )
##
##  A pre-crossed module or pre-cat1-group morphism is a pair of group homs
##
DeclareProperty( "IsGeneral2dMapping", IsGeneralMapping );
DeclareProperty( "Is2dMapping",
    IsGeneral2dMapping and RespectsMultiplication and RespectsOne );
DeclareProperty( "IsPreXModMorphism", Is2dMapping );
DeclareProperty( "IsXModMorphism", IsPreXModMorphism );

#############################################################################
##
#R  Is2dMappingRep( <mor> )
##
##  A pre-crossed module or pre-cat1-group morphism is a pair of group homs
##
DeclareRepresentation( "Is2dMappingRep", 
    Is2dMapping and IsAttributeStoringRep,
    [ "Source", "Range", "SourceHom", "RangeHom" ] );

#############################################################################
##
#A  SourceHom( <mor> )
##
DeclareAttribute( "SourceHom", Is2dMapping );

#############################################################################
##
#A  RangeHom( <mor> )
##
DeclareAttribute( "RangeHom", Is2dMapping );

#############################################################################
##
#A  Kernel2dMapping( <mor> )
##
DeclareAttribute( "Kernel2dMapping", Is2dMapping );

#############################################################################
##
#O  Make2dMapping( <src>, <rng>, <srchom>, <rnghom> )
##
DeclareOperation( "Make2dMapping",
    [ Is2dObject, Is2dObject, IsGroupHomomorphism, IsGroupHomomorphism ] );

#############################################################################
##
#F  PreXModMorphism( <args> )
##
DeclareGlobalFunction( "PreXModMorphism" );

#############################################################################
##
#O  PreXModMorphismByHoms( <src>, <rng>, <srchom>, <rnghom> )
##
DeclareOperation( "PreXModMorphismByHoms",
    [ IsPreXMod, IsPreXMod, IsGroupHomomorphism, IsGroupHomomorphism ] );

#############################################################################
##
#F  XModMorphism( <args> )
##
DeclareGlobalFunction( "XModMorphism" );

#############################################################################
##
#O  XModMorphismByHoms( <src>, <rng>, <srchom>, <rnghom> )
##
DeclareOperation( "XModMorphismByHoms",
    [ IsXMod, IsXMod, IsGroupHomomorphism, IsGroupHomomorphism ] );

#############################################################################
##
#O  InnerAutomorphismXMod( <XM>, <r> )
##
DeclareOperation( "InnerAutomorphismXMod",
    [ IsPreXMod, IsMultiplicativeElementWithInverse ] );

#############################################################################
##
#P  IsPermPreXModMorphism( <mor> )
##
DeclareProperty( "IsPermPreXModMorphism", IsPreXModMorphism );

#############################################################################
##
#A  IsomorphismPermPreXMod( <PM> )
##
##  DeclareAttribute( "IsomorphismPermPreXMod", IsPreXMod );

#############################################################################
##
#P  IsPreCat1Morphism( <mor> )
##
DeclareProperty( "IsPreCat1Morphism", Is2dMapping );

#############################################################################
##
#P  IsCat1Morphism( <mor> )
##
DeclareProperty( "IsCat1Morphism", IsPreCat1Morphism );

#############################################################################
##
#F  PreCat1Morphism( <args> )
##
DeclareGlobalFunction( "PreCat1Morphism" );

#############################################################################
##
#O  PreCat1MorphismByHoms( <src>, <rng>, <srchom>, <rnghom> )
##
DeclareOperation( "PreCat1MorphismByHoms",
    [ IsPreCat1, IsPreCat1, IsGroupHomomorphism, IsGroupHomomorphism ] );

#############################################################################
##
#F  Cat1Morphism( <args> )
##
DeclareGlobalFunction( "Cat1Morphism" );

#############################################################################
##
#O  Cat1MorphismByHoms( <src>, <rng>, <srchom>, <rnghom> )
##
DeclareOperation( "Cat1MorphismByHoms",
    [ IsCat1, IsCat1, IsGroupHomomorphism, IsGroupHomomorphism ] );

#############################################################################
##
#A  ReverseIsomorphism( <PCG> )
##
DeclareAttribute( "ReverseIsomorphism", IsPreCat1 );

#############################################################################
##
#P  IsPermPreCat1Morphism( <mor> )
##
DeclareProperty( "IsPermPreCat1Morphism", IsPreCat1Morphism );

#############################################################################
##
#P  IsSourceMorphism( <mor> )
##
DeclareProperty( "IsSourceMorphism", IsXModMorphism );

#############################################################################
##
#O  CompositionMorphism( <mor2>, <mor1> )
##
DeclareOperation( "CompositionMorphism", [ Is2dMapping, Is2dMapping ] );

#############################################################################
##
#O  PreXModBySourceHom( <mor> )
##
DeclareOperation( "PreXModBySourceHom", [ IsPreXModMorphism ] );

#############################################################################
##
#A  XModMorphismOfCat1Morphism( <mor> )
##
DeclareAttribute( "XModMorphismOfCat1Morphism", IsCat1Morphism );

#############################################################################
##
#O  XModMorphismByCat1Morphism( <mor> )
##
DeclareOperation( "XModMorphismByCat1Morphism", [ IsCat1Morphism ] );

#############################################################################
##
#A  Cat1MorphismOfXModMorphism( <mor> )
##
DeclareAttribute( "Cat1MorphismOfXModMorphism", IsXModMorphism );

#############################################################################
##
#O  Cat1MorphismByXModMorphism( <mor> )
##
DeclareOperation( "Cat1MorphismByXModMorphism", [ IsXModMorphism ] );

##############################################################################
##
#E  map2.gd . . . . . . . . . . . . . . . . . . . . . . . . . . . .  ends here
