##############################################################################
##
#W  obj2.gd                         XMOD Package                  Chris Wensley
#W                                                                 & Murat Alp
##
##  Declaration file for functions of the XMOD package.
##
#H  @(#)$Id: obj2.gd,v 1.2 2002/04/17 gap Exp $
##
#Y  Copyright (C) 1999,2001 University of St. Andrews, North Haugh,
#Y                          St. Andrews, Fife KY16 9SS, Scotland
##
Revision.("xmod/gap/obj2_gd") := 
    "@(#)$Id: obj2.gd,v 2.001 2002/04/17 gap Exp $";

###############################################################################
##
#V  InfoXMod
##
DeclareInfoClass( "InfoXMod" );

#############################################################################
##
#P  Is2dObject( <obj> )
##
DeclareProperty( "Is2dObject", IsObject );

#############################################################################
##
#R  IsPreXModObj( <obj> )
##
##  A pre-crossed module is a group homomorphism which preserves an action
##
DeclareRepresentation( "IsPreXModObj", IsObject and IsAttributeStoringRep,
      [ "boundary", "action" ] );

#############################################################################
##
#R  IsPreCat1Obj( <obj> )
##
##  A pre-cat1-group module is a pair of group endomorphisms
##  which have a common image
##
DeclareRepresentation( "IsPreCat1Obj", IsObject and IsAttributeStoringRep,
    [ "tail", "head", "rangeEmbedding" ] );

#############################################################################
##
#P  IsPerm2dObject( <obj> )
##
DeclareProperty( "IsPerm2dObject", Is2dObject );

#############################################################################
##
#P  IsFp2dObject( <obj> )
##
DeclareProperty( "IsFp2dObject", Is2dObject );

#############################################################################
##
#P  IsPc2dObject( <obj> )
##
DeclareProperty( "IsPc2dObject", Is2dObject );

#############################################################################
##
#P  IsPreXMod( <PM> )
##
DeclareProperty( "IsPreXMod", Is2dObject );

#############################################################################
##
#P  IsPermPreXMod( <PM> )
##
DeclareSynonym( "IsPermPreXMod", IsPreXMod and IsPerm2dObject );

#############################################################################
##
#P  IsFpPreXMod( <PM> )
##
DeclareSynonym( "IsFpPreXMod", IsPreXMod and IsFp2dObject );

#############################################################################
##
#P  IsPcPreXMod( <PM> )
##
DeclareSynonym( "IsPcPreXMod", IsPreXMod and IsPc2dObject );

#############################################################################
##
#P  IsXMod( <PM> )
##
DeclareProperty( "IsXMod", Is2dObject );

InstallTrueMethod( IsPreXMod, IsXMod );

#############################################################################
##
#P  IsPermXMod( <XM> )
##
DeclareSynonym( "IsPermXMod", IsXMod and IsPerm2dObject );

#############################################################################
##
#P  IsFpXMod( <XM> )
##
DeclareSynonym( "IsFpXMod", IsXMod and IsFp2dObject );

#############################################################################
##
#P  IsPcXMod( <XM> )
##
DeclareSynonym( "IsPcXMod", IsXMod and IsPc2dObject );

#############################################################################
##
#P  IsPreCat1( <PCG> )
##
DeclareProperty( "IsPreCat1", Is2dObject );

#############################################################################
##
#P  IsPermPreCat1( <PCG> )
##
DeclareSynonym( "IsPermPreCat1", IsPreCat1 and IsPerm2dObject );

#############################################################################
##
#P  IsFpPreCat1( <PCG> )
##
DeclareSynonym( "IsFpPreCat1", IsPreCat1 and IsFp2dObject );

#############################################################################
##
#P  IsPcPreCat1( <PCG> )
##
DeclareSynonym( "IsPcPreCat1", IsPreCat1 and IsPc2dObject );

#############################################################################
##
#P  IsCat1( <C1G> )
##
DeclareProperty( "IsCat1", Is2dObject );

#############################################################################
##
#P  IsPermCat1( <CG> )
##
DeclareSynonym( "IsPermCat1", IsCat1 and IsPerm2dObject );

#############################################################################
##
#P  IsFpCat1( <CG> )
##
DeclareSynonym( "IsFpCat1", IsCat1 and IsFp2dObject );

#############################################################################
##
#P  IsPcCat1( <CG> )
##
DeclareSynonym( "IsPcCat1", IsCat1 and IsPc2dObject );

#############################################################################
##
#O  PreXModObj( <bdy>, <act> )
##
DeclareOperation( "PreXModObj",
    [ IsGroupHomomorphism, IsGroupHomomorphism ] );

#############################################################################
##
#A  Boundary( <PM> )
##
DeclareAttribute( "Boundary", IsPreXMod );

#############################################################################
##
#A  AutoGroup( <PM> )
##
DeclareAttribute( "AutoGroup", IsPreXMod );

#############################################################################
##
#A  XModAction( <PM> )
##
DeclareAttribute( "XModAction", IsPreXMod );

#############################################################################
##
#A  PeifferSubgroup( <obj> )
##
DeclareAttribute( "PeifferSubgroup", Is2dObject );

#############################################################################
##
#O  PeifferSubgroupPreXMod( <PM> )
##
DeclareOperation( "PeifferSubgroupPreXMod", [ IsPreXMod ] );

#############################################################################
##
#O  PeifferSubgroupPreCat1( <P1C> )
##
DeclareOperation( "PeifferSubgroupPreCat1", [ IsPreCat1 ] );

#############################################################################
##
#O  PreXModByBoundaryAndAction( <bdy>, <act> )
##
DeclareOperation( "PreXModByBoundaryAndAction",
   [ IsGroupHomomorphism, IsGroupHomomorphism ] );

#############################################################################
##
#O  PreXModByCentralExtensionion( <hom> )
##
DeclareOperation( "PreXModByCentralExtension", [ IsGroupHomomorphism ] );

#############################################################################
##
#O  XModByBoundaryAndAction( <bdy>, <act> )
##
DeclareOperation( "XModByBoundaryAndAction",
   [ IsGroupHomomorphism, IsGroupHomomorphism ] );

#############################################################################
##
#O  XModByTrivialAction( <f> )
##
DeclareOperation( "XModByTrivialAction", [ IsGroupHomomorphism ] );

#############################################################################
##
#O  XModByNormalSubgroup( <G>, <N> )
##
DeclareOperation( "XModByNormalSubgroup", [ IsGroup, IsGroup ] );

#############################################################################
##
#O  XModByCentralExtension( <hom> )
##
DeclareOperation( "XModByCentralExtension", [ IsGroupHomomorphism ] );

#############################################################################
##
#O  XModByGroupOfAutomorphisms( <G>, <A> )
##
DeclareOperation( "XModByGroupOfAutomorphisms", 
    [ IsGroup, IsGroupOfAutomorphisms ] );

#############################################################################
##
#F  XModByAutomorphismGroup( <args> )
##
DeclareGlobalFunction( "XModByAutomorphismGroup" );

#############################################################################
##
#A  XModByInnerAutomorphismGroup( <G> )
##
DeclareAttribute( "XModByInnerAutomorphismGroup", IsGroup );

#############################################################################
##
#O  XModByRModule( <R> )
##
DeclareOperation( "XModByRModule", [ IsRModule ] );

#############################################################################
##
#A  XModByPeifferQuotient( <PM> )
##
DeclareAttribute( "XModByPeifferQuotient", IsPreXMod );

#############################################################################
##
#F  XMod( <args> )
##
DeclareGlobalFunction( "XMod" );

#############################################################################
##
#O  AsXMod( <arg> )
##
DeclareOperation( "AsXMod", [ IsObject ] );

#############################################################################
##
#P  IsTrivialAction2dObject( <obj> )
##
DeclareProperty( "IsTrivialAction2dObject", Is2dObject );

#############################################################################
##
#P  IsNormalSubgroup2dObject( <obj> )
##
DeclareProperty( "IsNormalSubgroup2dObject", Is2dObject );

#############################################################################
##
#P  IsCentralExtensionXMod( <obj> )
##
DeclareProperty( "IsCentralExtension2dObject", Is2dObject );

#############################################################################
##
#P  IsAutomorphismGroupXMod( <XM> )
##
DeclareProperty( "IsAutomorphismGroupXMod", IsPreXModObj );

#############################################################################
##
#P  IsRModule2dObject( <obj> )
##
DeclareProperty( "IsRModule2dObject", Is2dObject );

#############################################################################
##
#P  IsFreeXMod( <XM> )
##
DeclareProperty( "IsFreeXMod", IsPreXModObj );

#############################################################################
##
#O  IsSubPreXMod( <obj> )
#O  IsSubXMod( <obj> )
#O  IsSubPreCat1( <obj> )
#O  IsSubCat1( <obj> )
##
DeclareOperation( "IsSubPreXMod", [ IsPreXMod, IsPreXMod ] );
DeclareOperation( "IsSubXMod", [ IsXMod, IsXMod ] );
DeclareOperation( "IsSubPreCat1", [ IsPreCat1, IsPreCat1 ] );
DeclareOperation( "IsSubCat1", [ IsCat1, IsCat1 ] );

##############################################################################
##
#O  Sub2dObject( <obj>, <src>, <rng> )
#O  SubPreXMod( <PM, Ssrc, Srng> )
#O  SubXMod( <PM, Ssrc, Srng> )
#O  SubPreCat1( <C>, <H> )                           
##
DeclareOperation( "Sub2dObject", [ Is2dObject, IsGroup, IsGroup ] );
DeclareOperation( "SubPreXMod", [ IsPreXMod, IsGroup, IsGroup ] );
DeclareOperation( "SubXMod", [ IsXMod, IsGroup, IsGroup ] );
DeclareOperation( "SubPreCat1", [ IsPreCat1, IsGroup, IsGroup ] );
DeclareOperation( "SubCat1", [ IsCat1, IsGroup, IsGroup ] );

#############################################################################
##
#O  IdentitySub2dObject( <obj> )
#A  IdentitySubPreXMod( <obj> )
#A  IdentitySubXMod( <obj> )
#A  IdentitySubPreCat1( <obj> )
#A  IdentitySubCat1( <obj> )
##
DeclareOperation( "IdentitySub2dObject", [ Is2dObject ] );
DeclareAttribute( "IdentitySubPreXMod", IsPreXMod );
DeclareAttribute( "IdentitySubXMod", IsXMod );
DeclareAttribute( "IdentitySubPreCat1", IsPreCat1 );
DeclareAttribute( "IdentitySubCat1", IsCat1 );

#############################################################################
##
#P  IsIdentityCat1( <C1G> )
##
DeclareProperty( "IsIdentityCat1", IsCat1 );

#############################################################################
##
#O  PreCat1Obj( <arg> )
##
DeclareOperation( "PreCat1Obj",
    [ IsGroupHomomorphism, IsGroupHomomorphism, IsGroupHomomorphism ] );

#############################################################################
##
#A  Tail( <PCG> )
##
DeclareAttribute( "Tail", IsPreCat1 );

#############################################################################
##
#A  Head( <PCG> )
##
DeclareAttribute( "Head", IsPreCat1 );

#############################################################################
##
#A  RangeEmbedding( <PCG> )
##
DeclareAttribute( "RangeEmbedding", IsPreCat1 );

#############################################################################
##
#A  Reverse( <PCG> )
##
DeclareAttribute( "Reverse", IsPreCat1 );

#############################################################################
##
#O  PreCat1ByTailHeadEmbedding( <t>, <h>, <e> )
##
DeclareOperation( "PreCat1ByTailHeadEmbedding",
    [ IsGroupHomomorphism, IsGroupHomomorphism, IsGroupHomomorphism ] );

#############################################################################
##
#O  PreCat1ByEndomorphisms( <tail>, <head> )
##
DeclareOperation( "PreCat1ByEndomorphisms",
    [ IsGroupHomomorphism, IsGroupHomomorphism ] );

#############################################################################
##
#O  PreCat1ByNormalSubgroup( <G>, <N> )
##
DeclareOperation( "PreCat1ByNormalSubgroup", [ IsGroup, IsGroup ] );

#############################################################################
##
#O  PreXModByPreCat1( <PCG> )
##
DeclareOperation( "PreXModByPreCat1", [ IsPreCat1 ] );

#############################################################################
##
#O  PreCat1ByPreXMod( <PM> )
##
DeclareOperation( "PreCat1ByPreXMod", [ IsPreXMod ] );

#############################################################################
##
#A  XModOfCat1( <C1G> )
##
DeclareAttribute( "XModOfCat1", IsCat1 );

#############################################################################
##
#O  XModByCat1( <C1G> )
##
DeclareOperation( "XModByCat1", [ IsCat1 ] );

#############################################################################
##
#A  Cat1OfXMod( <XM> )
##
DeclareAttribute( "Cat1OfXMod", IsXMod );

#############################################################################
##
#O  Cat1ByXMod( <XM> )
##
DeclareOperation( "Cat1ByXMod", [ IsXMod ] );

#############################################################################
##
#A  SourceEmbedding( <XM> )
##
##  homomorphism from Source(XM) to Source(Cat1OfXMod(XM))
##
DeclareAttribute( "SourceEmbedding", IsPreXMod );

#############################################################################
##
#F  PreCat1( <arg> )
##
DeclareGlobalFunction( "PreCat1" );

#############################################################################
##
#F  Cat1( <arg> )
##
DeclareGlobalFunction( "Cat1" );

#############################################################################
##
#O  Cat1ByPeifferQuotient( <PM> )
##
DeclareOperation( "Cat1ByPeifferQuotient", [ IsPreCat1 ] );

#############################################################################
##
#A  KernelEmbedding( <C> )
##
DeclareAttribute( "KernelEmbedding", IsPreCat1 );

#############################################################################
##
#A  DirectProduct2dInfo( <D> )
##
DeclareAttribute( "DirectProduct2dInfo", Is2dObject, "mutable" );

#############################################################################
##
#A  NormalSubXMods( <XM> )
##
DeclareAttribute( "NormalSubXMods", IsXMod );

#############################################################################
##
#E  obj2.gd . . . . . . . . . . . . . . . . . . . . . . . . . . . . ends here

