##############################################################################
##
#W  up2.gd                         XMOD Package                  Chris Wensley
#W                                                                 & Murat Alp
##
##  Declaration file for functions of the XMOD package.
##
#H  @(#)$Id: up2.gd,v 1.2 2002/04/17 gap Exp $
##
#Y  Copyright (C) 1999,2001 University of St. Andrews, North Haugh,
#Y                          St. Andrews, Fife KY16 9SS, Scotland
##
Revision.("xmod/gap/up2_gd") := 
    "@(#)$Id: up2.gd,v 2.001 2002/04/17 gap Exp $";

#############################################################################
##
#P  IsUpMapping( <map> )
##
DeclareProperty( "IsUpMapping", IsGeneralMapping );

#############################################################################
##
#R  IsUpMappingObj( <map> )
##
##  A section|derivation is determined by a cat1-group|xmod + generator images
##
DeclareRepresentation( "IsUpMappingObj", IsUpMapping and IsAttributeStoringRep,
    [ "Object2d", "GeneratorImages" ] );

#############################################################################
##
#A  Object2d( <map> )
#A  GeneratorImages( <map> )
#A  ImagePositions( <map> )
##
DeclareAttribute( "Object2d", IsUpMapping );
DeclareAttribute( "GeneratorImages", IsUpMapping );
DeclareAttribute( "ImagePositions", IsUpMapping );

#############################################################################
##
#O  UpMappingObj( <obj>, <ims> )
##
DeclareOperation( "UpMappingObj", [ Is2dObject, IsHomogeneousList ] );

#############################################################################
##
#P  IsDerivation( <map> )
#P  IsSection( <map> )
##
DeclareProperty( "IsDerivation", IsUpMapping );
DeclareProperty( "IsSection", IsUpMapping );


##############################################################################
##                               Derivations                                ##
##############################################################################

##############################################################################
##
#O  DerivationByImages                                     sets up the mapping
#O  DerivationByImagesNC                                   sets up the mapping
##
DeclareOperation( "DerivationByImages", [ Is2dObject, IsHomogeneousList ] );
DeclareOperation( "DerivationByImagesNC", [ Is2dObject, IsHomogeneousList ] );
##  usage: DerivationByImages( XM, im, [, true|false ] )

##############################################################################
##
#O  DerivationImage                  image of  r \in R  by the derivation  chi
##
DeclareOperation( "DerivationImage", [ IsDerivation, IsObject ] );

###############################################################################
##
#O  DerivationBySection  construct an XMod derivation from a cat1-group section
##
DeclareOperation( "DerivationBySection", [ IsSection ] );

##############################################################################
##
#O  CompositeDerivation                 Whitehead composite of two derivations
##
DeclareOperation( "CompositeDerivation", [ IsDerivation, IsDerivation ] );

##############################################################################
##
#P  IsRegularDerivation                   so an element of the Whitehead group
##
DeclareProperty( "IsRegularDerivation", IsDerivation );

##############################################################################
##
#O  TestWhiteheadIsomorphism                  checks compatibility of products
##
DeclareOperation( "TestWhiteheadIsomorphism", [ IsXMod ] );

#############################################################################
##
#O  InverseDerivations      Finds all semigroup inverses XJ for derivation Xi
##                                                i.e.  XiXjXi=Xi & XjXiXj=Xj
DeclareOperation( "InverseDerivations", [ IsDerivation ] );

##############################################################################
##
#O  ListInverseDerivations               List all inverses for each derivation
##
DeclareOperation( "ListInverseDerivations", [ IsXMod ] );


##############################################################################
##                                 Sections                                 ##
##############################################################################

##############################################################################
##
#O  SectionByImages                                   sets up GroupHomByImages
#O  SectionByImagesNC                                 sets up GroupHomByImages
##
DeclareOperation( "SectionByImages", [ Is2dObject, IsGroupHomomorphism ] );
DeclareOperation( "SectionByImagesNC", [ Is2dObject, IsGroupHomomorphism ] );
##  usage: SectionByImages( C, im, [, true|false ] )

##############################################################################
##
#O  SectionByDerivation      the cat1-group section determined by a derivation
##
DeclareOperation( "SectionByDerivation", [ IsDerivation ] );

##############################################################################
##
#O  CompositeSection                       Whitehead composite of two sections
##
DeclareOperation( "CompositeSection", [ IsSection, IsSection ] );


#############################################################################
##                      Monoids of Derivations or Sections                 ##
#############################################################################

#############################################################################
##
#P  IsMonoidOfUpMappings( <obj> )
##
DeclareProperty( "IsMonoidOfUpMappings", IsObject );

#############################################################################
##
#R  IsMonoidOfUpMappingsObj( <obj> )
##
##  An UpMappings record stores images lists and composition table
##
DeclareRepresentation( "IsMonoidOfUpMappingsObj",
    IsMonoidOfUpMappings and IsAttributeStoringRep,
    [ "Object2d", "ImagesList" ] );

##############################################################################
##
#A  ImagesList                                returns list of DerivationImages
#A  AllOrRegular                                    type of derivations record
#A  ImagesTable                                   returns lists of image lists
##
DeclareAttribute( "ImagesList", IsMonoidOfUpMappings );
DeclareAttribute( "AllOrRegular", IsMonoidOfUpMappings );
DeclareAttribute( "ImagesTable", IsMonoidOfUpMappings );

#############################################################################
##
#O  MonoidOfUpMappingsObj( <obj>, <images>, <str> )
##
DeclareOperation( "MonoidOfUpMappingsObj",
    [ Is2dObject, IsHomogeneousList, IsString ] );

##############################################################################
##
#P  IsMonoidOfDerivations                               
#P  IsMonoidOfSections
##
DeclareProperty( "IsMonoidOfDerivations", IsMonoidOfUpMappings );
DeclareProperty( "IsMonoidOfSections", IsMonoidOfUpMappings );

##############################################################################
##
#A  RegularDerivations    find all invertible derivations for a crossed module
#A  AllDerivations                   find all derivations for a crossed module
#A  RegularSections              find all invertible sections for a cat1-group
#A  AllSections                             find all sections for a cat1-group
##
DeclareAttribute( "RegularDerivations", IsXMod );
DeclareAttribute( "AllDerivations", IsXMod );
DeclareAttribute( "RegularSections", IsCat1 );
DeclareAttribute( "AllSections", IsCat1 );

##############################################################################
##
#O  BacktrackDerivationsJ          recursive function for BacktrackDerivations
#O  BacktrackDerivations            recursive construction for all derivations
#O  BacktrackSectionsJ         recursion used by RegularSections & AllSections
##
DeclareOperation( "BacktrackDerivationsJ",  [ IsXMod, IsHomogeneousList,
    IsHomogeneousList, IsHomogeneousList, IsInt, IsString ] );
DeclareOperation( "BacktrackDerivations", [ IsXMod, IsString ] );
DeclareOperation( "BacktrackSectionsJ", [ IsRecord, IsInt, IsObject, IsInt ] );

###############################################################################
##
#A  WhiteheadMonoidTable( XM )                 Table of products of derivations
#A  WhiteheadGroupTable( XM )          Table of products of regular derivations
##
DeclareAttribute( "WhiteheadMonoidTable", IsXMod );
DeclareAttribute( "WhiteheadGroupTable", IsXMod );

###############################################################################
##
#A  WhiteheadPermGroup( XM )                       a permutation representation
#A  WhiteheadTransMonoid( XM )                  a transformation representation
##
DeclareAttribute( "WhiteheadPermGroup", IsXMod );
DeclareAttribute( "WhiteheadTransMonoid", IsXMod );

###############################################################################
##
#E  up2.gd  . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
