##############################################################################
##
#W  util.gd                        XMOD Package                  Chris Wensley
#W                                                                 & Murat Alp
##
##  Declaration file for functions of the XMOD package.
##
#H  @(#)$Id: util.gd,v 1.2 2002/04/17 gap Exp $
##
#Y  Copyright (C) 1999,2001 University of St. Andrews, North Haugh,
#Y                          St. Andrews, Fife KY16 9SS, Scotland
##
Revision.("xmod/gap/util_gd") := 
    "@(#)$Id: util.gd,v 2.001 2002/04/17 gap Exp $";

#############################################################################
##
#A  IdentitySubgroup( <G> )
##
DeclareAttribute( "IdentitySubgroup", IsGroup );

#############################################################################
##
#O  InclusionMapping( <G>, <H> )
##
DeclareOperation( "InclusionMapping", [ IsGroup, IsGroup ] );

#############################################################################
##
#O  RestrictionMappingOp( <hom>, <src>, <rng> )
##
## DeclareOperation( "RestrictionMappingOp",
DeclareOperation( "RestrictionMapping",
    [ IsGeneralMapping, IsGroup, IsGroup ] );

#############################################################################
##
#F  RestrictionMapping( <hom>, <src> )
#F  RestrictionMapping( <hom>, <src>, <rng> )
##
## DeclareGlobalFunction( "RestrictionMapping" );

#############################################################################
##
#O  ZeroMapping( <G>, <H> )
##
##  DeclareOperation( "ZeroMapping", [ IsMagma, IsMagmaWithOne ] );

#############################################################################
##
#P  IsEndomorphism( <f> )
##
DeclareProperty( "IsEndomorphism", IsGroupHomomorphism );

#############################################################################
##
#P  IsAutomorphism( <f> )
##
DeclareProperty( "IsAutomorphism", IsGroupHomomorphism );

InstallTrueMethod( IsAutomorphism, IsEndomorphism and IsBijective );

#############################################################################
##
#O  InnerAutomorphismsOfNormalSubgroup( <G>, <N> )
##
DeclareOperation( "InnerAutomorphismsOfNormalSubgroup", [ IsGroup, IsGroup ] );

#############################################################################
##
#F  InnerAutomorphismGroup( <G> )
#F  InnerAutomorphismGroup( <G>, <N> )
##
DeclareGlobalFunction( "InnerAutomorphismGroup" );

#############################################################################
##
#O  TrivialAction( <G>, <H> )
##
DeclareOperation( "TrivialAction", [ IsGroup, IsGroup ] );

#############################################################################
##
#R  IsRModuleObj( <obj> )
##
DeclareRepresentation( "IsRModuleObj", IsObject and IsAttributeStoringRep,
    [ "rModuleGroup", "rModuleAction" ] );

#############################################################################
##
#P  IsRModule( <obj> )
##
DeclareProperty( "IsRModule", IsObject );

#############################################################################
##
#A  RModuleGroup( <obj> )
##
DeclareAttribute( "RModuleGroup", IsRModule );

#############################################################################
##
#A  RModuleAction( <obj> )
##
DeclareAttribute( "RModuleAction", IsRModule );

#############################################################################
##
#O  RModuleObject( <abgrp>, <act> )
##
DeclareOperation( "RModuleObject", [ IsCommutative, IsGroupHomomorphism ] );

#############################################################################
##
#R  IsEndomorphismClassObj( <obj> )
##
##  An endomorphism class of a group G is a set of endomorphisms G -> G
##  with image in the same conjugacy class of subgroups of G
##
DeclareRepresentation( "IsEndomorphismClassObj",
    IsObject and IsAttributeStoringRep,
    [ "NaturalHomEndoClass", "Isomorphism", "AutoGroup", "Conjugators" ] );

#############################################################################
##
#P  IsEndomorphismClass( <cl> )
##
DeclareProperty( "IsEndomorphismClass", IsObject );

#############################################################################
##
#A  NaturalHomorphism( <class> )
##
DeclareAttribute( "NaturalHomEndoClass", IsEndomorphismClassObj );

#############################################################################
##
#A  Isomorphism( <class> )
##
DeclareAttribute( "Isomorphism", IsEndomorphismClassObj );

#############################################################################
##
#A  Conjugators( <class> )
##
DeclareAttribute( "Conjugators", IsEndomorphismClassObj );

##############################################################################
##
#O  EndomorphismClassObj( <nat>, <iso>, <aut>, <conj> )
##
DeclareOperation( "EndomorphismClassObj",
 [IsGroupHomomorphism, IsGroupHomomorphism, IsGroupOfAutomorphisms, IsList] );

#############################################################################
##
#A  AutomorphismClass( <G> )
##
DeclareAttribute( "AutomorphismClass", IsGroup );

#############################################################################
##
#A  NontrivialEndomorphismClasses( <G> )
##
DeclareAttribute( "NontrivialEndomorphismClasses", IsGroup );

#############################################################################
##
#A  NonIntersectingEndomorphismClasses( <G> )
##
DeclareAttribute( "NonIntersectingEndomorphismClasses", IsGroup );

#############################################################################
##
#A  ZeroEndomorphismClass( <G> )
##
DeclareAttribute( "ZeroEndomorphismClass", IsGroup );

#############################################################################
##
#F  EndomorphismClasses( <G> )
##
DeclareGlobalFunction( "EndomorphismClasses", [ IsGroup, IsInt ] );

###############################################################################
##
#O  EndomorphismImages( <list> )
##
DeclareOperation( "EndomorphismImages", [ IsList ] );

###############################################################################
##
#O  IdempotentImages( <list> )
##
DeclareOperation( "IdempotentImages", [ IsList ] );

##############################################################################
##
#A  GenerationOrder         elements of G generated as words in the generators
##
DeclareAttribute( "GenerationOrder", IsGroup );

##############################################################################
##
#A  GenerationPairs         elements of G generated as words in the generators
##
DeclareAttribute( "GenerationPairs", IsGroup );

##############################################################################
##
#O  CheckGenerationPairs             G.generationPairs, G.generationOrder ok ?
##
DeclareOperation( "CheckGenerationPairs", [ IsGroup ] );

#############################################################################
##
#E  util.gd . . . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
