#############################################################################
##
#W  test1.g                     XMOD test files                 Chris Wensley
#W                                                                & Murat Alp
##
#H  $Id: test1.g,v 2.001 2002/04/17 gap Exp $
##
#Y  Copyright (C) 1999,2001 University of St. Andrews, North Haugh,
#Y                          St. Andrews, Fife KY16 9SS, Scotland
##
#############################################################################

Print("\nXMod test file test1.g  :-");
Print("\ntesting constructions of crossed modules\n\n");

c5 := Group( (1,2,3,4,5) );
SetName( c5, "c5" );
X1 := XModByAutomorphismGroup( c5 );
Print("X1 = ",X1," is a crossed module :-\n");
Display( X1 );
Print("Properties; Attributes; Representations of X1 :-\n");
Print( KnownPropertiesOfObject(X1), "\n" );
Print( KnownAttributesOfObject(X1), "\n" );
Print( RepresentationsOfObject(X1), "\n" );
Print("X1 has size ", Size(X1), "\n\n" );

s3c4 := Group( (1,2), (2,3), (4,5,6,7) );
SetName( s3c4, "s3c4" );
s3 := Subgroup( s3c4, [ (1,2), (2,3) ] );
SetName( s3, "s3" );
gens3c4 := GeneratorsOfGroup( s3c4 );
imb := [ (1,2), (2,3), () ];
bX2 := GroupHomomorphismByImages( s3c4, s3, gens3c4, imb );
im1 := List( gens3c4, g -> g^(1,2) );
a1 := GroupHomomorphismByImages( s3c4, s3c4, gens3c4, im1 );
im2 := List( gens3c4, g -> g^(2,3) );
a2 := GroupHomomorphismByImages( s3c4, s3c4, gens3c4, im2 );
A := Group( a1, a2 );
aX2 := GroupHomomorphismByImages( s3, A, [(1,2),(2,3)], [a1,a2] );
X2 := XMod( bX2, aX2 );
Print("crossed module X2 = ",X2,"\n");
Display(X2);

s4 := Group( (1,2,3,4), (1,2) );
SetName( s4, "s4");
a4 := Subgroup( s4, [ (1,2,3), (2,3,4) ] );
SetName( a4, "a4" );
k4 := Subgroup( a4, [ (1,2)(3,4), (1,3)(2,4) ] );
SetName( k4, "k4" );
X4 := XModByNormalSubgroup( a4, k4 );
Print("crossed module X4 = ",X4,"\n");
Display(X4);

d8 := Subgroup( s4, [ (1,2,3,4), (1,3) ] );
SetName( d8, "d8" );
gend8 := GeneratorsOfGroup( d8 );
genk4 := GeneratorsOfGroup( k4 );
f8 := GroupHomomorphismByImages( d8, k4, gend8, genk4 );
X8 := XModByCentralExtension( f8 );
Print("crossed module X8 = ",X8,"\n");
Display(X8);

q8 := Group( (1,2,3,4)(5,8,7,6), (1,5,3,7)(2,6,4,8) );
SetName( q8, "q8" );
genq8 := GeneratorsOfGroup( q8 );
iaq8 := InnerAutomorphismGroup( q8 );
geniaq8 := GeneratorsOfGroup( iaq8 );
a := GroupHomomorphismByImages( q8, q8, genq8,
        [(1,5,3,7)(2,6,4,8),(1,4,3,2)(5,6,7,8)] );
genA8 := Concatenation( geniaq8, [a] );
idq8 := IdentityMapping( q8 );
A8 := Group( genA8, idq8 );
ok := IsGroupOfAutomorphisms( A8 );
AX8 := XModByGroupOfAutomorphisms( q8, A8 );
Print("crossed module AX8 = ",AX8,"\n");
Display(AX8);

imf := [ (1,3)(2,4), (1,3)(2,4) ];
f := GroupHomomorphismByImages( k4, d8, genk4, imf );
T8 := XModByTrivialAction( f );
Print("crossed module T8 = ",T8,"\n");
Display(T8);

imk4 := [ (1,3)(2,4), (1,4)(2,3) ];
c3 := Group( (11,12,13) );
SetName(c3,"c3");
a3 := GroupHomomorphismByImages( k4, k4, genk4, imk4 );
A3 := Group( a3 );
ic3 := GroupHomomorphismByImages( c3, A3, [(11,12,13)], [a3] );
ok := IsGroupOfAutomorphisms( A3 );
R3 := RModuleObject( k4, ic3 );
X3 := XModByRModule( R3 );
Print("crossed module X3 = ",X3,"\n");
Display(X3);

X14 := DirectProduct( X1, X4 );
Print("Direct product of X1 and X4 = ", X14, "\n" );
Display( X14 );
e1 := Embedding( X14, 1 );
e2 := Embedding( X14, 2 );
Print("Direct Product Information for X14:\n", DirectProductInfo(X14), "\n");

Print("\nPre-XMods\n");
d16 := Group( (1,2,3,4,5,6,7,8), (2,8)(3,7)(4,6) );
SetName( d16, "d16" );
gend16 := GeneratorsOfGroup( d16 );
sk4 := Subgroup( d16, [ (1,5)(3,7)(2,6)(4,8), (2,8)(3,7)(4,6) ] );
gensk4 := GeneratorsOfGroup( sk4 );
SetName( sk4, "sk4" );
f16 := GroupHomomorphismByImages( d16, sk4, gend16, gensk4 );
P16 := PreXModByCentralExtension( f16 );
Print("pre-crossed module P16 = ",P16,"\n");
Display(P16);
P := PeifferSubgroup( P16 );
Print( "P16 has Peiffer subgroup ", P, "\n" );
X16 := XModByPeifferQuotient( P16 );
Print("Peiffer quotient xmod X16 = ", X16, "\n" );
Display( X16 );
iso16 := IsomorphismPermGroup( Source( X16 ) );
S16 := Image( iso16 );
