#############################################################################
##
#W  test2.g                     XMOD test files                 Chris Wensley
#W                                                                & Murat Alp
##
#H  $Id: test2.g,v 2.001 2002/04/17 gap Exp $
##
#Y  Copyright (C) 1999,2001 University of St. Andrews, North Haugh,
#Y                          St. Andrews, Fife KY16 9SS, Scotland
##
#############################################################################

Print("\nXMod test file test2.g :-");
Print("\ntesting constructions of crossed module morphisms\n\n");

msl23 := SpecialLinearGroup( 2, 3 );
isl23 := IsomorphismPermGroup( msl23 );
sl23 := Image( isl23 );
Print( "sl23 = ", sl23, "\n" );
SetName( sl23, "sl23" );
nq8 := NormalSubgroups( sl23 )[3];
Print("normal subgroup nq8 of sl23 = ",nq8,"\n");
SetName( nq8, "nq8" );
X23 := XModByNormalSubgroup( sl23, nq8 );
Print("Normal subgroup xmod X23 = ", X23, "\n" );
Display( X23 );

c5 := Group( (1,2,3,4,5) );
SetName( c5, "c5" );
X1 := XModByAutomorphismGroup( c5 );

sigma1 := GroupHomomorphismByImages( c5, c5, [(1,2,3,4,5)], [(1,5,4,3,2)] );
rho1 := InclusionMapping( Range(X1), Range(X1) );
#ok := IsGroupHomomorphism(sigma1) and IsGroupHomomorphism( rho1 );
mor1 := XModMorphism( X1, X1, sigma1, rho1 );
Print("mor1 = ",mor1, " is a morphism X1 -> X1 :-\n");
Display( mor1 );
Print("Is mor1 an automorphism? ", IsAutomorphism(mor1), "\n");
Print("the order of mor1 is ", Order(mor1), "\n\n");

gensl23 := GeneratorsOfGroup(sl23);
gennq8 := GeneratorsOfGroup(nq8);
rmor := GroupHomomorphismByImages( sl23, a4, gensl23, [(1,2,3),(1,2)(3,4)] );
smor := GroupHomomorphismByImages(nq8, k4, gennq8, [(1,3)(2,4),(1,4)(2,3),()]);
mor23 := XModMorphism( X23, X4, smor, rmor );
Print("mor23 = ",mor23, " is a morphism X23 -> X4 :-\n");
Display( mor23 );
Print("Is mor23 single valued? ", IsSingleValued(mor23), "\n");
Print("Is mor23 surjective? ", IsSurjective(mor23), "\n");
Print("Is mor23 total? ", IsTotal(mor23), "\n");
Print("Is mor23 injective? ", IsInjective(mor23), "\n\n");
Print("KnownProperties; Attributes; Representations of m23 :-\n");
Print(KnownPropertiesOfObject(mor23),"\n");
Print(KnownAttributesOfObject(mor23),"\n");
Print(RepresentationsOfObject(mor23),"\n\n");

c4 := Subgroup( nq8, [ gennq8[1] ] );
SetName(c4,"c4");
S23 := SubXMod( X23, c4, nq8 );
Print("subxmod S23 of X23 = ", S23, "\n" );
Display( S23 );
Print("S23 is a sub-xmod of X23 ? ", IsSubXMod( X23, S23 ), "\n" );
Print("S23 is a normal sub-xmod of X23 ? ", IsNormal( X23, S23 ), "\n\n" );
inc23 := InclusionMapping( X23, S23 );
Print("inc23 = inclusion mapping\n", mor23, "\n");
Display( inc23 );

imor4 := IdentityMapping( X4 );
Print("\nimor4 = identity mapping on X4\n", imor4, "\n");
Display( imor4 );

N23 := NormalSubXMods( X23 );
Print("X23 has ", Length(N23), " sub-crossed modules :-\n",N23,"\n" );
Print("with sizes ",List(N23,n->Size(n)),"\n\n");

x := gennq8[1]*gennq8[2];
ia23 := InnerAutomorphismXMod( S23, x );
Print("\nia23 = inner automorphism of S23\n", ia23, "\n");
Display( ia23 );

comp1 := ia23*inc23;
Print("ia23 * inc23 = ", comp1, "\n" );
comp2 := CompositionMorphism( inc23, ia23 );
Print("CompositionMorphism( inc23, ia23 ) = ", comp2, "\n");
Print("comp1 = comp2 ? ",comp1 = comp2,"\n\n");

c2 := Subgroup( nq8, [ gennq8[1]^2 ] );
SetName( c2, "c2" );
SS23 := SubXMod( S23, c2, nq8 );
Print("subxmod SS23 of S23 = ", SS23, "\n" );
Display( SS23 );
incSS := InclusionMapping( S23, SS23 );
Print("inclusion mapping SS23 -> S23 = ", incSS, "\n");
Display( incSS );
T23 := PreXModBySourceHom( incSS );
Print("\nTop crossed module for incSS = ", T23, "\n" );
Display( T23 );
