#############################################################################
##
#W  test3.g                     XMOD test files                 Chris Wensley
#W                                                                & Murat Alp
##
#H  $Id: test3.g,v 2.001 2002/04/17 gap Exp $
##
#Y  Copyright (C) 1999,2001 University of St. Andrews, North Haugh,
#Y                          St. Andrews, Fife KY16 9SS, Scotland
##
#############################################################################

Print("\nXMod test file test3.g :-");
Print("\ntesting constructions of cat1-groups\n\n");

t2 := GroupHomomorphismByImages( s3c4, s3, gens3c4, [(1,2),(2,3),()] );
e2 := InclusionMapping( s3c4, s3 );
C2 := Cat1( t2, t2, e2 );
Print("cat1-group C2 = ",C2,"\n" );
Display( C2 );
XC2 := XModByCat1( C2 );
Print("associated crossed module is XC2 = ", XC2, "\n" );
Display( XC2 );

CX1 := Cat1ByXMod( X1 );
Print("cat1-group associated to X1 is CX1 = ", CX1, "\n" );
Display( CX1 );

hol20 := Group( (1,2,3,4,5), (2,3,5,4) );
SetName( hol20, "hol20" );
gen20 := GeneratorsOfGroup( hol20 );
c4 := Subgroup( hol20, [ (2,3,5,4) ] );
SetName( c4, "c4" );
im20 := [ (), (2,3,5,4) ];
h20 := GroupHomomorphismByImages( hol20, c4, gen20, im20 );
t20 := h20;
e20 := InclusionMapping( hol20, c4 );
C20 := Cat1( t20, h20, e20 );
Print("cat1-group C20 = ",C20,"\n" );
Display( C20 );

Print("Properties; Attributes; Representations of C20 :-\n");
Print( KnownPropertiesOfObject(C20), "\n" );
Print( KnownAttributesOfObject(C20), "\n" );
Print( RepresentationsOfObject(C20), "\n" );
Print("C20 has size ", Size(C20), "\n\n" );

c5 := Subgroup( hol20, [ (1,2,3,4,5) ] );
SetName( c5, "c5" );
X20 := XModByNormalSubgroup( hol20, c5 );
Print("normal inclusion crossed module X20 = ",X20,"\n" );
Display( X20 );
CX20 := Cat1ByXMod( X20 );
Print("associated cat1-group CX20 = ",CX20,"\n" );
Display( CX20 );
G20 := Source( CX20 );
Print("CX20 has source ",G20,", with Properties, Attributes:\n");
Print(KnownPropertiesOfObject(G20),"\n");
Print(KnownAttributesOfObject(G20),"\n");
sdp20 := SemidirectProductInfo(G20);
Print("The SemidirectProductInfo of G20 is:\n",sdp20,"\n");
Print("\nNeed to implement Cat1Select\n\n" );
