#############################################################################
##
#W  test4.g                     XMOD test files                 Chris Wensley
#W                                                                & Murat Alp
##
#H  $Id: test4.g,v 2.001 2002/04/17 gap Exp $
##
#Y  Copyright (C) 1999,2001 University of St. Andrews, North Haugh,
#Y                          St. Andrews, Fife KY16 9SS, Scotland
##
#############################################################################

Print("\nXMod test file test4.g :-");
Print("\ntesting constructions of cat1-group morphisms\n\n");

CX4 := Cat1ByXMod( X4 );
Print("cat1-group associated to X4 is CX4 = ", CX4, "\n" );
Display( CX4 );

sdp := Group( (11,12,13), (14,15,16), (12,13)(15,16) );
SetName( sdp, "sdp" );
s3b := Group( (24,25,26), (22,23)(25,26) );
SetName( s3b, "s3b" );
gensdp := GeneratorsOfGroup( sdp );
gens3b := GeneratorsOfGroup( s3b );
t18 := GroupHomomorphismByImages(sdp, s3b, gensdp,
  [ (24,25,26), (24,25,26), (22,23)(25,26) ] );
h18 :=  GroupHomomorphismByImages(sdp, s3b, gensdp,
  [ (), (24,25,26), (22,23)(25,26) ] );
e18 := GroupHomomorphismByImages(s3b, sdp, gens3b,
  [ (14,15,16), (12,13)(15,16) ] );
C18 := Cat1( t18, h18, e18 );
Print("cat1-group C18 = ", C18, "\n" );
Display( C18 );
XC18 := XModByCat1( C18 );
Print("associated crossed module XC18 = ", XC18, "\n" );
Display( XC18 );

ida4 := IdentityMapping( a4 );
AC4 := Cat1( ida4, ida4, ida4 );
Print("identity cat1-group AC4 = ", AC4, "\n" );
Display( AC4 );
GAC4 := Source( AC4 );
GCX4 := Source( CX4 );
genGAC4 := GeneratorsOfGroup( GAC4 );
genGCX4 := GeneratorsOfGroup( GCX4 );
im144 := genGCX4{[1..2]};
s144 := GroupHomomorphismByImages( GAC4, GCX4, genGAC4, im144 );
r144 := InclusionMapping( a4, a4 );
m144 := Cat1Morphism( AC4, CX4, s144, r144 );
Print("\nmorphism of cat1-groups AC4 => CX4  :  ", m144, "\n" );
Display(m144);
Print("Properties; Attributes; Representations of m144 :-\n");
Print( KnownPropertiesOfObject(m144), "\n" );
Print( KnownAttributesOfObject(m144), "\n" );
Print( RepresentationsOfObject(m144), "\n\n" );

RCX20 := Reverse( CX20 );
Print("reverse cat1-group to CX20 is RCX20 = ", RCX20, "\n" );
Display( RCX20 );
reviso := ReverseIsomorphism( CX20 );
Print("reverse isomorphism CX20 -> RCX20 is:\n", reviso, "\n" );
Display(reviso);

Cmor23 := Cat1MorphismOfXModMorphism( mor23 );
Print("the cat1-morphism corresponding to mor23 is :-\n");
Display(Cmor23);
Print("\nmor23 and Cmor23 have attributes:\n");
Print(KnownAttributesOfObject(mor23),"\n");
Print(KnownAttributesOfObject(Cmor23),"\n");
