#############################################################################
##
#W  test5.g                     XMOD test files                 Chris Wensley
#W                                                                & Murat Alp
##
#H  $Id: test5.g,v 2.001 2002/04/17 gap Exp $
##
#Y  Copyright (C) 1999,2001 University of St. Andrews, North Haugh,
#Y                          St. Andrews, Fife KY16 9SS, Scotland
##
#############################################################################

Print("\nXMod test file test5.g :-");
Print("\ntesting derivations of crossed modules\n\n");

c5 := Group( (1,2,3,4,5) );
SetName( c5, "c5" );
X1 := XModByAutomorphismGroup( c5 );        
chi1 := DerivationByImages( X1, [ (), () ] );
Print( "chi1 = ", chi1, "\n" );
ok1 := IsDerivation( chi1 );
Print("chi1 is a derivation? ", ok1, "\n" );
Print("chi1 has Object2d = ", Object2d( chi1 ), "\n" );
Print("chi1 has GeneratorImages = ", GeneratorImages( chi1 ), "\n" );
Print("chi1 has source = ", Source(chi1), "\n" );
Print("chi1 has range = ", Range(chi1), "\n" );
Print("known properties of chi1:\n", KnownPropertiesOfObject(chi1), "\n" );
Print("known attributes of chi1:\n", KnownAttributesOfObject(chi1), "\n" );

C1 := Cat1OfXMod( X1 );
Print("\nX1 is associated to cat1-group C1 =\n", C1, "\n" );
xi1 := SectionByDerivation( chi1 );
Print("xi1 = ", xi1, "\n" );

reg1 := RegularDerivations( X1 );
Print("\nImages list for RegularDerivations( X1 ) :-\n");
Print( ImagesList( reg1 ), "\n" );
all1 := AllDerivations( X1 );
Print("\nImages list for AllDerivations( X1 ) :-\n");
Print( ImagesList( all1 ), "\n\n" );

imder1 := ImagesList( reg1 );
chi2 := DerivationByImages( X1, imder1[2] );
chi3 := DerivationByImages( X1, imder1[3] );
Print( "chi2 = ", chi2, "\n" );
Print( "chi3 = ", chi3, "\n" );
im2 := ImagePositions( chi2 );
im3 := ImagePositions( chi3 );
Print("chi2 has image positions : ", im2, "\n" );
Print("chi3 has image positions : ", im3, "\n" );

chi23 := chi2 * chi3;
im23 := ImagePositions( chi23 );
Print( "chi2 * chi3= ", chi23, "\nwith image positions", im23, "\n" );

Print("\n\n################################################\n\n");

g18 := Group( (1,2,3), (4,5,6), (2,3)(5,6) );
SetName( g18, "g18" );
gen18 := GeneratorsOfGroup( g18 );
a := gen18[1];  b := gen18[2];  c := gen18[3];
s3 := Subgroup( g18, gen18{[2..3]} );
SetName( s3, "s3" );
t := GroupHomomorphismByImages( g18, s3, gen18, [ b,b,c] );
h := GroupHomomorphismByImages( g18, s3, gen18, [(),b,c] );
e := GroupHomomorphismByImages( s3, g18, [b,c], [b,c] );

C3 := Cat1( t, h, e );
Print("the cat1-group C3 :-\n");
Display(C3);

X3 := XModOfCat1( C3 );
Print("the crossed module X3 associated to C3 :-\n");
Display( X3 );

Print("X3 has attributes:\n", KnownAttributesOfObject(X3), "\n");
Print("C3 has attributes:\n", KnownAttributesOfObject(C3), "\n\n");

imchi := [ (1,2,3)(4,6,5), (1,2,3)(4,6,5) ];
chi := DerivationByImages( X3, imchi );
Print("chi has GeneratorImages = ", GeneratorImages(chi), "\n" );
Print("chi has ImagePositions  = ", ImagePositions( chi ), "\n\n" );

reg3 := RegularDerivations( X3 );
Print("regular derivations of X3 have images list\n" );
imder3 := ImagesList( reg3 );
Display( imder3 );
Print("images table for these derivations:\n" );
Display( ImagesTable( reg3 ) );
wgt3 := WhiteheadGroupTable( X3 );
Print("X3 has Whitehead Group Table:\n");
Display( wgt3);
wpg3 := WhiteheadPermGroup( X3 );
gwpg3 := GeneratorsOfGroup( wpg3);
Print("Whitehead perm group wpg3 of X3 is ", wpg3, "\n");
Print("and has generators ", gwpg3, "\n\n");

all3 := AllDerivations( X3 );
Print("all derivations of X3 have images list\n" );
Display( ImagesList( all3 ) );
Print("images table for these derivations:\n" );
Display( ImagesTable( all3 ) );
wmt3 := WhiteheadMonoidTable( X3 );
Print("X3 has Whitehead Monoid Table:\n");
Display( wmt3);
wtm3 := WhiteheadTransMonoid( X3 );
Print("Whitehead monoid of X3 has trans rep with generators:\n");
Print(GeneratorsOfMonoid(wtm3),"\n\n");

chi4 := DerivationByImages( X3, imder3[4] );
chi5 := DerivationByImages( X3, imder3[5] );
Print( "chi4 = ", chi4, "\n" );
Print( "chi5 = ", chi5, "\n" );
im4 := ImagePositions( chi4 );
im5 := ImagePositions( chi5 );
Print("chi4 has image positions : ", im4, "\n" );
Print("chi5 has image positions : ", im5, "\n" );

chi45 := chi4 * chi5;
im45 := ImagePositions( chi45 );
Print( "chi4 * chi5 = ", chi45, "\nwith image positions ", im45, "\n" );
pos := Position( imder3, GeneratorImages( chi45 ) );
Print("chi4 * chi5 is the derivation in position ", pos, "\n" );
p45 :=  gwpg3[4]*gwpg3[5];
Print("perm4 * perm5 is ", p45 );
Print(" which is also in position ", Position( gwpg3, p45 ), "\n");
Print("CONCLUSION: the perm rep _is_ isomorphic to the Whitehead group!\n\n");
