#A  BOUNDS FOR q = 2
##
##  Each entry [n][k] of one of the tables below contains
##  a bound (the first table contains lowerbounds, the   
##  second upperbounds) for a code with wordlength n and 
##  dimension k. Each entry contains one of the following
##  items:                                               
##                                                       
##  FOR LOWER- AND UPPERBOUNDSTABLE                      
##  [ 0, <d>, <ref> ]  from Brouwers table               
##                                                       
##  FOR LOWERBOUNDSTABLE                                 
##  empty        k= 0, 1, n or d= 2 or (k= 2 and q= 2)   
##  1            shortening a [ n + 1, k + 1 ] code      
##  2            puncturing a [ n + 1, k ] code          
##  3            extending a [ n - 1, k ] code           
##  [ 4, <dd> ]  constr. B, of a [ n+dd, k+dd-1, d ] code
##  [ 5, <k1> ]  an UUV-construction with a [ n / 2, k1 ]
##               and a [ n / 2, k - k1 ] code            
##  [ 6, <n1> ]  concatenation of a [ n1, k ] and a      
##               [ n - n1, k ] code                      
##  [ 7, <n1> ]  taking the residue of a [ n1, k + 1 ] code
##                                                       
##  FOR UPPERBOUNDSTABLE                                 
##  empty        Griesmer bound                          
##  11           shortening a [ n + 1, k + 1 ] code      
##  12           puncturing a [ n + 1, k ] code          
##  13           extending a [ n - 1, k ] code           
##  [ 14, <dd> ] constr. B, with dd = dual distance      


GUAVA_BOUNDS_TABLE[1][2] := [
#V   n = 1
[  ],
#V   n = 2
[  ],
#V   n = 3
[  ],
#V   n = 4
[  ],
#V   n = 5
[  ],
#V   n = 6
[ ,, [ 5, 2 ] ],
#V   n = 7
[ ,, 1, 2 ],
#V   n = 8
[ ,, [ 5, 2 ], [ 5, 3 ] ],
#V   n = 9
[ ,, [ 6, 3 ], 1, 2 ],
#V   n = 10
[ ,, [ 5, 2 ], [ 5, 3 ], [ 5, 4 ], [ 5, 4 ] ],
#V   n = 11
[ ,, 1, 2, 1, 1, 2 ],
#V   n = 12
[ ,, [ 5, 2 ], [ 5, 3 ], [ 5, 4 ], [ 5, 5 ], [ 5, 5 ], [ 5, 5 ] ],
#V   n = 13
[ ,, 1, [ 6, 5 ], 2, 1, 1, 1, 1 ],
#V   n = 14
[ ,, 1, 1, 2, 1, [ 5, 6 ], [ 5, 6 ], 1, 1 ],
#V   n = 15
[ ,, 1, 1, 2, 1, 1, 1, 1, 1, 2 ],
#V   n = 16
[ ,, [ 5, 2 ], [ 5, 3 ], [ 5, 4 ], 1, 1, 1, [ 5, 7 ], [ 5, 7 ], [ 5, 7 ] ],
#V   n = 17
[ ,, [ 6, 3 ], [ 6, 5 ], 1, 1, 1, 1, [ 0, 5, "N" ], 1, 1, 1 ],
#V   n = 18
[ ,, [ 6, 4 ], [ 6, 5 ], 1, 1, 1, 1, 3, [ 5, 8 ], 1, 1, 1 ],
#V   n = 19
[ ,, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 2 ],
#V   n = 20
[ ,, [ 6, 6 ], [ 5, 3 ], [ 7, 37 ], [ 5, 5 ], 1, 1, 1, 1, 1, [ 5, 9 ], 
  [ 5, 9 ], [ 5, 9 ], [ 5, 9 ] ],
#V   n = 21
[ ,, [ 6, 7 ], [ 6, 5 ], 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1 ],
#V   n = 22
[ ,, 1, 1, [ 6, 6 ], 1, 2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1 ],
#V   n = 23
[ ,, 1, 1, 2, 1, [ 0, 9, "HP" ], 1, 1, 1, 1, [ 0, 7, "N" ], 1, 
  [ 0, 5, "Wa" ], 1, 1, 1, 2 ],
#V   n = 24
[ ,, [ 6, 6 ], [ 5, 3 ], [ 5, 4 ], 1, 3, [ 5, 7 ], [ 5, 7 ], 1, 1, 3, 1, 3, 
  [ 5, 11 ], [ 5, 11 ], [ 5, 11 ], [ 5, 11 ], [ 5, 11 ] ],
#V   n = 25
[ ,, [ 6, 7 ], [ 6, 5 ], [ 7, 49 ], [ 7, 47 ], 3, 1, 1, 1, 1, 3, 1, 3, 1, 1, 
  1, 1, 1, 1 ],
#V   n = 26
[ ,, [ 7, 54 ], [ 7, 52 ], [ 6, 10 ], [ 7, 50 ], [ 7, 48 ], 1, 1, 2, 1, 3, 1, 
  3, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 27
[ ,, [ 4, 4 ], [ 7, 55 ], [ 7, 53 ], 1, [ 7, 51 ], 1, 1, [ 0, 9, "Pi2" ], 1, 
  3, 1, [ 0, 7, "L" ], 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 28
[ ,, [ 4, 4 ], [ 5, 3 ], [ 7, 56 ], 2, 1, 1, 1, 3, 2, 3, 1, 3, 1, 1, 1, 1, 
  [ 5, 13 ], [ 5, 13 ], [ 5, 13 ], 1, 1 ],
#V   n = 29
[ ,, 1, 1, 1, 2, 1, 1, 1, 3, 2, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 30
[ ,, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 2, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 31
[ ,, [ 6, 3 ], 1, 1, 2, 1, 2, 1, 1, [ 0, 11, "BCH" ], 1, 2, 3, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 2 ],
#V   n = 32
[ ,, [ 6, 4 ], [ 5, 3 ], [ 5, 4 ], [ 5, 5 ], 1, [ 0, 13, "Sa" ], 1, 1, 3, 2, 
  [ 0, 10, "Sh" ], 3, [ 5, 11 ], [ 5, 11 ], [ 0, 8, "CS" ], 1, 1, 1, 1, 1, 
  [ 5, 15 ], [ 5, 15 ], [ 5, 15 ], [ 5, 15 ] ],
#V   n = 33
[ ,, [ 6, 4 ], [ 6, 5 ], 1, 3, 1, 3, 2, 1, 3, 2, 3, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1 ],
#V   n = 34
[ ,, [ 6, 6 ], [ 6, 4 ], [ 6, 10 ], 1, 1, 3, 2, 1, 3, [ 0, 12, "Sh" ], 3, 1, 
  1, 2, 3, 1, 1, 1, 1, 1, [ 0, 6, "Sh" ], [ 5, 15 ], [ 5, 16 ], 1, 1, 1 ],
#V   n = 35
[ ,, [ 6, 7 ], [ 6, 5 ], 1, 1, 1, 2, [ 0, 14, "Pi" ], 1, 3, 3, 1, 2, 1, 2, 3, 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1 ],
#V   n = 36
[ ,, [ 6, 4 ], [ 5, 3 ], [ 7, 70 ], 1, 1, [ 0, 16, "DH" ], 3, 1, 3, 3, 1, 
  [ 0, 11, "Mo" ], 1, [ 0, 10, "Sh" ], 3, 1, 1, 1, 1, 2, 3, 1, 1, [ 5, 17 ], 
  [ 5, 17 ], 1, 1, 1 ],
#V   n = 37
[ ,, [ 6, 4 ], [ 6, 7 ], [ 7, 73 ], [ 7, 70 ], 1, 3, [ 0, 15, "FB" ], 1, 
  [ 0, 13, "O" ], 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1 
 ],
#V   n = 38
[ ,, [ 6, 6 ], [ 6, 8 ], [ 6, 6 ], 3, 2, 3, 3, 2, 3, 3, 1, 3, 1, 3, 1, 1, 1, 
  1, 1, [ 0, 8, "Sh" ], 3, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 39
[ ,, [ 6, 7 ], 1, 2, [ 6, 7 ], [ 0, 17, "vT3" ], 3, 3, [ 0, 15, "Zv" ], 3, 2, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2 ],
#V   n = 40
[ ,, [ 6, 4 ], [ 5, 3 ], [ 5, 4 ], [ 6, 8 ], 3, 3, 3, 3, 3, [ 0, 14, "GG" ], 
  1, 3, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, [ 5, 19 ], [ 5, 19 ], 
  [ 5, 19 ], [ 5, 19 ], [ 5, 19 ] ],
#V   n = 41
[ ,, [ 6, 7 ], [ 6, 11 ], 1, 1, 3, 2, 3, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 
  [ 0, 9, "N" ], 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 42
[ ,, [ 6, 7 ], [ 6, 12 ], [ 6, 10 ], 1, [ 0, 19, "vT1" ], [ 0, 18, "DM" ], 3, 
  3, 1, [ 0, 15, "FB" ], 1, 1, 2, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1 ],
#V   n = 43
[ ,, [ 6, 7 ], 1, 1, 2, 3, 3, 1, 3, 1, 3, 2, 1, [ 0, 13, "BCH" ], 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 44
[ ,, [ 4, 4 ], [ 6, 14 ], 1, 2, 3, 2, 1, 2, 1, 3, 2, 1, 3, 2, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 45
[ ,, [ 6, 7 ], [ 6, 15 ], 1, [ 0, 22, "SS" ], 3, [ 0, 20, "DM" ], 2, 
  [ 0, 18, "Gu3" ], 2, 3, [ 0, 16, "CLS" ], 1, 3, [ 0, 13, "DJ" ], 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 46
[ ,, [ 6, 7 ], 1, 1, 3, 1, 3, [ 0, 19, "Sa" ], 3, [ 0, 17, "GG1" ], 3, 3, 1, 
  3, 3, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, [ 5, 22 ], 
  1, 1, 1, 1 ],
#V   n = 47
[ ,, [ 6, 7 ], 1, 1, 2, 1, 2, 3, 3, 3, 3, 3, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 
  [ 0, 11, "N" ], 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2 ],
#V   n = 48
[ ,, [ 6, 7 ], [ 5, 3 ], [ 5, 4 ], [ 5, 5 ], 1, [ 0, 22, "DM" ], 3, 1, 3, 1, 
  3, [ 5, 12 ], 1, [ 0, 15, "FB" ], [ 0, 14, "Je" ], [ 5, 14 ], [ 5, 14 ], 1, 
  1, 1, 1, 3, 1, 2, [ 5, 18 ], [ 5, 16 ], [ 5, 17 ], [ 5, 18 ], 
  [ 0, 8, "RR" ], [ 5, 18 ], [ 5, 19 ], 1, 1, [ 0, 6, "Sh" ], [ 5, 23 ], 
  [ 5, 23 ], [ 5, 23 ], [ 5, 23 ], [ 5, 23 ], [ 5, 23 ] ],
#V   n = 49
[ ,, [ 6, 7 ], [ 6, 11 ], 1, 1, 1, 3, 3, 1, [ 0, 19, "B2x" ], 1, 
  [ 0, 17, "B2x" ], 1, 1, 3, 3, 1, 2, 1, 1, 1, 1, 3, 1, [ 0, 10, "Sh" ], 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 50
[ ,, [ 6, 7 ], [ 6, 12 ], [ 6, 10 ], 1, 1, 2, 3, 1, 3, 1, 3, [ 5, 12 ], 1, 3, 
  2, 1, 2, 1, 1, 1, 1, 3, 2, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 1 ],
#V   n = 51
[ ,, [ 6, 7 ], [ 7, 103 ], [ 7, 101 ], 1, 1, [ 0, 24, "BCH" ], 1, 2, 3, 1, 3, 
  1, 1, 3, [ 0, 16, "N" ], 1, [ 0, 14, "BCH" ], 1, 1, 1, 1, 3, 
  [ 0, 11, "DJ" ], 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1 
 ],
#V   n = 52
[ ,, [ 6, 7 ], [ 6, 14 ], [ 7, 104 ], [ 7, 101 ], 1, 3, 1, [ 0, 21, "Pu" ], 
  3, 1, 1, 1, 1, 3, 3, 1, 3, 1, 2, 1, 1, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 53
[ ,, [ 6, 7 ], [ 6, 15 ], [ 7, 105 ], [ 7, 105 ], 1, 3, 1, 3, 3, 1, 1, 1, 1, 
  2, 3, 1, 1, 1, 2, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1 ],
#V   n = 54
[ ,, [ 6, 7 ], [ 7, 109 ], [ 7, 108 ], [ 7, 106 ], 2, 3, 1, 3, 
  [ 0, 21, "GG1" ], 1, 1, 1, 1, 2, 3, 1, 1, 1, 2, 1, 2, 3, 3, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 55
[ ,, [ 6, 7 ], 1, [ 7, 110 ], [ 7, 109 ], [ 0, 25, "Zv" ], 3, 1, 
  [ 0, 23, "Zv" ], 3, 1, 1, 1, 1, [ 0, 19, "LC" ], 3, 1, 1, 1, 
  [ 0, 15, "N" ], 1, [ 0, 13, "GG1" ], 3, 3, 1, 1, 1, 1, 1, [ 0, 10, "Sh" ], 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 56
[ ,, [ 6, 7 ], [ 6, 14 ], [ 5, 4 ], [ 7, 111 ], 3, 3, 1, 3, 3, 1, 2, 1, 1, 3, 
  [ 0, 17, "MoY" ], 1, 1, 1, 3, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 1, [ 5, 21 ], 
  [ 5, 20 ], [ 5, 21 ], 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 27 ], [ 5, 27 ], 
  [ 5, 27 ], [ 5, 27 ], 1, 1 ],
#V   n = 57
[ ,, [ 6, 7 ], [ 6, 15 ], [ 7, 113 ], [ 7, 112 ], 3, 2, 1, 3, 
  [ 0, 23, "SRC" ], 1, 2, 1, 1, 3, 3, 1, 1, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 58
[ ,, [ 6, 7 ], [ 7, 117 ], [ 7, 116 ], [ 7, 114 ], [ 7, 112 ], 
  [ 0, 26, "DH" ], 1, 3, 3, 1, [ 0, 22, "GG1" ], 1, 1, 3, 3, 1, 2, 1, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 59
[ ,, [ 6, 7 ], [ 6, 15 ], [ 7, 118 ], [ 7, 117 ], [ 7, 115 ], 3, 1, 3, 3, 1, 
  3, 1, 1, 3, 2, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 60
[ ,, [ 6, 7 ], [ 6, 15 ], 1, [ 7, 119 ], 2, [ 0, 27, "Sa" ], 1, 
  [ 0, 25, "Ch" ], 3, 1, 1, 1, 1, 3, [ 0, 20, "CDJ" ], 2, [ 0, 18, "CZ" ], 1, 
  3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 61
[ ,, [ 6, 7 ], 1, 1, 1, 2, 3, 1, 3, 3, 1, 1, 1, 1, 2, 3, 2, 3, 1, 3, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 62
[ ,, [ 6, 7 ], 1, 1, 1, 2, 3, 1, 3, 2, 1, 1, 1, 1, 2, 1, 2, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1 ],
#V   n = 63
[ ,, [ 6, 7 ], 1, 1, 1, 2, 3, 1, [ 0, 27, "BCH" ], [ 0, 26, "N" ], 1, 1, 1, 
  1, [ 0, 23, "BCH" ], 1, [ 0, 21, "BCH" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  [ 0, 15, "N" ], 1, [ 0, 13, "BCH" ], 1, 1, 1, 1, 1, [ 0, 11, "BCH" ], 1, 1, 
  1, 2, 1, 1, 1, 1, 1, [ 0, 7, "N" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2 ],
#V   n = 64
[ ,, [ 6, 7 ], [ 6, 14 ], [ 5, 4 ], [ 5, 5 ], [ 5, 6 ], 2, 1, 3, 3, 1, 2, 1, 
  1, 3, 1, 3, 1, 1, 2, 1, 1, 2, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  [ 0, 9, "G" ], [ 5, 26 ], [ 5, 26 ], [ 5, 26 ], 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  [ 5, 31 ], [ 5, 31 ], [ 5, 31 ], [ 5, 31 ], [ 5, 31 ] ],
#V   n = 65
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 3, 3, [ 0, 30, "DH" ], 1, 3, [ 0, 27, "Ch" ], 1, 
  [ 0, 25, "N" ], 1, 1, 3, 1, 3, 1, 1, 2, 1, 1, [ 0, 17, "GG" ], 1, 1, 1, 3, 
  1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  [ 0, 5, "N" ], 1, 1, 1, 1, 1 ],
#V   n = 66
[ ,, [ 6, 7 ], [ 6, 5 ], [ 6, 10 ], 1, 3, 3, 1, 3, 3, 1, 3, 1, 1, 3, 1, 
  [ 0, 23, "O" ], 1, 1, [ 0, 20, "CZ" ], 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 2, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1 ],
#V   n = 67
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 5 ], 1, 1, [ 0, 31, "Su" ], 1, [ 0, 29, "O" ], 
  3, 1, 3, 1, 1, 3, 1, 3, 2, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, [ 0, 11, "O" ], 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 1 ],
#V   n = 68
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 6 ], [ 6, 20 ], 1, 3, 1, 3, 3, 1, 3, 1, 1, 3, 
  1, 3, [ 0, 21, "Wi" ], 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  [ 5, 23 ], 3, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 2, 1, 1, 3, 1, 1, 
  [ 5, 33 ], [ 5, 33 ], [ 5, 33 ], 1, 1, 1 ],
#V   n = 69
[ ,, [ 6, 7 ], [ 6, 8 ], [ 7, 137 ], [ 7, 135 ], 1, 3, 1, 3, 3, 1, 2, 1, 1, 
  3, 1, 3, 3, 1, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 3, 
  1, 1, 1, 1, 2, 3, 1, 1, 1, [ 0, 8, "Sh" ], 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1 ],
#V   n = 70
[ ,, [ 6, 7 ], [ 6, 8 ], [ 6, 15 ], [ 7, 138 ], [ 7, 136 ], 3, 1, 
  [ 0, 31, "Su" ], [ 0, 29, "GG" ], 1, [ 0, 28, "GB2" ], 1, 1, 
  [ 0, 25, "O" ], 1, 3, 3, 1, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 3, 1, 2, 1, 1, 1, [ 0, 9, "GG" ], 3, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 71
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 7 ], 3, 3, 1, 3, 3, 2, 3, 2, 1, 3, 
  2, 3, [ 0, 23, "Wi" ], 1, [ 0, 21, "Wi" ], 1, 1, 1, 1, 1, 2, 
  [ 0, 17, "SRC" ], 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 3, 1, 2, 1, 1, 1, 3, 3, 1, 
  1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 72
[ ,, [ 6, 7 ], [ 6, 15 ], [ 5, 4 ], 2, [ 6, 8 ], 3, [ 5, 8 ], 3, 3, 
  [ 0, 29, "GG" ], 3, [ 7, 128 ], 1, 3, [ 0, 25, "Ka" ], 3, 3, 1, 3, 1, 1, 1, 
  1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 3, 1, [ 0, 12, "To" ], 1, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 35 ], [ 5, 35 ], 
  [ 5, 35 ], 1, 1, 1 ],
#V   n = 73
[ ,, [ 6, 7 ], [ 6, 12 ], 1, [ 0, 36, "SS" ], [ 6, 9 ], [ 0, 33, "Sa" ], 1, 
  3, [ 0, 31, "GG" ], 3, 3, 1, 1, 3, 3, 3, 3, 1, 3, 1, 2, 1, 1, 1, 
  [ 0, 20, "PT" ], 3, 1, 1, 1, 1, 1, 1, 1, [ 0, 16, "PT" ], 1, 
  [ 0, 13, "Ka" ], 3, 1, 3, 1, 2, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 74
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 15 ], 3, [ 0, 35, "HP" ], 3, [ 5, 8 ], 3, 3, 
  3, 2, 1, 1, [ 0, 27, "SRC" ], 3, [ 0, 25, "Al2" ], 3, 1, [ 0, 23, "Wi" ], 
  1, [ 0, 21, "Wi" ], 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 3, 1, 3, 
  1, [ 0, 11, "To" ], 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 75
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], 3, 3, 3, 2, 3, 3, [ 0, 31, "GG" ], 
  [ 0, 30, "To2" ], 1, 1, 3, 3, 3, 3, 1, 3, 1, 3, 1, 1, 1, 3, 2, 1, 1, 1, 1, 
  1, 1, 1, 3, 1, 3, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 76
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 2, 3, [ 0, 35, "Sa" ], [ 0, 33, "Ka" ], 3, 3, 3, 
  3, 1, 1, 3, [ 0, 27, "Ka" ], 3, 3, 1, 3, 1, 3, 1, 2, 1, 3, [ 0, 20, "PTX" ],
  1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 2, 3, 1, 3, 1, 3, 1, 1, 1, 1, 
  [ 0, 9, "Ka" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 37 ], 1, 1, 1, 
  1, 1 ],
#V   n = 77
[ ,, [ 6, 7 ], [ 6, 8 ], [ 6, 15 ], [ 6, 32 ], 3, 3, 3, 3, 3, 3, 2, 1, 1, 3, 
  3, 3, 3, 1, 3, 1, [ 0, 23, "Wi" ], 1, [ 0, 21, "Wi" ], 1, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 2, 3, 1, 3, 1, 1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 78
[ ,, [ 6, 7 ], 1, [ 6, 16 ], [ 6, 32 ], [ 0, 37, "HP" ], 3, 3, 2, 3, 3, 
  [ 0, 32, "To" ], 2, 1, [ 0, 29, "GG" ], 3, [ 0, 27, "Al2" ], 3, 1, 3, 1, 3, 
  1, 3, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 2, 3, 1, 3, 1, 1, 
  [ 0, 11, "ZL" ], 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 79
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 2, 3, 3, 1, 2, 3, 3, 3, 2, 1, 3, 3, 3, 1, 2, 3, 
  1, 3, 1, 3, 1, 3, 3, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, [ 0, 15, "L" ], 2, 1, 
  3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2 ],
#V   n = 80
[ ,, [ 6, 7 ], [ 6, 15 ], [ 5, 4 ], [ 5, 5 ], 3, [ 0, 37, "vT1" ], 1, 
  [ 0, 35, "Gu3" ], 3, 3, 3, [ 0, 32, "Pi" ], 1, 3, 3, 3, 1, 2, 3, 1, 3, 1, 
  [ 0, 23, "Wi" ], 1, [ 0, 21, "Wi" ], 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  [ 0, 14, "Wz" ], 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, [ 5, 32 ], [ 5, 33 ], 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 39 ], [ 5, 39 ], [ 5, 39 ], 
  [ 5, 39 ], [ 5, 39 ], [ 5, 39 ] ],
#V   n = 81
[ ,, [ 6, 7 ], [ 6, 12 ], 1, 1, [ 0, 39, "Su" ], 3, 2, 3, 2, 3, 3, 3, 1, 3, 
  3, 3, 1, [ 0, 26, "CZ" ], 3, 1, 3, 1, 3, 1, 3, 3, 1, 1, [ 0, 20, "GG" ], 1, 
  1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1 ],
#V   n = 82
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 20 ], 1, 3, 3, 2, 3, 2, 3, 3, 3, 1, 3, 3, 3, 
  1, 3, [ 0, 25, "CZ" ], 1, 3, 1, 3, 1, 3, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, [ 0, 6, "Sh" ], 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 83
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 21 ], 1, 3, 2, [ 0, 38, "GG" ], 3, 2, 1, 3, 3, 
  1, [ 0, 31, "GG" ], [ 0, 29, "GG" ], 3, 1, 2, 3, 2, 3, 1, 3, 1, 
  [ 0, 23, "Wi" ], 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 84
[ ,, [ 6, 7 ], [ 6, 15 ], [ 7, 168 ], [ 6, 31 ], 3, [ 0, 40, "Q" ], 3, 
  [ 0, 37, "B2" ], [ 0, 36, "GB2" ], 1, 2, 3, 1, 3, 3, 3, 1, [ 0, 28, "CZ" ], 
  3, 2, 3, 1, 3, 1, 3, 1, [ 0, 22, "Je" ], 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 85
[ ,, [ 6, 7 ], [ 6, 8 ], [ 6, 23 ], [ 7, 169 ], 3, 3, [ 0, 39, "Gu3" ], 3, 3, 
  1, [ 0, 34, "GG1" ], 3, 1, 3, 3, 3, 1, 3, 3, [ 0, 26, "GG" ], 3, 1, 3, 1, 
  3, 1, 3, 1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1 ],
#V   n = 86
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 24 ], 1, 2, 3, 3, 3, 2, 1, 3, 1, 2, 3, 3, 
  [ 0, 29, "Su" ], 1, 3, 1, 3, 2, 1, 3, 1, 3, 1, 3, 1, 2, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 87
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 31 ], [ 0, 42, "Al" ], 3, 3, 1, 2, 
  1, [ 0, 35, "GG1" ], 1, 2, 3, 2, 3, 1, 3, 1, 1, 2, 1, 3, 1, 3, 1, 1, 1, 
  [ 0, 22, "PT" ], 1, 1, 1, 1, [ 0, 20, "GG" ], 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 88
[ ,, [ 6, 7 ], [ 6, 15 ], [ 5, 4 ], [ 5, 5 ], 3, [ 0, 41, "GG" ], 3, 1, 2, 1, 
  3, 1, [ 0, 34, "GG1" ], 3, [ 0, 32, "PTX" ], 3, 1, 3, 1, 1, 2, 2, 3, 1, 3, 
  1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  [ 5, 43 ], [ 5, 43 ], 1, 1, 1, 1, 1 ],
#V   n = 89
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 27 ], 1, 2, 3, 3, 1, [ 0, 40, "S" ], 2, 3, 1, 
  3, 3, 3, 3, 1, 3, 1, 1, [ 0, 28, "X" ], [ 0, 25, "MoY" ], 3, 1, 3, 1, 1, 1, 
  [ 0, 23, "Wi" ], 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 17, "L" ], 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, [ 0, 11, "PT" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, [ 0, 8, "Sh" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 90
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 28 ], [ 6, 45 ], [ 5, 6 ], 3, 3, 1, 3, 2, 3, 
  1, [ 0, 35, "GG1" ], 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 3, 1, 1, 1, 3, 2, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 91
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 1, 2, 3, [ 0, 41, "GG" ], 1, 3, [ 0, 38, "GB2" ],
  3, 1, 3, [ 0, 33, "GG" ], 3, 1, 1, 1, 1, 1, 3, 3, [ 0, 25, "GG" ], 1, 3, 1, 
  1, 1, 3, [ 0, 22, "PWK" ], 2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, [ 0, 14, "PT" ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, [ 0, 9, "Hg" ], 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 92
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 30 ], 1, [ 0, 45, "SS" ], 2, 3, 1, 3, 3, 2, 1, 
  3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 3, 1, 1, 1, 3, 3, 2, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 45 ], [ 5, 45 ], [ 5, 45 ], 
  1, 1, 1, 1 ],
#V   n = 93
[ ,, [ 6, 7 ], 1, [ 6, 31 ], [ 6, 45 ], 3, [ 0, 44, "Al" ], 3, 2, 3, 3, 
  [ 0, 38, "GG1" ], 1, 3, 3, 3, 1, 1, 1, 1, 1, 2, 2, 3, 1, 3, 1, 1, 1, 3, 3, 
  [ 0, 22, "PT" ], 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 2, 1, 1, 3, 1, 
  1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 94
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 1, 3, 3, 3, 2, 3, 1, 3, 1, 3, 3, 3, 1, 1, 1, 1, 
  1, 2, [ 0, 28, "GG" ], 3, 1, 3, 1, 1, 1, 3, 1, 3, 1, 2, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, [ 0, 15, "Ch" ], 1, 1, 3, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1 ],
#V   n = 95
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 1, 2, 2, 2, [ 0, 42, "Gu3" ], 3, 1, 
  [ 0, 39, "GG1" ], 1, 2, 2, [ 0, 33, "GG" ], 1, 1, 1, 1, 1, [ 0, 31, "GG" ], 
  3, [ 0, 27, "GG" ], 1, 2, 1, 1, 1, 3, 1, [ 0, 23, "Ch" ], 1, 
  [ 0, 21, "Ch" ], 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 
  [ 0, 14, "To4" ], 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2 ],
#V   n = 96
[ ,, [ 6, 7 ], [ 6, 15 ], [ 5, 4 ], [ 5, 5 ], [ 5, 6 ], [ 0, 46, "vT1" ], 
  [ 5, 8 ], 3, 2, 1, 3, 1, [ 0, 38, "GG1" ], [ 0, 36, "We" ], 3, 1, 1, 1, 1, 
  1, 3, 3, 3, 1, [ 0, 26, "Wz" ], [ 5, 24 ], [ 5, 24 ], [ 5, 24 ], 3, 1, 3, 
  1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 3, 1, 3, 
  [ 5, 33 ], 1, 1, [ 5, 36 ], 1, 1, 1, 3, 1, 1, 1, 1, 3, [ 5, 41 ], 
  [ 5, 41 ], [ 5, 41 ], 1, 1, [ 0, 8, "Sh" ], [ 5, 40 ], [ 5, 41 ], 
  [ 5, 42 ], 1, 1, 1, 1, [ 5, 47 ], [ 5, 47 ], [ 5, 47 ], [ 5, 47 ], 
  [ 5, 47 ], [ 5, 47 ], [ 5, 47 ] ],
#V   n = 97
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 1, 3, 3, 2, 3, [ 0, 42, "GG" ], 1, 3, 1, 3, 3, 
  3, 1, 1, 1, 1, 1, 3, 3, 3, 2, 3, 1, 2, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 98
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 20 ], 1, 1, 2, 2, 1, 3, 1, 3, 1, 
  [ 0, 39, "GG1" ], 3, [ 0, 35, "GG" ], 1, 1, 2, 1, 1, 3, [ 0, 29, "GG" ], 3, 
  [ 0, 27, "GG" ], 3, 1, [ 0, 25, "GG" ], 1, 3, 1, 3, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, [ 5, 36 ], 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1 ],
#V   n = 99
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 21 ], 1, 1, [ 0, 48, "DH" ], [ 0, 46, "GB" ], 
  1, [ 0, 43, "GB" ], 1, 3, 1, 3, 3, 3, 1, 1, 2, 1, 1, 3, 3, 3, 3, 3, 1, 3, 
  1, 3, 1, 3, 1, [ 0, 24, "To" ], 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 11, "Ro" ], 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 100
[ ,, [ 6, 7 ], [ 6, 15 ], [ 7, 200 ], [ 7, 198 ], 1, 3, 3, 1, 3, 1, 
  [ 0, 41, "GG1" ], 1, 3, [ 0, 37, "Ch" ], 3, 1, 1, [ 0, 34, "CZ" ], 1, 1, 3, 
  3, 3, 3, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 2, 1, [ 0, 21, "Ch" ], 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, [ 5, 36 ], 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 49 ], 
  1, 1, 1, 1, 1, 1 ],
#V   n = 101
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 23 ], [ 7, 201 ], [ 7, 199 ], 3, 2, 1, 3, 1, 
  3, 1, 3, 3, 3, 1, 1, 3, 1, 1, 3, [ 0, 31, "GG" ], 2, 3, 2, 1, 3, 1, 3, 1, 
  3, 1, 3, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 
  1, 1, [ 0, 13, "Ro" ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 102
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 24 ], 1, 3, 3, [ 5, 8 ], 1, 2, 1, 3, 1, 3, 3, 
  3, 1, 1, 3, 1, 1, 3, 3, [ 0, 30, "GG1" ], 3, [ 0, 28, "GG1" ], 2, 3, 1, 
  [ 0, 25, "GG" ], [ 5, 24 ], 3, 1, 3, 1, [ 0, 24, "QC" ], 1, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1 ],
#V   n = 103
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 1, 2, 3, 3, 1, [ 0, 46, "GG" ], 1, 
  [ 0, 43, "GG1" ], 1, [ 0, 41, "GG1" ], 2, 1, 2, 1, 2, 1, 1, 3, 3, 3, 1, 3, 
  2, 3, 1, 3, 2, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  [ 0, 19, "L" ], 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 104
[ ,, [ 6, 7 ], [ 6, 15 ], [ 5, 4 ], 1, 2, 3, [ 5, 8 ], 1, 3, 1, 3, 1, 3, 
  [ 0, 40, "We" ], 1, 2, 1, [ 0, 36, "We" ], 1, 1, 3, 3, 1, 1, 1, 2, 1, 2, 3, 
  2, 3, 1, 3, 1, 3, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 2, 1, 1, 
  2, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 105
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 27 ], [ 6, 32 ], [ 0, 52, "SS" ], 
  [ 0, 49, "HP" ], 1, 1, 2, 1, 3, 1, 3, 3, 1, [ 0, 38, "GG1" ], 1, 3, 1, 1, 
  [ 0, 33, "GG" ], 3, 1, 1, 1, 2, 1, 2, 3, [ 0, 26, "Wz" ], 3, 1, 3, 1, 3, 1, 
  [ 0, 24, "QC" ], 1, 1, 1, [ 0, 21, "X" ], 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 2, 
  1, 1, [ 0, 15, "Ro" ], 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 106
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 28 ], [ 6, 32 ], 3, 3, [ 5, 8 ], 1, 
  [ 0, 48, "GG" ], 2, 3, 1, [ 0, 43, "GG1" ], 3, 1, 3, 1, 3, 1, 1, 3, 3, 1, 
  1, 1, 2, 1, 2, 1, 3, 1, 1, 3, 1, 3, 1, 3, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 2, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 107
[ ,, [ 6, 7 ], [ 6, 15 ], [ 7, 215 ], [ 7, 213 ], 3, 3, 2, 1, 3, 2, 3, 1, 3, 
  3, 1, 1, 1, 2, 1, 1, 3, 3, 1, 1, 1, 2, 1, 2, 1, 2, 1, 1, 3, 1, 3, 1, 3, 1, 
  [ 0, 23, "Ch" ], 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, [ 0, 19, "L" ], 1, 1, 
  3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 108
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 30 ], [ 7, 216 ], [ 7, 214 ], 2, 
  [ 0, 50, "GB" ], 1, 3, [ 0, 46, "GB" ], 3, 1, 3, [ 0, 41, "Ch" ], 1, 1, 1, 
  2, 1, 1, 3, [ 0, 33, "Ch" ], 1, 1, 1, [ 0, 32, "B2x" ], 1, [ 0, 30, "B2x" ],
  1, [ 0, 28, "B2x" ], 1, 1, 1, 2, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1 ],
#V   n = 109
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], [ 7, 217 ], [ 0, 52, "DH" ], 
  3, 2, 3, 3, [ 0, 45, "GG1" ], 1, 3, 3, 1, 1, 1, 2, 1, 1, [ 0, 35, "GG" ], 
  3, 1, 1, 1, 3, 1, 3, 1, 3, 1, 1, 1, 2, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1 ],
#V   n = 110
[ ,, [ 6, 7 ], [ 6, 15 ], 3, [ 7, 220 ], [ 7, 218 ], 3, 2, [ 0, 49, "GB" ], 
  3, 2, 3, 1, 3, 3, 1, 1, 1, [ 0, 40, "Pi" ], 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, [ 0, 26, "Wz" ], 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1 ],
#V   n = 111
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 3, [ 7, 221 ], 2, [ 0, 52, "GG" ], 3, 3, 
  [ 0, 48, "GG" ], 3, 2, 3, 2, 1, 2, 1, 3, 1, 2, 3, 2, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 112
[ ,, [ 6, 7 ], [ 6, 15 ], [ 5, 4 ], [ 5, 5 ], 3, [ 0, 54, "vT1" ], 3, 3, 2, 
  3, 3, [ 0, 45, "GG1" ], 3, [ 0, 44, "We" ], 1, 2, 1, 3, 1, 2, 3, 
  [ 0, 36, "We" ], 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 3, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], 1, 1 
 ],
#V   n = 113
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 27 ], 1, 3, 3, 3, 2, [ 0, 50, "GG" ], 3, 
  [ 0, 47, "GG1" ], 3, 3, 3, 1, [ 0, 42, "GG1" ], 1, 3, 1, [ 0, 38, "GG1" ], 
  3, 3, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 114
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 28 ], 1, 1, 2, [ 0, 53, "GG1" ], 
  [ 0, 52, "Q" ], 3, 3, 3, 3, [ 0, 45, "GG1" ], 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 
  2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1 ],
#V   n = 115
[ ,, [ 6, 7 ], [ 6, 15 ], [ 7, 231 ], [ 7, 229 ], 1, [ 0, 56, "DH" ], 3, 3, 
  2, 2, 3, 3, 3, 3, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 116
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 30 ], [ 7, 232 ], [ 7, 230 ], 3, 3, 2, 
  [ 0, 52, "GG" ], [ 0, 50, "GG1" ], 3, 2, 3, [ 0, 45, "Ch" ], 1, 1, 1, 2, 1, 
  2, 1, 2, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 117
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 7, 233 ], [ 7, 233 ], 3, 
  [ 0, 55, "GB" ], [ 0, 54, "Q" ], 3, 3, 3, [ 0, 48, "GG1" ], 3, 3, 1, 1, 1, 
  [ 0, 43, "X" ], 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 1, 1, 1, 1, 1, 
  [ 0, 32, "SW" ], 2, 1, 1, 1, 1, [ 0, 26, "SW" ], 1, 1, 1, 1, 1, 1, 
  [ 0, 24, "SW" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 118
[ ,, [ 6, 7 ], [ 6, 15 ], 3, [ 7, 236 ], [ 7, 234 ], 3, 3, 3, 2, 2, 1, 3, 1, 
  3, 2, 1, 1, 3, 1, [ 0, 42, "GG1" ], 1, [ 0, 40, "GG1" ], 1, 
  [ 0, 38, "GG1" ], 1, [ 0, 36, "GG1" ], 2, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 119
[ ,, [ 6, 7 ], [ 6, 15 ], 3, 3, [ 7, 237 ], 3, 3, 2, [ 0, 54, "GG" ], 
  [ 0, 52, "GG1" ], 1, 2, 1, 2, 2, 1, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 2, 1, 1, 
  1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, [ 0, 23, "Ch" ], 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 120
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 30 ], 3, 3, [ 0, 57, "Al" ], 3, 
  [ 0, 56, "Q" ], 3, 3, 1, 2, 2, [ 0, 48, "We" ], [ 0, 46, "B2" ], 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, [ 0, 32, "SW" ], 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 121
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 48 ], 3, 3, 3, 3, 2, 2, 1, 2, 2, 3, 
  3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 122
[ ,, [ 6, 7 ], [ 6, 15 ], 3, [ 7, 244 ], 3, 3, 3, 3, [ 0, 56, "GG" ], 
  [ 0, 54, "B2" ], 1, [ 0, 52, "B2" ], 2, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 123
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 3, [ 7, 245 ], 2, 1, 3, 3, 3, 1, 3, 2, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1 ],
#V   n = 124
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 3, 2, 1, [ 0, 57, "GG" ], 3, 1, 1, 1, 
  2, [ 0, 49, "Ch" ], 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 125
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 1, 1, 2, 1, 3, 3, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 126
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 1, 1, 2, 1, 3, 3, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 127
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 1, 1, 2, 1, [ 0, 59, "GG" ], 3, 1, 1, 1, 
  [ 0, 55, "BCH" ], 2, 1, 1, 1, 1, 1, [ 0, 47, "BCH" ], 1, 1, 1, 1, 1, 1, 
  [ 0, 43, "BCH" ], [ 0, 37, "MoY" ], 1, 1, 1, 1, 1, [ 0, 35, "SW" ], 3, 1, 
  1, 1, 1, 1, [ 0, 31, "BCH" ], 1, 1, 1, 1, 1, 1, [ 0, 27, "BCH" ], 1, 1, 1, 
  1, 1, 1, [ 0, 23, "BCH" ], 1, 1, 1, 1, 1, 1, [ 0, 21, "BCH" ], 1, 1, 1, 1, 
  1, 1, [ 0, 19, "BCH" ], 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 2 ],
#V   n = 128
[ ,, [ 6, 7 ], [ 6, 15 ], [ 5, 4 ], [ 5, 5 ], [ 5, 6 ], [ 5, 7 ], 1, 3, 3, 1, 
  1, 1, 3, [ 0, 52, "We" ], [ 5, 16 ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 
  1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 2, [ 5, 36 ], 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, [ 0, 17, "Gp" ], 
  1, [ 5, 46 ], 1, 1, 1, 1, [ 0, 15, "Gp" ], 1, 1, 1, 1, 1, 1, 
  [ 0, 13, "Gp" ], 1, 1, 1, 1, 1, 1, [ 0, 11, "Gp" ], 1, 1, 1, 1, 1, 1, 
  [ 0, 9, "Gp" ], [ 5, 55 ], [ 5, 56 ], [ 5, 57 ], 1, 1, 1, [ 0, 7, "Gp" ], 
  1, 1, 1, 1, 1, 1, [ 0, 5, "Gp" ], [ 5, 63 ], [ 5, 63 ], [ 5, 63 ], 
  [ 5, 63 ], [ 5, 63 ], [ 5, 63 ] ],
#V   n = 129
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 27 ], 3, 3, 3, 1, 3, [ 0, 57, "GG" ], 1, 1, 1, 
  3, 3, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1 ],
#V   n = 130
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 28 ], [ 7, 257 ], 3, 3, [ 5, 8 ], 3, 3, 1, 1, 
  1, 3, 3, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 3, 3, 1, [ 5, 46 ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 3, 1, [ 5, 63 ], [ 5, 64 ], 1, 1, 1, 1, 1 ],
#V   n = 131
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 6 ], 3, 3, 3, 1, 3, 3, 1, 1, 1, 3, 3, 2, 1, 1, 
  2, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 2, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 3, [ 0, 27, "Su" ], 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 3, [ 0, 19, "Su" ], 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 132
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 30 ], [ 6, 6 ], 3, 3, 1, [ 0, 61, "GG" ], 
  [ 0, 59, "GuB" ], 1, 1, 1, 3, [ 0, 53, "XB" ], [ 0, 52, "BY" ], 1, 1, 
  [ 0, 49, "XB" ], 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, [ 0, 37, "XB" ], 1, 1, 1, 
  3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, [ 5, 65 ], 1, 1, 1, 1, 1, 1 ],
#V   n = 133
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 7 ], [ 6, 40 ], 3, 1, 3, 3, 1, 1, 
  1, 3, 3, 3, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 134
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], 1, 1, 2, 1, 3, 3, 1, 1, 1, 3, 3, 3, 1, 
  1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 2, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 3, 
  1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 135
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 10 ], [ 6, 31 ], 1, [ 0, 65, "Be" ], 1, 
  [ 0, 63, "GG" ], 3, 2, 1, 1, [ 0, 57, "GG" ], 2, 3, 1, 1, 2, 1, 
  [ 0, 49, "GG" ], 1, 1, 1, 1, 1, 1, [ 0, 45, "GG" ], 1, 1, 2, 1, 1, 1, 3, 1, 
  1, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, [ 0, 29, "M" ], 3, 1, 1, 
  [ 0, 27, "Su" ], 1, 1, [ 0, 25, "M" ], 1, 1, 1, 1, 1, 1, [ 0, 23, "M" ], 1, 
  1, 1, 1, 1, 1, [ 0, 21, "M" ], 3, 1, 1, [ 0, 19, "Su" ], 1, 1, 
  [ 0, 17, "M" ], 3, 1, 1, 1, 1, 1, [ 0, 15, "M" ], 3, 1, 1, 1, 1, 1, 
  [ 0, 13, "M" ], 3, 1, 1, 1, 1, 1, [ 0, 11, "M" ], 3, 1, 1, 1, 1, 1, 
  [ 0, 9, "M" ], 3, 1, 1, 1, 1, 1, [ 0, 7, "Su" ], 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 136
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 30 ], [ 6, 32 ], [ 6, 8 ], 3, [ 5, 8 ], 3, 3, 
  [ 7, 256 ], 1, 1, 3, [ 0, 56, "BZ" ], 3, 1, 1, [ 0, 52, "BZ" ], 1, 3, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, [ 0, 40, "BZ" ], 1, 1, 1, 3, 1, 1, [ 0, 34, "BZ" ], 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 3, 3, 1, 1, 3, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 
  1, 1, 1, 1, 1, 1, [ 5, 67 ], [ 5, 67 ], [ 5, 67 ], [ 5, 67 ], 1, 1, 1 ],
#V   n = 137
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], 2, 3, 1, 3, [ 0, 61, "GG" ], 
  1, 1, 1, 3, 3, 2, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 
  1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 138
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 32 ], [ 0, 68, "vT3" ], 3, 
  [ 5, 8 ], 3, 3, 2, 1, 1, 3, 3, [ 0, 54, "GG" ], 1, 1, 3, 1, 3, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 3, 
  1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 3, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1 ],
#V   n = 139
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 31 ], 3, [ 0, 67, "GG" ], 1, 3, 3, 
  [ 0, 61, "GG" ], 1, 1, [ 0, 59, "GG" ], 3, 3, 1, 1, 3, 1, [ 0, 51, "GG" ], 
  1, 1, 1, 1, 1, 1, [ 0, 47, "GG" ], 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  [ 0, 35, "XB" ], 2, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 3, 1, 1, 3, 1, 1, 
  [ 0, 27, "M" ], 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 3, 1, 1, 
  [ 0, 19, "M" ], 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 140
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], 3, 3, [ 5, 8 ], 3, 
  [ 0, 63, "GG" ], 3, 2, 1, 3, 3, [ 7, 250 ], 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, [ 0, 34, "BY" ], 1, 1, 3, 
  [ 0, 32, "BY" ], 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 69 ], 1, 1, 1, 1, 1, 1 ],
#V   n = 141
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 32 ], 2, 3, 2, 3, 3, 3, 2, 1, 3, 3, 
  [ 7, 253 ], 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 2, 3, 1, 1, 
  3, 3, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 2, 3, 1, 1, 3, 1, 1, 1, 1, 1, 2, 
  3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 
  1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 3, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 142
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 31 ], [ 0, 70, "vT3" ], 3, 2, 
  [ 0, 65, "GG" ], 3, 1, 2, 1, 3, 3, 1, [ 7, 254 ], 2, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 3, 1, 1, [ 0, 37, "XB" ], 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 
  1, 1, 1, 3, 1, 1, [ 0, 29, "Su" ], 3, 1, 1, 3, 1, 1, 1, 1, 1, 
  [ 0, 25, "Ka" ], 3, 1, 1, 1, 1, 1, [ 0, 23, "Ka" ], 3, 1, 1, 
  [ 0, 21, "Su" ], 3, 1, 1, 3, 1, 1, 1, 1, 1, [ 0, 17, "Ka" ], 3, 1, 1, 1, 1, 
  1, [ 0, 15, "Ka" ], 3, 1, 1, 1, 1, 1, [ 0, 13, "Ka" ], 3, 1, 1, 1, 1, 1, 
  [ 0, 11, "Ka" ], 3, 1, 1, 1, 1, 1, [ 0, 9, "Ka" ], 3, 1, 1, 1, 1, 1, 
  [ 0, 7, "Su" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 143
[ ,, [ 6, 7 ], [ 6, 15 ], 1, [ 6, 32 ], 3, [ 0, 69, "GG" ], 2, 3, 3, 1, 
  [ 0, 63, "GG" ], 1, [ 0, 61, "GG" ], 3, 1, 1, [ 7, 255 ], 2, 1, 
  [ 0, 53, "GG" ], 1, 2, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 
  1, 1, 3, 1, 1, 1, 2, 1, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 
  1, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 
  3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 144
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 30 ], [ 5, 5 ], 2, 3, [ 0, 68, "Gu" ], 3, 3, 
  1, 3, 1, 3, [ 0, 57, "XB" ], 1, 1, 1, [ 7, 256 ], 1, 3, 1, [ 0, 49, "XB" ], 
  1, 1, 1, 1, 3, 1, 1, [ 0, 41, "XB" ], 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 1, 2, 
  1, 1, 1, 2, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  3, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 71 ], [ 5, 71 ], [ 5, 71 ], [ 5, 71 ], 
  1, 1, 1 ],
#V   n = 145
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, [ 0, 72, "HvT" ], 3, 3, 3, 3, 1, 3, 
  1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 3, 
  [ 0, 38, "BY" ], 1, 1, 3, [ 0, 36, "BY" ], 1, 1, 1, [ 0, 34, "BY" ], 1, 1, 
  1, [ 0, 32, "BY" ], 1, 3, 1, 1, 3, 1, 1, 2, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 3, 3, 1, 1, 3, 1, 1, 2, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 146
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 21 ], [ 6, 73 ], 3, [ 0, 71, "GG" ], 3, 
  [ 0, 67, "GG" ], 2, 1, 3, 1, [ 0, 63, "GG" ], 3, 1, 1, 1, 1, 1, 
  [ 0, 55, "GG" ], 1, 3, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 3, 1, 
  1, 1, 3, 1, [ 5, 36 ], 1, 3, 1, 3, 1, 1, 3, 1, 1, [ 0, 29, "Ka" ], 3, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 3, 1, 1, [ 0, 21, "Ka" ], 3, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 147
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 31 ], 3, 3, 2, 3, [ 0, 66, "Gu3" ], 
  1, 3, 1, 3, [ 0, 59, "XB" ], 2, 1, 1, 1, 1, 3, 1, [ 0, 51, "XB" ], 1, 1, 1, 
  1, 3, 1, 1, [ 0, 43, "XB" ], 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 3, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 148
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], 3, 3, 2, 3, 3, [ 5, 11 ], 3, 
  1, 3, 3, [ 0, 57, "GG" ], 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 3, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 2, 3, 1, 1, 3, 3, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 3, 3, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 
  1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1 ],
#V   n = 149
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 24 ], 1, [ 0, 73, "Be" ], 3, 2, 2, 2, 2, 3, 1, 
  3, 3, 3, 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 2, 
  2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 3, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, [ 0, 25, "Su" ], 3, 1, 1, [ 0, 23, "Su" ], 3, 1, 1, 3, 3, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, [ 0, 17, "Su" ], 3, 1, 1, 1, 1, 1, 
  [ 0, 15, "Su" ], 3, 1, 1, 1, 1, 1, [ 0, 13, "Su" ], 3, 1, 1, 1, 1, 1, 
  [ 0, 11, "Su" ], 3, 1, 1, 1, 1, 1, 1, 3, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 150
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 31 ], 3, 3, [ 0, 72, "Gu3" ], 
  [ 0, 70, "Gu3" ], [ 0, 68, "Gu3" ], [ 0, 66, "BZ" ], 3, 1, 3, 3, 3, 1, 1, 
  1, 1, 3, 1, 3, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, [ 0, 39, "XB" ], 
  [ 0, 38, "BY" ], 1, 1, 1, [ 0, 36, "BY" ], 1, 1, 1, [ 0, 34, "BY" ], 1, 1, 
  1, [ 0, 32, "BY" ], 3, 1, 1, 3, [ 0, 30, "BZ" ], 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 3, 
  1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  1 ],
#V   n = 151
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], 3, 2, 3, 3, 3, 3, 
  [ 0, 65, "GG" ], 1, 3, 3, 3, 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 3, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 
  1, 1, 1, 1, 1, 1, [ 0, 27, "Su" ], 1, 1, 1, 1, 3, 3, 1, 1, 3, 1, 1, 1, 3, 
  3, 1, 1, 1, 1, 1, 1, [ 0, 19, "Su" ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 5, "Gu3" ], 1, 1, 1, 1, 1, 1, 1 
 ],
#V   n = 152
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, [ 0, 75, "Be" ], [ 0, 74, "Gu3" ], 3, 
  3, 3, 2, 3, 1, 3, 3, [ 0, 59, "GG" ], 1, 1, 2, 1, 3, 1, 3, 1, 1, 1, 1, 3, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 3, 1, 1, 2, 3, 1, 1, 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 3, [ 5, 75 ], [ 5, 75 ], [ 5, 75 ], 1, 1, 1, 1, 1 ],
#V   n = 153
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 28 ], [ 6, 48 ], 3, 3, 3, 2, 3, 
  [ 0, 68, "BZ" ], 3, 1, 3, 3, 3, 1, 1, [ 0, 57, "GG" ], 1, 3, 1, 3, 1, 1, 1, 
  1, [ 0, 49, "GG" ], 1, 1, 3, 1, 1, 1, 2, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 
  3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 
  3, 1, 1, [ 0, 23, "Su" ], 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1 ],
#V   n = 154
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 31 ], 3, 3, 3, [ 0, 72, "Gu3" ], 1, 
  3, 3, 1, 3, 3, 3, 1, 1, 3, 1, 3, 1, 3, 2, 1, 1, 1, 3, 1, 1, 3, 2, 1, 1, 2, 
  1, 1, 3, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 2, 
  1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 155
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], 3, [ 0, 75, "GG" ], 3, 3, 1, 
  2, [ 0, 67, "GG" ], 1, 3, 2, 3, 1, 1, 3, 1, 3, 1, 3, 2, 1, 1, 1, 3, 1, 1, 
  3, 2, 1, 1, [ 0, 42, "BY" ], 1, 1, 3, [ 0, 40, "BY" ], 1, 1, 1, 
  [ 0, 38, "BY" ], 1, 1, 1, [ 0, 36, "BY" ], 1, 1, 1, [ 0, 34, "BY" ], 1, 1, 
  1, 1, 1, 1, 1, 1, [ 0, 30, "BZ" ], 1, 1, 3, 1, 1, 1, 2, 3, 1, 1, 2, 3, 1, 
  1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 
  1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 156
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, [ 6, 64 ], 3, 3, 3, 1, 
  [ 0, 70, "PWK" ], 3, 1, [ 0, 65, "GG" ], [ 0, 62, "BZ" ], 3, 1, 1, 3, 1, 3, 
  1, [ 0, 53, "XB" ], [ 0, 52, "BY" ], 1, 1, 1, 3, 1, 1, [ 0, 45, "XB" ], 
  [ 0, 44, "BY" ], 1, 1, 3, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, [ 0, 27, "Su" ], 3, 1, 1, 
  [ 0, 25, "Su" ], 3, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, [ 0, 17, "Su" ], 3, 1, 1, 1, 1, 1, [ 0, 15, "Su" ], 3, 1, 1, 1, 
  1, 1, [ 0, 13, "Su" ], 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 157
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 31 ], [ 6, 64 ], 3, 2, 3, 1, 3, 3, 
  1, 3, 3, 2, 1, 1, [ 0, 59, "GG" ], 1, 3, 1, 3, 3, 1, 1, 1, 3, 1, 1, 3, 3, 
  2, 1, 3, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 158
[ ,, [ 6, 7 ], [ 6, 15 ], 1, [ 6, 32 ], [ 6, 64 ], 3, 2, 3, 1, 3, 3, 1, 3, 1, 
  2, 1, 1, 3, 1, [ 0, 57, "GG" ], 1, 3, 3, 1, 1, 2, 3, 1, 1, 3, 3, 
  [ 7, 246 ], 2, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 
  2, 1, 1, 1, 1, 3, 1, 1, 1, 2, 1, 1, 3, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 1, [ 0, 21, "Ka" ], 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 159
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 1, 2, 2, 2, 2, 1, 3, [ 0, 69, "GG" ], 1, 3, 1, 
  2, 1, 1, 3, 1, 3, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, [ 7, 247 ], [ 7, 247 ], 
  2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 
  2, 1, 1, 1, 2, 1, 1, 3, 2, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 
  3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2 ],
#V   n = 160
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 30 ], [ 5, 5 ], [ 5, 6 ], [ 0, 78, "DH" ], 
  [ 0, 76, "Gu3" ], [ 0, 74, "Gu3" ], 1, 2, 3, 1, [ 0, 67, "GG" ], 2, 
  [ 0, 64, "BZ" ], 2, 1, 3, 1, 3, 1, [ 0, 56, "BZ" ], 3, 1, 1, 
  [ 0, 52, "BZ" ], 3, 1, 1, [ 0, 48, "BZ" ], 2, 3, [ 7, 248 ], [ 7, 248 ], 2, 
  1, 1, [ 0, 42, "BY" ], 1, 1, 1, [ 0, 40, "BY" ], 1, 1, 1, [ 0, 38, "BY" ], 
  1, 1, 1, [ 0, 36, "BY" ], 1, 1, 1, [ 0, 34, "BY" ], 1, 1, 1, 1, 
  [ 0, 32, "BZ" ], 1, 1, 1, [ 0, 30, "BZ" ], 1, 1, 3, [ 0, 28, "BZ" ], 1, 1, 
  3, 1, 1, 1, 3, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  [ 5, 79 ], [ 5, 79 ], [ 5, 79 ], [ 5, 79 ], [ 5, 79 ], [ 5, 79 ], 
  [ 5, 79 ], [ 5, 79 ] ],
#V   n = 161
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 3, 3, 3, 3, 1, [ 0, 72, "Gu3" ], 3, 
  1, 3, 2, 3, 2, 1, 3, 1, 3, 1, 3, 2, 1, 1, 3, 3, 1, 1, 3, [ 7, 253 ], 2, 3, 
  [ 7, 249 ], [ 7, 249 ], 2, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 1, 
  [ 0, 25, "Ka" ], 1, 1, 1, 1, [ 0, 23, "Ka" ], 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 162
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 21 ], 1, 1, 2, [ 0, 77, "Gu3" ], 3, [ 5, 10 ], 
  3, [ 0, 71, "GG" ], 1, 3, [ 0, 66, "BZ" ], 3, [ 0, 62, "BZ" ], 2, 3, 1, 
  [ 0, 59, "GG" ], 1, 3, 2, 1, 1, 3, 3, 1, 1, 3, 2, [ 7, 254 ], 2, 3, 
  [ 7, 250 ], [ 7, 250 ], 2, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 
  3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 2, 3, 1, 1, 
  1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 163
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 37 ], 1, [ 0, 80, "DH" ], 3, 3, 2, 
  3, 3, 1, 3, 3, 3, 3, 2, 3, 1, 3, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 
  [ 7, 255 ], [ 7, 255 ], 2, 3, [ 7, 251 ], [ 7, 251 ], 2, 1, 1, 1, 3, 1, 1, 
  1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, [ 0, 17, "Su" ], 3, 1, 1, 1, 1, 1, [ 0, 15, "Su" ], 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 
  1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 164
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 38 ], [ 6, 82 ], 3, 3, 1, 2, 3, 3, 
  1, [ 0, 69, "GG" ], 2, 3, 1, 2, [ 0, 61, "XB" ], 1, 3, 1, [ 0, 57, "XB" ], 
  [ 0, 56, "BY" ], 1, 1, [ 0, 53, "XB" ], [ 0, 52, "BY" ], 1, 1, 
  [ 0, 49, "XB" ], [ 0, 48, "BY" ], 1, [ 7, 256 ], [ 7, 256 ], 3, 3, 
  [ 7, 252 ], [ 7, 252 ], 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 
  1, 1, 1, 3, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, [ 5, 81 ], 1, 1, 1, 1, 1, 
  1, 1 ],
#V   n = 165
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 24 ], [ 6, 32 ], [ 6, 63 ], 3, 3, 1, 
  [ 0, 75, "Gu3" ], 2, 3, 1, 3, [ 0, 68, "BZ" ], 2, 1, 2, 3, 1, 3, 1, 3, 3, 
  1, 1, 3, 3, 1, 1, 3, 3, 1, 1, [ 7, 257 ], [ 7, 255 ], 3, 3, [ 7, 253 ], 
  [ 7, 253 ], 2, 1, [ 0, 42, "BZ" ], 1, 1, 1, [ 0, 40, "BZ" ], 1, 1, 1, 
  [ 0, 38, "BZ" ], 1, 1, 1, [ 0, 36, "BZ" ], 1, 1, 1, 1, [ 0, 33, "BZ" ], 1, 
  1, 1, [ 0, 32, "BZ" ], 1, 1, 1, [ 0, 30, "BZ" ], 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1 ],
#V   n = 166
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 47 ], [ 6, 64 ], 3, 2, [ 5, 9 ], 3, 
  2, 3, 1, 3, 3, 2, 1, 2, 3, 1, 3, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 2, 
  3, 3, 3, 3, [ 7, 254 ], [ 7, 254 ], 2, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1 ],
#V   n = 167
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 48 ], 2, 3, [ 0, 80, "AEB" ], 2, 3, 
  2, 3, 1, [ 0, 71, "GG" ], 2, 2, 1, 2, 2, 1, 3, 1, 2, 3, 1, 1, 2, 3, 1, 1, 
  2, 3, 1, 1, 2, 3, 1, 3, 3, 3, [ 7, 255 ], [ 7, 255 ], 2, 2, 1, 1, 3, 1, 1, 
  1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, [ 0, 29, "Ka" ], 
  1, 1, 1, 1, 1, [ 0, 27, "Ka" ], 1, 1, 1, 1, [ 0, 25, "Ka" ], 1, 1, 1, 1, 
  [ 0, 23, "Ka" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, [ 0, 9, "Hg" ], 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 168
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 2, [ 0, 81, "GG" ], 3, 2, 3, 
  [ 0, 76, "Gu3" ], 3, 1, 3, [ 0, 70, "BZ" ], [ 0, 68, "GG" ], 1, 
  [ 0, 66, "GG" ], [ 0, 64, "BZ" ], 1, 2, 1, [ 0, 60, "BZ" ], 3, 1, 1, 
  [ 0, 56, "BZ" ], 3, 1, 1, [ 0, 52, "BZ" ], 3, 1, 1, [ 0, 48, "BZ" ], 3, 1, 
  1, 3, 3, 3, [ 7, 256 ], [ 7, 256 ], 2, 2, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 
  1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, [ 5, 83 ], 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 169
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 28 ], [ 6, 32 ], [ 6, 64 ], 3, 3, 2, 3, 3, 1, 
  2, 3, 3, 3, 1, 3, 3, 1, 2, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 1, 1, 
  2, 1, 3, 3, 3, [ 7, 257 ], [ 7, 255 ], 2, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 
  1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1 ],
#V   n = 170
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 44 ], [ 6, 64 ], 3, 3, 
  [ 0, 80, "Gu" ], 3, 3, 1, 2, 3, 2, 3, 1, 2, 3, 1, [ 0, 63, "GG" ], 1, 3, 2, 
  1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 2, 1, 1, 3, 3, 3, 3, [ 7, 256 ], 1, 
  3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 17, "Su" ], 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 171
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 45 ], [ 6, 43 ], [ 0, 83, "GG" ], 
  [ 0, 81, "Gu3" ], 3, 3, 3, 1, [ 0, 74, "BY" ], 3, [ 0, 72, "BZ" ], 3, 1, 
  [ 0, 68, "GG" ], 3, 1, 3, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 
  [ 0, 46, "BZ" ], 1, 1, 1, 3, 3, 3, 3, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 172
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 5, 5 ], [ 6, 63 ], 3, 3, 3, 1, 3, 1, 
  3, 1, 3, 3, 1, 3, [ 0, 65, "XB" ], 1, 3, 1, [ 0, 61, "XB" ], 
  [ 0, 60, "BY" ], 1, 1, [ 0, 57, "XB" ], [ 0, 56, "BY" ], 1, 1, 
  [ 0, 53, "XB" ], [ 0, 52, "BY" ], 1, 1, [ 0, 49, "XB" ], [ 0, 48, "BY" ], 
  1, 3, 1, 2, 1, 1, 3, 3, 3, 1, [ 0, 41, "XB" ], 1, 1, 1, [ 0, 39, "XB" ], 1, 
  1, 1, [ 0, 37, "XB" ], 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 173
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 47 ], [ 6, 64 ], 3, 3, 3, 1, 2, 1, 
  2, 1, 2, [ 0, 69, "GG" ], 1, 3, 3, 1, 3, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 
  1, 1, 3, 3, 1, 3, 1, 2, 1, 1, 1, 3, 3, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  1, 1, [ 0, 35, "XB" ], 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, [ 0, 27, "Ka" ], 1, 1, 1, 1, [ 0, 25, "Ka" ], 1, 1, 1, 1, 
  [ 0, 23, "Ka" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 174
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 48 ], [ 6, 47 ], 3, 3, 3, 1, 
  [ 0, 78, "BY" ], 1, [ 0, 76, "BY" ], 1, [ 0, 74, "BZ" ], 3, 1, 3, 3, 1, 3, 
  1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 2, [ 0, 46, "BZ" ], 1, 
  1, 1, 1, 3, 2, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  [ 0, 34, "BY" ], 1, 1, 1, 1, [ 0, 32, "BY" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 175
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], [ 6, 63 ], 2, 3, 3, 1, 3, 1, 
  3, 1, 3, 3, 1, 3, 2, 1, 3, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 
  1, 2, 3, 1, 2, 1, 1, 1, 2, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1 ],
#V   n = 176
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 5, 5 ], [ 5, 6 ], [ 6, 48 ], 2, 2, 1, 
  2, 1, 2, 1, 2, 3, 1, 3, [ 0, 68, "BZ" ], 2, 3, 1, [ 0, 64, "BZ" ], 3, 1, 1, 
  [ 0, 60, "BZ" ], 3, 1, 1, [ 0, 56, "BZ" ], 3, 1, 1, [ 0, 52, "BZ" ], 3, 1, 
  1, [ 0, 48, "BZ" ], 3, 1, 2, 1, 1, 1, [ 0, 44, "BZ" ], 3, 1, 1, 1, 3, 1, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, [ 5, 87 ], [ 5, 87 ], [ 5, 87 ], 1, 1, 1, 1, 1 ],
#V   n = 177
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 28 ], 1, [ 6, 50 ], [ 6, 49 ], 2, 
  [ 0, 82, "BY" ], 1, [ 0, 80, "BY" ], 1, [ 0, 78, "BY" ], 1, [ 0, 76, "BZ" ],
  3, 1, [ 0, 69, "GG" ], 3, 2, 3, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 
  2, 1, 1, 3, 3, 1, [ 0, 46, "BZ" ], 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 
  1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 178
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 52 ], [ 6, 82 ], 2, 2, 3, 1, 3, 1, 
  3, 1, 3, 1, 2, 3, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 
  1, 3, 3, 1, 3, 1, 2, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 2, 3, 1, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1 ],
#V   n = 179
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 53 ], [ 6, 83 ], [ 6, 51 ], 2, 2, 
  1, 2, 1, 2, 1, 2, 1, 2, 3, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 
  3, 2, 1, 1, 3, 2, 1, 3, 1, 2, 1, 3, 2, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 
  3, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, [ 0, 29, "Ka" ],
  1, 1, 1, 1, [ 0, 27, "Ka" ], 1, 1, 1, 1, [ 0, 25, "Ka" ], 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 180
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 5, 5 ], [ 6, 63 ], [ 5, 7 ], 
  [ 0, 87, "Gu3" ], [ 0, 84, "BY" ], 1, [ 0, 82, "BY" ], 1, [ 0, 80, "BY" ], 
  1, [ 0, 78, "BZ" ], 1, [ 0, 72, "BZ" ], 3, [ 0, 69, "XB" ], [ 0, 68, "BY" ],
  1, 1, [ 0, 65, "XB" ], [ 0, 64, "BY" ], 1, 1, [ 0, 61, "XB" ], 
  [ 0, 60, "BY" ], 1, 1, [ 0, 57, "XB" ], [ 0, 56, "BY" ], 1, 1, 
  [ 0, 53, "XB" ], [ 0, 52, "BY" ], 1, 1, [ 0, 49, "XB" ], [ 0, 48, "BY" ], 
  1, 3, 1, [ 0, 46, "BZ" ], 1, 3, [ 0, 44, "BY" ], 1, 1, 1, [ 0, 42, "BY" ], 
  1, 1, 1, [ 0, 40, "BY" ], 1, 1, 1, [ 0, 38, "BY" ], 3, 1, 1, 1, 
  [ 0, 36, "BY" ], 1, 1, 1, 1, [ 0, 34, "BY" ], 1, 1, 1, 1, [ 0, 32, "BY" ], 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 181
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 24 ], [ 6, 55 ], [ 6, 64 ], [ 6, 53 ], 3, 3, 
  1, 3, 1, 3, 1, 3, 1, 3, 3, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 
  3, 3, 1, 1, 3, 3, 1, 3, 1, 3, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 182
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 56 ], 1, 2, 3, 2, 1, 2, 1, 2, 1, 2, 
  1, 3, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 
  1, 1, 2, 3, 1, 2, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 183
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], [ 6, 63 ], [ 0, 90, "BZ" ], 
  3, [ 0, 86, "BY" ], 1, [ 0, 84, "BY" ], 1, [ 0, 82, "BY" ], 1, 
  [ 0, 80, "BZ" ], 2, 3, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 
  2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, [ 0, 46, "BZ" ], 3, 1, 1, 1, 3, 1, 1, 1, 
  3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 184
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, [ 5, 6 ], 3, 3, 3, 1, 3, 1, 3, 1, 3, 
  [ 0, 73, "XB" ], 3, 1, [ 0, 72, "BZ" ], 3, 1, 1, [ 0, 68, "BZ" ], 3, 1, 1, 
  [ 0, 64, "BZ" ], 3, 1, 1, [ 0, 60, "BZ" ], 3, 1, 1, [ 0, 56, "BZ" ], 3, 1, 
  1, [ 0, 52, "BZ" ], 3, 1, 1, [ 0, 48, "BY" ], 3, 1, 3, 1, 2, 1, 1, 2, 1, 1, 
  1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, [ 5, 91 ], [ 5, 91 ], [ 5, 91 ], 
  [ 5, 91 ], 1, 1, 1, 1 ],
#V   n = 185
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 59 ], 1, 2, 3, 2, 1, 2, 1, 2, 1, 2, 
  3, 3, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 
  1, 1, 3, 1, 1, 3, 1, 2, 1, 1, [ 0, 44, "BY" ], 1, 1, 1, [ 0, 42, "BY" ], 1, 
  1, 1, [ 0, 40, "BY" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, [ 0, 29, "Ka" ], 1, 1, 1, 1, [ 0, 27, "Ka" ], 1, 1, 
  1, 1, [ 0, 25, "Ka" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 186
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 60 ], [ 6, 90 ], [ 5, 7 ], 2, 
  [ 0, 88, "BY" ], 1, [ 0, 86, "BY" ], 1, [ 0, 84, "BY" ], 1, [ 0, 82, "BZ" ],
  3, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 
  1, 1, 3, 1, 1, 3, 1, [ 0, 46, "BZ" ], 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, [ 0, 36, "BY" ], 1, 1, 1, 1, [ 0, 34, "BY" ], 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1 ],
#V   n = 187
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, 2, 2, 3, 1, 3, 1, 3, 1, 3, 2, 1, 
  1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 188
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 62 ], 1, [ 0, 93, "Be" ], 2, 2, 1, 
  2, 1, 2, 1, 2, [ 0, 76, "BY" ], 1, 1, [ 0, 73, "XB" ], [ 0, 72, "BY" ], 1, 
  1, [ 0, 69, "XB" ], [ 0, 68, "BY" ], 1, 1, [ 0, 65, "XB" ], [ 0, 64, "BY" ],
  1, 1, [ 0, 61, "XB" ], [ 0, 60, "BY" ], 1, 1, [ 0, 57, "XB" ], 
  [ 0, 56, "BY" ], 1, 1, [ 0, 53, "XB" ], [ 0, 52, "BY" ], 1, 1, 
  [ 0, 49, "XB" ], 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 
  2, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 189
[ ,, [ 6, 7 ], [ 6, 15 ], 1, [ 6, 63 ], [ 6, 93 ], 3, [ 0, 92, "Gu3" ], 
  [ 0, 90, "Gu3" ], 1, [ 0, 88, "BY" ], 1, [ 0, 86, "BY" ], 1, 
  [ 0, 84, "BZ" ], 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 
  3, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 2, 
  1, 1, 1, 2, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 190
[ ,, [ 6, 7 ], [ 6, 15 ], 1, 1, 1, 3, 3, 3, 1, 3, 1, 3, 1, 3, 3, 1, 1, 3, 3, 
  1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 2, [ 0, 46, "BZ" ], 2, 1, 1, [ 0, 44, "BZ" ], 1, 1, 1, 
  [ 0, 42, "BZ" ], 1, 1, 1, [ 0, 40, "BZ" ], 2, 1, 1, 1, [ 0, 38, "BZ" ], 3, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, 1, 1, 1, 2, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 191
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, 2, 3, 3, 1, 3, 1, 2, 1, 2, 
  [ 0, 77, "XB" ], 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 
  3, 1, 1, 2, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 3, 2, 1, 1, 3, 1, 1, 1, 3, 1, 
  1, 1, 3, 2, 1, 1, 1, 3, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, [ 0, 29, "Ka" ], 1, 1, 1, 1, [ 0, 27, "Ka" ], 1, 1, 1, 1, 
  [ 0, 25, "Ka" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 21, "X" ], 
  1, 1, 1, 1, 1, 1, 1, [ 0, 19, "X" ], 1, 1, 1, [ 0, 17, "X" ], 1, 1, 1, 1, 
  1, 1, 1, [ 0, 15, "Su" ], 1, 1, 1, 1, 1, 1, 1, [ 0, 13, "X" ], 1, 1, 1, 1, 
  1, 1, 1, [ 0, 11, "X" ], 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2 ],
#V   n = 192
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 5, 5 ], [ 5, 6 ], [ 5, 7 ], 3, 2, 1, 
  3, 1, [ 0, 88, "BY" ], 1, [ 0, 86, "BZ" ], 3, 1, 1, [ 0, 76, "BZ" ], 3, 1, 
  1, [ 0, 72, "BZ" ], 3, 1, 1, [ 0, 68, "BZ" ], 3, 1, 1, [ 0, 64, "BZ" ], 3, 
  1, 1, [ 0, 60, "BZ" ], 3, 1, 1, [ 0, 56, "BZ" ], [ 0, 54, "PWK" ], 1, 1, 
  [ 0, 52, "BZ" ], 2, 1, 1, 1, 1, 1, [ 0, 48, "BZ" ], 3, [ 0, 46, "BZ" ], 1, 
  1, 3, 1, 1, 1, 3, 1, 1, 1, 3, [ 0, 40, "BY" ], 1, 1, 1, 3, [ 0, 38, "BY" ], 
  1, 1, 1, 1, [ 0, 36, "BY" ], 1, 1, 1, 1, [ 0, 34, "BY" ], 1, 1, 1, 1, 1, 
  [ 0, 32, "BZ" ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 3, 
  3, 3, 3, 1, 1, [ 5, 86 ], [ 5, 87 ], [ 5, 88 ], 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 3, 1, 1, [ 5, 95 ], [ 5, 95 ], [ 5, 95 ], [ 5, 95 ], [ 5, 95 ], 
  [ 5, 95 ], [ 5, 95 ], [ 5, 95 ] ],
#V   n = 193
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 28 ], 3, 3, 3, 1, 2, 1, 3, 1, 3, 1, 3, 3, 2, 
  1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 3, 1, 1, 
  3, 2, 1, 1, 1, 1, 1, 3, 3, 3, 1, 2, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 
  3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 194
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 73 ], 3, 3, 1, 2, 1, 3, 1, 3, 1, 2, 
  2, 2, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 3, 
  1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 3, 3, 1, 2, 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 195
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 37 ], [ 6, 90 ], 3, 1, 
  [ 0, 94, "Gu3" ], 1, [ 0, 89, "GG" ], 1, 3, 1, [ 0, 88, "BZ" ], 
  [ 0, 80, "BZ" ], [ 0, 78, "BZ" ], 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 
  2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 3, 3, 1, 
  [ 0, 46, "BZ" ], 3, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 3, 3, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 196
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 38 ], [ 6, 43 ], [ 6, 68 ], 2, 3, 
  1, 3, 1, 3, 1, 3, 3, 3, 1, 3, [ 0, 76, "BY" ], 1, 1, [ 0, 73, "XB" ], 
  [ 0, 72, "BY" ], 1, 1, [ 0, 69, "XB" ], [ 0, 68, "BY" ], 1, 1, 
  [ 0, 65, "XB" ], [ 0, 64, "BY" ], 1, 1, [ 0, 61, "XB" ], [ 0, 60, "BY" ], 
  1, 1, [ 0, 57, "XB" ], [ 0, 56, "BY" ], 1, 1, [ 0, 53, "XB" ], 
  [ 0, 52, "BY" ], 1, 1, 1, 1, 1, 3, 1, 3, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 
  1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, [ 5, 97 ], 1, 1, 1, 1, 1, 
  1, 1 ],
#V   n = 197
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 24 ], 1, [ 6, 92 ], [ 6, 69 ], 2, 3, 1, 3, 1, 
  3, 1, 3, 3, 1, 1, 2, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 
  1, 3, 3, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, [ 0, 45, "XB" ], 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, [ 0, 29, "Ka" ], 1, 1, 1, 1, 
  [ 0, 27, "Ka" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 
  1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 198
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 47 ], [ 6, 93 ], [ 0, 97, "Be" ], 
  [ 5, 8 ], 3, 1, 3, 1, [ 0, 89, "GG" ], 1, 3, 3, 1, 1, 2, 3, 1, 1, 3, 3, 1, 
  1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 2, 1, 1, 3, 
  1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 2, 1, 1, [ 0, 42, "BZ" ], 1, 1, 1, 1, 
  [ 0, 40, "BZ" ], 1, 1, 1, 1, [ 0, 38, "BZ" ], 1, 1, 1, 1, [ 0, 36, "BZ" ], 
  1, 1, 1, 1, 1, [ 0, 33, "BZ" ], 1, 1, 1, 1, [ 0, 32, "BZ" ], 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 199
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 48 ], [ 6, 93 ], 3, 3, 3, 1, 
  [ 0, 91, "GG" ], 1, 3, 1, 3, [ 0, 81, "XB" ], 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 
  2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 1, 1, 2, 1, 
  1, 1, 2, 3, 1, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 3, 3, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 200
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 2, 3, [ 5, 8 ], 3, 1, 3, 1, 3, 1, 3, 
  3, 1, 1, [ 0, 80, "BZ" ], 3, 1, 1, [ 0, 76, "BZ" ], 3, 1, 1, 
  [ 0, 72, "BZ" ], 3, 1, 1, [ 0, 68, "BZ" ], 3, 1, 1, [ 0, 64, "BZ" ], 3, 1, 
  1, [ 0, 60, "BZ" ], 3, 1, 1, [ 0, 56, "BZ" ], 3, 1, 1, [ 0, 52, "BZ" ], 1, 
  1, [ 0, 50, "BZ" ], 1, 1, 1, [ 0, 48, "BZ" ], 3, 1, 1, 1, 1, 1, 
  [ 0, 44, "BZ" ], 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 2, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  3, 1, 1, [ 5, 99 ], [ 5, 99 ], 1, 1, 1, 1, 1, 1 ],
#V   n = 201
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], [ 6, 96 ], 3, 3, 3, 1, 3, 1, 
  3, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 
  1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 3, [ 0, 29, "Ch" ], 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 202
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 44 ], [ 6, 64 ], [ 0, 99, "XB" ], 
  [ 5, 8 ], 3, 1, 3, 1, [ 0, 91, "GG" ], 1, 3, [ 0, 83, "XB" ], 1, 1, 3, 2, 
  1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 
  1, 3, 1, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 
  3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 203
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 45 ], [ 6, 43 ], 3, 2, 2, 1, 
  [ 0, 93, "GG" ], 1, 3, 1, [ 0, 89, "GG" ], 3, 1, 1, 3, 2, 1, 1, 3, 3, 1, 1, 
  3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 
  [ 0, 51, "XB" ], 2, 1, 1, 3, 3, 1, 1, 1, 2, 1, 3, 1, 2, 3, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  3, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 204
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 5, 5 ], [ 6, 92 ], 3, [ 0, 98, "Gu3" ],
  [ 5, 9 ], 1, 3, 1, 3, 1, 3, 3, 2, 1, 3, 2, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 
  3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 2, 1, 1, 3, 2, 1, 
  1, 1, 2, 1, 3, 1, [ 4, 48 ], [ 4, 51 ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 205
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 47 ], [ 6, 93 ], 3, 3, 1, 1, 3, 1, 
  3, 1, 3, 3, [ 0, 81, "XB" ], 1, 3, [ 0, 80, "Sab" ], 2, 1, 3, 1, 1, 1, 3, 
  1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 2, 3, 1, 1, 3, 
  [ 0, 50, "BZ" ], 1, 1, 3, [ 0, 48, "BZ" ], 1, 1, 1, [ 0, 46, "BZ" ], 1, 3, 
  1, 1, [ 4, 51 ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 206
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 48 ], [ 6, 64 ], 2, 2, [ 6, 11 ], 
  1, [ 0, 95, "GG" ], 1, [ 0, 93, "GG" ], 1, 3, [ 0, 85, "XB" ], 3, 1, 3, 3, 
  2, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  [ 0, 53, "XB" ], 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 1, 3, 1, 3, 3, 1, 1, 1, 
  1, 1, 1, [ 0, 41, "XB" ], 1, 1, 1, 1, [ 0, 39, "XB" ], 3, 3, 3, 3, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, [ 0, 31, "XB" ], 3, 1, 1, 1, 
  [ 0, 29, "Ch" ], 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 2, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1 ],
#V   n = 207
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], [ 6, 95 ], [ 0, 102, "BZ" ], 
  [ 0, 100, "Gu3" ], [ 6, 11 ], 1, 3, 1, 3, 1, [ 0, 91, "GG" ], 3, 3, 1, 3, 
  3, [ 0, 78, "BZ" ], 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 
  1, 1, 1, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 1, 3, 1, 3, 3, 3, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, [ 0, 35, "XB" ],
  1, 1, 1, 1, [ 0, 33, "XB" ], 1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, [ 0, 27, "X" ], 1, 1, 1, 1, 1, 1, 1, [ 0, 25, "X" ], 1, 1, 1, 1, 1, 1, 
  1, [ 0, 23, "X" ], 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 208
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 5, 5 ], [ 5, 6 ], 3, 3, 2, 2, 3, 1, 3, 
  1, 3, 3, 3, 1, [ 0, 81, "XB" ], 3, 3, 1, 3, 1, 1, 1, [ 0, 73, "XB" ], 1, 1, 
  1, [ 0, 69, "XB" ], 1, 1, 1, [ 0, 65, "XB" ], 1, 1, 1, [ 0, 61, "XB" ], 1, 
  1, 1, [ 0, 57, "XB" ], 1, 1, 3, [ 0, 53, "XB" ], 1, 1, 3, 3, 1, 1, 3, 3, 1, 
  2, 1, 3, [ 4, 46 ], 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, [ 5, 103 ], 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 209
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, [ 6, 64 ], 2, 3, 2, 2, 3, 1, 
  [ 0, 95, "GG" ], 1, 3, 2, 1, 1, 3, 3, 2, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 
  1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 2, 
  1, 3, [ 4, 46 ], [ 4, 46 ], 3, 3, 3, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 210
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 52 ], [ 6, 64 ], [ 5, 7 ], 3, 
  [ 0, 99, "Gu3" ], [ 0, 98, "Gu3" ], 3, 1, 3, 1, 3, [ 0, 88, "BZ" ], 1, 1, 
  3, 3, [ 0, 80, "BZ" ], 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 
  3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, [ 0, 48, "BZ" ], 1, 
  3, 1, [ 4, 46 ], 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 211
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 53 ], [ 6, 64 ], 3, 3, 3, 3, 3, 1, 
  3, 1, [ 0, 93, "GG" ], 3, 2, 1, [ 0, 83, "XB" ], 3, 3, 1, 3, 1, 1, 1, 
  [ 0, 75, "XB" ], 1, 1, 1, [ 0, 71, "XB" ], 1, 1, 1, [ 0, 67, "XB" ], 1, 1, 
  1, [ 0, 63, "XB" ], 1, 1, 1, [ 0, 59, "XB" ], 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 212
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, [ 5, 7 ], [ 0, 101, "GG" ], 3, 3, 
  2, 1, 3, 1, 3, 3, [ 0, 85, "XB" ], 1, 3, 3, 3, 1, [ 0, 77, "XB" ], 1, 1, 1, 
  3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 2, 1, 
  1, 1, 1, [ 0, 49, "XB" ], 1, 3, 1, [ 0, 47, "XB" ], 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, [ 0, 29, "Ch" ], 1, 3, 3, 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 213
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 55 ], 1, [ 0, 105, "Be" ], 3, 3, 3, 
  [ 0, 98, "GG" ], 2, 3, 1, 3, 3, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 3, 1, 1, 1, 
  3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 3, 
  1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 
  1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 214
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 56 ], [ 6, 64 ], 3, 3, 3, 1, 3, 
  [ 0, 97, "XB" ], 3, 1, [ 0, 95, "GG" ], [ 0, 89, "XB" ], 3, 1, 3, 1, 
  [ 0, 81, "XB" ], 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, [ 0, 55, "XB" ], 1, 1, 1, [ 0, 51, "XB" ], 3, 1, 
  3, 1, 3, 1, 2, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 215
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, 3, [ 0, 103, "XB" ], 2, 1, 2, 3, 
  3, 1, 3, 3, [ 0, 87, "XB" ], 1, 3, 1, 3, 1, 2, 1, 1, 1, 3, 1, 1, 1, 3, 1, 
  1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 3, 
  1, 3, 1, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 216
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, [ 0, 107, "Be" ], 3, 
  [ 0, 102, "GG" ], 1, [ 0, 100, "GG" ], 3, [ 0, 97, "GG" ], 1, 3, 3, 3, 1, 
  3, 1, 3, 1, [ 0, 80, "BZ" ], 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 
  3, 2, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 3, 1, 3, 1, 
  [ 0, 48, "BZ" ], 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, [ 0, 34, "BZ" ], 1, 1, 1, 1, 
  [ 0, 32, "BZ" ], 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 217
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 59 ], [ 6, 64 ], 3, 3, 3, 1, 3, 3, 
  3, 1, 3, [ 0, 91, "XB" ], 3, 1, 3, 1, [ 0, 83, "XB" ], 1, 3, 2, 1, 1, 3, 2, 
  1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  3, 3, 1, 3, 1, 3, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 218
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 60 ], [ 6, 64 ], 3, 3, 2, 1, 2, 3, 
  3, 1, 3, 3, 3, 1, 2, 1, 3, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 
  1, 3, 2, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 1, 3, 1, 3, 1, 3, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 219
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, 3, 2, [ 0, 104, "GG" ], 1, 
  [ 0, 102, "GG" ], 1, 3, 1, 3, 3, 3, 1, [ 0, 86, "BY" ], 1, 3, 1, 3, 2, 1, 
  1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 2, 1, 1, 3, 
  1, 1, 1, 3, 3, 1, 1, 1, 3, 1, 3, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  1, 1, 1, 1, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 220
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 62 ], 1, [ 0, 109, "Be" ], 2, 3, 1, 
  3, 1, [ 0, 99, "GG" ], 1, 3, 3, 3, 1, 3, 1, 3, 1, [ 0, 81, "XB" ], 
  [ 0, 80, "BY" ], 1, 1, [ 0, 77, "XB" ], [ 0, 76, "BY" ], 1, 1, 
  [ 0, 73, "XB" ], [ 0, 72, "BY" ], 1, 1, [ 0, 69, "XB" ], [ 0, 68, "BY" ], 
  1, 1, [ 0, 65, "XB" ], [ 0, 64, "BY" ], 1, 1, [ 0, 61, "XB" ], 
  [ 0, 60, "BY" ], 1, 1, [ 0, 57, "XB" ], 1, 1, 3, 1, 1, 1, [ 0, 53, "XB" ], 
  1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1 ],
#V   n = 221
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 16 ], [ 6, 63 ], [ 6, 64 ], 3, 
  [ 0, 107, "Gu3" ], 2, 1, 2, 2, 3, 1, 3, [ 0, 93, "XB" ], 3, 1, 2, 1, 2, 1, 
  3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 
  1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 222
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], [ 5, 6 ], 3, 3, 
  [ 0, 106, "GG" ], 1, [ 0, 104, "GG" ], 2, 3, 1, 3, 3, 2, 1, [ 0, 88, "BY" ],
  1, [ 0, 86, "BZ" ], 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 
  3, 1, 1, 3, 3, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, [ 0, 50, "BY" ], 
  1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 32, "BZ" ],
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 223
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, [ 6, 96 ], 2, 3, 3, 1, 3, 2, 3, 1, 
  [ 0, 97, "GG" ], 3, 2, 1, 3, 1, 3, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 
  2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 1, 1, 3, 1, 1, 1, 2, 1, 1, 1, 1, 3, 
  1, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 224
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 5, 5 ], [ 5, 6 ], [ 5, 7 ], 2, 2, 1, 
  2, 2, [ 0, 101, "GG" ], 1, 3, 2, [ 0, 91, "GG" ], 1, 3, 1, 2, 1, 
  [ 0, 84, "BZ" ], 3, 1, 1, [ 0, 80, "BZ" ], 3, 1, 1, [ 0, 76, "BZ" ], 3, 1, 
  1, [ 0, 72, "BZ" ], 3, 1, 1, [ 0, 68, "BZ" ], 3, 1, 1, [ 0, 64, "BZ" ], 3, 
  1, 1, [ 0, 60, "BZ" ], 1, 1, 3, 1, 1, 1, [ 0, 56, "BZ" ], 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  [ 5, 111 ], [ 5, 111 ], [ 5, 111 ], [ 5, 111 ], [ 5, 111 ], [ 5, 111 ], 1, 
  1 ],
#V   n = 225
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 3, 3, [ 0, 110, "Gu3" ], 
  [ 0, 108, "GG" ], 1, [ 0, 106, "GG" ], [ 0, 104, "BZ" ], 3, 1, 3, 
  [ 0, 96, "BZ" ], 3, 1, 3, 1, [ 0, 88, "BZ" ], 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 
  2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 226
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 52 ], 1, [ 5, 7 ], 3, 3, 1, 3, 3, 
  3, 1, 3, 3, 3, 1, 2, 1, 3, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 
  1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, [ 0, 57, "XB" ], 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 227
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 53 ], [ 6, 82 ], [ 6, 99 ], 3, 2, 
  1, 2, 3, [ 0, 103, "GG" ], 1, [ 0, 99, "GG" ], 3, 3, 1, 2, 1, 3, 1, 3, 2, 
  1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 1, 3, 2, 1, 
  3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 228
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, [ 6, 36 ], 3, [ 0, 110, "GG" ], 1, 
  [ 0, 108, "GG" ], 3, 3, 1, 3, 3, 3, 1, [ 0, 91, "GG" ], 1, 3, 1, 
  [ 0, 85, "XB" ], [ 0, 84, "BY" ], 1, 1, [ 0, 81, "XB" ], [ 0, 80, "BY" ], 
  1, 1, [ 0, 77, "XB" ], [ 0, 76, "BY" ], 1, 1, [ 0, 73, "XB" ], 
  [ 0, 72, "BY" ], 1, 1, [ 0, 69, "XB" ], [ 0, 68, "BY" ], 1, 1, 
  [ 0, 65, "XB" ], [ 0, 64, "BY" ], 1, 1, [ 0, 61, "XB" ], [ 0, 60, "BY" ], 
  1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 229
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 55 ], 1, [ 0, 113, "Be" ], 2, 3, 1, 
  3, [ 0, 105, "XB" ], 3, 1, 3, [ 0, 97, "XB" ], 2, 1, 3, 1, [ 0, 89, "XB" ], 
  1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 
  3, 3, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 230
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 56 ], 1, 3, [ 5, 8 ], 2, 1, 2, 3, 
  3, 1, 3, 3, 2, 1, 3, 1, 3, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 
  1, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 1, 1, 2, 1, 1, 3, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 231
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, 3, 1, [ 0, 112, "GG" ], 1, 
  [ 0, 110, "GG" ], 3, 3, 1, [ 0, 101, "GG" ], 3, [ 0, 95, "GG" ], 1, 3, 1, 
  3, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 1, 2, 3, 1, 
  1, 2, 3, 1, 1, 2, 1, 1, 2, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1 ],
#V   n = 232
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, [ 0, 115, "Be" ], [ 5, 8 ], 3, 1, 
  3, 3, 3, 1, 3, [ 0, 99, "XB" ], 3, 1, 2, 1, 3, 1, [ 0, 88, "BZ" ], 1, 1, 1, 
  [ 0, 84, "BZ" ], 1, 1, 1, [ 0, 80, "BZ" ], 1, 2, 1, [ 0, 76, "BZ" ], 1, 2, 
  1, [ 0, 72, "BZ" ], 1, 2, 1, [ 0, 68, "BZ" ], 1, 2, 1, [ 0, 64, "BZ" ], 3, 
  1, 1, [ 0, 60, "BY" ], 1, 1, [ 0, 58, "BZ" ], 1, 1, 1, [ 0, 56, "BZ" ], 3, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 233
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 59 ], [ 6, 64 ], 3, 1, 3, 1, 2, 3, 
  3, 1, 3, 3, 3, 1, 2, 1, 2, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 2, 1, 3, 1, 2, 
  1, 3, 1, 2, 1, 3, 1, 2, 1, 3, 2, 1, 1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 3, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 234
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 60 ], [ 6, 64 ], 3, [ 5, 8 ], 3, 1, 
  [ 0, 112, "GG" ], [ 0, 107, "XB" ], 3, 1, [ 0, 103, "GG" ], 3, 2, 1, 
  [ 0, 95, "GG" ], 1, [ 0, 92, "BZ" ], 1, 3, [ 4, 12 ], 1, 1, 3, 1, 1, 1, 3, 
  1, 2, 1, 3, 1, 2, 1, 3, 1, 2, 1, 3, 1, 2, 2, 3, 2, 1, 1, 3, 1, 1, 3, 1, 1, 
  1, 3, 1, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 235
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, 3, 2, 3, 1, 3, 3, [ 0, 105, "GG" ],
  1, 3, 3, 2, 1, 3, 1, 3, 1, 3, [ 4, 12 ], [ 4, 12 ], 1, 1, 1, 1, 1, 2, 1, 2, 
  1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 3, 2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 
  1, 2, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 236
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 62 ], 1, [ 0, 117, "Be" ], 2, 3, 1, 
  3, 3, 3, 1, 3, [ 0, 101, "XB" ], [ 0, 99, "GG" ], 1, 3, 1, 2, 1, 2, 1, 
  [ 4, 12 ], [ 4, 14 ], 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 
  2, 2, [ 0, 65, "XB" ], [ 0, 64, "BY" ], 1, 1, [ 0, 61, "XB" ], 1, 1, 1, 1, 
  1, 1, [ 0, 57, "XB" ], 1, [ 0, 56, "BZ" ], 1, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 237
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 63 ], 1, 3, 2, 3, 1, 3, 2, 3, 1, 3, 
  3, 3, 1, 2, 1, [ 0, 94, "BZ" ], 1, 2, 1, 1, [ 4, 14 ], [ 4, 14 ], 1, 1, 1, 
  2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 3, 3, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 3, 1, 3, 1, 1, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 238
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 48 ], [ 5, 6 ], 3, 
  [ 0, 116, "Gu3" ], [ 0, 113, "GG" ], 1, 3, 2, 3, 1, 3, 3, 3, 1, 2, 1, 3, 1, 
  2, 3, 1, 1, [ 4, 14 ], [ 4, 14 ], 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 
  2, 1, 2, 2, 3, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 2, 3, 3, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 239
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], [ 6, 112 ], 2, 3, 3, 1, 3, 2, 
  [ 0, 107, "GG" ], 1, 3, 2, 2, 1, [ 0, 99, "GG" ], 1, 2, 1, 2, 1, 3, 1, 1, 
  [ 4, 14 ], [ 4, 16 ], 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 
  3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 2, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 240
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 5, 5 ], [ 5, 6 ], [ 5, 7 ], 3, 3, 
  [ 5, 10 ], 3, [ 0, 112, "BZ" ], 3, 1, [ 0, 105, "GG" ], [ 0, 104, "BZ" ], 
  2, 1, 3, 2, [ 0, 96, "BZ" ], 1, 2, 1, 1, 3, 1, 1, [ 4, 16 ], 1, 
  [ 0, 86, "B2" ], 1, [ 0, 84, "B2" ], 1, [ 0, 82, "B2" ], 1, [ 0, 80, "B2" ],
  1, [ 0, 78, "B2" ], 1, [ 0, 76, "B2" ], 1, [ 0, 74, "B2" ], 2, 
  [ 0, 72, "B2" ], 2, [ 0, 68, "BZ" ], 3, 1, 1, [ 0, 64, "BZ" ], 2, 1, 1, 1, 
  1, 1, [ 0, 60, "BZ" ], 1, [ 0, 58, "BZ" ], 1, 1, [ 0, 56, "BZ" ], 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 241
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 59 ], [ 6, 96 ], 3, 3, 3, 
  [ 0, 113, "GG" ], 3, 3, 3, 1, 3, 3, [ 0, 103, "GG" ], 1, 3, 2, 3, 1, 
  [ 0, 94, "Gu3" ], 1, 1, 1, 3, 1, 1, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 
  3, 2, 3, 2, 3, 2, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 3, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 242
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 60 ], [ 6, 82 ], [ 5, 7 ], 2, 
  [ 0, 115, "GG" ], 3, 3, 3, 3, 1, 3, 3, 3, 1, 2, 2, 3, 1, 3, [ 4, 12 ], 1, 
  1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 3, 2, 1, 1, 
  3, 2, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 243
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, [ 6, 51 ], [ 0, 118, "Gu3" ], 3, 
  3, [ 0, 113, "GG" ], 3, [ 0, 109, "GG" ], 1, [ 0, 107, "GG" ], 1, 3, 1, 2, 
  2, 3, 1, 3, [ 4, 12 ], [ 4, 12 ], 1, 2, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 2, 3, 2, 1, 1, 3, 2, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 2, 1, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 244
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 62 ], 1, [ 0, 121, "Be" ], 3, 3, 3, 
  3, 3, 3, 1, 3, 1, 2, 1, [ 0, 103, "GG" ], 2, 3, 1, 3, 1, [ 4, 12 ], 1, 
  [ 0, 90, "B2" ], 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 
  [ 0, 69, "XB" ], [ 0, 68, "BY" ], 1, 1, [ 0, 65, "XB" ], [ 0, 64, "BY" ], 
  1, 1, 1, 1, 1, 3, 1, 3, 1, 1, [ 0, 58, "BZ" ], 1, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  1, 1, 1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 245
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 63 ], 1, 3, 3, 3, [ 0, 115, "GG" ], 
  3, [ 0, 113, "XB" ], 3, 1, 3, 1, 2, 1, 3, 2, 3, 1, 3, 1, 1, 1, 3, 1, 1, 3, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 3, 3, 1, 1, 3, 3, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 246
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 56 ], [ 5, 6 ], 3, 3, 
  [ 0, 117, "GG" ], 3, 3, 3, [ 0, 111, "GG" ], 1, [ 0, 109, "GG" ], 1, 
  [ 0, 107, "GG" ], 1, 3, 2, [ 0, 97, "XB" ], 1, 3, 3, 1, 1, 1, 1, 1, 1, 3, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 3, 3, 1, 1, 3, 3, 1, 1, 2, 1, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 247
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 32 ], [ 6, 120 ], 2, 2, 3, 3, 
  [ 0, 115, "XB" ], 3, 3, 1, 3, 1, 3, 1, 2, 2, 3, 1, 2, 3, 3, 1, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 3, 1, 1, 2, 3, 1, 1, 2, 
  1, 1, 2, 3, 1, 1, 1, 3, 1, 1, 2, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 248
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 62 ], [ 5, 6 ], [ 5, 7 ], 2, 3, 3, 
  3, 3, 3, 1, 3, 1, 3, 1, 2, 2, 3, 1, [ 0, 96, "BZ" ], 1, 3, 3, 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, [ 0, 72, "BZ" ], 3, 1, 1, 
  [ 0, 68, "BZ" ], 3, 1, 1, [ 0, 64, "BY" ], 1, 1, [ 0, 62, "BZ" ], 1, 3, 1, 
  1, 1, 1, 1, [ 0, 58, "BZ" ], 1, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 249
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 63 ], [ 6, 96 ], 3, 2, 
  [ 0, 119, "GG" ], 2, 3, [ 0, 115, "XB" ], 3, 1, [ 0, 111, "GG" ], 1, 
  [ 0, 109, "GG" ], 1, [ 0, 107, "GG" ], 2, 3, 1, 3, 1, 1, 3, 3, 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 3, 2, 1, 1, 3, 2, 1, 1, 3, 1, 
  1, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 250
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 60 ], [ 5, 6 ], [ 5, 7 ], 2, 3, 2, 
  3, 3, 3, 1, 3, 1, 3, 1, 3, 2, [ 0, 99, "XB" ], 1, 3, 1, 1, 1, 3, 3, 1, 1, 
  1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 3, 2, 1, 1, 3, 2, 1, 1, 3, 
  1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 2, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 
  1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 
  1, 1, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 251
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 6, 63 ], [ 6, 124 ], 2, 2, 3, 2, 2, 3, 
  3, 1, 3, 1, 3, 1, 3, 2, 3, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 3, 3, 
  1, 1, 1, 1, 1, 1, 2, 1, 2, 3, 2, 1, 1, 3, 2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 2, 
  3, 1, 1, 1, 1, 1, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 252
[ ,, [ 6, 7 ], [ 6, 15 ], 1, [ 6, 63 ], 1, [ 5, 7 ], 2, 3, [ 0, 120, "Gu3" ], 
  [ 0, 118, "BZ" ], 3, 3, 1, 3, 1, 1, 1, 1, 2, 3, 1, [ 0, 97, "XB" ], 1, 1, 
  1, 1, 2, 3, 3, 1, 1, 1, 1, 1, 2, 3, 3, 1, 1, 1, 1, 1, 2, 1, 2, 
  [ 0, 73, "XB" ], [ 0, 72, "BY" ], 1, 1, [ 0, 69, "XB" ], [ 0, 68, "BY" ], 
  1, 1, [ 0, 65, "XB" ], 3, 1, 1, 1, 1, 1, [ 0, 61, "XB" ], 3, 3, 1, 1, 1, 1, 
  [ 0, 58, "BZ" ], 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  2, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 
  3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 1, 
  3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 
  3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 253
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, 1, 2, 3, 3, 3, 2, [ 0, 113, "GG" ],
  1, 3, 1, 1, 1, 1, 2, 3, 1, 3, 1, 1, 1, 1, 2, 2, 3, 3, 1, 1, 1, 1, 2, 2, 3, 
  3, 1, 1, 1, 1, 2, 1, 2, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 3, 2, 1, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  2, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 3, 
  3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 1, 1, 
  1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 
  3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 1, 3, 3, 3, 3, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1 ],
#V   n = 254
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, 1, 2, 2, 3, 1, 2, 3, 1, 3, 3, 1, 
  1, 1, 2, 2, 1, 3, 3, 1, 1, 1, 2, 2, 3, 3, 3, 1, 1, 1, 2, 2, 3, 3, 3, 1, 1, 
  1, 2, 1, 2, 3, 3, 1, 1, 3, 3, 1, 1, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 3, 1, 
  1, 1, 2, 1, 2, 3, 3, 1, 1, 1, 2, 3, 3, 3, 3, 1, 1, 1, 2, 1, 1, 1, 2, 3, 3, 
  3, 3, 1, 1, 1, 2, 3, 3, 3, 3, 1, 1, 1, 2, 3, 3, 3, 3, 1, 1, 1, 2, 3, 3, 3, 
  3, 1, 1, 1, 2, 3, 3, 3, 3, 1, 1, 1, 2, 1, 1, 2, 3, 1, 1, 1, 2, 3, 3, 3, 3, 
  1, 1, 1, 2, 3, 3, 3, 3, 1, 1, 1, 2, 3, 3, 3, 3, 1, 1, 1, 2, 3, 3, 3, 3, 1, 
  1, 1, 2, 3, 3, 3, 3, 1, 1, 1, 2, 3, 3, 3, 3, 1, 1, 1, 2, 3, 1, 1, 1, 3, 3, 
  3, 3, 1, 1, 1, 2, 3, 3, 3, 3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 2, 3, 3, 3, 
  3, 3, 1, 1, 1, 3, 3, 3, 3, 1, 1, 1, 2, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1 ],
#V   n = 255
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 1, 1, 1, 2, [ 0, 122, "I" ], 3, 1, 
  [ 0, 119, "I" ], 3, 1, 3, 3, 3, 1, 1, [ 0, 111, "I" ], [ 0, 102, "I" ], 1, 
  [ 0, 99, "BZ" ], 3, 3, 1, 1, [ 0, 95, "I" ], [ 0, 94, "I" ], 3, 3, 3, 3, 1, 
  1, [ 0, 91, "I" ], [ 0, 90, "I" ], 3, 3, 3, 3, 1, 1, [ 0, 87, "I" ], 1, 
  [ 0, 85, "I" ], [ 0, 75, "BZ" ], 3, 1, 1, [ 0, 71, "BZ" ], 3, 1, 1, 
  [ 0, 67, "BZ" ], 3, 3, 3, 3, 1, 1, [ 0, 63, "BZ" ], 3, 3, 3, 3, 3, 1, 1, 
  [ 0, 59, "I" ], 1, [ 0, 57, "BZ" ], 3, 3, 3, 1, 1, [ 0, 55, "BCH" ], 3, 3, 
  3, 3, 3, 1, 1, [ 0, 53, "I" ], 3, 1, 1, [ 0, 51, "I" ], 3, 3, 3, 3, 3, 1, 
  1, [ 0, 47, "I" ], 3, 3, 3, 3, 3, 1, 1, [ 0, 45, "I" ], 3, 3, 3, 3, 3, 1, 
  1, [ 0, 43, "I" ], 3, 3, 3, 3, 3, 1, 1, [ 0, 39, "I" ], 3, 3, 3, 3, 3, 1, 
  1, [ 0, 37, "I" ], 1, 1, [ 0, 34, "I" ], 3, 3, 1, 1, [ 0, 31, "I" ], 3, 3, 
  3, 3, 3, 1, 1, [ 0, 29, "I" ], 3, 3, 3, 3, 3, 1, 1, [ 0, 27, "I" ], 3, 3, 
  3, 3, 3, 1, 1, [ 0, 25, "I" ], 3, 3, 3, 3, 3, 1, 1, [ 0, 23, "I" ], 3, 3, 
  3, 3, 3, 1, 1, [ 0, 21, "I" ], 3, 3, 3, 3, 3, 1, 1, [ 0, 19, "I" ], 3, 3, 
  1, 1, 2, 3, 3, 3, 3, 1, 1, [ 0, 15, "I" ], 3, 3, 3, 3, 3, 3, 1, 1, 2, 3, 3, 
  3, 3, 1, 1, [ 0, 11, "I" ], 3, 3, 3, 3, 3, 3, 1, 1, 2, 3, 3, 3, 3, 1, 1, 
  [ 0, 7, "I" ], 3, 3, 3, 3, 3, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2 ],
#V   n = 256
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], [ 5, 5 ], [ 5, 6 ], [ 5, 7 ], [ 5, 8 ], 
  3, 3, 1, 3, 3, 1, 2, 3, 3, 3, 1, 3, 3, 1, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 
  3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 1, 3, 3, 3, 3, 1, 3, 3, 3, 1, 3, 3, 3, 3, 
  3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 1, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 
  3, 1, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 
  3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 1, 3, 
  3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 
  3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 
  3, 1, 3, 3, 3, 3, 1, 2, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 3, 1, 2, 3, 
  3, 3, 3, 3, 1, 3, 3, 3, 3, 3, 3, 3, 3, 1, 2, 3, 3, 3, 3, 3, 1, 3, 3, 3, 3, 
  3, 3, 3, 3, 1, 2, [ 5, 127 ], [ 5, 127 ], [ 5, 127 ], [ 5, 127 ], 
  [ 5, 127 ], [ 5, 127 ], [ 5, 127 ] ],
#V   n = 257
[ ,, [ 6, 7 ], [ 6, 15 ], [ 6, 31 ], 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  [ 0, 114, "Gu3" ], 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, 3, [ 0, 18, "BCH" ], 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, [ 0, 14, "BCH" ], 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  [ 0, 10, "BCH" ], 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  [ 0, 6, "BCH" ], 3, 3, 3, 3, 3, 3, 3 ]];

GUAVA_BOUNDS_TABLE[2][2] := [
#V   n = 1
[  ],
#V   n = 2
[  ],
#V   n = 3
[  ],
#V   n = 4
[  ],
#V   n = 5
[  ],
#V   n = 6
[  ],
#V   n = 7
[  ],
#V   n = 8
[ ,,,, [ 14, 4 ] ],
#V   n = 9
[ ,,,, [ 14, 4 ], [ 14, 5 ] ],
#V   n = 10
[ ,,,,, [ 14, 5 ], [ 14, 6 ] ],
#V   n = 11
[ ,,,,,, [ 14, 6 ], [ 14, 7 ] ],
#V   n = 12
[ ,,,, [ 0, 4, "FP" ],,, [ 14, 7 ], [ 14, 8 ] ],
#V   n = 13
[ ,,,, 12, 11,,, [ 14, 8 ], [ 14, 9 ] ],
#V   n = 14
[ ,,,,, [ 14, 4 ], 11,,, [ 14, 9 ], [ 14, 10 ] ],
#V   n = 15
[ ,,,,,, [ 14, 5 ], 11,,, [ 14, 10 ], [ 14, 11 ] ],
#V   n = 16
[ ,,,,, [ 14, 4 ],, [ 14, 6 ], 11,,, [ 14, 8 ], [ 14, 12 ] ],
#V   n = 17
[ ,,,,, [ 14, 4 ], [ 14, 5 ],, [ 14, 7 ], 11,, [ 14, 8 ], [ 14, 9 ], 
  [ 14, 13 ] ],
#V   n = 18
[ ,,,,,, [ 14, 5 ], [ 14, 6 ],, [ 14, 6 ], 11,, [ 14, 9 ], [ 14, 10 ], 
  [ 14, 14 ] ],
#V   n = 19
[ ,,,,,,, [ 14, 6 ], [ 14, 7 ], 12, 11, 11,, [ 14, 10 ], [ 14, 11 ], 
  [ 14, 15 ] ],
#V   n = 20
[ ,,,,,,,, [ 14, 7 ], [ 14, 8 ], 11, [ 14, 8 ], 11,, [ 14, 11 ], [ 14, 12 ], 
  [ 14, 16 ] ],
#V   n = 21
[ ,,,,,,,,, [ 14, 8 ], [ 14, 9 ], 12, [ 14, 9 ], 11,, [ 14, 12 ], [ 14, 13 ], 
  [ 14, 17 ] ],
#V   n = 22
[ ,,,,,, [ 14, 4 ],,,, [ 14, 9 ], [ 14, 10 ], [ 14, 8 ], [ 14, 10 ], 11,, 
  [ 14, 13 ], [ 14, 14 ], [ 14, 18 ] ],
#V   n = 23
[ ,,,,,, [ 14, 4 ], [ 14, 5 ],,,, [ 14, 10 ], [ 14, 11 ], [ 14, 9 ], 
  [ 14, 11 ], 11,, [ 14, 14 ], [ 14, 15 ], [ 14, 19 ] ],
#V   n = 24
[ ,,,,,,, 13, [ 14, 6 ],,,, [ 14, 8 ], [ 14, 12 ], 13, [ 14, 12 ], 11,, 
  [ 14, 15 ], [ 14, 16 ], [ 14, 20 ] ],
#V   n = 25
[ ,,,,,, [ 14, 4 ], [ 0, 9, "YH1" ], 13, [ 14, 7 ],,, 13, [ 14, 9 ], 
  [ 0, 5, "Si" ], 13, [ 14, 13 ], 11,, [ 14, 16 ], [ 14, 17 ], [ 14, 21 ] ],
#V   n = 26
[ ,,,,,, [ 14, 4 ], [ 14, 5 ], 11, 13, [ 14, 8 ],, [ 0, 7, "Pu2" ], 13, 
  [ 14, 10 ], 11, 13, [ 14, 14 ], 11,, [ 14, 17 ], [ 14, 18 ], [ 14, 22 ] ],
#V   n = 27
[ ,,,,,,, 13, [ 14, 6 ], 11, 13, [ 14, 9 ],, 11, 13, [ 14, 11 ], 11, 13, 
  [ 14, 15 ], 11,, [ 14, 18 ], [ 14, 19 ], [ 14, 23 ] ],
#V   n = 28
[ ,,,,, [ 0, 12, "BM" ],, [ 0, 11, "DM" ], 13, [ 14, 7 ], 11, 13, [ 14, 10 ],
  , 11, 13, [ 14, 12 ], 11, 13, [ 14, 16 ], 11,, [ 14, 19 ], [ 14, 20 ], 
  [ 14, 24 ] ],
#V   n = 29
[ ,,,,, 12, 11,, 11, 13, [ 14, 8 ], 11, [ 14, 7 ], [ 14, 11 ],, 11, 13, 
  [ 14, 13 ], 11, [ 14, 11 ], [ 14, 17 ], 11,, [ 14, 20 ], [ 14, 21 ], 
  [ 14, 25 ] ],
#V   n = 30
[ ,,,,,, 13, 11,, 11, 13, [ 14, 9 ], 11, [ 14, 8 ], [ 14, 12 ],, 11, 13, 
  [ 14, 14 ], 11, [ 14, 12 ], [ 14, 18 ], 11,, [ 14, 21 ], [ 14, 22 ], 
  [ 14, 26 ] ],
#V   n = 31
[ ,,,,,, [ 0, 13, "vT3" ], 13, 11,, 11, 13, [ 14, 10 ], 11, [ 14, 9 ], 
  [ 14, 13 ],, 11, 13, [ 14, 15 ], 11, [ 14, 13 ], [ 14, 19 ], 11,, 
  [ 14, 22 ], [ 14, 23 ], [ 14, 27 ] ],
#V   n = 32
[ ,,,,,, [ 14, 4 ], 11, [ 14, 4 ], 11,, 13, [ 14, 7 ], [ 14, 11 ], 13, 
  [ 14, 10 ], [ 14, 14 ],, 11, 13, [ 14, 16 ], 11, [ 14, 14 ], [ 14, 20 ], 11,
  , [ 14, 16 ], [ 14, 24 ], [ 14, 28 ] ],
#V   n = 33
[ ,,,,,, 13, [ 14, 5 ], [ 0, 12, "He" ], [ 14, 5 ], 11, [ 0, 11, "HT" ], 13, 
  [ 14, 8 ], [ 14, 8 ], 13, [ 14, 11 ], [ 14, 15 ],, 11, 13, [ 14, 17 ], 11, 
  [ 14, 15 ], [ 14, 21 ], 11, [ 14, 16 ], [ 14, 17 ], [ 14, 25 ], [ 14, 29 ] 
 ],
#V   n = 34
[ ,,,,,, [ 0, 15, "vT3" ], 13, 12, 11, [ 14, 6 ], 11, 11, 13, [ 14, 9 ], 
  [ 14, 9 ], 13, [ 14, 12 ], [ 14, 16 ],, 13, 13, [ 14, 18 ], 11, [ 14, 16 ], 
  [ 14, 22 ], 11, [ 14, 17 ], [ 14, 18 ], [ 14, 26 ], [ 14, 30 ] ],
#V   n = 35
[ ,,,,,,, 11, 13, 12, 11, [ 14, 7 ], 11, 11, 13, [ 14, 10 ], [ 14, 10 ], 13, 
  [ 14, 13 ], [ 14, 17 ], [ 0, 7, "AEB" ], 13, 13, [ 14, 19 ], 11, 
  [ 14, 17 ], [ 14, 23 ], 11, [ 14, 18 ], [ 14, 19 ], [ 14, 27 ], [ 14, 31 ] 
 ],
#V   n = 36
[ ,,,,,,,, 13, 13, 12, 11, [ 14, 8 ], 11, 11, 13, [ 14, 11 ], [ 14, 11 ], 13, 
  [ 14, 14 ], [ 14, 18 ], 11, 13, [ 14, 12 ], [ 14, 20 ], 11, [ 14, 18 ], 
  [ 14, 24 ], 11, [ 14, 19 ], [ 14, 20 ], [ 14, 28 ], [ 14, 32 ] ],
#V   n = 37
[ ,,,,,,,, [ 0, 15, "HT" ], 13, 13, 12, 11, [ 14, 9 ], 11, 11, 13, 
  [ 14, 12 ], [ 14, 12 ], 13, [ 14, 15 ], [ 14, 19 ], 11, 13, 13, [ 14, 21 ], 
  11, [ 14, 19 ], [ 14, 25 ], 11, [ 14, 20 ], [ 14, 21 ], [ 14, 29 ], 
  [ 14, 33 ] ],
#V   n = 38
[ ,,,,,,,,, 11, 13, 13, [ 14, 7 ], 11, [ 14, 10 ], 11, 11, 13, [ 14, 13 ], 
  [ 14, 13 ], 13, [ 14, 16 ], [ 14, 20 ], 11, 13, 13, [ 14, 22 ], 13, 
  [ 14, 20 ], [ 14, 26 ], 11, [ 14, 21 ], [ 14, 22 ], [ 14, 30 ], [ 14, 34 ] 
 ],
#V   n = 39
[ ,,,,,,, [ 14, 4 ],,, 11, 13, [ 14, 7 ], [ 14, 8 ], 11, [ 14, 11 ], 11, 11, 
  13, [ 14, 14 ], [ 14, 14 ], 13, [ 14, 17 ], [ 14, 21 ], 11, 13, [ 14, 15 ], 
  [ 0, 5, "HT" ], 13, [ 14, 21 ], [ 14, 27 ], 11, [ 14, 22 ], [ 14, 23 ], 
  [ 14, 31 ], [ 14, 35 ] ],
#V   n = 40
[ ,,,,, [ 0, 18, "BM" ],, [ 14, 4 ], [ 14, 5 ],,, 13, 13, [ 14, 8 ], 
  [ 14, 9 ], 11, [ 14, 12 ], 11, 11, 13, [ 14, 15 ], [ 14, 15 ], 13, 
  [ 14, 18 ], [ 14, 22 ], 11, 13, [ 14, 16 ], 11, 13, [ 14, 22 ], [ 14, 28 ], 
  11, [ 14, 23 ], [ 14, 24 ], [ 14, 32 ], [ 14, 36 ] ],
#V   n = 41
[ ,,,,, 12, 11,, [ 14, 5 ], [ 14, 6 ],, [ 0, 15, "HT" ], 13, 13, [ 14, 9 ], 
  [ 14, 8 ], 11, [ 14, 13 ], 11, 11, 13, [ 14, 16 ], [ 14, 16 ], [ 14, 12 ], 
  [ 14, 19 ], [ 14, 23 ], 11, 13, [ 14, 17 ], 11, 13, [ 14, 23 ], [ 14, 29 ], 
  11, [ 14, 24 ], [ 14, 25 ], [ 14, 33 ], [ 14, 37 ] ],
#V   n = 42
[ ,,,,,, 12, 11,, [ 14, 6 ], [ 14, 7 ],, 11, 13, 13, [ 0, 13, "AEB" ], 
  [ 14, 9 ], 11, [ 14, 14 ], 11, 13, 13, [ 14, 17 ], [ 14, 17 ], 13, 
  [ 14, 20 ], [ 14, 24 ], 11, 13, [ 14, 18 ], 11, 13, [ 14, 24 ], [ 14, 30 ], 
  11, [ 14, 25 ], [ 14, 26 ], [ 14, 34 ], [ 14, 38 ] ],
#V   n = 43
[ ,,,,,,, 13, 11,, [ 14, 7 ], [ 14, 8 ],, 11, 13, 13, 11, [ 14, 10 ], 11, 
  [ 14, 15 ], [ 0, 11, "HT" ], 13, 13, [ 14, 18 ], [ 14, 18 ], [ 14, 14 ], 
  [ 14, 21 ], [ 14, 25 ], 11, 13, [ 14, 19 ], 11, 13, [ 14, 25 ], [ 14, 31 ], 
  11, [ 14, 26 ], [ 14, 27 ], [ 14, 35 ], [ 14, 39 ] ],
#V   n = 44
[ ,,,,,,, [ 0, 19, "DM" ], [ 14, 4 ], 11,, [ 14, 8 ], [ 14, 9 ],, 11, 13, 13, 
  11, [ 14, 11 ], 11, [ 14, 16 ], 11, 13, [ 14, 12 ], [ 14, 19 ], [ 14, 19 ], 
  [ 14, 15 ], [ 14, 22 ], [ 14, 26 ], 13, 13, [ 14, 20 ], 11, 13, [ 14, 26 ], 
  [ 14, 32 ], 11, [ 14, 27 ], [ 14, 28 ], [ 14, 36 ], [ 14, 40 ] ],
#V   n = 45
[ ,,,,,,,, 11, [ 14, 5 ], 11,, [ 14, 6 ], [ 14, 10 ],, 13, 13, 13, 11, 
  [ 14, 12 ], 11, [ 14, 17 ], 11, 13, [ 14, 13 ], [ 14, 20 ], [ 14, 20 ], 
  [ 14, 16 ], [ 14, 23 ], [ 0, 7, "AEB" ], 13, 13, [ 14, 21 ], 11, 13, 
  [ 14, 27 ], [ 14, 33 ], 11, [ 14, 28 ], [ 14, 29 ], [ 14, 37 ], [ 14, 41 ] 
 ],
#V   n = 46
[ ,,,,,,, [ 14, 4 ],, 11, [ 14, 6 ], 11, [ 14, 6 ], [ 14, 7 ], [ 14, 11 ], 
  [ 0, 15, "DK" ], 13, 13, 13, 11, [ 14, 13 ], 11, [ 14, 18 ], 11, 13, 
  [ 14, 14 ], [ 14, 21 ], [ 14, 14 ], [ 14, 17 ], [ 14, 24 ], 11, 13, 13, 
  [ 14, 22 ], 11, 13, [ 14, 28 ], [ 14, 34 ], 11, [ 14, 29 ], [ 14, 30 ], 
  [ 14, 38 ], [ 14, 42 ] ],
#V   n = 47
[ ,,,,,,, [ 14, 4 ], [ 14, 5 ],, 11, [ 14, 7 ], 11, [ 14, 7 ], [ 14, 8 ], 
  [ 14, 12 ], 11, 13, 13, 13, 11, [ 14, 14 ], 11, [ 14, 19 ], 11, 13, 
  [ 14, 15 ], [ 14, 14 ], 13, [ 14, 18 ], [ 14, 25 ], 11, 13, 13, [ 14, 23 ], 
  11, 13, [ 14, 29 ], [ 14, 35 ], 11, [ 14, 30 ], [ 14, 31 ], [ 14, 39 ], 
  [ 14, 43 ] ],
#V   n = 48
[ ,,,,,,,, [ 14, 5 ], [ 14, 6 ],, 13, [ 14, 8 ], 11, [ 14, 8 ], [ 14, 9 ], 
  [ 14, 13 ], 11, 13, 13, 13, 11, [ 14, 15 ], 11, [ 14, 20 ], 11, 13, 
  [ 14, 16 ], [ 14, 15 ], 13, [ 14, 19 ], [ 14, 26 ], 11, 13, 13, [ 14, 24 ], 
  11, 13, [ 14, 30 ], [ 14, 36 ], 11, [ 14, 31 ], [ 14, 32 ], [ 14, 40 ], 
  [ 14, 44 ] ],
#V   n = 49
[ ,,,,,,, [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ], [ 0, 19, "HT" ], 13, [ 14, 9 ], 
  11, [ 14, 9 ], [ 14, 10 ], [ 14, 14 ], 11, 13, 13, 13, 11, [ 14, 16 ], 11, 
  [ 14, 21 ], 11, 13, [ 14, 17 ], [ 14, 16 ], 13, [ 14, 20 ], [ 14, 27 ], 11, 
  13, 13, [ 14, 25 ], 11, 13, [ 14, 31 ], [ 14, 37 ], 11, [ 14, 32 ], 
  [ 14, 33 ], [ 14, 41 ], [ 14, 45 ] ],
#V   n = 50
[ ,,,,,,, [ 14, 4 ], [ 14, 5 ],, [ 14, 7 ], [ 14, 8 ], 11, 13, [ 14, 10 ], 
  11, [ 14, 10 ], [ 14, 11 ], [ 14, 15 ], 11, 13, 13, 13, 11, [ 14, 17 ], 11, 
  [ 14, 22 ], 11, 13, [ 14, 18 ], [ 14, 17 ], 13, [ 14, 21 ], [ 14, 28 ], 11, 
  13, 13, [ 14, 26 ], 11, 13, [ 14, 32 ], [ 14, 38 ], 11, [ 14, 33 ], 
  [ 14, 34 ], [ 14, 42 ], [ 14, 46 ] ],
#V   n = 51
[ ,,,,,,,, 13, [ 14, 6 ],, [ 14, 8 ], [ 14, 9 ], 11, [ 14, 7 ], [ 14, 11 ], 
  11, [ 14, 11 ], [ 14, 12 ], [ 14, 16 ], 11, 13, 13, [ 14, 12 ], 11, 
  [ 14, 18 ], 11, [ 14, 23 ], 13, 13, [ 14, 19 ], [ 14, 18 ], 13, [ 14, 22 ], 
  [ 14, 29 ], 11, 13, 13, [ 14, 27 ], 11, 13, [ 14, 33 ], [ 14, 39 ], 11, 
  [ 14, 34 ], [ 14, 35 ], [ 14, 43 ], [ 14, 47 ] ],
#V   n = 52
[ ,,,,,,,, 13, 13, [ 14, 7 ],, [ 14, 6 ], [ 14, 10 ], 11, [ 14, 8 ], 
  [ 14, 12 ], 11, [ 14, 12 ], [ 14, 13 ], [ 14, 17 ], 11, 13, 13, [ 14, 13 ], 
  11, [ 14, 19 ], 11, [ 0, 11, "AEB" ], 13, 13, [ 14, 20 ], [ 14, 19 ], 13, 
  [ 14, 23 ], [ 14, 30 ], 11, 13, 13, [ 14, 28 ], 11, 13, [ 14, 34 ], 
  [ 14, 40 ], 11, [ 14, 35 ], [ 14, 36 ], [ 14, 44 ], [ 14, 48 ] ],
#V   n = 53
[ ,,,,,, 13,, [ 0, 23, "DEI" ], 13, 13, [ 14, 8 ], [ 14, 6 ], [ 14, 7 ], 
  [ 14, 11 ], 11, [ 14, 9 ], [ 14, 13 ], 11, [ 14, 13 ], [ 14, 14 ], 
  [ 14, 18 ], 11, 13, 13, [ 14, 14 ], 11, [ 14, 20 ], 11, 11, 13, 13, 
  [ 14, 21 ], [ 14, 20 ], 13, [ 14, 24 ], [ 14, 31 ], 11, 13, 13, [ 14, 29 ], 
  11, [ 14, 24 ], [ 14, 35 ], [ 14, 41 ], 11, [ 14, 36 ], [ 14, 37 ], 
  [ 14, 45 ], [ 14, 49 ] ],
#V   n = 54
[ ,,,,,, 13, [ 14, 4 ],, 11, 13, 13, [ 14, 9 ], [ 14, 7 ], [ 14, 8 ], 
  [ 14, 12 ], 11, [ 14, 10 ], [ 14, 14 ], 11, [ 14, 14 ], [ 14, 15 ], 
  [ 14, 19 ], 11, 13, 13, [ 14, 15 ], 11, [ 14, 21 ], 11, 11, 13, 13, 
  [ 14, 22 ], [ 14, 21 ], 13, [ 14, 25 ], [ 14, 32 ], 11, 13, 13, [ 14, 30 ], 
  11, [ 14, 25 ], [ 14, 36 ], [ 14, 42 ], 11, [ 14, 37 ], [ 14, 38 ], 
  [ 14, 46 ], [ 14, 50 ] ],
#V   n = 55
[ ,,,,,, [ 0, 25, "vT4" ], 13, [ 14, 5 ],, 11, 13, 13, [ 14, 10 ], [ 14, 8 ], 
  [ 14, 9 ], [ 14, 13 ], 13, [ 14, 11 ], [ 14, 15 ], 11, [ 14, 10 ], 
  [ 14, 16 ], [ 14, 20 ], 11, 13, 13, [ 14, 16 ], [ 14, 14 ], [ 14, 22 ], 11, 
  11, 13, 13, [ 14, 23 ], [ 14, 22 ], 13, [ 14, 26 ], [ 14, 33 ], 11, 13, 13, 
  [ 14, 31 ], 11, [ 14, 26 ], [ 14, 37 ], [ 14, 43 ], 11, [ 14, 38 ], 
  [ 14, 39 ], [ 14, 47 ], [ 14, 51 ] ],
#V   n = 56
[ ,,,,,, 13, 11, 13, [ 14, 6 ],, 11, 13, [ 14, 7 ], [ 14, 11 ], 13, 
  [ 14, 10 ], [ 0, 19, "AEB" ], 13, [ 14, 12 ], [ 14, 16 ], [ 14, 10 ], 
  [ 14, 11 ], [ 14, 17 ], [ 14, 21 ], 11, 13, 13, [ 14, 14 ], [ 14, 15 ], 
  [ 14, 23 ], 11, 11, 13, 13, [ 14, 24 ], [ 14, 23 ], 13, [ 14, 27 ], 
  [ 14, 34 ], 11, 13, 13, [ 14, 32 ], 11, [ 14, 27 ], [ 14, 38 ], [ 14, 44 ], 
  11, [ 14, 39 ], [ 14, 40 ], [ 14, 48 ], [ 14, 52 ] ],
#V   n = 57
[ ,,,,,, 13, [ 14, 4 ], 11, 13, [ 14, 7 ],, 13, 13, [ 14, 8 ], 13, 13, 
  [ 14, 11 ], 11, 13, [ 14, 13 ], [ 14, 17 ], [ 14, 11 ], [ 14, 12 ], 
  [ 14, 18 ], [ 14, 22 ], 11, 13, 13, [ 14, 15 ], [ 14, 16 ], [ 14, 24 ], 11, 
  11, 13, 13, [ 14, 25 ], [ 14, 24 ], 13, [ 14, 28 ], [ 14, 35 ], 13, 13, 13, 
  [ 14, 33 ], 11, [ 14, 28 ], [ 14, 39 ], [ 14, 45 ], 11, [ 14, 40 ], 
  [ 14, 41 ], [ 14, 49 ], [ 14, 53 ] ],
#V   n = 58
[ ,,,,,, [ 0, 27, "vT3" ], 13, [ 14, 5 ], 13, 13, [ 14, 8 ], [ 0, 23, "HT" ], 
  13, 13, [ 0, 21, "AEB" ], 13, 13, [ 14, 12 ], 11, 13, [ 14, 14 ], 
  [ 14, 18 ], [ 14, 12 ], [ 14, 12 ], [ 14, 19 ], [ 14, 23 ], 11, 13, 13, 
  [ 14, 16 ], [ 14, 17 ], [ 14, 25 ], 11, 11, 13, 13, [ 14, 26 ], 13, 13, 
  [ 14, 29 ], [ 0, 7, "AEB" ], 13, 13, 13, [ 14, 34 ], 11, [ 14, 29 ], 
  [ 14, 40 ], [ 14, 46 ], 11, [ 14, 41 ], [ 14, 42 ], [ 14, 50 ], [ 14, 54 ] 
 ],
#V   n = 59
[ ,,,,,,, 11, 13, [ 14, 4 ], 13, 13, [ 14, 9 ], 11, 13, 13, 11, 13, 13, 
  [ 14, 13 ], 11, 13, [ 14, 15 ], [ 14, 19 ], [ 14, 12 ], [ 14, 13 ], 
  [ 14, 20 ], [ 14, 24 ], [ 14, 14 ], 13, 13, [ 14, 17 ], [ 14, 18 ], 
  [ 14, 26 ], 11, 11, 13, 13, [ 0, 9, "AEB" ], 13, 13, [ 14, 30 ], 11, 13, 
  13, 13, [ 14, 35 ], 11, [ 14, 30 ], [ 14, 41 ], [ 14, 47 ], 11, [ 14, 42 ], 
  [ 14, 43 ], [ 14, 51 ], [ 14, 55 ] ],
#V   n = 60
[ ,,,,,, 13,, 13, 13, [ 14, 5 ], 13, 13, [ 14, 10 ], 11, 13, 13, 11, 13, 13, 
  [ 14, 14 ], 11, 13, [ 14, 16 ], [ 14, 20 ], [ 14, 13 ], [ 14, 14 ], 
  [ 14, 21 ], [ 14, 14 ], 13, 13, 13, [ 14, 18 ], [ 14, 19 ], [ 14, 27 ], 11, 
  11, 13, 13, 11, 13, 13, [ 14, 31 ], 11, 13, 13, 13, [ 14, 36 ], 11, 
  [ 14, 31 ], [ 14, 42 ], [ 14, 48 ], 11, [ 14, 43 ], [ 14, 44 ], [ 14, 52 ], 
  [ 14, 56 ] ],
#V   n = 61
[ ,,,,,, [ 0, 29, "Lv" ], [ 14, 4 ], [ 0, 27, "DEI" ], 13, 13, [ 14, 6 ], 13, 
  [ 14, 7 ], [ 14, 11 ], 13, 13, 13, 11, 13, 13, [ 14, 15 ], 11, 13, 
  [ 14, 17 ], [ 14, 21 ], [ 14, 14 ], [ 14, 15 ], [ 14, 22 ], [ 14, 15 ], 13, 
  13, 13, [ 14, 19 ], [ 14, 20 ], [ 14, 28 ], 11, 11, 13, 13, 11, 13, 13, 
  [ 14, 32 ], 11, 13, 13, [ 14, 25 ], [ 14, 37 ], 11, [ 14, 32 ], [ 14, 43 ], 
  [ 14, 49 ], 11, [ 14, 44 ], [ 14, 45 ], [ 14, 53 ], [ 14, 57 ] ],
#V   n = 62
[ ,,,,,,, 11, [ 14, 5 ], 11, 13, 13, [ 14, 7 ], 13, [ 14, 8 ], 
  [ 0, 23, "AEB" ], 13, 13, 13, 11, 13, 13, [ 14, 16 ], 11, 13, [ 14, 18 ], 
  [ 14, 22 ], [ 14, 15 ], [ 14, 16 ], [ 14, 23 ], [ 14, 16 ], 13, 13, 13, 
  [ 14, 20 ], [ 14, 21 ], [ 14, 29 ], 11, 13, 13, 13, 11, 13, 13, [ 14, 33 ], 
  11, 13, 13, 13, [ 14, 38 ], [ 0, 4, "Joplus" ], [ 14, 33 ], [ 14, 44 ], 
  [ 14, 50 ], 11, [ 14, 45 ], [ 14, 46 ], [ 14, 54 ], [ 14, 58 ] ],
#V   n = 63
[ ,,,,,,,, 13, [ 14, 6 ], 11, 13, 13, [ 14, 8 ], 13, [ 14, 9 ], 11, 13, 13, 
  13, 11, 13, 13, [ 14, 17 ], 11, [ 14, 12 ], [ 14, 19 ], [ 14, 23 ], 
  [ 14, 16 ], [ 14, 17 ], [ 14, 24 ], [ 14, 17 ], 13, 13, 13, [ 14, 21 ], 
  [ 14, 22 ], [ 14, 30 ], [ 0, 11, "AEB" ], 13, 13, 13, 11, 13, 13, 
  [ 14, 34 ], 11, 13, 13, 13, 12, 11, [ 14, 34 ], [ 14, 45 ], [ 14, 51 ], 11, 
  [ 14, 46 ], [ 14, 47 ], [ 14, 55 ], [ 14, 59 ] ],
#V   n = 64
[ ,,,,,,, [ 14, 4 ], 13, 13, [ 14, 7 ], 11, 13, [ 14, 7 ], [ 14, 6 ], 13, 
  [ 14, 10 ], 11, 13, 13, 13, 11, 13, [ 14, 11 ], [ 14, 18 ], 13, [ 14, 13 ], 
  [ 14, 20 ], [ 14, 24 ], [ 14, 17 ], [ 14, 18 ], [ 14, 25 ], [ 14, 18 ], 13, 
  13, 13, [ 14, 22 ], [ 14, 23 ], [ 14, 31 ], 11, 13, 13, 13, 11, 13, 
  [ 14, 23 ], [ 14, 35 ], 11, 13, 13, [ 14, 28 ], 12, 11, [ 14, 35 ], 
  [ 14, 46 ], [ 14, 52 ], 11, [ 14, 32 ], [ 14, 48 ], [ 14, 56 ], [ 14, 60 ] 
 ],
#V   n = 65
[ ,,,,,,, 13, [ 0, 29, "DEI" ], 13, [ 14, 4 ], [ 14, 8 ], 13, 13, [ 14, 6 ], 
  13, 13, [ 14, 11 ], 11, 13, 13, 13, 11, 13, [ 14, 12 ], [ 0, 19, "AEB" ], 
  13, 13, [ 14, 21 ], [ 14, 25 ], [ 14, 18 ], [ 14, 19 ], [ 14, 26 ], 
  [ 14, 19 ], 13, 13, 13, [ 14, 23 ], [ 14, 24 ], [ 14, 32 ], 11, 13, 13, 13, 
  11, 13, 13, [ 14, 36 ], 11, 13, 13, [ 14, 29 ], 12, 11, [ 14, 36 ], 
  [ 14, 47 ], [ 14, 53 ], [ 14, 32 ], [ 14, 33 ], [ 14, 49 ], [ 14, 57 ], 
  [ 14, 61 ] ],
#V   n = 66
[ ,,,,,,, 13, 13, 11, 13, 13, [ 0, 27, "Das" ], 13, 13, [ 14, 7 ], 13, 13, 
  [ 14, 12 ], 11, 13, 13, 13, 11, 13, [ 14, 13 ], 11, 13, [ 14, 15 ], 
  [ 14, 22 ], [ 14, 26 ], [ 14, 19 ], [ 14, 20 ], [ 14, 27 ], [ 14, 20 ], 13, 
  13, 13, [ 14, 24 ], [ 14, 25 ], [ 14, 33 ], 11, 13, 13, 13, 11, 13, 
  [ 14, 25 ], [ 14, 37 ], 11, 13, 13, [ 14, 30 ], 12, 11, [ 14, 37 ], 
  [ 14, 48 ], [ 14, 54 ], [ 14, 33 ], [ 14, 34 ], [ 14, 50 ], [ 14, 58 ], 
  [ 14, 62 ] ],
#V   n = 67
[ ,,,,,,, [ 0, 31, "DH" ], 13, 13, 11, 13, [ 14, 6 ], 11, 13, 13, [ 14, 8 ], 
  13, 13, [ 14, 13 ], 11, 13, 13, [ 14, 11 ], 11, 13, [ 14, 14 ], 11, 13, 
  [ 14, 16 ], [ 14, 23 ], [ 14, 27 ], [ 14, 20 ], [ 14, 21 ], [ 14, 28 ], 
  [ 14, 21 ], 13, 13, 13, 13, [ 14, 26 ], [ 14, 34 ], 11, 13, 13, [ 14, 23 ], 
  11, 13, 13, [ 14, 38 ], 11, 13, 13, [ 14, 31 ], 12, 11, [ 14, 38 ], 
  [ 14, 49 ], [ 14, 55 ], [ 14, 34 ], [ 14, 35 ], [ 14, 51 ], [ 14, 59 ], 
  [ 14, 63 ] ],
#V   n = 68
[ ,,,,,,,, 11, 13, [ 14, 4 ], 11, 13, [ 14, 7 ], 11, 13, 13, [ 14, 9 ], 13, 
  13, [ 14, 14 ], 11, 13, 13, [ 14, 12 ], 13, 13, [ 14, 15 ], 11, 13, 
  [ 14, 17 ], [ 14, 24 ], [ 14, 28 ], [ 14, 21 ], [ 14, 22 ], [ 14, 29 ], 
  [ 14, 22 ], 13, 13, [ 0, 13, "AEB" ], 13, [ 14, 27 ], [ 14, 35 ], 11, 13, 
  13, 13, 11, 13, 13, [ 14, 39 ], 11, 13, 13, [ 14, 32 ], [ 14, 29 ], 11, 
  [ 14, 39 ], [ 14, 50 ], [ 14, 56 ], [ 14, 35 ], [ 14, 36 ], [ 14, 52 ], 
  [ 14, 60 ], [ 14, 64 ] ],
#V   n = 69
[ ,,,,,,,,, 13, 13, 13, 11, 13, [ 14, 8 ], 11, 13, 13, [ 14, 10 ], 13, 13, 
  [ 14, 15 ], 11, 13, 13, [ 0, 21, "AEB" ], 13, 13, [ 14, 16 ], 11, 13, 
  [ 14, 18 ], [ 14, 25 ], [ 14, 29 ], [ 14, 22 ], [ 14, 23 ], [ 14, 30 ], 13, 
  13, 13, 11, 13, [ 14, 28 ], [ 14, 36 ], 11, 13, 13, [ 14, 25 ], 11, 13, 
  [ 14, 28 ], [ 14, 40 ], 11, 13, 13, [ 14, 33 ], 12, 11, [ 14, 40 ], 
  [ 14, 51 ], [ 14, 57 ], [ 14, 36 ], [ 14, 37 ], [ 14, 53 ], [ 14, 61 ], 
  [ 14, 65 ] ],
#V   n = 70
[ ,,,,,,,,, [ 0, 31, "HT" ], 13, 13, [ 14, 6 ], [ 14, 6 ], 13, [ 14, 9 ], 11, 
  13, 13, [ 14, 11 ], 13, 13, [ 14, 16 ], 11, 13, 13, 11, 13, 13, [ 14, 17 ], 
  11, 13, [ 14, 19 ], [ 14, 26 ], [ 14, 30 ], [ 14, 23 ], [ 14, 24 ], 
  [ 0, 15, "AEB" ], 13, 13, 13, 11, 13, [ 14, 29 ], [ 14, 37 ], 11, 13, 13, 
  13, [ 0, 8, "Joplus" ], 13, [ 14, 29 ], [ 14, 41 ], 11, 13, 13, [ 14, 34 ], 
  12, 11, [ 14, 41 ], [ 14, 52 ], [ 14, 58 ], [ 14, 37 ], [ 14, 38 ], 
  [ 14, 54 ], [ 14, 62 ], [ 14, 66 ] ],
#V   n = 71
[ ,,,,,,,,,, 11, 13, 13, [ 14, 6 ], 13, 13, [ 14, 10 ], 13, 13, 13, 
  [ 14, 12 ], 13, 13, [ 14, 17 ], 11, 13, 13, 11, 13, 13, [ 14, 18 ], 11, 13, 
  [ 14, 20 ], [ 14, 27 ], [ 14, 31 ], 13, [ 14, 25 ], 11, 13, 13, 13, 11, 13, 
  [ 14, 30 ], [ 14, 38 ], 11, 13, 13, 12, 11, 13, [ 14, 30 ], [ 14, 42 ], 13, 
  13, 13, [ 14, 35 ], [ 14, 32 ], 11, [ 14, 42 ], [ 14, 53 ], [ 14, 59 ], 
  [ 14, 38 ], [ 14, 39 ], [ 14, 55 ], [ 14, 63 ], [ 14, 67 ] ],
#V   n = 72
[ ,,,,,,,, [ 14, 4 ],,, 11, 13, 13, 13, 13, [ 14, 7 ], [ 0, 27, "AEB" ], 13, 
  13, 13, [ 14, 13 ], 13, [ 14, 11 ], [ 14, 18 ], 13, 13, 13, 11, 13, 13, 
  [ 14, 19 ], 11, 13, [ 14, 21 ], [ 14, 28 ], 13, 13, [ 14, 26 ], 11, 13, 13, 
  13, 11, 13, [ 14, 31 ], [ 14, 39 ], 13, 13, 13, 12, 11, 13, [ 14, 31 ], 
  [ 0, 7, "LP" ], 13, 13, 13, [ 14, 36 ], [ 14, 33 ], 11, [ 14, 43 ], 
  [ 14, 54 ], [ 14, 60 ], [ 14, 39 ], [ 14, 40 ], [ 14, 56 ], [ 14, 64 ], 
  [ 14, 68 ] ],
#V   n = 73
[ ,,,,,, 13,, [ 14, 4 ], [ 14, 5 ],,, 11, 13, [ 0, 29, "AEB" ], 13, 13, 
  [ 14, 8 ], 11, 13, 13, 13, 13, 13, [ 14, 12 ], [ 0, 23, "AEB" ], 13, 13, 
  13, 11, 13, 13, [ 14, 20 ], 13, 13, [ 14, 22 ], [ 0, 17, "AEB" ], 13, 13, 
  [ 14, 27 ], 11, 13, 13, 13, 11, 13, [ 14, 32 ], [ 0, 11, "LP" ], 13, 13, 
  13, 12, 11, 13, [ 14, 32 ], 11, 13, 13, 13, [ 14, 37 ], [ 14, 34 ], 11, 
  [ 14, 44 ], [ 14, 55 ], [ 14, 61 ], [ 14, 40 ], [ 14, 41 ], [ 14, 57 ], 
  [ 14, 65 ], [ 14, 69 ] ],
#V   n = 74
[ ,,,,,, [ 0, 35, "vT2" ], 13,, [ 14, 5 ], [ 14, 6 ],,, 13, 13, 11, 13, 13, 
  [ 14, 9 ], 11, 13, 13, [ 0, 25, "AEB" ], 13, 13, [ 14, 13 ], 11, 13, 13, 
  13, 11, 13, 13, [ 0, 19, "AEB" ], 13, 13, [ 14, 23 ], 11, 13, 13, 
  [ 14, 28 ], 11, 13, 13, 13, 11, 13, [ 14, 33 ], 11, 13, 13, 13, 12, 11, 13, 
  [ 14, 33 ], 11, 13, 13, 13, [ 14, 38 ], [ 14, 35 ], 11, [ 14, 45 ], 
  [ 14, 56 ], [ 14, 62 ], [ 14, 41 ], [ 14, 42 ], [ 14, 58 ], [ 14, 66 ], 
  [ 14, 70 ] ],
#V   n = 75
[ ,,,,,,, 11, [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ],, [ 0, 31, "HT" ], 13, 13, 11, 
  13, 13, [ 14, 10 ], 11, 13, 13, 11, 13, 13, [ 14, 14 ], 11, 13, 13, 13, 11, 
  13, 13, 11, 13, 13, [ 14, 24 ], 11, 13, 13, [ 14, 29 ], 11, 13, 13, 13, 13, 
  13, [ 14, 34 ], 11, 13, 13, 13, 12, 11, 13, [ 14, 34 ], 11, 13, 13, 13, 
  [ 14, 39 ], [ 14, 36 ], 11, [ 14, 46 ], [ 14, 57 ], [ 14, 63 ], [ 14, 42 ], 
  [ 14, 43 ], [ 14, 59 ], [ 14, 67 ], [ 14, 71 ] ],
#V   n = 76
[ ,,,,,,,, 11, [ 14, 5 ],, [ 14, 7 ], [ 14, 8 ],, 11, 13, 13, 11, 13, 13, 
  [ 14, 11 ], 13, 13, 13, 11, 13, 13, [ 14, 15 ], 11, 13, 13, 13, 13, 13, 13, 
  11, 13, 13, [ 14, 25 ], 11, 13, 13, [ 14, 30 ], 11, 13, 13, [ 0, 13, "LP" ],
  13, 13, [ 14, 35 ], 11, 13, 13, 13, 12, 11, 13, [ 14, 35 ], 11, 13, 13, 13, 
  [ 14, 40 ], [ 14, 37 ], 11, [ 14, 47 ], [ 14, 58 ], [ 14, 64 ], [ 14, 43 ], 
  [ 14, 44 ], [ 14, 60 ], [ 14, 68 ], [ 14, 72 ] ],
#V   n = 77
[ ,,,,,,,,, 13, [ 14, 6 ],, [ 14, 8 ], [ 14, 9 ],, 13, 13, 13, 11, 13, 13, 
  [ 0, 27, "AEB" ], 13, 13, 13, 11, 13, 13, [ 14, 16 ], 11, 13, 13, 
  [ 0, 21, "AEB" ], 13, 13, 13, 11, 13, 13, [ 14, 26 ], 11, 13, 13, 
  [ 14, 31 ], 11, 13, 13, 11, 13, 13, [ 14, 36 ], 11, 13, 13, 13, 12, 11, 13, 
  [ 14, 36 ], 11, 13, 13, 13, [ 14, 41 ], [ 14, 38 ], 11, [ 14, 48 ], 
  [ 14, 59 ], [ 14, 65 ], [ 14, 44 ], [ 14, 45 ], [ 14, 61 ], [ 14, 69 ], 
  [ 14, 73 ] ],
#V   n = 78
[ ,,,,,,,,, [ 14, 4 ], 13, [ 14, 7 ],, [ 14, 6 ], [ 14, 10 ], 
  [ 0, 31, "AEB" ], 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  [ 14, 17 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, [ 14, 27 ], 11, 13, 13, 
  [ 14, 32 ], 11, 13, 13, 11, 13, 13, [ 14, 37 ], 11, 13, 13, 13, 12, 11, 13, 
  [ 14, 37 ], 11, 13, 13, 13, [ 14, 42 ], [ 14, 39 ], 11, [ 14, 49 ], 
  [ 14, 60 ], [ 14, 66 ], [ 14, 45 ], [ 14, 46 ], [ 14, 62 ], [ 14, 70 ], 
  [ 14, 74 ] ],
#V   n = 79
[ ,,,,,,,, [ 14, 4 ],, [ 14, 5 ], 13, [ 14, 8 ], [ 14, 6 ], [ 14, 7 ], 
  [ 14, 11 ], 11, 13, 13, [ 0, 29, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, [ 0, 23, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  [ 14, 28 ], 13, 13, 13, [ 14, 33 ], 11, 13, 13, 11, 13, 13, [ 14, 38 ], 11, 
  13, 13, 13, 12, 11, 13, [ 14, 38 ], 11, 13, 13, 13, [ 14, 43 ], [ 14, 40 ], 
  11, [ 14, 50 ], [ 14, 61 ], [ 14, 67 ], [ 14, 46 ], [ 14, 47 ], [ 14, 63 ], 
  [ 14, 71 ], [ 14, 75 ] ],
#V   n = 80
[ ,,,,,,,, [ 14, 4 ], [ 14, 5 ],, [ 14, 6 ], 13, [ 14, 9 ], [ 14, 7 ], 
  [ 14, 8 ], [ 14, 12 ], 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, [ 0, 17, "LP" ], 13, 13, 
  13, [ 14, 34 ], 13, 13, 13, 11, 13, 13, [ 14, 39 ], 11, 13, 13, 13, 12, 11, 
  13, [ 14, 39 ], 11, 13, 13, 13, [ 14, 44 ], [ 14, 41 ], 11, [ 14, 51 ], 
  [ 14, 62 ], [ 14, 68 ], [ 14, 47 ], [ 14, 48 ], [ 14, 64 ], [ 14, 72 ], 
  [ 14, 76 ] ],
#V   n = 81
[ ,,,,,,, 13,, [ 14, 5 ], [ 14, 6 ],, 13, 13, [ 14, 10 ], [ 14, 8 ], 
  [ 14, 9 ], [ 14, 13 ], 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, [ 14, 23 ], 
  [ 0, 15, "LP" ], 13, 13, 13, 11, 13, 13, [ 14, 40 ], 11, 13, 13, 13, 12, 
  11, 13, [ 14, 40 ], 11, 13, 13, 13, [ 14, 45 ], [ 14, 42 ], 11, [ 14, 52 ], 
  [ 14, 63 ], [ 14, 69 ], [ 14, 48 ], [ 14, 49 ], [ 14, 65 ], [ 14, 73 ], 
  [ 14, 77 ] ],
#V   n = 82
[ ,,,,,,, 13, [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ], [ 0, 35, "HT" ], 13, 
  [ 14, 7 ], [ 14, 11 ], [ 14, 9 ], [ 14, 10 ], [ 14, 14 ], 13, 13, 13, 11, 
  13, 13, 13, 13, 13, 13, [ 0, 25, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 11, 13, 13, [ 14, 24 ], 11, 13, 13, 13, 11, 13, 13, 
  [ 14, 41 ], 13, 13, 13, 13, 12, 11, 13, [ 14, 41 ], 11, 13, 13, 13, 
  [ 14, 46 ], [ 14, 43 ], 11, [ 14, 53 ], [ 14, 64 ], [ 14, 70 ], [ 14, 49 ], 
  [ 14, 50 ], [ 14, 66 ], [ 14, 74 ], [ 14, 78 ] ],
#V   n = 83
[ ,,,,,,, [ 0, 39, "DH" ], 13, [ 14, 5 ],, [ 14, 7 ], [ 14, 8 ], 11, 13, 
  [ 14, 8 ], [ 14, 12 ], [ 14, 10 ], [ 14, 11 ], [ 0, 31, "AEB" ], 13, 13, 
  13, 13, 13, 13, [ 0, 27, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, [ 14, 25 ], 11, 13, 13, 13, 11, 
  13, [ 14, 27 ], [ 0, 11, "LP" ], 13, 13, 13, 13, [ 0, 8, "Joplus" ], 11, 
  13, [ 14, 42 ], 11, 13, 13, 13, [ 14, 47 ], [ 14, 44 ], 11, [ 14, 54 ], 
  [ 14, 65 ], [ 14, 71 ], [ 14, 50 ], [ 14, 51 ], [ 14, 67 ], [ 14, 75 ], 
  [ 14, 79 ] ],
#V   n = 84
[ ,,,,,,,, 11, 13, [ 14, 6 ],, [ 14, 8 ], [ 14, 9 ], 11, 13, [ 14, 9 ], 
  [ 14, 13 ], 13, [ 14, 12 ], 11, 13, 13, [ 0, 29, "AEB" ], 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, [ 0, 19, "LP" ], 
  13, 13, 13, 11, 13, 13, [ 14, 26 ], 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  13, 12, 11, 11, 13, [ 14, 43 ], 11, 13, 13, 13, [ 14, 48 ], [ 14, 45 ], 11, 
  [ 14, 55 ], [ 14, 66 ], [ 14, 72 ], [ 14, 51 ], [ 14, 52 ], [ 14, 68 ], 
  [ 14, 76 ], [ 14, 80 ] ],
#V   n = 85
[ ,,,,,, 13,,, 13, 13, [ 14, 7 ],, [ 14, 6 ], [ 14, 10 ], 13, 13, [ 14, 10 ], 
  13, 13, [ 14, 13 ], 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, [ 0, 21, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  [ 14, 27 ], 11, 13, 13, 13, 11, 13, [ 14, 29 ], 11, 13, 13, 13, 12, 11, 11, 
  13, [ 14, 44 ], 11, 13, 13, 13, [ 14, 49 ], [ 14, 46 ], 11, [ 14, 56 ], 
  [ 14, 67 ], [ 14, 73 ], [ 14, 52 ], [ 14, 53 ], [ 14, 69 ], [ 14, 77 ], 
  [ 14, 81 ] ],
#V   n = 86
[ ,,,,,, [ 0, 41, "vT2" ], 13,, [ 0, 39, "HT" ], 13, 13, [ 14, 8 ], 
  [ 14, 6 ], [ 14, 7 ], [ 0, 35, "AEB" ], 13, 13, [ 0, 33, "AEB" ], 13, 13, 
  [ 14, 14 ], 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, [ 14, 23 ], 11, 13, 13, [ 14, 28 ], 11, 
  13, 13, 13, [ 0, 12, "Joplus" ], 13, [ 14, 30 ], 11, 13, 13, 13, 12, 11, 
  11, 13, [ 14, 45 ], 11, 13, 13, 13, [ 14, 50 ], [ 14, 47 ], 11, [ 14, 57 ], 
  [ 14, 68 ], [ 14, 74 ], [ 14, 53 ], [ 14, 54 ], [ 14, 70 ], [ 14, 78 ], 
  [ 14, 82 ] ],
#V   n = 87
[ ,,,,,,, 11, [ 14, 4 ],, 11, 13, 13, [ 14, 9 ], 13, [ 14, 8 ], 11, 13, 13, 
  11, 13, 13, [ 14, 15 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, [ 0, 23, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, [ 14, 24 ], 
  11, 13, 13, [ 14, 29 ], 11, 13, 13, 12, 11, 13, [ 14, 31 ], 11, 13, 13, 13, 
  12, 11, 11, 13, [ 14, 46 ], 11, 13, 13, 13, [ 14, 51 ], [ 14, 48 ], 11, 
  [ 14, 58 ], [ 14, 69 ], [ 14, 75 ], [ 14, 54 ], [ 14, 55 ], [ 14, 71 ], 
  [ 14, 79 ], [ 14, 83 ] ],
#V   n = 88
[ ,,,,,, 13,, 11, [ 14, 5 ],, 11, 13, 13, 13, 13, [ 14, 9 ], 11, 13, 13, 11, 
  13, 13, [ 0, 31, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, [ 14, 25 ], 11, 13, 13, 
  [ 14, 30 ], 13, 13, 13, 12, 11, 13, [ 14, 32 ], 11, 13, 13, 13, 12, 11, 11, 
  13, [ 14, 47 ], 11, 13, 13, 13, [ 14, 52 ], [ 14, 49 ], 11, [ 14, 59 ], 
  [ 14, 70 ], [ 14, 76 ], [ 14, 55 ], [ 14, 56 ], [ 14, 72 ], [ 14, 80 ], 
  [ 14, 84 ] ],
#V   n = 89
[ ,,,,,, [ 0, 43, "vT2" ], 13,, 13, [ 14, 6 ],, 13, 13, [ 0, 37, "AEB" ], 13, 
  13, [ 14, 10 ], 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, [ 0, 25, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, [ 14, 26 ], 11, 13, 13, [ 0, 15, "LP" ], 13, 13, 13, 12, 11, 13, 
  [ 14, 33 ], 11, 13, 13, 13, 12, 11, 11, 13, [ 14, 48 ], 11, 13, 13, 13, 
  [ 14, 53 ], 13, 11, [ 14, 60 ], [ 14, 71 ], [ 14, 77 ], [ 14, 56 ], 
  [ 14, 57 ], [ 14, 73 ], [ 14, 81 ], [ 14, 85 ] ],
#V   n = 90
[ ,,,,,,, 13, [ 14, 4 ], [ 14, 4 ], 13, [ 14, 7 ], [ 0, 39, "HT" ], 13, 13, 
  11, 13, 13, [ 0, 35, "LP" ], 13, 13, 13, 11, 13, [ 14, 11 ], 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 13, 13, 13, [ 14, 27 ], 13, 13, 13, 11, 13, 13, 13, 12, 11, 13, 
  [ 14, 34 ], 11, 13, 13, 13, 12, 11, 11, 13, [ 14, 49 ], 11, 13, 13, 13, 
  [ 0, 5, "LP" ], 13, 11, [ 14, 61 ], [ 14, 72 ], [ 14, 78 ], [ 14, 57 ], 
  [ 14, 58 ], [ 14, 74 ], [ 14, 82 ], [ 14, 86 ] ],
#V   n = 91
[ ,,,,,,, [ 0, 43, "DH" ], 13, [ 14, 5 ], [ 14, 5 ], 13, [ 14, 8 ], 11, 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 13, 13, [ 14, 12 ], 11, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  [ 0, 19, "LP" ], 13, 13, 13, [ 0, 17, "Jo2" ], 13, 13, 13, 11, 13, 13, 13, 
  12, 11, 13, [ 14, 35 ], 11, 13, 13, 13, 12, 11, 11, 13, [ 14, 50 ], 
  [ 0, 6, "Joplus" ], 13, 13, 13, 11, 13, 11, [ 14, 62 ], [ 14, 73 ], 
  [ 14, 79 ], [ 14, 58 ], [ 14, 59 ], [ 14, 75 ], [ 14, 83 ], [ 14, 87 ] ],
#V   n = 92
[ ,,,,,,,, 11, 13, [ 14, 6 ], [ 14, 6 ], [ 14, 5 ], [ 14, 9 ], 13, 13, 13, 
  13, 13, 13, 13, 13, 13, [ 0, 33, "AEB" ], 13, 13, [ 14, 13 ], 11, 13, 13, 
  [ 0, 29, "AEB" ], 13, 13, 13, [ 0, 27, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  12, 11, 13, [ 14, 36 ], 11, 13, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 13, 
  11, 13, 11, [ 14, 63 ], [ 14, 74 ], [ 14, 80 ], [ 14, 59 ], [ 14, 60 ], 
  [ 14, 76 ], [ 14, 84 ], [ 14, 88 ] ],
#V   n = 93
[ ,,,,,,, 13,, 13, 13, [ 14, 7 ], 13, 13, [ 0, 39, "AEB" ], 13, 13, 
  [ 0, 37, "AEB" ], 13, 13, [ 0, 35, "AEB" ], 13, 13, 13, 11, 13, 13, 
  [ 14, 14 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 12, 
  11, 13, [ 14, 37 ], 11, 13, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 13, 11, 
  13, 11, [ 14, 64 ], [ 14, 75 ], [ 14, 81 ], [ 14, 60 ], [ 14, 61 ], 
  [ 14, 77 ], [ 14, 85 ], [ 14, 89 ] ],
#V   n = 94
[ ,,,,,,, 13, [ 14, 4 ], [ 0, 43, "DEI" ], 13, 13, [ 0, 41, "DK" ], 13, 
  [ 14, 7 ], 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  [ 0, 31, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 12, 11, 13, [ 14, 38 ], 11, 13, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 
  13, 11, 13, 11, [ 14, 65 ], [ 14, 76 ], [ 14, 82 ], [ 14, 61 ], [ 14, 62 ], 
  [ 14, 78 ], [ 14, 86 ], [ 14, 90 ] ],
#V   n = 95
[ ,,,,,,, [ 0, 45, "DH" ], 13, [ 14, 5 ], 13, 13, [ 14, 5 ], 11, 13, 
  [ 14, 8 ], 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  [ 0, 21, "LP" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 12, 11, 13, [ 14, 39 ], 13, 13, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 
  13, 11, 13, 11, [ 14, 66 ], [ 14, 77 ], [ 14, 83 ], [ 14, 62 ], [ 14, 63 ], 
  [ 14, 79 ], [ 14, 87 ], [ 14, 91 ] ],
#V   n = 96
[ ,,,,,,, 13, 11, 13, [ 0, 43, "AEB" ], 13, 13, 13, 13, 13, [ 14, 9 ], 11, 
  13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 13, 13, 13, [ 0, 23, "LP" ], 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 
  [ 0, 11, "LP" ], 13, 13, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 13, 11, 
  13, 11, [ 14, 67 ], [ 14, 78 ], [ 14, 84 ], [ 14, 63 ], [ 14, 64 ], 
  [ 14, 80 ], [ 14, 88 ], [ 14, 92 ] ],
#V   n = 97
[ ,,,,,,, 13, [ 14, 4 ], 11, 13, 11, 13, 13, [ 0, 41, "AEB" ], 13, 13, 
  [ 14, 10 ], 13, 13, [ 0, 37, "AEB" ], 13, 13, 13, 13, 13, 13, 
  [ 0, 33, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  [ 0, 25, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 13, 13, 13, [ 0, 13, "LP" ], 13, 11, 13, 11, 13, 13, 
  13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 13, 11, 13, 11, [ 14, 68 ], 
  [ 14, 79 ], [ 14, 85 ], [ 14, 64 ], [ 14, 65 ], [ 14, 81 ], [ 14, 89 ], 
  [ 14, 93 ] ],
#V   n = 98
[ ,,,,,,, [ 0, 47, "DM" ], 13, [ 14, 5 ], 13, 13, 11, 13, 13, 11, 13, 13, 
  [ 0, 39, "AEB" ], 13, 13, 11, 13, 13, [ 0, 35, "AEB" ], 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, [ 0, 27, "AEB" ], 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  [ 0, 15, "LP" ], 13, 13, 13, 11, 13, 11, 13, 11, 13, 13, 13, 13, 12, 11, 
  11, 13, 12, 11, 13, 13, 13, 11, 13, 11, [ 14, 69 ], [ 14, 80 ], [ 14, 86 ], 
  [ 14, 65 ], [ 14, 66 ], [ 14, 82 ], [ 14, 90 ], [ 14, 94 ] ],
#V   n = 99
[ ,,,,,,,, 13, 13, [ 14, 4 ], 13, [ 14, 5 ], 11, 13, 13, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 11, 13, 11, 13, 13, 13, 13, 13, 11, 
  11, 13, 12, 11, 13, 13, 13, 11, 13, 11, [ 14, 70 ], [ 14, 81 ], [ 14, 87 ], 
  [ 14, 66 ], [ 14, 67 ], [ 14, 83 ], [ 14, 91 ], [ 14, 95 ] ],
#V   n = 100
[ ,,,,,,,, [ 0, 47, "AEB" ], 13, 13, [ 14, 5 ], 13, 13, 13, 13, 
  [ 0, 41, "AEB" ], 13, 13, [ 14, 8 ], 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, [ 0, 31, "AEB" ], 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 11, 13, 11, 13, 11, 13, 13, 13, [ 0, 9, "LP" ], 13, 11, 
  11, 13, 12, 11, 13, 13, 13, 11, 13, 11, [ 14, 71 ], [ 14, 82 ], [ 14, 88 ], 
  [ 14, 67 ], [ 14, 68 ], [ 14, 84 ], [ 14, 92 ], [ 14, 96 ] ],
#V   n = 101
[ ,,,,,,,,, 13, 13, 13, [ 14, 6 ], 13, [ 0, 43, "AEB" ], 13, 13, 11, 13, 13, 
  [ 0, 39, "AEB" ], 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 
  13, 13, 13, [ 0, 29, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, [ 0, 19, "Jo2" ], 13, 13, 13, 13, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 11, 13, 12, 11, 
  13, 13, 13, 11, 13, 11, [ 14, 72 ], [ 14, 83 ], [ 14, 89 ], [ 14, 68 ], 
  [ 14, 69 ], [ 14, 85 ], [ 14, 93 ], [ 14, 97 ] ],
#V   n = 102
[ ,,,,,,,,, [ 0, 47, "DK" ], 13, 13, [ 14, 5 ], [ 14, 7 ], 13, 11, 13, 13, 
  11, 13, 13, 11, 13, 13, [ 0, 37, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 13, 13, 13, 11, 13, 13, 13, [ 0, 17, "LP" ], 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 11, 13, 12, 11, 13, 
  13, 13, 11, 13, 11, [ 14, 73 ], [ 14, 84 ], [ 14, 90 ], [ 14, 69 ], 
  [ 14, 70 ], [ 14, 86 ], [ 14, 94 ], [ 14, 98 ] ],
#V   n = 103
[ ,,,,,,,, [ 14, 4 ],, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 
  13, 13, 11, 13, 13, 13, 13, 13, 13, [ 0, 33, "AEB" ], 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  [ 0, 21, "LP" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 11, 13, 12, 11, 13, 13, 13, 
  11, 13, 11, [ 14, 74 ], [ 14, 85 ], [ 14, 91 ], [ 14, 70 ], [ 14, 71 ], 
  [ 14, 87 ], [ 14, 95 ], [ 14, 99 ] ],
#V   n = 104
[ ,,,,,,,, [ 14, 4 ], [ 14, 5 ],, 11, 13, 13, 13, 13, [ 0, 43, "AEB" ], 13, 
  13, [ 0, 41, "AEB" ], 13, 13, 13, 11, 13, 13, 11, 13, 13, [ 0, 35, "AEB" ], 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 11, 13, 12, 11, 
  13, 13, 13, 11, 13, 11, [ 14, 75 ], [ 14, 86 ], [ 14, 92 ], [ 14, 71 ], 
  [ 14, 72 ], [ 14, 88 ], [ 14, 96 ], [ 14, 100 ] ],
#V   n = 105
[ ,,,,,,,,, [ 14, 5 ], [ 14, 6 ],, 13, 13, [ 0, 45, "AEB" ], 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, [ 0, 23, "LP" ],
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 11, 13, 12, 11, 13, 13, 13, 11, 
  13, 11, [ 14, 76 ], [ 14, 87 ], [ 14, 93 ], [ 14, 72 ], [ 14, 73 ], 
  [ 14, 89 ], [ 14, 97 ], [ 14, 101 ] ],
#V   n = 106
[ ,,,,,,,, [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ], [ 0, 47, "AEB" ], 13, 13, 13, 
  13, 13, 11, 13, 13, 11, 13, 13, [ 0, 39, "AEB" ], 13, 13, 13, 11, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 11, 13, 12, 
  11, 13, 13, 13, 11, 13, 11, [ 14, 77 ], [ 14, 88 ], [ 14, 94 ], [ 14, 73 ], 
  [ 14, 74 ], [ 14, 90 ], [ 14, 98 ], [ 14, 102 ] ],
#V   n = 107
[ ,,,,,,,, [ 14, 4 ], [ 14, 5 ],, [ 14, 4 ], [ 14, 8 ], 11, 13, 
  [ 0, 45, "AEB" ], 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  [ 0, 27, "LP" ], 13, 13, 13, [ 0, 25, "LP" ], 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 11, 
  13, 11, 13, 13, 13, 11, 13, 11, 11, 13, 12, 11, 13, 13, 13, 11, 13, 11, 
  [ 14, 78 ], [ 14, 89 ], [ 14, 95 ], [ 14, 74 ], [ 14, 75 ], [ 14, 91 ], 
  [ 14, 99 ], [ 14, 103 ] ],
#V   n = 108
[ ,,,,,,,,, [ 14, 5 ], [ 14, 6 ], [ 14, 4 ], [ 14, 5 ], [ 14, 9 ], 13, 13, 
  11, 13, 13, [ 0, 43, "AEB" ], 13, 13, 13, 13, 13, 13, 11, 13, 13, 
  [ 0, 37, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  [ 0, 29, "LP" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  [ 0, 13, "LP" ], 13, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 11, 13, 12, 
  11, 13, 13, 13, 11, 13, 11, [ 14, 79 ], [ 14, 90 ], [ 14, 96 ], [ 14, 75 ], 
  [ 14, 76 ], [ 14, 92 ], [ 14, 100 ], [ 14, 104 ] ],
#V   n = 109
[ ,,,,,,,,,, [ 14, 6 ], [ 14, 7 ], [ 14, 5 ], 11, [ 0, 47, "AEB" ], 13, 13, 
  11, 13, 13, 11, 13, 13, [ 0, 41, "AEB" ], 13, 13, 13, 11, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, [ 0, 33, "AEB" ], 13, 13, 13, [ 0, 31, "AEB" ], 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, [ 0, 15, "LP" ], 13, 13, 13, 11, 13, 
  13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 11, [ 14, 45 ], 12, 11, 13, 13, 13, 
  11, 13, 11, [ 14, 80 ], [ 14, 91 ], [ 14, 97 ], [ 14, 76 ], [ 14, 77 ], 
  [ 14, 93 ], [ 14, 101 ], [ 14, 105 ] ],
#V   n = 110
[ ,,,,,,,, [ 14, 4 ],,, 13, [ 14, 8 ], 11, [ 14, 7 ], 13, 13, 13, 11, 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 11, 13, [ 0, 10, "Joplus" ], 13, 13, 13, 11, 13, 11, 11, 
  [ 14, 46 ], 12, 11, 13, 13, 13, 11, 13, 11, [ 14, 81 ], [ 14, 92 ], 
  [ 14, 98 ], [ 14, 77 ], [ 14, 78 ], [ 14, 94 ], [ 14, 102 ], [ 14, 106 ] ],
#V   n = 111
[ ,,,,,,,, [ 14, 4 ], [ 14, 5 ],, 13, [ 14, 5 ], [ 14, 9 ], 13, 
  [ 0, 47, "AEB" ], 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  [ 0, 39, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  [ 0, 21, "LP" ], 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 11, 12, 11, 13, 13, 13, 11, 13, 11, 11, [ 14, 47 ], 12, 11, 
  13, 13, 13, 11, 13, 11, [ 14, 82 ], [ 14, 93 ], [ 14, 99 ], [ 14, 78 ], 
  [ 14, 79 ], [ 14, 95 ], [ 14, 103 ], [ 14, 107 ] ],
#V   n = 112
[ ,,,,,,,,, [ 14, 5 ], [ 14, 6 ], 13, 13, 13, 13, 13, 11, 13, 13, 
  [ 0, 45, "AEB" ], 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 
  13, 13, [ 0, 35, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 
  13, 13, 13, [ 0, 17, "LP" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 
  12, 11, 13, 13, 13, 11, 13, 11, 11, [ 14, 48 ], 12, 11, 13, 13, 13, 11, 13, 
  11, [ 14, 83 ], [ 14, 94 ], [ 14, 100 ], [ 14, 79 ], [ 14, 80 ], 
  [ 14, 96 ], [ 14, 104 ], [ 14, 108 ] ],
#V   n = 113
[ ,,,,,,,, [ 14, 4 ],, [ 14, 6 ], [ 0, 51, "AEB" ], 13, 13, [ 0, 49, "AEB" ], 
  13, 13, 11, 13, 13, 11, 13, 13, [ 0, 43, "AEB" ], 13, 13, [ 0, 41, "AEB" ], 
  13, 13, 13, 11, 13, 13, [ 0, 37, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  13, 13, 13, 11, 13, 13, 13, [ 0, 19, "Jo2" ], 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 11, 12, 11, 13, 13, 13, 11, 13, 11, 11, 
  [ 14, 49 ], 12, 11, 13, 13, [ 14, 52 ], 11, [ 14, 51 ], 11, [ 14, 84 ], 
  [ 14, 95 ], [ 14, 101 ], [ 14, 80 ], [ 14, 81 ], [ 14, 97 ], [ 14, 105 ], 
  [ 14, 109 ] ],
#V   n = 114
[ ,,,,,,,, 13, [ 14, 5 ],, 13, 11, 13, 13, 13, 13, [ 14, 6 ], 11, 13, 13, 13, 
  13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 
  13, [ 0, 23, "LP" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 12, 11, 13, 13, 13, 11, 13, 11, 11, 
  [ 14, 50 ], [ 0, 6, "Joplus" ], 11, 13, 13, [ 14, 53 ], 11, 13, 11, 
  [ 14, 85 ], [ 14, 96 ], [ 14, 102 ], [ 14, 81 ], [ 14, 82 ], [ 14, 98 ], 
  [ 14, 106 ], [ 14, 110 ] ],
#V   n = 115
[ ,,,,,,,, 13, 13, [ 14, 6 ], 13, [ 14, 5 ], 11, 13, [ 0, 49, "AEB" ], 13, 
  13, 13, 13, 13, [ 0, 45, "AEB" ], 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, [ 0, 25, "LP" ], 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  11, 12, 11, 13, 13, 13, 11, 13, 11, 11, 12, 11, 11, 13, 13, [ 14, 54 ], 11, 
  13, 11, [ 14, 86 ], [ 14, 97 ], [ 14, 103 ], [ 14, 82 ], [ 14, 83 ], 
  [ 14, 99 ], [ 14, 107 ], [ 14, 111 ] ],
#V   n = 116
[ ,,,,,,,, [ 0, 55, "DEI" ], 13, 13, 13, 13, [ 14, 6 ], 11, 13, 11, 13, 13, 
  [ 0, 47, "AEB" ], 13, 13, 11, 13, 13, [ 0, 43, "AEB" ], 13, 13, 13, 11, 13, 
  13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 12, 
  11, 13, 13, 13, 11, 13, 11, 11, 12, 11, 11, 13, 13, [ 14, 55 ], 11, 13, 11, 
  [ 14, 87 ], [ 14, 98 ], [ 14, 104 ], [ 14, 83 ], [ 14, 84 ], [ 14, 100 ], 
  [ 14, 108 ], [ 14, 112 ] ],
#V   n = 117
[ ,,,,,,, 13,, 11, 13, [ 0, 53, "AEB" ], 13, 13, [ 14, 7 ], 13, 13, 11, 13, 
  13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 13, [ 0, 39, "AEB" ], 
  13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, [ 0, 27, "LP" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  11, 12, 11, 13, 13, 13, 11, 13, 11, 11, 12, 11, 11, 13, 13, [ 14, 56 ], 11, 
  [ 14, 55 ], 11, [ 14, 88 ], [ 14, 99 ], [ 14, 105 ], [ 14, 84 ], 
  [ 14, 85 ], [ 14, 101 ], [ 14, 109 ], [ 14, 113 ] ],
#V   n = 118
[ ,,,,,,, 13, [ 14, 4 ],, 13, 13, 11, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 
  13, 11, 13, 13, 11, 13, 13, [ 0, 41, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 
  13, 13, 13, [ 0, 35, "AEB" ], 13, 13, 13, [ 0, 33, "LP" ], 13, 13, 13, 
  [ 0, 31, "LP" ], 13, 13, 13, [ 0, 29, "LP" ], 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 11, 12, 11, 13, 13, 13, 13, 13, 11, 11, 12, 
  11, 11, 13, 13, [ 14, 57 ], 11, [ 14, 56 ], 11, [ 14, 89 ], [ 14, 100 ], 
  [ 14, 106 ], [ 14, 85 ], [ 14, 86 ], [ 14, 102 ], [ 14, 110 ], [ 14, 114 ] 
 ],
#V   n = 119
[ ,,,,,,, [ 0, 57, "DH" ], 13, [ 14, 5 ], [ 0, 55, "AEB" ], 13, 13, 11, 13, 
  [ 0, 51, "AEB" ], 13, 13, 13, 13, 13, [ 0, 47, "AEB" ], 13, 13, 13, 13, 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, [ 0, 37, "AEB" ], 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 12, 11, 13, 13, [ 0, 9, "LP" ], 13, 
  13, 11, 11, 12, 11, 11, 13, 13, [ 14, 58 ], 11, [ 14, 57 ], 11, [ 14, 90 ], 
  [ 14, 101 ], [ 14, 107 ], [ 14, 86 ], [ 14, 87 ], [ 14, 103 ], [ 14, 111 ], 
  [ 14, 115 ] ],
#V   n = 120
[ ,,,,,,, 13, 11, 13, [ 14, 6 ], 13, 13, 13, 11, 13, 11, 13, 13, 
  [ 0, 49, "AEB" ], 13, 13, 11, 13, 13, [ 0, 45, "AEB" ], 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 11, 12, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, 
  [ 14, 59 ], 11, [ 14, 58 ], 11, [ 14, 91 ], [ 14, 102 ], [ 14, 108 ], 
  [ 14, 87 ], [ 14, 88 ], [ 14, 104 ], [ 14, 112 ], [ 14, 116 ] ],
#V   n = 121
[ ,,,,,,, 13, [ 14, 4 ], 11, 13, [ 0, 55, "AEB" ], 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, [ 0, 21, "LP" ],
  13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, [ 0, 15, "LP" ], 13, 13, 13, 
  [ 0, 13, "LP" ], 13, 13, 13, 11, 12, 11, 13, 13, 11, 13, 13, 11, 11, 12, 
  11, 11, 13, 13, [ 14, 60 ], 11, [ 14, 59 ], 11, [ 14, 92 ], [ 14, 103 ], 
  [ 14, 109 ], [ 14, 88 ], [ 14, 89 ], [ 14, 105 ], [ 14, 113 ], [ 14, 117 ] 
 ],
#V   n = 122
[ ,,,,,,, [ 0, 59, "DH" ], 13, [ 14, 5 ], 13, [ 14, 4 ], 11, 13, 13, 13, 13, 
  [ 0, 51, "AEB" ], 13, 13, [ 0, 49, "AEB" ], 13, 13, 13, 11, 13, 13, 11, 13, 
  13, [ 0, 43, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, [ 0, 23, "LP" ], 13, 13, 13, 11, 13, 13, 13, 13, 11, 
  13, 13, 13, [ 0, 16, "Joplus" ], 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 12, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, [ 14, 61 ], 11, 
  [ 14, 60 ], 11, [ 14, 93 ], [ 14, 104 ], [ 14, 110 ], [ 14, 89 ], 
  [ 14, 90 ], [ 14, 106 ], [ 14, 114 ], [ 14, 118 ] ],
#V   n = 123
[ ,,,,,,,, 13, 13, [ 14, 4 ], 13, [ 14, 5 ], 11, 13, [ 0, 53, "AEB" ], 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 
  13, 13, [ 0, 39, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 12, 11, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 12, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, 
  [ 14, 62 ], 11, [ 14, 61 ], 11, [ 14, 94 ], [ 14, 105 ], [ 14, 111 ], 
  [ 14, 90 ], [ 14, 91 ], [ 14, 107 ], [ 14, 115 ], [ 14, 119 ] ],
#V   n = 124
[ ,,,,,,, 13, [ 0, 59, "AEB" ], 13, 13, 13, 13, [ 14, 6 ], 13, 13, 11, 13, 
  13, 11, 13, 13, 11, 13, 13, [ 0, 47, "AEB" ], 13, 13, 13, 13, 13, 13, 11, 
  13, 13, [ 0, 41, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, [ 0, 19, "LP" ], 13, 13, 13, 
  12, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 12, 11, 13, 13, 11, 13, 
  13, 11, 11, 12, 11, 11, 13, 13, [ 14, 63 ], 11, [ 14, 62 ], 11, [ 14, 95 ], 
  [ 14, 106 ], [ 14, 112 ], [ 14, 91 ], [ 14, 92 ], [ 14, 108 ], [ 14, 116 ], 
  [ 14, 120 ] ],
#V   n = 125
[ ,,,,,,, [ 0, 61, "Lv" ], [ 14, 4 ], 11, 13, [ 0, 57, "AEB" ], 13, 13, 
  [ 0, 55, "AEB" ], 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  [ 0, 45, "AEB" ], 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  [ 0, 27, "LP" ], 13, 13, 13, [ 0, 25, "LP" ], 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 12, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, [ 14, 64 ], 
  13, [ 14, 63 ], 11, [ 14, 96 ], [ 14, 107 ], [ 14, 113 ], [ 14, 92 ], 
  [ 14, 93 ], [ 14, 109 ], [ 14, 117 ], [ 14, 121 ] ],
#V   n = 126
[ ,,,,,,,, 11, [ 14, 5 ], 13, 13, 11, 13, 13, 13, 13, [ 0, 53, "AEB" ], 13, 
  13, [ 0, 51, "AEB" ], 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 12, 11, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, [ 0, 11, "LP" ], 13, 11, 13, 13, 11, 13, 13, 11, 11, 
  12, 11, 11, 13, 13, [ 0, 5, "LP" ], 13, [ 14, 64 ], 11, [ 14, 97 ], 
  [ 14, 108 ], [ 14, 114 ], [ 14, 93 ], [ 14, 94 ], [ 14, 110 ], [ 14, 118 ], 
  [ 14, 122 ] ],
#V   n = 127
[ ,,,,,,,,, 11, [ 0, 59, "AEB" ], 13, 13, 11, 13, [ 0, 55, "AEB" ], 13, 13, 
  11, 13, 13, 11, 13, 13, [ 0, 49, "AEB" ], 13, 13, 13, 11, 13, 13, 11, 13, 
  13, [ 0, 43, "AEB" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, [ 0, 35, "LP" ], 13, 13, 13, [ 0, 33, "LP" ], 13, 13, 13, 13, 11, 13, 
  13, [ 0, 29, "LP" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 12, 11, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, 11, 
  13, [ 14, 65 ], 11, [ 14, 98 ], [ 14, 109 ], [ 14, 115 ], [ 14, 94 ], 
  [ 14, 95 ], [ 14, 111 ], [ 14, 119 ], [ 14, 123 ] ],
#V   n = 128
[ ,,,,,,,, [ 14, 4 ],, 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 12, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, 11, 13, [ 14, 66 ], 
  11, [ 14, 99 ], [ 14, 110 ], [ 14, 116 ], [ 14, 64 ], [ 14, 96 ], 
  [ 14, 112 ], [ 14, 120 ], [ 14, 124 ] ],
#V   n = 129
[ ,,,,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 4 ], [ 0, 59, "BK" ], 13, 13, 
  [ 0, 57, "BK" ], 13, 13, 13, 13, 13, 13, 13, [ 0, 51, "BK" ], 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 12, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 11, 
  13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, 11, 13, [ 14, 67 ], 11, 
  [ 14, 100 ], [ 14, 111 ], [ 14, 64 ], [ 14, 65 ], [ 14, 97 ], [ 14, 113 ], 
  [ 14, 121 ], [ 14, 125 ] ],
#V   n = 130
[ ,,,,,,,,, [ 14, 5 ], [ 14, 6 ], 13, 11, 13, 13, 13, 13, [ 0, 55, "BK" ], 
  13, 13, [ 0, 53, "BK" ], 13, 13, 11, 13, 13, [ 0, 49, "BK" ], 13, 13, 13, 
  [ 0, 47, "BK" ], 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 12, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, 11, 13, [ 14, 68 ], 11, 
  [ 14, 101 ], [ 14, 112 ], [ 14, 65 ], [ 14, 66 ], [ 14, 98 ], [ 14, 114 ], 
  [ 14, 122 ], [ 14, 126 ] ],
#V   n = 131
[ ,,,,,,,,,, 13, 13, 13, 11, 13, [ 0, 57, "BK" ], 13, 13, 11, 13, 13, 13, 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 12, 11, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, 11, 13, 
  [ 14, 69 ], 11, [ 14, 102 ], [ 14, 113 ], [ 14, 66 ], [ 14, 67 ], 
  [ 14, 99 ], [ 14, 115 ], [ 14, 123 ], [ 14, 127 ] ],
#V   n = 132
[ ,,,,,,,,,, 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, [ 0, 53, "BK" ], 13, 
  13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, [ 0, 16, "Jo" ], 11, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 
  11, 13, 13, 11, 13, [ 14, 70 ], 11, [ 14, 103 ], [ 14, 114 ], [ 14, 67 ], 
  [ 14, 68 ], [ 14, 100 ], [ 14, 116 ], [ 14, 124 ], [ 14, 128 ] ],
#V   n = 133
[ ,,,,,,,,,, 13, [ 0, 61, "BK" ], 13, 13, [ 0, 59, "BK" ], 13, 13, 13, 13, 
  13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 12, 11, 11, 13, 13, 
  [ 0, 14, "Jo" ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 11, 13, 
  13, 11, 11, 12, 11, 11, 13, 13, 11, 13, [ 14, 71 ], 11, [ 14, 104 ], 
  [ 14, 115 ], [ 14, 68 ], [ 14, 69 ], [ 14, 101 ], [ 14, 117 ], [ 14, 125 ], 
  [ 14, 129 ] ],
#V   n = 134
[ ,,,,,,,,,, 13, 13, 11, 13, 13, 13, 13, [ 0, 57, "BK" ], 13, 13, 
  [ 0, 55, "BK" ], 13, 13, 11, 13, 13, [ 0, 51, "BK" ], 13, 13, 13, 13, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 11, 13, 
  13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, 11, 13, [ 14, 72 ], 11, 
  [ 14, 105 ], [ 14, 116 ], [ 14, 69 ], [ 14, 70 ], [ 14, 102 ], [ 14, 118 ], 
  [ 14, 126 ], [ 14, 130 ] ],
#V   n = 135
[ ,,,,,,,,,, [ 0, 63, "BK" ], 13, 13, 11, 13, [ 0, 59, "BK" ], 13, 13, 11, 
  13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, [ 0, 49, "BK" ], 13, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  [ 0, 18, "Jo" ], 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, 11, 13, 
  [ 14, 73 ], 11, [ 14, 106 ], [ 14, 117 ], [ 14, 70 ], [ 14, 71 ], 
  [ 14, 103 ], [ 14, 119 ], [ 14, 127 ], [ 14, 131 ] ],
#V   n = 136
[ ,,,,,,,,,,, 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, [ 0, 55, "BK" ], 13, 
  13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 12, 11, 13, 13, 12, 11, 11, 13, 12, 11, 
  13, 13, 13, [ 0, 12, "Jo" ], 13, 13, 13, 11, 13, 11, 13, 13, 11, 13, 13, 
  11, 11, 12, 11, 11, 13, 13, 11, 13, [ 14, 74 ], 11, [ 14, 107 ], 
  [ 14, 118 ], [ 14, 71 ], [ 14, 72 ], [ 14, 104 ], [ 14, 120 ], [ 14, 128 ], 
  [ 14, 132 ] ],
#V   n = 137
[ ,,,,,,,,, [ 14, 4 ],, [ 0, 63, "BK" ], 13, 13, [ 0, 61, "BK" ], 13, 
  [ 0, 59, "BK" ], 13, 13, 13, 13, 13, 11, 13, 13, [ 0, 53, "BK" ], 13, 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 12, 11, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 12, 11, 
  13, 13, [ 14, 51 ], 11, 13, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 
  13, 11, 13, [ 14, 75 ], 11, [ 14, 108 ], [ 14, 119 ], [ 14, 72 ], 
  [ 14, 73 ], [ 14, 105 ], [ 14, 121 ], [ 14, 129 ], [ 14, 133 ] ],
#V   n = 138
[ ,,,,,,, [ 0, 66, "Be" ],, [ 14, 4 ], [ 14, 5 ],, 11, 13, 13, 13, 13, 11, 
  13, 13, [ 0, 57, "BK" ], 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  11, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  [ 0, 20, "Jo" ], 13, 13, 12, 11, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 
  12, 11, 13, 13, 13, 11, 13, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 
  13, 11, 13, [ 14, 76 ], 11, [ 14, 109 ], [ 14, 120 ], [ 14, 73 ], 
  [ 14, 74 ], [ 14, 106 ], [ 14, 122 ], [ 14, 130 ], [ 14, 134 ] ],
#V   n = 139
[ ,,,,,,, 12, 11,, [ 14, 5 ], [ 14, 6 ],, 11, 13, [ 0, 61, "BK" ], 13, 13, 
  11, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, [ 0, 51, "BK" ], 13, 13, 
  13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 12, 11, 
  13, 13, 12, 11, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 12, 11, 13, 13, 
  [ 14, 53 ], 11, 13, 11, 13, 13, 11, 13, 13, 11, 11, 12, 11, 11, 13, 13, 11, 
  13, [ 14, 77 ], 11, [ 14, 110 ], [ 14, 121 ], [ 14, 74 ], [ 14, 75 ], 
  [ 14, 107 ], [ 14, 123 ], [ 14, 131 ], [ 14, 135 ] ],
#V   n = 140
[ ,,,,,,,, 12, 11,, [ 14, 6 ], [ 14, 7 ],, 13, 13, 13, 13, 13, 11, 13, 
  [ 0, 57, "BK" ], 13, 13, 13, 13, 13, [ 0, 53, "BK" ], 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 12, 
  11, 13, 13, 12, 11, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 12, 11, 13, 13, 
  [ 14, 54 ], 11, 13, 11, 13, 13, 11, 13, [ 14, 57 ], 11, 11, 12, 11, 11, 13, 
  13, 11, 13, [ 14, 78 ], 11, [ 14, 111 ], [ 14, 122 ], [ 14, 75 ], 
  [ 14, 76 ], [ 14, 108 ], [ 14, 124 ], [ 14, 132 ], [ 14, 136 ] ],
#V   n = 141
[ ,,,,,,,,, [ 14, 4 ], 11,, [ 14, 4 ], [ 14, 8 ], [ 0, 63, "BK" ], 13, 
  [ 0, 61, "BK" ], 13, 13, 13, 13, 13, 11, 13, 13, [ 0, 55, "BK" ], 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, [ 0, 22, "Jo" ], 13, 13, 12, 11, 13, 13, 12, 11, 13, 13, 12, 11, 
  11, 13, 12, 11, 13, 13, 12, 11, 13, 13, [ 14, 55 ], 11, 13, 11, 13, 13, 
  [ 0, 8, "Jo" ], 13, 13, 11, 11, 12, 11, 11, 13, 13, 11, 13, [ 14, 79 ], 11, 
  [ 14, 112 ], [ 14, 123 ], [ 14, 76 ], [ 14, 77 ], [ 14, 109 ], [ 14, 125 ], 
  [ 14, 133 ], [ 14, 137 ] ],
#V   n = 142
[ ,,,,,,,,,, [ 14, 4 ], 11, [ 14, 4 ], [ 14, 5 ], [ 14, 9 ], 13, 13, 11, 13, 
  13, [ 0, 59, "BK" ], 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 12, 11, 13, 13, 
  12, 11, 13, 13, 12, 11, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 12, 11, 13, 
  13, [ 14, 56 ], 11, 13, 11, 13, 12, 11, 13, [ 14, 59 ], 11, 11, 12, 11, 11, 
  13, 13, 11, 13, [ 14, 80 ], 11, [ 14, 113 ], [ 14, 124 ], [ 14, 77 ], 
  [ 14, 78 ], [ 14, 110 ], [ 14, 126 ], [ 14, 134 ], [ 14, 138 ] ],
#V   n = 143
[ ,,,,,,,,,, 12, [ 14, 5 ], 11, [ 14, 5 ], 13, [ 0, 63, "BK" ], 13, 13, 11, 
  13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 12, 11, 13, 13, 12, 11, 13, 
  13, 12, 11, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 12, 11, 13, 13, 
  [ 14, 57 ], 11, 13, 11, 13, 12, 11, 13, [ 14, 60 ], 11, 11, 12, 11, 11, 13, 
  13, 11, 13, [ 14, 81 ], 11, [ 14, 114 ], [ 14, 125 ], [ 14, 78 ], 
  [ 14, 79 ], [ 14, 111 ], [ 14, 127 ], [ 14, 135 ], [ 14, 139 ] ],
#V   n = 144
[ ,,,,,,,,, [ 14, 4 ],, 13, [ 14, 6 ], 11, 13, [ 14, 7 ], 13, 13, 13, 11, 13, 
  [ 0, 59, "BK" ], 13, 13, 13, 13, 13, [ 0, 55, "BK" ], 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 12, 
  11, 13, 13, 12, 11, 13, 13, 12, 11, 13, 13, 12, 11, 11, 13, 12, 11, 13, 13, 
  12, 11, 13, 13, [ 14, 58 ], 11, 13, 11, 13, 12, 11, 13, [ 14, 61 ], 11, 11, 
  12, 11, 11, 13, 13, 11, 13, [ 14, 82 ], 11, [ 14, 115 ], [ 14, 126 ], 
  [ 14, 79 ], [ 14, 80 ], [ 14, 112 ], [ 14, 128 ], [ 14, 136 ], [ 14, 140 ] 
 ],
#V   n = 145
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], [ 0, 67, "BK" ], 13, [ 14, 7 ], 
  [ 0, 65, "BK" ], 13, [ 0, 63, "BK" ], 13, 13, 13, 13, 13, 13, 13, 13, 
  [ 0, 57, "BK" ], 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 13, 11, 13, 13, [ 14, 20 ], 11, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 12, 11, 13, 13, 12, 
  11, 13, 13, [ 0, 18, "Jo" ], 11, 13, 13, [ 0, 16, "Jo" ], 11, 11, 13, 12, 
  11, 13, 13, 12, 11, 13, 13, [ 14, 59 ], [ 0, 10, "Jo" ], 13, 11, 13, 12, 
  11, 13, [ 14, 62 ], 11, 11, [ 0, 6, "Jo" ], 11, 11, 13, 13, 11, 13, 
  [ 14, 83 ], 11, [ 14, 116 ], [ 14, 127 ], [ 14, 80 ], [ 14, 81 ], 
  [ 14, 113 ], [ 14, 129 ], [ 14, 137 ], [ 14, 141 ] ],
#V   n = 146
[ ,,,,,,,,,, [ 14, 5 ], [ 14, 6 ], 11, 13, [ 14, 8 ], 13, 13, 13, 13, 13, 
  [ 0, 61, "BK" ], 13, [ 0, 59, "BK" ], 13, 13, 13, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 11, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  [ 0, 24, "Jo" ], 13, 13, 12, 11, 13, 13, 12, 11, 13, 12, 11, 11, 13, 12, 
  11, 11, 11, 13, 12, 11, 13, 13, 12, 11, 13, 13, 12, 11, 13, 11, 13, 12, 11, 
  13, [ 14, 63 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, [ 14, 84 ], 11, 
  [ 14, 117 ], [ 14, 128 ], [ 14, 81 ], [ 14, 82 ], [ 14, 114 ], [ 14, 130 ], 
  [ 14, 138 ], [ 14, 142 ] ],
#V   n = 147
[ ,,,,,,,,, [ 14, 4 ],, 13, [ 14, 7 ], 11, 13, [ 0, 65, "BK" ], 13, 
  [ 0, 63, "BK" ], 13, 13, 13, 13, 13, 11, 13, 13, [ 0, 57, "BK" ], 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 12, 11, 13, 13, 12, 11, 13, 13, [ 0, 20, "Jo" ], 11, 13, 12, 11, 
  11, 13, 12, 11, 11, 11, 13, [ 0, 14, "Jo" ], 11, 13, 13, 12, 11, 13, 13, 
  12, 11, 13, 11, 13, 12, 11, 13, [ 14, 64 ], 11, 12, 11, 11, 11, 13, 13, 11, 
  13, [ 14, 85 ], 11, [ 14, 118 ], [ 14, 129 ], [ 14, 82 ], [ 14, 83 ], 
  [ 14, 115 ], [ 14, 131 ], [ 14, 139 ], [ 14, 143 ] ],
#V   n = 148
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, 13, [ 14, 8 ], 11, 13, 11, 13, 11, 13, 
  13, [ 0, 61, "BK" ], 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, [ 14, 23 ], 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 12, 
  11, 13, 13, 12, 11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 12, 11, 11, 11, 12, 
  11, 11, 13, 13, 12, 11, 13, 13, 12, 11, 13, 11, 13, 12, 11, 13, [ 14, 65 ], 
  11, 12, 11, 11, 11, 13, 13, 11, 13, [ 14, 86 ], 11, [ 14, 119 ], 
  [ 14, 130 ], [ 14, 83 ], [ 14, 84 ], [ 14, 116 ], [ 14, 132 ], [ 14, 140 ], 
  [ 14, 144 ] ],
#V   n = 149
[ ,,,,,,,,,, 13, [ 0, 69, "BK" ], 13, [ 14, 5 ], [ 14, 9 ], 13, [ 14, 7 ], 
  13, 13, 11, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, [ 0, 55, "BK" ], 
  13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  13, [ 14, 24 ], 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 12, 11, 13, 13, 12, 11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 12, 
  11, 11, 11, 12, 11, 11, 13, 13, 12, 11, 13, 13, 12, 11, 13, 11, 13, 12, 11, 
  13, [ 14, 66 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, [ 14, 87 ], 11, 
  [ 14, 120 ], [ 14, 131 ], [ 14, 84 ], [ 14, 85 ], [ 14, 117 ], [ 14, 133 ], 
  [ 14, 141 ], [ 14, 145 ] ],
#V   n = 150
[ ,,,,,,,,,, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 11, 13, [ 0, 61, "BK" ], 
  13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, [ 14, 20 ], 11, 13, 13, [ 14, 25 ], 13, 13, 13, 
  11, 13, 13, [ 14, 26 ], 11, 13, 13, 13, 11, 13, 13, 13, [ 14, 32 ], 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 
  [ 0, 26, "Jo" ], 13, 13, 12, 11, 13, 13, [ 0, 22, "Jo" ], 11, 13, 12, 11, 
  11, 13, 12, 11, 11, 13, 12, 11, 11, 11, 12, 11, 11, 13, 13, 12, 11, 13, 13, 
  12, 11, 13, 11, 13, 12, 11, 13, [ 14, 67 ], 11, 12, 11, 11, 11, 13, 13, 11, 
  13, [ 14, 88 ], 11, [ 14, 121 ], [ 14, 132 ], [ 14, 85 ], [ 14, 86 ], 
  [ 14, 118 ], [ 14, 134 ], [ 14, 142 ], [ 14, 146 ] ],
#V   n = 151
[ ,,,,,,,,,, [ 0, 71, "BK" ], 13, 13, 11, 13, [ 0, 67, "BK" ], 13, 
  [ 0, 65, "BK" ], 13, 13, 13, 13, 13, 11, 13, 13, [ 0, 59, "BK" ], 13, 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 11, 13, 13, [ 14, 26 ], 13, 13, 13, 11, 13, 13, 11, 11, 13, 13, 
  13, 11, 13, 13, [ 14, 32 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 
  11, 13, 13, 11, 13, 13, 12, 11, 13, 13, 12, 11, 13, 12, 11, 11, 13, 12, 11, 
  11, 13, 12, 11, 11, 13, 12, 11, 11, 11, 12, 11, 11, 13, 13, 12, 11, 13, 13, 
  12, 11, 13, 11, 13, 12, 11, 13, [ 14, 68 ], 11, 12, 11, 11, 11, 13, 13, 11, 
  13, [ 14, 89 ], 11, [ 14, 122 ], [ 14, 133 ], [ 14, 86 ], [ 14, 87 ], 
  [ 14, 119 ], [ 14, 135 ], [ 14, 143 ], [ 14, 147 ] ],
#V   n = 152
[ ,,,,,,,,, [ 14, 4 ],, 13, 13, [ 14, 5 ], 13, 13, 13, 13, 11, 13, 13, 
  [ 0, 63, "BK" ], 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  [ 14, 27 ], 13, 13, 13, [ 14, 26 ], 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 
  [ 14, 33 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 
  13, 13, 12, 11, 13, 13, 12, 11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 12, 11, 
  11, 13, 12, 11, 11, 11, 12, 11, 11, 13, 13, [ 0, 12, "Jo" ], 11, 13, 13, 
  12, 11, 13, 11, 13, 12, 11, 13, [ 14, 69 ], 11, 12, 11, 11, 11, 13, 13, 11, 
  13, [ 14, 90 ], 11, [ 14, 123 ], [ 14, 134 ], [ 14, 87 ], [ 14, 88 ], 
  [ 14, 120 ], [ 14, 136 ], [ 14, 144 ], [ 14, 148 ] ],
#V   n = 153
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], [ 0, 71, "BK" ], 13, 13, [ 0, 69, "BK" ], 
  13, [ 0, 67, "BK" ], 13, 13, 11, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 
  13, 13, 13, [ 14, 23 ], 13, 13, 13, [ 14, 28 ], 13, 13, [ 14, 26 ], 13, 13, 
  13, [ 14, 29 ], 13, 13, 13, 13, 11, 13, 13, [ 14, 34 ], 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 12, 11, 13, 13, 12, 11, 
  13, 12, 11, 11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 12, 11, 11, 11, 12, 11, 
  11, 13, 12, 11, 11, 13, 13, 12, 11, 13, 11, 13, 12, 11, 13, [ 14, 70 ], 11, 
  12, 11, 11, 11, 13, 13, 11, 13, [ 14, 91 ], 11, [ 14, 124 ], [ 14, 135 ], 
  [ 14, 88 ], [ 14, 89 ], [ 14, 121 ], [ 14, 137 ], [ 14, 145 ], [ 14, 149 ] 
 ],
#V   n = 154
[ ,,,,,,,,,, [ 14, 5 ], [ 14, 6 ], 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 
  [ 0, 63, "BK" ], 13, 13, 13, 13, 13, [ 0, 59, "BK" ], 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 
  [ 14, 24 ], 13, 13, 13, [ 14, 29 ], 13, 13, [ 14, 27 ], 11, 13, 13, 
  [ 14, 30 ], 13, 13, 13, 13, [ 14, 32 ], 13, 13, [ 14, 35 ], 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 13, [ 0, 30, "Jo" ], 13, 13, 11, 13, 13, 12, 
  11, 13, 13, [ 0, 24, "Jo" ], 11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 12, 
  11, 11, 13, 12, 11, 11, 11, 12, 11, 11, 13, 12, 11, 11, 13, 13, 12, 11, 13, 
  11, 13, 12, 11, 13, [ 14, 71 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, 
  [ 14, 92 ], 11, [ 14, 125 ], [ 14, 136 ], [ 14, 89 ], [ 14, 90 ], 
  [ 14, 122 ], [ 14, 138 ], [ 14, 146 ], [ 14, 150 ] ],
#V   n = 155
[ ,,,,,,,,, [ 14, 4 ],, 13, [ 0, 71, "BK" ], 13, 13, [ 0, 69, "BK" ], 13, 
  [ 0, 67, "BK" ], 13, 13, 13, 13, 13, 11, 13, 13, [ 0, 61, "BK" ], 13, 13, 
  11, 13, 13, [ 0, 57, "BK" ], 13, 13, 13, [ 0, 55, "BK" ], 13, 13, 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, [ 14, 20 ], 11, 13, 13, 13, [ 14, 25 ], 13, 
  13, 13, [ 14, 30 ], 13, 13, 11, 13, 13, 13, [ 14, 31 ], 13, 13, 13, 
  [ 14, 32 ], 13, 13, 13, [ 14, 36 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 12, 11, 13, 13, 11, 13, 13, 12, 11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 
  12, 11, 11, 13, 12, 11, 11, 13, 12, 11, 11, 11, 12, 11, 11, 13, 12, 11, 11, 
  13, 13, 12, 11, 13, 11, 13, 12, 11, 13, [ 14, 72 ], 11, 12, 11, 11, 11, 13, 
  13, 11, 13, [ 14, 93 ], 11, [ 14, 126 ], [ 14, 137 ], [ 14, 90 ], 
  [ 14, 91 ], [ 14, 123 ], [ 14, 139 ], [ 14, 147 ], [ 14, 151 ] ],
#V   n = 156
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 
  [ 0, 65, "BK" ], 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 11, 13, 13, 13, 
  [ 14, 26 ], 13, 13, 13, [ 14, 31 ], 13, 13, [ 14, 29 ], 13, 13, 13, 
  [ 14, 32 ], 13, 13, 13, [ 14, 33 ], 13, 13, 13, [ 14, 37 ], 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 12, 11, 13, 13, [ 0, 28, "Jo" ], 13, 13, 12, 
  11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 12, 
  11, 11, 11, 12, 11, 11, 13, 12, 11, 11, 13, 13, 12, 11, 13, 11, 13, 12, 11, 
  13, [ 14, 73 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, [ 14, 94 ], 11, 
  [ 14, 127 ], [ 14, 138 ], [ 14, 91 ], [ 14, 92 ], [ 14, 124 ], [ 14, 140 ], 
  [ 14, 148 ], [ 14, 152 ] ],
#V   n = 157
[ ,,,,,,,,,, 13, [ 0, 73, "BK" ], 13, [ 14, 5 ], 11, 13, [ 0, 69, "BK" ], 13, 
  13, 11, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 
  [ 14, 27 ], 13, 13, 13, [ 14, 32 ], 13, 13, [ 14, 30 ], 13, 13, 13, 
  [ 14, 33 ], 13, 13, 13, [ 14, 34 ], 13, 13, 13, [ 14, 38 ], 13, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 12, 11, 13, 12, 11, 13, 13, 12, 11, 13, 12, 11, 
  11, 13, 12, 11, 11, 13, 12, 11, 11, 13, [ 0, 18, "Jo" ], 11, 11, 13, 12, 
  11, 11, 11, 12, 11, 11, 13, 12, 11, 11, 13, 13, 12, 11, 13, 11, 13, 12, 11, 
  13, [ 14, 74 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, [ 14, 95 ], 11, 
  [ 14, 128 ], [ 14, 139 ], [ 14, 92 ], [ 14, 93 ], [ 14, 125 ], [ 14, 141 ], 
  [ 14, 149 ], [ 14, 153 ] ],
#V   n = 158
[ ,,,,,,,,,, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, [ 0, 65, "BK" ], 
  13, 13, 13, 13, 13, [ 0, 61, "BK" ], 13, 13, 13, 13, 13, 13, 11, 13, 13, 
  13, 11, 13, 13, 13, 13, [ 14, 18 ], 13, 13, 13, 13, 13, 13, 13, [ 14, 23 ], 
  13, 13, 13, 13, [ 14, 28 ], 13, 13, 13, [ 14, 33 ], 13, 13, [ 14, 31 ], 13, 
  13, 13, [ 14, 34 ], 13, 13, 13, [ 14, 35 ], 13, 13, 13, [ 14, 39 ], 13, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 12, 11, 13, 12, 11, 13, 13, 12, 11, 13, 
  12, 11, 11, 13, 12, 11, 11, 13, [ 0, 20, "Jo" ], 11, 11, 12, 11, 11, 11, 
  13, [ 0, 16, "Jo" ], 11, 11, 11, 12, 11, 11, 13, 12, 11, 11, 13, 13, 12, 
  11, 13, 11, 13, 12, 11, 13, [ 14, 75 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, 
  [ 14, 96 ], 11, [ 14, 129 ], [ 14, 140 ], [ 14, 93 ], [ 14, 94 ], 
  [ 14, 126 ], [ 14, 142 ], [ 14, 150 ], [ 14, 154 ] ],
#V   n = 159
[ ,,,,,,,,, [ 14, 4 ], [ 0, 75, "BK" ], 13, [ 0, 73, "BK" ], 13, 13, 
  [ 0, 71, "BK" ], 13, [ 0, 69, "BK" ], 13, 13, 13, 11, 13, 11, 13, 13, 
  [ 0, 63, "BK" ], 13, 13, 11, 13, 13, [ 0, 59, "BK" ], 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 13, [ 14, 19 ], 13, 13, 13, [ 14, 20 ], 13, 13, 13, 
  [ 14, 24 ], 13, 13, 13, 13, [ 14, 29 ], 13, 13, 13, [ 14, 34 ], 13, 13, 
  [ 14, 32 ], 13, 13, 13, [ 14, 35 ], 13, 13, 13, [ 14, 36 ], 13, 13, 13, 
  [ 14, 40 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 12, 11, 13, 12, 11, 
  13, 13, [ 0, 26, "Jo" ], 11, 13, 12, 11, 11, 13, 12, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 13, 12, 11, 11, 13, 13, 
  12, 11, 13, 11, 13, 12, 11, 13, [ 14, 76 ], 11, 12, 11, 11, 11, 13, 13, 11, 
  13, [ 14, 97 ], 11, [ 14, 130 ], [ 14, 141 ], [ 14, 94 ], [ 14, 95 ], 
  [ 14, 127 ], [ 14, 143 ], [ 14, 151 ], [ 14, 155 ] ],
#V   n = 160
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, 13, 11, 13, 13, 11, 13, 11, 13, 13, 13, 
  11, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 13, [ 14, 20 ], 13, 13, 13, [ 14, 21 ], 11, 13, 13, 
  [ 14, 25 ], 13, 13, 13, 13, [ 14, 30 ], 13, 13, 13, [ 14, 35 ], 13, 13, 
  [ 14, 33 ], 13, 13, 13, [ 14, 36 ], 13, 13, 13, [ 14, 37 ], 13, 13, 13, 
  [ 14, 41 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 12, 11, 13, 12, 11, 
  13, 12, 11, 11, 13, 12, 11, 11, 13, [ 0, 22, "Jo" ], 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 13, 12, 11, 11, 13, 13, 
  12, 11, 13, 11, 13, 12, 11, 13, [ 14, 77 ], 11, 12, 11, 11, 11, 13, 13, 11, 
  13, [ 14, 98 ], 11, [ 14, 131 ], [ 14, 142 ], [ 14, 95 ], [ 14, 96 ], 
  [ 14, 128 ], [ 14, 144 ], [ 14, 152 ], [ 14, 156 ] ],
#V   n = 161
[ ,,,,,,,,,, [ 14, 5 ], [ 0, 75, "BK" ], 13, 13, 11, 13, 13, 11, 13, 11, 13, 
  13, 13, 11, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 13, [ 14, 21 ], 13, 13, 13, 11, 13, 13, 13, 
  [ 14, 26 ], 13, 13, 13, 13, [ 14, 31 ], 13, 13, 13, [ 14, 36 ], 13, 13, 
  [ 14, 34 ], 13, 13, 13, [ 14, 37 ], 13, 13, 13, [ 14, 38 ], 13, 13, 13, 
  [ 14, 42 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, [ 0, 30, "Jo" ], 
  11, 13, 12, 11, 13, 12, 11, 11, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 13, 12, 11, 11, 13, 13, 
  12, 11, 13, 11, 13, 12, 11, 13, [ 14, 78 ], 11, 12, 11, 11, 11, 13, 13, 11, 
  13, [ 14, 99 ], 11, [ 14, 132 ], [ 14, 143 ], [ 14, 96 ], [ 14, 97 ], 
  [ 14, 129 ], [ 14, 145 ], [ 14, 153 ], [ 14, 157 ] ],
#V   n = 162
[ ,,,,,,,,, [ 14, 4 ],, 13, 13, 13, 13, 11, 13, 13, 11, 13, 11, 13, 13, 13, 
  11, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 
  11, 13, 13, 13, 13, [ 14, 22 ], 13, 13, 13, [ 14, 23 ], 13, 13, 13, 
  [ 14, 27 ], 13, 13, 13, 13, [ 14, 32 ], 13, 13, 13, [ 14, 37 ], 13, 13, 
  [ 14, 35 ], 13, 13, 13, [ 14, 38 ], 13, 13, 13, [ 14, 39 ], 13, 13, 13, 
  [ 14, 43 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 12, 11, 11, 13, 12, 11, 
  13, 12, 11, 11, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 11, [ 0, 14, "Jo" ], 11, 11, 13, 12, 11, 11, 13, 13, 
  12, 11, 13, 11, 13, 12, 11, 13, [ 14, 79 ], 11, 12, 11, 11, 11, 13, 13, 11, 
  13, [ 14, 100 ], 11, [ 14, 133 ], [ 14, 144 ], [ 14, 97 ], [ 14, 98 ], 
  [ 14, 130 ], [ 14, 146 ], [ 14, 154 ], [ 14, 158 ] ],
#V   n = 163
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, [ 0, 75, "BK" ], 13, 13, 13, 11, 13, 
  [ 14, 6 ], 11, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 11, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, [ 14, 23 ], 13, 13, 
  13, [ 14, 24 ], 13, 13, 13, [ 14, 28 ], 13, 13, 13, 13, [ 14, 33 ], 13, 13, 
  13, [ 14, 38 ], 13, 13, [ 14, 36 ], 13, 13, 13, [ 14, 39 ], 13, 13, 13, 
  [ 14, 40 ], 13, 13, 13, [ 14, 44 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  12, 11, 11, 13, [ 0, 28, "Jo" ], 11, 13, 12, 11, 11, 13, [ 0, 24, "Jo" ], 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 13, 12, 11, 11, 13, 13, 12, 11, 13, 11, 13, 12, 11, 13, 
  [ 14, 80 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, [ 14, 101 ], 11, 
  [ 14, 134 ], [ 14, 145 ], [ 14, 98 ], [ 14, 99 ], [ 14, 131 ], [ 14, 147 ], 
  [ 14, 155 ], [ 14, 159 ] ],
#V   n = 164
[ ,,,,,,,,,, [ 14, 5 ], 13, 13, 11, 13, 13, 13, 13, 13, 13, 11, 13, 11, 13, 
  13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 13, 11, 13, 13, 13, 13, [ 14, 24 ], 13, 13, 13, [ 14, 25 ], 13, 13, 13, 
  [ 14, 29 ], 13, 13, 13, 13, [ 14, 34 ], 13, 13, 13, [ 14, 39 ], 13, 13, 
  [ 14, 37 ], 13, 13, 13, [ 14, 40 ], 13, 13, 13, [ 14, 41 ], 13, 13, 13, 
  [ 14, 45 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 12, 11, 11, 12, 11, 11, 
  13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 13, 13, 12, 11, 13, 11, 
  13, 12, 11, 13, [ 14, 81 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, 
  [ 14, 102 ], 11, [ 14, 135 ], [ 14, 146 ], [ 14, 99 ], [ 14, 100 ], 
  [ 14, 132 ], [ 14, 148 ], [ 14, 156 ], [ 14, 160 ] ],
#V   n = 165
[ ,,,,,,,,,,, [ 0, 77, "BK" ], 13, 13, 11, 13, 13, [ 14, 6 ], 13, 13, 
  [ 14, 8 ], 11, 13, 11, 13, 13, [ 14, 10 ], 13, 13, 11, 13, 13, 11, 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, [ 14, 25 ], 
  13, 13, 13, [ 14, 26 ], 13, 13, 13, [ 14, 30 ], 13, 13, 13, 13, [ 14, 35 ], 
  13, 13, 13, [ 14, 40 ], 13, 13, [ 14, 38 ], 13, 13, 13, [ 14, 41 ], 13, 13, 
  13, [ 14, 42 ], 13, 13, 13, [ 14, 46 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 
  13, 12, 11, 11, 12, 11, 11, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 
  11, 13, 13, 12, 11, 13, 11, 13, 12, 11, 13, [ 14, 82 ], 11, 12, 11, 11, 11, 
  13, 13, 11, 13, [ 14, 103 ], 11, [ 14, 136 ], [ 14, 147 ], [ 14, 100 ], 
  [ 14, 101 ], [ 14, 133 ], [ 14, 149 ], [ 14, 157 ], [ 14, 161 ] ],
#V   n = 166
[ ,,,,,,,,,,, 12, 11, 13, 13, 11, 13, 13, [ 14, 7 ], 13, 13, [ 14, 9 ], 
  [ 14, 8 ], 13, 11, 13, 13, [ 14, 11 ], 13, 13, 11, 13, 13, 11, 13, 13, 11, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, [ 14, 26 ], 13, 
  13, 13, [ 14, 27 ], 13, 13, 13, [ 14, 31 ], 13, 13, 13, 13, [ 14, 36 ], 13, 
  13, 13, [ 14, 41 ], 13, 13, [ 14, 39 ], 13, 13, 13, [ 14, 42 ], 13, 13, 13, 
  [ 14, 43 ], 13, 13, 13, [ 14, 47 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  12, 11, 11, 12, 11, 11, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 
  13, 13, [ 0, 10, "Jo" ], 11, 13, 11, 13, 12, 11, 13, [ 14, 83 ], 11, 12, 
  11, 11, 11, 13, 13, 11, 13, [ 14, 104 ], 11, [ 14, 137 ], [ 14, 148 ], 
  [ 14, 101 ], [ 14, 102 ], [ 14, 134 ], [ 14, 150 ], [ 14, 158 ], 
  [ 14, 162 ] ],
#V   n = 167
[ ,,,,,,,,,,, 12, 13, 11, 13, 13, 11, 13, 13, [ 14, 8 ], 13, 13, [ 14, 8 ], 
  13, 13, 11, 13, 13, [ 14, 12 ], 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, [ 14, 27 ], 13, 13, 13, 
  [ 14, 28 ], 13, 13, 13, [ 14, 32 ], 13, 13, 13, 13, [ 14, 37 ], 13, 13, 13, 
  [ 14, 42 ], 13, 13, [ 14, 40 ], 13, 13, 13, [ 14, 43 ], 13, 13, 13, 
  [ 14, 44 ], 13, 13, 13, [ 14, 48 ], 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  12, 11, 11, 12, 11, 11, 13, [ 0, 26, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  13, 12, 11, 11, 13, 12, 11, 11, 13, 11, 13, 12, 11, 13, [ 14, 84 ], 11, 12, 
  11, 11, 11, 13, 13, 11, 13, [ 14, 105 ], 11, [ 14, 138 ], [ 14, 149 ], 
  [ 14, 102 ], [ 14, 103 ], [ 14, 135 ], [ 14, 151 ], [ 14, 159 ], 
  [ 14, 163 ] ],
#V   n = 168
[ ,,,,,,,,, [ 14, 4 ],,, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, [ 14, 13 ], 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 11, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, [ 14, 28 ], 13, 13, 13, 
  [ 14, 29 ], 13, 13, 13, [ 14, 33 ], 13, 13, 13, 13, [ 14, 38 ], 13, 13, 13, 
  [ 14, 43 ], 13, 13, [ 14, 41 ], 13, 13, 13, [ 14, 44 ], 13, 13, 13, 
  [ 14, 45 ], 13, 13, 13, [ 14, 49 ], 13, 13, 13, [ 14, 42 ], 13, 13, 13, 11, 
  13, 13, [ 0, 30, "Jo" ], 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 11, 13, [ 0, 8, "Jo" ], 11, 13, 
  [ 14, 85 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, [ 14, 106 ], 11, 
  [ 14, 139 ], [ 14, 150 ], [ 14, 103 ], [ 14, 104 ], [ 14, 136 ], 
  [ 14, 152 ], [ 14, 160 ], [ 14, 164 ] ],
#V   n = 169
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ],, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, [ 14, 10 ], 13, 13, 13, [ 14, 14 ], 13, 13, 13, 13, 13, 11, 
  13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 
  [ 14, 29 ], 13, 13, 13, [ 14, 30 ], 13, 13, 13, [ 14, 34 ], 13, 13, 13, 13, 
  [ 14, 39 ], 13, 13, 13, [ 14, 44 ], 13, 13, [ 14, 42 ], 13, 13, 13, 
  [ 14, 45 ], 13, 13, 13, [ 14, 46 ], 13, 13, 13, [ 14, 50 ], 13, 13, 
  [ 14, 42 ], 13, 13, 13, 13, 11, 13, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, [ 0, 20, "Jo" ], 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 
  11, 12, 11, 11, 13, [ 14, 86 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, 
  [ 14, 107 ], 11, [ 14, 140 ], [ 14, 151 ], [ 14, 104 ], [ 14, 105 ], 
  [ 14, 137 ], [ 14, 153 ], [ 14, 161 ], [ 14, 165 ] ],
#V   n = 170
[ ,,,,,,,,,, [ 14, 5 ], [ 14, 6 ], 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, [ 14, 11 ], 13, 13, 13, [ 14, 15 ], 13, [ 14, 12 ], 13, 
  13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  13, 13, [ 14, 30 ], 13, 13, 13, [ 14, 31 ], 13, 13, 13, [ 14, 35 ], 13, 13, 
  13, 13, [ 14, 40 ], 13, 13, 13, [ 14, 45 ], 13, 13, [ 14, 43 ], 13, 13, 13, 
  [ 14, 46 ], 13, 13, 13, [ 14, 47 ], 13, 13, 13, [ 14, 51 ], 13, 13, 
  [ 14, 43 ], 13, 13, 13, 13, 11, 13, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, [ 0, 18, "Jo" ], 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 13, 12, 11, 11, 13, 
  11, 12, 11, 11, 13, [ 14, 87 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, 
  [ 14, 108 ], 11, [ 14, 141 ], [ 14, 152 ], [ 14, 105 ], [ 14, 106 ], 
  [ 14, 138 ], [ 14, 154 ], [ 14, 162 ], [ 14, 166 ] ],
#V   n = 171
[ ,,,,,,,,, [ 14, 4 ],, 13, [ 0, 79, "BK" ], 13, 13, [ 0, 77, "BK" ], 13, 
  [ 0, 75, "BK" ], 13, 13, [ 0, 73, "BK" ], 13, 13, [ 0, 71, "BK" ], 13, 13, 
  13, 13, [ 14, 12 ], 13, 13, 13, 13, 13, [ 14, 13 ], 11, 13, 13, 13, 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, [ 14, 31 ], 
  13, 13, 13, [ 14, 32 ], 13, 13, 13, [ 14, 36 ], 13, 13, 13, 13, [ 14, 41 ], 
  13, 13, 13, [ 14, 46 ], 13, 13, [ 14, 44 ], 13, 13, 13, [ 14, 47 ], 13, 13, 
  13, [ 14, 48 ], 13, 13, 13, [ 14, 52 ], 13, 13, [ 14, 44 ], 13, 13, 13, 13, 
  11, 13, 12, 11, 11, 11, [ 0, 28, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, [ 0, 22, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 13, [ 0, 12, "Jo" ], 11, 11, 13, 12, 11, 11, 
  13, 11, 12, 11, 11, 13, [ 14, 88 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, 
  [ 14, 109 ], 11, [ 14, 142 ], [ 14, 153 ], [ 14, 106 ], [ 14, 107 ], 
  [ 14, 139 ], [ 14, 155 ], [ 14, 163 ], [ 14, 167 ] ],
#V   n = 172
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 11, 
  13, 13, 11, 13, 13, 13, 13, [ 14, 13 ], 13, 13, 13, 13, 13, 11, 13, 13, 13, 
  13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, 
  [ 14, 32 ], 13, 13, 13, [ 14, 33 ], 13, 13, 13, [ 14, 37 ], 13, 13, 13, 13, 
  [ 14, 42 ], 13, 13, 13, [ 14, 47 ], 13, 13, [ 14, 45 ], 13, 13, 13, 
  [ 14, 48 ], 13, 13, 13, [ 14, 49 ], 13, 13, 13, [ 14, 53 ], 13, 13, 
  [ 14, 45 ], 13, 13, 13, 13, [ 14, 46 ], 13, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 0, 16, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 
  11, 13, 11, 12, 11, 11, 13, [ 14, 89 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, 
  [ 14, 110 ], 11, [ 14, 143 ], [ 14, 154 ], [ 14, 107 ], [ 14, 108 ], 
  [ 14, 140 ], [ 14, 156 ], [ 14, 164 ], [ 14, 168 ] ],
#V   n = 173
[ ,,,,,,,,,, [ 14, 5 ], [ 0, 81, "BK" ], 13, [ 14, 5 ], 11, 13, 
  [ 0, 77, "BK" ], 13, [ 0, 75, "BK" ], 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, [ 14, 14 ], 13, 13, 13, 13, 13, [ 14, 15 ], 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 13, 13, [ 14, 33 ], 
  13, 13, 13, [ 14, 34 ], 13, 13, 13, [ 14, 38 ], 13, 13, 13, 13, [ 14, 43 ], 
  13, 13, 13, [ 14, 48 ], 13, 13, [ 14, 46 ], 13, 13, 13, [ 14, 49 ], 13, 13, 
  13, [ 14, 50 ], 13, 13, 13, [ 14, 54 ], 13, 13, [ 14, 46 ], 13, 13, 13, 
  [ 14, 46 ], [ 14, 47 ], 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  [ 0, 24, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 13, 11, 
  12, 11, 11, 13, [ 14, 90 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, 
  [ 14, 111 ], 11, [ 14, 144 ], [ 14, 155 ], [ 14, 108 ], [ 14, 109 ], 
  [ 14, 141 ], [ 14, 157 ], [ 14, 165 ], [ 14, 169 ] ],
#V   n = 174
[ ,,,,,,,,,,, 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, [ 0, 73, "BK" ], 
  13, 13, [ 0, 71, "BK" ], 13, 13, 13, 13, 13, [ 14, 15 ], 13, 13, 13, 13, 
  13, [ 14, 16 ], 13, 13, 13, 13, 13, [ 14, 16 ], 11, 13, 13, 11, 13, 13, 13, 
  13, 13, 13, 13, 11, 13, 13, 13, 13, [ 14, 34 ], 13, 13, 13, [ 14, 35 ], 13, 
  13, 13, [ 14, 39 ], 13, 13, 13, 13, [ 14, 44 ], 13, 13, 13, [ 14, 49 ], 13, 
  13, [ 14, 47 ], 13, 13, 13, [ 14, 50 ], 13, 13, 13, [ 14, 51 ], 13, 13, 13, 
  [ 14, 55 ], 13, 13, [ 14, 47 ], 13, 13, 13, [ 14, 47 ], 13, 13, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 12, 
  11, 11, 13, 11, 12, 11, 11, 13, [ 14, 91 ], 11, 12, 11, 11, 11, 13, 13, 11, 
  13, [ 14, 112 ], 11, [ 14, 145 ], [ 14, 156 ], [ 14, 109 ], [ 14, 110 ], 
  [ 14, 142 ], [ 14, 158 ], [ 14, 166 ], [ 14, 170 ] ],
#V   n = 175
[ ,,,,,,,,, [ 14, 4 ],, 13, [ 0, 81, "BK" ], 13, 13, [ 0, 79, "BK" ], 13, 
  [ 0, 77, "BK" ], 13, 13, 11, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 
  [ 0, 67, "BK" ], 13, 13, 13, 13, 13, [ 0, 63, "BK" ], 13, 13, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, [ 14, 20 ], 11, 13, 13, 13, 11, 13, 13, 13, 13, 
  [ 14, 35 ], 13, 13, 13, [ 14, 36 ], 13, 13, 13, [ 14, 40 ], 13, 13, 13, 13, 
  [ 14, 45 ], 13, 13, 13, [ 14, 50 ], 13, 13, [ 14, 48 ], 13, 13, 13, 
  [ 14, 51 ], 13, 13, 13, [ 14, 52 ], 13, 13, 13, [ 14, 56 ], 13, 13, 
  [ 14, 48 ], 13, 13, 13, [ 0, 32, "sph" ], 13, 13, 12, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 13, 
  11, 12, 11, 11, 13, [ 14, 92 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, 
  [ 14, 113 ], 11, [ 14, 146 ], [ 14, 157 ], [ 14, 110 ], [ 14, 111 ], 
  [ 14, 143 ], [ 14, 159 ], [ 14, 167 ], [ 14, 171 ] ],
#V   n = 176
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], [ 0, 83, "BK" ], 13, 11, 13, 13, 13, 13, 
  13, 13, 13, 11, 13, [ 0, 73, "BK" ], 13, 13, 13, 13, 13, 13, 13, 13, 12, 
  11, 13, 13, 13, 13, 12, 11, 13, 13, 13, 13, 13, [ 14, 18 ], 13, 13, 13, 11, 
  13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 13, [ 14, 36 ], 13, 13, 13, 
  [ 14, 37 ], 13, 13, 13, [ 14, 41 ], 13, 13, 13, 13, [ 14, 46 ], 13, 13, 13, 
  [ 14, 51 ], 13, 13, [ 14, 49 ], 13, 13, 13, [ 14, 52 ], 13, 13, 13, 
  [ 14, 53 ], 13, 13, 13, [ 14, 57 ], 13, 13, [ 14, 49 ], 13, 13, 12, 11, 13, 
  13, [ 0, 30, "Jo" ], 11, 11, 12, 11, 11, 11, [ 0, 26, "Jo" ], 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 13, 11, 12, 11, 11, 13, 
  [ 14, 93 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, [ 14, 114 ], 11, 
  [ 14, 147 ], [ 14, 158 ], [ 14, 111 ], [ 14, 112 ], [ 14, 144 ], 
  [ 14, 160 ], [ 14, 168 ], [ 14, 172 ] ],
#V   n = 177
[ ,,,,,,,,,, [ 14, 5 ], [ 14, 6 ], 13, 13, 11, 13, [ 0, 79, "BK" ], 13, 
  [ 0, 77, "BK" ], 13, 13, 13, 13, 13, 11, 13, 13, [ 0, 71, "BK" ], 13, 13, 
  13, 13, 12, 12, 11, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 13, [ 14, 19 ], 
  13, 13, 13, 11, 13, 13, [ 14, 22 ], 13, 13, 13, 13, 11, 13, 13, 13, 13, 
  [ 14, 37 ], 13, 13, 13, [ 14, 38 ], 13, 13, 13, [ 14, 42 ], 13, 13, 13, 13, 
  [ 14, 47 ], 13, 13, 13, [ 14, 52 ], 13, 13, [ 14, 50 ], 13, 13, 13, 
  [ 14, 53 ], 13, 13, 13, [ 14, 54 ], 13, 13, 13, [ 14, 58 ], 13, 13, 
  [ 14, 50 ], 13, 13, 12, 11, 13, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 13, 11, 12, 11, 11, 
  13, [ 14, 94 ], 11, 12, 11, 11, 11, 13, 13, 11, 13, [ 14, 115 ], 11, 
  [ 14, 148 ], [ 14, 159 ], [ 14, 112 ], [ 14, 113 ], [ 14, 145 ], 
  [ 14, 161 ], [ 14, 169 ], [ 14, 173 ] ],
#V   n = 178
[ ,,,,,,,,, [ 14, 4 ],, [ 14, 6 ], 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 
  13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 12, 12, 11, 13, 13, 13, 12, 12, 
  11, 13, 13, 13, 13, 13, [ 14, 20 ], 13, 13, 13, 13, 13, 13, [ 14, 23 ], 13, 
  13, 13, 13, 13, 13, 13, 13, 13, [ 14, 38 ], 13, 13, 13, [ 14, 39 ], 13, 13, 
  13, [ 14, 43 ], 13, 13, 13, 13, [ 14, 48 ], 13, 13, 13, [ 14, 53 ], 13, 13, 
  [ 14, 51 ], 13, 13, 13, [ 14, 54 ], 13, 13, 13, [ 14, 55 ], 13, 13, 13, 
  [ 14, 59 ], 13, 13, [ 0, 34, "Jo" ], 13, 13, 12, 11, 13, 12, 11, 11, 11, 
  12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 11, [ 0, 14, "Jo" ], 11, 11, 11, 12, 11, 
  11, 11, 13, 12, 11, 11, 13, 11, 12, 11, 11, 13, [ 14, 95 ], 11, 12, 11, 11, 
  11, 13, 13, 11, 13, [ 14, 116 ], 11, [ 14, 149 ], [ 14, 160 ], [ 14, 113 ], 
  [ 14, 114 ], [ 14, 146 ], [ 14, 162 ], [ 14, 170 ], [ 14, 174 ] ],
#V   n = 179
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ],, [ 0, 83, "BK" ], 13, 13, [ 0, 81, "BK" ], 
  13, [ 0, 79, "BK" ], 13, 13, 11, 13, [ 0, 75, "BK" ], 13, 13, 13, 13, 13, 
  [ 0, 71, "BK" ], 13, 13, 13, 13, 13, 12, 12, 11, 13, 13, 13, 12, 12, 11, 
  13, 13, 13, 13, 13, [ 14, 21 ], 13, 13, [ 14, 20 ], 11, 13, 13, [ 14, 24 ], 
  13, 13, 13, [ 14, 24 ], 11, 13, 13, 13, 13, [ 14, 39 ], 13, 13, 13, 
  [ 14, 40 ], 13, 13, 13, [ 14, 44 ], 13, 13, 13, 13, [ 14, 49 ], 13, 13, 13, 
  [ 14, 54 ], 13, 13, [ 14, 52 ], 13, 13, 13, [ 14, 55 ], 13, 13, 13, 
  [ 14, 56 ], 13, 13, 13, [ 14, 60 ], 13, 12, 11, 13, 13, 12, 11, 13, 12, 11, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  13, 12, 11, 11, 13, 11, 12, 11, 11, 13, [ 14, 96 ], 11, 12, 11, 11, 11, 13, 
  13, 11, 13, [ 14, 117 ], 11, [ 14, 150 ], [ 14, 161 ], [ 14, 114 ], 
  [ 14, 115 ], [ 14, 147 ], [ 14, 163 ], [ 14, 171 ], [ 14, 175 ] ],
#V   n = 180
[ ,,,,,,,,,, [ 14, 5 ], [ 14, 6 ], 13, 11, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 11, 13, 13, [ 0, 73, "BK" ], 13, 13, 11, 13, 13, 13, 13, 13, 12, 12, 
  11, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 13, [ 14, 22 ], 13, 13, 11, 13, 
  13, 13, [ 14, 25 ], 13, 13, 13, 11, 13, 13, 13, 13, 13, [ 14, 40 ], 13, 13, 
  13, [ 14, 41 ], 13, 13, 13, [ 14, 45 ], 13, 13, 13, 13, [ 14, 50 ], 13, 13, 
  13, [ 14, 55 ], 13, 13, [ 14, 53 ], 13, 13, 13, [ 14, 56 ], 13, 13, 13, 
  [ 14, 57 ], 13, 13, 13, [ 14, 61 ], 13, 12, 11, 13, 13, 12, 11, 13, 12, 11, 
  11, 11, [ 0, 28, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  12, 11, 11, 11, 13, 12, 11, 11, 13, 11, 12, 11, 11, 13, [ 14, 97 ], 11, 12, 
  11, 11, 11, 13, 13, [ 0, 4, "Jo" ], 13, [ 14, 118 ], 11, [ 14, 151 ], 
  [ 14, 162 ], [ 14, 115 ], [ 14, 116 ], [ 14, 148 ], [ 14, 164 ], 
  [ 14, 172 ], [ 14, 176 ] ],
#V   n = 181
[ ,,,,,,,,,,, 13, 13, 13, 11, 13, [ 0, 81, "BK" ], 13, [ 0, 79, "BK" ], 13, 
  13, [ 0, 77, "BK" ], 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 
  13, 12, 12, 11, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 13, [ 14, 23 ], 13, 
  13, [ 14, 22 ], 13, 13, 13, [ 14, 26 ], 13, 13, 13, [ 14, 26 ], 13, 13, 13, 
  13, 13, [ 14, 41 ], 13, 13, 13, [ 14, 42 ], 13, 13, 13, [ 14, 46 ], 13, 13, 
  13, 13, [ 14, 51 ], 13, 13, 13, [ 14, 56 ], 13, 13, [ 14, 54 ], 13, 13, 13, 
  [ 14, 57 ], 13, 13, 13, [ 14, 58 ], 13, 13, 13, [ 14, 62 ], 13, 12, 11, 13, 
  13, [ 0, 32, "Jo" ], 11, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, [ 0, 20, "Jo" ], 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 13, 
  11, 12, 11, 11, 13, [ 14, 98 ], 11, 12, 11, 11, 11, 13, 12, 11, 13, 
  [ 14, 119 ], 11, [ 14, 152 ], [ 14, 163 ], [ 14, 116 ], [ 14, 117 ], 
  [ 14, 149 ], [ 14, 165 ], [ 14, 173 ], [ 14, 177 ] ],
#V   n = 182
[ ,,,,,,,,,,, 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 12, 12, 11, 13, 13, 13, 12, 12, 11, 
  13, 13, 13, 13, 13, [ 14, 24 ], 13, 13, [ 14, 23 ], 13, 13, 13, [ 14, 27 ], 
  13, 13, 13, [ 14, 27 ], 13, 13, 13, 13, 13, [ 14, 42 ], 13, 13, 13, 
  [ 14, 43 ], 13, 13, 13, [ 14, 47 ], 13, 13, 13, 13, [ 14, 52 ], 13, 13, 13, 
  [ 14, 57 ], 13, 13, [ 14, 55 ], 13, 13, 13, [ 14, 58 ], 13, 13, 13, 
  [ 14, 59 ], 13, 13, 13, [ 14, 63 ], 13, 12, 11, 13, 12, 11, 11, 13, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [ 0, 22, "Jo" ], 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  12, 11, 11, 11, 13, 12, 11, 11, 13, 11, 12, 11, 11, 13, [ 14, 99 ], 11, 12, 
  11, 11, 11, 13, 12, 11, 13, [ 14, 120 ], 11, [ 14, 153 ], [ 14, 164 ], 
  [ 14, 117 ], [ 14, 118 ], [ 14, 150 ], [ 14, 166 ], [ 14, 174 ], 
  [ 14, 178 ] ],
#V   n = 183
[ ,,,,,,,,, [ 14, 4 ],, 13, [ 0, 85, "BK" ], 13, 13, [ 0, 83, "BK" ], 13, 
  [ 0, 81, "BK" ], 13, 13, 11, 13, [ 0, 77, "BK" ], 13, 13, 13, 11, 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 13, 13, 12, 12, 11, 13, 13, 13, 12, 12, 11, 13, 
  13, 13, 13, 13, [ 14, 25 ], 13, 13, [ 14, 24 ], 13, 13, 13, [ 14, 28 ], 13, 
  13, 13, [ 14, 28 ], 13, 13, 13, 13, 13, [ 14, 43 ], 13, 13, 13, [ 14, 44 ], 
  13, 13, 13, [ 14, 48 ], 13, 13, 13, 13, [ 14, 53 ], 13, 13, 13, [ 14, 58 ], 
  13, 13, [ 14, 56 ], 13, 13, 13, [ 14, 59 ], 13, 13, 13, [ 14, 60 ], 13, 13, 
  13, [ 14, 64 ], 13, 12, 11, 13, 12, 11, 11, 13, 12, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, [ 0, 24, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  11, [ 0, 18, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 13, 12, 11, 11, 13, 11, 12, 11, 11, 13, [ 14, 100 ], 11, 12, 
  11, 11, 11, 13, 12, 11, 13, [ 14, 121 ], 11, [ 14, 154 ], [ 14, 165 ], 
  [ 14, 118 ], [ 14, 119 ], [ 14, 151 ], [ 14, 167 ], [ 14, 175 ], 
  [ 14, 179 ] ],
#V   n = 184
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 12, 12, 
  11, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 13, [ 14, 26 ], 13, 13, 
  [ 14, 25 ], 13, 13, 13, [ 14, 29 ], 13, 13, 13, [ 14, 29 ], 13, 13, 13, 13, 
  13, [ 14, 44 ], 13, 13, 13, [ 14, 45 ], 13, 13, 13, [ 14, 49 ], 13, 13, 13, 
  13, [ 14, 54 ], 13, 13, 13, [ 14, 40 ], 13, 13, [ 14, 57 ], 13, 13, 13, 
  [ 14, 60 ], 13, 13, 13, [ 0, 38, "Jo" ], 13, 13, 13, [ 14, 65 ], 13, 12, 
  11, 13, 12, 11, 11, 13, [ 0, 30, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 13, 11, 12, 
  11, 11, 13, [ 14, 101 ], 11, [ 0, 6, "Jo" ], 11, 11, 11, 13, 12, 11, 13, 
  [ 14, 122 ], 11, [ 14, 155 ], [ 14, 166 ], [ 14, 119 ], [ 14, 120 ], 
  [ 14, 152 ], [ 14, 168 ], [ 14, 176 ], [ 14, 180 ] ],
#V   n = 185
[ ,,,,,,,,,, [ 14, 5 ], [ 0, 87, "BK" ], 13, 13, 11, 13, [ 0, 83, "BK" ], 13, 
  [ 0, 81, "BK" ], 13, 13, [ 0, 79, "BK" ], 13, [ 0, 77, "BK" ], 13, 13, 13, 
  13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 12, 12, 11, 13, 13, 13, 
  12, 12, 11, 13, 13, 13, 13, 13, [ 14, 27 ], 13, 13, [ 14, 26 ], 13, 13, 13, 
  [ 14, 30 ], 13, 13, 13, [ 14, 30 ], 13, 13, 13, 13, 13, [ 14, 45 ], 13, 13, 
  13, [ 14, 46 ], 13, 13, 13, [ 14, 50 ], 13, 13, 13, 13, [ 14, 55 ], 13, 13, 
  [ 14, 40 ], 13, 13, 13, [ 14, 58 ], 13, 13, 13, [ 14, 61 ], 13, 13, 12, 11, 
  13, 13, 13, [ 14, 66 ], 13, 12, 11, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 
  11, 13, 11, 12, 11, 11, 13, [ 14, 102 ], 12, 11, 11, 11, 11, 13, 12, 11, 
  13, [ 14, 123 ], 11, [ 14, 156 ], [ 14, 167 ], [ 14, 120 ], [ 14, 121 ], 
  [ 14, 153 ], [ 14, 169 ], [ 14, 177 ], [ 14, 181 ] ],
#V   n = 186
[ ,,,,,,,,, [ 14, 4 ],, 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 
  11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 12, 12, 
  11, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 13, [ 14, 28 ], 13, 13, 
  [ 14, 27 ], 13, 13, 13, [ 14, 31 ], 13, 13, 13, [ 14, 31 ], 13, 13, 13, 13, 
  13, [ 14, 46 ], 13, 13, 13, [ 14, 47 ], 13, 13, 13, [ 14, 51 ], 13, 13, 13, 
  13, [ 14, 56 ], 13, 13, [ 14, 41 ], 11, 13, 13, [ 14, 59 ], 13, 13, 13, 
  [ 14, 62 ], 13, 13, 12, 11, 13, 13, 13, [ 14, 67 ], 13, [ 0, 34, "Jo" ], 
  11, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [ 0, 26, "Jo" ], 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 13, 11, 12, 
  11, 11, 13, [ 14, 103 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 124 ], 
  11, [ 14, 157 ], [ 14, 168 ], [ 14, 121 ], [ 14, 122 ], [ 14, 154 ], 
  [ 14, 170 ], [ 14, 178 ], [ 14, 182 ] ],
#V   n = 187
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, [ 0, 87, "BK" ], 13, 13, 
  [ 0, 85, "BK" ], 13, [ 0, 83, "BK" ], 13, 13, 11, 13, [ 0, 79, "BK" ], 13, 
  13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 12, 
  12, 11, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 13, [ 14, 29 ], 13, 13, 
  [ 14, 28 ], 13, 13, 13, [ 14, 32 ], 13, 13, 13, [ 14, 32 ], 13, 13, 13, 13, 
  13, [ 14, 47 ], 13, 13, 13, [ 14, 48 ], 13, 13, 13, [ 14, 52 ], 13, 13, 13, 
  13, [ 14, 57 ], 13, 13, 11, 13, 13, 13, [ 14, 60 ], 13, 13, 13, [ 14, 63 ], 
  13, 13, 12, 11, 13, 13, 13, [ 14, 68 ], 12, 11, 11, 13, 12, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 11, [ 0, 16, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 
  11, 12, 11, 11, 11, 13, 12, 11, 11, [ 14, 77 ], 11, 12, 11, 11, 13, 
  [ 14, 104 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 125 ], 11, 
  [ 14, 158 ], [ 14, 169 ], [ 14, 122 ], [ 14, 123 ], [ 14, 155 ], 
  [ 14, 171 ], [ 14, 179 ], [ 14, 183 ] ],
#V   n = 188
[ ,,,,,,,,,, [ 14, 5 ], 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 
  12, 12, 11, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 13, [ 14, 30 ], 13, 13, 
  [ 14, 29 ], 13, 13, 13, [ 14, 33 ], 13, 13, 13, [ 14, 33 ], 13, 13, 13, 13, 
  13, [ 14, 48 ], 13, 13, 13, [ 14, 49 ], 13, 13, 13, [ 14, 53 ], 13, 13, 13, 
  13, [ 14, 58 ], 13, 13, [ 14, 43 ], 13, 13, 13, [ 14, 61 ], 13, 13, 13, 
  [ 14, 64 ], 13, 13, 12, 11, 13, 13, 13, 12, 12, 11, 11, 13, 12, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 13, 12, 11, 11, [ 14, 78 ], 11, 12, 11, 11, 13, [ 14, 105 ], 12, 
  11, 11, 11, 11, 13, 12, 11, 13, [ 14, 126 ], 11, [ 14, 159 ], [ 14, 170 ], 
  [ 14, 123 ], [ 14, 124 ], [ 14, 156 ], [ 14, 172 ], [ 14, 180 ], 
  [ 14, 184 ] ],
#V   n = 189
[ ,,,,,,,,,,, [ 0, 89, "BK" ], 13, 13, 11, 13, [ 0, 85, "BK" ], 13, 
  [ 0, 83, "BK" ], 13, 13, [ 0, 81, "BK" ], 13, [ 0, 79, "BK" ], 13, 13, 13, 
  11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 12, 12, 
  11, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 13, [ 14, 31 ], 13, 13, 
  [ 14, 30 ], 13, 13, 13, [ 14, 34 ], 13, 13, 13, [ 14, 34 ], 13, 13, 13, 13, 
  13, 13, 13, 13, 13, [ 14, 50 ], 13, 13, 13, [ 14, 54 ], 13, 13, 13, 13, 
  [ 14, 59 ], 13, 13, [ 14, 44 ], 13, 13, 13, [ 14, 62 ], 13, 13, 13, 
  [ 14, 65 ], 13, 13, 12, 11, 13, 13, 12, 12, 12, 11, 11, 13, [ 0, 32, "Jo" ],
  11, 11, 12, 11, 11, 11, [ 0, 28, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, [ 14, 79 ], 11, 12, 11, 
  11, 13, [ 14, 106 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 127 ], 11, 
  [ 14, 160 ], [ 14, 171 ], [ 14, 124 ], [ 14, 125 ], [ 14, 157 ], 
  [ 14, 173 ], [ 14, 181 ], [ 14, 185 ] ],
#V   n = 190
[ ,,,,,,,,, [ 14, 4 ],, 13, 13, 13, 13, 11, 13, 11, 13, 11, 13, 13, 11, 13, 
  11, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 
  13, 13, 12, 12, 11, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 13, [ 14, 32 ], 
  13, 13, [ 14, 31 ], 13, 13, 13, [ 14, 35 ], 13, 13, 13, [ 14, 35 ], 13, 13, 
  13, 13, [ 14, 32 ], 11, 13, 13, 13, [ 14, 51 ], 13, 13, 13, [ 14, 55 ], 13, 
  13, 13, 13, [ 14, 60 ], 13, 13, [ 14, 45 ], 13, 13, 13, [ 14, 63 ], 13, 13, 
  13, [ 14, 66 ], 13, 13, [ 0, 38, "Jo" ], 11, 13, 13, 12, 13, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, [ 14, 80 ], 11, 12, 11, 11, 13, 
  [ 14, 107 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 128 ], 11, 
  [ 14, 161 ], [ 14, 172 ], [ 14, 125 ], [ 14, 126 ], [ 14, 158 ], 
  [ 14, 174 ], [ 14, 182 ], [ 14, 186 ] ],
#V   n = 191
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, [ 0, 89, "BK" ], 13, 13, 13, 11, 13, 
  11, 13, 11, 13, 13, 11, 13, 11, 13, 13, 13, 11, 13, 13, 13, [ 14, 12 ], 13, 
  13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 12, 12, 11, 13, 13, 13, 12, 12, 
  11, 13, 13, 13, 13, 13, [ 14, 33 ], 13, 13, [ 14, 32 ], 13, 13, 13, 
  [ 14, 36 ], 13, 13, 13, [ 14, 36 ], 13, 13, 13, 13, 11, 13, 13, 13, 13, 
  [ 14, 52 ], 13, 13, 13, [ 14, 56 ], 13, 13, 13, 13, [ 14, 42 ], 13, 13, 
  [ 14, 46 ], 13, 13, 13, [ 14, 64 ], 13, 13, 13, [ 14, 67 ], 13, 12, 11, 11, 
  13, 13, 13, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 13, 12, 11, 11, 
  [ 14, 81 ], 11, 12, 11, 11, 13, [ 14, 108 ], 12, 11, 11, 11, 11, 13, 12, 
  11, 13, [ 14, 129 ], 11, [ 14, 162 ], [ 14, 173 ], [ 14, 126 ], 
  [ 14, 127 ], [ 14, 159 ], [ 14, 175 ], [ 14, 183 ], [ 14, 187 ] ],
#V   n = 192
[ ,,,,,,,,,, [ 14, 5 ], 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 
  13, 13, 11, 13, 13, 13, 11, 13, 13, 13, [ 14, 13 ], 13, 13, 13, 11, 13, 13, 
  11, 13, 13, 13, 13, 13, 12, 12, 11, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 
  13, [ 14, 34 ], 13, 13, [ 14, 33 ], 13, 13, 13, [ 14, 37 ], 13, 13, 13, 
  [ 14, 37 ], 13, 13, 13, 13, [ 14, 34 ], 13, 13, 13, 13, [ 14, 53 ], 13, 13, 
  13, [ 14, 57 ], 13, 13, 13, [ 14, 42 ], 13, 13, 13, [ 14, 47 ], 13, 13, 13, 
  [ 14, 65 ], 13, 13, 13, [ 14, 68 ], 13, 12, 11, 11, 13, [ 0, 36, "Jo" ], 
  13, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 11, [ 0, 12, "Jo" ], 11, 11, 11, 13, 
  [ 0, 10, "Jo" ], 11, 11, [ 14, 82 ], 11, 12, 11, 11, 13, [ 14, 109 ], 12, 
  11, 11, 11, 11, 13, 12, 11, 13, [ 14, 130 ], 11, [ 14, 163 ], [ 14, 174 ], 
  [ 14, 127 ], [ 14, 128 ], [ 14, 160 ], [ 14, 176 ], [ 14, 184 ], 
  [ 14, 188 ] ],
#V   n = 193
[ ,,,,,,,,, [ 14, 4 ],, [ 0, 91, "BK" ], 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, [ 14, 14 ], 13, 13, 
  13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 12, 12, 11, 13, 13, 13, 12, 12, 11, 
  13, 13, 13, 13, 13, [ 14, 35 ], 13, 13, [ 14, 34 ], 13, 13, 13, [ 14, 38 ], 
  13, 13, 13, [ 14, 38 ], 13, 13, 13, 13, [ 14, 35 ], 13, 13, 13, 13, 
  [ 14, 54 ], 13, 13, 13, [ 14, 58 ], 13, 13, 13, [ 14, 43 ], 13, 13, 13, 
  [ 14, 48 ], 13, 13, 13, [ 14, 66 ], 13, 13, 13, [ 14, 69 ], 13, 12, 11, 11, 
  12, 11, 13, 13, [ 0, 34, "Jo" ], 11, 11, 12, 11, 11, 11, [ 0, 30, "Jo" ], 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [ 0, 24, "Jo" ], 11, 11, 11, 
  [ 0, 22, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 83 ], 11, 
  12, 11, 11, 13, [ 14, 110 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, 
  [ 14, 131 ], 11, [ 14, 164 ], [ 14, 175 ], [ 14, 128 ], [ 14, 129 ], 
  [ 14, 161 ], [ 14, 177 ], [ 14, 185 ], [ 14, 189 ] ],
#V   n = 194
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, 13, 13, 13, 13, 13, 13, 13, 
  [ 0, 85, "BK" ], 13, 13, 13, 13, [ 0, 81, "BK" ], 13, 13, [ 0, 79, "BK" ], 
  13, 13, 13, 13, 13, 13, 13, 13, [ 14, 15 ], 13, 13, [ 14, 14 ], 11, 13, 13, 
  13, 13, 13, 13, 13, 13, 12, 12, 13, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 
  13, [ 14, 36 ], 13, 13, [ 14, 35 ], 13, 13, 13, [ 14, 39 ], 13, 13, 13, 
  [ 14, 39 ], 13, 13, 13, 13, [ 14, 36 ], 13, 13, 13, 13, [ 14, 55 ], 13, 13, 
  13, [ 14, 59 ], 13, 13, 13, [ 14, 44 ], 13, 13, 13, [ 14, 49 ], 13, 13, 13, 
  [ 14, 67 ], 13, 13, 13, [ 14, 70 ], 13, 12, 11, 11, 12, 11, 13, 12, 11, 11, 
  11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, [ 0, 20, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 84 ], 
  11, 12, 11, 11, 13, [ 14, 111 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, 
  [ 14, 132 ], 11, [ 14, 165 ], [ 14, 176 ], [ 14, 129 ], [ 14, 130 ], 
  [ 14, 162 ], [ 14, 178 ], [ 14, 186 ], [ 14, 190 ] ],
#V   n = 195
[ ,,,,,,,,,, [ 14, 5 ], 13, [ 0, 91, "BK" ], 13, 13, [ 0, 89, "BK" ], 13, 13, 
  13, 13, 11, 13, [ 0, 83, "BK" ], 13, 13, 11, 13, 13, 13, 13, 13, 
  [ 0, 77, "BK" ], 13, 13, 13, 13, 13, [ 14, 16 ], 13, 13, 11, 13, 13, 
  [ 14, 16 ], 13, 13, 13, 13, 13, 13, 12, [ 14, 20 ], 13, 13, 13, 13, 12, 12, 
  11, 13, 13, 13, 13, 13, [ 14, 37 ], 13, 13, [ 14, 36 ], 13, 13, 13, 
  [ 14, 40 ], 13, 13, 13, [ 14, 40 ], 13, 13, 13, 13, [ 14, 37 ], 11, 13, 13, 
  13, [ 14, 56 ], 13, 13, 13, [ 14, 60 ], 13, 13, 13, [ 14, 45 ], 13, 13, 13, 
  [ 14, 50 ], 13, 13, 13, [ 14, 68 ], 13, 13, 13, [ 14, 71 ], 13, 12, 11, 11, 
  12, 11, 13, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  [ 14, 85 ], 11, 12, 11, 11, 13, [ 14, 112 ], 12, 11, 11, 11, 11, 13, 12, 
  11, 13, [ 14, 133 ], 11, [ 14, 166 ], [ 14, 177 ], [ 14, 130 ], 
  [ 14, 131 ], [ 14, 163 ], [ 14, 179 ], [ 14, 187 ], [ 14, 191 ] ],
#V   n = 196
[ ,,,,,,,,,,, 13, 13, 11, 13, 13, 13, [ 0, 87, "BK" ], 13, 13, 13, 13, 13, 
  13, 13, 13, 11, 13, [ 0, 79, "BK" ], 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  [ 14, 17 ], 13, 13, [ 14, 16 ], 13, 13, [ 14, 17 ], 13, 13, 13, 13, 13, 13, 
  12, [ 14, 21 ], 13, 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 13, [ 14, 38 ], 
  13, 13, [ 14, 37 ], 13, 13, 13, [ 14, 41 ], 13, 13, 13, [ 14, 41 ], 13, 13, 
  13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 13, [ 14, 42 ], 13, 13, 13, 
  [ 14, 46 ], 13, 13, 13, [ 14, 51 ], 13, 13, 13, [ 14, 69 ], 13, 13, 13, 
  [ 14, 72 ], 13, [ 0, 38, "Jo" ], 11, 11, 12, 11, 13, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [ 0, 26, "Jo" ], 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 86 ], 11, 12, 
  11, 11, 13, [ 14, 113 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 134 ], 
  11, [ 14, 167 ], [ 14, 178 ], [ 14, 131 ], [ 14, 132 ], [ 14, 164 ], 
  [ 14, 180 ], [ 14, 188 ], [ 14, 192 ] ],
#V   n = 197
[ ,,,,,,,,,,, [ 0, 93, "BK" ], 13, 13, 11, 13, [ 0, 89, "BK" ], 13, 11, 13, 
  13, [ 0, 85, "BK" ], 13, [ 0, 83, "BK" ], 13, 13, 13, 13, 13, 11, 13, 13, 
  [ 0, 77, "BK" ], 13, 13, 13, 13, 13, 13, [ 14, 18 ], 13, 13, [ 14, 17 ], 
  13, 13, [ 14, 18 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 22 ], 13, 13, 13, 13, 
  12, 12, 11, 13, 13, 13, 13, 13, [ 14, 39 ], 13, 13, [ 14, 38 ], 13, 13, 13, 
  [ 14, 42 ], 13, 13, 13, [ 14, 42 ], 13, 13, 13, 13, [ 14, 39 ], 13, 13, 13, 
  [ 14, 38 ], 11, 13, 13, [ 14, 42 ], 13, 13, 13, 13, [ 14, 47 ], 13, 13, 13, 
  [ 14, 52 ], 13, 13, 13, [ 14, 70 ], 13, 13, 13, [ 14, 73 ], 12, 11, 11, 11, 
  12, 11, 13, 12, 11, 11, 11, [ 0, 32, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 0, 18, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 11, [ 0, 14, "Jo" ], 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 87 ], 11, 12, 11, 11, 13, 
  [ 14, 114 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 135 ], 11, 
  [ 14, 168 ], [ 14, 179 ], [ 14, 132 ], [ 14, 133 ], [ 14, 165 ], 
  [ 14, 181 ], [ 14, 189 ], [ 14, 193 ] ],
#V   n = 198
[ ,,,,,,,,,,, 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 
  [ 0, 81, "BK" ], 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  [ 14, 19 ], 13, 13, [ 14, 18 ], 13, 13, [ 14, 19 ], 13, 13, 13, 13, 13, 12, 
  12, [ 14, 23 ], 13, 13, 13, 13, 12, 12, 13, 13, 13, 13, 13, 13, [ 14, 40 ], 
  13, 13, [ 14, 39 ], 13, 13, 13, [ 14, 43 ], 13, 13, 13, [ 14, 43 ], 13, 13, 
  13, 13, [ 14, 40 ], 13, 13, 13, 11, 11, 13, 13, [ 14, 43 ], 13, 13, 13, 13, 
  [ 14, 48 ], 13, 13, 13, [ 14, 53 ], 13, 13, 13, [ 14, 71 ], 13, 13, 13, 12, 
  12, 11, 11, 11, [ 0, 36, "Jo" ], 11, 13, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, [ 0, 28, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 88 ], 11, 12, 11, 11, 13, 
  [ 14, 115 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 136 ], 11, 
  [ 14, 169 ], [ 14, 180 ], [ 14, 133 ], [ 14, 134 ], [ 14, 166 ], 
  [ 14, 182 ], [ 14, 190 ], [ 14, 194 ] ],
#V   n = 199
[ ,,,,,,,,,,, 13, [ 0, 93, "BK" ], 13, 13, [ 0, 91, "BK" ], 13, 13, 13, 13, 
  13, 13, [ 0, 85, "BK" ], 13, [ 0, 83, "BK" ], 13, 13, 13, 13, 13, 13, 11, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, [ 14, 20 ], 13, 13, [ 14, 19 ], 13, 13, 
  [ 14, 20 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 24 ], 13, 13, 13, 13, 12, 
  [ 14, 24 ], 11, 13, 13, 13, 13, 13, [ 14, 41 ], 13, 13, [ 14, 40 ], 13, 13, 
  13, [ 14, 44 ], 13, 13, 13, [ 14, 44 ], 13, 13, 13, 13, [ 14, 41 ], 13, 13, 
  13, 11, 11, 13, 13, [ 14, 44 ], 13, 13, 13, 13, [ 14, 49 ], 13, 13, 13, 
  [ 14, 54 ], 13, 13, 13, [ 14, 72 ], 13, 13, 12, 12, 12, 11, 11, 12, 11, 11, 
  13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 89 ], 
  11, 12, 11, 11, 13, [ 14, 116 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, 
  [ 14, 137 ], 11, [ 14, 170 ], [ 14, 181 ], [ 14, 134 ], [ 14, 135 ], 
  [ 14, 167 ], [ 14, 183 ], [ 14, 191 ], [ 14, 195 ] ],
#V   n = 200
[ ,,,,,,,,, [ 14, 4 ],, 13, 13, 11, 13, 13, 13, [ 0, 89, "BK" ], 13, 13, 
  [ 0, 87, "BK" ], 13, 13, 13, 13, 11, 13, 13, [ 0, 81, "BK" ], 13, 13, 13, 
  11, 13, [ 0, 77, "BK" ], 13, 13, 13, 13, 13, 13, 13, [ 14, 21 ], 13, 13, 
  [ 14, 20 ], 13, 13, [ 14, 21 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 25 ], 13, 
  13, 13, 13, 12, 11, 13, 13, 13, 13, 13, 13, [ 14, 42 ], 13, 13, [ 14, 41 ], 
  13, 13, 13, [ 14, 45 ], 13, 13, 13, [ 14, 45 ], 13, 13, 13, 13, [ 14, 42 ], 
  13, 13, 13, 11, 11, 13, 13, [ 14, 45 ], 13, 13, 13, 13, [ 14, 50 ], 13, 13, 
  13, [ 14, 55 ], 13, 13, 13, [ 14, 73 ], 13, 13, 12, 12, 12, 11, 11, 12, 11, 
  11, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  [ 14, 90 ], 11, [ 0, 8, "Jo" ], 11, 11, 13, [ 14, 117 ], 12, 11, 11, 11, 
  11, 13, 12, 11, 13, [ 14, 138 ], 11, [ 14, 171 ], [ 14, 182 ], [ 14, 135 ], 
  [ 14, 136 ], [ 14, 168 ], [ 14, 184 ], [ 14, 192 ], [ 14, 196 ] ],
#V   n = 201
[ ,,,,,,, [ 0, 98, "Be" ],, [ 14, 4 ], [ 14, 5 ], [ 0, 95, "BK" ], 13, 13, 
  11, 13, [ 0, 91, "BK" ], 13, 13, 13, 13, 11, 13, [ 0, 85, "BK" ], 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 13, 13, 
  [ 14, 22 ], 13, 13, [ 14, 21 ], 13, 13, [ 14, 22 ], 13, 13, 13, 13, 13, 12, 
  12, [ 14, 26 ], 13, 13, 13, 12, 11, [ 14, 26 ], 13, 13, 13, 13, 13, 13, 
  [ 14, 43 ], 13, 13, [ 14, 42 ], 13, 13, 13, [ 14, 46 ], 13, 13, 13, 
  [ 14, 46 ], 13, 13, 13, 13, [ 14, 43 ], 13, 13, 13, 11, 13, 13, 13, 
  [ 14, 46 ], 13, 13, 13, 13, [ 14, 51 ], 13, 13, 13, [ 14, 56 ], 13, 13, 13, 
  [ 14, 74 ], 13, 13, 12, 12, 12, 11, 11, 12, 11, 11, 13, [ 0, 34, "Jo" ], 
  11, 11, 12, 11, 11, 11, [ 0, 30, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  [ 14, 91 ], 12, 11, 11, 11, 13, [ 14, 118 ], 12, 11, 11, 11, 11, 13, 12, 
  11, 13, [ 14, 139 ], 11, [ 14, 172 ], [ 14, 183 ], [ 14, 136 ], 
  [ 14, 137 ], [ 14, 169 ], [ 14, 185 ], [ 14, 193 ], [ 14, 197 ] ],
#V   n = 202
[ ,,,,,,, 12, 11,, [ 14, 5 ], [ 14, 6 ], 13, 13, 13, 13, 13, 13, 
  [ 0, 89, "BK" ], 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 
  13, 11, 13, 11, 13, 13, 13, 13, 13, 13, 13, [ 14, 23 ], 13, 13, [ 14, 22 ], 
  13, 13, [ 14, 23 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 27 ], 13, 13, 13, 11, 
  12, [ 14, 27 ], 13, 13, 13, 13, 13, 13, [ 14, 44 ], 13, 13, [ 14, 43 ], 13, 
  13, 13, [ 14, 47 ], 13, 13, 13, [ 14, 47 ], 13, 13, 13, 13, [ 14, 44 ], 13, 
  13, 13, [ 14, 43 ], 13, 13, 13, [ 14, 47 ], 13, 13, 13, 13, [ 14, 52 ], 13, 
  13, 13, [ 14, 57 ], 13, 13, 13, [ 14, 50 ], 13, 13, 12, 13, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  [ 14, 92 ], 12, 11, 11, 11, 13, [ 14, 119 ], 12, 11, 11, 11, 11, 13, 12, 
  11, 13, [ 14, 140 ], 11, [ 14, 173 ], [ 14, 184 ], [ 14, 137 ], 
  [ 14, 138 ], [ 14, 170 ], [ 14, 186 ], [ 14, 194 ], [ 14, 198 ] ],
#V   n = 203
[ ,,,,,,,, 12, 11,, [ 14, 6 ], [ 0, 95, "BK" ], 13, 13, [ 0, 93, "BK" ], 13, 
  13, 13, 11, 13, 13, [ 0, 87, "BK" ], 13, [ 0, 85, "BK" ], 13, 13, 13, 11, 
  13, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 13, 13, [ 14, 24 ], 
  13, 13, [ 14, 23 ], 13, 13, [ 14, 24 ], 13, 13, 13, 13, 13, 12, 12, 
  [ 14, 28 ], 13, 13, 13, 12, 12, [ 14, 28 ], 13, 13, 13, 13, 13, 13, 13, 13, 
  13, [ 14, 44 ], 13, 13, 13, [ 14, 48 ], 13, 13, 13, [ 14, 48 ], 13, 13, 13, 
  13, [ 14, 45 ], 13, 13, 13, [ 14, 44 ], 13, 13, 13, [ 14, 48 ], 13, 13, 13, 
  13, [ 14, 53 ], 13, 13, 13, [ 14, 58 ], 13, 13, [ 14, 50 ], [ 14, 51 ], 13, 
  13, [ 14, 53 ], 12, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, [ 14, 93 ], 12, 11, 11, 11, 13, 
  [ 14, 120 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 141 ], 11, 
  [ 14, 174 ], [ 14, 185 ], [ 14, 138 ], [ 14, 139 ], [ 14, 171 ], 
  [ 14, 187 ], [ 14, 195 ], [ 14, 199 ] ],
#V   n = 204
[ ,,,,,,,,, [ 14, 4 ], 11,, 13, 13, 13, 13, 13, [ 0, 91, "BK" ], 13, 13, 11, 
  13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 11, 13, 
  13, 13, 13, 13, 13, 13, [ 14, 25 ], 13, 13, [ 14, 24 ], 13, 13, [ 14, 25 ], 
  13, 13, 13, 13, 13, 12, 12, [ 14, 29 ], 13, 13, 13, 12, 12, [ 14, 29 ], 13, 
  13, 13, 13, 13, [ 14, 30 ], 13, 13, 13, [ 14, 45 ], 13, 13, 13, [ 14, 49 ], 
  13, 13, 13, [ 14, 49 ], 13, 13, 13, 13, [ 14, 46 ], 13, 13, 13, [ 14, 45 ], 
  13, 13, 13, [ 14, 49 ], 13, 13, 13, 13, [ 14, 54 ], 13, 13, 13, [ 14, 59 ], 
  13, 13, [ 14, 51 ], [ 14, 52 ], 13, 13, 12, 13, [ 0, 38, "Jo" ], 11, 11, 
  12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, [ 0, 24, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, [ 0, 16, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, [ 14, 94 ], 12, 11, 11, 11, 13, 
  [ 14, 121 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 142 ], 11, 
  [ 14, 175 ], [ 14, 186 ], [ 14, 139 ], [ 14, 140 ], [ 14, 172 ], 
  [ 14, 188 ], [ 14, 196 ], [ 14, 200 ] ],
#V   n = 205
[ ,,,,,,,,,, [ 14, 4 ], 11, 13, [ 0, 95, "BK" ], 13, 13, [ 0, 93, "BK" ], 13, 
  13, 13, 13, 11, 13, [ 0, 87, "BK" ], 13, 13, 11, 13, 13, 13, 11, 13, 13, 
  11, 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 13, 13, [ 14, 26 ], 13, 13, 
  [ 14, 25 ], 13, 13, [ 14, 26 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 30 ], 13, 
  13, 13, 12, 12, [ 14, 30 ], 13, 13, 13, 13, 13, [ 14, 31 ], 13, 13, 13, 
  [ 14, 46 ], 13, 13, 13, [ 14, 50 ], 13, 13, 13, [ 14, 50 ], 13, 13, 13, 13, 
  [ 14, 47 ], 13, 13, 13, [ 14, 46 ], 13, 13, 13, [ 14, 50 ], 13, 13, 13, 13, 
  [ 14, 55 ], 13, 13, 13, [ 14, 60 ], 13, 13, [ 14, 52 ], [ 14, 53 ], 13, 13, 
  [ 14, 55 ], 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, [ 0, 22, "Jo" ], 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 95 ], 12, 11, 11, 11, 13, 
  [ 14, 122 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 143 ], 11, 
  [ 14, 176 ], [ 14, 187 ], [ 14, 140 ], [ 14, 141 ], [ 14, 173 ], 
  [ 14, 189 ], [ 14, 197 ], [ 14, 201 ] ],
#V   n = 206
[ ,,,,,,,,,, 12, [ 14, 5 ], 13, 13, 11, 13, 13, 13, [ 0, 91, "BK" ], 13, 13, 
  13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 
  11, 13, 13, 13, 13, 13, 13, 13, [ 14, 27 ], 13, 13, [ 14, 26 ], 13, 13, 
  [ 14, 27 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 31 ], 13, 13, 13, 12, 12, 
  [ 14, 31 ], 13, 13, 13, 13, 13, [ 14, 32 ], 13, 13, 13, [ 14, 47 ], 13, 13, 
  13, [ 14, 51 ], 13, 13, 13, [ 14, 51 ], 13, 13, 13, 13, [ 14, 48 ], 13, 13, 
  13, [ 14, 47 ], 13, 13, 13, [ 14, 51 ], 13, 13, 13, 13, [ 14, 56 ], 13, 13, 
  13, [ 14, 61 ], 13, 13, [ 14, 53 ], 13, 13, 13, 12, 12, 11, 11, 11, 
  [ 0, 36, "Jo" ], 11, 11, 12, 11, 11, 11, [ 0, 32, "Jo" ], 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, [ 0, 26, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 96 ], 12, 11, 11, 11, 13, 
  [ 14, 123 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 144 ], 11, 
  [ 14, 177 ], [ 14, 188 ], [ 14, 141 ], [ 14, 142 ], [ 14, 174 ], 
  [ 14, 190 ], [ 14, 198 ], [ 14, 202 ] ],
#V   n = 207
[ ,,,,,,,,, [ 14, 4 ],, 12, [ 0, 97, "BK" ], 13, 13, 11, 13, 13, 13, 11, 13, 
  13, [ 0, 89, "BK" ], 13, [ 0, 87, "BK" ], 13, 13, 13, 13, 13, 13, 13, 11, 
  13, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 13, 13, [ 14, 28 ], 
  13, 13, [ 14, 27 ], 13, 13, [ 14, 28 ], 13, 13, 13, 13, 13, 12, 12, 
  [ 14, 32 ], 13, 13, 13, 12, 12, [ 14, 32 ], 13, 13, 13, 13, 13, [ 14, 33 ], 
  13, 13, 13, [ 14, 48 ], 13, 13, 13, [ 14, 52 ], 13, 13, 13, [ 14, 52 ], 13, 
  13, 13, 13, [ 14, 49 ], 13, 13, 13, [ 14, 48 ], 13, 13, 13, [ 14, 52 ], 13, 
  13, 13, 13, [ 14, 57 ], 13, 13, 13, [ 14, 62 ], 13, 13, 13, 13, 13, 12, 13, 
  12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  [ 0, 28, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  11, [ 0, 20, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 97 ], 12, 11, 11, 
  11, 13, [ 14, 124 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 145 ], 11, 
  [ 14, 178 ], [ 14, 189 ], [ 14, 142 ], [ 14, 143 ], [ 14, 175 ], 
  [ 14, 191 ], [ 14, 199 ], [ 14, 203 ] ],
#V   n = 208
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ],, 13, 13, 13, 13, 13, [ 0, 93, "BK" ], 13, 
  13, 11, 13, 13, 11, 13, 11, 13, 13, [ 0, 85, "BK" ], 13, 13, 13, 13, 11, 
  13, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 13, 13, [ 14, 29 ], 
  13, 13, [ 14, 28 ], 13, 13, [ 14, 29 ], 13, 13, 13, 13, 13, 12, 12, 
  [ 14, 33 ], 13, 13, 13, 12, 12, [ 14, 33 ], 13, 13, 13, 13, 13, [ 14, 34 ], 
  13, 13, 13, [ 14, 49 ], 13, 13, 13, [ 14, 53 ], 13, 13, 13, [ 14, 53 ], 13, 
  13, 13, 13, [ 14, 50 ], 13, 13, 13, [ 14, 49 ], 13, 13, 13, [ 14, 53 ], 13, 
  13, 13, 13, [ 14, 58 ], 13, 13, 13, [ 14, 63 ], 13, [ 0, 42, "Jo" ], 13, 
  13, 13, 13, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, [ 14, 98 ], 12, 11, 11, 11, 13, 
  [ 14, 125 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 146 ], 11, 
  [ 14, 179 ], [ 14, 190 ], [ 14, 143 ], [ 14, 144 ], [ 14, 176 ], 
  [ 14, 192 ], [ 14, 200 ], [ 14, 204 ] ],
#V   n = 209
[ ,,,,,,,,,, [ 14, 5 ], [ 14, 6 ], 13, [ 0, 97, "BK" ], 13, 13, 
  [ 0, 95, "BK" ], 13, 13, 13, 13, 11, 13, 13, 13, 13, 11, 13, 13, 13, 13, 
  13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 13, 
  13, [ 14, 30 ], 13, 13, [ 14, 29 ], 13, 13, [ 14, 30 ], 13, 13, 13, 13, 13, 
  12, 12, [ 14, 34 ], 13, 13, 13, 12, 12, [ 14, 34 ], 13, 13, 13, 13, 13, 
  [ 14, 35 ], 13, 13, 13, [ 14, 50 ], 13, 13, 13, [ 14, 54 ], 13, 13, 13, 
  [ 14, 54 ], 13, 13, 13, 13, [ 14, 51 ], 13, 13, 13, [ 14, 50 ], 13, 13, 13, 
  [ 14, 54 ], 13, 13, 13, 13, [ 14, 59 ], 13, 13, 13, [ 14, 64 ], 12, 11, 13, 
  13, [ 0, 40, "Jo" ], 13, 13, 12, 11, 11, 12, 11, 11, 11, [ 0, 34, "Jo" ], 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 99 ], 12, 
  11, 11, 11, 13, [ 14, 126 ], 12, 11, 11, 11, 11, 13, 12, 11, 13, 
  [ 14, 147 ], 11, [ 14, 180 ], [ 14, 191 ], [ 14, 144 ], [ 14, 145 ], 
  [ 14, 177 ], [ 14, 193 ], [ 14, 201 ], [ 14, 205 ] ],
#V   n = 210
[ ,,,,,,,,, [ 14, 4 ],, [ 14, 6 ], 13, 13, 11, 13, 13, 13, [ 0, 93, "BK" ], 
  13, 13, 13, 13, 13, 13, 13, 13, 11, 13, [ 0, 85, "BK" ], 13, 13, 13, 13, 
  13, 13, 13, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, [ 14, 30 ], 13, 13, [ 14, 31 ], 13, 13, 13, 13, 13, 12, 12, 
  [ 14, 35 ], 13, 13, 13, 12, 12, [ 14, 35 ], 13, 13, 13, 13, 13, [ 14, 36 ], 
  13, 13, 13, [ 14, 51 ], 13, 13, 13, [ 14, 55 ], 13, 13, 13, [ 14, 55 ], 13, 
  13, 13, 13, [ 14, 52 ], 13, 13, 13, [ 14, 51 ], 13, 13, 13, [ 14, 55 ], 13, 
  13, 13, 13, [ 14, 60 ], 13, 13, 13, 12, 12, 11, 13, 12, 11, 13, 13, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, [ 14, 100 ], 12, 11, 11, 11, 13, [ 14, 127 ], 12, 11, 11, 11, 11, 
  13, 12, 11, 13, [ 14, 148 ], 11, [ 14, 181 ], [ 14, 192 ], [ 14, 145 ], 
  [ 14, 146 ], [ 14, 178 ], [ 14, 194 ], [ 14, 202 ], [ 14, 206 ] ],
#V   n = 211
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ],, [ 0, 99, "BK" ], 13, 13, 11, 13, 13, 13, 
  11, 13, 13, [ 0, 91, "BK" ], 13, [ 0, 89, "BK" ], 13, 13, 13, 13, 13, 11, 
  13, 13, 13, 13, [ 14, 12 ], 11, 13, 13, 11, 13, 13, 13, 13, 13, 11, 13, 13, 
  13, 13, 13, 13, [ 14, 20 ], 13, 13, 13, [ 14, 31 ], 13, 13, [ 14, 32 ], 13, 
  13, 13, 13, 13, 12, 12, [ 14, 36 ], 13, 13, 13, 12, 12, [ 14, 36 ], 13, 13, 
  13, 13, 13, [ 14, 37 ], 13, 13, 13, [ 14, 52 ], 13, 13, 13, [ 14, 56 ], 13, 
  13, 13, [ 14, 56 ], 13, 13, 13, 13, [ 14, 53 ], 13, 13, 13, [ 14, 52 ], 13, 
  13, 13, [ 14, 56 ], 13, 13, 13, 13, [ 14, 61 ], 13, 13, 12, 12, 12, 11, 13, 
  12, 11, 13, 13, [ 0, 38, "Jo" ], 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, [ 0, 30, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  [ 14, 101 ], 12, 11, 11, 11, 13, [ 14, 128 ], 12, 11, 11, 11, 11, 13, 12, 
  11, 13, [ 14, 149 ], 11, [ 14, 182 ], [ 14, 193 ], [ 14, 146 ], 
  [ 14, 147 ], [ 14, 179 ], [ 14, 195 ], [ 14, 203 ], [ 14, 207 ] ],
#V   n = 212
[ ,,,,,,,,,, 13, [ 14, 6 ], 12, 11, 13, 13, 11, [ 0, 95, "BK" ], 13, 13, 11, 
  13, 13, 11, 13, 11, 13, 13, [ 0, 87, "BK" ], 13, 13, 11, 13, 13, 13, 13, 
  11, 13, 13, 13, 11, 13, 13, [ 14, 16 ], 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  [ 14, 21 ], 13, 13, 13, [ 14, 32 ], 13, 13, [ 14, 33 ], 13, 13, 13, 13, 13, 
  12, 12, [ 14, 37 ], 13, 13, 13, 12, 12, [ 14, 37 ], 13, 13, 13, 13, 13, 
  [ 14, 38 ], 13, 13, 13, [ 14, 53 ], 13, 13, 13, 13, 13, 13, 13, [ 14, 57 ], 
  13, 13, 13, 13, [ 14, 54 ], 13, 13, 13, [ 14, 53 ], 13, 13, 13, [ 14, 57 ], 
  13, 13, 13, 13, [ 14, 62 ], 13, 13, 12, 12, 12, 11, 13, 12, 11, 13, 12, 11, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, [ 14, 102 ], 12, 11, 11, 11, 13, [ 14, 129 ], 12, 11, 11, 11, 
  11, 13, 12, 11, 13, [ 14, 150 ], 11, [ 14, 183 ], [ 14, 194 ], [ 14, 147 ], 
  [ 14, 148 ], [ 14, 180 ], [ 14, 196 ], [ 14, 204 ], [ 14, 208 ] ],
#V   n = 213
[ ,,,,,,,,,, 13, 13, 12, 13, 11, 13, 13, 12, 11, 13, 13, 11, 13, 13, 11, 13, 
  11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, [ 14, 14 ], 13, 13, 13, 11, 13, 
  13, [ 14, 17 ], 13, 13, 11, 13, 13, 13, 13, 13, 13, [ 14, 22 ], 13, 13, 13, 
  [ 14, 33 ], 13, 13, [ 14, 34 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 38 ], 13, 
  13, 13, 12, 12, [ 14, 38 ], 13, 13, 13, 13, 13, [ 14, 39 ], 13, 13, 13, 
  [ 14, 54 ], 13, 13, [ 14, 38 ], 11, 13, 13, 13, [ 14, 58 ], 13, 13, 13, 13, 
  [ 14, 55 ], 13, 13, 13, [ 14, 54 ], 13, 13, 13, [ 14, 58 ], 13, 13, 13, 13, 
  [ 14, 63 ], 13, 13, 12, 12, 12, 11, 13, 12, 11, 13, 12, 11, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, [ 0, 18, "Jo" ], 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, [ 14, 103 ], 12, 11, 11, 11, 13, [ 14, 130 ], 12, 11, 11, 11, 
  11, 13, 12, 11, 13, [ 14, 151 ], 11, [ 14, 184 ], [ 14, 195 ], [ 14, 148 ], 
  [ 14, 149 ], [ 14, 181 ], [ 14, 197 ], [ 14, 205 ], [ 14, 209 ] ],
#V   n = 214
[ ,,,,,,,,,, [ 0, 103, "BK" ], 13, 13, 13, 13, 11, 13, 12, 13, 11, 13, 13, 
  11, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, [ 14, 15 ], 
  13, 13, 13, 11, 13, 13, [ 14, 18 ], 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  [ 14, 23 ], 13, 13, 13, [ 14, 34 ], 13, 13, [ 14, 35 ], 13, 13, 13, 13, 13, 
  12, 12, [ 14, 39 ], 13, 13, 13, 12, 12, [ 14, 39 ], 13, 13, 13, 13, 13, 
  [ 14, 40 ], 13, 13, 13, [ 14, 55 ], 13, 13, 11, 11, 13, 13, 13, [ 14, 59 ], 
  13, 13, 13, 13, [ 14, 56 ], 13, 13, 13, [ 14, 55 ], 13, 13, 13, [ 14, 59 ], 
  13, 13, 13, 13, [ 14, 64 ], 13, 13, 12, 12, [ 0, 42, "Jo" ], 11, 13, 12, 
  11, 13, 12, 11, 11, 11, [ 0, 36, "Jo" ], 11, 11, 12, 11, 11, 11, 
  [ 0, 32, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  [ 14, 104 ], 12, 11, 11, 11, 13, [ 14, 131 ], 12, 11, 11, 11, 11, 13, 12, 
  11, 13, [ 14, 152 ], 11, [ 14, 185 ], [ 14, 196 ], [ 14, 149 ], 
  [ 14, 150 ], [ 14, 182 ], [ 14, 198 ], [ 14, 206 ], [ 14, 210 ] ],
#V   n = 215
[ ,,,,,,,,, [ 14, 4 ],, 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 
  13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, [ 14, 16 ], 13, 
  13, 13, 13, 13, 13, [ 14, 19 ], 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  [ 14, 24 ], 13, 13, 13, [ 14, 35 ], 13, 13, [ 14, 36 ], 13, 13, 13, 13, 13, 
  12, 12, [ 14, 40 ], 13, 13, 13, 12, 12, [ 14, 40 ], 13, 13, 13, 13, 13, 
  [ 14, 41 ], 13, 13, 13, [ 14, 56 ], 13, 13, 11, 13, 13, 13, 13, [ 14, 60 ], 
  13, 13, 13, 13, [ 14, 57 ], 13, 13, 13, [ 14, 56 ], 13, 13, 13, [ 14, 60 ], 
  13, 13, 13, 13, [ 14, 65 ], 13, 13, 12, 12, 11, 11, 13, 12, 11, 13, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, [ 0, 12, "Jo" ], 11, 
  11, 11, 11, 12, 11, 11, 11, [ 14, 105 ], 12, 11, 11, 11, 13, [ 14, 132 ], 
  12, 11, 11, 11, 11, 13, 12, 11, 13, [ 14, 153 ], 11, [ 14, 186 ], 
  [ 14, 197 ], [ 14, 150 ], [ 14, 151 ], [ 14, 183 ], [ 14, 199 ], 
  [ 14, 207 ], [ 14, 211 ] ],
#V   n = 216
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, 13, 13, 13, 13, [ 0, 99, "BK" ], 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 11, 13, 
  13, 13, 13, [ 14, 17 ], 13, 13, [ 14, 16 ], 13, 13, 13, [ 14, 20 ], 13, 13, 
  11, 13, 13, 13, 13, 13, 13, [ 14, 25 ], 13, 13, 13, [ 14, 36 ], 13, 13, 
  [ 14, 37 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 41 ], 13, 13, 13, 12, 12, 
  [ 14, 41 ], 13, 13, 13, 13, 13, [ 14, 42 ], 13, 13, 13, 13, 13, 13, 
  [ 14, 41 ], 13, 13, 13, 13, [ 14, 61 ], 13, 13, 13, 13, [ 14, 58 ], 13, 13, 
  13, [ 14, 57 ], 13, 13, 13, [ 14, 61 ], 13, 13, 13, 13, [ 14, 66 ], 13, 13, 
  12, 12, 11, 11, 13, [ 0, 40, "Jo" ], 11, 13, 12, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 
  [ 14, 106 ], 12, 11, 11, 11, 13, [ 14, 133 ], 12, 11, 11, 11, 11, 13, 12, 
  11, [ 14, 103 ], [ 14, 154 ], 11, [ 14, 187 ], [ 14, 198 ], [ 14, 151 ], 
  [ 14, 152 ], [ 14, 184 ], [ 14, 200 ], [ 14, 208 ], [ 14, 212 ] ],
#V   n = 217
[ ,,,,,,,,,, [ 14, 5 ], [ 0, 103, "BK" ], 13, [ 0, 101, "BK" ], 13, 13, 13, 
  13, 13, 13, 13, 13, 13, [ 0, 93, "BK" ], 13, [ 0, 91, "BK" ], 13, 13, 13, 
  13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, [ 14, 18 ], 13, 13, 
  [ 14, 17 ], 13, 13, 13, [ 14, 21 ], 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  [ 14, 26 ], 13, 13, 13, 13, 13, 13, [ 14, 38 ], 13, 13, 13, 13, 13, 12, 12, 
  [ 14, 42 ], 13, 13, 13, 12, 12, [ 14, 42 ], 13, 13, 13, 13, 13, [ 14, 43 ], 
  13, 13, [ 14, 38 ], 13, 13, 13, [ 14, 42 ], 13, 13, 13, 13, [ 14, 62 ], 13, 
  13, 13, 13, [ 14, 59 ], 13, 13, 13, [ 14, 58 ], 13, 13, 13, [ 14, 62 ], 13, 
  13, 13, 13, [ 14, 67 ], 13, 12, 12, 12, 11, 11, 12, 11, 11, 13, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  [ 0, 26, "Jo" ], 11, 11, 11, [ 0, 24, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, [ 0, 14, "Jo" ], 
  11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 107 ], 12, 11, 
  11, 11, 13, [ 14, 134 ], 12, 11, 11, 11, 11, 13, 12, 11, [ 14, 104 ], 
  [ 14, 155 ], 11, [ 14, 188 ], [ 14, 199 ], [ 14, 152 ], [ 14, 153 ], 
  [ 14, 185 ], [ 14, 201 ], [ 14, 209 ], [ 14, 213 ] ],
#V   n = 218
[ ,,,,,,,,, [ 14, 4 ],, 12, 13, 13, 11, 13, 13, 13, [ 0, 97, "BK" ], 13, 13, 
  [ 0, 95, "BK" ], 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 13, [ 14, 19 ], 13, 13, [ 14, 18 ], 13, 13, 13, 
  [ 14, 22 ], 13, 13, 11, 13, 13, 13, 13, 13, 13, [ 14, 27 ], 13, 13, 
  [ 14, 24 ], 13, 13, 13, [ 14, 39 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 43 ], 
  13, 13, 13, 12, 12, [ 14, 43 ], 13, 13, 13, 13, 13, [ 14, 44 ], 13, 13, 
  [ 14, 39 ], 11, 13, 13, [ 14, 43 ], 13, 13, 13, 13, [ 14, 63 ], 13, 13, 13, 
  13, [ 14, 60 ], 13, 13, 13, [ 14, 59 ], 13, 13, 13, [ 14, 63 ], 13, 13, 13, 
  13, [ 14, 68 ], 13, 12, 12, 12, 11, 11, 12, 11, 11, 13, [ 0, 38, "Jo" ], 
  11, 11, 12, 11, 11, 11, [ 0, 34, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, [ 0, 28, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, [ 14, 108 ], 12, 11, 11, 
  11, 13, [ 14, 135 ], 12, 11, 11, 11, 11, 13, 12, 11, [ 14, 105 ], 
  [ 14, 156 ], 11, [ 14, 189 ], [ 14, 200 ], [ 14, 153 ], [ 14, 154 ], 
  [ 14, 186 ], [ 14, 202 ], [ 14, 210 ], [ 14, 214 ] ],
#V   n = 219
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 12, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 
  11, 13, [ 0, 93, "BK" ], 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 13, [ 14, 20 ], 13, 13, [ 14, 19 ], 13, 13, 13, 
  [ 14, 23 ], 13, 13, 13, 13, 13, 13, 13, 13, 13, [ 14, 28 ], 13, 13, 
  [ 14, 25 ], 13, 13, 13, [ 14, 40 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 44 ], 
  13, 13, 13, 12, 12, [ 14, 44 ], 13, 13, 13, 13, 13, [ 14, 45 ], 13, 13, 11, 
  13, 13, 13, [ 14, 44 ], 13, 13, 13, 13, [ 14, 64 ], 13, 13, 13, 13, 
  [ 14, 61 ], 13, 13, 13, [ 14, 60 ], 13, 13, 13, [ 14, 64 ], 13, 13, 13, 13, 
  [ 14, 69 ], 13, 12, 12, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, [ 0, 22, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 
  11, 11, 11, [ 14, 109 ], 12, 11, 11, 11, 13, [ 14, 136 ], 12, 11, 11, 11, 
  11, 13, 12, 11, [ 14, 106 ], [ 14, 157 ], 11, [ 14, 190 ], [ 14, 201 ], 
  [ 14, 154 ], [ 14, 155 ], [ 14, 187 ], [ 14, 203 ], [ 14, 211 ], 
  [ 14, 215 ] ],
#V   n = 220
[ ,,,,,,,,,, [ 14, 5 ], [ 14, 6 ], [ 0, 103, "BK" ], 13, 13, 13, 11, 
  [ 0, 99, "BK" ], 13, [ 0, 97, "BK" ], 13, 13, 13, 13, 13, 13, 13, 13, 11, 
  13, [ 0, 89, "BK" ], 13, 13, 13, 13, 13, 11, 13, 13, 11, 13, 13, 13, 13, 
  [ 14, 21 ], 13, 13, [ 14, 20 ], 13, 13, 13, [ 14, 24 ], 13, [ 14, 20 ], 13, 
  13, 13, 13, 13, 13, 13, [ 14, 29 ], 13, 13, [ 14, 26 ], 13, 13, 13, 
  [ 14, 41 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 45 ], 13, 13, 13, 12, 12, 
  [ 14, 45 ], 13, 13, 13, 13, 13, [ 14, 46 ], 13, 13, [ 14, 41 ], 13, 13, 13, 
  [ 14, 45 ], 13, 13, 13, 13, [ 14, 65 ], 13, 13, 13, 13, [ 14, 62 ], 13, 13, 
  13, [ 14, 61 ], 13, 13, 13, [ 14, 65 ], 13, 13, 13, 13, [ 14, 70 ], 13, 12, 
  12, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, [ 0, 30, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, [ 0, 10, "Jo" ], 11, 
  11, 11, [ 14, 110 ], 12, 11, 11, 11, 13, [ 14, 137 ], 12, 11, 11, 11, 11, 
  13, 12, 11, [ 14, 107 ], [ 14, 158 ], 11, [ 14, 191 ], [ 14, 202 ], 
  [ 14, 155 ], [ 14, 156 ], [ 14, 188 ], [ 14, 204 ], [ 14, 212 ], 
  [ 14, 216 ] ],
#V   n = 221
[ ,,,,,,,,,,, 13, 12, 11, 13, 13, 13, 12, 13, 13, 11, 13, 13, [ 0, 95, "BK" ],
  13, [ 0, 93, "BK" ], 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 13, [ 14, 22 ], 13, 13, [ 14, 21 ], 13, 13, 13, 
  [ 14, 25 ], 13, [ 14, 21 ], 13, 13, 13, 13, 13, 13, 13, [ 14, 30 ], 13, 13, 
  [ 14, 27 ], 13, 13, 13, [ 14, 42 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 46 ], 
  13, 13, 13, 12, 12, [ 14, 46 ], 13, 13, 13, 13, 13, [ 14, 47 ], 13, 13, 
  [ 14, 42 ], 13, 13, 13, [ 14, 46 ], 13, 13, 13, 13, [ 14, 66 ], 13, 13, 13, 
  13, [ 14, 63 ], 13, 13, 13, [ 14, 62 ], 13, 13, 13, [ 14, 66 ], 13, 13, 13, 
  13, [ 14, 71 ], 13, 12, 12, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 14, 111 ], 12, 11, 11, 11, 13, [ 14, 138 ], 12, 11, 11, 11, 11, 13, 12, 
  11, [ 14, 108 ], [ 14, 159 ], 11, [ 14, 192 ], [ 14, 203 ], [ 14, 156 ], 
  [ 14, 157 ], [ 14, 189 ], [ 14, 205 ], [ 14, 213 ], [ 14, 217 ] ],
#V   n = 222
[ ,,,,,,,,, [ 14, 4 ],, 13, 12, 12, 11, 13, 13, 12, [ 0, 99, "BK" ], 13, 13, 
  11, 13, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 13, [ 14, 23 ], 13, 13, [ 14, 22 ], 13, 13, 13, 
  [ 14, 26 ], 13, [ 14, 22 ], 13, 13, 13, 13, 13, 13, 13, [ 14, 31 ], 13, 13, 
  [ 14, 28 ], 13, 13, 13, 13, 13, 13, 13, 13, 13, 12, 12, [ 14, 47 ], 13, 13, 
  13, 12, 12, [ 14, 47 ], 13, 13, 13, 13, 13, [ 14, 48 ], 13, 13, [ 14, 43 ], 
  13, 13, 13, [ 14, 47 ], 13, 13, 13, 13, [ 14, 67 ], 13, 13, 13, 13, 
  [ 14, 64 ], 13, 13, 13, [ 14, 63 ], 13, 13, 13, [ 14, 67 ], 13, 13, 13, 13, 
  [ 14, 72 ], 13, 12, 12, [ 0, 42, "Jo" ], 11, 11, 12, 11, 11, 12, 11, 11, 
  11, [ 0, 36, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 0, 20, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 11, [ 0, 16, "Jo" ], 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 14, 112 ], 12, 11, 11, 11, 13, [ 14, 139 ], 12, 11, 11, 11, 11, 13, 12, 
  11, [ 14, 109 ], [ 14, 160 ], 11, [ 14, 193 ], [ 14, 204 ], [ 14, 157 ], 
  [ 14, 158 ], [ 14, 190 ], [ 14, 206 ], [ 14, 214 ], [ 14, 218 ] ],
#V   n = 223
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, 13, 12, 12, 11, 13, 13, 12, 11, 13, 13, 
  11, 13, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 11, 13, 
  13, 11, 13, 13, 13, 13, [ 14, 24 ], 13, 13, [ 14, 23 ], 13, 13, 13, 
  [ 14, 27 ], 13, [ 14, 23 ], 13, 13, 13, 13, 13, 13, 13, [ 14, 32 ], 13, 13, 
  [ 14, 29 ], 13, 13, [ 14, 28 ], 13, 13, 13, 13, 13, 13, 12, 12, [ 14, 48 ], 
  13, 13, 13, 12, 12, [ 14, 48 ], 13, 13, 13, 13, 13, [ 14, 49 ], 13, 13, 
  [ 14, 44 ], 13, 13, 13, [ 14, 48 ], 13, 13, 13, 13, [ 14, 68 ], 13, 13, 13, 
  13, [ 14, 65 ], 13, 13, 13, [ 14, 64 ], 13, 13, 13, [ 14, 68 ], 13, 13, 13, 
  13, 13, 13, 12, 12, 11, 11, 11, [ 0, 40, "Jo" ], 11, 11, 12, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, [ 14, 113 ], 12, 11, 11, 11, 13, [ 14, 140 ], 12, 11, 11, 11, 11, 
  13, 12, 11, [ 14, 110 ], [ 14, 161 ], 11, [ 14, 194 ], [ 14, 205 ], 
  [ 14, 158 ], [ 14, 159 ], [ 14, 191 ], [ 14, 207 ], [ 14, 215 ], 
  [ 14, 219 ] ],
#V   n = 224
[ ,,,,,,,,,, [ 14, 5 ], [ 0, 107, "BK" ], 13, 13, 12, 12, 11, 13, 12, 12, 11, 
  13, 13, 11, 13, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 13, [ 14, 25 ], 13, 13, [ 14, 24 ], 13, 13, 13, 
  [ 14, 28 ], 13, [ 14, 24 ], 13, 13, 13, 13, 13, 13, 13, [ 14, 33 ], 13, 13, 
  [ 14, 30 ], 13, 13, [ 14, 29 ], 13, 13, 13, 13, 13, 13, 12, 12, [ 14, 49 ], 
  13, 13, 13, 12, 12, [ 14, 49 ], 13, 13, 13, 13, 13, [ 14, 50 ], 13, 13, 
  [ 14, 45 ], 13, 13, 13, [ 14, 49 ], 13, 13, 13, 13, [ 14, 69 ], 13, 13, 13, 
  13, [ 14, 66 ], 13, 13, 13, [ 14, 65 ], 13, 13, 13, [ 14, 69 ], 13, 13, 13, 
  13, 13, 13, 12, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, [ 0, 32, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, [ 14, 114 ], 12, 11, 11, 11, 13, [ 14, 141 ], 12, 11, 11, 11, 11, 
  13, 12, 11, [ 14, 111 ], [ 14, 162 ], 11, [ 14, 195 ], [ 14, 206 ], 
  [ 14, 159 ], [ 14, 160 ], [ 14, 192 ], [ 14, 208 ], [ 14, 216 ], 
  [ 14, 220 ] ],
#V   n = 225
[ ,,,,,,,,, [ 14, 4 ],, 12, 11, 13, 13, 12, 12, 13, 13, 12, 12, 11, 13, 13, 
  11, 13, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 13, [ 14, 26 ], 13, 13, [ 14, 25 ], 13, 13, 13, 
  [ 14, 29 ], 13, [ 14, 25 ], 13, 13, 13, 13, 13, 13, 13, [ 14, 34 ], 13, 13, 
  [ 14, 31 ], 13, 13, [ 14, 30 ], 13, 13, 13, 13, 13, 13, 12, 12, [ 14, 50 ], 
  13, 13, 13, 12, 12, [ 14, 50 ], 13, 13, 13, 13, 13, [ 14, 51 ], 13, 13, 
  [ 14, 46 ], 13, 13, 13, [ 14, 50 ], 13, 13, 13, 13, [ 14, 70 ], 13, 13, 13, 
  13, [ 14, 67 ], 13, 13, 13, [ 14, 66 ], 13, 13, 13, [ 14, 70 ], 13, 13, 13, 
  13, 13, 12, 12, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 14, 115 ], 12, 11, 11, 11, 13, [ 14, 142 ], 12, 11, 11, 11, 11, 13, 12, 
  11, [ 14, 112 ], [ 14, 163 ], 11, [ 14, 196 ], [ 14, 207 ], [ 14, 160 ], 
  [ 14, 161 ], [ 14, 193 ], [ 14, 209 ], [ 14, 217 ], [ 14, 221 ] ],
#V   n = 226
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 12, [ 14, 4 ], 11, 13, 13, 12, [ 14, 6 ], 
  13, 13, 12, 12, 11, 13, 13, 11, 13, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 
  13, 13, 13, 13, [ 14, 14 ], 11, 13, [ 14, 16 ], 13, 13, 13, 13, 13, 
  [ 14, 27 ], 13, 13, [ 14, 26 ], 13, 13, 13, [ 14, 30 ], 13, [ 14, 26 ], 13, 
  13, 13, 13, 13, 13, 13, [ 14, 35 ], 13, 13, [ 14, 32 ], 13, 13, [ 14, 31 ], 
  13, 13, 13, 13, 13, 13, 12, 12, [ 14, 51 ], 13, 13, 13, 12, 12, [ 14, 51 ], 
  13, 13, 13, 13, 13, [ 14, 52 ], 13, 13, [ 14, 47 ], 13, 13, 13, [ 14, 51 ], 
  13, 13, 13, 13, [ 14, 71 ], 13, 13, 13, 13, [ 14, 68 ], 13, 13, 13, 
  [ 14, 67 ], 13, 13, 13, [ 14, 71 ], 13, [ 0, 46, "Jo" ], 13, 13, 13, 12, 
  12, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, [ 0, 34, "Jo" ],
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 14, 116 ], 12, 11, 11, 11, 13, [ 14, 143 ], 12, 11, 11, 11, 11, 13, 12, 
  11, [ 14, 113 ], [ 14, 164 ], 11, [ 14, 197 ], [ 14, 208 ], [ 14, 161 ], 
  [ 14, 162 ], [ 14, 194 ], [ 14, 210 ], [ 14, 218 ], [ 14, 222 ] ],
#V   n = 227
[ ,,,,,,,,,, 13, [ 14, 6 ], 13, [ 14, 5 ], 11, 13, 13, 13, [ 14, 7 ], 13, 13, 
  12, 13, 11, 13, 13, 11, 13, 13, 11, 13, 11, 13, 13, 13, 11, 13, 11, 13, 13, 
  13, 13, 11, 13, 13, [ 14, 17 ], 13, 13, 13, 13, 13, [ 14, 28 ], 13, 13, 
  [ 14, 27 ], 13, 13, 13, [ 14, 31 ], 13, [ 14, 27 ], 13, 13, 13, 13, 13, 13, 
  13, [ 14, 36 ], 13, 13, [ 14, 33 ], 13, 13, [ 14, 32 ], 13, 13, 13, 13, 13, 
  13, 12, 12, [ 14, 52 ], 13, 13, 13, 12, 12, [ 14, 52 ], 13, 13, 13, 13, 13, 
  [ 14, 53 ], 13, 13, [ 14, 48 ], 13, 13, 13, [ 14, 52 ], 13, 13, 13, 13, 
  [ 14, 72 ], 13, 13, 13, 13, [ 14, 69 ], 13, 13, 13, [ 14, 68 ], 13, 13, 13, 
  [ 14, 72 ], 12, 11, 13, 13, 13, 12, 12, 12, 11, 11, 12, 11, 11, 11, 
  [ 0, 38, "Jo" ], 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 11, [ 14, 117 ], 12, 11, 11, 11, 13, 
  [ 14, 144 ], 12, 11, 11, 11, 11, 13, 12, 11, [ 14, 114 ], [ 14, 165 ], 11, 
  [ 14, 198 ], [ 14, 209 ], [ 14, 162 ], [ 14, 163 ], [ 14, 195 ], 
  [ 14, 211 ], [ 14, 219 ], [ 14, 223 ] ],
#V   n = 228
[ ,,,,,,,,,, 13, 13, 13, 13, [ 14, 6 ], 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  11, 13, 13, 11, 13, 13, 11, 13, 11, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 
  [ 14, 16 ], 13, 13, [ 14, 18 ], 13, 13, 13, 13, 13, [ 14, 29 ], 13, 13, 
  [ 14, 28 ], 13, 13, 13, [ 14, 32 ], 13, [ 14, 28 ], 13, 13, 13, 13, 13, 13, 
  13, [ 14, 37 ], 13, 13, [ 14, 34 ], 13, 13, [ 14, 33 ], 13, 13, 13, 13, 13, 
  13, 12, 12, [ 14, 53 ], 13, 13, 13, 12, 12, [ 14, 53 ], 13, 13, 13, 13, 13, 
  [ 14, 54 ], 13, 13, [ 14, 49 ], 13, 13, 13, [ 14, 53 ], 13, 13, 13, 13, 
  [ 14, 50 ], 13, 13, 13, 13, [ 14, 70 ], 13, 13, 13, [ 14, 69 ], 13, 13, 13, 
  12, 12, 11, 13, 13, 13, 12, 12, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, [ 14, 118 ], 12, 11, 11, 11, 13, [ 14, 145 ], 12, 11, 11, 11, 11, 
  13, 12, 11, [ 14, 115 ], [ 14, 166 ], 11, [ 14, 199 ], [ 14, 210 ], 
  [ 14, 163 ], [ 14, 164 ], [ 14, 196 ], [ 14, 212 ], [ 14, 220 ], 
  [ 14, 224 ] ],
#V   n = 229
[ ,,,,,,,,,, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, 13, 13, 11, 13, 11, 13, 13, [ 14, 12 ], 11, 13, 11, 13, 13, 13, 
  13, [ 14, 17 ], 13, 13, [ 14, 19 ], 13, 13, 13, 13, 13, [ 14, 30 ], 13, 13, 
  [ 14, 29 ], 13, 13, 13, [ 14, 33 ], 13, [ 14, 29 ], 13, 13, 13, 13, 13, 13, 
  13, [ 14, 38 ], 13, 13, [ 14, 35 ], 13, 13, [ 14, 34 ], 13, 13, 13, 13, 13, 
  13, 12, 12, [ 14, 54 ], 13, 13, 13, 12, 12, [ 14, 54 ], 13, 13, 13, 13, 13, 
  [ 14, 55 ], 13, 13, [ 14, 50 ], 13, 13, 13, [ 14, 54 ], 13, 13, 13, 
  [ 14, 50 ], 13, 13, 13, 13, 13, [ 14, 71 ], 13, 13, 13, [ 14, 70 ], 13, 13, 
  12, 12, 12, 11, 13, 13, 13, 12, 12, [ 0, 42, "Jo" ], 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  [ 0, 28, "Jo" ], 11, 11, 11, [ 0, 26, "Jo" ], 11, 11, 11, [ 0, 24, "Jo" ], 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 14, 119 ], 12, 11, 11, 11, 13, [ 14, 146 ], 12, 11, 11, 11, 11, 13, 12, 
  11, [ 14, 116 ], [ 14, 167 ], 11, [ 14, 200 ], [ 14, 211 ], [ 14, 164 ], 
  [ 14, 165 ], [ 14, 197 ], [ 14, 213 ], [ 14, 221 ], [ 14, 225 ] ],
#V   n = 230
[ ,,,,,,,,,, [ 0, 111, "BK" ], 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, 13, 13, [ 14, 8 ], 11, 13, [ 14, 10 ], 13, 13, 13, 11, 13, 11, 13, 13, 
  11, 13, 13, 11, 13, 13, 13, 13, [ 14, 18 ], 13, 13, [ 14, 20 ], 13, 13, 13, 
  13, 13, 13, 13, 13, [ 14, 30 ], 13, 13, 13, [ 14, 34 ], 13, [ 14, 30 ], 13, 
  13, 13, 13, 13, 13, 13, [ 14, 39 ], 13, 13, [ 14, 36 ], 13, 13, [ 14, 35 ], 
  13, 13, 13, 13, 13, 13, 12, 12, 13, 13, 13, 13, 12, 12, [ 14, 55 ], 13, 13, 
  13, 13, 13, [ 14, 56 ], 13, 13, [ 14, 51 ], 13, 13, 13, [ 14, 55 ], 13, 13, 
  13, [ 14, 51 ], 11, 13, 13, 13, 13, [ 14, 72 ], 13, 13, 13, [ 14, 71 ], 13, 
  13, 12, 12, 12, 11, 13, 13, 13, 12, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 0, 18, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, 11, [ 14, 120 ], 12, 11, 11, 11, 13, 
  [ 14, 147 ], 12, 11, 11, 11, 11, 13, 12, 11, [ 14, 117 ], [ 14, 168 ], 11, 
  [ 14, 201 ], [ 14, 212 ], [ 14, 165 ], [ 14, 166 ], [ 14, 198 ], 
  [ 14, 214 ], [ 14, 222 ], [ 14, 226 ] ],
#V   n = 231
[ ,,,,,,,,, [ 14, 4 ],, 13, [ 0, 109, "BK" ], 13, 13, [ 0, 107, "BK" ], 13, 
  13, 13, 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, [ 14, 11 ], 13, 13, 13, 11, 
  13, 11, 13, 13, [ 14, 14 ], 13, 13, 11, 13, 13, 13, 13, [ 14, 19 ], 13, 13, 
  [ 14, 21 ], 13, 13, 13, 13, [ 14, 20 ], 13, 13, 13, [ 14, 31 ], 13, 13, 13, 
  [ 14, 35 ], 13, [ 14, 31 ], 13, 13, 13, 13, 13, 13, 13, [ 14, 40 ], 13, 13, 
  [ 14, 37 ], 13, 13, [ 14, 36 ], 13, 13, 13, 13, 13, 13, 12, [ 14, 36 ], 13, 
  13, 13, 13, 12, 12, [ 14, 56 ], 13, 13, 13, 13, 13, [ 14, 57 ], 13, 13, 
  [ 14, 52 ], 13, 13, 13, [ 14, 56 ], 13, 13, 13, 11, 13, 13, 13, 13, 13, 
  [ 14, 73 ], 13, 13, 13, [ 14, 72 ], 13, 13, 12, 12, 12, 11, 13, 13, 13, 12, 
  12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, [ 0, 36, "Jo" ], 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, [ 0, 30, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 11, [ 14, 121 ], 12, 11, 11, 11, 13, [ 14, 148 ], 12, 11, 11, 11, 
  11, 13, 12, 11, [ 14, 118 ], [ 14, 169 ], 11, [ 14, 202 ], [ 14, 213 ], 
  [ 14, 166 ], [ 14, 167 ], [ 14, 199 ], [ 14, 215 ], [ 14, 223 ], 
  [ 14, 227 ] ],
#V   n = 232
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, 13, 11, 13, 13, 13, [ 0, 105, "BK" ], 
  13, [ 0, 103, "BK" ], 13, 13, [ 0, 101, "BK" ], 13, 13, 13, 13, [ 14, 10 ], 
  13, 13, [ 14, 12 ], 13, 13, 13, 13, 13, 13, 13, 13, [ 14, 15 ], 13, 13, 11, 
  13, 13, 13, 13, [ 14, 20 ], 13, 13, [ 14, 22 ], 13, 13, 13, 13, [ 14, 21 ], 
  13, 13, 13, [ 14, 32 ], 13, 13, 13, [ 14, 36 ], 13, [ 14, 32 ], 13, 13, 13, 
  13, 13, 13, 13, [ 14, 41 ], 13, 13, [ 14, 38 ], 13, 13, [ 14, 37 ], 13, 13, 
  13, 13, 13, 13, 12, [ 14, 37 ], 13, 13, 13, 13, 12, 12, [ 14, 57 ], 13, 13, 
  13, 13, 13, [ 14, 58 ], 13, 13, [ 14, 53 ], 13, 13, 13, [ 14, 57 ], 13, 13, 
  13, [ 14, 53 ], 13, 13, 13, 13, 13, [ 14, 74 ], 13, 13, 13, [ 14, 73 ], 13, 
  13, 12, 12, [ 0, 46, "Jo" ], 11, 13, 13, 12, 13, 12, 11, 11, 11, 
  [ 0, 40, "Jo" ], 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 0, 22, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 14, 122 ], 12, 11, 11, 11, 13, [ 14, 149 ], [ 0, 6, "Jo" ], 11, 11, 11, 
  11, 13, 12, 11, [ 14, 119 ], [ 14, 170 ], 11, [ 14, 203 ], [ 14, 214 ], 
  [ 14, 167 ], [ 14, 168 ], [ 14, 200 ], [ 14, 216 ], [ 14, 224 ], 
  [ 14, 228 ] ],
#V   n = 233
[ ,,,,,,,,,, [ 14, 5 ], [ 0, 111, "BK" ], 13, 13, 11, 13, [ 0, 107, "BK" ], 
  13, 11, 13, 11, 13, 13, 11, 13, 13, 13, 13, [ 14, 11 ], 13, 13, [ 14, 13 ], 
  13, 13, [ 14, 12 ], 13, [ 14, 12 ], 11, 13, 13, [ 14, 16 ], 13, 13, 11, 13, 
  13, 13, 13, [ 14, 21 ], 13, 13, [ 14, 23 ], 13, 13, 13, 13, [ 14, 22 ], 13, 
  13, 13, [ 14, 33 ], 13, 13, 13, [ 14, 37 ], 13, [ 14, 33 ], 13, 13, 13, 13, 
  13, 13, 13, [ 14, 42 ], 13, 13, [ 14, 39 ], 13, 13, [ 14, 38 ], 13, 13, 13, 
  13, 13, 12, 12, [ 14, 38 ], 13, 13, 13, 13, 12, 12, [ 14, 58 ], 13, 13, 13, 
  13, 13, [ 14, 59 ], 13, 13, [ 14, 54 ], 13, 13, 13, [ 14, 58 ], 13, 13, 13, 
  [ 14, 54 ], 13, 13, 13, 13, 13, [ 14, 75 ], 13, 13, 13, [ 14, 74 ], 13, 13, 
  12, 12, 11, 11, 13, 13, 13, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, [ 0, 32, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, [ 14, 123 ], 12, 11, 11, 11, 13, 12, 11, 11, 
  11, 11, 11, 13, 12, 11, [ 14, 120 ], [ 14, 171 ], 11, [ 14, 204 ], 
  [ 14, 215 ], [ 14, 168 ], [ 14, 169 ], [ 14, 201 ], [ 14, 217 ], 
  [ 14, 225 ], [ 14, 229 ] ],
#V   n = 234
[ ,,,,,,,,, [ 14, 4 ],, 12, 11, 13, 13, 11, 13, 11, 13, 11, 13, 11, 13, 13, 
  11, 13, 13, 13, 13, [ 14, 12 ], 13, 13, [ 14, 14 ], 13, 13, [ 14, 13 ], 13, 
  11, 13, 13, 13, [ 14, 17 ], 13, 13, 11, 13, 13, 13, 13, [ 14, 22 ], 13, 13, 
  [ 14, 24 ], 13, 13, 13, 13, [ 14, 23 ], 13, 13, 13, [ 14, 34 ], 13, 13, 13, 
  [ 14, 38 ], 13, [ 14, 34 ], 13, 13, 13, 13, 13, 13, 13, [ 14, 43 ], 13, 13, 
  [ 14, 40 ], 13, 13, [ 14, 39 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 39 ], 13, 
  13, 13, 13, 12, 12, [ 14, 59 ], 13, 13, 13, 13, 13, [ 14, 60 ], 13, 13, 
  [ 14, 55 ], 13, 13, 13, [ 14, 59 ], 13, 13, 13, [ 14, 55 ], 13, 13, 13, 13, 
  13, [ 14, 76 ], 13, 13, 13, [ 14, 75 ], 13, 13, 12, 12, 11, 11, 13, 
  [ 0, 44, "Jo" ], 13, 13, 12, 11, 11, 12, 11, 11, 11, [ 0, 38, "Jo" ], 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  12, 11, 11, 11, 11, [ 14, 124 ], 12, 11, 11, 11, 13, 12, 11, 11, 11, 11, 
  11, 13, 12, 11, [ 14, 121 ], [ 14, 172 ], 11, [ 14, 205 ], [ 14, 216 ], 
  [ 14, 169 ], [ 14, 170 ], [ 14, 202 ], [ 14, 218 ], [ 14, 226 ], 
  [ 14, 230 ] ],
#V   n = 235
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 12, [ 14, 4 ], 11, 13, 13, 11, 13, 11, 13, 
  11, 13, 11, 13, 13, 11, 13, 13, 13, 13, [ 14, 13 ], 13, 13, [ 14, 15 ], 13, 
  13, [ 14, 14 ], 13, [ 14, 14 ], 13, 13, 13, [ 14, 18 ], 13, 13, 13, 13, 13, 
  13, 13, [ 14, 23 ], 13, 13, [ 14, 25 ], 13, 13, 13, 13, [ 14, 24 ], 13, 13, 
  13, [ 14, 35 ], 13, 13, 13, [ 14, 39 ], 13, [ 14, 35 ], 13, 13, 13, 13, 13, 
  13, 13, [ 14, 44 ], 13, 13, [ 14, 41 ], 13, 13, [ 14, 40 ], 13, 13, 13, 13, 
  13, 12, 12, [ 14, 40 ], 13, 13, 13, 13, 12, 12, [ 14, 60 ], 13, 13, 13, 13, 
  13, [ 14, 61 ], 13, 13, [ 14, 56 ], 13, 13, 13, [ 14, 60 ], 13, 13, 13, 
  [ 14, 56 ], 13, 13, 13, 13, 13, [ 14, 77 ], 13, 13, 13, [ 14, 76 ], 13, 12, 
  12, 12, 11, 11, 12, 11, 13, 13, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 11, [ 14, 125 ], 12, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 13, 
  12, 11, [ 14, 122 ], [ 14, 173 ], 11, [ 14, 206 ], [ 14, 217 ], 
  [ 14, 170 ], [ 14, 171 ], [ 14, 203 ], [ 14, 219 ], [ 14, 227 ], 
  [ 14, 231 ] ],
#V   n = 236
[ ,,,,,,,,,, [ 14, 5 ], [ 14, 6 ], 13, [ 14, 5 ], 11, 13, 13, 13, 13, 11, 13, 
  11, 13, 11, 13, 13, 11, 13, 13, 13, 13, [ 14, 14 ], 13, 13, [ 14, 16 ], 13, 
  13, [ 14, 15 ], 13, [ 14, 15 ], 13, 13, 13, [ 14, 19 ], 13, [ 14, 16 ], 13, 
  13, 13, 13, 13, [ 14, 24 ], 13, 13, [ 14, 26 ], 13, 13, 13, 13, [ 14, 25 ], 
  13, 13, 13, [ 14, 36 ], 13, 13, 13, [ 14, 40 ], 13, [ 14, 36 ], 13, 13, 13, 
  13, 13, 13, 13, [ 14, 45 ], 13, 13, [ 14, 42 ], 13, 13, [ 14, 41 ], 13, 13, 
  13, 13, 13, 12, 12, [ 14, 41 ], 13, 13, 13, 13, 12, 12, [ 14, 61 ], 13, 13, 
  13, 13, 13, [ 14, 62 ], 13, 13, [ 14, 57 ], 13, 13, 13, [ 14, 61 ], 13, 13, 
  13, [ 14, 57 ], 13, 13, 13, 13, 13, [ 14, 78 ], 13, 13, 13, [ 14, 77 ], 13, 
  12, 12, 12, 11, 11, 12, 11, 13, 13, [ 0, 42, "Jo" ], 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, [ 0, 34, "Jo" ], 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, [ 14, 126 ], 12, 11, 11, 
  11, 13, 12, 11, 11, 11, 11, 11, 13, 12, 11, [ 14, 123 ], [ 14, 174 ], 11, 
  [ 14, 207 ], [ 14, 218 ], [ 14, 171 ], [ 14, 172 ], [ 14, 204 ], 
  [ 14, 220 ], [ 14, 228 ], [ 14, 232 ] ],
#V   n = 237
[ ,,,,,,,,,,, 13, 13, 13, [ 14, 6 ], 11, 13, 13, 13, 13, 11, 13, 11, 13, 11, 
  13, 13, 11, 13, 13, 13, 13, [ 14, 15 ], 13, 13, [ 14, 17 ], 13, 13, 
  [ 14, 16 ], 13, [ 14, 16 ], 13, 13, 13, [ 14, 20 ], 13, [ 14, 17 ], 13, 13, 
  13, 13, 13, [ 14, 25 ], 13, 13, [ 14, 27 ], 13, 13, 13, 13, [ 14, 26 ], 13, 
  13, 13, [ 14, 37 ], 13, 13, 13, 13, 13, [ 14, 37 ], 13, 13, 13, 13, 13, 13, 
  13, [ 14, 46 ], 13, 13, [ 14, 43 ], 13, 13, [ 14, 42 ], 13, 13, 13, 13, 13, 
  12, 12, [ 14, 42 ], 13, 13, 13, 13, 12, 12, [ 14, 62 ], 13, 13, 13, 13, 13, 
  [ 14, 63 ], 13, 13, [ 14, 58 ], 13, 13, 13, [ 14, 62 ], 13, 13, 13, 
  [ 14, 58 ], 13, 13, 13, 13, 13, [ 14, 79 ], 13, 13, 13, [ 14, 78 ], 13, 12, 
  12, 12, 11, 11, 12, 11, 13, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 11, [ 14, 127 ], [ 0, 8, "Jo" ], 11, 11, 11, 13, 12, 11, 11, 11, 
  11, 11, 13, 12, 11, [ 14, 124 ], [ 14, 175 ], 11, [ 14, 208 ], [ 14, 219 ], 
  [ 14, 172 ], [ 14, 173 ], [ 14, 205 ], [ 14, 221 ], [ 14, 229 ], 
  [ 14, 233 ] ],
#V   n = 238
[ ,,,,,,,,, [ 14, 4 ],, 13, 13, 13, 13, [ 14, 7 ], 13, 13, 13, 13, 13, 11, 
  13, 11, 13, 11, 13, 13, 11, 13, 13, 13, 13, [ 14, 16 ], 13, 13, [ 14, 18 ], 
  13, 13, [ 14, 17 ], 13, [ 14, 17 ], 13, 13, 13, [ 14, 21 ], 13, [ 14, 18 ], 
  13, 13, 13, 13, 13, [ 14, 26 ], 13, 13, [ 14, 28 ], 13, 13, 13, 13, 
  [ 14, 27 ], 13, 13, 13, [ 14, 38 ], 13, 13, [ 14, 26 ], 11, 13, [ 14, 38 ], 
  13, 13, 13, 13, 13, 13, 13, [ 14, 47 ], 13, 13, [ 14, 44 ], 13, 13, 
  [ 14, 43 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 43 ], 13, 13, 13, 13, 12, 12, 
  [ 14, 63 ], 13, 13, 13, 13, 13, [ 14, 64 ], 13, 13, [ 14, 59 ], 13, 13, 13, 
  [ 14, 63 ], 13, 13, 13, [ 14, 59 ], 13, 13, 13, 13, 13, [ 14, 80 ], 13, 13, 
  13, [ 14, 79 ], 13, 12, 12, 12, 11, 11, 12, 11, 13, 12, 11, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 0, 20, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  13, 12, 11, 11, 11, 11, 11, 13, 12, 11, [ 14, 125 ], [ 14, 176 ], 11, 
  [ 14, 209 ], [ 14, 220 ], [ 14, 173 ], [ 14, 174 ], [ 14, 206 ], 
  [ 14, 222 ], [ 14, 230 ], [ 14, 234 ] ],
#V   n = 239
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  11, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, [ 14, 17 ], 13, 13, 
  [ 14, 19 ], 13, 13, [ 14, 18 ], 13, [ 14, 18 ], 13, 13, 13, [ 14, 22 ], 13, 
  [ 14, 19 ], 13, 13, 13, 13, 13, [ 14, 27 ], 13, 13, [ 14, 29 ], 13, 13, 13, 
  13, [ 14, 28 ], 13, 13, 13, [ 14, 39 ], 13, 13, 11, 13, 13, [ 14, 39 ], 13, 
  13, 13, 13, 13, 13, 13, [ 14, 48 ], 13, 13, [ 14, 45 ], 13, 13, [ 14, 44 ], 
  13, 13, 13, 13, 13, 12, 12, [ 14, 44 ], 13, 13, 13, 13, 12, 12, [ 14, 64 ], 
  13, 13, 13, 13, 13, [ 14, 65 ], 13, 13, [ 14, 60 ], 13, 13, 13, [ 14, 64 ], 
  13, 13, 13, [ 14, 60 ], 13, 13, 13, 13, 13, [ 14, 81 ], 13, 13, 13, 
  [ 14, 80 ], 13, 12, 12, 12, 11, 11, 12, 11, 13, 12, 11, 11, 11, 
  [ 0, 40, "Jo" ], 11, 11, 12, 11, 11, 11, [ 0, 36, "Jo" ], 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 13, 12, 11, [ 14, 126 ], 
  [ 14, 177 ], 11, [ 14, 210 ], [ 14, 221 ], [ 14, 174 ], [ 14, 175 ], 
  [ 14, 207 ], [ 14, 223 ], [ 14, 231 ], [ 14, 235 ] ],
#V   n = 240
[ ,,,,,,,,,, [ 14, 5 ], [ 0, 115, "BK" ], [ 0, 113, "BK" ], 13, 13, 13, 
  [ 0, 111, "BK" ], [ 0, 109, "BK" ], 13, 13, 13, 13, 13, 13, [ 14, 8 ], 13, 
  [ 14, 8 ], 11, 13, 13, 11, 13, 13, 13, 13, [ 14, 18 ], 13, 13, [ 14, 20 ], 
  13, 13, [ 14, 19 ], 13, [ 14, 19 ], 13, 13, 13, [ 14, 23 ], 13, [ 14, 20 ], 
  13, 13, 13, 13, 13, [ 14, 28 ], 13, 13, [ 14, 30 ], 13, 13, 13, 13, 
  [ 14, 29 ], 13, 13, 13, [ 14, 40 ], 13, 13, [ 14, 28 ], 13, 13, [ 14, 40 ], 
  13, 13, 13, 13, 13, 13, 13, [ 14, 49 ], 13, 13, [ 14, 46 ], 13, 13, 
  [ 14, 45 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 45 ], 13, 13, 13, 13, 12, 12, 
  [ 14, 65 ], 13, 13, 13, 13, 13, [ 14, 66 ], 13, 13, [ 14, 61 ], 13, 13, 13, 
  [ 14, 65 ], 13, 13, 13, [ 14, 61 ], 13, 13, 13, 13, 13, [ 14, 82 ], 13, 13, 
  13, [ 14, 81 ], 13, 12, 12, [ 0, 46, "Jo" ], 11, 11, 12, 11, 13, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 0, 14, "Jo" ], 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  12, 11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 13, 12, 11, [ 14, 127 ], 
  [ 14, 178 ], 11, [ 14, 211 ], [ 14, 222 ], [ 14, 175 ], [ 14, 176 ], 
  [ 14, 208 ], [ 14, 224 ], [ 14, 232 ], [ 14, 236 ] ],
#V   n = 241
[ ,,,,,,,,, [ 14, 4 ],, 13, 12, 11, 13, 13, 13, 12, 11, 13, 13, 13, 13, 
  [ 14, 8 ], 13, [ 14, 9 ], 13, 11, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, [ 14, 21 ], 13, 13, [ 14, 20 ], 13, [ 14, 20 ], 13, 13, 13, [ 14, 24 ], 
  13, [ 14, 21 ], 13, 13, 13, 13, 13, [ 14, 29 ], 13, 13, [ 14, 31 ], 13, 13, 
  13, 13, [ 14, 30 ], 13, 13, 13, 13, 13, 13, [ 14, 29 ], 13, 13, [ 14, 41 ], 
  13, 13, 13, 13, 13, 13, 13, [ 14, 50 ], 13, 13, [ 14, 47 ], 13, 13, 
  [ 14, 46 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 46 ], 13, 13, 13, 13, 12, 12, 
  [ 14, 66 ], 13, 13, 13, 13, 13, [ 14, 67 ], 13, 13, [ 14, 62 ], 13, 13, 13, 
  [ 14, 66 ], 13, 13, 13, [ 14, 62 ], 13, 13, 13, 13, 13, [ 14, 83 ], 13, 13, 
  13, 13, 13, 12, 12, 11, 11, 11, [ 0, 44, "Jo" ], 11, 13, 12, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, [ 0, 28, "Jo" ], 11, 11, 11, [ 0, 26, "Jo" ], 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 13, 12, 11, [ 14, 128 ], 
  [ 14, 179 ], 11, [ 14, 212 ], [ 14, 223 ], [ 14, 176 ], [ 14, 177 ], 
  [ 14, 209 ], [ 14, 225 ], [ 14, 233 ], [ 14, 237 ] ],
#V   n = 242
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 13, 12, 13, 11, 13, 13, 12, 13, 11, 13, 13, 
  13, 13, [ 14, 9 ], 13, [ 14, 10 ], 13, [ 14, 10 ], 13, 13, [ 14, 10 ], 11, 
  13, 13, 13, [ 14, 12 ], 13, 13, 13, [ 14, 22 ], 13, 13, [ 14, 21 ], 13, 
  [ 14, 21 ], 13, 13, 13, [ 14, 25 ], 13, [ 14, 22 ], 13, 13, 13, 13, 13, 
  [ 14, 30 ], 13, 13, [ 14, 32 ], 13, 13, 13, 13, [ 14, 31 ], 13, 13, 
  [ 14, 26 ], 13, 13, 13, [ 14, 30 ], 13, 13, [ 14, 42 ], 13, 13, 13, 13, 13, 
  13, 13, [ 14, 51 ], 13, 13, [ 14, 48 ], 13, 13, [ 14, 47 ], 13, 13, 13, 13, 
  13, 12, 12, [ 14, 47 ], 13, 13, 13, 13, 12, 12, [ 14, 67 ], 13, 13, 13, 13, 
  13, [ 14, 68 ], 13, 13, [ 14, 63 ], 13, 13, 13, [ 14, 67 ], 13, 13, 13, 
  [ 14, 63 ], 13, 13, 13, 13, 13, [ 14, 84 ], 13, 13, 13, 13, 13, 12, 12, 11, 
  11, 12, 11, 11, 13, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, [ 0, 30, "Jo" ], 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 11, [ 0, 12, "Jo" ], 
  11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 13, 12, 11, 11, 11, 
  11, 11, 13, [ 14, 116 ], 11, [ 14, 129 ], [ 14, 180 ], 11, [ 14, 213 ], 
  [ 14, 224 ], [ 14, 177 ], [ 14, 178 ], [ 14, 210 ], [ 14, 226 ], 
  [ 14, 234 ], [ 14, 238 ] ],
#V   n = 243
[ ,,,,,,,,,, [ 14, 5 ], 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 13, 13, 
  13, [ 14, 10 ], 13, [ 14, 11 ], 13, [ 14, 11 ], 13, 13, 11, 13, 13, 13, 13, 
  [ 14, 13 ], 13, 13, 13, 13, 13, 13, [ 14, 22 ], 13, [ 14, 22 ], 13, 13, 13, 
  [ 14, 26 ], 13, [ 14, 23 ], 13, 13, 13, 13, 13, [ 14, 31 ], 13, 13, 
  [ 14, 33 ], 13, 13, 13, 13, [ 14, 32 ], 13, 13, [ 14, 27 ], 13, 13, 13, 
  [ 14, 31 ], 13, 13, [ 14, 43 ], 13, 13, 13, 13, 13, 13, 13, [ 14, 52 ], 13, 
  13, [ 14, 49 ], 13, 13, [ 14, 48 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 48 ], 
  13, 13, 13, 13, 12, 12, [ 14, 68 ], 13, 13, 13, 13, 13, [ 14, 69 ], 13, 13, 
  [ 14, 64 ], 13, 13, 13, [ 14, 68 ], 13, 13, 13, [ 14, 64 ], 13, 13, 13, 13, 
  13, [ 14, 85 ], 13, 13, 13, 13, 12, 12, 12, 11, 11, 12, 11, 11, 13, 12, 11, 
  11, 12, 11, 11, 11, [ 0, 38, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, [ 0, 32, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, [ 0, 24, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  12, 11, 11, 11, 11, [ 0, 16, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 13, 12, 11, 11, 
  11, 11, 11, 13, [ 14, 117 ], 11, [ 14, 130 ], [ 14, 181 ], 11, [ 14, 214 ], 
  [ 14, 225 ], [ 14, 178 ], [ 14, 179 ], [ 14, 211 ], [ 14, 227 ], 
  [ 14, 235 ], [ 14, 239 ] ],
#V   n = 244
[ ,,,,,,,,,,, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  [ 14, 11 ], 13, [ 14, 12 ], 13, [ 14, 12 ], 13, 13, [ 14, 12 ], 13, 13, 13, 
  13, [ 14, 14 ], 13, 13, [ 14, 14 ], 13, 13, 13, [ 14, 23 ], 13, [ 14, 23 ], 
  13, 13, 13, [ 14, 27 ], 13, [ 14, 24 ], 13, 13, 13, 13, 13, [ 14, 32 ], 13, 
  13, [ 14, 34 ], 13, 13, 13, 13, [ 14, 33 ], 13, 13, [ 14, 28 ], 13, 13, 13, 
  [ 14, 32 ], 13, 13, [ 14, 44 ], 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
  [ 14, 50 ], 13, 13, [ 14, 49 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 49 ], 13, 
  13, 13, 13, 12, 12, [ 14, 69 ], 13, 13, 13, 13, 13, [ 14, 70 ], 13, 13, 
  [ 14, 65 ], 13, 13, 13, [ 14, 69 ], 13, 13, 13, [ 14, 65 ], 13, 13, 13, 13, 
  13, [ 14, 86 ], [ 0, 50, "Jo" ], 13, 13, 13, 12, 12, 12, 11, 11, 12, 11, 
  11, 13, [ 0, 42, "Jo" ], 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 13, [ 14, 118 ], 
  11, [ 14, 131 ], [ 14, 182 ], 11, [ 14, 215 ], [ 14, 226 ], [ 14, 179 ], 
  [ 14, 180 ], [ 14, 212 ], [ 14, 228 ], [ 14, 236 ], [ 14, 240 ] ],
#V   n = 245
[ ,,,,,,,,,,, [ 0, 117, "BK" ], 13, [ 0, 115, "BK" ], 13, 13, 
  [ 0, 113, "BK" ], 13, [ 0, 111, "BK" ], 13, [ 0, 109, "BK" ], 13, 13, 13, 
  13, 13, 13, [ 14, 12 ], 13, [ 14, 13 ], 13, [ 14, 13 ], 13, 13, [ 14, 13 ], 
  13, 13, 13, 13, [ 14, 15 ], 13, 13, [ 14, 15 ], 13, 13, 13, [ 14, 24 ], 13, 
  [ 14, 24 ], 13, 13, 13, [ 14, 28 ], 13, [ 14, 25 ], 13, 13, 13, 13, 13, 
  [ 14, 33 ], 13, 13, [ 14, 35 ], 13, 13, 13, 13, [ 14, 34 ], 13, 13, 
  [ 14, 29 ], 13, 13, 13, [ 14, 33 ], 13, 13, [ 14, 45 ], 13, 13, 13, 13, 13, 
  13, [ 14, 34 ], 11, 13, 13, [ 14, 51 ], 13, 13, [ 14, 50 ], 13, 13, 13, 13, 
  13, 12, 12, [ 14, 50 ], 13, 13, 13, 13, 12, 12, [ 14, 70 ], 13, 13, 13, 13, 
  13, [ 14, 71 ], 13, 13, [ 14, 66 ], 13, 13, 13, [ 14, 70 ], 13, 13, 13, 
  [ 14, 66 ], 13, 13, 13, 13, 13, 12, 11, 13, 13, 13, 12, 12, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  [ 0, 34, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 13, 
  [ 14, 119 ], 11, [ 14, 132 ], [ 14, 183 ], 11, [ 14, 216 ], [ 14, 227 ], 
  [ 14, 180 ], [ 14, 181 ], [ 14, 213 ], [ 14, 229 ], [ 14, 237 ], 
  [ 14, 241 ] ],
#V   n = 246
[ ,,,,,,,,, [ 14, 4 ],, 12, 11, 13, 11, 13, 13, 11, 13, 11, 13, 11, 13, 13, 
  13, 13, 13, 13, [ 14, 13 ], 13, [ 14, 14 ], 13, [ 14, 14 ], 13, 13, 
  [ 14, 14 ], 13, 13, 13, 13, [ 14, 16 ], 13, 13, [ 14, 16 ], 13, 13, 13, 
  [ 14, 25 ], 13, [ 14, 25 ], 13, 13, 13, [ 14, 29 ], 13, [ 14, 26 ], 13, 13, 
  13, 13, 13, [ 14, 34 ], 13, 13, [ 14, 36 ], 13, 13, 13, 13, [ 14, 35 ], 13, 
  13, [ 14, 30 ], 13, 13, 13, [ 14, 34 ], 13, 13, [ 14, 46 ], 13, 13, 13, 13, 
  13, 13, 11, 13, 13, 13, [ 14, 52 ], 13, 13, [ 14, 51 ], 13, 13, 13, 13, 13, 
  12, 12, [ 14, 51 ], 13, 13, 13, 13, [ 14, 46 ], 12, [ 14, 71 ], 13, 13, 13, 
  13, 13, [ 14, 72 ], 13, 13, [ 14, 67 ], 13, 13, 13, [ 14, 71 ], 13, 13, 13, 
  [ 14, 67 ], 13, 13, 13, 13, 12, 12, 11, 13, 13, 13, 12, 12, [ 0, 46, "Jo" ],
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 13, [ 14, 120 ], 
  11, [ 14, 133 ], [ 14, 184 ], 11, [ 14, 217 ], [ 14, 228 ], [ 14, 181 ], 
  [ 14, 182 ], [ 14, 214 ], [ 14, 230 ], [ 14, 238 ], [ 14, 242 ] ],
#V   n = 247
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], 12, 12, 11, 13, 11, 13, 13, 11, 13, 11, 13, 
  11, 13, 13, 13, 13, 13, 13, [ 14, 14 ], 13, [ 14, 15 ], 13, [ 14, 15 ], 13, 
  13, [ 14, 15 ], 13, 13, 13, 13, [ 14, 17 ], 13, 13, [ 14, 17 ], 13, 13, 13, 
  [ 14, 26 ], 13, [ 14, 26 ], 13, 13, 13, [ 14, 30 ], 13, [ 14, 27 ], 13, 13, 
  13, 13, 13, [ 14, 35 ], 13, 13, [ 14, 37 ], 13, 13, 13, 13, [ 14, 36 ], 13, 
  13, [ 14, 31 ], 13, 13, 13, [ 14, 35 ], 13, 13, [ 14, 47 ], 13, 13, 13, 13, 
  13, 13, [ 14, 36 ], 13, 13, 13, [ 14, 53 ], 13, 13, [ 14, 52 ], 13, 13, 13, 
  13, 13, 12, 12, [ 14, 52 ], 13, 13, 13, [ 14, 46 ], [ 14, 47 ], 12, 
  [ 14, 72 ], 13, 13, 13, 13, 13, [ 14, 73 ], 13, 13, [ 14, 68 ], 13, 13, 13, 
  [ 14, 72 ], 13, 13, 13, [ 14, 68 ], 13, 13, 13, 12, 12, 12, 11, 13, 13, 13, 
  12, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, [ 0, 40, "Jo" ], 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, [ 0, 22, "Jo" ], 11, 
  11, 11, 12, 11, 11, 11, 11, [ 0, 18, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 13, [ 14, 121 ], 11, [ 14, 134 ], 
  [ 14, 185 ], 11, [ 14, 218 ], [ 14, 229 ], [ 14, 182 ], [ 14, 183 ], 
  [ 14, 215 ], [ 14, 231 ], [ 14, 239 ], [ 14, 243 ] ],
#V   n = 248
[ ,,,,,,,, 13,, [ 14, 5 ], [ 14, 6 ], 12, 12, 11, 13, 11, 13, 13, 11, 13, 11, 
  13, 11, 13, 13, 13, 13, 13, 13, [ 14, 15 ], 13, [ 14, 16 ], 13, [ 14, 16 ], 
  13, 13, [ 14, 16 ], 13, 13, 13, 13, [ 14, 18 ], 13, 13, [ 14, 18 ], 13, 13, 
  13, [ 14, 27 ], 13, [ 14, 27 ], 13, 13, 13, 13, 13, [ 14, 28 ], 13, 13, 13, 
  13, 13, [ 14, 36 ], 13, 13, [ 14, 38 ], 13, 13, 13, 13, [ 14, 37 ], 13, 13, 
  [ 14, 32 ], 13, 13, 13, [ 14, 36 ], 13, 13, [ 14, 48 ], 13, 13, 13, 13, 13, 
  13, [ 14, 37 ], 13, 13, 13, [ 14, 54 ], 13, 13, [ 14, 53 ], 13, 13, 13, 13, 
  13, 12, 12, [ 14, 53 ], 13, 13, 13, [ 14, 47 ], [ 14, 48 ], 12, [ 14, 50 ], 
  13, 13, 13, 13, 13, [ 14, 74 ], 13, 13, [ 14, 69 ], 13, 13, 13, [ 14, 73 ], 
  13, 13, 13, [ 14, 69 ], 13, 13, 13, 12, 12, 12, 11, 13, 13, 13, 12, 12, 11, 
  11, 11, [ 0, 44, "Jo" ], 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 13, 
  [ 14, 122 ], 11, [ 14, 135 ], [ 14, 186 ], 11, [ 14, 219 ], [ 14, 230 ], 
  [ 14, 183 ], [ 14, 184 ], [ 14, 216 ], [ 14, 232 ], [ 14, 240 ], 
  [ 14, 244 ] ],
#V   n = 249
[ ,,,,,,,, 13, [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ], 12, 12, 11, 13, 11, 13, 13, 
  11, 13, 11, 13, 11, 13, 13, 13, 13, 13, 13, [ 14, 16 ], 13, [ 14, 17 ], 13, 
  [ 14, 17 ], 13, 13, [ 14, 17 ], 13, 13, 13, 13, [ 14, 19 ], 13, 13, 
  [ 14, 19 ], 13, 13, 13, [ 14, 28 ], 13, [ 14, 28 ], 13, 13, [ 14, 20 ], 13, 
  13, [ 14, 29 ], 13, 13, 13, 13, 13, 13, 13, 13, [ 14, 39 ], 13, 13, 13, 13, 
  [ 14, 38 ], 13, 13, [ 14, 33 ], 13, 13, 13, [ 14, 37 ], 13, 13, [ 14, 49 ], 
  13, 13, 13, 13, 13, 13, [ 14, 38 ], 13, 13, 13, [ 14, 55 ], 13, 13, 
  [ 14, 54 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 54 ], 13, 13, 13, [ 14, 48 ], 
  [ 14, 49 ], [ 14, 50 ], [ 14, 51 ], 13, 13, 13, 13, 13, [ 14, 75 ], 13, 13, 
  [ 14, 70 ], 13, 13, 13, [ 14, 74 ], 13, 13, 13, [ 14, 70 ], 13, 13, 13, 12, 
  12, 12, 11, 13, 13, 12, 12, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, [ 0, 36, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  11, 13, 12, 11, 11, 11, 11, 11, 13, [ 14, 123 ], 11, [ 14, 136 ], 
  [ 14, 187 ], 11, [ 14, 220 ], [ 14, 231 ], [ 14, 184 ], [ 14, 185 ], 
  [ 14, 217 ], [ 14, 233 ], [ 14, 241 ], [ 14, 245 ] ],
#V   n = 250
[ ,,,,,,,, [ 0, 123, "BK" ], 13, [ 14, 5 ],, [ 14, 4 ], [ 14, 8 ], 12, 12, 
  13, 13, 13, 13, 13, 11, 13, 11, 13, 11, 13, 13, 13, 13, 13, 13, [ 14, 17 ], 
  13, [ 14, 18 ], 13, [ 14, 18 ], 13, 13, [ 14, 18 ], 13, 13, 13, 13, 
  [ 14, 20 ], 13, 13, [ 14, 20 ], 13, 13, 13, 13, 13, [ 14, 29 ], 13, 13, 
  [ 14, 21 ], 13, 13, [ 14, 30 ], 13, 13, 13, 13, [ 14, 24 ], 13, 13, 13, 
  [ 14, 40 ], 13, 13, 13, 13, [ 14, 39 ], 13, 13, [ 14, 34 ], 13, 13, 13, 
  [ 14, 38 ], 13, 13, [ 14, 50 ], 13, 13, 13, 13, 13, 13, [ 14, 39 ], 13, 13, 
  13, [ 14, 56 ], 13, 13, [ 14, 55 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 55 ], 
  13, 13, 13, [ 14, 49 ], [ 14, 50 ], [ 14, 51 ], 13, 13, 13, 13, 13, 13, 
  [ 14, 76 ], 13, 13, [ 14, 71 ], 13, 13, 13, [ 14, 75 ], 13, 13, 13, 
  [ 14, 71 ], 13, 13, 13, 12, 12, [ 0, 50, "Jo" ], 11, 13, 13, 12, 13, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 
  11, 11, 11, 12, 11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 13, 
  [ 14, 124 ], 11, [ 14, 137 ], [ 14, 188 ], 11, [ 14, 221 ], [ 14, 232 ], 
  [ 14, 185 ], [ 14, 186 ], [ 14, 218 ], [ 14, 234 ], [ 14, 242 ], 
  [ 14, 246 ] ],
#V   n = 251
[ ,,,,,,,,, 11, 13, [ 14, 6 ], [ 14, 4 ], [ 14, 5 ], [ 14, 9 ], 12, 
  [ 14, 6 ], 13, [ 14, 6 ], 13, 13, 13, 11, 13, 11, 13, 11, 13, 13, 13, 13, 
  13, 13, [ 14, 18 ], 13, 13, 13, 13, 13, 13, [ 14, 19 ], 13, 13, 13, 13, 
  [ 14, 21 ], 13, 13, [ 14, 21 ], 13, 13, [ 14, 18 ], 13, 13, [ 14, 30 ], 13, 
  13, [ 14, 22 ], 13, 13, [ 14, 31 ], 13, 13, 13, 13, [ 14, 25 ], 13, 13, 13, 
  13, 13, 13, 13, 13, [ 14, 40 ], 13, 13, [ 14, 35 ], 13, 13, 13, [ 14, 39 ], 
  13, 13, [ 14, 51 ], 13, 13, 13, 13, 13, 13, [ 14, 40 ], 13, 13, 13, 
  [ 14, 57 ], 13, 13, [ 14, 56 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 56 ], 13, 
  13, 13, [ 14, 50 ], [ 14, 51 ], [ 14, 52 ], 13, 13, 13, 13, 13, 13, 
  [ 14, 77 ], 13, 13, [ 14, 72 ], 13, 13, 13, [ 14, 76 ], 13, 13, 13, 
  [ 14, 72 ], 13, 13, 13, 12, 12, 11, 11, 13, 13, 13, 13, 12, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 13, [ 14, 125 ], 11, 
  [ 14, 138 ], [ 14, 189 ], 11, [ 14, 222 ], [ 14, 233 ], [ 14, 186 ], 
  [ 14, 187 ], [ 14, 219 ], [ 14, 235 ], [ 14, 243 ], [ 14, 247 ] ],
#V   n = 252
[ ,,,,,,,,,, 11, 13, [ 14, 7 ], [ 14, 5 ], [ 14, 6 ], [ 14, 10 ], 12, 
  [ 14, 7 ], 13, [ 14, 7 ], 13, 13, 13, 13, 13, 13, 13, 11, 13, 13, 13, 13, 
  13, 13, 13, [ 14, 12 ], 13, [ 14, 12 ], 11, 13, 13, [ 14, 20 ], 13, 13, 13, 
  13, [ 14, 22 ], 13, 13, [ 14, 22 ], 13, 13, [ 14, 19 ], 13, 13, 13, 13, 13, 
  [ 14, 23 ], 13, 13, [ 14, 32 ], 13, 13, 13, 13, [ 14, 26 ], 13, 13, 
  [ 14, 26 ], 11, 13, 13, 13, 13, [ 14, 41 ], 13, 13, [ 14, 36 ], 13, 13, 13, 
  [ 14, 40 ], 13, 13, [ 14, 52 ], 13, 13, 13, 13, 13, 13, [ 14, 41 ], 13, 13, 
  13, [ 14, 58 ], 13, 13, [ 14, 57 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 57 ], 
  13, 13, 13, [ 14, 51 ], 12, [ 14, 53 ], 11, 13, 13, 13, 13, 13, [ 14, 78 ], 
  13, 13, [ 14, 73 ], 13, 13, 13, [ 14, 77 ], 13, 13, 13, [ 14, 73 ], 13, 13, 
  13, 12, 12, 11, 11, 13, [ 0, 48, "Jo" ], 13, 13, 12, 11, 11, 12, 11, 11, 
  11, [ 0, 42, "Jo" ], 11, 11, 12, 11, 11, 11, [ 0, 38, "Jo" ], 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, [ 0, 30, "Jo" ], 11, 11, 11, 
  [ 0, 28, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 13, 
  12, 11, 11, 11, 11, 11, 13, [ 14, 126 ], 11, [ 14, 139 ], [ 14, 190 ], 11, 
  [ 14, 223 ], [ 14, 234 ], [ 14, 187 ], [ 14, 188 ], [ 14, 220 ], 
  [ 14, 236 ], [ 14, 244 ], [ 14, 248 ] ],
#V   n = 253
[ ,,,,,,,,, [ 14, 4 ],, 13, [ 14, 4 ], [ 14, 8 ], [ 14, 6 ], [ 14, 7 ], 12, 
  12, [ 14, 8 ], 13, [ 14, 8 ], 13, 13, [ 14, 8 ], 13, [ 14, 8 ], 13, 13, 11, 
  13, 13, 13, 13, 13, [ 14, 12 ], 13, [ 14, 13 ], 13, 11, 13, 13, 13, 
  [ 14, 21 ], 13, 13, 13, 13, [ 14, 23 ], 13, 13, [ 14, 23 ], 13, 13, 
  [ 14, 20 ], 13, [ 14, 20 ], 13, 13, 13, [ 14, 24 ], 13, 13, [ 14, 33 ], 13, 
  13, 13, 13, [ 14, 27 ], 13, 13, 11, 13, 13, 13, 13, 13, [ 14, 42 ], 13, 13, 
  [ 14, 37 ], 13, 13, 13, [ 14, 41 ], 13, 13, [ 14, 53 ], 13, 13, 13, 13, 13, 
  13, [ 14, 42 ], 13, 13, 13, [ 14, 59 ], 13, 13, [ 14, 58 ], 13, 13, 13, 13, 
  13, 12, 12, [ 14, 58 ], 13, 13, 13, 12, 12, 11, 13, 13, 13, 13, 13, 13, 
  [ 14, 79 ], 13, 13, [ 14, 74 ], 13, 13, 13, [ 14, 78 ], 13, 13, 13, 
  [ 14, 74 ], 13, 13, 12, 12, 12, 11, 11, 12, 11, 13, 13, [ 0, 46, "Jo" ], 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, [ 0, 32, "Jo" ], 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 
  13, [ 14, 127 ], 11, [ 14, 140 ], [ 14, 191 ], 11, [ 14, 224 ], 
  [ 14, 235 ], [ 14, 188 ], [ 14, 189 ], [ 14, 221 ], [ 14, 237 ], 
  [ 14, 245 ], [ 14, 249 ] ],
#V   n = 254
[ ,,,,,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 4 ], 13, [ 14, 5 ], [ 14, 9 ], 
  [ 14, 7 ], [ 14, 8 ], 12, 12, [ 14, 9 ], 13, [ 14, 9 ], 13, 13, [ 14, 9 ], 
  13, [ 14, 9 ], 13, 13, 13, 13, 13, 13, 13, 13, [ 14, 13 ], 13, [ 14, 14 ], 
  13, [ 14, 14 ], 13, 13, 13, [ 14, 22 ], 13, 13, 13, 13, [ 14, 24 ], 13, 13, 
  [ 14, 24 ], 13, 13, [ 14, 21 ], 13, [ 14, 21 ], 13, 13, 13, [ 14, 25 ], 13, 
  13, [ 14, 34 ], 13, 13, 13, 13, [ 14, 28 ], 13, 13, [ 14, 28 ], 13, 13, 13, 
  13, 13, [ 14, 43 ], 13, 13, [ 14, 38 ], 13, 13, 13, [ 14, 42 ], 13, 13, 
  [ 14, 54 ], 13, 13, 13, 13, 13, 13, [ 14, 43 ], 13, 13, 13, [ 14, 60 ], 13, 
  13, [ 14, 59 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 59 ], 13, 13, 13, 12, 11, 
  [ 14, 55 ], 13, 13, 13, 13, 13, 13, [ 14, 80 ], 13, 13, [ 14, 75 ], 13, 13, 
  13, [ 14, 79 ], 13, 13, 13, [ 14, 75 ], 13, 13, 12, 12, 12, 11, 11, 12, 11, 
  13, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  11, [ 0, 26, "Jo" ], 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 11, [ 0, 10, "sph" ], 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  13, 12, 11, 11, 11, 11, 11, 13, [ 0, 4, "Jo" ], 11, [ 14, 141 ], 
  [ 14, 192 ], 11, [ 14, 225 ], [ 14, 236 ], [ 14, 189 ], [ 14, 190 ], 
  [ 14, 222 ], [ 14, 238 ], [ 14, 246 ], [ 14, 250 ] ],
#V   n = 255
[ ,,,,,,,,,, [ 14, 5 ], [ 14, 6 ], [ 14, 5 ], 13, [ 14, 6 ], [ 14, 10 ], 
  [ 14, 8 ], [ 14, 9 ], 12, 12, [ 14, 10 ], 13, [ 14, 10 ], 13, 13, 
  [ 14, 10 ], 13, [ 14, 10 ], 13, [ 14, 10 ], 13, 13, 13, 13, 13, 13, 
  [ 14, 14 ], 13, [ 14, 15 ], 13, [ 14, 15 ], 13, 13, 13, [ 14, 23 ], 13, 13, 
  13, 12, [ 14, 25 ], 13, 13, [ 14, 25 ], 13, 13, [ 14, 22 ], 13, [ 14, 22 ], 
  13, 13, 13, [ 14, 26 ], 13, 13, [ 14, 35 ], 13, 13, 13, 13, [ 14, 29 ], 13, 
  13, [ 14, 29 ], 13, 13, 13, 13, 13, [ 14, 44 ], 13, 13, [ 14, 39 ], 13, 13, 
  13, [ 14, 43 ], 13, 13, 13, 13, 13, 13, 13, 13, 13, [ 14, 44 ], 13, 13, 13, 
  [ 14, 61 ], 13, 13, [ 14, 60 ], 13, 13, 13, 13, 13, 12, 12, [ 14, 60 ], 13, 
  13, 13, 11, 12, [ 14, 56 ], 13, 13, 13, 13, 13, 13, [ 14, 81 ], 13, 13, 
  [ 14, 76 ], 13, 13, 13, [ 14, 80 ], 13, 13, 13, [ 14, 76 ], 13, 13, 12, 12, 
  12, 11, 11, 12, 11, 13, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 
  [ 0, 20, "Jo " ], 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 
  11, 13, 12, 11, 11, 11, 11, 11, 12, 11, 11, [ 14, 142 ], [ 14, 193 ], 11, 
  [ 14, 226 ], [ 14, 237 ], [ 14, 190 ], [ 14, 191 ], [ 14, 223 ], 
  [ 14, 239 ], [ 14, 247 ], [ 14, 251 ] ],
#V   n = 256
[ ,,,,,,,,, [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ], [ 14, 6 ], 11, [ 14, 7 ], 
  [ 14, 11 ], [ 14, 6 ], [ 14, 10 ], 12, 12, [ 14, 11 ], 12, [ 14, 11 ], 11, 
  13, [ 14, 11 ], 12, [ 14, 11 ], 12, [ 14, 11 ], 11, 13, 11, 13, 11, 12, 
  [ 14, 15 ], 12, [ 14, 16 ], 12, [ 14, 16 ], 11, 11, 13, [ 14, 24 ], 11, 13, 
  11, 12, [ 14, 26 ], 11, 12, [ 14, 26 ], 11, 12, [ 14, 23 ], 12, [ 14, 23 ], 
  11, 11, 13, [ 14, 27 ], 11, 12, [ 14, 36 ], 11, 13, 11, 12, [ 14, 30 ], 11, 
  12, [ 14, 30 ], 11, 11, 13, 13, 13, [ 14, 45 ], 11, 12, [ 14, 40 ], 11, 11, 
  13, [ 14, 44 ], 11, [ 14, 36 ], 11, 11, 13, 13, 13, 11, 13, [ 14, 45 ], 11, 
  11, 12, [ 14, 62 ], 11, 12, [ 14, 61 ], 11, 11, 13, 13, 13, 12, 12, 
  [ 14, 61 ], 11, 11, 13, 12, 12, [ 14, 57 ], 11, 11, 13, 11, 11, 12, 
  [ 14, 82 ], 11, 12, [ 14, 77 ], 11, 11, 13, [ 14, 81 ], 11, 11, 13, 
  [ 14, 77 ], 11, 12, 12, 12, 12, 11, 11, 12, 11, 13, 12, 11, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 
  11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 12, 11, 11, [ 14, 143 ], 
  [ 14, 194 ], 11, [ 14, 227 ], [ 14, 238 ], [ 14, 128 ], [ 14, 192 ], 
  [ 14, 224 ], [ 14, 240 ], [ 14, 248 ], [ 14, 252 ] ],
#V   n = 257
[ ,,,,,,,,, 12, 11,, 12, 12, 11, 11, 11, 12, 11, 12, 12, 12, 12, 12, 11, 11, 
  12, 12, 12, 12, 12, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 12, 12, 12, 11, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 12, 
  11, 11, 11, 12, 11, 12, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 11, 11, 12, 12, 12, 11, 11, 11, 12, 12, 12, 11, 11, 11, 
  11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 12, 
  12, 12, 11, 11, 12, 11, 12, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 12, 11, 11, 11, 
  12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 12, 
  11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 11 
 ]];