#############################################################################
##
#W  omget.g           OpenMath Sharepackage         Andrew Solomon
##
#H  @(#)$Id: omget.g,v 1.5 2000/03/29 16:28:54 andrews Exp $
##
#Y  Copyright (C)  1997,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St.  Andrews, Scotland
##
##  Reads an XML encoded object from an input stream and returns
##  a GAP object.
##
##

#############################################################################
##
#F  OMGetObject 
##
##  <stream> is an input stream with an OpenMath object on it.
##  Takes precisely one object off <stream> (using pipeobj)
##  and puts it onto an output stream connected to a named
##  pipe (from.gap) to gpipe, which parses the object into
##  a byte stream and returns it on "to.gap". 
##  From there the byte stream is turned into a GAP object
##  by OMgetObjectByteStream.
##

InstallGlobalFunction("OMGetObject",
function(stream)
  local
    tmpdir,
    instream, outstream, # streams from gpipe and to gpipe
    fromgap, togap, # named pipes 
		path,	# path of executable
		exec; # filename of executable

	path := DirectoriesPackagePrograms("openmath");
	exec := Filename(path, "gpipe");
  
  # create a temporary directory
  tmpdir := DirectoryTemporary(); 
  
  # make names for the named pipes: pout: GAP->gpipe, pin: gpipe->GAP
  fromgap := Filename( tmpdir, "from.gap" );
  togap := Filename( tmpdir, "to.gap" );
  
  # create the pipes
  Exec(Concatenation(["mkfifo ",fromgap]));
  Exec(Concatenation(["mkfifo ",togap]));

  # now run gpipe in the background
  Exec(Concatenation(["cat ",fromgap," | ",exec," -x -  ",togap," &"]));

  instream := InputTextFile(togap);
  outstream := OutputTextFile(fromgap, false);
  PipeOpenMathObject(stream, outstream);


  # feed in the object to outstream
  return OMgetObjectByteStream(instream);

end);



