#######################################################################
##
#W  om.gd          GAP OpenMath Share Package           Andrew Solomon
##
#H  @(#)$Id: omput.gd,v 1.4 2000/08/15 01:52:26 gap Exp $
##
#Y  Copyright (C)  1997,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St.  Andrews, Scotland
##
##
## 
Revision.("openmath/gap/om.gd") := 
"@(#)$Id: omput.gd,v 1.4 2000/08/15 01:52:26 gap Exp $";


#######################################################################
##
#F  OMPutObject( <stream>, <obj> )  
## 
##  OMPutObject writes the XML OpenMath encoding of the GAP object <obj> to
##  output stream <stream>.
## 
DeclareGlobalFunction("OMPutObject");

#######################################################################
##
#O  OMPut(<stream>,<obj> ) 
## 
##
DeclareOperation("OMPut", [IsOutputStream, IsObject ]);


#######################################################################
##
#O  OMPutList(<stream>,<obj> ) 
## 
##  Tries to render this as an OpenMath list
##
DeclareOperation("OMPutList", [IsOutputStream, IsObject ]);

#######################################################################
##
#F  OMPrint( <obj> ) ....   Print <obj> as OpenMath object 
##
##  OMPrint writes the XML OpenMath encoding of GAP object <obj> 
##  to the standard output.
##

DeclareGlobalFunction("OMPrint");


#######################################################################
##
#F  OMWriteLine( <stream>, <list> )
##
##  Auxilliary function for OMPut functions.
##  Takes a list of string arguments and outputs them
##  to a single line with the correct indentation.
##
##  Input : List of arguments to print
##  Output: \t ^ OMIndent, arguments
##
DeclareGlobalFunction("OMWriteLine");


#######################################################################
##
#F  OMPutSymbol( <stream>, <cd>, <name> )
##
##  Input : cd, name as strings
##  Output: <OMS cd="<cd>" name="<name>" />
##
DeclareGlobalFunction("OMPutSymbol");


#######################################################################
##
#F  OMPutVar( <stream>, <name> )
##
##  Input : name as string
##  Output: <OMV name="<name>" />
##
DeclareGlobalFunction("OMPutVar");





# Determines the indentation of the next line to be printed.
OMIndent := 0;


######################################################################
##
#E

