#############################################################################
##
#W  collect.gd                  Polycyc                         Werner Nickel
##

#############################################################################
##
##  First we need a new representation for a power-conjugate collector, which
##  will  implement the  generic collector  for  groups given by a polycyclic
##  presentation.
##
#R  IsFromTheLeftCollectorRep( <obj> )  . . . . . . . . . . . . . . . . . . .
##
DeclareRepresentation( "IsFromTheLeftCollectorRep",
                        IsPowerConjugateCollector, [] );

BindGlobal( "FromTheLeftCollectorFamily",
    NewFamily( "FromTheLeftCollector", IsFromTheLeftCollectorRep ) );
          
#############################################################################
##  
#P  The following property is used to dispatch between a GAP level collector
#P  and the kernel collector.           . . . . . . . . . . . . . . . . . . .
##
DeclareProperty( "UseLibraryCollector", IsFromTheLeftCollectorRep  );

#############################################################################
##
##  Next the  operation for creating a from the left collector is defined.
##
#O  FromTheLeftCollector. . . . . . . . . . . . . . . . . . . . . . . . . . .
##
DeclareOperation( "FromTheLeftCollector", [IsObject] );

#############################################################################
##
#I  InfoFromTheLeftCollector . . . . . . . . . . . . . . . . . . . . . . . .
##
DeclareInfoClass( "InfoFromTheLeftCollector" );

#############################################################################
##
#H this is just a hack
##
PC_PCP_ELEMENTS_FAMILY := 22;
PC_PCP_ELEMENTS_TYPE := 23;

PC_COMMUTATORS := 24;
PC_INVERSECOMMUTATORS := 25;
PC_COMMUTATORSINVERSE := 26;
PC_INVERSECOMMUTATORSINVERSE := 27;
