#############################################################################
##
#W  pcplib.gi                    Polycyc                         Bettina Eick
##

##
## Some functions to construct generic pcp groups
##

#############################################################################
##
#M AbelianPcpGroup
##
InstallGlobalFunction( AbelianPcpGroup, function( n, rels )
    local coll, i;
    coll := FromTheLeftCollector( n );
    for i in [1..n] do
        if IsBound( rels[i] ) and rels[i] > 0 then
            SetRelativeOrder( coll, i, rels[i] );
        fi;
    od;
    return PcpGroupByCollector( coll );
end );

#############################################################################
##
#M DihedralPcpGroup
##
InstallGlobalFunction( DihedralPcpGroup, function( n )
    local coll, m;
    coll := FromTheLeftCollector( 2 );
    SetRelativeOrder( coll, 1, 2 );
    if IsInt( n ) then 
        m := n/2;
        if not IsInt( m ) then return fail; fi;
        SetRelativeOrder( coll, 2, m ); 
        SetConjugate( coll, 2,  1, [2,m-1] );
    else
        SetConjugate( coll, 2,  1, [2,-1] );
        SetConjugate( coll, 2, -1, [2,-1] );
    fi;
    return PcpGroupByCollector( coll );
end );

#############################################################################
##
#M UnitriangularPcpGroup(n)
##
UnitriangularPcpGroup := function( n )
    local l, c, g, m, id, i, j, h, k, v, o, r;

    l := n*(n-1)/2;
    c := FromTheLeftCollector( l );

    # compute matrix generators
    g := [];
    for i in [1..n-1] do
        for j in [1..n-i] do
            r := IdentityMat( n );
            r[j][i+j] := 1;
            Add( g, r );
        od;
    od;
    h := List( g, x -> x^-1 );

    # read of pc presentation
    m := IdentityMat( n );
    for i in [1..Length(g)] do
        for j in [1..i-1] do
            v := Comm( g[j], g[i] );
            if v <> m then
                if v in g then
                    k := Position( g, v );
                    o := [k, -1];
                elif v in h then
                    k := Position( h, v );
                    o := [k, 1];
                else
                    Error("generator out of range"); 
                fi;
                SetCommutator( c, i, j, o );
            fi;
        od;
    od;
    return PcpGroupByCollector( c );
end;

#############################################################################
##
#M SubgroupUnitriangularPcpGroup( mats )
##
SubgroupUnitriangularPcpGroup := function( mats )
    local n, G, g, i, j, r, h, m, e, v, c;

    # get the dimension and the full unitriangluar group
    n := Length( mats[1] );
    G := UnitriangularPcpGroup( n );

    # compute corresponding generators
    g := [];
    for i in [1..n-1] do
        for j in [1..n-i] do
            r := IdentityMat( n );
            r[j][i+j] := 1;
            Add( g, r );
        od;
    od;

    # get exponents for each matrix
    h := [];
    for m in mats do
        e := [];
        c := 0;
        for i in [1..n-1] do
            v := List( [1..n-i], x -> m[x][x+i] );
            r := MappedVector( v, g{[c+1..c+n-i]} );
            m := r^-1 * m;
            c := c + n-i;
            Append( e, v ); 
        od;
        Add( h, MappedVector( e, Pcp(G) ) );
    od;

    return Subgroup( G, h );
end;
