#A  BOUNDS FOR q = 4
##
##  Each entry [n][k] of one of the tables below contains
##  a bound (the first table contains lowerbounds, the   
##  second upperbounds) for a code with wordlength n and 
##  dimension k. Each entry contains one of the following
##  items:                                               
##                                                       
##  FOR LOWER- AND UPPERBOUNDSTABLE                      
##  [ 0, <d>, <ref> ]  from Brouwers table               
##                                                       
##  FOR LOWERBOUNDSTABLE                                 
##  empty        k= 0, 1, n or d= 2 or (k= 2 and q= 2)   
##  1            shortening a [ n + 1, k + 1 ] code      
##  2            puncturing a [ n + 1, k ] code          
##  3            extending a [ n - 1, k ] code           
##  [ 4, <dd> ]  constr. B, of a [ n+dd, k+dd-1, d ] code
##  [ 5, <k1> ]  an UUV-construction with a [ n / 2, k1 ]
##               and a [ n / 2, k - k1 ] code            
##  [ 6, <n1> ]  concatenation of a [ n1, k ] and a      
##               [ n - n1, k ] code                      
##  [ 7, <n1> ]  taking the residue of a [ n1, k + 1 ] code
##                                                       
##  FOR UPPERBOUNDSTABLE                                 
##  empty        Griesmer bound                          
##  11           shortening a [ n + 1, k + 1 ] code      
##  12           puncturing a [ n + 1, k ] code          
##  13           extending a [ n - 1, k ] code           
##  [ 14, <dd> ] constr. B, with dd = dual distance      


GUAVA_BOUNDS_TABLE[1][4] := [
#V   n = 1
[  ],
#V   n = 2
[  ],
#V   n = 3
[  ],
#V   n = 4
[ , 1 ],
#V   n = 5
[ , 1, 2 ],
#V   n = 6
[ , [ 6, 3 ], [ 0, 4, "GH" ] ],
#V   n = 7
[ , 1, 3, 2 ],
#V   n = 8
[ , 1, 1, [ 5, 3 ], 1 ],
#V   n = 9
[ , [ 4, 8 ], 1, 1, 1, 2 ],
#V   n = 10
[ , [ 7, 42 ], [ 6, 4 ], 1, 1, 2, 1 ],
#V   n = 11
[ , 1, 2, 2, 1, 2, 1, 2 ],
#V   n = 12
[ , 1, [ 6, 6 ], 2, 1, [ 0, 6, "Q1" ], [ 5, 4 ], [ 5, 5 ], 1 ],
#V   n = 13
[ , 1, 1, 2, 1, 3, 1, 1, 1, 1 ],
#V   n = 14
[ , 1, 1, 2, 1, 1, 1, 1, [ 5, 6 ], 1, 1 ],
#V   n = 15
[ , 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1 ],
#V   n = 16
[ , 1, 1, 2, 1, 2, 1, 1, 2, 1, [ 5, 7 ], 1, 2 ],
#V   n = 17
[ , 1, 2, [ 0, 12, "GH" ], 1, 2, 1, 1, 2, 1, 1, 1, [ 0, 4, "c" ], 1 ],
#V   n = 18
[ , 1, 2, 3, 2, [ 0, 10, "Gu" ], 1, 1, [ 0, 8, "MO" ], 2, 1, 1, 3, 1, 1 ],
#V   n = 19
[ , 1, 2, 3, 2, 3, 1, 1, 3, 2, 1, 1, 2, 1, 2, 1 ],
#V   n = 20
[ , 1, 2, 1, 2, 1, 1, 1, 3, [ 0, 8, "Q1" ], 1, 2, [ 0, 6, "Slo" ], 1, 2, 1, 1 
 ],
#V   n = 21
[ , 1, [ 0, 16, "La" ], 1, 2, 1, 1, 1, 1, 3, 1, [ 0, 7, "Ki" ], 3, 1, 
  [ 0, 5, "Ki" ], 1, 1, [ 0, 3, "HM" ] ],
#V   n = 22
[ , [ 7, 90 ], 3, 1, 2, 2, 1, 1, 1, 1, 1, 3, 3, 1, 3, 1, 1, 3 ],
#V   n = 23
[ , [ 6, 3 ], 3, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2 ],
#V   n = 24
[ , [ 6, 4 ], [ 6, 3 ], 2, [ 0, 16, "Liz" ], 2, [ 0, 13, "GuB" ], 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1, [ 5, 11 ], [ 5, 11 ], 1 ],
#V   n = 25
[ , [ 7, 105 ], [ 6, 4 ], 2, 3, 2, 3, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 
  1 ],
#V   n = 26
[ , 1, 2, 2, 3, [ 0, 16, "Gu" ], 2, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 
  [ 0, 6, "Slo" ], 1, 1, 1, 1 ],
#V   n = 27
[ , [ 7, 111 ], [ 6, 6 ], 2, 2, 3, 2, [ 0, 14, "Slo" ], [ 0, 13, "GuB" ], 1, 
  1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 1 ],
#V   n = 28
[ , [ 6, 3 ], [ 6, 6 ], [ 0, 20, "GH" ], 2, [ 0, 17, "GuB" ], 
  [ 0, 16, "GuB" ], 3, 3, 1, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, [ 5, 13 ], 1, 1 
 ],
#V   n = 29
[ , [ 6, 4 ], 1, 3, 2, 3, 3, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1 ],
#V   n = 30
[ , [ 7, 126 ], 1, 2, [ 0, 20, "Ki" ], 2, 2, 2, [ 0, 15, "Slo" ], 1, 1, 1, 1, 
  1, [ 0, 12, "Q1" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 31
[ , [ 7, 127 ], [ 7, 123 ], [ 0, 22, "GH" ], 3, 2, 2, 2, 3, 1, 2, 1, 1, 1, 3, 
  1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 32
[ , [ 7, 130 ], [ 7, 128 ], 3, 3, [ 0, 20, "Gu" ], [ 0, 19, "Gu" ], 
  [ 0, 17, "GuB" ], 3, 1, 2, 1, 1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 
  [ 5, 15 ], 1, 1 ],
#V   n = 33
[ , [ 6, 3 ], [ 6, 6 ], 2, 2, 3, 3, 3, 2, 1, 2, 1, 1, 1, 3, 1, 
  [ 0, 10, "Ki" ], 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2 ],
#V   n = 34
[ , [ 6, 4 ], [ 6, 13 ], [ 6, 17 ], 2, 2, 3, 2, 2, 1, 2, 1, 1, 1, 3, 1, 3, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, [ 5, 15 ], [ 5, 16 ], 1 ],
#V   n = 35
[ , [ 6, 5 ], [ 6, 14 ], [ 6, 17 ], 2, [ 0, 22, "GuB" ], 2, 2, 2, 1, 
  [ 0, 16, "Ki" ], 2, 1, 1, 3, 1, 1, 1, 2, 1, 1, 1, [ 0, 8, "c" ], 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 36
[ , [ 6, 3 ], [ 6, 15 ], 1, 2, 3, 2, [ 0, 20, "Slo" ], [ 0, 19, "Gu" ], 1, 3, 
  2, 1, 1, 1, 1, 1, 1, 2, 1, 1, [ 5, 13 ], 3, 1, 1, 1, 1, 1, 1, [ 5, 17 ], 1, 
  1 ],
#V   n = 37
[ , [ 6, 4 ], [ 6, 16 ], 1, 2, 2, 2, 3, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 
  2, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 38
[ , [ 6, 4 ], 2, 1, 2, 2, 2, 2, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, [ 0, 12, "Q1" ],
  1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 39
[ , [ 6, 5 ], 2, 1, 2, 2, [ 0, 24, "Gu" ], 2, 2, 1, 2, [ 0, 18, "Ki" ], 1, 2, 
  1, 1, 1, 1, 3, 1, [ 0, 11, "Ki" ], 2, 1, [ 0, 9, "Ki" ], 1, 1, 1, 1, 1, 2, 
  1, 1, 1, 1, 1 ],
#V   n = 40
[ , [ 6, 5 ], 2, 2, [ 0, 28, "Ki" ], 2, 3, 2, [ 0, 21, "Slo" ], 1, 2, 3, 1, 
  2, 1, 1, 1, 1, 1, 1, 3, 2, 1, 3, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2 ],
#V   n = 41
[ , 1, 2, 2, 3, 2, 2, 2, 3, 2, [ 0, 20, "Ki" ], 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 3, 1, 1, 1, 1, 1, [ 0, 7, "Ki" ], 1, 1, 1, 1, 1, [ 0, 4, "IN" ], 1 ],
#V   n = 42
[ , [ 6, 4 ], [ 6, 21 ], 2, 3, [ 0, 28, "GuB" ], 2, 2, 1, 2, 3, 3, 1, 2, 
  [ 5, 12 ], 1, 1, 1, 1, 1, 1, 2, 1, 3, [ 5, 15 ], 1, 1, 1, 2, 3, [ 5, 18 ], 
  1, [ 5, 18 ], 1, 1, 3, [ 5, 19 ], [ 5, 20 ] ],
#V   n = 43
[ , [ 6, 5 ], [ 6, 21 ], 2, 2, 3, [ 0, 27, "Ki" ], [ 0, 26, "Ki" ], 1, 2, 3, 
  3, 1, [ 0, 18, "Ki" ], 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  [ 0, 8, "Ki" ], 3, 1, 1, 1, 1, 1, [ 0, 5, "Ki" ], 1, 1, 1 ],
#V   n = 44
[ , [ 6, 5 ], [ 6, 21 ], [ 0, 32, "GH" ], 2, 3, 3, 3, 2, [ 0, 23, "Slo" ], 
  [ 0, 21, "BZ" ], 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, [ 0, 14, "Q1" ], 1, 1, 1, 1, 
  1, 1, 3, 3, 1, 1, 1, 1, 1, 3, 1, 1, [ 5, 21 ], 1 ],
#V   n = 45
[ , [ 6, 5 ], [ 6, 21 ], 3, [ 0, 31, "Ki" ], 2, [ 0, 28, "Gu" ], 3, 
  [ 0, 24, "BZ" ], 3, 3, [ 0, 20, "BY" ], 2, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1 ],
#V   n = 46
[ , [ 6, 4 ], [ 6, 21 ], 2, 3, 2, 3, 3, 3, 3, 2, 3, 2, 3, 1, 2, 1, 1, 2, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 47
[ , [ 6, 5 ], 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 1, 2, 1, 1, 2, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 48
[ , [ 6, 5 ], [ 6, 21 ], 2, 2, [ 0, 32, "Gu" ], [ 0, 30, "GuB" ], 
  [ 0, 28, "GuB" ], 2, 1, [ 0, 24, "BZ" ], 2, [ 0, 21, "BZ" ], 
  [ 0, 20, "BY" ], 1, [ 0, 18, "BY" ], 1, 1, [ 0, 16, "BZ" ], 1, 1, 3, 1, 1, 
  1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 23 ], [ 5, 23 ], 1, 1 
 ],
#V   n = 49
[ , [ 6, 5 ], [ 6, 21 ], [ 0, 36, "GH" ], 2, 3, 3, 3, 2, 1, 3, 2, 3, 3, 1, 3, 
  1, 1, 3, 1, 2, 3, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  2, 1, 1, 1 ],
#V   n = 50
[ , [ 6, 5 ], [ 6, 8 ], 3, [ 0, 35, "Gu" ], 2, 2, 2, [ 0, 28, "BZ" ], 1, 3, 
  [ 0, 24, "BZ" ], 2, 1, 1, 1, 1, 1, 3, 1, 2, 3, 1, 1, 1, 1, 1, 
  [ 0, 12, "Slo" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 5, "Slo" ], 
  1, 1, 1, 1 ],
#V   n = 51
[ , [ 6, 5 ], [ 6, 9 ], 3, 3, 2, 2, 2, 3, 1, 2, 3, 2, 1, 1, 1, 1, 1, 1, 1, 
  [ 0, 16, "BZ" ], 3, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1 ],
#V   n = 52
[ , [ 6, 5 ], [ 6, 16 ], 2, [ 0, 36, "BCH" ], [ 0, 35, "BCH" ], 
  [ 0, 33, "Gu" ], 2, 2, 1, 2, 3, [ 0, 24, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1 ],
#V   n = 53
[ , [ 6, 5 ], [ 6, 16 ], 2, 3, 3, 3, 2, 2, 2, [ 0, 27, "XB" ], 1, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 54
[ , [ 6, 5 ], [ 6, 21 ], 2, 2, [ 0, 36, "GuB" ], 1, 2, 2, 2, 3, 1, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 14, "Q1" ], 3, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, [ 0, 8, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 55
[ , [ 6, 5 ], [ 6, 13 ], [ 0, 40, "GH" ], [ 0, 38, "GuB" ], 3, 1, 2, 2, 2, 
  [ 0, 28, "BZ" ], 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 56
[ , [ 6, 5 ], [ 6, 14 ], 3, 3, 1, 1, 2, 2, [ 0, 30, "BY" ], 3, 1, 
  [ 0, 27, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  [ 0, 12, "Slo" ], 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 27 ], 
  [ 5, 27 ], 1, 1, 1 ],
#V   n = 57
[ , [ 6, 5 ], [ 6, 15 ], 2, 1, 1, 1, 2, [ 0, 34, "Yi" ], 3, 2, 1, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 58
[ , [ 6, 5 ], [ 6, 16 ], 2, 1, 1, 1, 2, 3, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 59
[ , [ 6, 5 ], 2, 2, 1, 1, 1, 2, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1 ],
#V   n = 60
[ , [ 6, 5 ], 2, 2, 1, 1, 1, 2, [ 0, 36, "BZ" ], [ 0, 33, "BZ" ], 
  [ 0, 32, "BZ" ], 1, [ 0, 30, "BZ" ], 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  2, [ 0, 16, "BY" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 61
[ , [ 6, 5 ], 2, 2, 1, 1, 1, 2, 3, 3, 3, 1, 3, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 62
[ , [ 6, 5 ], 2, 2, 1, 1, 1, 2, 3, 1, 2, 1, 3, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 2, 1, 1, 1, 1 ],
#V   n = 63
[ , [ 6, 5 ], [ 6, 21 ], 2, 2, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 
  1, 1, 2, 1, 1, 1, 2, 3, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  2, 1, 1, 1, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1 ],
#V   n = 64
[ , [ 6, 5 ], [ 6, 21 ], [ 0, 48, "RM" ], 2, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 
  [ 0, 28, "BCH" ], 1, 1, [ 0, 27, "BCH" ], 2, 1, [ 0, 24, "BCH" ], 1, 1, 1, 
  2, 2, 1, 1, 1, 2, [ 0, 15, "BCH" ], 1, 1, [ 0, 14, "BCH" ], 1, 1, 1, 2, 1, 
  [ 0, 11, "BCH" ], 1, 1, 1, 2, 1, 1, 1, 1, [ 0, 7, "BCH" ], 1, 1, 
  [ 0, 6, "BCH" ], [ 5, 31 ], [ 5, 31 ], [ 5, 31 ], 1, 1, 1 ],
#V   n = 65
[ , [ 6, 5 ], [ 6, 21 ], 3, 2, 1, 1, [ 0, 44, "BC" ], 2, 1, [ 0, 36, "BZ" ], 
  2, [ 0, 33, "XB" ], 1, [ 0, 31, "BC" ], 1, 3, 1, 1, 3, [ 0, 25, "BC" ], 1, 
  3, 1, 1, 1, [ 0, 23, "BC" ], [ 0, 18, "BC" ], 1, 2, 1, [ 0, 16, "BY" ], 3, 
  2, 1, 3, 1, 2, 1, [ 0, 12, "BC" ], 1, 3, 1, 1, 1, [ 0, 10, "BC" ], 1, 1, 1, 
  1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 66
[ , [ 6, 5 ], [ 6, 21 ], 3, [ 0, 47, "Gu" ], 2, 1, 3, [ 0, 40, "XB" ], 1, 3, 
  2, 3, 1, 3, 1, 3, 1, 1, 3, 3, 1, 3, 1, 1, 1, 3, 3, 1, [ 0, 17, "BZ" ], 1, 
  3, 3, [ 0, 15, "BZ" ], 1, 3, 1, [ 0, 13, "BZ" ], 1, 3, 1, 3, 1, 1, 1, 3, 1, 
  1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 67
[ , [ 6, 5 ], [ 6, 21 ], 2, 3, 2, 1, 3, 3, 1, 2, 2, 3, 1, 2, 1, 2, 1, 1, 3, 
  3, 1, 3, 2, 1, 1, 3, 1, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 
  3, 1, 2, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 68
[ , [ 6, 5 ], 2, 2, [ 0, 48, "BZ" ], 2, 1, 3, 3, 1, 2, [ 0, 36, "BZ" ], 2, 1, 
  [ 0, 33, "BZ" ], 2, [ 0, 30, "BZ" ], 1, 1, 3, 3, 1, 3, [ 0, 24, "BZ" ], 1, 
  1, 3, 1, 1, 2, 1, 3, 1, 1, 1, 3, 1, 3, 1, 3, 1, [ 0, 12, "BZ" ], 1, 2, 1, 
  3, 1, [ 0, 9, "BZ" ], 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, [ 5, 32 ], [ 5, 33 ], 
  [ 5, 33 ], [ 5, 33 ], 1, 1 ],
#V   n = 69
[ , [ 6, 5 ], [ 6, 21 ], 2, 3, 2, 2, 3, 2, 1, 2, 3, 2, 2, 3, 2, 3, 1, 2, 3, 
  3, 1, 3, 3, 1, 1, 3, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 1, 2, [ 0, 13, "XB" ], 
  1, 3, 1, [ 0, 11, "XB" ], 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 70
[ , [ 6, 5 ], [ 6, 21 ], [ 0, 52, "BZ" ], 1, 2, 2, 3, 2, 1, [ 0, 40, "BZ" ], 
  3, [ 0, 36, "BZ" ], 2, 3, [ 0, 32, "BZ" ], 3, 1, [ 0, 28, "BZ" ], 3, 3, 2, 
  3, 3, 1, 1, 3, 1, 1, [ 0, 20, "BY" ], 1, [ 0, 18, "BY" ], 1, [ 5, 23 ], 1, 
  [ 0, 16, "BY" ], 1, 1, [ 0, 14, "BZ" ], 3, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 71
[ , [ 6, 5 ], 1, 3, 1, 2, 2, 3, 2, 1, 3, 1, 3, 2, 3, 3, 3, 1, 3, 3, 1, 2, 3, 
  3, 1, 1, 3, 2, 1, 3, 1, 3, 1, 2, 1, 3, 1, 1, 3, 3, 1, 3, 1, 1, 1, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 72
[ , [ 6, 5 ], 1, 2, 1, 2, [ 0, 47, "Slo" ], 2, [ 0, 44, "XB" ], 1, 2, 1, 2, 
  [ 0, 36, "BZ" ], 1, 2, 1, 1, 2, [ 0, 28, "BY" ], 1, [ 0, 26, "BY" ], 3, 3, 
  1, 1, 3, 2, 1, 3, 1, 1, 1, 2, 1, 3, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, [ 5, 30 ], [ 5, 30 ], 1, 1, [ 0, 8, "BZ" ], 1, 1, 1, 1, 1, 1, 
  [ 5, 35 ], [ 5, 35 ], [ 5, 35 ], 1, 1, 1 ],
#V   n = 73
[ , [ 6, 5 ], 1, 2, 1, 2, 3, 2, 3, 1, 2, 1, 2, 3, 1, 2, 1, 1, 2, 3, 1, 3, 1, 
  3, 1, 1, 3, 2, 1, 3, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 74
[ , [ 6, 5 ], 1, 2, 1, 2, 2, 2, 3, 1, 2, 1, 2, 3, 1, 2, 1, 1, 2, 2, 1, 2, 1, 
  1, 2, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 75
[ , [ 6, 5 ], [ 6, 21 ], [ 0, 56, "BZ" ], 1, 2, 2, [ 0, 48, "BZ" ], 1, 1, 
  [ 0, 44, "BZ" ], 1, [ 0, 40, "BZ" ], 3, 1, [ 0, 36, "BZ" ], 1, 1, 
  [ 0, 32, "BZ" ], [ 0, 30, "BZ" ], 1, [ 0, 28, "BY" ], 1, 1, 2, 1, 1, 
  [ 0, 24, "BY" ], 1, [ 0, 22, "BY" ], 1, 1, 1, [ 0, 20, "BY" ], 1, 
  [ 0, 18, "BY" ], 1, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 76
[ , [ 6, 5 ], 1, 3, 1, 2, 2, 3, 1, 1, 3, 1, 3, 1, 2, 3, 1, 1, 3, 3, 1, 3, 1, 
  1, [ 0, 26, "XB" ], 2, 1, 3, 1, 3, 1, 2, 1, 3, 1, 3, 1, [ 0, 17, "BZ" ], 1, 
  1, 1, 1, 1, [ 0, 14, "BZ" ], 1, [ 0, 13, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 37 ], [ 5, 37 ], 1, 1, 1, 1 ],
#V   n = 77
[ , [ 6, 5 ], 1, 2, 1, 2, 2, 2, 1, 1, 2, 1, 2, 1, 2, 3, 1, 1, 2, 1, 1, 2, 1, 
  1, 3, 2, 1, 3, 1, 1, 1, 2, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 3, 2, 3, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 78
[ , [ 6, 5 ], 1, 2, 1, [ 0, 56, "Hi" ], [ 0, 52, "Gu" ], 2, 1, 1, 2, 1, 2, 1, 
  2, 3, 1, 1, 2, 1, 1, 2, 2, 1, 1, 2, 1, 3, 1, 1, 1, 2, 1, 3, 1, 1, 1, 2, 1, 
  2, 1, 1, 1, 1, 2, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 79
[ , [ 6, 5 ], 1, 2, 1, 3, 3, 2, 1, 1, 2, 1, 2, 1, 2, 3, 1, 1, 2, 1, 1, 2, 2, 
  1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 1, 
  [ 0, 13, "XB" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 80
[ , [ 6, 5 ], 2, [ 0, 60, "BZ" ], [ 6, 40 ], 3, 3, [ 0, 52, "BZ" ], 1, 1, 
  [ 0, 48, "BZ" ], 1, [ 0, 44, "BZ" ], 1, [ 0, 40, "BZ" ], 3, 1, 1, 
  [ 0, 36, "BZ" ], 1, 1, [ 0, 32, "BZ" ], [ 0, 30, "BZ" ], 1, 1, 
  [ 0, 28, "BY" ], 1, [ 0, 26, "BY" ], 1, 1, 1, [ 0, 24, "BY" ], 1, 
  [ 0, 22, "BY" ], 1, 1, 1, [ 0, 20, "BY" ], 1, [ 0, 18, "BY" ], 1, 1, 1, 1, 
  [ 0, 16, "BZ" ], 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, [ 5, 39 ], [ 5, 39 ], 1, 1, 1, 1 ],
#V   n = 81
[ , [ 6, 5 ], 2, 3, 1, 3, 1, 3, 1, 1, 3, 1, 3, 1, 3, 1, 2, 1, 3, 1, 1, 3, 3, 
  1, 1, 3, 1, 3, 1, 2, 1, 3, 1, 3, 1, 2, 1, 3, 1, 3, 1, 2, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 2, 1 ],
#V   n = 82
[ , [ 6, 5 ], 2, 2, 1, 2, 1, 2, 1, 1, 3, 1, 2, 1, 2, 1, 2, 2, 3, 1, 1, 2, 1, 
  1, 1, 3, 1, 1, 1, 2, 1, 3, 1, 1, 1, 2, 1, 3, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 36 ], 1, 1, 1, 1, 
  1, 1, [ 5, 37 ], [ 5, 38 ], [ 5, 39 ], [ 5, 40 ], 1, 1 ],
#V   n = 83
[ , [ 6, 5 ], 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 2, 3, 1, 1, 2, 2, 
  1, 1, 2, 1, 1, 1, 2, 1, 3, 1, 1, 1, 2, 1, 3, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 
  2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 2, 1, 1 ],
#V   n = 84
[ , [ 6, 5 ], [ 6, 21 ], 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 2, 3, 1, 
  1, 2, 2, 2, 1, 2, 2, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 1, 3, 
  1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 1, 
  [ 5, 38 ], 1, 1, 1, 2, 1, [ 5, 41 ], [ 5, 41 ], [ 5, 41 ], [ 5, 41 ], 
  [ 5, 41 ], 1 ],
#V   n = 85
[ , [ 6, 5 ], [ 6, 21 ], [ 0, 64, "La" ], 1, [ 0, 60, "BC" ], 1, 
  [ 0, 56, "BZ" ], 1, 1, 2, 1, [ 0, 48, "BZ" ], 1, [ 0, 44, "BZ" ], 1, 
  [ 0, 40, "BZ" ], [ 0, 39, "BZ" ], 3, 1, 1, [ 0, 36, "BZ" ], [ 0, 33, "BZ" ],
  [ 0, 32, "BZ" ], 1, [ 0, 31, "BC" ], 2, 1, 1, [ 0, 28, "BZ" ], 1, 
  [ 0, 26, "BZ" ], 1, 1, 1, [ 0, 24, "BZ" ], 1, [ 0, 22, "BZ" ], 1, 1, 1, 
  [ 0, 20, "BZ" ], 1, 1, 2, 1, 1, 1, [ 0, 16, "BZ" ], 1, 1, 1, 2, 1, 1, 1, 1, 
  [ 0, 12, "BZ" ], [ 0, 11, "BC" ], 1, 1, 1, [ 0, 10, "BC" ], [ 0, 9, "BZ" ], 
  1, 1, 1, 1, 1, 1, 1, 1, [ 0, 6, "BC" ], 1, [ 0, 5, "BZ" ], 1, 1, 1, 1, 1, 
  [ 0, 3, "HM" ] ],
#V   n = 86
[ , [ 6, 5 ], [ 6, 21 ], 3, 1, 3, 2, 3, 1, 1, [ 0, 52, "XB" ], 1, 3, 2, 3, 1, 
  3, 3, 2, 1, 1, 3, 3, 3, 2, 3, [ 0, 30, "BCH" ], 2, 1, 3, 1, 3, 1, 1, 1, 3, 
  1, 3, 1, 1, 1, 3, 1, 1, [ 0, 18, "XB" ], 1, 1, 1, 3, 1, 1, 1, 
  [ 0, 14, "BCH" ], 1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 3, [ 5, 36 ], 1, 1, 1, 1, 
  1, 1, 1, 3, 1, 3, [ 5, 40 ], [ 5, 41 ], [ 5, 42 ], 1, 1, 3 ],
#V   n = 87
[ , [ 6, 5 ], [ 6, 21 ], 3, 1, 2, 2, 3, 1, 1, 3, 1, 3, 2, 3, 1, 2, 3, 2, 1, 
  1, 3, 3, 3, [ 0, 32, "XB" ], 3, 3, 2, 1, 3, 1, 3, 1, 1, 1, 3, 1, 3, 1, 1, 
  1, 3, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 3, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 3, 1, 3, [ 0, 5, "XB" ], 1, 1, 1, 1, 3, 1 ],
#V   n = 88
[ , [ 6, 5 ], [ 6, 21 ], 3, 1, 2, 2, 3, 1, 1, 3, 1, 3, 2, 3, 1, 
  [ 0, 42, "BZ" ], 3, [ 0, 39, "BZ" ], 1, 1, 3, 3, [ 0, 33, "BZ" ], 3, 3, 3, 
  [ 0, 30, "BZ" ], 1, 3, 1, 3, 1, 2, 1, 3, 1, 3, 1, 2, 1, 3, 1, 1, 3, 1, 2, 
  1, 3, 1, 1, [ 5, 30 ], 3, 1, 2, 1, 1, 3, 1, 1, 1, 1, 3, 3, [ 5, 36 ], 1, 1, 
  1, 1, 1, 1, 1, 3, [ 5, 40 ], 3, 3, [ 5, 43 ], [ 5, 43 ], [ 5, 43 ], 1, 1, 
  [ 5, 43 ], [ 5, 43 ] ],
#V   n = 89
[ , [ 6, 5 ], 2, [ 6, 4 ], 1, 2, 2, 2, 1, 1, 3, 1, 3, 2, 2, 1, 3, 1, 3, 1, 2, 
  3, 1, 3, 3, 3, 3, 3, 1, 3, 1, 2, 1, 2, 1, 3, 1, 2, 1, 2, 1, 3, 1, 1, 2, 1, 
  2, 1, 3, 1, 1, 1, 3, 1, 2, 1, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 90
[ , [ 6, 5 ], [ 6, 21 ], [ 6, 5 ], 1, [ 0, 64, "BZ" ], 2, [ 0, 58, "XB" ], 1, 
  1, 2, 1, 2, [ 0, 48, "BZ" ], [ 0, 46, "XB" ], 1, 2, 1, 2, 1, 2, 3, 1, 2, 3, 
  1, 1, 3, 1, 1, 2, [ 0, 28, "XB" ], 1, [ 0, 26, "XB" ], 1, 3, 1, 
  [ 0, 24, "BY" ], 1, [ 0, 22, "BY" ], 1, 3, 1, 1, [ 0, 20, "BY" ], 1, 
  [ 0, 18, "BY" ], 1, 3, 1, 1, 1, 1, 1, [ 0, 14, "BZ" ], 1, 1, 3, 1, 1, 1, 1, 
  3, 3, [ 5, 36 ], 1, 1, 1, 1, 1, 1, 1, [ 0, 8, "BZ" ], 1, [ 5, 41 ], 
  [ 5, 41 ], [ 5, 41 ], [ 5, 41 ], [ 5, 43 ], [ 5, 44 ], 1, 1, 1, 1, 
  [ 5, 44 ] ],
#V   n = 91
[ , [ 6, 5 ], [ 6, 21 ], 2, 2, 3, [ 0, 61, "Gu" ], 3, 1, 1, [ 0, 54, "XB" ], 
  1, [ 0, 50, "XB" ], 3, 3, 1, 2, 1, 2, 1, 2, 3, 1, 2, 1, 2, 1, 2, 1, 1, 2, 
  3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 1, 3, 1, 3, 1, 3, 1, 1, 1, 1, 1, 3, 1, 
  1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1 ],
#V   n = 92
[ , [ 6, 5 ], [ 6, 8 ], [ 6, 17 ], 2, 3, 3, 2, 1, 1, 3, 1, 3, 3, 2, 1, 
  [ 0, 45, "BZ" ], 1, [ 0, 42, "BZ" ], 1, [ 0, 39, "BZ" ], 2, 1, 
  [ 0, 36, "BZ" ], 1, 2, 1, [ 0, 32, "BZ" ], 1, 1, [ 0, 30, "BZ" ], 3, 1, 3, 
  1, 3, 1, 3, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, [ 5, 42 ], [ 5, 42 ], 
  [ 5, 42 ], [ 5, 42 ], [ 5, 45 ], [ 5, 45 ], 1, 1, 1, 1, [ 5, 45 ] ],
#V   n = 93
[ , [ 6, 5 ], [ 6, 9 ], [ 6, 8 ], 2, 3, 3, [ 0, 60, "XB" ], 1, 1, 2, 1, 2, 3, 
  [ 0, 48, "XB" ], 1, 3, 1, 3, 1, 3, [ 0, 38, "BY" ], 2, 3, 1, 
  [ 0, 34, "BY" ], 1, 3, 1, 1, 3, 3, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 2, 1, 3, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 3, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1 ],
#V   n = 94
[ , [ 6, 5 ], [ 6, 15 ], 2, 2, 3, 2, 3, 1, 1, [ 0, 56, "XB" ], 2, 
  [ 0, 52, "XB" ], 2, 3, 1, 2, 1, 2, 1, 2, 3, 2, 3, 1, 3, 1, 3, 1, 1, 3, 1, 
  2, 1, 1, 2, 1, 3, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 
  2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, [ 5, 43 ], 
  [ 5, 43 ], [ 5, 43 ], [ 5, 43 ], 1, 1, 1, 1, 1, 1, [ 5, 46 ] ],
#V   n = 95
[ , [ 6, 5 ], [ 6, 16 ], [ 6, 31 ], [ 0, 68, "Slo" ], 2, 2, 3, 1, 1, 3, 2, 3, 
  2, 3, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 
  1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  2, 1 ],
#V   n = 96
[ , [ 6, 5 ], [ 6, 21 ], 2, 3, [ 6, 18 ], [ 0, 64, "Slo" ], [ 0, 61, "GuB" ], 
  1, 1, 3, [ 0, 54, "BZ" ], 3, [ 0, 51, "BZ" ], 3, 1, [ 0, 48, "BZ" ], 1, 
  [ 0, 45, "BZ" ], 2, [ 0, 42, "BZ" ], [ 0, 40, "BY" ], [ 0, 39, "BY" ], 
  [ 0, 38, "BY" ], 1, [ 0, 36, "BY" ], 1, [ 0, 34, "BY" ], [ 0, 33, "BZ" ], 
  1, [ 0, 32, "BZ" ], 1, [ 0, 30, "BZ" ], 1, 1, [ 0, 28, "BY" ], 1, 
  [ 0, 26, "BY" ], 1, 1, 1, 1, [ 0, 24, "BY" ], 1, [ 0, 22, "BY" ], 1, 1, 1, 
  1, [ 0, 20, "BY" ], 1, [ 0, 18, "BY" ], 1, 1, 1, 1, 1, [ 0, 16, "BZ" ], 1, 
  [ 0, 14, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 42 ], 1, 3, 1, 1, 1, 1, 
  1, 1, 1, [ 5, 44 ], [ 5, 44 ], [ 5, 44 ], [ 5, 44 ], [ 5, 47 ], [ 5, 47 ], 
  [ 5, 47 ], [ 5, 47 ], [ 5, 47 ], [ 5, 47 ], [ 5, 47 ] ],
#V   n = 97
[ , [ 6, 5 ], [ 6, 13 ], [ 6, 17 ], 2, 2, 3, 3, 1, 1, 2, 3, 2, 3, 2, 1, 3, 1, 
  3, 2, 3, 3, 3, 3, 1, 3, 1, 3, 3, 1, 3, 1, 3, 1, 2, 3, 1, 3, 1, 1, 1, 1, 3, 
  1, 3, 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 98
[ , [ 6, 5 ], [ 6, 14 ], [ 6, 17 ], 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 3, 1, 
  2, 2, 2, 1, 2, 2, 1, 2, 1, 1, 2, 1, 3, 1, 2, 1, 2, 3, 1, 1, 1, 1, 2, 1, 3, 
  1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 45 ], [ 5, 45 ], [ 5, 45 ], 
  [ 5, 45 ], 1, 1, 1, 1, [ 5, 48 ], [ 5, 48 ], [ 5, 48 ] ],
#V   n = 99
[ , [ 6, 5 ], [ 6, 15 ], 2, 2, [ 0, 69, "Gu" ], 2, 2, 1, 1, 2, 2, 2, 2, 2, 1, 
  2, 1, 2, 2, 2, 1, 2, [ 0, 40, "BZ" ], 1, 2, 1, 1, 2, 1, 2, 2, 
  [ 0, 32, "BZ" ], 1, [ 0, 30, "BZ" ], 3, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 2, 
  1, 3, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 2, [ 0, 13, "BZ" ], 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 
  1 ],
#V   n = 100
[ , [ 6, 5 ], [ 6, 16 ], 2, [ 0, 72, "Slo" ], 3, 2, [ 0, 64, "BZ" ], 1, 1, 
  [ 0, 60, "BZ" ], [ 0, 57, "BZ" ], [ 0, 56, "BZ" ], [ 0, 54, "BZ" ], 
  [ 0, 52, "BZ" ], 1, 2, 1, [ 0, 48, "BZ" ], 2, [ 0, 45, "BZ" ], 2, 
  [ 0, 42, "BZ" ], 3, 1, [ 0, 39, "BZ" ], 1, 1, [ 0, 36, "BZ" ], 1, 
  [ 0, 34, "XB" ], [ 0, 33, "BZ" ], 3, 2, 3, 3, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 
  1, 2, 1, 3, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 
  1, 2, [ 5, 42 ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 46 ], [ 5, 46 ], 
  [ 5, 46 ], [ 5, 46 ], [ 5, 47 ], [ 5, 48 ], [ 5, 49 ], 1, [ 5, 49 ], 
  [ 5, 49 ], [ 5, 49 ] ],
#V   n = 101
[ , [ 6, 5 ], 2, 2, 3, 3, 2, 3, 1, 1, 3, 3, 3, 3, 3, 1, [ 0, 51, "XB" ], 1, 
  3, 2, 3, 2, 3, 3, 2, 3, 1, 1, 3, 1, 3, 3, 3, 2, 3, 2, 1, 1, 1, 1, 2, 1, 2, 
  1, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 
  1, 2, 1 ],
#V   n = 102
[ , [ 6, 5 ], 2, [ 0, 76, "GH" ], 2, [ 6, 12 ], 2, 2, 1, 1, 3, 1, 2, 3, 2, 1, 
  3, 1, 3, [ 0, 48, "BZ" ], 3, [ 0, 44, "BZ" ], 3, 3, [ 0, 40, "BZ" ], 3, 1, 
  2, 3, 1, 3, 3, 3, [ 0, 32, "BY" ], 3, [ 0, 30, "BZ" ], 1, 1, 1, 1, 
  [ 0, 28, "BZ" ], 1, [ 0, 26, "BZ" ], 1, 1, 1, 1, [ 0, 24, "BZ" ], 1, 
  [ 0, 22, "BZ" ], 1, 1, 1, 1, [ 0, 20, "BZ" ], 1, 1, 2, 1, 1, 1, 1, 
  [ 0, 16, "BZ" ], 3, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 12, "BZ" ], 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, [ 5, 47 ], [ 5, 47 ], [ 5, 47 ], [ 5, 48 ], 
  [ 5, 49 ], [ 5, 50 ], 1, 1, [ 5, 50 ], [ 5, 50 ], [ 5, 50 ] ],
#V   n = 103
[ , [ 6, 5 ], 2, 3, 2, 2, 2, 2, 1, 1, 2, 1, 2, 1, 2, 1, 3, 1, 3, 3, 2, 3, 3, 
  2, 3, 3, 1, 2, 3, 1, 3, 3, 3, 3, 1, 3, 1, 1, 1, 1, 3, 2, 3, 2, 1, 1, 1, 3, 
  1, 3, 1, 1, 1, 1, 3, 1, 1, [ 0, 18, "XB" ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 
  1, 1, 1, 2, 1 ],
#V   n = 104
[ , [ 6, 5 ], 2, 3, 2, [ 6, 26 ], [ 0, 71, "Gu" ], 2, 1, 1, 2, 1, 2, 1, 2, 1, 
  3, 1, 3, 3, 2, 3, 2, [ 0, 42, "XB" ], 3, [ 0, 40, "XB" ], 2, 
  [ 0, 38, "XB" ], 3, 1, 2, 1, 2, 3, 1, 1, 1, 1, 2, 1, 3, 2, 3, 2, 1, 1, 1, 
  3, 1, 3, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 48 ], [ 5, 48 ], 
  [ 5, 48 ], [ 5, 51 ], [ 5, 51 ], [ 5, 51 ], 1, 1, [ 5, 51 ], [ 5, 51 ], 
  [ 5, 51 ] ],
#V   n = 105
[ , [ 6, 5 ], [ 6, 21 ], 2, 2, [ 0, 73, "Gu" ], 3, [ 0, 68, "BZ" ], 1, 1, 2, 
  1, [ 0, 60, "BZ" ], 1, [ 0, 56, "BZ" ], 1, 2, 1, 2, 3, [ 0, 48, "BZ" ], 1, 
  2, 3, 2, 3, [ 0, 39, "BZ" ], 3, 3, 1, [ 0, 36, "XB" ], 1, [ 0, 34, "BZ" ], 
  3, 1, 1, 1, 1, 2, 1, 3, [ 0, 28, "BY" ], 3, [ 0, 26, "BY" ], 1, 1, 1, 3, 1, 
  3, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 
  1 ],
#V   n = 106
[ , [ 6, 5 ], [ 6, 21 ], [ 6, 31 ], 2, 3, 3, 3, 1, 2, [ 0, 64, "XB" ], 1, 3, 
  1, 3, 1, 2, 1, 2, 3, 3, 1, [ 0, 45, "XB" ], 3, [ 0, 42, "XB" ], 3, 3, 3, 2, 
  2, 3, 1, 3, 1, 2, 1, 1, 1, 2, 2, 3, 3, 1, 3, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 
  3, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, [ 5, 49 ], [ 5, 49 ], [ 5, 49 ], 
  [ 5, 52 ], 1, 1, 1, 1, [ 5, 52 ], [ 5, 52 ], [ 5, 52 ] ],
#V   n = 107
[ , [ 6, 5 ], [ 6, 21 ], 2, 2, 2, 3, 2, 1, 2, 3, 1, 2, 1, 2, 1, 
  [ 0, 54, "XB" ], 2, [ 0, 51, "XB" ], 3, 3, 1, 3, 1, 3, 2, 1, 2, 2, 2, 3, 1, 
  2, 1, 2, 1, 1, 1, 2, 2, 3, 3, 1, 1, 1, 2, 1, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 108
[ , [ 6, 5 ], [ 6, 21 ], [ 6, 28 ], 2, 2, 2, [ 6, 43 ], 1, 2, 3, 1, 2, 1, 2, 
  1, 3, [ 0, 52, "BZ" ], 3, 2, 3, 1, 2, 1, 1, 2, 1, [ 0, 40, "BY" ], 
  [ 0, 39, "BZ" ], [ 0, 38, "BY" ], 3, 1, [ 0, 36, "BZ" ], 1, [ 0, 34, "BZ" ],
  1, 1, 1, [ 0, 32, "BZ" ], 2, 1, 3, 1, 1, 1, 2, 1, 1, 1, 1, [ 0, 24, "BY" ], 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, [ 5, 43 ], [ 5, 44 ], 1, 1, 1, 1, 1, 1, [ 0, 8, "BZ" ], 1, 
  [ 5, 50 ], [ 5, 50 ], [ 5, 50 ], [ 5, 50 ], [ 5, 53 ], [ 5, 53 ], 1, 1, 1, 
  [ 5, 53 ], [ 5, 53 ], [ 5, 53 ] ],
#V   n = 109
[ , [ 6, 5 ], [ 6, 21 ], [ 6, 17 ], [ 0, 80, "AEB" ], 2, 2, 2, 1, 2, 2, 1, 2, 
  1, 2, 1, 2, 3, 3, 2, 3, 1, 2, 1, 1, 2, 1, 3, 3, 3, 1, 2, 3, 1, 3, 1, 2, 1, 
  3, 2, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 110
[ , [ 6, 5 ], 2, 2, 3, [ 0, 77, "Gu" ], [ 0, 74, "Gu" ], [ 0, 72, "BZ" ], 1, 
  [ 0, 68, "BZ" ], 2, 1, [ 0, 64, "BZ" ], 1, [ 0, 60, "BZ" ], 1, 
  [ 0, 56, "BZ" ], 1, 2, [ 0, 51, "BZ" ], 2, 1, [ 0, 48, "BZ" ], 1, 1, 
  [ 0, 44, "BZ" ], 1, 2, 1, 2, 1, 2, 3, 1, 2, 1, 2, 1, 3, [ 0, 32, "BY" ], 1, 
  [ 0, 30, "BY" ], 1, 1, 1, [ 0, 28, "BY" ], 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 3, [ 5, 49 ], 1, 1, [ 5, 51 ], [ 5, 51 ], [ 5, 51 ], 
  [ 5, 51 ], 1, 1, 1, 1, 1, [ 5, 54 ], [ 5, 54 ], [ 5, 54 ] ],
#V   n = 111
[ , [ 6, 5 ], [ 6, 21 ], [ 6, 31 ], 3, 3, 3, 3, 1, 3, 2, 1, 3, 1, 3, 1, 3, 1, 
  2, 3, 2, 2, 3, 1, 1, 3, 1, [ 0, 42, "BY" ], 2, [ 0, 40, "BY" ], 1, 2, 1, 1, 
  [ 0, 36, "BZ" ], 1, [ 0, 34, "BZ" ], 2, 3, 3, 1, 3, 1, 2, 1, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 
  1, 1, 1, 1, 2, 1 ],
#V   n = 112
[ , [ 6, 5 ], [ 6, 21 ], 2, 2, 2, 2, 2, 1, 2, [ 0, 68, "XB" ], 1, 2, 1, 2, 1, 
  2, 1, [ 0, 54, "BZ" ], 3, [ 0, 51, "BZ" ], 2, 3, 1, 1, 2, 1, 3, 2, 3, 1, 
  [ 0, 39, "BZ" ], 1, 1, 3, 1, 3, 2, 3, 3, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, [ 5, 47 ], [ 5, 48 ], [ 5, 49 ], 1, 3, 1, 1, 
  [ 5, 50 ], 1, 1, [ 5, 52 ], [ 5, 52 ], [ 5, 52 ], [ 5, 52 ], [ 5, 55 ], 
  [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], [ 5, 55 ] 
 ],
#V   n = 113
[ , [ 6, 5 ], [ 6, 8 ], [ 6, 28 ], 2, 2, 2, 2, 1, 2, 3, 1, 2, 1, 2, 1, 2, 1, 
  3, 1, 3, 2, 3, 1, 1, 2, 1, 1, 2, 2, 1, 3, 1, 1, 2, 1, 1, 2, 1, 3, 1, 1, 1, 
  2, 1, 3, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 114
[ , [ 6, 5 ], [ 6, 9 ], [ 6, 17 ], 2, 2, 2, 2, 1, 2, 3, 1, 2, 1, 2, 1, 2, 1, 
  2, 1, 2, 2, 2, 1, 1, 2, 1, 1, 2, [ 0, 42, "BZ" ], 2, [ 0, 40, "BZ" ], 2, 1, 
  [ 0, 38, "BZ" ], 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, [ 5, 51 ], [ 5, 51 ], 1, 1, [ 5, 51 ], 1, 
  1, [ 5, 53 ], [ 5, 53 ], [ 5, 53 ], [ 5, 53 ], 1, 1, 1, 1, 1, [ 5, 56 ], 
  [ 5, 56 ], [ 5, 56 ] ],
#V   n = 115
[ , [ 6, 5 ], [ 6, 16 ], 2, [ 0, 84, "Gu" ], 2, 2, [ 0, 76, "BZ" ], 1, 
  [ 0, 72, "BZ" ], 1, 1, [ 0, 68, "BZ" ], 1, [ 0, 64, "BZ" ], 1, 
  [ 0, 60, "BZ" ], 1, 2, 1, 2, [ 0, 52, "BZ" ], 2, 1, 1, [ 0, 48, "BZ" ], 1, 
  1, [ 0, 44, "BZ" ], 3, 2, 3, 2, 2, 3, 1, 1, [ 0, 36, "BY" ], 1, 
  [ 0, 34, "BY" ], 1, 1, 1, [ 0, 32, "BY" ], 1, [ 0, 30, "BY" ], 1, 1, 1, 
  [ 0, 28, "BY" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 116
[ , [ 6, 5 ], [ 6, 16 ], [ 6, 31 ], 3, 2, 2, 3, 1, 3, 1, 1, 3, 1, 3, 1, 3, 1, 
  [ 0, 57, "BZ" ], 1, [ 0, 54, "BZ" ], 3, [ 0, 51, "BZ" ], 2, 1, 3, 1, 1, 3, 
  3, [ 0, 42, "BZ" ], 3, [ 0, 40, "XB" ], [ 0, 39, "BZ" ], 3, 2, 1, 3, 1, 3, 
  1, 2, 1, 3, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 
  [ 5, 52 ], [ 5, 52 ], [ 5, 52 ], [ 5, 52 ], 1, 1, [ 5, 52 ], 1, 1, 
  [ 5, 54 ], [ 5, 54 ], [ 5, 54 ], [ 5, 54 ], 1, 1, 1, 1, 1, [ 5, 57 ], 
  [ 5, 57 ], [ 5, 57 ] ],
#V   n = 117
[ , [ 6, 5 ], [ 6, 21 ], 2, 2, 2, [ 0, 80, "Gu" ], 2, 1, 2, 1, 1, 2, 1, 2, 1, 
  2, 1, 3, 1, 3, 2, 3, 2, 2, 3, 1, 1, 2, 3, 3, 1, 3, 3, 3, 2, 2, 3, 1, 1, 1, 
  2, 1, 3, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 118
[ , [ 6, 5 ], [ 6, 13 ], [ 0, 88, "GH" ], 2, 2, 3, 2, 1, 2, 1, 1, 2, 1, 2, 1, 
  2, 1, 2, 1, 2, 2, 2, 2, 2, 3, 1, 1, 2, 2, 3, 1, 1, 2, 1, 2, 2, 3, 1, 1, 1, 
  2, 1, 3, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  [ 5, 50 ], [ 5, 53 ], [ 5, 53 ], [ 5, 53 ], [ 5, 53 ], [ 5, 53 ], 1, 1, 
  [ 5, 53 ], 1, 1, [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], 1, 1, 1, 1, 1, 
  [ 5, 58 ], [ 5, 58 ], [ 5, 58 ] ],
#V   n = 119
[ , [ 6, 5 ], [ 6, 14 ], 3, 2, 2, 3, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 
  2, 2, 2, 2, 2, 3, 1, 1, 2, 2, 2, 1, 1, 2, 1, 2, 2, 2, 1, 1, 1, 2, 1, 2, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 120
[ , [ 6, 5 ], [ 6, 15 ], 2, [ 0, 88, "Gu" ], [ 0, 86, "Gu" ], 
  [ 0, 81, "Slo" ], [ 0, 80, "BZ" ], 1, [ 0, 76, "BZ" ], 1, 1, 
  [ 0, 72, "BZ" ], 1, [ 0, 68, "BZ" ], 1, [ 0, 64, "BZ" ], 1, [ 0, 60, "BZ" ],
  1, [ 0, 57, "BZ" ], [ 0, 56, "BZ" ], [ 0, 54, "BZ" ], [ 0, 52, "BZ" ], 
  [ 0, 51, "BZ" ], 3, 1, 1, [ 0, 48, "BZ" ], [ 0, 45, "BY" ], [ 0, 44, "BZ" ],
  1, 1, [ 0, 42, "BZ" ], 1, [ 0, 40, "BY" ], [ 0, 39, "BZ" ], [ 0, 38, "BY" ],
  1, 1, 1, [ 0, 36, "BY" ], 1, [ 0, 34, "BY" ], 1, 1, 1, [ 0, 32, "BY" ], 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, [ 0, 12, "BZ" ], 1, [ 5, 51 ], 
  [ 5, 51 ], [ 5, 54 ], [ 5, 54 ], [ 5, 54 ], [ 5, 54 ], [ 5, 54 ], 1, 1, 
  [ 5, 54 ], 1, 1, [ 5, 56 ], [ 5, 56 ], [ 5, 56 ], [ 5, 56 ], [ 5, 59 ], 1, 
  1, 1, 1, [ 5, 59 ], [ 5, 59 ], [ 5, 59 ] ],
#V   n = 121
[ , [ 6, 5 ], [ 6, 16 ], 2, 3, 3, 3, 3, 1, 3, 1, 1, 3, 1, 3, 1, 3, 1, 3, 1, 
  3, 3, 3, 3, 3, 1, 2, 1, 3, 3, 3, 1, 2, 3, 1, 3, 3, 3, 1, 2, 1, 3, 1, 3, 1, 
  2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 2, 2, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 122
[ , [ 6, 5 ], 2, 2, 3, 3, 1, 2, 1, 2, 1, 1, 3, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 
  2, 2, 1, 2, 2, 3, 1, 2, 1, 2, 3, 1, 3, 1, 1, 1, 2, 1, 3, 1, 1, 1, 2, 1, 3, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 2, [ 5, 52 ], 
  [ 5, 52 ], [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], [ 5, 55 ], 1, 1, 
  [ 5, 55 ], 1, 1, [ 5, 57 ], [ 5, 57 ], [ 5, 57 ], [ 5, 57 ], 1, 1, 1, 1, 1, 
  [ 5, 60 ], [ 5, 60 ], [ 5, 60 ] ],
#V   n = 123
[ , [ 6, 5 ], 2, [ 0, 92, "GH" ], 2, 3, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 
  2, 1, 1, 2, 2, 2, 2, 1, 2, 2, 3, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 2, 1, 3, 1, 
  1, 1, 2, 1, 3, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 2, 
  1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 124
[ , [ 6, 5 ], 2, 3, 2, 2, 1, 2, 1, 2, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 
  [ 0, 57, "BZ" ], 2, [ 0, 54, "BZ" ], 1, 2, 2, 3, 1, 2, 1, [ 0, 45, "BZ" ], 
  [ 0, 44, "BZ" ], 1, [ 0, 42, "BZ" ], 1, 1, 1, 2, 1, 2, 1, 1, 1, 2, 1, 2, 1, 
  1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, [ 0, 12, "BZ" ], 1, 
  [ 5, 53 ], [ 5, 53 ], [ 5, 53 ], [ 5, 56 ], [ 5, 56 ], [ 5, 56 ], 
  [ 5, 56 ], [ 5, 56 ], 1, 1, [ 5, 56 ], 1, 1, [ 5, 58 ], [ 5, 58 ], 
  [ 5, 58 ], [ 5, 58 ], 1, 1, 1, 1, 1, [ 5, 61 ], [ 5, 61 ], [ 5, 61 ] ],
#V   n = 125
[ , [ 6, 5 ], 2, 2, [ 0, 91, "Gu" ], [ 0, 88, "BZ" ], [ 6, 61 ], 
  [ 0, 84, "BZ" ], 1, [ 0, 80, "BZ" ], 1, 1, 2, 1, [ 0, 72, "BZ" ], 1, 
  [ 0, 68, "BZ" ], 1, [ 0, 64, "BZ" ], 1, 2, [ 0, 60, "BZ" ], 3, 
  [ 0, 56, "BZ" ], 3, 1, [ 0, 52, "BZ" ], [ 0, 51, "BZ" ], 3, 1, 
  [ 0, 48, "BZ" ], 1, 3, 3, 2, 3, 1, 1, 1, [ 0, 40, "BZ" ], 1, 
  [ 0, 38, "BZ" ], 1, 1, 1, [ 0, 36, "BZ" ], 1, [ 0, 34, "BZ" ], 1, 1, 1, 
  [ 0, 32, "BZ" ], 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 1, 1, 1, 
  1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1 ],
#V   n = 126
[ , [ 6, 5 ], [ 6, 21 ], 2, 3, 3, [ 6, 62 ], 3, 1, 3, 1, 1, [ 0, 76, "XB" ], 
  1, 3, 1, 3, 2, 3, 1, 2, 3, 2, 3, 2, 1, 3, 3, 2, 2, 3, 1, 2, 3, 2, 3, 1, 2, 
  1, 3, 1, 3, 1, 1, 1, 3, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 3, 1, 1, 3, 1, 1, 2, [ 5, 54 ], [ 5, 54 ], [ 5, 54 ], [ 5, 57 ], 
  [ 5, 57 ], [ 5, 57 ], [ 5, 57 ], [ 5, 57 ], 1, 1, [ 5, 57 ], 1, 1, 
  [ 5, 59 ], [ 5, 59 ], [ 5, 59 ], [ 5, 59 ], 1, 1, 1, 1, 1, [ 5, 62 ], 
  [ 5, 62 ], [ 5, 62 ] ],
#V   n = 127
[ , [ 6, 5 ], [ 6, 21 ], 2, 3, 2, [ 6, 63 ], 2, 1, 3, 1, 1, 3, 1, 3, 1, 3, 2, 
  3, 1, 2, 3, 2, 1, 2, 1, 2, 3, 2, 2, 3, 1, 2, 1, 2, 2, 1, 2, 1, 3, 1, 3, 1, 
  1, 1, 3, 1, 3, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 3, 
  1, 1, 2, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 
  1, 1, 2, 1 ],
#V   n = 128
[ , [ 6, 5 ], [ 6, 21 ], [ 6, 64 ], 3, 2, [ 6, 64 ], 2, 1, 3, 1, 1, 3, 1, 3, 
  1, 3, [ 0, 66, "BY" ], 3, 1, [ 0, 63, "BZ" ], 3, [ 0, 60, "BZ" ], 1, 
  [ 0, 57, "BZ" ], 1, [ 0, 54, "BZ" ], 3, [ 0, 51, "BY" ], [ 0, 50, "BZ" ], 
  3, 1, [ 0, 48, "BZ" ], 1, [ 0, 45, "BY" ], [ 0, 44, "BZ" ], 1, 
  [ 0, 42, "BZ" ], 1, 3, 1, 3, 1, 1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 2, 1, 1, 3, 1, 1, [ 0, 12, "BZ" ], 3, 1, [ 5, 54 ], 
  [ 5, 54 ], [ 5, 58 ], [ 5, 58 ], [ 5, 58 ], [ 5, 58 ], [ 5, 58 ], 
  [ 5, 58 ], [ 5, 56 ], [ 5, 57 ], [ 5, 58 ], [ 5, 56 ], [ 5, 57 ], 
  [ 5, 60 ], [ 5, 60 ], [ 5, 60 ], [ 5, 63 ], [ 5, 63 ], [ 5, 63 ], 
  [ 5, 63 ], [ 5, 63 ], [ 5, 63 ], [ 5, 63 ], [ 5, 63 ], [ 5, 63 ] ],
#V   n = 129
[ , [ 6, 5 ], [ 6, 21 ], [ 6, 44 ], 1, 2, 2, 2, 1, 2, 3, 1, 3, 1, 3, 1, 2, 3, 
  3, 1, 3, 3, 3, 1, 3, 1, 3, 3, 3, 3, 3, 1, 3, 1, 3, 3, 1, 3, 1, 3, 1, 2, 1, 
  2, 1, 3, 3, 3, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 
  1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 3, 1, 3, 
  3, 1, 3, 3, 3, 1, 1, 2, 1, 1, 1, 1, 1, 1, 3, 1, 3, 3, 1, 1, 1, 2, 1, 1, 3, 
  3, 3, 1, 1, 2, 1 ],
#V   n = 130
[ , [ 6, 5 ], [ 6, 21 ], [ 6, 28 ], [ 6, 10 ], [ 0, 92, "Gu" ], 
  [ 0, 89, "Gu" ], [ 6, 65 ], 3, [ 0, 82, "XB" ], 3, 3, 3, 3, 3, 3, 
  [ 0, 70, "XB" ], 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
  3, 3, 3, 3, 3, [ 0, 40, "XB" ], 3, [ 0, 38, "BZ" ], 3, [ 0, 37, "BZ" ], 3, 
  3, 3, [ 0, 35, "BZ" ], 3, [ 0, 34, "BZ" ], 3, [ 0, 33, "BZ" ], 3, 
  [ 0, 32, "BZ" ], 3, [ 0, 31, "BZ" ], 3, [ 0, 30, "BZ" ], 3, [ 0, 29, "BZ" ],
  3, [ 0, 28, "BZ" ], 3, [ 0, 27, "BZ" ], 3, [ 0, 26, "BZ" ], 3, 
  [ 0, 25, "BZ" ], 3, [ 0, 24, "BZ" ], 3, [ 0, 23, "BZ" ], 3, [ 0, 22, "BZ" ],
  3, [ 0, 21, "BZ" ], 3, [ 0, 20, "BZ" ], 3, [ 0, 19, "BZ" ], 3, 
  [ 0, 18, "BZ" ], 3, [ 0, 17, "BZ" ], 3, [ 0, 16, "BZ" ], 3, [ 0, 15, "BZ" ],
  [ 5, 51 ], 3, 3, [ 5, 54 ], 3, 3, [ 5, 51 ], 3, 3, [ 5, 54 ], [ 5, 55 ], 
  [ 5, 59 ], [ 5, 59 ], [ 5, 59 ], [ 5, 59 ], [ 5, 59 ], [ 5, 59 ], 
  [ 5, 59 ], [ 5, 59 ], [ 5, 59 ], 3, [ 5, 61 ], [ 5, 61 ], [ 5, 61 ], 
  [ 5, 61 ], [ 5, 61 ], [ 5, 63 ], [ 5, 64 ], 3, 3, [ 5, 64 ], [ 5, 64 ], 
  [ 5, 64 ], [ 5, 64 ], [ 5, 64 ] ]];

GUAVA_BOUNDS_TABLE[2][4] := [
#V   n = 1
[  ],
#V   n = 2
[  ],
#V   n = 3
[  ],
#V   n = 4
[  ],
#V   n = 5
[  ],
#V   n = 6
[ ,,, [ 14, 4 ] ],
#V   n = 7
[ ,,, [ 14, 4 ], [ 14, 5 ] ],
#V   n = 8
[ ,,,, [ 14, 5 ], [ 14, 6 ] ],
#V   n = 9
[ ,,,,, [ 14, 6 ], [ 14, 7 ] ],
#V   n = 10
[ ,, [ 0, 6, "GH" ],,,, [ 14, 7 ], [ 14, 8 ] ],
#V   n = 11
[ ,, 12, 11,,,, [ 14, 8 ], [ 14, 9 ] ],
#V   n = 12
[ ,,, 12, 11,, [ 14, 6 ],, [ 14, 9 ], [ 14, 10 ] ],
#V   n = 13
[ ,,,, 12, 11, [ 14, 6 ], 11,, [ 14, 10 ], [ 14, 11 ] ],
#V   n = 14
[ ,,,,, 12, 11, 11, [ 14, 8 ],, [ 14, 11 ], [ 14, 12 ] ],
#V   n = 15
[ ,,,, [ 14, 4 ],, [ 14, 6 ], 11, [ 14, 8 ], [ 14, 9 ],, [ 14, 12 ], 
  [ 14, 13 ] ],
#V   n = 16
[ ,,,, [ 14, 4 ], [ 14, 5 ],, 12, 11, [ 14, 9 ], [ 14, 10 ],, [ 14, 13 ], 
  [ 14, 14 ] ],
#V   n = 17
[ ,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ],, [ 14, 8 ], 11, [ 14, 10 ], 
  [ 14, 11 ],, [ 14, 14 ], [ 14, 15 ] ],
#V   n = 18
[ ,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], [ 14, 7 ],, [ 14, 8 ], 11, 
  [ 14, 11 ], [ 14, 12 ],, [ 14, 15 ], [ 14, 16 ] ],
#V   n = 19
[ ,,, [ 0, 12, "GH" ], [ 0, 11, "HLL" ], [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], 
  [ 14, 8 ], [ 14, 8 ], [ 14, 9 ], 11, [ 14, 12 ], [ 14, 13 ], [ 14, 12 ], 
  [ 14, 16 ], [ 14, 17 ] ],
#V   n = 20
[ ,,, 12, 11, 11, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], [ 14, 9 ], [ 14, 9 ], 
  [ 14, 10 ], 11, [ 14, 13 ], [ 14, 14 ], 11, [ 14, 17 ], [ 14, 18 ] ],
#V   n = 21
[ ,,, 12, [ 14, 4 ], 11, 11, [ 14, 7 ], [ 14, 8 ], [ 14, 9 ], [ 14, 10 ], 
  [ 14, 10 ], [ 14, 11 ], 11, [ 14, 14 ], [ 14, 15 ], 11, [ 14, 18 ], 
  [ 14, 19 ] ],
#V   n = 22
[ ,,, 12, [ 14, 4 ], [ 14, 5 ], 11, 11, [ 14, 8 ], [ 14, 9 ], [ 14, 10 ], 
  [ 14, 11 ], [ 14, 11 ], [ 14, 12 ], 11, [ 14, 15 ], [ 14, 16 ], 11, 
  [ 14, 16 ], [ 14, 20 ] ],
#V   n = 23
[ ,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], 11, 11, [ 14, 9 ], [ 14, 10 ], 
  [ 14, 11 ], [ 14, 12 ], 12, [ 14, 13 ], 11, [ 14, 16 ], [ 14, 17 ], 
  [ 14, 16 ], [ 14, 17 ], [ 14, 21 ] ],
#V   n = 24
[ ,,,,, [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], 11, 11, [ 14, 10 ], [ 14, 11 ], 
  [ 14, 12 ], [ 14, 13 ], 12, [ 14, 14 ], 11, [ 14, 17 ], [ 14, 18 ], 
  [ 14, 17 ], [ 14, 18 ], [ 14, 22 ] ],
#V   n = 25
[ ,,,,,, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], 11, 11, [ 14, 11 ], [ 14, 12 ], 
  [ 14, 13 ], [ 14, 14 ], 12, [ 14, 15 ], 11, [ 14, 18 ], [ 14, 19 ], 
  [ 14, 18 ], [ 14, 19 ], [ 14, 23 ] ],
#V   n = 26
[ ,,,,,,, [ 14, 7 ], [ 14, 8 ], [ 14, 9 ], 11, 11, [ 14, 12 ], [ 14, 13 ], 
  [ 14, 14 ], [ 14, 15 ], 12, [ 14, 16 ], 11, [ 14, 19 ], [ 14, 20 ], 
  [ 14, 19 ], [ 14, 20 ], [ 14, 24 ] ],
#V   n = 27
[ ,,,,,,,, [ 14, 8 ], [ 14, 9 ], [ 14, 10 ], 11, 11, [ 14, 13 ], [ 14, 14 ], 
  [ 14, 15 ], [ 14, 16 ], 12, [ 14, 17 ], 11, [ 14, 20 ], [ 14, 21 ], 
  [ 14, 20 ], [ 14, 21 ], [ 14, 25 ] ],
#V   n = 28
[ ,,,, [ 0, 18, "HLL" ],,,,, [ 14, 9 ], [ 14, 10 ], [ 14, 11 ], 11, 11, 
  [ 14, 14 ], [ 14, 15 ], [ 14, 16 ], [ 14, 17 ], 12, [ 14, 18 ], 11, 
  [ 14, 21 ], [ 14, 22 ], [ 14, 21 ], [ 14, 22 ], [ 14, 26 ] ],
#V   n = 29
[ ,,,, 12, 11,, [ 14, 6 ],,, [ 14, 10 ], [ 14, 11 ], [ 14, 12 ], 11, 11, 
  [ 14, 15 ], [ 14, 16 ], [ 14, 17 ], [ 14, 18 ], 12, [ 14, 19 ], 11, 
  [ 14, 22 ], [ 14, 23 ], [ 14, 22 ], [ 14, 23 ], [ 14, 27 ] ],
#V   n = 30
[ ,,,,, [ 14, 4 ], 11, [ 14, 6 ], 11,,, [ 14, 11 ], [ 14, 12 ], [ 14, 11 ], 
  11, 11, [ 14, 16 ], [ 14, 17 ], [ 14, 18 ], [ 14, 19 ], 12, [ 14, 20 ], 11, 
  [ 0, 4, "BK" ], [ 14, 24 ], [ 14, 23 ], [ 14, 24 ], [ 14, 28 ] ],
#V   n = 31
[ ,,,,,, 12, 11, 11, [ 14, 8 ],,, [ 14, 12 ], 12, [ 14, 12 ], [ 14, 12 ], 11, 
  [ 14, 17 ], [ 14, 18 ], [ 14, 16 ], [ 14, 20 ], 12, [ 14, 21 ], 12, 11, 
  [ 14, 25 ], [ 14, 24 ], [ 14, 25 ], [ 14, 29 ] ],
#V   n = 32
[ ,,, [ 0, 22, "GH" ],, [ 14, 4 ],, [ 14, 6 ], 11, [ 14, 8 ], [ 14, 9 ],,, 
  12, 12, [ 14, 13 ], 11, 11, [ 14, 18 ], [ 14, 16 ], [ 14, 17 ], [ 14, 21 ], 
  12, [ 14, 22 ], 12, 11, [ 14, 26 ], [ 14, 25 ], [ 14, 26 ], [ 14, 30 ] ],
#V   n = 33
[ ,,, 12, 11, [ 14, 4 ], 11,, 12, 11, [ 14, 9 ], [ 14, 10 ],, 12, 12, 
  [ 14, 12 ], [ 14, 14 ], 11, 11, [ 14, 16 ], [ 14, 17 ], [ 14, 18 ], 
  [ 14, 22 ], 12, [ 14, 23 ], 12, 11, [ 14, 27 ], [ 14, 26 ], [ 14, 27 ], 
  [ 14, 31 ] ],
#V   n = 34
[ ,,,, 12, 11, 11, [ 14, 6 ],, [ 14, 8 ], 11, [ 14, 10 ], [ 14, 11 ],, 12, 
  [ 14, 12 ], 12, [ 14, 15 ], 11, 11, [ 14, 17 ], [ 14, 18 ], [ 14, 19 ], 
  [ 14, 23 ], 12, [ 14, 24 ], 12, 11, [ 14, 28 ], [ 14, 27 ], [ 14, 28 ], 
  [ 14, 32 ] ],
#V   n = 35
[ ,,,,, [ 14, 4 ], 11, [ 14, 6 ], 11,, [ 14, 9 ], 11, [ 14, 11 ], [ 14, 12 ],
  , [ 14, 12 ], 12, 12, [ 14, 16 ], [ 14, 16 ], 11, [ 14, 18 ], [ 14, 19 ], 
  [ 14, 20 ], [ 14, 24 ], 12, [ 14, 25 ], [ 14, 22 ], 11, [ 14, 29 ], 
  [ 14, 28 ], [ 14, 29 ], [ 14, 33 ] ],
#V   n = 36
[ ,,,,,, 12, 11, 11, [ 14, 8 ],, [ 14, 10 ], 11, [ 14, 12 ], [ 14, 13 ],, 12, 
  12, 12, [ 14, 17 ], [ 14, 17 ], 11, [ 14, 19 ], [ 14, 20 ], [ 14, 21 ], 
  [ 14, 25 ], 12, [ 14, 26 ], 12, 11, [ 14, 30 ], [ 14, 29 ], [ 14, 30 ], 
  [ 14, 34 ] ],
#V   n = 37
[ ,,,,, [ 14, 4 ],, [ 14, 6 ], 11, [ 14, 8 ], [ 14, 9 ],, [ 14, 11 ], 11, 
  [ 14, 13 ], [ 14, 14 ],, 12, 12, [ 14, 16 ], [ 14, 18 ], [ 14, 18 ], 11, 
  [ 14, 20 ], [ 14, 21 ], [ 14, 22 ], [ 14, 26 ], [ 14, 22 ], [ 14, 27 ], 
  [ 14, 24 ], 11, [ 14, 31 ], [ 14, 30 ], [ 14, 31 ], [ 14, 35 ] ],
#V   n = 38
[ ,,,,, [ 14, 4 ], [ 14, 5 ],, 12, 11, [ 14, 9 ], [ 14, 10 ],, [ 14, 12 ], 
  11, [ 14, 14 ], [ 14, 15 ],, 12, [ 14, 16 ], [ 14, 17 ], [ 14, 19 ], 
  [ 14, 19 ], 11, [ 14, 21 ], [ 14, 22 ], [ 14, 23 ], [ 14, 27 ], 12, 
  [ 14, 28 ], [ 14, 25 ], 11, [ 14, 32 ], [ 14, 31 ], [ 14, 32 ], [ 14, 36 ] 
 ],
#V   n = 39
[ ,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], [ 14, 6 ], [ 14, 8 ], 11, 
  [ 14, 10 ], [ 14, 11 ],, [ 14, 11 ], 11, [ 14, 15 ], [ 14, 16 ],, 
  [ 14, 16 ], [ 14, 17 ], [ 14, 18 ], [ 14, 20 ], [ 14, 20 ], 11, [ 14, 22 ], 
  [ 14, 23 ], [ 14, 24 ], [ 14, 28 ], [ 0, 6, "LP" ], [ 14, 29 ], [ 14, 26 ], 
  11, [ 14, 33 ], [ 14, 32 ], [ 14, 33 ], [ 14, 37 ] ],
#V   n = 40
[ ,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], [ 14, 7 ], [ 14, 8 ], 11, 
  [ 14, 11 ], [ 14, 12 ], 12, [ 14, 12 ], 11, [ 14, 16 ], [ 14, 17 ],, 
  [ 14, 17 ], [ 14, 18 ], [ 14, 19 ], [ 14, 21 ], [ 14, 21 ], 11, [ 14, 23 ], 
  [ 14, 24 ], [ 14, 25 ], 12, 11, [ 14, 30 ], [ 14, 27 ], 11, [ 14, 34 ], 
  [ 14, 33 ], [ 14, 34 ], [ 14, 38 ] ],
#V   n = 41
[ ,,,,,, [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], 12, [ 14, 9 ], 11, 
  [ 14, 12 ], [ 14, 13 ], 12, [ 14, 13 ], 11, [ 14, 17 ], [ 14, 18 ],, 
  [ 14, 18 ], [ 14, 19 ], [ 14, 20 ], [ 14, 22 ], [ 14, 22 ], 11, [ 14, 24 ], 
  [ 14, 25 ], [ 14, 26 ], 12, 11, [ 14, 31 ], [ 14, 28 ], 11, [ 14, 35 ], 
  [ 14, 34 ], [ 14, 35 ], [ 14, 39 ] ],
#V   n = 42
[ ,,,,, [ 14, 4 ],, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], [ 14, 9 ], 12, 
  [ 14, 10 ], 11, [ 14, 13 ], [ 14, 14 ], 12, [ 14, 14 ], 11, [ 14, 18 ], 
  [ 14, 19 ],, [ 14, 19 ], [ 14, 20 ], [ 14, 21 ], [ 14, 23 ], [ 14, 23 ], 
  11, [ 14, 25 ], [ 14, 26 ], [ 14, 27 ], 12, 11, [ 14, 32 ], [ 14, 29 ], 11, 
  [ 14, 36 ], [ 14, 35 ], [ 14, 36 ], [ 14, 40 ] ],
#V   n = 43
[ ,,,,, [ 14, 4 ], [ 14, 5 ],, [ 14, 7 ], [ 14, 8 ], [ 14, 9 ], [ 14, 10 ], 
  12, [ 14, 11 ], 11, [ 14, 14 ], [ 14, 15 ], 12, [ 14, 15 ], 11, [ 14, 19 ], 
  [ 14, 20 ],, [ 14, 20 ], [ 14, 21 ], [ 14, 22 ], [ 14, 24 ], [ 14, 24 ], 
  [ 0, 10, "LP" ], [ 14, 26 ], [ 14, 27 ], [ 14, 28 ], 12, 11, [ 14, 33 ], 
  [ 14, 30 ], 11, [ 14, 37 ], [ 14, 36 ], [ 14, 37 ], [ 14, 41 ] ],
#V   n = 44
[ ,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ],, [ 14, 8 ], [ 14, 9 ], [ 14, 10 ], 
  [ 14, 11 ], 12, [ 14, 12 ], 11, [ 14, 15 ], [ 14, 16 ], 12, [ 14, 16 ], 11, 
  [ 14, 20 ], [ 14, 21 ],, [ 14, 21 ], [ 14, 22 ], [ 14, 23 ], [ 14, 25 ], 
  [ 14, 25 ], 11, [ 14, 27 ], [ 14, 28 ], [ 14, 29 ], 12, 11, [ 14, 34 ], 
  [ 14, 31 ], 11, [ 14, 38 ], [ 14, 37 ], [ 14, 38 ], [ 14, 42 ] ],
#V   n = 45
[ ,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], [ 14, 7 ],, [ 14, 9 ], [ 14, 10 ], 
  [ 14, 11 ], [ 14, 12 ], 12, [ 14, 13 ], 11, [ 14, 16 ], [ 14, 17 ], 12, 
  [ 14, 17 ], 11, [ 14, 21 ], [ 14, 22 ],, [ 14, 22 ], [ 14, 23 ], 
  [ 14, 24 ], [ 14, 26 ], [ 14, 26 ], 11, [ 14, 28 ], [ 14, 29 ], [ 14, 30 ], 
  12, 11, [ 14, 35 ], [ 14, 32 ], 11, [ 14, 39 ], [ 14, 38 ], [ 14, 39 ], 
  [ 14, 43 ] ],
#V   n = 46
[ ,,,,, [ 0, 31, "BK" ], [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], [ 14, 8 ],, 
  [ 14, 10 ], [ 14, 11 ], [ 14, 12 ], [ 14, 13 ], 12, [ 14, 14 ], 11, 
  [ 14, 17 ], [ 14, 18 ], [ 14, 16 ], [ 14, 18 ], 11, [ 14, 22 ], [ 14, 23 ],
  , [ 14, 23 ], [ 14, 24 ], [ 14, 25 ], [ 14, 27 ], [ 14, 27 ], 11, 
  [ 14, 29 ], [ 14, 30 ], [ 14, 31 ], 12, 11, [ 14, 36 ], [ 14, 33 ], 11, 
  [ 14, 40 ], [ 14, 39 ], [ 14, 40 ], [ 14, 44 ] ],
#V   n = 47
[ ,,,,,, 11, [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], [ 14, 9 ],, [ 14, 11 ], 
  [ 14, 12 ], [ 14, 13 ], [ 14, 14 ], 12, [ 14, 15 ], 11, [ 14, 15 ], 
  [ 14, 19 ], [ 14, 17 ], [ 14, 19 ], 11, [ 14, 23 ], [ 14, 24 ], 
  [ 0, 15, "LP" ], [ 14, 24 ], [ 14, 25 ], [ 14, 26 ], [ 14, 28 ], 
  [ 14, 28 ], 11, [ 14, 30 ], [ 14, 31 ], [ 14, 32 ], 12, 11, [ 14, 37 ], 
  [ 14, 34 ], 11, [ 14, 41 ], [ 14, 40 ], [ 14, 41 ], [ 14, 45 ] ],
#V   n = 48
[ ,,,,, [ 14, 4 ],, 11, [ 14, 7 ], [ 14, 8 ], [ 14, 9 ], [ 14, 10 ],, 
  [ 14, 12 ], [ 14, 13 ], [ 14, 14 ], [ 14, 15 ], 12, [ 14, 16 ], [ 14, 15 ], 
  [ 14, 16 ], [ 14, 20 ], [ 14, 18 ], [ 14, 20 ], 11, [ 14, 24 ], [ 14, 25 ], 
  11, [ 14, 25 ], [ 14, 26 ], [ 14, 27 ], [ 14, 29 ], [ 14, 29 ], 11, 
  [ 14, 31 ], [ 0, 8, "LP" ], [ 14, 33 ], 12, 11, [ 14, 38 ], [ 14, 35 ], 11, 
  [ 14, 42 ], [ 14, 41 ], [ 14, 42 ], [ 14, 46 ] ],
#V   n = 49
[ ,,,, [ 0, 34, "LP" ], [ 14, 4 ], [ 14, 5 ],, 11, [ 14, 8 ], [ 14, 9 ], 
  [ 14, 10 ], [ 14, 11 ],, [ 14, 13 ], [ 14, 14 ], [ 14, 15 ], [ 14, 16 ], 
  12, [ 14, 17 ], [ 14, 16 ], [ 14, 17 ], [ 14, 21 ], [ 14, 19 ], [ 14, 21 ], 
  11, [ 14, 20 ], [ 14, 26 ], 11, [ 14, 26 ], [ 14, 27 ], [ 14, 28 ], 
  [ 14, 30 ], [ 14, 30 ], 11, 12, 11, [ 14, 34 ], 12, 11, [ 14, 39 ], 
  [ 14, 36 ], 11, [ 14, 43 ], [ 14, 42 ], [ 14, 43 ], [ 14, 47 ] ],
#V   n = 50
[ ,,,, 12, 11, [ 14, 5 ], [ 14, 6 ],, 11, [ 14, 9 ], [ 14, 10 ], [ 14, 11 ], 
  [ 14, 12 ], 13, [ 14, 14 ], [ 14, 15 ], [ 14, 16 ], [ 14, 17 ], [ 14, 15 ], 
  [ 14, 18 ], [ 14, 17 ], [ 14, 18 ], [ 14, 22 ], [ 14, 20 ], [ 14, 22 ], 
  [ 14, 20 ], [ 14, 21 ], [ 14, 27 ], 11, [ 14, 27 ], [ 14, 28 ], [ 14, 29 ], 
  [ 14, 31 ], [ 14, 31 ], 11, 12, 11, [ 14, 35 ], 12, 11, [ 14, 40 ], 
  [ 14, 37 ], 11, [ 14, 44 ], [ 14, 43 ], [ 14, 44 ], [ 14, 48 ] ],
#V   n = 51
[ ,,,,, [ 14, 4 ], 11, [ 14, 6 ], [ 14, 7 ],, 11, [ 14, 10 ], [ 14, 11 ], 
  [ 14, 12 ], [ 0, 27, "LP" ], 13, [ 14, 15 ], [ 14, 16 ], [ 14, 14 ], 
  [ 14, 18 ], [ 14, 16 ], [ 14, 19 ], [ 14, 18 ], [ 14, 19 ], [ 14, 23 ], 
  [ 14, 21 ], [ 14, 23 ], [ 14, 21 ], [ 14, 22 ], [ 14, 28 ], 11, 
  [ 0, 14, "LP" ], [ 14, 29 ], [ 14, 30 ], [ 14, 32 ], [ 14, 32 ], 11, 12, 
  11, [ 14, 36 ], 12, 11, [ 14, 41 ], [ 14, 38 ], 11, [ 14, 45 ], [ 14, 44 ], 
  [ 14, 45 ], [ 14, 49 ] ],
#V   n = 52
[ ,,,,,, [ 14, 5 ], 11, [ 14, 7 ], [ 14, 8 ], [ 0, 31, "LP" ], 11, 
  [ 14, 11 ], [ 14, 12 ], 12, 11, [ 14, 12 ], [ 14, 16 ], [ 14, 14 ], 
  [ 14, 15 ], [ 14, 19 ], [ 14, 17 ], [ 14, 20 ], [ 14, 19 ], [ 14, 20 ], 
  [ 14, 24 ], [ 14, 22 ], [ 14, 24 ], [ 14, 22 ], [ 14, 23 ], [ 14, 29 ], 11, 
  11, [ 14, 30 ], [ 0, 12, "LP" ], [ 14, 33 ], [ 14, 33 ], 11, 12, 11, 
  [ 14, 37 ], 12, 11, [ 14, 42 ], [ 14, 39 ], 11, [ 14, 46 ], [ 14, 45 ], 
  [ 14, 46 ], [ 14, 50 ] ],
#V   n = 53
[ ,,, [ 0, 38, "GH" ], [ 0, 37, "LP" ], [ 14, 4 ],, [ 14, 6 ], 11, [ 14, 8 ], 
  [ 14, 9 ], 11, 11, [ 14, 12 ], 12, 12, 11, 13, [ 14, 14 ], [ 14, 15 ], 
  [ 14, 16 ], [ 14, 20 ], [ 14, 18 ], [ 14, 21 ], [ 14, 20 ], [ 14, 21 ], 
  [ 14, 25 ], [ 14, 23 ], [ 14, 25 ], [ 14, 23 ], [ 14, 24 ], [ 14, 30 ], 11, 
  11, 12, 11, [ 14, 34 ], [ 14, 34 ], 11, 12, 11, [ 14, 38 ], 12, 11, 
  [ 14, 43 ], [ 14, 40 ], 11, [ 14, 47 ], [ 14, 46 ], [ 14, 47 ], [ 14, 51 ] 
 ],
#V   n = 54
[ ,,, 12, 11, 11, [ 14, 5 ],, [ 14, 7 ], 11, [ 14, 9 ], [ 14, 10 ], 11, 11, 
  12, 12, [ 14, 12 ], 11, [ 14, 14 ], [ 14, 15 ], [ 14, 16 ], [ 14, 17 ], 
  [ 14, 21 ], [ 14, 19 ], [ 14, 22 ], [ 14, 21 ], [ 14, 22 ], [ 14, 26 ], 
  [ 14, 24 ], [ 14, 26 ], [ 14, 24 ], [ 14, 25 ], [ 14, 31 ], 11, 11, 12, 11, 
  [ 14, 35 ], [ 14, 35 ], 11, 12, 11, [ 14, 39 ], 12, 11, [ 14, 44 ], 
  [ 14, 41 ], 11, [ 14, 48 ], [ 14, 47 ], [ 14, 48 ], [ 14, 52 ] ],
#V   n = 55
[ ,,,, 12, 11, 11, [ 14, 6 ], [ 0, 35, "BK" ], [ 14, 8 ], 11, [ 14, 10 ], 
  [ 14, 11 ], 11, 11, 12, [ 14, 12 ], 12, 11, [ 14, 15 ], [ 14, 16 ], 
  [ 14, 17 ], [ 14, 18 ], [ 14, 22 ], [ 14, 20 ], [ 14, 23 ], [ 14, 22 ], 
  [ 14, 23 ], [ 14, 27 ], [ 14, 25 ], [ 14, 27 ], [ 14, 25 ], [ 14, 26 ], 
  [ 14, 32 ], 11, 11, 12, 11, [ 14, 36 ], [ 14, 36 ], 11, 12, 11, [ 14, 40 ], 
  12, 11, [ 14, 45 ], [ 14, 42 ], 11, [ 14, 49 ], [ 14, 48 ], [ 14, 49 ], 
  [ 14, 53 ] ],
#V   n = 56
[ ,,, [ 0, 40, "HLL" ],, [ 14, 4 ], 11, 11, [ 14, 7 ], 11, [ 0, 34, "LP" ], 
  11, [ 14, 11 ], [ 14, 12 ], 11, 11, [ 14, 12 ], 12, [ 14, 14 ], 11, 
  [ 14, 16 ], [ 14, 17 ], [ 14, 18 ], [ 14, 19 ], [ 14, 23 ], [ 14, 21 ], 
  [ 14, 24 ], [ 14, 23 ], [ 14, 24 ], [ 14, 28 ], [ 14, 26 ], [ 14, 28 ], 
  [ 14, 26 ], [ 14, 27 ], [ 14, 33 ], 11, 11, 12, 11, [ 14, 37 ], [ 14, 37 ], 
  11, 12, 11, [ 14, 41 ], 12, 11, [ 14, 46 ], [ 14, 43 ], 11, [ 14, 50 ], 
  [ 14, 49 ], [ 14, 50 ], [ 14, 54 ] ],
#V   n = 57
[ ,,, 12, 11,, [ 14, 5 ], 11, 11, [ 14, 8 ], 11, 11, 11, [ 14, 12 ], 
  [ 14, 13 ], 11, [ 0, 30, "LP" ], 13, [ 14, 14 ], [ 14, 15 ], 11, 
  [ 14, 17 ], [ 14, 18 ], [ 14, 19 ], [ 14, 20 ], [ 14, 24 ], [ 14, 22 ], 
  [ 14, 25 ], [ 14, 24 ], [ 14, 25 ], [ 14, 29 ], [ 14, 27 ], [ 14, 29 ], 
  [ 14, 27 ], [ 14, 28 ], [ 14, 34 ], 11, 11, 12, 11, [ 14, 38 ], 
  [ 0, 10, "LP" ], 11, 12, 11, [ 14, 42 ], 12, 11, [ 14, 47 ], [ 14, 44 ], 
  11, [ 14, 51 ], [ 14, 50 ], [ 14, 51 ], [ 14, 55 ] ],
#V   n = 58
[ ,,, 12, 12, 11,, [ 0, 38, "LP" ], 11, 11, [ 14, 9 ], 11, 11, 
  [ 0, 33, "LP" ], [ 14, 10 ], [ 14, 14 ], 11, 11, [ 14, 14 ], [ 14, 15 ], 
  [ 14, 16 ], 11, [ 14, 18 ], [ 14, 19 ], [ 14, 20 ], [ 14, 21 ], [ 14, 25 ], 
  [ 14, 23 ], [ 14, 26 ], [ 14, 25 ], [ 14, 26 ], [ 14, 30 ], [ 14, 28 ], 
  [ 14, 30 ], [ 14, 28 ], [ 14, 29 ], [ 14, 35 ], 11, 11, 12, 11, 12, 11, 11, 
  12, 11, [ 14, 43 ], 12, 11, [ 14, 48 ], [ 14, 45 ], 11, [ 14, 52 ], 
  [ 14, 51 ], [ 14, 52 ], [ 14, 56 ] ],
#V   n = 59
[ ,,, 12, 12, [ 14, 4 ], 11, 12, 11, 11, 11, [ 14, 10 ], 11, 11, 11, 11, 
  [ 14, 15 ], 11, 11, [ 14, 15 ], [ 14, 16 ], [ 14, 17 ], 11, [ 14, 19 ], 
  [ 14, 20 ], [ 14, 21 ], [ 14, 22 ], [ 14, 26 ], [ 14, 24 ], [ 14, 27 ], 
  [ 14, 26 ], [ 14, 27 ], [ 14, 31 ], [ 14, 29 ], [ 14, 31 ], [ 14, 29 ], 
  [ 14, 30 ], [ 14, 36 ], 11, 11, 12, 11, 12, 11, 11, 12, 11, [ 14, 44 ], 12, 
  11, [ 14, 49 ], [ 14, 46 ], 11, [ 14, 53 ], [ 14, 52 ], [ 14, 53 ], 
  [ 14, 57 ] ],
#V   n = 60
[ ,,,, 12, [ 14, 4 ], [ 14, 4 ], 11, 12, 11, 11, [ 0, 36, "BK" ], [ 14, 11 ], 
  11, 11, 11, [ 14, 12 ], [ 14, 16 ], 11, 11, [ 14, 16 ], [ 14, 17 ], 
  [ 14, 18 ], 11, [ 0, 26, "LP" ], [ 14, 21 ], [ 14, 22 ], [ 14, 23 ], 
  [ 0, 23, "LP" ], [ 14, 25 ], [ 14, 28 ], [ 14, 27 ], [ 14, 28 ], 
  [ 14, 32 ], [ 14, 30 ], [ 14, 32 ], [ 14, 30 ], [ 14, 31 ], [ 14, 37 ], 11, 
  11, 12, 11, 12, 11, 11, 12, 11, [ 14, 45 ], 12, 11, [ 14, 50 ], 
  [ 0, 4, "LP" ], 11, [ 14, 54 ], [ 14, 53 ], [ 14, 54 ], [ 14, 58 ] ],
#V   n = 61
[ ,,,,, [ 14, 4 ], 12, 11, 11, 12, 11, [ 14, 8 ], 11, [ 14, 12 ], 11, 11, 11, 
  11, [ 14, 17 ], 11, 11, [ 0, 29, "LP" ], [ 14, 18 ], [ 14, 19 ], 11, 11, 
  [ 14, 22 ], [ 14, 23 ], [ 14, 24 ], 11, [ 14, 26 ], [ 14, 29 ], [ 14, 28 ], 
  [ 14, 29 ], [ 0, 19, "LP" ], [ 14, 31 ], [ 14, 33 ], [ 14, 31 ], 
  [ 14, 32 ], [ 0, 15, "LP" ], [ 0, 14, "LP" ], 11, 12, 11, 12, 11, 11, 12, 
  11, [ 14, 46 ], [ 0, 6, "LP" ], 11, 12, 11, 11, [ 14, 55 ], [ 14, 54 ], 
  [ 14, 55 ], [ 14, 59 ] ],
#V   n = 62
[ ,,,, [ 0, 44, "LP" ], [ 0, 43, "BK" ], 12, 11, [ 14, 6 ], 11, 12, 11, 12, 
  11, [ 0, 35, "LP" ], 11, 11, 11, [ 14, 14 ], [ 14, 18 ], 11, 11, 11, 
  [ 14, 19 ], [ 14, 20 ], 11, 11, [ 14, 23 ], [ 14, 24 ], [ 14, 25 ], 11, 
  [ 14, 27 ], [ 14, 30 ], [ 14, 29 ], [ 14, 30 ], 11, [ 14, 32 ], [ 14, 34 ], 
  [ 14, 32 ], [ 14, 33 ], 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 
  12, 11, 11, [ 14, 56 ], [ 14, 55 ], [ 14, 56 ], [ 14, 60 ] ],
#V   n = 63
[ ,,,, 12, 11, 11, 11, 12, [ 14, 7 ], 11, 13, 11, [ 14, 10 ], 11, 11, 11, 11, 
  11, [ 14, 15 ], [ 14, 19 ], 11, 11, 11, [ 14, 20 ], [ 14, 21 ], 11, 11, 
  [ 14, 24 ], [ 14, 25 ], [ 14, 26 ], 11, [ 14, 28 ], [ 14, 31 ], [ 14, 30 ], 
  [ 14, 31 ], 11, [ 14, 33 ], [ 14, 35 ], [ 14, 33 ], [ 14, 34 ], 11, 11, 11, 
  12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, [ 14, 57 ], [ 14, 56 ], 
  [ 14, 57 ], [ 14, 61 ] ],
#V   n = 64
[ ,,,, 12, [ 14, 4 ], 11, 11, 12, 12, [ 14, 8 ], [ 0, 39, "BK" ], 13, 11, 
  [ 14, 11 ], 11, 11, 11, 11, 11, [ 14, 16 ], [ 14, 20 ], 11, 11, 11, 
  [ 14, 21 ], [ 14, 22 ], 11, 11, [ 14, 25 ], [ 14, 26 ], [ 14, 27 ], 11, 
  [ 14, 29 ], [ 14, 32 ], [ 14, 31 ], [ 14, 32 ], 11, [ 0, 18, "LP" ], 
  [ 14, 36 ], [ 14, 34 ], [ 14, 35 ], 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 
  12, 11, 11, 12, 11, 11, [ 14, 58 ], [ 14, 57 ], [ 14, 58 ], [ 14, 62 ] ],
#V   n = 65
[ ,,,, 12, [ 14, 4 ], [ 14, 5 ], 11, 11, 12, 12, [ 14, 9 ], 11, 13, 11, 
  [ 14, 12 ], 11, 11, 11, 11, 11, [ 14, 17 ], [ 14, 21 ], 11, 11, 11, 
  [ 14, 22 ], [ 14, 23 ], 11, 11, [ 14, 26 ], [ 14, 27 ], [ 14, 28 ], 11, 
  [ 0, 22, "LP" ], [ 14, 33 ], [ 14, 32 ], [ 14, 33 ], 11, 11, [ 14, 37 ], 
  [ 14, 35 ], [ 14, 36 ], 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 
  12, 11, 11, [ 14, 59 ], [ 14, 58 ], [ 14, 59 ], [ 14, 63 ] ],
#V   n = 66
[ ,,,,, 13, [ 14, 5 ], [ 14, 6 ], 11, 11, 12, 12, [ 14, 10 ], 11, 
  [ 0, 38, "LP" ], 11, [ 14, 13 ], 11, 11, [ 0, 34, "LP" ], 11, 11, 
  [ 14, 18 ], [ 14, 22 ], 11, 11, 11, [ 0, 28, "LP" ], [ 14, 24 ], 11, 11, 
  [ 14, 27 ], [ 14, 28 ], [ 14, 29 ], 11, 11, [ 14, 34 ], [ 14, 33 ], 
  [ 14, 34 ], 11, 11, [ 14, 38 ], [ 14, 36 ], [ 14, 37 ], 11, 11, 11, 
  [ 0, 12, "LP" ], 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 
  [ 14, 60 ], [ 14, 59 ], [ 14, 60 ], [ 14, 64 ] ],
#V   n = 67
[ ,,,,, [ 0, 46, "BK" ], 13, [ 14, 6 ], [ 14, 7 ], [ 0, 43, "BK" ], 11, 13, 
  [ 14, 8 ], [ 14, 11 ], 11, 11, 11, [ 14, 14 ], 11, 11, 11, 11, 11, 
  [ 14, 19 ], [ 0, 31, "LP" ], 11, 11, 11, 11, [ 14, 25 ], 11, 11, 
  [ 14, 28 ], [ 14, 29 ], [ 14, 30 ], 11, 11, [ 14, 35 ], [ 14, 34 ], 
  [ 14, 35 ], 11, 11, [ 14, 39 ], [ 14, 37 ], [ 14, 38 ], 11, 11, 12, 11, 11, 
  12, 11, 11, [ 0, 8, "LP" ], 11, 12, 11, 11, 12, 11, 11, [ 14, 48 ], 
  [ 14, 60 ], [ 14, 61 ], [ 14, 65 ] ],
#V   n = 68
[ ,,,, [ 14, 3 ], 12, 11, 13, [ 14, 7 ], [ 14, 6 ], 11, [ 0, 42, "BK" ], 
  [ 14, 8 ], 12, [ 14, 12 ], 11, 11, [ 0, 37, "LP" ], [ 14, 15 ], 11, 11, 11, 
  11, 11, [ 14, 20 ], 11, 11, 11, 11, 11, [ 14, 26 ], 11, 11, [ 14, 29 ], 
  [ 14, 30 ], [ 14, 31 ], 11, 11, [ 14, 36 ], [ 14, 35 ], [ 14, 36 ], 11, 11, 
  [ 14, 40 ], [ 14, 38 ], [ 14, 39 ], 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, [ 14, 49 ], [ 14, 61 ], [ 14, 62 ], [ 14, 66 ] ],
#V   n = 69
[ ,,,, [ 14, 3 ], [ 14, 4 ], 12, 11, 13, 12, 12, 11, 11, 13, [ 0, 40, "LP" ], 
  [ 14, 13 ], 11, 11, 11, [ 14, 16 ], 11, 11, 11, 11, 11, [ 14, 21 ], 11, 11, 
  11, 11, 11, [ 14, 27 ], 11, 11, [ 14, 30 ], [ 14, 31 ], [ 14, 32 ], 11, 11, 
  [ 0, 21, "LP" ], [ 14, 36 ], [ 14, 37 ], 11, 11, [ 0, 17, "LP" ], 
  [ 14, 39 ], [ 14, 40 ], 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, [ 14, 50 ], [ 14, 62 ], [ 14, 63 ], [ 14, 67 ] ],
#V   n = 70
[ ,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ], 12, 11, 13, 13, [ 14, 8 ], 11, 11, 
  12, 11, [ 14, 14 ], 11, 11, 11, [ 14, 17 ], 11, 11, 11, 11, 11, [ 14, 22 ], 
  11, 11, 11, 11, 11, [ 14, 28 ], 11, 11, [ 14, 31 ], [ 14, 32 ], [ 14, 33 ], 
  11, 11, 11, [ 0, 20, "LP" ], [ 14, 38 ], 11, 11, 11, [ 0, 16, "LP" ], 
  [ 14, 41 ], 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  [ 14, 51 ], [ 14, 63 ], [ 14, 64 ], [ 14, 68 ] ],
#V   n = 71
[ ,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], 12, 11, [ 0, 45, "LP" ], 
  13, [ 14, 9 ], 11, 11, 12, 11, [ 14, 15 ], 11, 11, 11, [ 14, 18 ], 11, 11, 
  11, [ 0, 33, "LP" ], 11, [ 14, 23 ], 11, 11, 11, 11, 11, [ 14, 29 ], 11, 
  11, [ 14, 32 ], [ 14, 33 ], [ 14, 34 ], 11, 11, 11, 11, [ 14, 39 ], 11, 11, 
  11, 11, [ 14, 42 ], 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, [ 14, 52 ], [ 14, 64 ], [ 14, 65 ], [ 14, 69 ] ],
#V   n = 72
[ ,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], 12, 11, 11, 
  [ 0, 44, "LP" ], [ 14, 10 ], 11, 11, 12, 11, [ 14, 16 ], 11, 11, 11, 
  [ 0, 36, "LP" ], 11, 11, 11, 11, 11, [ 14, 24 ], 11, [ 0, 30, "LP" ], 11, 
  11, 11, [ 0, 27, "LP" ], 11, 11, [ 14, 33 ], [ 14, 34 ], [ 14, 35 ], 11, 
  11, 11, 11, [ 14, 40 ], 11, 11, 11, 11, [ 14, 43 ], 11, 11, 12, 11, 11, 12, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 53 ], [ 14, 65 ], [ 14, 66 ], 
  [ 14, 70 ] ],
#V   n = 73
[ ,,,, [ 14, 3 ],, [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], [ 14, 8 ], 12, 11, 11, 
  11, [ 0, 43, "LP" ], 11, 11, 12, 11, [ 0, 39, "LP" ], 11, 11, 11, 11, 11, 
  11, 11, 11, 11, [ 14, 25 ], 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 34 ], 
  [ 14, 35 ], [ 14, 36 ], 11, 11, 11, 11, [ 14, 41 ], 11, 11, 11, 11, 
  [ 14, 44 ], 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  [ 14, 54 ], [ 14, 66 ], [ 14, 67 ], [ 14, 71 ] ],
#V   n = 74
[ ,,,, [ 14, 3 ], [ 14, 4 ], [ 0, 51, "BK" ], [ 14, 6 ], [ 14, 7 ], 
  [ 0, 48, "BK" ], [ 14, 9 ], 13, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, [ 14, 26 ], 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 14, 35 ], [ 14, 36 ], [ 0, 23, "LP" ], 11, 11, 11, 11, [ 14, 42 ], 11, 
  11, 11, 11, [ 14, 45 ], [ 0, 14, "LP" ], 11, 12, 11, 11, [ 14, 43 ], 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 55 ], [ 14, 67 ], [ 14, 68 ], 
  [ 14, 72 ] ],
#V   n = 75
[ ,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ], 11, [ 0, 50, "BK" ], [ 14, 6 ], 11, 
  [ 0, 47, "BK" ], [ 14, 8 ], 11, 11, 11, 11, [ 0, 42, "LP" ], 11, 12, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 27 ], 11, 11, 11, 11, 11, 11, 
  11, 11, [ 14, 36 ], 12, 11, 11, 11, 11, 11, [ 0, 19, "LP" ], 11, 11, 11, 
  11, 12, 11, 11, 12, 11, 11, [ 14, 44 ], 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, [ 14, 56 ], [ 14, 68 ], [ 14, 69 ], [ 14, 73 ] ],
#V   n = 76
[ ,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], 11, 11, 12, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 14, 28 ], 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 12, 11, 11, 12, 11, 11, [ 0, 10, "sph" ], 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, [ 14, 57 ], [ 14, 69 ], [ 14, 70 ], [ 14, 74 ] ],
#V   n = 77
[ ,,,,, [ 14, 4 ], [ 14, 5 ], [ 14, 6 ], [ 14, 7 ], 11, 11, [ 14, 8 ], 11, 
  11, [ 14, 10 ], [ 0, 45, "LP" ], 11, 11, 11, 11, [ 0, 41, "LP" ], 13, 11, 
  11, [ 0, 38, "LP" ], 11, 11, 11, [ 0, 35, "LP" ], 11, 11, 11, 11, 
  [ 14, 29 ], 11, 11, [ 0, 29, "LP" ], 11, 11, 11, [ 0, 26, "LP" ], 11, 12, 
  12, 11, [ 0, 22, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 58 ], [ 14, 70 ], 
  [ 14, 71 ], [ 14, 75 ] ],
#V   n = 78
[ ,,,, [ 14, 3 ],, [ 0, 54, "BK" ], [ 0, 53, "LP" ], [ 14, 7 ], 
  [ 0, 51, "BK" ], 11, 11, [ 14, 9 ], 11, 11, [ 14, 11 ], 11, 11, 11, 11, 11, 
  11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 32, "LP" ], 
  [ 14, 30 ], 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, [ 14, 59 ], [ 14, 71 ], [ 14, 72 ], [ 14, 76 ] ],
#V   n = 79
[ ,,,, [ 14, 3 ], [ 14, 4 ], 12, 11, 11, [ 14, 6 ], 11, [ 0, 50, "BK" ], 
  [ 0, 49, "BK" ], [ 14, 10 ], 11, 11, [ 14, 12 ], 11, 11, 11, 11, 11, 11, 
  13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 31 ], 11, 11, 11, 11, 
  11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 
  12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 60 ], 
  [ 14, 72 ], [ 14, 73 ], [ 14, 77 ] ],
#V   n = 80
[ ,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ], 12, 11, 11, 12, 11, 11, 11, 
  [ 0, 48, "LP" ], 11, 11, [ 14, 13 ], 11, 11, 11, 11, 11, 11, 13, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 32 ], 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 25, "LP" ], 13, 12, 11, 11, 11, 11, 11, 11, [ 0, 18, "sph" ], 11, 11, 
  11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  [ 14, 61 ], [ 14, 73 ], [ 14, 74 ], [ 14, 78 ] ],
#V   n = 81
[ ,,,, [ 14, 3 ], [ 14, 4 ], [ 0, 56, "LP" ], [ 14, 6 ], 12, 11, 11, 
  [ 14, 8 ], 11, 11, 11, 11, 11, 11, [ 14, 14 ], 11, [ 0, 44, "LP" ], 11, 11, 
  11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 33 ], 11, 11, 
  11, 11, 11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 
  11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 62 ], 
  [ 14, 74 ], [ 14, 75 ], [ 14, 79 ] ],
#V   n = 82
[ ,,,,, [ 0, 58, "LP" ], 12, 11, [ 14, 7 ], [ 0, 54, "BK" ], 11, 11, 
  [ 14, 9 ], 11, 11, 11, 11, [ 0, 47, "LP" ], 11, [ 14, 15 ], 11, 11, 
  [ 0, 43, "LP" ], 11, 11, 11, [ 0, 40, "LP" ], 11, 11, 11, [ 0, 37, "LP" ], 
  11, 11, 11, 11, 11, 11, 11, [ 14, 34 ], 11, 11, 11, 11, 11, 11, 11, 11, 13, 
  12, 11, 11, [ 0, 21, "LP" ], 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 63 ], [ 14, 75 ], 
  [ 14, 76 ], [ 14, 80 ] ],
#V   n = 83
[ ,,,, [ 14, 3 ], 12, 11, 12, 11, 12, 11, [ 0, 53, "BK" ], [ 0, 52, "LP" ], 
  [ 14, 10 ], 11, 11, 11, 11, 11, 11, [ 14, 16 ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, [ 0, 34, "LP" ], 11, 11, 11, [ 14, 35 ], 11, 
  11, 11, [ 0, 28, "LP" ], 11, 11, 11, 11, 13, 12, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 12, 11, 11, [ 0, 12, "sph" ], 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, [ 14, 64 ], [ 14, 76 ], [ 14, 77 ], [ 14, 81 ] ],
#V   n = 84
[ ,,,, [ 14, 3 ], [ 14, 4 ], 12, 11, 12, 11, 12, 11, 11, 11, [ 0, 51, "LP" ], 
  [ 0, 50, "LP" ], 11, 11, 11, 11, [ 0, 46, "LP" ], [ 14, 17 ], 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 31, "LP" ],
  11, 11, 11, 11, 11, 11, 11, 11, 13, 13, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 16, "sph" ], 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, [ 14, 65 ], [ 14, 77 ], [ 14, 78 ], [ 14, 82 ] ],
#V   n = 85
[ ,,,, [ 14, 3 ], [ 14, 4 ], [ 14, 5 ], 13, 11, [ 0, 56, "BK" ], 11, 12, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, [ 14, 18 ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, [ 0, 24, "LP" ], 13, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 66 ], 
  [ 14, 78 ], [ 14, 79 ], [ 14, 83 ] ],
#V   n = 86
[ ,,,, [ 14, 3 ], [ 0, 61, "LP" ], [ 0, 60, "BK" ], [ 0, 59, "LP" ], 13, 12, 
  11, 11, [ 0, 54, "LP" ], 11, 11, 11, 11, 11, [ 0, 49, "LP" ], 11, 11, 11, 
  11, [ 14, 19 ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 
  11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, [ 14, 67 ], [ 14, 64 ], [ 14, 80 ], [ 14, 84 ] ],
#V   n = 87
[ ,,,, [ 0, 63, "LP" ], 12, 11, 11, 11, 12, 12, 11, 12, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, [ 14, 20 ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 27, "LP" ], 11, 
  11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 68 ], [ 14, 65 ], 
  [ 14, 81 ], [ 14, 85 ] ],
#V   n = 88
[ ,,,,, 11, 13, 11, 11, 11, 12, 12, 11, 12, 11, [ 0, 53, "LP" ], 11, 11, 11, 
  11, 11, 11, 11, 11, 11, [ 0, 45, "LP" ], 11, 11, 11, [ 0, 42, "LP" ], 11, 
  11, 11, [ 0, 39, "LP" ], 11, 11, 11, [ 0, 36, "LP" ], 11, 11, 11, 11, 11, 
  11, 11, [ 0, 30, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 
  11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, [ 14, 69 ], [ 14, 66 ], [ 14, 82 ], [ 14, 86 ] ],
#V   n = 89
[ ,,,,,, [ 0, 62, "BK" ], 13, 11, [ 0, 59, "BK" ], 11, 12, 13, 11, 12, 11, 
  11, [ 0, 52, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 13, 11, 11, 11, [ 0, 20, "sph" ], 11, 11, 11, 12, 11, 
  11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  [ 14, 70 ], [ 14, 67 ], [ 14, 83 ], [ 14, 87 ] ],
#V   n = 90
[ ,,,,,, 12, 11, 13, 12, 11, 11, [ 0, 57, "LP" ], 13, 11, 13, 11, 11, 11, 11, 
  11, 11, 11, [ 0, 48, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, [ 0, 33, "LP" ], 11, 11, 11, 11, 11, 11, 
  11, 11, [ 0, 26, "LP" ], 11, 11, 11, [ 0, 23, "LP" ], [ 0, 22, "LP" ], 11, 
  11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, [ 14, 71 ], [ 14, 68 ], [ 14, 84 ], [ 14, 88 ] ],
#V   n = 91
[ ,,,,,,, 12, 11, 12, 12, 11, 12, 11, 13, [ 0, 55, "LP" ], 13, 11, 11, 11, 
  [ 0, 51, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 44, "LP" ], 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 
  [ 0, 14, "sph" ], 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, [ 14, 72 ], [ 14, 69 ], [ 14, 85 ], [ 14, 89 ] ],
#V   n = 92
[ ,,,,,, [ 0, 64, "LP" ],, 12, 11, 12, 12, 11, 12, 11, 12, 11, 13, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 41, "LP" ], 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 73 ], [ 14, 70 ], 
  [ 14, 86 ], [ 14, 90 ] ],
#V   n = 93
[ ,,,,,, [ 14, 4 ], 11,, [ 0, 62, "LP" ], 11, 12, 13, 11, 12, 11, 12, 11, 
  [ 0, 54, "LP" ], 11, 11, 11, 11, [ 0, 50, "LP" ], 11, 11, 11, 
  [ 0, 47, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 38, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 18, "sph" ], 11, 12, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  [ 14, 74 ], [ 14, 71 ], [ 14, 87 ], [ 14, 91 ] ],
#V   n = 94
[ ,,,,,, [ 14, 4 ], 12, 11, 12, 11, 11, [ 0, 60, "LP" ], 13, 11, 13, 11, 12, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 75 ], [ 14, 72 ], 
  [ 14, 88 ], [ 14, 92 ] ],
#V   n = 95
[ ,,,,,, [ 14, 4 ], 12, [ 14, 6 ], 11, 12, 11, 12, 11, 13, [ 0, 58, "LP" ], 
  13, 11, 12, 11, 11, [ 0, 53, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 35, "LP" ], 
  11, 11, 11, [ 0, 32, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, [ 14, 76 ], [ 14, 73 ], [ 14, 89 ], 
  [ 14, 93 ] ],
#V   n = 96
[ ,,,,,,, 12, [ 14, 6 ], [ 14, 7 ], 11, 12, 11, 12, 11, 12, 11, 13, 11, 12, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, [ 0, 8, "sph" ], 11, 11, 12, 11, 11, 12, 11, 11, 
  [ 14, 77 ], [ 14, 74 ], [ 14, 90 ], [ 14, 94 ] ],
#V   n = 97
[ ,,,,,, [ 0, 68, "LP" ],, [ 14, 6 ], [ 0, 65, "LP" ], [ 14, 8 ], 11, 
  [ 0, 62, "LP" ], 11, 12, 11, 12, 11, [ 0, 57, "LP" ], 11, 13, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, [ 0, 46, "LP" ], 11, 11, 11, 
  [ 0, 43, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 
  11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 11, 12, 11, 11, 12, 
  11, 11, [ 14, 78 ], [ 14, 75 ], [ 14, 91 ], [ 14, 95 ] ],
#V   n = 98
[ ,,,,,, [ 14, 4 ], 11,, 12, 11, [ 0, 64, "LP" ], 12, 11, 11, 13, 11, 12, 11, 
  11, [ 0, 56, "LP" ], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, [ 0, 40, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 11, 12, 
  11, 11, 12, 11, 11, [ 14, 79 ], [ 14, 76 ], [ 14, 92 ], [ 14, 96 ] ],
#V   n = 99
[ ,,,,, [ 0, 71, "LP" ], [ 14, 4 ], 12, 11, 13, 12, 11, 11, 12, 11, 
  [ 0, 61, "LP" ], [ 0, 60, "LP" ], 11, 13, 11, 11, 11, 13, 11, 11, 11, 
  [ 0, 52, "LP" ], 11, 11, 11, [ 0, 49, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 
  [ 0, 16, "sph" ], 11, 12, 11, 11, 12, 11, 11, [ 0, 10, "sph" ], 11, 12, 11, 
  11, 11, [ 0, 6, "sph" ], 11, 11, 12, 11, 11, [ 14, 80 ], [ 14, 77 ], 
  [ 14, 93 ], [ 14, 97 ] ],
#V   n = 100
[ ,,,,,, 11, 12, [ 14, 6 ], [ 0, 67, "BK" ], 13, 12, 11, 11, 12, 11, 11, 11, 
  [ 0, 59, "LP" ], 13, 11, 11, 11, [ 0, 55, "LP" ], 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 37, "LP" ], 11, 11, 11, [ 0, 34, "LP" ], 11, 11, 11, [ 0, 31, "LP" ], 
  11, 11, [ 0, 29, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, [ 14, 81 ], [ 14, 78 ], [ 14, 94 ], [ 14, 98 ] ],
#V   n = 101
[ ,,,,,, [ 0, 71, "LP" ], 11, [ 14, 6 ], 12, 11, 13, [ 0, 65, "LP" ], 11, 11, 
  13, 11, 11, 11, 11, 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 20, "sph" ], 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 11, 12, 11, 11, [ 14, 82 ], [ 14, 79 ], [ 14, 95 ], 
  [ 14, 99 ] ],
#V   n = 102
[ ,,,,,, [ 14, 4 ], 11, 11, 12, 12, 11, 12, 11, 11, [ 0, 63, "LP" ], 13, 11, 
  11, 11, 11, [ 0, 58, "LP" ], 11, 11, 11, 11, [ 0, 54, "LP" ], 11, 11, 11, 
  11, 11, 11, 11, [ 0, 48, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, [ 14, 83 ], [ 14, 80 ], 
  [ 14, 96 ], [ 14, 100 ] ],
#V   n = 103
[ ,,,,,, [ 14, 4 ], 12, 11, 13, 12, 12, 11, 12, 11, 12, 11, 13, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, [ 0, 51, "LP" ], 11, 11, 11, 11, 
  11, 11, 11, [ 0, 45, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, [ 14, 84 ], [ 14, 81 ], [ 14, 97 ], 
  [ 14, 101 ] ],
#V   n = 104
[ ,,,,,, [ 14, 4 ], 12, [ 14, 6 ], [ 0, 70, "LP" ], 13, 12, 13, 11, 12, 11, 
  12, 11, [ 0, 62, "LP" ], 11, 11, 11, 11, 11, [ 0, 57, "LP" ], 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 
  [ 0, 12, "sph" ], 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  [ 14, 85 ], [ 14, 82 ], [ 14, 98 ], [ 14, 102 ] ],
#V   n = 105
[ ,,,,,, [ 0, 74, "BK" ], 13, [ 14, 6 ], 12, 11, 13, [ 0, 68, "LP" ], 
  [ 0, 67, "LP" ], 11, 13, 11, 12, 11, 11, 11, [ 0, 60, "LP" ], 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, [ 0, 42, "LP" ], 11, 11, 11, [ 0, 39, "LP" ], 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 
  11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, [ 14, 86 ], [ 14, 83 ], [ 14, 99 ], [ 14, 103 ] ],
#V   n = 106
[ ,,,,,, 12, 11, [ 14, 6 ], 12, 12, 11, 12, 11, 11, [ 0, 66, "LP" ], 
  [ 0, 65, "LP" ], 11, 13, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, [ 0, 50, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, [ 0, 24, "sph" ], 11, 11, 11, 12, 11, 11, 12, 11, 12, 
  11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 
  11, [ 14, 87 ], [ 14, 84 ], [ 14, 100 ], [ 14, 104 ] ],
#V   n = 107
[ ,,,,,, [ 14, 4 ], 12, 11, 13, 13, 12, 11, 12, 11, 11, 11, 11, 
  [ 0, 64, "LP" ], 13, 11, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 
  11, 11, 11, 11, 12, 11, 11, [ 0, 18, "sph" ], 11, 12, 11, 11, 12, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, [ 14, 88 ], 
  [ 14, 85 ], [ 14, 101 ], [ 14, 105 ] ],
#V   n = 108
[ ,,,, [ 0, 79, "LP" ],, [ 14, 4 ], 12, 12, [ 0, 73, "LP" ], [ 0, 72, "LP" ], 
  13, 13, 11, 12, 11, 11, 11, 11, 11, 13, 11, 11, 12, 11, 11, 11, 11, 11, 
  [ 0, 56, "LP" ], 11, 11, 11, [ 0, 53, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 12, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, [ 14, 89 ], [ 14, 86 ], [ 14, 102 ], [ 14, 106 ] ],
#V   n = 109
[ ,,,,, 11, [ 0, 77, "LP" ], 13, [ 14, 6 ], 12, 11, 11, [ 0, 71, "LP" ], 
  [ 0, 70, "LP" ], 11, 13, 11, 11, 11, 11, 11, [ 0, 63, "LP" ], 11, 11, 12, 
  11, [ 0, 59, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, [ 0, 47, "LP" ], 11, 11, 11, [ 0, 44, "LP" ], 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 12, 11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, [ 14, 90 ], [ 14, 87 ], 
  [ 14, 103 ], [ 14, 107 ] ],
#V   n = 110
[ ,,,,,, 12, 11, [ 0, 76, "LP" ], 12, 12, 11, 11, 11, 11, [ 0, 69, "LP" ], 
  [ 0, 68, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 12, 11, 11, [ 0, 22, "sph" ], 11, 12, 11, 12, 11, 11, 12, 
  11, 11, [ 0, 14, "sph" ], 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 11, 12, 11, 11, [ 14, 91 ], [ 14, 88 ], [ 14, 104 ], [ 14, 108 ] ],
#V   n = 111
[ ,,,,,, 12, 12, 11, 11, 13, 12, 11, 11, 11, 11, 11, 11, [ 0, 67, "LP" ], 
  [ 0, 66, "LP" ], 11, 11, 11, 11, [ 0, 62, "LP" ], 11, 12, 11, 11, 
  [ 0, 58, "LP" ], 11, 11, 11, [ 0, 55, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 12, 11, 11, 
  12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, [ 14, 92 ], [ 14, 89 ], [ 14, 105 ], 
  [ 14, 109 ] ],
#V   n = 112
[ ,,,,,,, 12, 12, [ 0, 76, "LP" ], [ 0, 75, "LP" ], 13, 13, [ 0, 72, "LP" ], 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, [ 0, 52, "LP" ], 11, 11, 11, [ 0, 49, "LP" ], 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 12, 
  11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  11, 12, 11, 11, [ 14, 93 ], [ 14, 90 ], [ 14, 106 ], [ 14, 110 ] ],
#V   n = 113
[ ,,,,,, [ 14, 4 ],, 13, 12, 11, 11, [ 0, 74, "LP" ], 12, 11, [ 0, 71, "LP" ],
  [ 0, 70, "LP" ], 11, 11, 11, 11, 11, [ 0, 65, "LP" ], 11, 11, 11, 11, 11, 
  13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, [ 0, 28, "sph" ], 11, 11, 11, 12, 11, 12, 11, 11, 
  12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, [ 14, 94 ], [ 14, 91 ], [ 14, 107 ], 
  [ 14, 111 ] ],
#V   n = 114
[ ,,,,,, [ 14, 4 ], 11, [ 0, 79, "LP" ], 12, 12, 11, 11, 11, 12, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, [ 0, 64, "LP" ], 11, 11, 11, [ 0, 61, "LP" ], 13, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 
  12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 
  11, 11, [ 14, 95 ], [ 14, 92 ], [ 14, 108 ], [ 14, 112 ] ],
#V   n = 115
[ ,,,,,, [ 14, 4 ], 11, [ 14, 6 ], 11, 13, 12, 11, 11, 11, 12, 11, 11, 11, 
  [ 0, 69, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 13, 11, 11, 11, 
  11, 11, 11, 11, [ 0, 54, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, [ 0, 26, "sph" ], 11, 12, 11, 12, 11, 11, 
  12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, [ 14, 96 ], [ 14, 93 ], [ 14, 109 ], 
  [ 14, 113 ] ],
#V   n = 116
[ ,,,,,, [ 14, 4 ], 13, [ 14, 6 ], [ 0, 79, "LP" ], [ 0, 78, "LP" ], 13, 
  [ 0, 76, "LP" ], [ 0, 75, "LP" ], 11, 11, 13, 11, 11, 11, 11, 
  [ 0, 68, "LP" ], 11, 11, 11, 11, 11, [ 0, 63, "LP" ], 11, 11, 11, 13, 11, 
  11, 11, [ 0, 57, "LP" ], 11, 11, 11, 11, 11, 11, 11, [ 0, 51, "LP" ], 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 
  11, [ 0, 20, "sph" ], 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, [ 14, 97 ], [ 14, 94 ], 
  [ 14, 110 ], [ 14, 114 ] ],
#V   n = 117
[ ,,,,,, [ 0, 83, "LP" ], [ 0, 82, "LP" ], [ 14, 6 ], 12, 11, 11, 12, 11, 11, 
  [ 0, 74, "LP" ], [ 0, 73, "LP" ], 13, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, [ 0, 60, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 
  12, 11, 12, 11, 12, 11, 11, 12, 11, 11, [ 0, 16, "sph" ], 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, [ 14, 82 ], 11, 11, 
  [ 14, 98 ], [ 14, 95 ], [ 14, 111 ], [ 14, 115 ] ],
#V   n = 118
[ ,,,,,, [ 14, 4 ], 11, 11, 12, 13, 11, 11, 13, 11, 11, 11, 11, 
  [ 0, 72, "LP" ], [ 0, 71, "LP" ], 11, 11, 11, 11, [ 0, 67, "LP" ], 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 
  11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 11, [ 14, 83 ], 11, 11, [ 14, 99 ], [ 14, 96 ], 
  [ 14, 112 ], [ 14, 116 ] ],
#V   n = 119
[ ,,,,,, [ 14, 4 ], 12, 11, 11, [ 0, 80, "LP" ], 13, 11, [ 0, 77, "LP" ], 13, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 12, 11, 11, [ 0, 24, "sph" ], 11, 12, 11, 12, 
  11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 11, 12, 11, 11, [ 14, 100 ], [ 14, 97 ], [ 14, 113 ], 
  [ 14, 117 ] ],
#V   n = 120
[ ,,,,, [ 0, 87, "BK" ], [ 0, 85, "BK" ], 13, [ 14, 6 ], [ 0, 82, "BK" ], 12, 
  11, [ 0, 79, "LP" ], 12, 11, 13, [ 0, 75, "LP" ], 11, 11, 11, 11, 11, 
  [ 0, 70, "LP" ], 11, 11, 11, 11, [ 0, 66, "LP" ], 11, 11, 11, 11, 
  [ 0, 62, "LP" ], 11, 11, 11, [ 0, 59, "LP" ], 11, 11, 11, [ 0, 56, "LP" ], 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 
  12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 12, 11, 11, 
  [ 14, 101 ], [ 14, 98 ], [ 14, 114 ], [ 14, 118 ] ],
#V   n = 121
[ ,,,,,, 12, 11, [ 14, 6 ], 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 30, "sph" ], 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 
  11, [ 0, 4, "sph" ], 11, 11, [ 14, 102 ], [ 14, 99 ], [ 14, 115 ], 
  [ 14, 119 ] ],
#V   n = 122
[ ,,,,,, 12, 12, 11, 12, 13, 11, 12, 11, 11, 12, 11, 12, 11, [ 0, 74, "LP" ], 
  11, 11, 11, 11, 11, [ 0, 69, "LP" ], 11, 11, 11, 11, [ 0, 65, "LP" ], 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 
  12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 11, [ 14, 103 ], [ 14, 100 ], [ 14, 116 ], 
  [ 14, 120 ] ],
#V   n = 123
[ ,,,,,, [ 14, 4 ], 12, 12, 11, [ 0, 83, "LP" ], 13, 11, [ 0, 80, "LP" ], 11, 
  11, 13, 11, 12, 11, 11, [ 0, 73, "LP" ], [ 0, 72, "LP" ], 11, 11, 11, 11, 
  [ 0, 68, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, 
  [ 14, 104 ], [ 14, 101 ], [ 14, 117 ], [ 14, 121 ] ],
#V   n = 124
[ ,,,,,, [ 0, 88, "LP" ], [ 14, 5 ], 13, [ 0, 85, "LP" ], 12, 11, 
  [ 0, 82, "LP" ], 12, 11, 11, [ 0, 78, "LP" ], 13, 11, 13, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  [ 0, 58, "LP" ], 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, [ 0, 28, "sph" ], 11, 12, 11, 12, 11, 11, 
  [ 0, 22, "sph" ], 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, [ 14, 105 ], 
  [ 14, 102 ], [ 14, 118 ], [ 14, 122 ] ],
#V   n = 125
[ ,,,,,, 12, 11, [ 0, 87, "LP" ], 12, 11, 12, 11, 11, 12, 11, 12, 11, 13, 
  [ 0, 76, "LP" ], 13, 11, 11, 11, 11, [ 0, 71, "LP" ], 11, 11, 11, 11, 
  [ 0, 67, "LP" ], 11, 11, 11, [ 0, 64, "LP" ], 11, 11, 11, [ 0, 61, "LP" ], 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 12, 11, 11, 12, 11, 11, 
  [ 0, 18, "sph" ], 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 11, [ 14, 106 ], [ 14, 103 ], [ 14, 119 ], 
  [ 14, 123 ] ],
#V   n = 126
[ ,,,,,, 12, 12, 11, 11, 13, 11, 12, 11, 11, 12, 11, 12, 11, 12, 11, 13, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 12, 11, 11, 12, 11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 11, [ 14, 107 ], [ 14, 104 ], [ 14, 120 ], [ 14, 124 ] ],
#V   n = 127
[ ,,,,,, 13, 12, 12, 11, [ 0, 86, "LP" ], 13, 11, [ 0, 83, "LP" ], 11, 11, 
  [ 0, 80, "LP" ], 11, 12, 11, 12, 11, [ 0, 75, "LP" ], 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 
  11, 11, [ 0, 26, "sph" ], 11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 11, [ 14, 108 ], [ 14, 105 ], [ 14, 121 ], [ 14, 125 ] ],
#V   n = 128
[ ,,,,,, [ 0, 91, "LP" ], 13, 13, [ 0, 88, "LP" ], 12, 11, [ 0, 85, "LP" ], 
  12, 11, 11, 12, 11, 11, 13, 11, 12, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 12, 11, 
  11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, [ 14, 109 ], 
  [ 14, 106 ], [ 14, 122 ], [ 14, 126 ] ],
#V   n = 129
[ ,,,,,, 12, 11, [ 0, 90, "LP" ], 12, 11, 12, 11, 11, 12, 11, 12, 12, 11, 
  [ 0, 79, "LP" ], 13, 11, 13, 11, 11, [ 0, 74, "LP" ], 11, 11, 11, 11, 
  [ 0, 70, "LP" ], 11, 11, 11, 11, [ 0, 66, "LP" ], 11, 11, 11, 
  [ 0, 63, "LP" ], 11, 11, 11, [ 0, 60, "LP" ], 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 11, 12, 
  11, 11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 
  11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 12, 11, 11, 11, [ 14, 110 ], 
  [ 14, 107 ], [ 14, 123 ], [ 14, 127 ] ],
#V   n = 130
[ ,,,,,, 12, 12, 11, 11, [ 0, 88, "LP" ], 11, 12, [ 0, 85, "LP" ], 11, 12, 
  11, 12, 12, 11, 11, 12, [ 0, 77, "LP" ], 12, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 
  11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 
  11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 12, 11, 11, 12, 11, 11, 12, 11, 
  11, [ 0, 12, "sph" ], 11, 11, [ 0, 10, "sph" ], 11, 11, 12, 11, 11, 12, 11, 
  11, 12, 11, 11, 11, 12, 11, 11, 11 ]];