##
## Print Banner
##

Print("#I -- OpenMath share package -- \n"); 
Print("#I -- Andrew Solomon -- \n"); 




#################################################################
##
##  DefineTokens()
##
##  Look through the include file binding "gapOM..." names to values,
##  but deleting the "gap" prefix.
##

DefineTokens := function()

  local inf, s, sp, infile;
  
	infile := Filename(DirectoriesPackageLibrary("openmath","include"), "gap_tokens.h");
  inf := InputTextFile(infile);


  s := ReadLine(inf);
  while s <> fail do
    # if it is a definition line, then read the definition
    if Length(s) >= 3 and s{[1..3]} = "gap" then
      sp := SplitString(s,','," \t\n");
      #Print("Operation : BindGlobal(",sp[1]{[4 .. Length(sp[1])]},",",
				#Int(sp[3]),")\n");
      BindGlobal(sp[1]{[4 .. Length(sp[1])]}, Int(sp[3]));
    fi;
    s := ReadLine(inf);
  od;
end;

DefineTokens();
Unbind(DefineTokens);

# these files are concerned with outputting OpenMath

ReadPkg("openmath","/gap/omput.gd");
ReadPkg("openmath","/gap/omput.gi");


# Frank Luebeck's utility for obtaining view strings.
ReadPkg("openmath", "/gap/printutil.g");

# these files are required for reading an  OpenMath encoded object 
# from a stream

ReadPkg("openmath", "/gap/lex.g");
ReadPkg("openmath", "/gap/gap.g");
ReadPkg("openmath", "/gap/parse.gd");
ReadPkg("openmath", "/gap/parse.gi");
ReadPkg("openmath", "/gap/pipeobj.g");
ReadPkg("openmath", "/gap/omget.gd");
ReadPkg("openmath", "/gap/omget.g");

# a function for testing OMGetObject.OMPutObject = id
ReadPkg("openmath", "/gap/test.gd");
ReadPkg("openmath", "/gap/test.g");



#################################################################
#E
