#############################################################################
##
#W    compat.g           share package 'polycyclic'              Bettina Eick
#W                                                              Werner Nickel
##
##    This file contains code that makes  sure that this package is backwards
##    compatible with older versions of GAP 4.
##

if not CompareVersionNumbers( VERSION, "4.3" ) then
    ##
    ##    With 4.3 the components !.generators and !.genimages of a
    ##    group general mapping were moved into one component called
    ##    MappingGeneratorsImages.  To remain compatible with 4.1
    ##    and 4.2 we keep the old components as well.  This affects
    ##    the methods in gap/basic/grphoms.gi that build a general
    ##    group mapping. 
    ##
    ##    Since the attribute MappingGeneratorsImages is used in
    ##    the code, we have to declare it here.
    ##
    if not IsBound( MappingGeneratorsImages ) then
        DeclareAttribute( "MappingGeneratorsImages", IsGeneralMapping );
    fi;

fi;
