#############################################################################
##
#W  convert.gi                   Polycyc                         Bettina Eick
##

#############################################################################
##
## Convert finite pcp groups to pcp groups.
##
PcpGroupToPcGroup := function( G )
    local pcp, rel, n, F, f, i, rws, h, e, w, j;

    pcp := Pcp( G );
    rel := RelativeOrdersOfPcp( pcp );
    if ForAny( rel, x -> x = 0 ) then return fail; fi;
 
    n := Length( pcp );
    F := FreeGroup( n );
    f := GeneratorsOfGroup( F );
    
    rws := SingleCollector( f, rel );
    for i in [1..n] do

        # set power
        h := pcp[i] ^ rel[i];
        e := ExponentsByPcp( pcp, h );
        w := MappedVector( e, f );
        SetPower( rws, i, w );

        # set conjugates
        for j in [1..i-1] do
            h := pcp[i]^pcp[j];
            e := ExponentsByPcp( pcp, h );
            w := MappedVector( e, f );
            SetConjugate( rws, i, j, w );
        od;
    od;
    return GroupByRwsNC( rws );
end;

InstallMethod( IsomorphismPcGroup, true, [IsPcpGroup], 0, 
function( G )
    local H, hom;
    H := PcpGroupToPcGroup( G );
    if H = fail then return fail; fi;
    hom := GroupHomomorphismByImagesNC( G, H, 
           AsList(Pcp(G)), AsList(Pcgs(H)) );
    SetIsInjective( hom, true );
    return hom;
end );

#############################################################################
##
## Convert pc groups to pcp groups.
##
PcGroupToPcpGroup := function( G )
    local g, r, n, i, coll, h, e, w, j;

    g := Pcgs( G );
    r := RelativeOrders( g ); 
    n := Length( g );

    coll := FromTheLeftCollector( n );
    for i in [1..n] do

        # set power
        h := g[i] ^ r[i];
        e := ExponentsOfPcElement( g, h );
        w := ObjByExponents( coll, e );
        SetRelativeOrder( coll, i, r[i] );
        SetPower( coll, i, w );

        # set conjugates
        for j in [1..i-1] do
            h := g[i]^g[j];
            e := ExponentsOfPcElement( g, h );
            w := ObjByExponents( coll, e );
            SetConjugate( coll, i, j, w );

            h := g[i]^(g[j]^-1);
            e := ExponentsOfPcElement( g, h );
            w := ObjByExponents( coll, e );
            SetConjugate( coll, i, -j, w );
        od;
    od;

    return PcpGroupByCollector( coll );
end;

InstallMethod( IsomorphismPcpGroup, true, [IsPcGroup], 0,
function( G )
    local H, hom;
    H := PcGroupToPcpGroup( G );
    hom := GroupHomomorphismByImagesNC( G, H, AsList(Pcgs(G)), AsList(Pcp(H)));
    SetIsInjective( hom, true );
    return hom;
end );

InstallMethod( IsomorphismPcpGroup, true, [IsPermGroup], 0,
function( G )
    local iso, F,H, gens, hom;
    if not IsSolvableGroup( G ) then return fail; fi;
    iso  := IsomorphismPcGroup( G );
    F    := Image( iso );
    H    := PcGroupToPcpGroup( F );
    gens := List( Pcgs(F), x -> PreImagesRepresentative( iso, x ) );
    hom  := GroupHomomorphismByImagesNC( G, H, gens, AsList(Pcp(H)) );
    SetIsInjective( hom, true );
    return hom;
end );
                      
