#############################################################################
##
#W  examples.gi              Polycyc                                  BE & WN
##
##  Some examples of pcp groups -- PcpExamples
##

#############################################################################
##
##  Each group in this file should be appended to the following list.
##  This makes looping over all examples for test purposes easy.
##
PcpExamples := [];


#############################################################################
##
##                                             [ 0 1 ]   [ -1  0 ] 
##  The semidirect product of the matrices     [ 1 1 ],  [  0 -1 ]
##
##  and Z^2.  We let the generator corresponding to the second matrix
##  have infinite order. 
##
Add( PcpExamples, 
     SplitExtensionPcpGroup( AbelianPcpGroup( 2, [] ), 
                             [ [[0,1],[1,1]], [[-1,0],[0,-1]] ] ) );

#############################################################################
##
##  The following matrices are a basis of the fundamental units of the
##  order defined by the polynomials x^4 - x - 1
##
Add( PcpExamples, 
       SplitExtensionPcpGroup( AbelianPcpGroup( 2, [] ), 
       [ [ [ 0,1,0,0 ],  [ 0,0,1,0 ],  [ 0,0,0,1 ],  [ 1,1,0,0 ] ],
       [ [ 1,1,0,-1 ], [ -1,0,1,0 ], [ 0,-1,0,1 ], [ 1,1,-1,0 ] ] ] ) );

#############################################################################
##
##  Z split Z 
##
FTL := FromTheLeftCollector( 2 );
SetConjugate( FTL, 2,  1, [2,-1] );
SetConjugate( FTL, 2, -1, [2,-1] );
Add( PcpExamples, PcpGroupByCollector(FTL) );

#############################################################################
##
##  A gr oup of Hirsch length 3.  Interesting because the exponents in
##  words can become large very quickly.
##
FTL := FromTheLeftCollector( 3 );
SetConjugate( FTL, 2, 1, [3, 1] );
SetConjugate( FTL, 3, 1, [2, 1, 3, 7] );
#SetConjugate( FTL, 2,-1, [2,-7, 3, 1] );
#SetConjugate( FTL, 3,-1, [2, 1] );
Add( PcpExamples, PcpGroupByCollector(FTL) );

#############################################################################
##
##  A torsion free polycyclic group which is not nilpotent. It is
##  taken vom Robinson's book, page 158.
##
FTL := FromTheLeftCollector( 4 );
SetRelativeOrder( FTL, 1, 2 );
SetPower( FTL, 1, [4,1] );
SetConjugate( FTL, 2,1, [2,-1] );
SetConjugate( FTL, 3,1, [3,-1] );
SetConjugate( FTL, 3,2, [3,1,4,2] );
Add( PcpExamples, PcpGroupByCollector(FTL) );

#############################################################################
##
## This is S_3.
##
FTL := FromTheLeftCollector( 2 );
SetRelativeOrder( FTL, 1, 2 );
SetRelativeOrder( FTL, 2, 3 );
SetConjugate( FTL, 2, 1, [2,2] );
Add( PcpExamples, PcpGroupByCollector(FTL) );

#############################################################################
##
## 4 polycyclic groups from Lo/Ostheimer paper on finding matrix reps
## for pc groups. They are all non-nilpotent, but poly-Z
##
FTL := FromTheLeftCollector( 3 );
SetConjugate( FTL, 2, 1, [2,2,3,1]);
SetConjugate( FTL, 3, 1, [2,1,3,1]);
Add( PcpExamples, PcpGroupByCollector(FTL) );

FTL := FromTheLeftCollector( 4 );
SetConjugate( FTL, 2, 1, [3,1] );
SetConjugate( FTL, 3, 1, [2,-1, 3,3, 4,1] );
SetConjugate( FTL, 3, 2, [3,1,4,-1]);
Add( PcpExamples, PcpGroupByCollector(FTL) );

FTL := FromTheLeftCollector( 5 );
SetConjugate( FTL, 2, 1, [2,1,4,-1]);
SetConjugate( FTL, 3, 2, [5,1]);
SetConjugate( FTL, 4, 2, [3,1,4,-1,5,1]);
SetConjugate( FTL, 5, 2, [4,1]);
Add( PcpExamples, PcpGroupByCollector(FTL) );

FTL := FromTheLeftCollector( 3 );
SetConjugate( FTL, 2, 1, [2,1,3,-3] );
SetConjugate( FTL, 3, 1, [3,-1] );
SetConjugate( FTL, 3, 2, [3,-1] );
Add( PcpExamples, PcpGroupByCollector(FTL) );

#############################################################################
##
## a pc group from Eddie's preprint on `low index for pc groups'
##
FTL := FromTheLeftCollector( 4 );
SetConjugate( FTL, 2, 1, [2,-1] );
SetConjugate( FTL, 4, 1, [4,-1] );
SetConjugate( FTL, 3, 2, [3,2,4,1]);
SetConjugate( FTL, 4, 2, [3,3,4,2]);
Add( PcpExamples, PcpGroupByCollector(FTL) );


#############################################################################
##
##  At last, clean the variable FTL.
##
Unbind( FTL );
