
# from Eddie's paper on low index
EddiesExamples := [];

#############################################################################
##
## G1 is free nilpotent of rank 2 and class 3.
##
FLT := FromTheLeftCollector( 5 );
SetConjugate( FLT, 2, 1, [2,1,3, 1] );
SetConjugate( FLT, 3, 1, [3,1,4, 1] );
SetConjugate( FLT, 3, 2, [3,1,5, 1] );
#SetFeatureObj( FLT, UseKernelCollector, true );
Add( EddiesExamples, PcpGroupByCollector( FLT ) );


#############################################################################
##
## G2 is free nilpotent of rank 3 and class 2.
##
FLT := FromTheLeftCollector( 6 );
SetConjugate( FLT, 2, 1, [2,1,4, 1] );
SetConjugate( FLT, 3, 1, [3,1,5, 1] );
SetConjugate( FLT, 3, 2, [3,1,6, 1] );
#SetFeatureObj( FLT, UseKernelCollector, true );
Add( EddiesExamples, PcpGroupByCollector( FLT ) );

#############################################################################
##
## G3 is given by a pcp presenation
##
FLT := FromTheLeftCollector( 4 );
SetConjugate( FLT, 2, 1, [2,-1] );
SetConjugate( FLT, 4, 1, [4,-1] );
SetConjugate( FLT, 3, 2, [3,2,4,1]);
SetConjugate( FLT, 4, 2, [3,3,4,2]);
#SetFeatureObj( FLT, UseKernelCollector, true );
Add( EddiesExamples, PcpGroupByCollector( FLT ) );

Unbind(FLT);


#############################################################################
##                index       number       time
##
##  G1             27          445          7.87         
##  G1             32         2099         31.48
##
##  G2             27        10336        197.56           
##  G2             32        63091        906.09
##
##  G3             60          646          3.51
##  G3             96         2894         23.45
##
