############################################################################
##
#W  nilpot.gi                   Polycyc                         Bettina Eick
#W                                                             Werner Nickel
##

#############################################################################
##
#F Minimal generating set
##
InstallMethod( MinimalGeneratingSet,
        "nilpotent pcp group",
        true,
        [IsPcpGroup and IsNilpotentGroup],
        0,
function( G )
    return GeneratorsOfPcp( Pcp( G, DerivedSubgroup(G), "snf" ) );
end );

#############################################################################
##
#F NextStepCentralizer
##
PcpNextStepCentralizer := function( gens, cent, pcp )
    local   pcpros,  rels,  i,  g,  newgens,  matrix,  notcentral,  h,  
            pcpgens,  comm,  null,  j,  elm,  r,  l;

    pcpgens := GeneratorsOfPcp( pcp );
    pcpros  := RelativeOrdersOfPcp( pcp );

    ##  Get the relations in this factor group.
    rels := [];
    for i in [1..Length(pcpgens)] do
        if pcpros[i] > 0 then
	    r := ExponentsByPcp( pcp, pcpgens[i]^pcpros[i] );
            r[i] := -pcpros[i];
            Add( rels, r );
        fi;
    od;

    for g in gens do
        if Length( cent ) = 0 then return []; fi;

        newgens := [];
        matrix  := [];
        notcentral := [];
        for h in cent do
            comm := ExponentsByPcp( pcp, Comm( h, g ) );
            if comm = 0 * comm  then
                Add( newgens, h );
            else
                Add( notcentral, h );
                Add( matrix, comm );
            fi;
        od;

        if Length( matrix ) > 0  then
    
            # add the relations to the matrix.
            Append( matrix, rels );

            # get nullspace
            null := NullspaceIntMat( matrix );

            # calculate elements corresponding to null
	    l := Length( notcentral );
            for j  in [1..Length(null)]  do
                elm := MappedVector( null[j]{[1..l]}, notcentral );
                if elm <> elm^0 then
                    Add( newgens, elm );
                fi;
            od;
        fi;
        cent := newgens;
    od;
    return cent;
end;

#############################################################################
##
#F PcpCentreBySeries( G, gens, ser ) . . . . . . . . . . . . .centralise gens
##
PcpCentreBySeries := function( G, gens, ser )
    local  cent, i, pcp;

    cent := ShallowCopy( GeneratorsOfPcp( Pcp( ser[1], ser[2] ) ) );
    for i in [2..Length(ser)-1] do
	pcp  := Pcp( ser[i], ser[i+1] );
        cent := PcpNextStepCentralizer( gens, cent, pcp );
        Append( cent, GeneratorsOfPcp( pcp ) );
    od;
    Append( cent, GeneratorsOfGroup( ser[Length(ser)] ) );
    return cent;
end;


#############################################################################
##
#F CentreNilpotentGroup
##
InstallMethod( Centre,
        "centre for a nilpotent pcp group",
        true,
        [IsPcpGroup and IsNilpotentGroup],
        0,
function( G )
    local  ser, gens, cent;
    if Length(Igs(G)) = 0 then return G; fi;
    ser  := LowerCentralSeries(G);
    gens := GeneratorsOfPcp( Pcp( ser[1], ser[2] ) );
    cent := PcpCentreBySeries( G, gens, ser );
    return Subgroup( G, cent );
end );

#############################################################################
##
#F CentralizerNilpotentGroup
##
InstallMethod( CentralizerOp,
        "for a nilpotent pcp group",
        true,
        [IsPcpGroup and IsNilpotentGroup, IsPcpElement],
        0,
function( G, elm )
    local  ser, gens, cent;
    if Length(Igs(G)) = 0 then return G; fi;
    if not elm in G then TryNextMethod(); fi;
    ser  := LowerCentralSeries(G);
    cent := PcpCentreBySeries( G, [elm], ser );
    return Subgroup( G, cent );
end );

InstallMethod( CentralizerOp,
        "for a nilpotent pcp group",
        true,
        [IsPcpGroup and IsNilpotentGroup, IsPcpGroup],
        0,
function( G, U )
    local  ser, gens, cent;
    if Length(Igs(G)) = 0 then return G; fi;
    if not IsSubgroup( G, U ) then TryNextMethod(); fi;
    SetIsNilpotentGroup( U, true );
    ser  := LowerCentralSeries(G);
    cent := PcpCentreBySeries( G, MinimalGeneratingSet(U), ser );
    return Subgroup( G, cent );
end );

#############################################################################
##
#F UpperCentralSeriesNilpotentGroup( G )
##
InstallMethod( UpperCentralSeriesOfGroup, 
        true, 
        [IsPcpGroup and IsNilpotentGroup], 
        0, 
function( G )
    local ser, gens, C, upp;

    ser  := LowerCentralSeries(G);
    gens := GeneratorsOfPcp( Pcp( ser[1], ser[2] ) );
    C    := TrivialSubgroup( G );
    upp  := [C];
    while Index( G, C ) > 1 do
        ser := ModuloSeries( ser, C );
	C   := PcpCentreBySeries( G, gens, ser );
        C   := Subgroup( G, C );
	Add( upp, C );
    od;
    return Reversed( upp );
end );

