#############################################################################
##
#W  notyet.gi                  Polycyc                           Bettina Eick
##

InstallMethod( SylowSubgroup, true, [IsPcpGroup, IsInt and IsPosRat], 0, 
function( G, p )
    if not IsFinite(Size(G)) then 
        Error("sorry: not yet installed");
    fi;
    TryNextMethod();
end );

#InstallMethod( Normalizer , true, [IsPcpGroup, IsPcpGroup], 0, 
#function( G, H )
#    Error("sorry: not yet installed");
#end );

#InstallMethod( Centralizer , true, [IsPcpGroup, IsPcpGroup], 0, 
#function( G, H )
#    Error("sorry: not yet installed");
#end );

InstallMethod( Centre, true, [IsPcpGroup], 0, 
function( G )
    if not IsNilpotent(G) then 
        Error("sorry: centre for non-nilpotent groups not yet installed");
    fi;
    TryNextMethod();
end );

InstallMethod( Intersection2, true, [IsPcpGroup, IsPcpGroup], 0, 
function( U, V )
    local G;

    # Check the parent and catch a trivial case
    G := Parent( U );
    if G <> Parent( V ) then return []; fi;    

    # check for trivial cases
    if IsInt(Size(U)) and IsInt(Size(V)) then 
        if IsInt(Size(V)/Size(U)) and ForAll(Igs(U), x -> x in V ) then
            return U;
        elif Size(V)<Size(U) and IsInt(Size(U)/Size(V))
             and ForAll( Igs(V), x -> x in U ) then
            return V;
        fi;
    fi;

    # test if one the groups is known to be normal
    if IsNormal( V, U ) then
        return NormalIntersection( V, U );
    elif IsNormal( U, V ) then
        return NormalIntersection( V, U );
    fi;

    Error("sorry: intersection for non-normal groups not yet installed");
end );

