/*
** 1998-10-15 -	Config page for main window position and size. Neat.
** 2000-02-26 -	This file has been pretty much entierly rewritten, and renamed. It now
**		supports configuring position and size of not only the main window, but
**		also the config and textview windows. Pretty neat.
*/

#include "gentoo.h"

#include "guiutil.h"
#include "strutil.h"

#include "cfg_module.h"

#include "cfg_windows.h"

#define	NODE	"Windows"

/* ----------------------------------------------------------------------------------------- */

typedef struct {
	GtkWidget	*vbox;				/* Config page structures always begin like this. */
	GtkWidget	*content;			/* Content built for us by the window module. */

	MainInfo	*min;
	gboolean	modified;
	WinInfo		*edit;				/* Window info being edited. */
} P_Windows;

static P_Windows	the_page;

/* ----------------------------------------------------------------------------------------- */

static void populate_page(P_Windows *page)
{
	if(page->content)
		gtk_widget_destroy(page->content);
	page->content = win_wininfo_build(page->edit, &page->modified);
	gtk_box_pack_start(GTK_BOX(page->vbox), page->content, FALSE, FALSE, 0);
	gtk_widget_show_all(page->content);
}

/* ----------------------------------------------------------------------------------------- */

static GtkWidget * cwn_init(MainInfo *min, gchar **name)
{
	P_Windows	*page = &the_page;

	if(name == NULL)
		return NULL;

	*name = _("Windows");

	page->edit    = NULL;

	page->vbox    = gtk_vbox_new(FALSE, 0);
	page->content = NULL;

	gtk_widget_show_all(page->vbox);
	return page->vbox;
}

/* ----------------------------------------------------------------------------------------- */

/* 2000-01-30 -	Update possize display. */
static void cwn_update(MainInfo *min)
{
	P_Windows	*page = &the_page;

	page->min	= min;
	page->modified	= FALSE;

	if(page->edit != NULL)
		win_wininfo_destroy(page->edit);
	page->edit = win_wininfo_copy(min->cfg.wininfo);
	populate_page(page);
}

/* ----------------------------------------------------------------------------------------- */

static void cwn_accept(MainInfo *min)
{
	P_Windows	*page = &the_page;

	if(page->modified)
	{
		win_wininfo_destroy(min->cfg.wininfo);
		min->cfg.wininfo = page->edit;
		page->edit = NULL;
		page->modified = FALSE;
	}
}

/* ----------------------------------------------------------------------------------------- */

static gboolean cwn_save(MainInfo *min, FILE *out)
{
	win_wininfo_save(min->cfg.wininfo, out);

	return TRUE;
}

/* ----------------------------------------------------------------------------------------- */

static void cwn_load(MainInfo *min, XmlNode *node)
{
	win_wininfo_load(min->cfg.wininfo, node);
}

/* ----------------------------------------------------------------------------------------- */

/* 2000-02-26 -	When the config window hides, we can free our editing copy if we (still) have one. */
static void cwn_hide(MainInfo *min)
{
	P_Windows	*page = &the_page;

	if(page->edit != NULL)
	{
		win_wininfo_destroy(page->edit);
		page->edit = NULL;
	}
}

/* ----------------------------------------------------------------------------------------- */

CfgPage * cwn_describe(MainInfo *min)
{
	static CfgPage	desc = { NODE, cwn_init, cwn_update, cwn_accept, cwn_save, cwn_load, cwn_hide };

	return &desc;
}
