/*
** 1998-08-27 -	I've gotten pretty far without a native command for creating directories,
**		but now is the time. I want one!
** 1998-09-01 -	Added the possibility to enter the newly created directory, something I
**		find I want to do occasionally. Having it here saves one click. :^)
** 1999-03-13 -	Adjusted for new dialog module.
** 1999-04-04 -	Moved "CD New" flag out into min->cfg, making it behave a bit more like
**		the other commands and paving the way for saving this info in config file.
** 1999-06-19 -	Adapted for the new dialog module. Cleaner now.
*/

#include "gentoo.h"
#include "dialog.h"
#include "dirpane.h"
#include "errors.h"
#include "cmdseq.h"
#include "cmdseq_config.h"
#include "cfg_gui.h"

#include "cmd_mkdir.h"

#define	CMD_ID	"mkdir"

/* ----------------------------------------------------------------------------------------- */

typedef struct {
	GtkWidget	*vbox;
	GtkWidget	*entry;
	DirPane		*src;
} MkdInfo;

typedef struct {			/* Command-specific configuration data. */
	gboolean	modified;		/* Has the setting(s) been modified? */
	gboolean	cd_new;			/* CD into new directory after creation? */
} OptMkDir;

static OptMkDir	mkdir_options;
static CmdCfg	*mkdir_cmc = NULL;

/* ----------------------------------------------------------------------------------------- */

/* 1998-08-27 -	This gets called when user closes down the mkdir dialog. Create the
**		dir (and, optionally, enter it).
*/
static void make_dir(MkdInfo *mdi)
{
	gchar	buf[PATH_MAX];

	g_snprintf(buf, sizeof buf, "%s%c%s", mdi->src->dir.path, G_DIR_SEPARATOR, gtk_entry_get_text(GTK_ENTRY(mdi->entry)));
	if(mkdir(buf, -1) == 0)
	{
		if(mkdir_options.cd_new)
			csq_execute_format(mdi->src->main, "DirEnter 'dir=%s'", buf);
		else
			dp_rescan(mdi->src);
	}
	else
	{
		err_set(mdi->src->main, errno, CMD_ID, buf);
		err_show(mdi->src->main);
	}
	if(mkdir_options.modified)
		cfg_modified_set(mdi->src->main);
}

/* ----------------------------------------------------------------------------------------- */

/* 1998-08-27 -	The mkdir entry point. Simple stuff. */
int cmd_mkdir(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	Dialog		*dlg;
	MkdInfo		mi;
	GtkWidget	*wid;

	mi.src = src;
	mi.vbox = gtk_vbox_new(FALSE, 0);
	wid = gtk_label_new(_("Enter Name of Directory to Create"));
	gtk_box_pack_start(GTK_BOX(mi.vbox), wid, FALSE, FALSE, 0);
	gtk_widget_show(wid);
	mi.entry = gtk_entry_new_with_max_length(MAXNAMLEN - 1);
	gtk_box_pack_start(GTK_BOX(mi.vbox), mi.entry, FALSE, FALSE, 0);
	gtk_widget_show(mi.entry);
	wid = cmc_field_build(mkdir_cmc, "cd_new", &mkdir_options);
	gtk_box_pack_start(GTK_BOX(mi.vbox), wid, FALSE, FALSE, 0);
	gtk_widget_show(wid);
	gtk_widget_show(mi.vbox);
	dlg = dlg_dialog_sync_new(mi.vbox, _("Make Directory"), _("OK|Cancel"));
	gtk_widget_grab_focus(mi.entry);
	if(dlg_dialog_sync_wait(dlg) == DLG_POSITIVE)
		make_dir(&mi);
	dlg_dialog_sync_destroy(dlg);

	return 1;
}

/* ----------------------------------------------------------------------------------------- */

/* 1999-04-04 -	Support function for dynamic command configuration management (buzz, buzz). */
void cfg_mkdir(MainInfo *min)
{
	if(mkdir_cmc == NULL)
	{
		/* Initialize default option values. */
		mkdir_options.modified	= FALSE;
		mkdir_options.cd_new	= FALSE;

		mkdir_cmc = cmc_config_new("MkDir", &mkdir_options);
		cmc_field_add_boolean(mkdir_cmc, "modified", NULL, offsetof(OptMkDir, modified));
		cmc_field_add_boolean(mkdir_cmc, "cd_new", _("CD Into New Directory?"), offsetof(OptMkDir, cd_new));
		cmc_config_register(mkdir_cmc);
	}
}
