/*
** 1999-05-24 -	Broke this functionality out from the style configuration module since, er,
**		I felt like it. Rewrote it in the process, too. :) Uses the sligtly more
**		modern dialog module interface, thus returns directly the name of the icon
**		that was selected (or NULL if user cancels).
** 1999-06-19 -	Changes for the new dialog module.
*/

#include "gentoo.h"

#include "iconutil.h"
#include "guiutil.h"
#include "strutil.h"

#include "dialog.h"
#include "icon_dialog.h"

/* ----------------------------------------------------------------------------------------- */

/* 1999-05-24 -	User selected a row in the list. Copy the name. */
static void evt_clist_select_row(GtkWidget *clist, gint row, gint column, GdkEventButton *btn, gpointer user)
{
	gchar	*ptr = NULL;

	if((gtk_clist_get_text(GTK_CLIST(clist), row, 1, &ptr) > 0) && (ptr != NULL))
		stu_strncpy(user, ptr, FILENAME_MAX);
}

const gchar * idl_dialog_sync_new_wait(MainInfo *min, const gchar *path, const gchar *title, const gchar *current, gboolean show_progress)
{
	GList		*icons, *here;
	gboolean	terminate = FALSE;
	gchar		*rd[2] = { "", "" }, selected[FILENAME_MAX] = "";
	gpointer	progress = NULL;
	guint		position, length, selrow = 0, row;
	GtkWidget	*scwin, *clist;
	GdkPixmap	*ipix;
	GdkBitmap	*imsk;

	if(min == NULL)
		return NULL;

	if(title == NULL)
		title = _("Pick Icon");

	if((icons = ico_get_all(min, path)) == NULL)
		return NULL;

	length = g_list_length(icons);

	if(show_progress)
		progress = gui_progress_begin(_("Loading Icon Graphics..."), _("Cancel"));

	scwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scwin), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(scwin, 200, 320);
	clist = gtk_clist_new(2);
	gtk_clist_set_selection_mode(GTK_CLIST(clist), GTK_SELECTION_BROWSE);
	gtk_clist_set_column_width(GTK_CLIST(clist), 0, 16);
	gtk_clist_set_column_justification(GTK_CLIST(clist), 0, GTK_JUSTIFY_CENTER);
	gtk_clist_set_column_auto_resize(GTK_CLIST(clist), 0, TRUE);
	gtk_signal_connect(GTK_OBJECT(clist), "select_row", GTK_SIGNAL_FUNC(evt_clist_select_row), selected);
	gtk_container_add(GTK_CONTAINER(scwin), clist);
	gtk_widget_show(clist);

	for(here = icons, position = 0U; here != NULL; here = g_list_next(here), position++)
	{
		if(progress != NULL)
		{
			if((terminate = gui_progress_update(progress, (gfloat) position / length, (gchar *) here->data)))
				break;
			if(ico_no_icon(here->data))
				continue;
			if((ipix = ico_icon_get(min, here->data, &imsk)) != NULL)
			{
				rd[1] = here->data;
				row = gtk_clist_append(GTK_CLIST(clist), rd);
				gtk_clist_set_pixmap(GTK_CLIST(clist), row, 0, ipix, imsk);
				if((current != NULL) && (strcmp(current, here->data) == 0))
					selrow = row;
			}
		}
	}
	if(progress != NULL)
		gui_progress_end(progress);

	if(!terminate)
	{
		Dialog	*dlg;

		gtk_clist_select_row(GTK_CLIST(clist), selrow, -1);
/*		gtk_clist_moveto(GTK_CLIST(clist), selrow, -1, 0.5, 0.0);*/
		gtk_widget_show(scwin);
		dlg = dlg_dialog_sync_new(scwin, title, _("OK|Cancel"));
		if(dlg_dialog_sync_wait(dlg) != 0)
			terminate = TRUE;
		dlg_dialog_sync_destroy(dlg);
	}
	else
		gtk_widget_destroy(scwin);

	ico_free_all(icons);

	return terminate ? NULL : selected;
}
