/*
** 1998-08-02 -	Header file for the new string module.
** 2000-04-16 -	When <string.h> is included, all symbols starting with
**		"str" are reserved for the C implementation. This makes
**		my use of "str_" as a module-prefix for this module a
**		blatantly obvious conformance error. Fixed by changing
**		to "stu_" (for string utils, of course?).
*/

#include <sys/types.h>		/* For mode_t. */

#include <glib.h>		/* For the g-types. */

/* ----------------------------------------------------------------------------------------- */

gchar *		stu_strncpy(gchar *dst, const gchar *src, gssize n);
gchar *		stu_strncat(gchar *dst, const gchar *src, gssize n);
gchar *		stu_strntoupper(gchar *dst, const gchar *src, gssize n);

const gchar *	stu_strcasechr(const gchar *str, gchar c);
const gchar *	stu_strcaserchr(const gchar *str, gchar c);
gboolean	stu_has_suffix(const gchar *string, const char *suffix);

const gchar *	stu_glob_to_re(const gchar *glob);
void		stu_gstring_glob_to_re(GString *glob);

gchar *		stu_mode_to_text(gchar *buf, gsize buf_max, mode_t mode);

const gchar *	stu_scan_string(const gchar *def, char **str);

gint		stu_strcasecmp(const char *s, const char *r);
gint		stu_strcasencmp(const gchar *s, const gchar *t, gssize l);

const gchar *	stu_word_length(const gchar *str, gsize *len, gchar *store);
gchar **	stu_split_args(const char *argstring);
