/*
** 1998-07-25 -	The obligatory header file for the XML utility module. The module provides
**		a way of reading in an XML file (um, at least I think it's XML) into a tree,
**		and then do various operations on that tree. Useful for configuration data.
*/

#if !defined(XMLUTIL_H)
#define	XMLUTIL_H

/* This is one of gentoo's few opaque datatypes. */
typedef struct XmlNode	XmlNode;

/* ----------------------------------------------------------------------------------------- */

FILE *		xml_put_open(const gchar *name);
void		xml_put_close(FILE *out);
void		xml_put_node_open(FILE *out, const gchar *node);
void		xml_put_node_close(FILE *out, const gchar *node);

void		xml_put_integer(FILE *out, const gchar *name, gint value);
void		xml_put_uinteger(FILE *out, const gchar *name, guint value);
void		xml_put_real(FILE *out, const gchar *name, gfloat value);
void		xml_put_boolean(FILE *out, const gchar *name, gboolean value);
void		xml_put_text(FILE *out, const gchar *name, const gchar *value);
void		xml_put_color(FILE *out, const gchar *name, const GdkColor *color);

gboolean	xml_get_integer(XmlNode *node, const gchar *name, gint *n);
gboolean	xml_get_uinteger(XmlNode *node, const gchar *name, guint *n);
gboolean	xml_get_real(XmlNode *node, const gchar *name, gfloat *x);		/* ;^) */
gboolean	xml_get_boolean(XmlNode *node, const gchar *name, gboolean *x);
gboolean	xml_get_text(XmlNode *node, const gchar *name, gchar **str);
gboolean	xml_get_text_copy(XmlNode *node, const gchar *name, gchar *str, gsize max);
gboolean	xml_get_color(XmlNode *node, const gchar *name, GdkColor *col);

XmlNode *	xml_node_new(const gchar *name);
gint		xml_node_has_name(XmlNode *node, const gchar *name);
void		xml_node_add_child(XmlNode *node, XmlNode *child);
void		xml_node_visit_children(XmlNode *node, void (*func)(XmlNode *child, gpointer user_data), gpointer user_data);
void		xml_node_destroy(XmlNode *node);

XmlNode *	xml_tree_load(const gchar *name);
XmlNode *	xml_tree_search(XmlNode *root, const gchar *name);
void		xml_tree_destroy(XmlNode *node);

#endif		/* XMLUTIL_H */
