/*
	odlabel.c
*/

#include "odlabel.h"
#include <gtk/gtk.h>
#include <gdk/gdk.h>

static void	od_label_class_init		(ODLabelClass	*klass);
static void od_label_init			(ODLabel		*label);

/* the methods that are wrong in GtkLabel */
static void od_label_draw			(GtkWidget		*widget,
									 GdkRectangle	*area);

GtkLabelClass	*parent_class = NULL;

GtkType od_label_get_type (void) {
	static GtkType label_type = 0;
	
	if (!label_type) {
		static const GtkTypeInfo label_info = {
			"ODLabel",
			sizeof (ODLabel),
			sizeof (ODLabelClass),
			(GtkClassInitFunc) od_label_class_init,
			(GtkObjectInitFunc) od_label_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};
		label_type = gtk_type_unique (GTK_TYPE_LABEL, &label_info);
	}
	return label_type;
}

static void	od_label_class_init (ODLabelClass	*klass) {
	GtkWidgetClass	*widget_class;
	
	widget_class = GTK_WIDGET_CLASS(klass);
	widget_class->draw = od_label_draw;

	parent_class = gtk_type_class(GTK_TYPE_LABEL);
}

static void od_label_init (ODLabel *label) {
	/* do nothing */
}

GtkWidget * od_label_new (const gchar *str) {
	GtkLabel	*label;
	
	label = gtk_type_new (OD_TYPE_LABEL);
	if (str && *str)
		gtk_label_set_text (label, str);
	
	return GTK_WIDGET (label);
}

/* copied from gtk_widget_real_draw(), with the addition of a clear */
static void
od_label_draw (GtkWidget	*widget,
			   GdkRectangle	*area)
{
	GdkEventExpose event;
	
	g_return_if_fail (widget != NULL);
	g_return_if_fail (GTK_IS_WIDGET (widget));
	g_return_if_fail (area != NULL);
	
	if (GTK_WIDGET_DRAWABLE (widget)) {
		gdk_window_clear_area (widget->window, area->x, area->y, area->width, area->height);

		if (GTK_WIDGET_CLASS(parent_class)->draw)
			GTK_WIDGET_CLASS(parent_class)->draw(widget, area);
	}
}

