/* Copyright (C) 2002 Pascal Haakmat */

#ifndef BLOCK_H
#define BLOCK_H

#include <audiofile.h>
#include "config.h"
#include "cache.h"

typedef struct _block {
    cache_type type;
    int ref;
    AFframecount frame_count;
    int frame_width;
    float graph_hres;
    cache *frame_cache;
    cache *graph_cache;
} block;

block *
block_resize(block *block,
             AFframecount frame_count);

void
block_move(block *block,
           AFframecount new_frame_offset,
           AFframecount old_frame_offset,
           AFframecount frame_count);

void
block_addref(block *block);

void 
block_unref(block *block);

block *
block_new(cache_type type,
          int frame_width,
          float graph_hres,
          AFframecount frame_count);

block *
block_clone(block *block,
            AFframecount frame_offset,
            AFframecount frame_count);

block *
block_split(block *block,
            AFframecount frame_offset);

block *
block_join(block *b1,
           block *b2);

#endif /* ! BLOCK_H */
