#ifndef BLOCKLIST_H
#define BLOCKLIST_H

#include <glib.h>
#include "config.h"
#include "audiofile.h"

struct bcache {
    AFframecount frame_offset;
    GList *block;
    short is_valid;
    short hits;
};

struct blocklist {
    AFframecount frame_count;
    GList *l;
    struct bcache bc[MAX_BCACHE_ENTRIES];
};

struct blocklist *
blocklist_new(GList *l);

void
blocklist_destroy(struct blocklist *bl);

struct blocklist *
blocklist_clone(struct blocklist *bl);

AFframecount
blocklist_frame_count(struct blocklist *bl);

int
blocklist_block_find(struct blocklist *bl,
                     AFframecount *frame_offset,
                     GList **block);

GList *
blocklist_delete(struct blocklist *bl,
                 AFframecount frame_offset,
                 AFframecount frame_count);

int
blocklist_buffer_insert(struct blocklist *bl,
                        _frame_bits frame_bits,
                        int frame_width,
                        AFframecount frame_offset,
                        AFframecount frame_count);

int
blocklist_blocks_insert(struct blocklist *bl,
                        GList *l,
                        AFframecount frame_offset);

void
blocklist_blocks_destroy(GList *l);

void
blocklist_blocks_set(struct blocklist *bl, GList *l);

void
blocklist_dump(struct blocklist *bl);

#endif /* ! BLOCKLIST_H */
