/*
 * Copyright (C) 2002 Pascal Haakmat.
 */

#include "config.h"
#include <stdlib.h>

#define SAFETY_BUFFER_SIZE 100 * 1024

void *mem_safety_buffer = NULL;
int mem_fail_allocation_on_zero = 0;

int
mem_init() {
    mem_safety_buffer = malloc(SAFETY_BUFFER_SIZE);
    if(!mem_safety_buffer)
        return 1;
    return 0;
}

void
mem_exit() {
    if(mem_safety_buffer)
        free(mem_safety_buffer);
}

void *
mem_alloc(size_t sz) {
    void *ptr;

    if(mem_fail_allocation_on_zero > 0)
        if(!(--mem_fail_allocation_on_zero))
            return NULL;

    ptr = malloc(sz);

    if(!ptr) {
        FAIL("alloc of %d bytes failed\n", sz);
        if(mem_safety_buffer) {
            free(mem_safety_buffer);
            FAIL("freed safety buffer\n");
            mem_safety_buffer = NULL;
        } else {
            FAIL("safety buffer already freed!\n");
        }
        return NULL;
    }
    return ptr;
}

void *
mem_realloc(void *old_ptr, 
            size_t sz) {
    void *ptr;
    
    if(mem_fail_allocation_on_zero > 0)
        if(!(--mem_fail_allocation_on_zero))
            return NULL;

    ptr = realloc(old_ptr, sz);

    if(!ptr) {
        FAIL("realloc of %d bytes failed\n", sz);
        if(mem_safety_buffer) {
            free(mem_safety_buffer);
            FAIL("freed safety buffer\n");
            mem_safety_buffer = NULL;
        } else {
            FAIL("safety buffer already freed!\n");
        }
        return NULL;
    }
    return ptr;
}


void *
mem_calloc(size_t nmemb,
           size_t sz) {
    void *ptr;
 
    if(mem_fail_allocation_on_zero > 0)
        if(!(--mem_fail_allocation_on_zero))
            return NULL;

    ptr = calloc(nmemb, sz);

    if(!ptr) {
        FAIL("calloc of %d bytes failed\n", nmemb * sz);
        if(mem_safety_buffer) {
            free(mem_safety_buffer);
            FAIL("freed safety buffer\n");
            mem_safety_buffer = NULL;
        } else {
            FAIL("safety buffer already freed!\n");
        }
        return NULL;
    }
    return ptr;
}


void
mem_free(void *ptr) {
    free(ptr);
}
